
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/assets/CCRawAsset.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var CCObject = require('../platform/CCObject');

var js = require('../platform/js');
/**
 * !#en
 * The base class for registering asset types.
 * !#zh
 * 注册用的资源基类。
 *
 * @class RawAsset
 * @extends Object
 */


cc.RawAsset = cc.Class({
  name: 'cc.RawAsset',
  "extends": CCObject,
  ctor: function ctor() {
    /**
     * @property _uuid
     * @type {String}
     * @private
     */
    Object.defineProperty(this, '_uuid', {
      value: '',
      writable: true // enumerable is false by default, to avoid uuid being assigned to empty string during destroy

    });
  }
});
/**
 * @method isRawAssetType
 * @param {Function} ctor
 * @returns {Boolean}
 * @static
 * @private
 */

js.value(cc.RawAsset, 'isRawAssetType', function (ctor) {
  return js.isChildClassOf(ctor, cc.RawAsset) && !js.isChildClassOf(ctor, cc.Asset);
}); // TODO - DELME after 2.1

js.value(cc.RawAsset, 'wasRawAssetType', function (ctor) {
  return ctor === cc.Texture2D || ctor === cc.AudioClip || ctor === cc.ParticleAsset || ctor === cc.Asset; // since 1.10, all raw asset will import as cc.Asset
});
module.exports = cc.RawAsset;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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