
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/assets/CCAudioClip.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var Asset = require('./CCAsset');

var EventTarget = require('../event/event-target');

var LoadMode = cc.Enum({
  WEB_AUDIO: 0,
  DOM_AUDIO: 1
});
/**
 * !#en Class for audio data handling.
 * !#zh 音频资源类。
 * @class AudioClip
 * @extends Asset
 * @uses EventTarget
 */

var AudioClip = cc.Class({
  name: 'cc.AudioClip',
  "extends": Asset,
  mixins: [EventTarget],
  ctor: function ctor() {
    this.loaded = false; // the web audio buffer or <audio> element

    this._audio = null;
  },
  properties: {
    loadMode: {
      "default": LoadMode.WEB_AUDIO,
      type: LoadMode
    },
    _nativeAsset: {
      get: function get() {
        return this._audio;
      },
      set: function set(value) {
        // HACK: fix load mp3 as audioClip, _nativeAsset is set as audioClip.
        // Should load mp3 as audioBuffer indeed.
        if (value instanceof cc.AudioClip) {
          this._audio = value._nativeAsset;
        } else {
          this._audio = value;
        }

        if (this._audio) {
          this.loaded = true;
          this.emit('load');
        }
      },
      override: true
    }
  },
  statics: {
    LoadMode: LoadMode,
    _loadByUrl: function _loadByUrl(url, callback) {
      var item = cc.loader.getItem(url) || cc.loader.getItem(url + '?useDom=1');

      if (!item || !item.complete) {
        cc.loader.load(url, function (error, downloadUrl) {
          if (error) {
            return callback(error);
          }

          item = cc.loader.getItem(url) || cc.loader.getItem(url + '?useDom=1');
          callback(null, item.content);
        });
      } else {
        if (item._owner instanceof AudioClip) {
          // preloaded and retained by audio clip
          callback(null, item._owner);
        } else {
          callback(null, item.content);
        }
      }
    }
  },
  destroy: function destroy() {
    cc.audioEngine.uncache(this);

    this._super();
  }
});
/**
 * !#zh
 * 当该资源加载成功后触发该事件
 * !#en
 * This event is emitted when the asset is loaded
 *
 * @event load
 */

cc.AudioClip = AudioClip;
module.exports = AudioClip;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvY29jb3MyZC9jb3JlL2Fzc2V0cy9DQ0F1ZGlvQ2xpcC5qcyJdLCJuYW1lcyI6WyJBc3NldCIsInJlcXVpcmUiLCJFdmVudFRhcmdldCIsIkxvYWRNb2RlIiwiY2MiLCJFbnVtIiwiV0VCX0FVRElPIiwiRE9NX0FVRElPIiwiQXVkaW9DbGlwIiwiQ2xhc3MiLCJuYW1lIiwibWl4aW5zIiwiY3RvciIsImxvYWRlZCIsIl9hdWRpbyIsInByb3BlcnRpZXMiLCJsb2FkTW9kZSIsInR5cGUiLCJfbmF0aXZlQXNzZXQiLCJnZXQiLCJzZXQiLCJ2YWx1ZSIsImVtaXQiLCJvdmVycmlkZSIsInN0YXRpY3MiLCJfbG9hZEJ5VXJsIiwidXJsIiwiY2FsbGJhY2siLCJpdGVtIiwibG9hZGVyIiwiZ2V0SXRlbSIsImNvbXBsZXRlIiwibG9hZCIsImVycm9yIiwiZG93bmxvYWRVcmwiLCJjb250ZW50IiwiX293bmVyIiwiZGVzdHJveSIsImF1ZGlvRW5naW5lIiwidW5jYWNoZSIsIl9zdXBlciIsIm1vZHVsZSIsImV4cG9ydHMiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7QUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQTBCQSxJQUFNQSxLQUFLLEdBQUdDLE9BQU8sQ0FBQyxXQUFELENBQXJCOztBQUNBLElBQU1DLFdBQVcsR0FBR0QsT0FBTyxDQUFDLHVCQUFELENBQTNCOztBQUVBLElBQUlFLFFBQVEsR0FBR0MsRUFBRSxDQUFDQyxJQUFILENBQVE7QUFDbkJDLEVBQUFBLFNBQVMsRUFBRSxDQURRO0FBRW5CQyxFQUFBQSxTQUFTLEVBQUU7QUFGUSxDQUFSLENBQWY7QUFLQTs7Ozs7Ozs7QUFPQSxJQUFJQyxTQUFTLEdBQUdKLEVBQUUsQ0FBQ0ssS0FBSCxDQUFTO0FBQ3JCQyxFQUFBQSxJQUFJLEVBQUUsY0FEZTtBQUVyQixhQUFTVixLQUZZO0FBR3JCVyxFQUFBQSxNQUFNLEVBQUUsQ0FBQ1QsV0FBRCxDQUhhO0FBS3JCVSxFQUFBQSxJQUxxQixrQkFLYjtBQUNKLFNBQUtDLE1BQUwsR0FBYyxLQUFkLENBREksQ0FHSjs7QUFDQSxTQUFLQyxNQUFMLEdBQWMsSUFBZDtBQUNILEdBVm9CO0FBWXJCQyxFQUFBQSxVQUFVLEVBQUU7QUFDUkMsSUFBQUEsUUFBUSxFQUFFO0FBQ04saUJBQVNiLFFBQVEsQ0FBQ0csU0FEWjtBQUVOVyxNQUFBQSxJQUFJLEVBQUVkO0FBRkEsS0FERjtBQUtSZSxJQUFBQSxZQUFZLEVBQUU7QUFDVkMsTUFBQUEsR0FEVSxpQkFDSDtBQUNILGVBQU8sS0FBS0wsTUFBWjtBQUNILE9BSFM7QUFJVk0sTUFBQUEsR0FKVSxlQUlMQyxLQUpLLEVBSUU7QUFDUjtBQUNBO0FBQ0EsWUFBSUEsS0FBSyxZQUFZakIsRUFBRSxDQUFDSSxTQUF4QixFQUFtQztBQUMvQixlQUFLTSxNQUFMLEdBQWNPLEtBQUssQ0FBQ0gsWUFBcEI7QUFDSCxTQUZELE1BR0s7QUFDRCxlQUFLSixNQUFMLEdBQWNPLEtBQWQ7QUFDSDs7QUFDRCxZQUFJLEtBQUtQLE1BQVQsRUFBaUI7QUFDYixlQUFLRCxNQUFMLEdBQWMsSUFBZDtBQUNBLGVBQUtTLElBQUwsQ0FBVSxNQUFWO0FBQ0g7QUFDSixPQWpCUztBQWtCVkMsTUFBQUEsUUFBUSxFQUFFO0FBbEJBO0FBTE4sR0FaUztBQXVDckJDLEVBQUFBLE9BQU8sRUFBRTtBQUNMckIsSUFBQUEsUUFBUSxFQUFFQSxRQURMO0FBRUxzQixJQUFBQSxVQUFVLEVBQUUsb0JBQVVDLEdBQVYsRUFBZUMsUUFBZixFQUF5QjtBQUNqQyxVQUFJQyxJQUFJLEdBQUd4QixFQUFFLENBQUN5QixNQUFILENBQVVDLE9BQVYsQ0FBa0JKLEdBQWxCLEtBQTBCdEIsRUFBRSxDQUFDeUIsTUFBSCxDQUFVQyxPQUFWLENBQWtCSixHQUFHLEdBQUcsV0FBeEIsQ0FBckM7O0FBQ0EsVUFBSSxDQUFDRSxJQUFELElBQVMsQ0FBQ0EsSUFBSSxDQUFDRyxRQUFuQixFQUE2QjtBQUN6QjNCLFFBQUFBLEVBQUUsQ0FBQ3lCLE1BQUgsQ0FBVUcsSUFBVixDQUFlTixHQUFmLEVBQW9CLFVBQVVPLEtBQVYsRUFBaUJDLFdBQWpCLEVBQThCO0FBQzlDLGNBQUlELEtBQUosRUFBVztBQUNQLG1CQUFPTixRQUFRLENBQUNNLEtBQUQsQ0FBZjtBQUNIOztBQUNETCxVQUFBQSxJQUFJLEdBQUd4QixFQUFFLENBQUN5QixNQUFILENBQVVDLE9BQVYsQ0FBa0JKLEdBQWxCLEtBQTBCdEIsRUFBRSxDQUFDeUIsTUFBSCxDQUFVQyxPQUFWLENBQWtCSixHQUFHLEdBQUcsV0FBeEIsQ0FBakM7QUFDQUMsVUFBQUEsUUFBUSxDQUFDLElBQUQsRUFBT0MsSUFBSSxDQUFDTyxPQUFaLENBQVI7QUFDSCxTQU5EO0FBT0gsT0FSRCxNQVNLO0FBQ0QsWUFBSVAsSUFBSSxDQUFDUSxNQUFMLFlBQXVCNUIsU0FBM0IsRUFBc0M7QUFDbEM7QUFDQW1CLFVBQUFBLFFBQVEsQ0FBQyxJQUFELEVBQU9DLElBQUksQ0FBQ1EsTUFBWixDQUFSO0FBQ0gsU0FIRCxNQUlLO0FBQ0RULFVBQUFBLFFBQVEsQ0FBQyxJQUFELEVBQU9DLElBQUksQ0FBQ08sT0FBWixDQUFSO0FBQ0g7QUFDSjtBQUNKO0FBdEJJLEdBdkNZO0FBZ0VyQkUsRUFBQUEsT0FoRXFCLHFCQWdFVjtBQUNQakMsSUFBQUEsRUFBRSxDQUFDa0MsV0FBSCxDQUFlQyxPQUFmLENBQXVCLElBQXZCOztBQUNBLFNBQUtDLE1BQUw7QUFDSDtBQW5Fb0IsQ0FBVCxDQUFoQjtBQXNFQTs7Ozs7Ozs7O0FBU0FwQyxFQUFFLENBQUNJLFNBQUgsR0FBZUEsU0FBZjtBQUNBaUMsTUFBTSxDQUFDQyxPQUFQLEdBQWlCbEMsU0FBakIiLCJzb3VyY2VzQ29udGVudCI6WyIvKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKlxuIENvcHlyaWdodCAoYykgMjAxMy0yMDE2IENodWtvbmcgVGVjaG5vbG9naWVzIEluYy5cbiBDb3B5cmlnaHQgKGMpIDIwMTctMjAxOCBYaWFtZW4gWWFqaSBTb2Z0d2FyZSBDby4sIEx0ZC5cblxuIGh0dHBzOi8vd3d3LmNvY29zLmNvbS9cblxuIFBlcm1pc3Npb24gaXMgaGVyZWJ5IGdyYW50ZWQsIGZyZWUgb2YgY2hhcmdlLCB0byBhbnkgcGVyc29uIG9idGFpbmluZyBhIGNvcHlcbiBvZiB0aGlzIHNvZnR3YXJlIGFuZCBhc3NvY2lhdGVkIGVuZ2luZSBzb3VyY2UgY29kZSAodGhlIFwiU29mdHdhcmVcIiksIGEgbGltaXRlZCxcbiAgd29ybGR3aWRlLCByb3lhbHR5LWZyZWUsIG5vbi1hc3NpZ25hYmxlLCByZXZvY2FibGUgYW5kIG5vbi1leGNsdXNpdmUgbGljZW5zZVxuIHRvIHVzZSBDb2NvcyBDcmVhdG9yIHNvbGVseSB0byBkZXZlbG9wIGdhbWVzIG9uIHlvdXIgdGFyZ2V0IHBsYXRmb3Jtcy4gWW91IHNoYWxsXG4gIG5vdCB1c2UgQ29jb3MgQ3JlYXRvciBzb2Z0d2FyZSBmb3IgZGV2ZWxvcGluZyBvdGhlciBzb2Z0d2FyZSBvciB0b29scyB0aGF0J3NcbiAgdXNlZCBmb3IgZGV2ZWxvcGluZyBnYW1lcy4gWW91IGFyZSBub3QgZ3JhbnRlZCB0byBwdWJsaXNoLCBkaXN0cmlidXRlLFxuICBzdWJsaWNlbnNlLCBhbmQvb3Igc2VsbCBjb3BpZXMgb2YgQ29jb3MgQ3JlYXRvci5cblxuIFRoZSBzb2Z0d2FyZSBvciB0b29scyBpbiB0aGlzIExpY2Vuc2UgQWdyZWVtZW50IGFyZSBsaWNlbnNlZCwgbm90IHNvbGQuXG4gWGlhbWVuIFlhamkgU29mdHdhcmUgQ28uLCBMdGQuIHJlc2VydmVzIGFsbCByaWdodHMgbm90IGV4cHJlc3NseSBncmFudGVkIHRvIHlvdS5cblxuIFRIRSBTT0ZUV0FSRSBJUyBQUk9WSURFRCBcIkFTIElTXCIsIFdJVEhPVVQgV0FSUkFOVFkgT0YgQU5ZIEtJTkQsIEVYUFJFU1MgT1JcbiBJTVBMSUVELCBJTkNMVURJTkcgQlVUIE5PVCBMSU1JVEVEIFRPIFRIRSBXQVJSQU5USUVTIE9GIE1FUkNIQU5UQUJJTElUWSxcbiBGSVRORVNTIEZPUiBBIFBBUlRJQ1VMQVIgUFVSUE9TRSBBTkQgTk9OSU5GUklOR0VNRU5ULiBJTiBOTyBFVkVOVCBTSEFMTCBUSEVcbiBBVVRIT1JTIE9SIENPUFlSSUdIVCBIT0xERVJTIEJFIExJQUJMRSBGT1IgQU5ZIENMQUlNLCBEQU1BR0VTIE9SIE9USEVSXG4gTElBQklMSVRZLCBXSEVUSEVSIElOIEFOIEFDVElPTiBPRiBDT05UUkFDVCwgVE9SVCBPUiBPVEhFUldJU0UsIEFSSVNJTkcgRlJPTSxcbiBPVVQgT0YgT1IgSU4gQ09OTkVDVElPTiBXSVRIIFRIRSBTT0ZUV0FSRSBPUiBUSEUgVVNFIE9SIE9USEVSIERFQUxJTkdTIElOXG4gVEhFIFNPRlRXQVJFLlxuICoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKiovXG5cbmNvbnN0IEFzc2V0ID0gcmVxdWlyZSgnLi9DQ0Fzc2V0Jyk7XG5jb25zdCBFdmVudFRhcmdldCA9IHJlcXVpcmUoJy4uL2V2ZW50L2V2ZW50LXRhcmdldCcpO1xuXG52YXIgTG9hZE1vZGUgPSBjYy5FbnVtKHtcbiAgICBXRUJfQVVESU86IDAsXG4gICAgRE9NX0FVRElPOiAxLFxufSk7XG5cbi8qKlxuICogISNlbiBDbGFzcyBmb3IgYXVkaW8gZGF0YSBoYW5kbGluZy5cbiAqICEjemgg6Z+z6aKR6LWE5rqQ57G744CCXG4gKiBAY2xhc3MgQXVkaW9DbGlwXG4gKiBAZXh0ZW5kcyBBc3NldFxuICogQHVzZXMgRXZlbnRUYXJnZXRcbiAqL1xudmFyIEF1ZGlvQ2xpcCA9IGNjLkNsYXNzKHtcbiAgICBuYW1lOiAnY2MuQXVkaW9DbGlwJyxcbiAgICBleHRlbmRzOiBBc3NldCxcbiAgICBtaXhpbnM6IFtFdmVudFRhcmdldF0sXG5cbiAgICBjdG9yICgpIHtcbiAgICAgICAgdGhpcy5sb2FkZWQgPSBmYWxzZTtcblxuICAgICAgICAvLyB0aGUgd2ViIGF1ZGlvIGJ1ZmZlciBvciA8YXVkaW8+IGVsZW1lbnRcbiAgICAgICAgdGhpcy5fYXVkaW8gPSBudWxsO1xuICAgIH0sXG5cbiAgICBwcm9wZXJ0aWVzOiB7XG4gICAgICAgIGxvYWRNb2RlOiB7XG4gICAgICAgICAgICBkZWZhdWx0OiBMb2FkTW9kZS5XRUJfQVVESU8sXG4gICAgICAgICAgICB0eXBlOiBMb2FkTW9kZVxuICAgICAgICB9LFxuICAgICAgICBfbmF0aXZlQXNzZXQ6IHtcbiAgICAgICAgICAgIGdldCAoKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIHRoaXMuX2F1ZGlvO1xuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIHNldCAodmFsdWUpIHtcbiAgICAgICAgICAgICAgICAvLyBIQUNLOiBmaXggbG9hZCBtcDMgYXMgYXVkaW9DbGlwLCBfbmF0aXZlQXNzZXQgaXMgc2V0IGFzIGF1ZGlvQ2xpcC5cbiAgICAgICAgICAgICAgICAvLyBTaG91bGQgbG9hZCBtcDMgYXMgYXVkaW9CdWZmZXIgaW5kZWVkLlxuICAgICAgICAgICAgICAgIGlmICh2YWx1ZSBpbnN0YW5jZW9mIGNjLkF1ZGlvQ2xpcCkge1xuICAgICAgICAgICAgICAgICAgICB0aGlzLl9hdWRpbyA9IHZhbHVlLl9uYXRpdmVBc3NldDtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMuX2F1ZGlvID0gdmFsdWU7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIGlmICh0aGlzLl9hdWRpbykge1xuICAgICAgICAgICAgICAgICAgICB0aGlzLmxvYWRlZCA9IHRydWU7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMuZW1pdCgnbG9hZCcpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBvdmVycmlkZTogdHJ1ZVxuICAgICAgICB9XG4gICAgfSxcblxuICAgIHN0YXRpY3M6IHtcbiAgICAgICAgTG9hZE1vZGU6IExvYWRNb2RlLFxuICAgICAgICBfbG9hZEJ5VXJsOiBmdW5jdGlvbiAodXJsLCBjYWxsYmFjaykge1xuICAgICAgICAgICAgdmFyIGl0ZW0gPSBjYy5sb2FkZXIuZ2V0SXRlbSh1cmwpIHx8IGNjLmxvYWRlci5nZXRJdGVtKHVybCArICc/dXNlRG9tPTEnKTtcbiAgICAgICAgICAgIGlmICghaXRlbSB8fCAhaXRlbS5jb21wbGV0ZSkge1xuICAgICAgICAgICAgICAgIGNjLmxvYWRlci5sb2FkKHVybCwgZnVuY3Rpb24gKGVycm9yLCBkb3dubG9hZFVybCkge1xuICAgICAgICAgICAgICAgICAgICBpZiAoZXJyb3IpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBjYWxsYmFjayhlcnJvcik7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgaXRlbSA9IGNjLmxvYWRlci5nZXRJdGVtKHVybCkgfHwgY2MubG9hZGVyLmdldEl0ZW0odXJsICsgJz91c2VEb209MScpO1xuICAgICAgICAgICAgICAgICAgICBjYWxsYmFjayhudWxsLCBpdGVtLmNvbnRlbnQpO1xuICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICAgICAgaWYgKGl0ZW0uX293bmVyIGluc3RhbmNlb2YgQXVkaW9DbGlwKSB7XG4gICAgICAgICAgICAgICAgICAgIC8vIHByZWxvYWRlZCBhbmQgcmV0YWluZWQgYnkgYXVkaW8gY2xpcFxuICAgICAgICAgICAgICAgICAgICBjYWxsYmFjayhudWxsLCBpdGVtLl9vd25lcik7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICBjYWxsYmFjayhudWxsLCBpdGVtLmNvbnRlbnQpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgIH0sXG5cbiAgICBkZXN0cm95ICgpIHtcbiAgICAgICAgY2MuYXVkaW9FbmdpbmUudW5jYWNoZSh0aGlzKTtcbiAgICAgICAgdGhpcy5fc3VwZXIoKTtcbiAgICB9XG59KTtcblxuLyoqXG4gKiAhI3poXG4gKiDlvZPor6XotYTmupDliqDovb3miJDlip/lkI7op6blj5Hor6Xkuovku7ZcbiAqICEjZW5cbiAqIFRoaXMgZXZlbnQgaXMgZW1pdHRlZCB3aGVuIHRoZSBhc3NldCBpcyBsb2FkZWRcbiAqXG4gKiBAZXZlbnQgbG9hZFxuICovXG5cbmNjLkF1ZGlvQ2xpcCA9IEF1ZGlvQ2xpcDtcbm1vZHVsZS5leHBvcnRzID0gQXVkaW9DbGlwO1xuIl0sInNvdXJjZVJvb3QiOiIvIn0=