
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/assets/CCAsset.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var RawAsset = require('./CCRawAsset');
/**
 * !#en
 * Base class for handling assets used in Creator.<br/>
 *
 * You may want to override:<br/>
 * - createNode<br/>
 * - getset functions of _nativeAsset<br/>
 * - cc.Object._serialize<br/>
 * - cc.Object._deserialize<br/>
 * !#zh
 * Creator 中的资源基类。<br/>
 *
 * 您可能需要重写：<br/>
 * - createNode <br/>
 * - _nativeAsset 的 getset 方法<br/>
 * - cc.Object._serialize<br/>
 * - cc.Object._deserialize<br/>
 *
 * @class Asset
 * @extends RawAsset
 */


cc.Asset = cc.Class({
  name: 'cc.Asset',
  "extends": RawAsset,
  ctor: function ctor() {
    /**
     * !#en
     * Whether the asset is loaded or not
     * !#zh
     * 该资源是否已经成功加载
     *
     * @property loaded
     * @type {Boolean}
     */
    this.loaded = true;
    /**
     * !#en
     * Points to the true url of this asset's native object, only valid when asset is loaded and asyncLoadAsset is not enabled.
     * The difference between nativeUrl and url is that the latter is final path, there is no needs to transform url by md5 and subpackage. 
     * Besides, url may points to temporary path or cached path on mini game platform which has cache mechanism (WeChat etc).
     * If you want to make use of the native file on those platforms, you should use url instead of nativeUrl.
     * 
     * !#zh
     * 资源的原生文件的真实url，只在资源被加载后以及没有启用延迟加载时才有效。 nativeUrl 与 url 的区别在于，url 是资源最终路径，所以 url 不需要再经过 md5 以及子包的路径转换，
     * 另外某些带缓存机制的小游戏平台（微信等）上url可能会指向临时文件路径或者缓存路径，如果你需要在这些平台上使用资源的原生文件，请使用url，避免使用nativeUrl
     * @property url
     * @type {String}
     */

    this.url = '';
  },
  properties: {
    /**
     * !#en
     * Returns the url of this asset's native object, if none it will returns an empty string.
     * !#zh
     * 返回该资源对应的目标平台资源的 URL，如果没有将返回一个空字符串。
     * @property nativeUrl
     * @type {String}
     * @readOnly
     */
    nativeUrl: {
      get: function get() {
        if (this._native) {
          var name = this._native;

          if (name.charCodeAt(0) === 47) {
            // '/'
            // remove library tag
            // not imported in library, just created on-the-fly
            return name.slice(1);
          }

          if (cc.AssetLibrary) {
            var base = cc.AssetLibrary.getLibUrlNoExt(this._uuid, true);

            if (name.charCodeAt(0) === 46) {
              // '.'
              // imported in dir where json exist
              return base + name;
            } else {
              // imported in an independent dir
              return base + '/' + name;
            }
          } else {
            cc.errorID(6400);
          }
        }

        return '';
      },
      visible: false
    },

    /**
     * Serializable url for native asset.
     * @property {String} _native
     * @default undefined
     * @private
     */
    _native: "",

    /**
     * The underlying native asset of this asset if one is available.
     * This property can be used to access additional details or functionality releated to the asset.
     * This property will be initialized by the loader if `_native` is available.
     * @property {Object} _nativeAsset
     * @default null
     * @private
     */
    _nativeAsset: {
      get: function get() {
        return this._$nativeAsset;
      },
      set: function set(obj) {
        this._$nativeAsset = obj;
      }
    }
  },
  statics: {
    /**
     * 应 AssetDB 要求提供这个方法
     *
     * @method deserialize
     * @param {String} data
     * @return {Asset}
     * @static
     * @private
     */
    deserialize: CC_EDITOR && function (data) {
      return cc.deserialize(data);
    },

    /**
     * !#en Indicates whether its dependent raw assets can support deferred load if the owner scene (or prefab) is marked as `asyncLoadAssets`.
     * !#zh 当场景或 Prefab 被标记为 `asyncLoadAssets`，禁止延迟加载该资源所依赖的其它 RawAsset。
     *
     * @property {Boolean} preventDeferredLoadDependents
     * @default false
     * @static
     */
    preventDeferredLoadDependents: false,

    /**
     * !#en Indicates whether its native object should be preloaded from native url.
     * !#zh 禁止预加载原生对象。
     *
     * @property {Boolean} preventPreloadNativeObject
     * @default false
     * @static
     */
    preventPreloadNativeObject: false
  },

  /**
   * Returns the asset's url.
   *
   * The `Asset` object overrides the `toString()` method of the `Object` object.
   * For `Asset` objects, the toString() method returns a string representation of the object.
   * JavaScript calls the toString() method automatically when an asset is to be represented as a text value or when a texture is referred to in a string concatenation.
   *
   * @method toString
   * @return {String}
   */
  toString: function toString() {
    return this.nativeUrl;
  },

  /**
   * 应 AssetDB 要求提供这个方法
   *
   * @method serialize
   * @return {String}
   * @private
   */
  serialize: CC_EDITOR && function () {
    return Editor.serialize(this);
  },

  /**
   * !#en
   * Create a new node using this asset in the scene.<br/>
   * If this type of asset dont have its corresponding node type, this method should be null.
   * !#zh
   * 使用该资源在场景中创建一个新节点。<br/>
   * 如果这类资源没有相应的节点类型，该方法应该是空的。
   *
   * @method createNode
   * @param {Function} callback
   * @param {String} callback.error - null or the error info
   * @param {Object} callback.node - the created node or null
   */
  createNode: null,

  /**
   * Set native file name for this asset.
   * @seealso nativeUrl
   *
   * @method _setRawAsset
   * @param {String} filename
   * @param {Boolean} [inLibrary=true]
   * @private
   */
  _setRawAsset: function _setRawAsset(filename, inLibrary) {
    if (inLibrary !== false) {
      this._native = filename || undefined;
    } else {
      this._native = '/' + filename; // simply use '/' to tag location where is not in the library
    }
  }
});
module.exports = cc.Asset;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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