
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/CCNode.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
'use strict';

var _valueTypes = require("./value-types");

var BaseNode = require('./utils/base-node');

var PrefabHelper = require('./utils/prefab-helper');

var nodeMemPool = require('./utils/trans-pool').NodeMemPool;

var AffineTrans = require('./utils/affine-transform');

var eventManager = require('./event-manager');

var macro = require('./platform/CCMacro');

var js = require('./platform/js');

var Event = require('./event/event');

var EventTarget = require('./event/event-target');

var RenderFlow = require('./renderer/render-flow');

var Flags = cc.Object.Flags;
var Destroying = Flags.Destroying;
var ERR_INVALID_NUMBER = CC_EDITOR && 'The %s is invalid';
var ONE_DEGREE = Math.PI / 180;
var ActionManagerExist = !!cc.ActionManager;

var emptyFunc = function emptyFunc() {}; // getWorldPosition temp var


var _gwpVec3 = new _valueTypes.Vec3();

var _gwpQuat = new _valueTypes.Quat(); // _invTransformPoint temp var


var _tpVec3a = new _valueTypes.Vec3();

var _tpVec3b = new _valueTypes.Vec3();

var _tpQuata = new _valueTypes.Quat();

var _tpQuatb = new _valueTypes.Quat(); // setWorldPosition temp var


var _swpVec3 = new _valueTypes.Vec3(); // getWorldScale temp var


var _gwsVec3 = new _valueTypes.Vec3(); // setWorldScale temp var


var _swsVec3 = new _valueTypes.Vec3(); // getWorldRT temp var


var _gwrtVec3a = new _valueTypes.Vec3();

var _gwrtVec3b = new _valueTypes.Vec3();

var _gwrtQuata = new _valueTypes.Quat();

var _gwrtQuatb = new _valueTypes.Quat(); // lookAt temp var


var _laVec3 = new _valueTypes.Vec3();

var _laQuat = new _valueTypes.Quat(); //up、right、forward temp var


var _urfVec3 = new _valueTypes.Vec3();

var _urfQuat = new _valueTypes.Quat(); // _hitTest temp var


var _htVec3a = new _valueTypes.Vec3();

var _htVec3b = new _valueTypes.Vec3(); // getWorldRotation temp var


var _gwrQuat = new _valueTypes.Quat(); // setWorldRotation temp var


var _swrQuat = new _valueTypes.Quat();

var _quata = new _valueTypes.Quat();

var _mat4_temp = cc.mat4();

var _vec3_temp = new _valueTypes.Vec3();

var _cachedArray = new Array(16);

_cachedArray.length = 0;
var POSITION_ON = 1 << 0;
var SCALE_ON = 1 << 1;
var ROTATION_ON = 1 << 2;
var SIZE_ON = 1 << 3;
var ANCHOR_ON = 1 << 4;
var COLOR_ON = 1 << 5;
var BuiltinGroupIndex = cc.Enum({
  DEBUG: 31
});
/**
 * !#en Node's local dirty properties flag
 * !#zh Node 的本地属性 dirty 状态位
 * @enum Node._LocalDirtyFlag
 * @static
 * @private
 * @namespace Node
 */

var LocalDirtyFlag = cc.Enum({
  /**
   * !#en Flag for position dirty
   * !#zh 位置 dirty 的标记位
   * @property {Number} POSITION
   * @static
   */
  POSITION: 1 << 0,

  /**
   * !#en Flag for scale dirty
   * !#zh 缩放 dirty 的标记位
   * @property {Number} SCALE
   * @static
   */
  SCALE: 1 << 1,

  /**
   * !#en Flag for rotation dirty
   * !#zh 旋转 dirty 的标记位
   * @property {Number} ROTATION
   * @static
   */
  ROTATION: 1 << 2,

  /**
   * !#en Flag for skew dirty
   * !#zh skew dirty 的标记位
   * @property {Number} SKEW
   * @static
   */
  SKEW: 1 << 3,

  /**
   * !#en Flag for rotation, scale or position dirty
   * !#zh 旋转，缩放，或位置 dirty 的标记位
   * @property {Number} TRS
   * @static
   */
  TRS: 1 << 0 | 1 << 1 | 1 << 2,

  /**
   * !#en Flag for rotation or scale dirty
   * !#zh 旋转或缩放 dirty 的标记位
   * @property {Number} RS
   * @static
   */
  RS: 1 << 1 | 1 << 2,

  /**
   * !#en Flag for rotation, scale, position, skew dirty
   * !#zh 旋转，缩放，位置，或斜角 dirty 的标记位
   * @property {Number} TRS
   * @static
   */
  TRSS: 1 << 0 | 1 << 1 | 1 << 2 | 1 << 3,

  /**
   * !#en Flag for physics position dirty
   * !#zh 物理位置 dirty 的标记位
   * @property {Number} PHYSICS_POSITION
   * @static
   */
  PHYSICS_POSITION: 1 << 4,

  /**
   * !#en Flag for physics scale dirty
   * !#zh 物理缩放 dirty 的标记位
   * @property {Number} PHYSICS_SCALE
   * @static
   */
  PHYSICS_SCALE: 1 << 5,

  /**
   * !#en Flag for physics rotation dirty
   * !#zh 物理旋转 dirty 的标记位
   * @property {Number} PHYSICS_ROTATION
   * @static
   */
  PHYSICS_ROTATION: 1 << 6,

  /**
   * !#en Flag for physics trs dirty
   * !#zh 物理位置旋转缩放 dirty 的标记位
   * @property {Number} PHYSICS_TRS
   * @static
   */
  PHYSICS_TRS: 1 << 4 | 1 << 5 | 1 << 6,

  /**
   * !#en Flag for physics rs dirty
   * !#zh 物理旋转缩放 dirty 的标记位
   * @property {Number} PHYSICS_RS
   * @static
   */
  PHYSICS_RS: 1 << 5 | 1 << 6,

  /**
   * !#en Flag for node and physics position dirty
   * !#zh 所有位置 dirty 的标记位
   * @property {Number} ALL_POSITION
   * @static
   */
  ALL_POSITION: 1 << 0 | 1 << 4,

  /**
   * !#en Flag for node and physics scale dirty
   * !#zh 所有缩放 dirty 的标记位
   * @property {Number} ALL_SCALE
   * @static
   */
  ALL_SCALE: 1 << 1 | 1 << 5,

  /**
   * !#en Flag for node and physics rotation dirty
   * !#zh 所有旋转 dirty 的标记位
   * @property {Number} ALL_ROTATION
   * @static
   */
  ALL_ROTATION: 1 << 2 | 1 << 6,

  /**
   * !#en Flag for node and physics trs dirty
   * !#zh 所有trs dirty 的标记位
   * @property {Number} ALL_TRS
   * @static
   */
  ALL_TRS: 1 << 0 | 1 << 1 | 1 << 2 | 1 << 4 | 1 << 5 | 1 << 6,

  /**
   * !#en Flag for all dirty properties
   * !#zh 覆盖所有 dirty 状态的标记位
   * @property {Number} ALL
   * @static
   */
  ALL: 0xffff
});
/**
 * !#en The event type supported by Node
 * !#zh Node 支持的事件类型
 * @class Node.EventType
 * @static
 * @namespace Node
 */
// Why EventType defined as class, because the first parameter of Node.on method needs set as 'string' type.

var EventType = cc.Enum({
  /**
   * !#en The event type for touch start event, you can use its value directly: 'touchstart'
   * !#zh 当手指触摸到屏幕时。
   * @property {String} TOUCH_START
   * @static
   */
  TOUCH_START: 'touchstart',

  /**
   * !#en The event type for touch move event, you can use its value directly: 'touchmove'
   * !#zh 当手指在屏幕上移动时。
   * @property {String} TOUCH_MOVE
   * @static
   */
  TOUCH_MOVE: 'touchmove',

  /**
   * !#en The event type for touch end event, you can use its value directly: 'touchend'
   * !#zh 当手指在目标节点区域内离开屏幕时。
   * @property {String} TOUCH_END
   * @static
   */
  TOUCH_END: 'touchend',

  /**
   * !#en The event type for touch end event, you can use its value directly: 'touchcancel'
   * !#zh 当手指在目标节点区域外离开屏幕时。
   * @property {String} TOUCH_CANCEL
   * @static
   */
  TOUCH_CANCEL: 'touchcancel',

  /**
   * !#en The event type for mouse down events, you can use its value directly: 'mousedown'
   * !#zh 当鼠标按下时触发一次。
   * @property {String} MOUSE_DOWN
   * @static
   */
  MOUSE_DOWN: 'mousedown',

  /**
   * !#en The event type for mouse move events, you can use its value directly: 'mousemove'
   * !#zh 当鼠标在目标节点在目标节点区域中移动时，不论是否按下。
   * @property {String} MOUSE_MOVE
   * @static
   */
  MOUSE_MOVE: 'mousemove',

  /**
   * !#en The event type for mouse enter target events, you can use its value directly: 'mouseenter'
   * !#zh 当鼠标移入目标节点区域时，不论是否按下。
   * @property {String} MOUSE_ENTER
   * @static
   */
  MOUSE_ENTER: 'mouseenter',

  /**
   * !#en The event type for mouse leave target events, you can use its value directly: 'mouseleave'
   * !#zh 当鼠标移出目标节点区域时，不论是否按下。
   * @property {String} MOUSE_LEAVE
   * @static
   */
  MOUSE_LEAVE: 'mouseleave',

  /**
   * !#en The event type for mouse up events, you can use its value directly: 'mouseup'
   * !#zh 当鼠标从按下状态松开时触发一次。
   * @property {String} MOUSE_UP
   * @static
   */
  MOUSE_UP: 'mouseup',

  /**
   * !#en The event type for mouse wheel events, you can use its value directly: 'mousewheel'
   * !#zh 当鼠标滚轮滚动时。
   * @property {String} MOUSE_WHEEL
   * @static
   */
  MOUSE_WHEEL: 'mousewheel',

  /**
   * !#en The event type for position change events.
   * Performance note, this event will be triggered every time corresponding properties being changed,
   * if the event callback have heavy logic it may have great performance impact, try to avoid such scenario.
   * !#zh 当节点位置改变时触发的事件。
   * 性能警告：这个事件会在每次对应的属性被修改时触发，如果事件回调损耗较高，有可能对性能有很大的负面影响，请尽量避免这种情况。
   * @property {String} POSITION_CHANGED
   * @static
   */
  POSITION_CHANGED: 'position-changed',

  /**
   * !#en The event type for rotation change events.
   * Performance note, this event will be triggered every time corresponding properties being changed,
   * if the event callback have heavy logic it may have great performance impact, try to avoid such scenario.
   * !#zh 当节点旋转改变时触发的事件。
   * 性能警告：这个事件会在每次对应的属性被修改时触发，如果事件回调损耗较高，有可能对性能有很大的负面影响，请尽量避免这种情况。
   * @property {String} ROTATION_CHANGED
   * @static
   */
  ROTATION_CHANGED: 'rotation-changed',

  /**
   * !#en The event type for scale change events.
   * Performance note, this event will be triggered every time corresponding properties being changed,
   * if the event callback have heavy logic it may have great performance impact, try to avoid such scenario.
   * !#zh 当节点缩放改变时触发的事件。
   * 性能警告：这个事件会在每次对应的属性被修改时触发，如果事件回调损耗较高，有可能对性能有很大的负面影响，请尽量避免这种情况。
   * @property {String} SCALE_CHANGED
   * @static
   */
  SCALE_CHANGED: 'scale-changed',

  /**
   * !#en The event type for size change events.
   * Performance note, this event will be triggered every time corresponding properties being changed,
   * if the event callback have heavy logic it may have great performance impact, try to avoid such scenario.
   * !#zh 当节点尺寸改变时触发的事件。
   * 性能警告：这个事件会在每次对应的属性被修改时触发，如果事件回调损耗较高，有可能对性能有很大的负面影响，请尽量避免这种情况。
   * @property {String} SIZE_CHANGED
   * @static
   */
  SIZE_CHANGED: 'size-changed',

  /**
   * !#en The event type for anchor point change events.
   * Performance note, this event will be triggered every time corresponding properties being changed,
   * if the event callback have heavy logic it may have great performance impact, try to avoid such scenario.
   * !#zh 当节点锚点改变时触发的事件。
   * 性能警告：这个事件会在每次对应的属性被修改时触发，如果事件回调损耗较高，有可能对性能有很大的负面影响，请尽量避免这种情况。
   * @property {String} ANCHOR_CHANGED
   * @static
   */
  ANCHOR_CHANGED: 'anchor-changed',

  /**
  * !#en The event type for color change events.
  * Performance note, this event will be triggered every time corresponding properties being changed,
  * if the event callback have heavy logic it may have great performance impact, try to avoid such scenario.
  * !#zh 当节点颜色改变时触发的事件。
  * 性能警告：这个事件会在每次对应的属性被修改时触发，如果事件回调损耗较高，有可能对性能有很大的负面影响，请尽量避免这种情况。
  * @property {String} COLOR_CHANGED
  * @static
  */
  COLOR_CHANGED: 'color-changed',

  /**
   * !#en The event type for new child added events.
   * !#zh 当新的子节点被添加时触发的事件。
   * @property {String} CHILD_ADDED
   * @static
   */
  CHILD_ADDED: 'child-added',

  /**
   * !#en The event type for child removed events.
   * !#zh 当子节点被移除时触发的事件。
   * @property {String} CHILD_REMOVED
   * @static
   */
  CHILD_REMOVED: 'child-removed',

  /**
   * !#en The event type for children reorder events.
   * !#zh 当子节点顺序改变时触发的事件。
   * @property {String} CHILD_REORDER
   * @static
   */
  CHILD_REORDER: 'child-reorder',

  /**
   * !#en The event type for node group changed events.
   * !#zh 当节点归属群组发生变化时触发的事件。
   * @property {String} GROUP_CHANGED
   * @static
   */
  GROUP_CHANGED: 'group-changed',

  /**
   * !#en The event type for node's sibling order changed.
   * !#zh 当节点在兄弟节点中的顺序发生变化时触发的事件。
   * @property {String} SIBLING_ORDER_CHANGED
   * @static
   */
  SIBLING_ORDER_CHANGED: 'sibling-order-changed'
});
var _touchEvents = [EventType.TOUCH_START, EventType.TOUCH_MOVE, EventType.TOUCH_END, EventType.TOUCH_CANCEL];
var _mouseEvents = [EventType.MOUSE_DOWN, EventType.MOUSE_ENTER, EventType.MOUSE_MOVE, EventType.MOUSE_LEAVE, EventType.MOUSE_UP, EventType.MOUSE_WHEEL];
var _skewNeedWarn = true;

var _skewWarn = function _skewWarn(value, node) {
  if (value !== 0) {
    var nodePath = "";

    if (CC_EDITOR) {
      var NodeUtils = Editor.require('scene://utils/node');

      nodePath = "Node: " + NodeUtils.getNodePath(node) + ".";
    }

    _skewNeedWarn && cc.warn("`cc.Node.skewX/Y` is deprecated since v2.2.1, please use 3D node instead.", nodePath);
    !CC_EDITOR && (_skewNeedWarn = false);
  }
};

var _currentHovered = null;

var _touchStartHandler = function _touchStartHandler(touch, event) {
  var pos = touch.getLocation();
  var node = this.owner;

  if (node._hitTest(pos, this)) {
    event.type = EventType.TOUCH_START;
    event.touch = touch;
    event.bubbles = true;
    node.dispatchEvent(event);
    return true;
  }

  return false;
};

var _touchMoveHandler = function _touchMoveHandler(touch, event) {
  var node = this.owner;
  event.type = EventType.TOUCH_MOVE;
  event.touch = touch;
  event.bubbles = true;
  node.dispatchEvent(event);
};

var _touchEndHandler = function _touchEndHandler(touch, event) {
  var pos = touch.getLocation();
  var node = this.owner;

  if (node._hitTest(pos, this)) {
    event.type = EventType.TOUCH_END;
  } else {
    event.type = EventType.TOUCH_CANCEL;
  }

  event.touch = touch;
  event.bubbles = true;
  node.dispatchEvent(event);
};

var _touchCancelHandler = function _touchCancelHandler(touch, event) {
  var pos = touch.getLocation();
  var node = this.owner;
  event.type = EventType.TOUCH_CANCEL;
  event.touch = touch;
  event.bubbles = true;
  node.dispatchEvent(event);
};

var _mouseDownHandler = function _mouseDownHandler(event) {
  var pos = event.getLocation();
  var node = this.owner;

  if (node._hitTest(pos, this)) {
    event.type = EventType.MOUSE_DOWN;
    event.bubbles = true;
    node.dispatchEvent(event);
  }
};

var _mouseMoveHandler = function _mouseMoveHandler(event) {
  var pos = event.getLocation();
  var node = this.owner;

  var hit = node._hitTest(pos, this);

  if (hit) {
    if (!this._previousIn) {
      // Fix issue when hover node switched, previous hovered node won't get MOUSE_LEAVE notification
      if (_currentHovered && _currentHovered._mouseListener) {
        event.type = EventType.MOUSE_LEAVE;

        _currentHovered.dispatchEvent(event);

        _currentHovered._mouseListener._previousIn = false;
      }

      _currentHovered = this.owner;
      event.type = EventType.MOUSE_ENTER;
      node.dispatchEvent(event);
      this._previousIn = true;
    }

    event.type = EventType.MOUSE_MOVE;
    event.bubbles = true;
    node.dispatchEvent(event);
  } else if (this._previousIn) {
    event.type = EventType.MOUSE_LEAVE;
    node.dispatchEvent(event);
    this._previousIn = false;
    _currentHovered = null;
  } else {
    // continue dispatching
    return;
  } // Event processed, cleanup


  event.stopPropagation();
};

var _mouseUpHandler = function _mouseUpHandler(event) {
  var pos = event.getLocation();
  var node = this.owner;

  if (node._hitTest(pos, this)) {
    event.type = EventType.MOUSE_UP;
    event.bubbles = true;
    node.dispatchEvent(event);
    event.stopPropagation();
  }
};

var _mouseWheelHandler = function _mouseWheelHandler(event) {
  var pos = event.getLocation();
  var node = this.owner;

  if (node._hitTest(pos, this)) {
    event.type = EventType.MOUSE_WHEEL;
    event.bubbles = true;
    node.dispatchEvent(event);
    event.stopPropagation();
  }
};

function _searchComponentsInParent(node, comp) {
  if (comp) {
    var index = 0;
    var list = null;

    for (var curr = node; curr && cc.Node.isNode(curr); curr = curr._parent, ++index) {
      if (curr.getComponent(comp)) {
        var next = {
          index: index,
          node: curr
        };

        if (list) {
          list.push(next);
        } else {
          list = [next];
        }
      }
    }

    return list;
  }

  return null;
}

function _checkListeners(node, events) {
  if (!(node._objFlags & Destroying)) {
    var i = 0;

    if (node._bubblingListeners) {
      for (; i < events.length; ++i) {
        if (node._bubblingListeners.hasEventListener(events[i])) {
          return true;
        }
      }
    }

    if (node._capturingListeners) {
      for (; i < events.length; ++i) {
        if (node._capturingListeners.hasEventListener(events[i])) {
          return true;
        }
      }
    }

    return false;
  }

  return true;
}

function _doDispatchEvent(owner, event) {
  var target, i;
  event.target = owner; // Event.CAPTURING_PHASE

  _cachedArray.length = 0;

  owner._getCapturingTargets(event.type, _cachedArray); // capturing


  event.eventPhase = 1;

  for (i = _cachedArray.length - 1; i >= 0; --i) {
    target = _cachedArray[i];

    if (target._capturingListeners) {
      event.currentTarget = target; // fire event

      target._capturingListeners.emit(event.type, event, _cachedArray); // check if propagation stopped


      if (event._propagationStopped) {
        _cachedArray.length = 0;
        return;
      }
    }
  }

  _cachedArray.length = 0; // Event.AT_TARGET
  // checks if destroyed in capturing callbacks

  event.eventPhase = 2;
  event.currentTarget = owner;

  if (owner._capturingListeners) {
    owner._capturingListeners.emit(event.type, event);
  }

  if (!event._propagationImmediateStopped && owner._bubblingListeners) {
    owner._bubblingListeners.emit(event.type, event);
  }

  if (!event._propagationStopped && event.bubbles) {
    // Event.BUBBLING_PHASE
    owner._getBubblingTargets(event.type, _cachedArray); // propagate


    event.eventPhase = 3;

    for (i = 0; i < _cachedArray.length; ++i) {
      target = _cachedArray[i];

      if (target._bubblingListeners) {
        event.currentTarget = target; // fire event

        target._bubblingListeners.emit(event.type, event); // check if propagation stopped


        if (event._propagationStopped) {
          _cachedArray.length = 0;
          return;
        }
      }
    }
  }

  _cachedArray.length = 0;
} // traversal the node tree, child cullingMask must keep the same with the parent.


function _getActualGroupIndex(node) {
  var groupIndex = node.groupIndex;

  if (groupIndex === 0 && node.parent) {
    groupIndex = _getActualGroupIndex(node.parent);
  }

  return groupIndex;
}

function _updateCullingMask(node) {
  var index = _getActualGroupIndex(node);

  node._cullingMask = 1 << index;

  if (CC_JSB && CC_NATIVERENDERER) {
    node._proxy && node._proxy.updateCullingMask();
  }

  ;

  for (var i = 0; i < node._children.length; i++) {
    _updateCullingMask(node._children[i]);
  }
} // 2D/3D matrix functions


function updateLocalMatrix3D() {
  if (this._localMatDirty & LocalDirtyFlag.TRSS) {
    // Update transform
    var t = this._matrix;
    var tm = t.m;

    _valueTypes.Trs.toMat4(t, this._trs); // skew


    if (this._skewX || this._skewY) {
      var a = tm[0],
          b = tm[1],
          c = tm[4],
          d = tm[5];
      var skx = Math.tan(this._skewX * ONE_DEGREE);
      var sky = Math.tan(this._skewY * ONE_DEGREE);
      if (skx === Infinity) skx = 99999999;
      if (sky === Infinity) sky = 99999999;
      tm[0] = a + c * sky;
      tm[1] = b + d * sky;
      tm[4] = c + a * skx;
      tm[5] = d + b * skx;
    }

    this._localMatDirty &= ~LocalDirtyFlag.TRSS; // Register dirty status of world matrix so that it can be recalculated

    this._worldMatDirty = true;
  }
}

function updateLocalMatrix2D() {
  var dirtyFlag = this._localMatDirty;
  if (!(dirtyFlag & LocalDirtyFlag.TRSS)) return; // Update transform

  var t = this._matrix;
  var tm = t.m;
  var trs = this._trs;

  if (dirtyFlag & (LocalDirtyFlag.RS | LocalDirtyFlag.SKEW)) {
    var rotation = -this._eulerAngles.z;
    var hasSkew = this._skewX || this._skewY;
    var sx = trs[7],
        sy = trs[8];

    if (rotation || hasSkew) {
      var a = 1,
          b = 0,
          c = 0,
          d = 1; // rotation

      if (rotation) {
        var rotationRadians = rotation * ONE_DEGREE;
        c = Math.sin(rotationRadians);
        d = Math.cos(rotationRadians);
        a = d;
        b = -c;
      } // scale


      tm[0] = a *= sx;
      tm[1] = b *= sx;
      tm[4] = c *= sy;
      tm[5] = d *= sy; // skew

      if (hasSkew) {
        var _a = tm[0],
            _b = tm[1],
            _c = tm[4],
            _d = tm[5];
        var skx = Math.tan(this._skewX * ONE_DEGREE);
        var sky = Math.tan(this._skewY * ONE_DEGREE);
        if (skx === Infinity) skx = 99999999;
        if (sky === Infinity) sky = 99999999;
        tm[0] = _a + _c * sky;
        tm[1] = _b + _d * sky;
        tm[4] = _c + _a * skx;
        tm[5] = _d + _b * skx;
      }
    } else {
      tm[0] = sx;
      tm[1] = 0;
      tm[4] = 0;
      tm[5] = sy;
    }
  } // position


  tm[12] = trs[0];
  tm[13] = trs[1];
  this._localMatDirty &= ~LocalDirtyFlag.TRSS; // Register dirty status of world matrix so that it can be recalculated

  this._worldMatDirty = true;
}

function calculWorldMatrix3D() {
  // Avoid as much function call as possible
  if (this._localMatDirty & LocalDirtyFlag.TRSS) {
    this._updateLocalMatrix();
  }

  if (this._parent) {
    var parentMat = this._parent._worldMatrix;

    _valueTypes.Mat4.mul(this._worldMatrix, parentMat, this._matrix);
  } else {
    _valueTypes.Mat4.copy(this._worldMatrix, this._matrix);
  }

  this._worldMatDirty = false;
}

function calculWorldMatrix2D() {
  // Avoid as much function call as possible
  if (this._localMatDirty & LocalDirtyFlag.TRSS) {
    this._updateLocalMatrix();
  } // Assume parent world matrix is correct


  var parent = this._parent;

  if (parent) {
    this._mulMat(this._worldMatrix, parent._worldMatrix, this._matrix);
  } else {
    _valueTypes.Mat4.copy(this._worldMatrix, this._matrix);
  }

  this._worldMatDirty = false;
}

function mulMat2D(out, a, b) {
  var am = a.m,
      bm = b.m,
      outm = out.m;
  var aa = am[0],
      ab = am[1],
      ac = am[4],
      ad = am[5],
      atx = am[12],
      aty = am[13];
  var ba = bm[0],
      bb = bm[1],
      bc = bm[4],
      bd = bm[5],
      btx = bm[12],
      bty = bm[13];

  if (ab !== 0 || ac !== 0) {
    outm[0] = ba * aa + bb * ac;
    outm[1] = ba * ab + bb * ad;
    outm[4] = bc * aa + bd * ac;
    outm[5] = bc * ab + bd * ad;
    outm[12] = aa * btx + ac * bty + atx;
    outm[13] = ab * btx + ad * bty + aty;
  } else {
    outm[0] = ba * aa;
    outm[1] = bb * ad;
    outm[4] = bc * aa;
    outm[5] = bd * ad;
    outm[12] = aa * btx + atx;
    outm[13] = ad * bty + aty;
  }
}

var mulMat3D = _valueTypes.Mat4.mul;
/**
 * !#en
 * Class of all entities in Cocos Creator scenes.<br/>
 * For events supported by Node, please refer to {{#crossLink "Node.EventType"}}{{/crossLink}}
 * !#zh
 * Cocos Creator 场景中的所有节点类。<br/>
 * 支持的节点事件，请参阅 {{#crossLink "Node.EventType"}}{{/crossLink}}。
 * @class Node
 * @extends _BaseNode
 */

var NodeDefines = {
  name: 'cc.Node',
  "extends": BaseNode,
  properties: {
    // SERIALIZABLE
    _opacity: 255,
    _color: cc.Color.WHITE,
    _contentSize: cc.Size,
    _anchorPoint: cc.v2(0.5, 0.5),
    _position: undefined,
    _scale: undefined,
    _trs: null,
    _eulerAngles: cc.Vec3,
    _skewX: 0.0,
    _skewY: 0.0,
    _zIndex: {
      "default": undefined,
      type: cc.Integer
    },
    _localZOrder: {
      "default": 0,
      serializable: false
    },
    _is3DNode: false,
    // internal properties

    /**
     * !#en
     * Group index of node.<br/>
     * Which Group this node belongs to will resolve that this node's collision components can collide with which other collision componentns.<br/>
     * !#zh
     * 节点的分组索引。<br/>
     * 节点的分组将关系到节点的碰撞组件可以与哪些碰撞组件相碰撞。<br/>
     * @property groupIndex
     * @type {Integer}
     * @default 0
     */
    _groupIndex: {
      "default": 0,
      formerlySerializedAs: 'groupIndex'
    },
    groupIndex: {
      get: function get() {
        return this._groupIndex;
      },
      set: function set(value) {
        this._groupIndex = value;

        _updateCullingMask(this);

        this.emit(EventType.GROUP_CHANGED, this);
      }
    },

    /**
     * !#en
     * Group of node.<br/>
     * Which Group this node belongs to will resolve that this node's collision components can collide with which other collision componentns.<br/>
     * !#zh
     * 节点的分组。<br/>
     * 节点的分组将关系到节点的碰撞组件可以与哪些碰撞组件相碰撞。<br/>
     * @property group
     * @type {String}
     */
    group: {
      get: function get() {
        return cc.game.groupList[this.groupIndex] || '';
      },
      set: function set(value) {
        // update the groupIndex
        this.groupIndex = cc.game.groupList.indexOf(value);
      }
    },
    //properties moved from base node begin

    /**
     * !#en The position (x, y) of the node in its parent's coordinates.
     * !#zh 节点在父节点坐标系中的位置（x, y）。
     * @property {Vec3} position
     * @example
     * cc.log("Node Position: " + node.position);
     */

    /**
     * !#en x axis position of node.
     * !#zh 节点 X 轴坐标。
     * @property x
     * @type {Number}
     * @example
     * node.x = 100;
     * cc.log("Node Position X: " + node.x);
     */
    x: {
      get: function get() {
        return this._trs[0];
      },
      set: function set(value) {
        var trs = this._trs;

        if (value !== trs[0]) {
          if (!CC_EDITOR || isFinite(value)) {
            var oldValue;

            if (CC_EDITOR) {
              oldValue = trs[0];
            }

            trs[0] = value;
            this.setLocalDirty(LocalDirtyFlag.ALL_POSITION); // fast check event

            if (this._eventMask & POSITION_ON) {
              // send event
              if (CC_EDITOR) {
                this.emit(EventType.POSITION_CHANGED, new cc.Vec3(oldValue, trs[1], trs[2]));
              } else {
                this.emit(EventType.POSITION_CHANGED);
              }
            }
          } else {
            cc.error(ERR_INVALID_NUMBER, 'new x');
          }
        }
      }
    },

    /**
     * !#en y axis position of node.
     * !#zh 节点 Y 轴坐标。
     * @property y
     * @type {Number}
     * @example
     * node.y = 100;
     * cc.log("Node Position Y: " + node.y);
     */
    y: {
      get: function get() {
        return this._trs[1];
      },
      set: function set(value) {
        var trs = this._trs;

        if (value !== trs[1]) {
          if (!CC_EDITOR || isFinite(value)) {
            var oldValue;

            if (CC_EDITOR) {
              oldValue = trs[1];
            }

            trs[1] = value;
            this.setLocalDirty(LocalDirtyFlag.ALL_POSITION); // fast check event

            if (this._eventMask & POSITION_ON) {
              // send event
              if (CC_EDITOR) {
                this.emit(EventType.POSITION_CHANGED, new cc.Vec3(trs[0], oldValue, trs[2]));
              } else {
                this.emit(EventType.POSITION_CHANGED);
              }
            }
          } else {
            cc.error(ERR_INVALID_NUMBER, 'new y');
          }
        }
      }
    },

    /**
     * !#en z axis position of node.
     * !#zh 节点 Z 轴坐标。
     * @property z
     * @type {Number}
     */
    z: {
      get: function get() {
        return this._trs[2];
      },
      set: function set(value) {
        var trs = this._trs;

        if (value !== trs[2]) {
          if (!CC_EDITOR || isFinite(value)) {
            trs[2] = value;
            this.setLocalDirty(LocalDirtyFlag.ALL_POSITION);
            !CC_NATIVERENDERER && (this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM); // fast check event

            if (this._eventMask & POSITION_ON) {
              this.emit(EventType.POSITION_CHANGED);
            }
          } else {
            cc.error(ERR_INVALID_NUMBER, 'new z');
          }
        }
      }
    },

    /**
     * !#en Rotation of node.
     * !#zh 该节点旋转角度。
     * @property rotation
     * @type {Number}
     * @deprecated since v2.1
     * @example
     * node.rotation = 90;
     * cc.log("Node Rotation: " + node.rotation);
     */
    rotation: {
      get: function get() {
        if (CC_DEBUG) {
          cc.warn("`cc.Node.rotation` is deprecated since v2.1.0, please use `-angle` instead. (`this.node.rotation` -> `-this.node.angle`)");
        }

        return -this.angle;
      },
      set: function set(value) {
        if (CC_DEBUG) {
          cc.warn("`cc.Node.rotation` is deprecated since v2.1.0, please set `-angle` instead. (`this.node.rotation = x` -> `this.node.angle = -x`)");
        }

        this.angle = -value;
      }
    },

    /**
     * !#en
     * Angle of node, the positive value is anti-clockwise direction.
     * !#zh
     * 该节点的旋转角度，正值为逆时针方向。
     * @property angle
     * @type {Number}
     */
    angle: {
      get: function get() {
        return this._eulerAngles.z;
      },
      set: function set(value) {
        _valueTypes.Vec3.set(this._eulerAngles, 0, 0, value);

        _valueTypes.Trs.fromAngleZ(this._trs, value);

        this.setLocalDirty(LocalDirtyFlag.ALL_ROTATION);

        if (this._eventMask & ROTATION_ON) {
          this.emit(EventType.ROTATION_CHANGED);
        }
      }
    },

    /**
     * !#en The rotation as Euler angles in degrees, used in 3D node.
     * !#zh 该节点的欧拉角度，用于 3D 节点。
     * @property eulerAngles
     * @type {Vec3}
     * @example
     * node.is3DNode = true;
     * node.eulerAngles = cc.v3(45, 45, 45);
     * cc.log("Node eulerAngles (X, Y, Z): " + node.eulerAngles.toString());
     */

    /**
     * !#en Rotation on x axis.
     * !#zh 该节点 X 轴旋转角度。
     * @property rotationX
     * @type {Number}
     * @deprecated since v2.1
     * @example
     * node.is3DNode = true;
     * node.eulerAngles = cc.v3(45, 0, 0);
     * cc.log("Node eulerAngles X: " + node.eulerAngles.x);
     */
    rotationX: {
      get: function get() {
        if (CC_DEBUG) {
          cc.warn("`cc.Node.rotationX` is deprecated since v2.1.0, please use `eulerAngles.x` instead. (`this.node.rotationX` -> `this.node.eulerAngles.x`)");
        }

        return this._eulerAngles.x;
      },
      set: function set(value) {
        if (CC_DEBUG) {
          cc.warn("`cc.Node.rotationX` is deprecated since v2.1.0, please set `eulerAngles` instead. (`this.node.rotationX = x` -> `this.node.is3DNode = true; this.node.eulerAngles = cc.v3(x, 0, 0)`");
        }

        if (this._eulerAngles.x !== value) {
          this._eulerAngles.x = value; // Update quaternion from rotation

          if (this._eulerAngles.x === this._eulerAngles.y) {
            _valueTypes.Trs.fromAngleZ(this._trs, -value);
          } else {
            _valueTypes.Trs.fromEulerNumber(this._trs, value, this._eulerAngles.y, 0);
          }

          this.setLocalDirty(LocalDirtyFlag.ALL_ROTATION);

          if (this._eventMask & ROTATION_ON) {
            this.emit(EventType.ROTATION_CHANGED);
          }
        }
      }
    },

    /**
     * !#en Rotation on y axis.
     * !#zh 该节点 Y 轴旋转角度。
     * @property rotationY
     * @type {Number}
     * @deprecated since v2.1
     * @example
     * node.is3DNode = true;
     * node.eulerAngles = cc.v3(0, 45, 0);
     * cc.log("Node eulerAngles Y: " + node.eulerAngles.y);
     */
    rotationY: {
      get: function get() {
        if (CC_DEBUG) {
          cc.warn("`cc.Node.rotationY` is deprecated since v2.1.0, please use `eulerAngles.y` instead. (`this.node.rotationY` -> `this.node.eulerAngles.y`)");
        }

        return this._eulerAngles.y;
      },
      set: function set(value) {
        if (CC_DEBUG) {
          cc.warn("`cc.Node.rotationY` is deprecated since v2.1.0, please set `eulerAngles` instead. (`this.node.rotationY = y` -> `this.node.is3DNode = true; this.node.eulerAngles = cc.v3(0, y, 0)`");
        }

        if (this._eulerAngles.y !== value) {
          this._eulerAngles.y = value; // Update quaternion from rotation

          if (this._eulerAngles.x === this._eulerAngles.y) {
            _valueTypes.Trs.fromAngleZ(this._trs, -value);
          } else {
            _valueTypes.Trs.fromEulerNumber(this._trs, this._eulerAngles.x, value, 0);
          }

          this.setLocalDirty(LocalDirtyFlag.ALL_ROTATION);

          if (this._eventMask & ROTATION_ON) {
            this.emit(EventType.ROTATION_CHANGED);
          }
        }
      }
    },
    eulerAngles: {
      get: function get() {
        if (CC_EDITOR) {
          return this._eulerAngles;
        } else {
          return _valueTypes.Trs.toEuler(this._eulerAngles, this._trs);
        }
      },
      set: function set(v) {
        if (CC_EDITOR) {
          this._eulerAngles.set(v);
        }

        _valueTypes.Trs.fromEuler(this._trs, v);

        this.setLocalDirty(LocalDirtyFlag.ALL_ROTATION);
        !CC_NATIVERENDERER && (this._renderFlag |= RenderFlow.FLAG_TRANSFORM);

        if (this._eventMask & ROTATION_ON) {
          this.emit(EventType.ROTATION_CHANGED);
        }
      }
    },
    // This property is used for Mesh Skeleton Animation
    // Should be removed when node.rotation upgrade to quaternion value
    quat: {
      get: function get() {
        var trs = this._trs;
        return new _valueTypes.Quat(trs[3], trs[4], trs[5], trs[6]);
      },
      set: function set(v) {
        this.setRotation(v);
      }
    },

    /**
     * !#en The local scale relative to the parent.
     * !#zh 节点相对父节点的缩放。
     * @property scale
     * @type {Number}
     * @example
     * node.scale = 1;
     */
    scale: {
      get: function get() {
        return this._trs[7];
      },
      set: function set(v) {
        this.setScale(v);
      }
    },

    /**
     * !#en Scale on x axis.
     * !#zh 节点 X 轴缩放。
     * @property scaleX
     * @type {Number}
     * @example
     * node.scaleX = 0.5;
     * cc.log("Node Scale X: " + node.scaleX);
     */
    scaleX: {
      get: function get() {
        return this._trs[7];
      },
      set: function set(value) {
        if (this._trs[7] !== value) {
          this._trs[7] = value;
          this.setLocalDirty(LocalDirtyFlag.ALL_SCALE);

          if (this._eventMask & SCALE_ON) {
            this.emit(EventType.SCALE_CHANGED);
          }
        }
      }
    },

    /**
     * !#en Scale on y axis.
     * !#zh 节点 Y 轴缩放。
     * @property scaleY
     * @type {Number}
     * @example
     * node.scaleY = 0.5;
     * cc.log("Node Scale Y: " + node.scaleY);
     */
    scaleY: {
      get: function get() {
        return this._trs[8];
      },
      set: function set(value) {
        if (this._trs[8] !== value) {
          this._trs[8] = value;
          this.setLocalDirty(LocalDirtyFlag.ALL_SCALE);

          if (this._eventMask & SCALE_ON) {
            this.emit(EventType.SCALE_CHANGED);
          }
        }
      }
    },

    /**
     * !#en Scale on z axis.
     * !#zh 节点 Z 轴缩放。
     * @property scaleZ
     * @type {Number}
     */
    scaleZ: {
      get: function get() {
        return this._trs[9];
      },
      set: function set(value) {
        if (this._trs[9] !== value) {
          this._trs[9] = value;
          this.setLocalDirty(LocalDirtyFlag.ALL_SCALE);
          !CC_NATIVERENDERER && (this._renderFlag |= RenderFlow.FLAG_TRANSFORM);

          if (this._eventMask & SCALE_ON) {
            this.emit(EventType.SCALE_CHANGED);
          }
        }
      }
    },

    /**
     * !#en Skew x
     * !#zh 该节点 X 轴倾斜角度。
     * @property skewX
     * @type {Number}
     * @example
     * node.skewX = 0;
     * cc.log("Node SkewX: " + node.skewX);
     * @deprecated since v2.2.1
     */
    skewX: {
      get: function get() {
        return this._skewX;
      },
      set: function set(value) {
        _skewWarn(value, this);

        this._skewX = value;
        this.setLocalDirty(LocalDirtyFlag.SKEW);

        if (CC_JSB && CC_NATIVERENDERER) {
          this._proxy.updateSkew();
        }
      }
    },

    /**
     * !#en Skew y
     * !#zh 该节点 Y 轴倾斜角度。
     * @property skewY
     * @type {Number}
     * @example
     * node.skewY = 0;
     * cc.log("Node SkewY: " + node.skewY);
     * @deprecated since v2.2.1
     */
    skewY: {
      get: function get() {
        return this._skewY;
      },
      set: function set(value) {
        _skewWarn(value, this);

        this._skewY = value;
        this.setLocalDirty(LocalDirtyFlag.SKEW);

        if (CC_JSB && CC_NATIVERENDERER) {
          this._proxy.updateSkew();
        }
      }
    },

    /**
     * !#en Opacity of node, default value is 255.
     * !#zh 节点透明度，默认值为 255。
     * @property opacity
     * @type {Number}
     * @example
     * node.opacity = 255;
     */
    opacity: {
      get: function get() {
        return this._opacity;
      },
      set: function set(value) {
        value = cc.misc.clampf(value, 0, 255);

        if (this._opacity !== value) {
          this._opacity = value;

          if (CC_JSB && CC_NATIVERENDERER) {
            this._proxy.updateOpacity();
          }

          this._renderFlag |= RenderFlow.FLAG_OPACITY_COLOR;
        }
      },
      range: [0, 255]
    },

    /**
     * !#en Color of node, default value is white: (255, 255, 255).
     * !#zh 节点颜色。默认为白色，数值为：（255，255，255）。
     * @property color
     * @type {Color}
     * @example
     * node.color = new cc.Color(255, 255, 255);
     */
    color: {
      get: function get() {
        return this._color.clone();
      },
      set: function set(value) {
        if (!this._color.equals(value)) {
          this._color.set(value);

          if (CC_DEV && value.a !== 255) {
            cc.warnID(1626);
          }

          this._renderFlag |= RenderFlow.FLAG_COLOR;

          if (this._eventMask & COLOR_ON) {
            this.emit(EventType.COLOR_CHANGED, value);
          }
        }
      }
    },

    /**
     * !#en Anchor point's position on x axis.
     * !#zh 节点 X 轴锚点位置。
     * @property anchorX
     * @type {Number}
     * @example
     * node.anchorX = 0;
     */
    anchorX: {
      get: function get() {
        return this._anchorPoint.x;
      },
      set: function set(value) {
        var anchorPoint = this._anchorPoint;

        if (anchorPoint.x !== value) {
          anchorPoint.x = value;

          if (this._eventMask & ANCHOR_ON) {
            this.emit(EventType.ANCHOR_CHANGED);
          }
        }
      }
    },

    /**
     * !#en Anchor point's position on y axis.
     * !#zh 节点 Y 轴锚点位置。
     * @property anchorY
     * @type {Number}
     * @example
     * node.anchorY = 0;
     */
    anchorY: {
      get: function get() {
        return this._anchorPoint.y;
      },
      set: function set(value) {
        var anchorPoint = this._anchorPoint;

        if (anchorPoint.y !== value) {
          anchorPoint.y = value;

          if (this._eventMask & ANCHOR_ON) {
            this.emit(EventType.ANCHOR_CHANGED);
          }
        }
      }
    },

    /**
     * !#en Width of node.
     * !#zh 节点宽度。
     * @property width
     * @type {Number}
     * @example
     * node.width = 100;
     */
    width: {
      get: function get() {
        return this._contentSize.width;
      },
      set: function set(value) {
        if (value !== this._contentSize.width) {
          if (CC_EDITOR) {
            var clone = cc.size(this._contentSize.width, this._contentSize.height);
          }

          this._contentSize.width = value;

          if (this._eventMask & SIZE_ON) {
            if (CC_EDITOR) {
              this.emit(EventType.SIZE_CHANGED, clone);
            } else {
              this.emit(EventType.SIZE_CHANGED);
            }
          }
        }
      }
    },

    /**
     * !#en Height of node.
     * !#zh 节点高度。
     * @property height
     * @type {Number}
     * @example
     * node.height = 100;
     */
    height: {
      get: function get() {
        return this._contentSize.height;
      },
      set: function set(value) {
        if (value !== this._contentSize.height) {
          if (CC_EDITOR) {
            var clone = cc.size(this._contentSize.width, this._contentSize.height);
          }

          this._contentSize.height = value;

          if (this._eventMask & SIZE_ON) {
            if (CC_EDITOR) {
              this.emit(EventType.SIZE_CHANGED, clone);
            } else {
              this.emit(EventType.SIZE_CHANGED);
            }
          }
        }
      }
    },

    /**
     * !#en zIndex is the 'key' used to sort the node relative to its siblings.<br/>
     * The value of zIndex should be in the range between cc.macro.MIN_ZINDEX and cc.macro.MAX_ZINDEX.<br/>
     * The Node's parent will sort all its children based on the zIndex value and the arrival order.<br/>
     * Nodes with greater zIndex will be sorted after nodes with smaller zIndex.<br/>
     * If two nodes have the same zIndex, then the node that was added first to the children's array will be in front of the other node in the array.<br/>
     * Node's order in children list will affect its rendering order. Parent is always rendering before all children.
     * !#zh zIndex 是用来对节点进行排序的关键属性，它决定一个节点在兄弟节点之间的位置。<br/>
     * zIndex 的取值应该介于 cc.macro.MIN_ZINDEX 和 cc.macro.MAX_ZINDEX 之间
     * 父节点主要根据节点的 zIndex 和添加次序来排序，拥有更高 zIndex 的节点将被排在后面，如果两个节点的 zIndex 一致，先添加的节点会稳定排在另一个节点之前。<br/>
     * 节点在 children 中的顺序决定了其渲染顺序。父节点永远在所有子节点之前被渲染
     * @property zIndex
     * @type {Number}
     * @example
     * node.zIndex = 1;
     * cc.log("Node zIndex: " + node.zIndex);
     */
    zIndex: {
      get: function get() {
        return this._localZOrder >> 16;
      },
      set: function set(value) {
        if (value > macro.MAX_ZINDEX) {
          cc.warnID(1636);
          value = macro.MAX_ZINDEX;
        } else if (value < macro.MIN_ZINDEX) {
          cc.warnID(1637);
          value = macro.MIN_ZINDEX;
        }

        if (this.zIndex !== value) {
          this._localZOrder = this._localZOrder & 0x0000ffff | value << 16;
          this.emit(EventType.SIBLING_ORDER_CHANGED);

          this._onSiblingIndexChanged();
        }
      }
    },

    /**
     * !#en
     * Switch 2D/3D node. The 2D nodes will run faster.
     * !#zh
     * 切换 2D/3D 节点，2D 节点会有更高的运行效率
     * @property {Boolean} is3DNode
     * @default false
    */
    is3DNode: {
      get: function get() {
        return this._is3DNode;
      },
      set: function set(v) {
        this._is3DNode = v;

        this._update3DFunction();
      }
    },

    /**
     * !#en Returns a normalized vector representing the up direction (Y axis) of the node in world space.
     * !#zh 获取节点正上方（y 轴）面对的方向，返回值为世界坐标系下的归一化向量
     * 
     * @property up
     * @type {Vec3}
     */
    up: {
      get: function get() {
        var _up = _valueTypes.Vec3.transformQuat(_urfVec3, _valueTypes.Vec3.UP, this.getWorldRotation(_urfQuat));

        return _up.clone();
      }
    },

    /**
     * !#en Returns a normalized vector representing the right direction (X axis) of the node in world space.
     * !#zh 获取节点正右方（x 轴）面对的方向，返回值为世界坐标系下的归一化向量
     * 
     * @property right
     * @type {Vec3}
     */
    right: {
      get: function get() {
        var _right = _valueTypes.Vec3.transformQuat(_urfVec3, _valueTypes.Vec3.RIGHT, this.getWorldRotation(_urfQuat));

        return _right.clone();
      }
    },

    /**
     * !#en Returns a normalized vector representing the forward direction (Z axis) of the node in world space.
     * !#zh 获取节点正前方（z 轴）面对的方向，返回值为世界坐标系下的归一化向量
     * 
     * @property forward
     * @type {Vec3}
     */
    forward: {
      get: function get() {
        var _forward = _valueTypes.Vec3.transformQuat(_urfVec3, _valueTypes.Vec3.FORWARD, this.getWorldRotation(_urfQuat));

        return _forward.clone();
      }
    }
  },

  /**
   * @method constructor
   * @param {String} [name]
   */
  ctor: function ctor() {
    this._reorderChildDirty = false; // cache component

    this._widget = null; // fast render component access

    this._renderComponent = null; // Event listeners

    this._capturingListeners = null;
    this._bubblingListeners = null; // Touch event listener

    this._touchListener = null; // Mouse event listener

    this._mouseListener = null;

    this._initDataFromPool();

    this._eventMask = 0;
    this._cullingMask = 1;
    this._childArrivalOrder = 1; // Proxy

    if (CC_JSB && CC_NATIVERENDERER) {
      this._proxy = new renderer.NodeProxy(this._spaceInfo.unitID, this._spaceInfo.index, this._id, this._name);

      this._proxy.init(this);
    } // should reset _renderFlag for both web and native


    this._renderFlag = RenderFlow.FLAG_TRANSFORM | RenderFlow.FLAG_OPACITY_COLOR;
  },
  statics: {
    EventType: EventType,
    _LocalDirtyFlag: LocalDirtyFlag,
    // is node but not scene
    isNode: function isNode(obj) {
      return obj instanceof Node && (obj.constructor === Node || !(obj instanceof cc.Scene));
    },
    BuiltinGroupIndex: BuiltinGroupIndex
  },
  // OVERRIDES
  _onSiblingIndexChanged: function _onSiblingIndexChanged() {
    // update rendering scene graph, sort them by arrivalOrder
    if (this._parent) {
      this._parent._delaySort();
    }
  },
  _onPreDestroy: function _onPreDestroy() {
    var destroyByParent = this._onPreDestroyBase(); // Actions


    if (ActionManagerExist) {
      cc.director.getActionManager().removeAllActionsFromTarget(this);
    } // Remove Node.currentHovered


    if (_currentHovered === this) {
      _currentHovered = null;
    } // Remove all event listeners if necessary


    if (this._touchListener || this._mouseListener) {
      eventManager.removeListeners(this);

      if (this._touchListener) {
        this._touchListener.owner = null;
        this._touchListener.mask = null;
        this._touchListener = null;
      }

      if (this._mouseListener) {
        this._mouseListener.owner = null;
        this._mouseListener.mask = null;
        this._mouseListener = null;
      }
    }

    if (CC_JSB && CC_NATIVERENDERER) {
      this._proxy.destroy();

      this._proxy = null;
    }

    this._backDataIntoPool();

    if (this._reorderChildDirty) {
      cc.director.__fastOff(cc.Director.EVENT_AFTER_UPDATE, this.sortAllChildren, this);
    }

    if (!destroyByParent) {
      // simulate some destruct logic to make undo system work correctly
      if (CC_EDITOR) {
        // ensure this node can reattach to scene by undo system
        this._parent = null;
      }
    }
  },
  _onPostActivated: function _onPostActivated(active) {
    var actionManager = ActionManagerExist ? cc.director.getActionManager() : null;

    if (active) {
      // Refresh transform
      this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM; // ActionManager & EventManager

      actionManager && actionManager.resumeTarget(this);
      eventManager.resumeTarget(this); // Search Mask in parent

      this._checkListenerMask();
    } else {
      // deactivate
      actionManager && actionManager.pauseTarget(this);
      eventManager.pauseTarget(this);
    }
  },
  _onHierarchyChanged: function _onHierarchyChanged(oldParent) {
    this._updateOrderOfArrival(); // Fixed a bug where children and parent node groups were forced to synchronize, instead of only synchronizing `_cullingMask` value


    _updateCullingMask(this);

    if (this._parent) {
      this._parent._delaySort();
    }

    this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;

    this._onHierarchyChangedBase(oldParent);

    if (cc._widgetManager) {
      cc._widgetManager._nodesOrderDirty = true;
    }

    if (oldParent && this._activeInHierarchy) {
      //TODO: It may be necessary to update the listener mask of all child nodes.
      this._checkListenerMask();
    } // Node proxy


    if (CC_JSB && CC_NATIVERENDERER) {
      this._proxy.updateParent();
    }
  },
  // INTERNAL
  _update3DFunction: function _update3DFunction() {
    if (this._is3DNode) {
      this._updateLocalMatrix = updateLocalMatrix3D;
      this._calculWorldMatrix = calculWorldMatrix3D;
      this._mulMat = mulMat3D;
    } else {
      this._updateLocalMatrix = updateLocalMatrix2D;
      this._calculWorldMatrix = calculWorldMatrix2D;
      this._mulMat = mulMat2D;
    }

    if (this._renderComponent && this._renderComponent._on3DNodeChanged) {
      this._renderComponent._on3DNodeChanged();
    }

    this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
    this._localMatDirty = LocalDirtyFlag.ALL;

    if (CC_JSB && CC_NATIVERENDERER) {
      this._proxy.update3DNode();
    }
  },
  _initDataFromPool: function _initDataFromPool() {
    if (!this._spaceInfo) {
      if (CC_EDITOR || CC_TEST) {
        this._spaceInfo = {
          trs: new Float64Array(10),
          localMat: new Float64Array(16),
          worldMat: new Float64Array(16)
        };
      } else {
        this._spaceInfo = nodeMemPool.pop();
      }
    }

    var spaceInfo = this._spaceInfo;
    this._matrix = cc.mat4(spaceInfo.localMat);

    _valueTypes.Mat4.identity(this._matrix);

    this._worldMatrix = cc.mat4(spaceInfo.worldMat);

    _valueTypes.Mat4.identity(this._worldMatrix);

    this._localMatDirty = LocalDirtyFlag.ALL;
    this._worldMatDirty = true;
    var trs = this._trs = this._spaceInfo.trs;
    trs[0] = 0; // position.x

    trs[1] = 0; // position.y

    trs[2] = 0; // position.z

    trs[3] = 0; // rotation.x

    trs[4] = 0; // rotation.y

    trs[5] = 0; // rotation.z

    trs[6] = 1; // rotation.w

    trs[7] = 1; // scale.x

    trs[8] = 1; // scale.y

    trs[9] = 1; // scale.z
  },
  _backDataIntoPool: function _backDataIntoPool() {
    if (!(CC_EDITOR || CC_TEST)) {
      // push back to pool
      nodeMemPool.push(this._spaceInfo);
      this._matrix = null;
      this._worldMatrix = null;
      this._trs = null;
      this._spaceInfo = null;
    }
  },
  _toEuler: function _toEuler() {
    if (this.is3DNode) {
      _valueTypes.Trs.toEuler(this._eulerAngles, this._trs);
    } else {
      var z = Math.asin(this._trs[5]) / ONE_DEGREE * 2;

      _valueTypes.Vec3.set(this._eulerAngles, 0, 0, z);
    }
  },
  _fromEuler: function _fromEuler() {
    if (this.is3DNode) {
      _valueTypes.Trs.fromEuler(this._trs, this._eulerAngles);
    } else {
      _valueTypes.Trs.fromAngleZ(this._trs, this._eulerAngles.z);
    }
  },
  _upgrade_1x_to_2x: function _upgrade_1x_to_2x() {
    if (this._is3DNode) {
      this._update3DFunction();
    }

    var trs = this._trs;

    if (trs) {
      var desTrs = trs;
      trs = this._trs = this._spaceInfo.trs; // just adapt to old trs

      if (desTrs.length === 11) {
        trs.set(desTrs.subarray(1));
      } else {
        trs.set(desTrs);
      }
    } else {
      trs = this._trs = this._spaceInfo.trs;
    }

    if (this._zIndex !== undefined) {
      this._localZOrder = this._zIndex << 16;
      this._zIndex = undefined;
    }

    if (CC_EDITOR) {
      if (this._skewX !== 0 || this._skewY !== 0) {
        var NodeUtils = Editor.require('scene://utils/node');

        cc.warn("`cc.Node.skewX/Y` is deprecated since v2.2.1, please use 3D node instead.", "Node: " + NodeUtils.getNodePath(this) + ".");
      }
    }

    this._fromEuler();

    if (this._localZOrder !== 0) {
      this._zIndex = (this._localZOrder & 0xffff0000) >> 16;
    } // Upgrade from 2.0.0 preview 4 & earlier versions
    // TODO: Remove after final version


    if (this._color.a < 255 && this._opacity === 255) {
      this._opacity = this._color.a;
      this._color.a = 255;
    }

    if (CC_JSB && CC_NATIVERENDERER) {
      this._renderFlag |= RenderFlow.FLAG_TRANSFORM | RenderFlow.FLAG_OPACITY_COLOR;
    }
  },

  /*
   * The initializer for Node which will be called before all components onLoad
   */
  _onBatchCreated: function _onBatchCreated() {
    var prefabInfo = this._prefab;

    if (prefabInfo && prefabInfo.sync && prefabInfo.root === this) {
      if (CC_DEV) {
        // TODO - remove all usage of _synced
        cc.assert(!prefabInfo._synced, 'prefab should not synced');
      }

      PrefabHelper.syncWithPrefab(this);
    }

    this._upgrade_1x_to_2x();

    this._updateOrderOfArrival(); // Fixed a bug where children and parent node groups were forced to synchronize, instead of only synchronizing `_cullingMask` value


    this._cullingMask = 1 << _getActualGroupIndex(this);

    if (CC_JSB && CC_NATIVERENDERER) {
      this._proxy && this._proxy.updateCullingMask();
    }

    ;

    if (!this._activeInHierarchy) {
      // deactivate ActionManager and EventManager by default
      if (ActionManagerExist) {
        cc.director.getActionManager().pauseTarget(this);
      }

      eventManager.pauseTarget(this);
    }

    var children = this._children;

    for (var i = 0, len = children.length; i < len; i++) {
      children[i]._onBatchCreated();
    }

    if (children.length > 0) {
      this._renderFlag |= RenderFlow.FLAG_CHILDREN;
    }

    if (CC_JSB && CC_NATIVERENDERER) {
      this._proxy.initNative();
    }
  },
  // the same as _onBatchCreated but untouch prefab
  _onBatchRestored: function _onBatchRestored() {
    this._upgrade_1x_to_2x(); // Fixed a bug where children and parent node groups were forced to synchronize, instead of only synchronizing `_cullingMask` value


    this._cullingMask = 1 << _getActualGroupIndex(this);

    if (CC_JSB && CC_NATIVERENDERER) {
      this._proxy && this._proxy.updateCullingMask();
    }

    ;

    if (!this._activeInHierarchy) {
      // deactivate ActionManager and EventManager by default
      // ActionManager may not be inited in the editor worker.
      var manager = cc.director.getActionManager();
      manager && manager.pauseTarget(this);
      eventManager.pauseTarget(this);
    }

    var children = this._children;

    for (var i = 0, len = children.length; i < len; i++) {
      children[i]._onBatchRestored();
    }

    if (children.length > 0) {
      this._renderFlag |= RenderFlow.FLAG_CHILDREN;
    }

    if (CC_JSB && CC_NATIVERENDERER) {
      this._proxy.initNative();
    }
  },
  // EVENT TARGET
  _checkListenerMask: function _checkListenerMask() {
    // Because Mask may be nested, need to find all the Mask components in the parent node. 
    // The click area must satisfy all Masks to trigger the click.
    if (this._touchListener) {
      var mask = this._touchListener.mask = _searchComponentsInParent(this, cc.Mask);

      if (this._mouseListener) {
        this._mouseListener.mask = mask;
      }
    } else if (this._mouseListener) {
      this._mouseListener.mask = _searchComponentsInParent(this, cc.Mask);
    }
  },
  _checknSetupSysEvent: function _checknSetupSysEvent(type) {
    var newAdded = false;
    var forDispatch = false;

    if (_touchEvents.indexOf(type) !== -1) {
      if (!this._touchListener) {
        this._touchListener = cc.EventListener.create({
          event: cc.EventListener.TOUCH_ONE_BY_ONE,
          swallowTouches: true,
          owner: this,
          mask: _searchComponentsInParent(this, cc.Mask),
          onTouchBegan: _touchStartHandler,
          onTouchMoved: _touchMoveHandler,
          onTouchEnded: _touchEndHandler,
          onTouchCancelled: _touchCancelHandler
        });
        eventManager.addListener(this._touchListener, this);
        newAdded = true;
      }

      forDispatch = true;
    } else if (_mouseEvents.indexOf(type) !== -1) {
      if (!this._mouseListener) {
        this._mouseListener = cc.EventListener.create({
          event: cc.EventListener.MOUSE,
          _previousIn: false,
          owner: this,
          mask: _searchComponentsInParent(this, cc.Mask),
          onMouseDown: _mouseDownHandler,
          onMouseMove: _mouseMoveHandler,
          onMouseUp: _mouseUpHandler,
          onMouseScroll: _mouseWheelHandler
        });
        eventManager.addListener(this._mouseListener, this);
        newAdded = true;
      }

      forDispatch = true;
    }

    if (newAdded && !this._activeInHierarchy) {
      cc.director.getScheduler().schedule(function () {
        if (!this._activeInHierarchy) {
          eventManager.pauseTarget(this);
        }
      }, this, 0, 0, 0, false);
    }

    return forDispatch;
  },

  /**
   * !#en
   * Register a callback of a specific event type on Node.<br/>
   * Use this method to register touch or mouse event permit propagation based on scene graph,<br/>
   * These kinds of event are triggered with dispatchEvent, the dispatch process has three steps:<br/>
   * 1. Capturing phase: dispatch in capture targets (`_getCapturingTargets`), e.g. parents in node tree, from root to the real target<br/>
   * 2. At target phase: dispatch to the listeners of the real target<br/>
   * 3. Bubbling phase: dispatch in bubble targets (`_getBubblingTargets`), e.g. parents in node tree, from the real target to root<br/>
   * In any moment of the dispatching process, it can be stopped via `event.stopPropagation()` or `event.stopPropagationImmidiate()`.<br/>
   * It's the recommended way to register touch/mouse event for Node,<br/>
   * please do not use cc.eventManager directly for Node.<br/>
   * You can also register custom event and use `emit` to trigger custom event on Node.<br/>
   * For such events, there won't be capturing and bubbling phase, your event will be dispatched directly to its listeners registered on the same node.<br/>
   * You can also pass event callback parameters with `emit` by passing parameters after `type`.
   * !#zh
   * 在节点上注册指定类型的回调函数，也可以设置 target 用于绑定响应函数的 this 对象。<br/>
   * 鼠标或触摸事件会被系统调用 dispatchEvent 方法触发，触发的过程包含三个阶段：<br/>
   * 1. 捕获阶段：派发事件给捕获目标（通过 `_getCapturingTargets` 获取），比如，节点树中注册了捕获阶段的父节点，从根节点开始派发直到目标节点。<br/>
   * 2. 目标阶段：派发给目标节点的监听器。<br/>
   * 3. 冒泡阶段：派发事件给冒泡目标（通过 `_getBubblingTargets` 获取），比如，节点树中注册了冒泡阶段的父节点，从目标节点开始派发直到根节点。<br/>
   * 同时您可以将事件派发到父节点或者通过调用 stopPropagation 拦截它。<br/>
   * 推荐使用这种方式来监听节点上的触摸或鼠标事件，请不要在节点上直接使用 cc.eventManager。<br/>
   * 你也可以注册自定义事件到节点上，并通过 emit 方法触发此类事件，对于这类事件，不会发生捕获冒泡阶段，只会直接派发给注册在该节点上的监听器<br/>
   * 你可以通过在 emit 方法调用时在 type 之后传递额外的参数作为事件回调的参数列表
   * @method on
   * @param {String|Node.EventType} type - A string representing the event type to listen for.<br>See {{#crossLink "Node/EventTyupe/POSITION_CHANGED"}}Node Events{{/crossLink}} for all builtin events.
   * @param {Function} callback - The callback that will be invoked when the event is dispatched. The callback is ignored if it is a duplicate (the callbacks are unique).
   * @param {Event|any} [callback.event] event or first argument when emit
   * @param {any} [callback.arg2] arg2
   * @param {any} [callback.arg3] arg3
   * @param {any} [callback.arg4] arg4
   * @param {any} [callback.arg5] arg5
   * @param {Object} [target] - The target (this object) to invoke the callback, can be null
   * @param {Boolean} [useCapture=false] - When set to true, the listener will be triggered at capturing phase which is ahead of the final target emit, otherwise it will be triggered during bubbling phase.
   * @return {Function} - Just returns the incoming callback so you can save the anonymous function easier.
   * @typescript
   * on<T extends Function>(type: string, callback: T, target?: any, useCapture?: boolean): T
   * @example
   * this.node.on(cc.Node.EventType.TOUCH_START, this.memberFunction, this);  // if "this" is component and the "memberFunction" declared in CCClass.
   * node.on(cc.Node.EventType.TOUCH_START, callback, this);
   * node.on(cc.Node.EventType.TOUCH_MOVE, callback, this);
   * node.on(cc.Node.EventType.TOUCH_END, callback, this);
   * node.on(cc.Node.EventType.TOUCH_CANCEL, callback, this);
   * node.on(cc.Node.EventType.ANCHOR_CHANGED, callback);
   * node.on(cc.Node.EventType.COLOR_CHANGED, callback);
   */
  on: function on(type, callback, target, useCapture) {
    var forDispatch = this._checknSetupSysEvent(type);

    if (forDispatch) {
      return this._onDispatch(type, callback, target, useCapture);
    } else {
      switch (type) {
        case EventType.POSITION_CHANGED:
          this._eventMask |= POSITION_ON;
          break;

        case EventType.SCALE_CHANGED:
          this._eventMask |= SCALE_ON;
          break;

        case EventType.ROTATION_CHANGED:
          this._eventMask |= ROTATION_ON;
          break;

        case EventType.SIZE_CHANGED:
          this._eventMask |= SIZE_ON;
          break;

        case EventType.ANCHOR_CHANGED:
          this._eventMask |= ANCHOR_ON;
          break;

        case EventType.COLOR_CHANGED:
          this._eventMask |= COLOR_ON;
          break;
      }

      if (!this._bubblingListeners) {
        this._bubblingListeners = new EventTarget();
      }

      return this._bubblingListeners.on(type, callback, target);
    }
  },

  /**
   * !#en
   * Register an callback of a specific event type on the Node,
   * the callback will remove itself after the first time it is triggered.
   * !#zh
   * 注册节点的特定事件类型回调，回调会在第一时间被触发后删除自身。
   *
   * @method once
   * @param {String} type - A string representing the event type to listen for.
   * @param {Function} callback - The callback that will be invoked when the event is dispatched.
   *                              The callback is ignored if it is a duplicate (the callbacks are unique).
   * @param {Event|any} [callback.event] event or first argument when emit
   * @param {any} [callback.arg2] arg2
   * @param {any} [callback.arg3] arg3
   * @param {any} [callback.arg4] arg4
   * @param {any} [callback.arg5] arg5
   * @param {Object} [target] - The target (this object) to invoke the callback, can be null
   * @typescript
   * once<T extends Function>(type: string, callback: T, target?: any, useCapture?: boolean): T
   * @example
   * node.once(cc.Node.EventType.ANCHOR_CHANGED, callback);
   */
  once: function once(type, callback, target, useCapture) {
    var forDispatch = this._checknSetupSysEvent(type);

    var listeners = null;

    if (forDispatch && useCapture) {
      listeners = this._capturingListeners = this._capturingListeners || new EventTarget();
    } else {
      listeners = this._bubblingListeners = this._bubblingListeners || new EventTarget();
    }

    listeners.once(type, callback, target);
  },
  _onDispatch: function _onDispatch(type, callback, target, useCapture) {
    // Accept also patameters like: (type, callback, useCapture)
    if (typeof target === 'boolean') {
      useCapture = target;
      target = undefined;
    } else useCapture = !!useCapture;

    if (!callback) {
      cc.errorID(6800);
      return;
    }

    var listeners = null;

    if (useCapture) {
      listeners = this._capturingListeners = this._capturingListeners || new EventTarget();
    } else {
      listeners = this._bubblingListeners = this._bubblingListeners || new EventTarget();
    }

    if (!listeners.hasEventListener(type, callback, target)) {
      listeners.on(type, callback, target);

      if (target && target.__eventTargets) {
        target.__eventTargets.push(this);
      }
    }

    return callback;
  },

  /**
   * !#en
   * Removes the callback previously registered with the same type, callback, target and or useCapture.
   * This method is merely an alias to removeEventListener.
   * !#zh 删除之前与同类型，回调，目标或 useCapture 注册的回调。
   * @method off
   * @param {String} type - A string representing the event type being removed.
   * @param {Function} [callback] - The callback to remove.
   * @param {Object} [target] - The target (this object) to invoke the callback, if it's not given, only callback without target will be removed
   * @param {Boolean} [useCapture=false] - When set to true, the listener will be triggered at capturing phase which is ahead of the final target emit, otherwise it will be triggered during bubbling phase.
   * @example
   * this.node.off(cc.Node.EventType.TOUCH_START, this.memberFunction, this);
   * node.off(cc.Node.EventType.TOUCH_START, callback, this.node);
   * node.off(cc.Node.EventType.ANCHOR_CHANGED, callback, this);
   */
  off: function off(type, callback, target, useCapture) {
    var touchEvent = _touchEvents.indexOf(type) !== -1;
    var mouseEvent = !touchEvent && _mouseEvents.indexOf(type) !== -1;

    if (touchEvent || mouseEvent) {
      this._offDispatch(type, callback, target, useCapture);

      if (touchEvent) {
        if (this._touchListener && !_checkListeners(this, _touchEvents)) {
          eventManager.removeListener(this._touchListener);
          this._touchListener = null;
        }
      } else if (mouseEvent) {
        if (this._mouseListener && !_checkListeners(this, _mouseEvents)) {
          eventManager.removeListener(this._mouseListener);
          this._mouseListener = null;
        }
      }
    } else if (this._bubblingListeners) {
      this._bubblingListeners.off(type, callback, target);

      var hasListeners = this._bubblingListeners.hasEventListener(type); // All listener removed


      if (!hasListeners) {
        switch (type) {
          case EventType.POSITION_CHANGED:
            this._eventMask &= ~POSITION_ON;
            break;

          case EventType.SCALE_CHANGED:
            this._eventMask &= ~SCALE_ON;
            break;

          case EventType.ROTATION_CHANGED:
            this._eventMask &= ~ROTATION_ON;
            break;

          case EventType.SIZE_CHANGED:
            this._eventMask &= ~SIZE_ON;
            break;

          case EventType.ANCHOR_CHANGED:
            this._eventMask &= ~ANCHOR_ON;
            break;

          case EventType.COLOR_CHANGED:
            this._eventMask &= ~COLOR_ON;
            break;
        }
      }
    }
  },
  _offDispatch: function _offDispatch(type, callback, target, useCapture) {
    // Accept also patameters like: (type, callback, useCapture)
    if (typeof target === 'boolean') {
      useCapture = target;
      target = undefined;
    } else useCapture = !!useCapture;

    if (!callback) {
      this._capturingListeners && this._capturingListeners.removeAll(type);
      this._bubblingListeners && this._bubblingListeners.removeAll(type);
    } else {
      var listeners = useCapture ? this._capturingListeners : this._bubblingListeners;

      if (listeners) {
        listeners.off(type, callback, target);

        if (target && target.__eventTargets) {
          js.array.fastRemove(target.__eventTargets, this);
        }
      }
    }
  },

  /**
   * !#en Removes all callbacks previously registered with the same target.
   * !#zh 移除目标上的所有注册事件。
   * @method targetOff
   * @param {Object} target - The target to be searched for all related callbacks
   * @example
   * node.targetOff(target);
   */
  targetOff: function targetOff(target) {
    var listeners = this._bubblingListeners;

    if (listeners) {
      listeners.targetOff(target); // Check for event mask reset

      if (this._eventMask & POSITION_ON && !listeners.hasEventListener(EventType.POSITION_CHANGED)) {
        this._eventMask &= ~POSITION_ON;
      }

      if (this._eventMask & SCALE_ON && !listeners.hasEventListener(EventType.SCALE_CHANGED)) {
        this._eventMask &= ~SCALE_ON;
      }

      if (this._eventMask & ROTATION_ON && !listeners.hasEventListener(EventType.ROTATION_CHANGED)) {
        this._eventMask &= ~ROTATION_ON;
      }

      if (this._eventMask & SIZE_ON && !listeners.hasEventListener(EventType.SIZE_CHANGED)) {
        this._eventMask &= ~SIZE_ON;
      }

      if (this._eventMask & ANCHOR_ON && !listeners.hasEventListener(EventType.ANCHOR_CHANGED)) {
        this._eventMask &= ~ANCHOR_ON;
      }

      if (this._eventMask & COLOR_ON && !listeners.hasEventListener(EventType.COLOR_CHANGED)) {
        this._eventMask &= ~COLOR_ON;
      }
    }

    if (this._capturingListeners) {
      this._capturingListeners.targetOff(target);
    }

    if (target && target.__eventTargets) {
      js.array.fastRemove(target.__eventTargets, this);
    }

    if (this._touchListener && !_checkListeners(this, _touchEvents)) {
      eventManager.removeListener(this._touchListener);
      this._touchListener = null;
    }

    if (this._mouseListener && !_checkListeners(this, _mouseEvents)) {
      eventManager.removeListener(this._mouseListener);
      this._mouseListener = null;
    }
  },

  /**
   * !#en Checks whether the EventTarget object has any callback registered for a specific type of event.
   * !#zh 检查事件目标对象是否有为特定类型的事件注册的回调。
   * @method hasEventListener
   * @param {String} type - The type of event.
   * @return {Boolean} True if a callback of the specified type is registered; false otherwise.
   */
  hasEventListener: function hasEventListener(type) {
    var has = false;

    if (this._bubblingListeners) {
      has = this._bubblingListeners.hasEventListener(type);
    }

    if (!has && this._capturingListeners) {
      has = this._capturingListeners.hasEventListener(type);
    }

    return has;
  },

  /**
   * !#en
   * Trigger an event directly with the event name and necessary arguments.
   * !#zh
   * 通过事件名发送自定义事件
   *
   * @method emit
   * @param {String} type - event type
   * @param {*} [arg1] - First argument in callback
   * @param {*} [arg2] - Second argument in callback
   * @param {*} [arg3] - Third argument in callback
   * @param {*} [arg4] - Fourth argument in callback
   * @param {*} [arg5] - Fifth argument in callback
   * @example
   * 
   * eventTarget.emit('fire', event);
   * eventTarget.emit('fire', message, emitter);
   */
  emit: function emit(type, arg1, arg2, arg3, arg4, arg5) {
    if (this._bubblingListeners) {
      this._bubblingListeners.emit(type, arg1, arg2, arg3, arg4, arg5);
    }
  },

  /**
   * !#en
   * Dispatches an event into the event flow.
   * The event target is the EventTarget object upon which the dispatchEvent() method is called.
   * !#zh 分发事件到事件流中。
   *
   * @method dispatchEvent
   * @param {Event} event - The Event object that is dispatched into the event flow
   */
  dispatchEvent: function dispatchEvent(event) {
    _doDispatchEvent(this, event);

    _cachedArray.length = 0;
  },

  /**
   * !#en Pause node related system events registered with the current Node. Node system events includes touch and mouse events.
   * If recursive is set to true, then this API will pause the node system events for the node and all nodes in its sub node tree.
   * Reference: http://docs.cocos2d-x.org/editors_and_tools/creator-chapters/scripting/internal-events/
   * !#zh 暂停当前节点上注册的所有节点系统事件，节点系统事件包含触摸和鼠标事件。
   * 如果传递 recursive 为 true，那么这个 API 将暂停本节点和它的子树上所有节点的节点系统事件。
   * 参考：https://www.cocos.com/docs/creator/scripting/internal-events.html
   * @method pauseSystemEvents
   * @param {Boolean} recursive - Whether to pause node system events on the sub node tree.
   * @example
   * node.pauseSystemEvents(true);
   */
  pauseSystemEvents: function pauseSystemEvents(recursive) {
    eventManager.pauseTarget(this, recursive);
  },

  /**
   * !#en Resume node related system events registered with the current Node. Node system events includes touch and mouse events.
   * If recursive is set to true, then this API will resume the node system events for the node and all nodes in its sub node tree.
   * Reference: http://docs.cocos2d-x.org/editors_and_tools/creator-chapters/scripting/internal-events/
   * !#zh 恢复当前节点上注册的所有节点系统事件，节点系统事件包含触摸和鼠标事件。
   * 如果传递 recursive 为 true，那么这个 API 将恢复本节点和它的子树上所有节点的节点系统事件。
   * 参考：https://www.cocos.com/docs/creator/scripting/internal-events.html
   * @method resumeSystemEvents
   * @param {Boolean} recursive - Whether to resume node system events on the sub node tree.
   * @example
   * node.resumeSystemEvents(true);
   */
  resumeSystemEvents: function resumeSystemEvents(recursive) {
    eventManager.resumeTarget(this, recursive);
  },
  _hitTest: function _hitTest(point, listener) {
    var w = this._contentSize.width,
        h = this._contentSize.height,
        cameraPt = _htVec3a,
        testPt = _htVec3b;
    var camera = cc.Camera.findCamera(this);

    if (camera) {
      camera.getScreenToWorldPoint(point, cameraPt);
    } else {
      cameraPt.set(point);
    }

    this._updateWorldMatrix(); // If scale is 0, it can't be hit.


    if (!_valueTypes.Mat4.invert(_mat4_temp, this._worldMatrix)) {
      return false;
    }

    _valueTypes.Vec2.transformMat4(testPt, cameraPt, _mat4_temp);

    testPt.x += this._anchorPoint.x * w;
    testPt.y += this._anchorPoint.y * h;
    var hit = false;

    if (testPt.x >= 0 && testPt.y >= 0 && testPt.x <= w && testPt.y <= h) {
      hit = true;

      if (listener && listener.mask) {
        var mask = listener.mask;
        var parent = this;
        var length = mask ? mask.length : 0; // find mask parent, should hit test it

        for (var i = 0, j = 0; parent && j < length; ++i, parent = parent.parent) {
          var temp = mask[j];

          if (i === temp.index) {
            if (parent === temp.node) {
              var comp = parent.getComponent(cc.Mask);

              if (comp && comp._enabled && !comp._hitTest(cameraPt)) {
                hit = false;
                break;
              }

              j++;
            } else {
              // mask parent no longer exists
              mask.length = j;
              break;
            }
          } else if (i > temp.index) {
            // mask parent no longer exists
            mask.length = j;
            break;
          }
        }
      }
    }

    return hit;
  },

  /**
   * Get all the targets listening to the supplied type of event in the target's capturing phase.
   * The capturing phase comprises the journey from the root to the last node BEFORE the event target's node.
   * The result should save in the array parameter, and MUST SORT from child nodes to parent nodes.
   *
   * Subclasses can override this method to make event propagable.
   * @method _getCapturingTargets
   * @private
   * @param {String} type - the event type
   * @param {Array} array - the array to receive targets
   * @example {@link cocos2d/core/event/_getCapturingTargets.js}
   */
  _getCapturingTargets: function _getCapturingTargets(type, array) {
    var parent = this.parent;

    while (parent) {
      if (parent._capturingListeners && parent._capturingListeners.hasEventListener(type)) {
        array.push(parent);
      }

      parent = parent.parent;
    }
  },

  /**
   * Get all the targets listening to the supplied type of event in the target's bubbling phase.
   * The bubbling phase comprises any SUBSEQUENT nodes encountered on the return trip to the root of the tree.
   * The result should save in the array parameter, and MUST SORT from child nodes to parent nodes.
   *
   * Subclasses can override this method to make event propagable.
   * @method _getBubblingTargets
   * @private
   * @param {String} type - the event type
   * @param {Array} array - the array to receive targets
   */
  _getBubblingTargets: function _getBubblingTargets(type, array) {
    var parent = this.parent;

    while (parent) {
      if (parent._bubblingListeners && parent._bubblingListeners.hasEventListener(type)) {
        array.push(parent);
      }

      parent = parent.parent;
    }
  },
  // ACTIONS

  /**
   * !#en
   * Executes an action, and returns the action that is executed.<br/>
   * The node becomes the action's target. Refer to cc.Action's getTarget() <br/>
   * Calling runAction while the node is not active won't have any effect. <br/>
   * Note：You shouldn't modify the action after runAction, that won't take any effect.<br/>
   * if you want to modify, when you define action plus.
   * !#zh
   * 执行并返回该执行的动作。该节点将会变成动作的目标。<br/>
   * 调用 runAction 时，节点自身处于不激活状态将不会有任何效果。<br/>
   * 注意：你不应该修改 runAction 后的动作，将无法发挥作用，如果想进行修改，请在定义 action 时加入。
   * @method runAction
   * @param {Action} action
   * @return {Action} An Action pointer
   * @example
   * var action = cc.scaleTo(0.2, 1, 0.6);
   * node.runAction(action);
   * node.runAction(action).repeatForever(); // fail
   * node.runAction(action.repeatForever()); // right
   */
  runAction: ActionManagerExist ? function (action) {
    if (!this.active) return;
    cc.assertID(action, 1618);
    var am = cc.director.getActionManager();

    if (!am._suppressDeprecation) {
      am._suppressDeprecation = true;
      cc.warnID(1639);
    }

    am.addAction(action, this, false);
    return action;
  } : emptyFunc,

  /**
   * !#en Pause all actions running on the current node. Equals to `cc.director.getActionManager().pauseTarget(node)`.
   * !#zh 暂停本节点上所有正在运行的动作。和 `cc.director.getActionManager().pauseTarget(node);` 等价。
   * @method pauseAllActions
   * @example
   * node.pauseAllActions();
   */
  pauseAllActions: ActionManagerExist ? function () {
    cc.director.getActionManager().pauseTarget(this);
  } : emptyFunc,

  /**
   * !#en Resume all paused actions on the current node. Equals to `cc.director.getActionManager().resumeTarget(node)`.
   * !#zh 恢复运行本节点上所有暂停的动作。和 `cc.director.getActionManager().resumeTarget(node);` 等价。
   * @method resumeAllActions
   * @example
   * node.resumeAllActions();
   */
  resumeAllActions: ActionManagerExist ? function () {
    cc.director.getActionManager().resumeTarget(this);
  } : emptyFunc,

  /**
   * !#en Stops and removes all actions from the running action list .
   * !#zh 停止并且移除所有正在运行的动作列表。
   * @method stopAllActions
   * @example
   * node.stopAllActions();
   */
  stopAllActions: ActionManagerExist ? function () {
    cc.director.getActionManager().removeAllActionsFromTarget(this);
  } : emptyFunc,

  /**
   * !#en Stops and removes an action from the running action list.
   * !#zh 停止并移除指定的动作。
   * @method stopAction
   * @param {Action} action An action object to be removed.
   * @example
   * var action = cc.scaleTo(0.2, 1, 0.6);
   * node.stopAction(action);
   */
  stopAction: ActionManagerExist ? function (action) {
    cc.director.getActionManager().removeAction(action);
  } : emptyFunc,

  /**
   * !#en Removes an action from the running action list by its tag.
   * !#zh 停止并且移除指定标签的动作。
   * @method stopActionByTag
   * @param {Number} tag A tag that indicates the action to be removed.
   * @example
   * node.stopActionByTag(1);
   */
  stopActionByTag: ActionManagerExist ? function (tag) {
    if (tag === cc.Action.TAG_INVALID) {
      cc.logID(1612);
      return;
    }

    cc.director.getActionManager().removeActionByTag(tag, this);
  } : emptyFunc,

  /**
   * !#en Returns an action from the running action list by its tag.
   * !#zh 通过标签获取指定动作。
   * @method getActionByTag
   * @see cc.Action#getTag and cc.Action#setTag
   * @param {Number} tag
   * @return {Action} The action object with the given tag.
   * @example
   * var action = node.getActionByTag(1);
   */
  getActionByTag: ActionManagerExist ? function (tag) {
    if (tag === cc.Action.TAG_INVALID) {
      cc.logID(1613);
      return null;
    }

    return cc.director.getActionManager().getActionByTag(tag, this);
  } : function () {
    return null;
  },

  /**
   * !#en
   * Returns the numbers of actions that are running plus the ones that are schedule to run (actions in actionsToAdd and actions arrays).<br/>
   *    Composable actions are counted as 1 action. Example:<br/>
   *    If you are running 1 Sequence of 7 actions, it will return 1. <br/>
   *    If you are running 7 Sequences of 2 actions, it will return 7.</p>
   * !#zh
   * 获取运行着的动作加上正在调度运行的动作的总数。<br/>
   * 例如：<br/>
   * - 如果你正在运行 7 个动作中的 1 个 Sequence，它将返回 1。<br/>
   * - 如果你正在运行 2 个动作中的 7 个 Sequence，它将返回 7。<br/>
   *
   * @method getNumberOfRunningActions
   * @return {Number} The number of actions that are running plus the ones that are schedule to run
   * @example
   * var count = node.getNumberOfRunningActions();
   * cc.log("Running Action Count: " + count);
   */
  getNumberOfRunningActions: ActionManagerExist ? function () {
    return cc.director.getActionManager().getNumberOfRunningActionsInTarget(this);
  } : function () {
    return 0;
  },
  // TRANSFORM RELATED

  /**
   * !#en
   * Returns a copy of the position (x, y, z) of the node in its parent's coordinates.
   * You can pass a cc.Vec2 or cc.Vec3 as the argument to receive the return values.
   * !#zh
   * 获取节点在父节点坐标系中的位置（x, y, z）。
   * 你可以传一个 cc.Vec2 或者 cc.Vec3 作为参数来接收返回值。
   * @method getPosition
   * @param {Vec2|Vec3} [out] - The return value to receive position
   * @return {Vec2|Vec3} The position (x, y, z) of the node in its parent's coordinates
   * @example
   * cc.log("Node Position: " + node.getPosition());
   */
  getPosition: function getPosition(out) {
    out = out || new _valueTypes.Vec3();
    return _valueTypes.Trs.toPosition(out, this._trs);
  },

  /**
   * !#en
   * Sets the position (x, y, z) of the node in its parent's coordinates.<br/>
   * Usually we use cc.v2(x, y) to compose cc.Vec2 object,<br/>
   * and passing two numbers (x, y) is more efficient than passing cc.Vec2 object.
   * For 3D node we can use cc.v3(x, y, z) to compose cc.Vec3 object,<br/>
   * and passing three numbers (x, y, z) is more efficient than passing cc.Vec3 object.
   * !#zh
   * 设置节点在父节点坐标系中的位置。<br/>
   * 可以通过下面的方式设置坐标点：<br/>
   * 1. 传入 2 个数值 x, y。<br/>
   * 2. 传入 cc.v2(x, y) 类型为 cc.Vec2 的对象。
   * 3. 对于 3D 节点可以传入 3 个数值 x, y, z。<br/>
   * 4. 对于 3D 节点可以传入 cc.v3(x, y, z) 类型为 cc.Vec3 的对象。
   * @method setPosition
   * @param {Vec2|Vec3|Number} newPosOrX - X coordinate for position or the position (x, y, z) of the node in coordinates
   * @param {Number} [y] - Y coordinate for position
   * @param {Number} [z] - Z coordinate for position
   */
  setPosition: function setPosition(newPosOrX, y, z) {
    var x;

    if (y === undefined) {
      x = newPosOrX.x;
      y = newPosOrX.y;
      z = newPosOrX.z || 0;
    } else {
      x = newPosOrX;
      z = z || 0;
    }

    var trs = this._trs;

    if (trs[0] === x && trs[1] === y && trs[2] === z) {
      return;
    }

    if (CC_EDITOR) {
      var oldPosition = new cc.Vec3(trs[0], trs[1], trs[2]);
    }

    trs[0] = x;
    trs[1] = y;
    trs[2] = z;
    this.setLocalDirty(LocalDirtyFlag.ALL_POSITION);
    !CC_NATIVERENDERER && (this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM); // fast check event

    if (this._eventMask & POSITION_ON) {
      if (CC_EDITOR) {
        this.emit(EventType.POSITION_CHANGED, oldPosition);
      } else {
        this.emit(EventType.POSITION_CHANGED);
      }
    }
  },

  /**
   * !#en
   * Returns the scale factor of the node.
   * Need pass a cc.Vec2 or cc.Vec3 as the argument to receive the return values.
   * !#zh 获取节点的缩放，需要传一个 cc.Vec2 或者 cc.Vec3 作为参数来接收返回值。
   * @method getScale
   * @param {Vec2|Vec3} out
   * @return {Vec2|Vec3} The scale factor
   * @example
   * cc.log("Node Scale: " + node.getScale(cc.v3()));
   */
  getScale: function getScale(out) {
    if (out !== undefined) {
      return _valueTypes.Trs.toScale(out, this._trs);
    } else {
      cc.errorID(1400, 'cc.Node.getScale', 'cc.Node.scale or cc.Node.getScale(cc.Vec3)');
      return this._trs[7];
    }
  },

  /**
   * !#en
   * Sets the scale of axis in local coordinates of the node.
   * You can operate 2 axis in 2D node, and 3 axis in 3D node.
   * !#zh
   * 设置节点在本地坐标系中坐标轴上的缩放比例。
   * 2D 节点可以操作两个坐标轴，而 3D 节点可以操作三个坐标轴。
   * @method setScale
   * @param {Number|Vec2|Vec3} x - scaleX or scale object
   * @param {Number} [y]
   * @param {Number} [z]
   * @example
   * node.setScale(cc.v2(2, 2));
   * node.setScale(cc.v3(2, 2, 2)); // for 3D node
   * node.setScale(2);
   */
  setScale: function setScale(x, y, z) {
    if (x && typeof x !== 'number') {
      y = x.y;
      z = x.z === undefined ? 1 : x.z;
      x = x.x;
    } else if (x !== undefined && y === undefined) {
      y = x;
      z = x;
    } else if (z === undefined) {
      z = 1;
    }

    var trs = this._trs;

    if (trs[7] !== x || trs[8] !== y || trs[9] !== z) {
      trs[7] = x;
      trs[8] = y;
      trs[9] = z;
      this.setLocalDirty(LocalDirtyFlag.ALL_SCALE);
      !CC_NATIVERENDERER && (this._renderFlag |= RenderFlow.FLAG_TRANSFORM);

      if (this._eventMask & SCALE_ON) {
        this.emit(EventType.SCALE_CHANGED);
      }
    }
  },

  /**
   * !#en
   * Get rotation of node (in quaternion).
   * Need pass a cc.Quat as the argument to receive the return values.
   * !#zh
   * 获取该节点的 quaternion 旋转角度，需要传一个 cc.Quat 作为参数来接收返回值。
   * @method getRotation
   * @param {Quat} out
   * @return {Quat} Quaternion object represents the rotation
   */
  getRotation: function getRotation(out) {
    if (out instanceof _valueTypes.Quat) {
      return _valueTypes.Trs.toRotation(out, this._trs);
    } else {
      if (CC_DEBUG) {
        cc.warn("`cc.Node.getRotation()` is deprecated since v2.1.0, please use `-cc.Node.angle` instead. (`this.node.getRotation()` -> `-this.node.angle`)");
      }

      return -this.angle;
    }
  },

  /**
   * !#en Set rotation of node (in quaternion).
   * !#zh 设置该节点的 quaternion 旋转角度。
   * @method setRotation
   * @param {cc.Quat|Number} quat Quaternion object represents the rotation or the x value of quaternion
   * @param {Number} [y] y value of quternion
   * @param {Number} [z] z value of quternion
   * @param {Number} [w] w value of quternion
   */
  setRotation: function setRotation(rotation, y, z, w) {
    if (typeof rotation === 'number' && y === undefined) {
      if (CC_DEBUG) {
        cc.warn("`cc.Node.setRotation(degree)` is deprecated since v2.1.0, please set `-cc.Node.angle` instead. (`this.node.setRotation(x)` -> `this.node.angle = -x`)");
      }

      this.angle = -rotation;
    } else {
      var x = rotation;

      if (y === undefined) {
        x = rotation.x;
        y = rotation.y;
        z = rotation.z;
        w = rotation.w;
      }

      var trs = this._trs;

      if (trs[3] !== x || trs[4] !== y || trs[5] !== z || trs[6] !== w) {
        trs[3] = x;
        trs[4] = y;
        trs[5] = z;
        trs[6] = w;
        this.setLocalDirty(LocalDirtyFlag.ALL_ROTATION);

        if (this._eventMask & ROTATION_ON) {
          this.emit(EventType.ROTATION_CHANGED);
        }

        if (CC_EDITOR) {
          this._toEuler();
        }
      }
    }
  },

  /**
   * !#en
   * Returns a copy the untransformed size of the node. <br/>
   * The contentSize remains the same no matter the node is scaled or rotated.<br/>
   * All nodes has a size. Layer and Scene has the same size of the screen by default. <br/>
   * !#zh 获取节点自身大小，不受该节点是否被缩放或者旋转的影响。
   * @method getContentSize
   * @return {Size} The untransformed size of the node.
   * @example
   * cc.log("Content Size: " + node.getContentSize());
   */
  getContentSize: function getContentSize() {
    return cc.size(this._contentSize.width, this._contentSize.height);
  },

  /**
   * !#en
   * Sets the untransformed size of the node.<br/>
   * The contentSize remains the same no matter the node is scaled or rotated.<br/>
   * All nodes has a size. Layer and Scene has the same size of the screen.
   * !#zh 设置节点原始大小，不受该节点是否被缩放或者旋转的影响。
   * @method setContentSize
   * @param {Size|Number} size - The untransformed size of the node or The untransformed size's width of the node.
   * @param {Number} [height] - The untransformed size's height of the node.
   * @example
   * node.setContentSize(cc.size(100, 100));
   * node.setContentSize(100, 100);
   */
  setContentSize: function setContentSize(size, height) {
    var locContentSize = this._contentSize;
    var clone;

    if (height === undefined) {
      if (size.width === locContentSize.width && size.height === locContentSize.height) return;

      if (CC_EDITOR) {
        clone = cc.size(locContentSize.width, locContentSize.height);
      }

      locContentSize.width = size.width;
      locContentSize.height = size.height;
    } else {
      if (size === locContentSize.width && height === locContentSize.height) return;

      if (CC_EDITOR) {
        clone = cc.size(locContentSize.width, locContentSize.height);
      }

      locContentSize.width = size;
      locContentSize.height = height;
    }

    if (this._eventMask & SIZE_ON) {
      if (CC_EDITOR) {
        this.emit(EventType.SIZE_CHANGED, clone);
      } else {
        this.emit(EventType.SIZE_CHANGED);
      }
    }
  },

  /**
   * !#en
   * Returns a copy of the anchor point.<br/>
   * Anchor point is the point around which all transformations and positioning manipulations take place.<br/>
   * It's like a pin in the node where it is "attached" to its parent. <br/>
   * The anchorPoint is normalized, like a percentage. (0,0) means the bottom-left corner and (1,1) means the top-right corner. <br/>
   * But you can use values higher than (1,1) and lower than (0,0) too.  <br/>
   * The default anchor point is (0.5,0.5), so it starts at the center of the node.
   * !#zh
   * 获取节点锚点，用百分比表示。<br/>
   * 锚点应用于所有变换和坐标点的操作，它就像在节点上连接其父节点的大头针。<br/>
   * 锚点是标准化的，就像百分比一样。(0，0) 表示左下角，(1，1) 表示右上角。<br/>
   * 但是你可以使用比（1，1）更高的值或者比（0，0）更低的值。<br/>
   * 默认的锚点是（0.5，0.5），因此它开始于节点的中心位置。<br/>
   * 注意：Creator 中的锚点仅用于定位所在的节点，子节点的定位不受影响。
   * @method getAnchorPoint
   * @return {Vec2} The anchor point of node.
   * @example
   * cc.log("Node AnchorPoint: " + node.getAnchorPoint());
   */
  getAnchorPoint: function getAnchorPoint() {
    return cc.v2(this._anchorPoint);
  },

  /**
   * !#en
   * Sets the anchor point in percent. <br/>
   * anchor point is the point around which all transformations and positioning manipulations take place. <br/>
   * It's like a pin in the node where it is "attached" to its parent. <br/>
   * The anchorPoint is normalized, like a percentage. (0,0) means the bottom-left corner and (1,1) means the top-right corner.<br/>
   * But you can use values higher than (1,1) and lower than (0,0) too.<br/>
   * The default anchor point is (0.5,0.5), so it starts at the center of the node.
   * !#zh
   * 设置锚点的百分比。<br/>
   * 锚点应用于所有变换和坐标点的操作，它就像在节点上连接其父节点的大头针。<br/>
   * 锚点是标准化的，就像百分比一样。(0，0) 表示左下角，(1，1) 表示右上角。<br/>
   * 但是你可以使用比（1，1）更高的值或者比（0，0）更低的值。<br/>
   * 默认的锚点是（0.5，0.5），因此它开始于节点的中心位置。<br/>
   * 注意：Creator 中的锚点仅用于定位所在的节点，子节点的定位不受影响。
   * @method setAnchorPoint
   * @param {Vec2|Number} point - The anchor point of node or The x axis anchor of node.
   * @param {Number} [y] - The y axis anchor of node.
   * @example
   * node.setAnchorPoint(cc.v2(1, 1));
   * node.setAnchorPoint(1, 1);
   */
  setAnchorPoint: function setAnchorPoint(point, y) {
    var locAnchorPoint = this._anchorPoint;

    if (y === undefined) {
      if (point.x === locAnchorPoint.x && point.y === locAnchorPoint.y) return;
      locAnchorPoint.x = point.x;
      locAnchorPoint.y = point.y;
    } else {
      if (point === locAnchorPoint.x && y === locAnchorPoint.y) return;
      locAnchorPoint.x = point;
      locAnchorPoint.y = y;
    }

    this.setLocalDirty(LocalDirtyFlag.ALL_POSITION);

    if (this._eventMask & ANCHOR_ON) {
      this.emit(EventType.ANCHOR_CHANGED);
    }
  },

  /*
   * Transforms position from world space to local space.
   * @method _invTransformPoint
   * @param {Vec3} out
   * @param {Vec3} vec3
   */
  _invTransformPoint: function _invTransformPoint(out, pos) {
    if (this._parent) {
      this._parent._invTransformPoint(out, pos);
    } else {
      _valueTypes.Vec3.copy(out, pos);
    }

    var ltrs = this._trs; // out = parent_inv_pos - pos

    _valueTypes.Trs.toPosition(_tpVec3a, ltrs);

    _valueTypes.Vec3.sub(out, out, _tpVec3a); // out = inv(rot) * out


    _valueTypes.Trs.toRotation(_tpQuata, ltrs);

    _valueTypes.Quat.conjugate(_tpQuatb, _tpQuata);

    _valueTypes.Vec3.transformQuat(out, out, _tpQuatb); // out = (1/scale) * out


    _valueTypes.Trs.toScale(_tpVec3a, ltrs);

    _valueTypes.Vec3.inverseSafe(_tpVec3b, _tpVec3a);

    _valueTypes.Vec3.mul(out, out, _tpVec3b);

    return out;
  },

  /*
   * Calculate and return world position.
   * This is not a public API yet, its usage could be updated
   * @method getWorldPosition
   * @param {Vec3} out
   * @return {Vec3}
   */
  getWorldPosition: function getWorldPosition(out) {
    _valueTypes.Trs.toPosition(out, this._trs);

    var curr = this._parent;
    var ltrs;

    while (curr) {
      ltrs = curr._trs; // out = parent_scale * pos

      _valueTypes.Trs.toScale(_gwpVec3, ltrs);

      _valueTypes.Vec3.mul(out, out, _gwpVec3); // out = parent_quat * out


      _valueTypes.Trs.toRotation(_gwpQuat, ltrs);

      _valueTypes.Vec3.transformQuat(out, out, _gwpQuat); // out = out + pos


      _valueTypes.Trs.toPosition(_gwpVec3, ltrs);

      _valueTypes.Vec3.add(out, out, _gwpVec3);

      curr = curr._parent;
    }

    return out;
  },

  /*
   * Set world position.
   * This is not a public API yet, its usage could be updated
   * @method setWorldPosition
   * @param {Vec3} pos
   */
  setWorldPosition: function setWorldPosition(pos) {
    var ltrs = this._trs;

    if (CC_EDITOR) {
      var oldPosition = new cc.Vec3(ltrs[0], ltrs[1], ltrs[2]);
    } // NOTE: this is faster than invert world matrix and transform the point


    if (this._parent) {
      this._parent._invTransformPoint(_swpVec3, pos);
    } else {
      _valueTypes.Vec3.copy(_swpVec3, pos);
    }

    _valueTypes.Trs.fromPosition(ltrs, _swpVec3);

    this.setLocalDirty(LocalDirtyFlag.ALL_POSITION); // fast check event

    if (this._eventMask & POSITION_ON) {
      // send event
      if (CC_EDITOR) {
        this.emit(EventType.POSITION_CHANGED, oldPosition);
      } else {
        this.emit(EventType.POSITION_CHANGED);
      }
    }
  },

  /*
   * Calculate and return world rotation
   * This is not a public API yet, its usage could be updated
   * @method getWorldRotation
   * @param {Quat} out
   * @return {Quat}
   */
  getWorldRotation: function getWorldRotation(out) {
    _valueTypes.Trs.toRotation(_gwrQuat, this._trs);

    _valueTypes.Quat.copy(out, _gwrQuat);

    var curr = this._parent;

    while (curr) {
      _valueTypes.Trs.toRotation(_gwrQuat, curr._trs);

      _valueTypes.Quat.mul(out, _gwrQuat, out);

      curr = curr._parent;
    }

    return out;
  },

  /*
   * Set world rotation with quaternion
   * This is not a public API yet, its usage could be updated
   * @method setWorldRotation
   * @param {Quat} val
   */
  setWorldRotation: function setWorldRotation(val) {
    if (this._parent) {
      this._parent.getWorldRotation(_swrQuat);

      _valueTypes.Quat.conjugate(_swrQuat, _swrQuat);

      _valueTypes.Quat.mul(_swrQuat, _swrQuat, val);
    } else {
      _valueTypes.Quat.copy(_swrQuat, val);
    }

    _valueTypes.Trs.fromRotation(this._trs, _swrQuat);

    if (CC_EDITOR) {
      this._toEuler();
    }

    this.setLocalDirty(LocalDirtyFlag.ALL_ROTATION);
  },

  /*
   * Calculate and return world scale
   * This is not a public API yet, its usage could be updated
   * @method getWorldScale
   * @param {Vec3} out
   * @return {Vec3}
   */
  getWorldScale: function getWorldScale(out) {
    _valueTypes.Trs.toScale(_gwsVec3, this._trs);

    _valueTypes.Vec3.copy(out, _gwsVec3);

    var curr = this._parent;

    while (curr) {
      _valueTypes.Trs.toScale(_gwsVec3, curr._trs);

      _valueTypes.Vec3.mul(out, out, _gwsVec3);

      curr = curr._parent;
    }

    return out;
  },

  /*
   * Set world scale with vec3
   * This is not a public API yet, its usage could be updated
   * @method setWorldScale
   * @param {Vec3} scale
   */
  setWorldScale: function setWorldScale(scale) {
    if (this._parent) {
      this._parent.getWorldScale(_swsVec3);

      _valueTypes.Vec3.div(_swsVec3, scale, _swsVec3);
    } else {
      _valueTypes.Vec3.copy(_swsVec3, scale);
    }

    _valueTypes.Trs.fromScale(this._trs, _swsVec3);

    this.setLocalDirty(LocalDirtyFlag.ALL_SCALE);
  },
  getWorldRT: function getWorldRT(out) {
    var opos = _gwrtVec3a;
    var orot = _gwrtQuata;
    var ltrs = this._trs;

    _valueTypes.Trs.toPosition(opos, ltrs);

    _valueTypes.Trs.toRotation(orot, ltrs);

    var curr = this._parent;

    while (curr) {
      ltrs = curr._trs; // opos = parent_lscale * lpos

      _valueTypes.Trs.toScale(_gwrtVec3b, ltrs);

      _valueTypes.Vec3.mul(opos, opos, _gwrtVec3b); // opos = parent_lrot * opos


      _valueTypes.Trs.toRotation(_gwrtQuatb, ltrs);

      _valueTypes.Vec3.transformQuat(opos, opos, _gwrtQuatb); // opos = opos + lpos


      _valueTypes.Trs.toPosition(_gwrtVec3b, ltrs);

      _valueTypes.Vec3.add(opos, opos, _gwrtVec3b); // orot = lrot * orot


      _valueTypes.Quat.mul(orot, _gwrtQuatb, orot);

      curr = curr._parent;
    }

    _valueTypes.Mat4.fromRT(out, orot, opos);

    return out;
  },

  /**
   * !#en Set rotation by lookAt target point, normally used by Camera Node
   * !#zh 通过观察目标来设置 rotation，一般用于 Camera Node 上
   * @method lookAt
   * @param {Vec3} pos
   * @param {Vec3} [up] - default is (0,1,0)
   */
  lookAt: function lookAt(pos, up) {
    this.getWorldPosition(_laVec3);

    _valueTypes.Vec3.sub(_laVec3, _laVec3, pos); // NOTE: we use -z for view-dir


    _valueTypes.Vec3.normalize(_laVec3, _laVec3);

    _valueTypes.Quat.fromViewUp(_laQuat, _laVec3, up);

    this.setWorldRotation(_laQuat);
  },
  _updateLocalMatrix: updateLocalMatrix2D,
  _calculWorldMatrix: function _calculWorldMatrix() {
    // Avoid as much function call as possible
    if (this._localMatDirty & LocalDirtyFlag.TRSS) {
      this._updateLocalMatrix();
    } // Assume parent world matrix is correct


    var parent = this._parent;

    if (parent) {
      this._mulMat(this._worldMatrix, parent._worldMatrix, this._matrix);
    } else {
      _valueTypes.Mat4.copy(this._worldMatrix, this._matrix);
    }

    this._worldMatDirty = false;
  },
  _mulMat: mulMat2D,
  _updateWorldMatrix: function _updateWorldMatrix() {
    if (this._parent) {
      this._parent._updateWorldMatrix();
    }

    if (this._worldMatDirty) {
      this._calculWorldMatrix(); // Sync dirty to children


      var children = this._children;

      for (var i = 0, l = children.length; i < l; i++) {
        children[i]._worldMatDirty = true;
      }
    }
  },
  setLocalDirty: function setLocalDirty(flag) {
    this._localMatDirty |= flag;
    this._worldMatDirty = true;

    if (flag === LocalDirtyFlag.ALL_POSITION || flag === LocalDirtyFlag.POSITION) {
      this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
    } else {
      this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
    }
  },
  setWorldDirty: function setWorldDirty() {
    this._worldMatDirty = true;
  },

  /**
   * !#en
   * Get the local transform matrix (4x4), based on parent node coordinates
   * !#zh 返回局部空间坐标系的矩阵，基于父节点坐标系。
   * @method getLocalMatrix
   * @param {Mat4} out The matrix object to be filled with data
   * @return {Mat4} Same as the out matrix object
   * @example
   * let mat4 = cc.mat4();
   * node.getLocalMatrix(mat4);
   */
  getLocalMatrix: function getLocalMatrix(out) {
    this._updateLocalMatrix();

    return _valueTypes.Mat4.copy(out, this._matrix);
  },

  /**
   * !#en
   * Get the world transform matrix (4x4)
   * !#zh 返回世界空间坐标系的矩阵。
   * @method getWorldMatrix
   * @param {Mat4} out The matrix object to be filled with data
   * @return {Mat4} Same as the out matrix object
   * @example
   * let mat4 = cc.mat4();
   * node.getWorldMatrix(mat4);
   */
  getWorldMatrix: function getWorldMatrix(out) {
    this._updateWorldMatrix();

    return _valueTypes.Mat4.copy(out, this._worldMatrix);
  },

  /**
   * !#en
   * Converts a Point to node (local) space coordinates.
   * !#zh
   * 将一个点转换到节点 (局部) 空间坐标系。
   * @method convertToNodeSpaceAR
   * @param {Vec3|Vec2} worldPoint
   * @param {Vec3|Vec2} [out]
   * @return {Vec3|Vec2}
   * @typescript
   * convertToNodeSpaceAR<T extends cc.Vec2 | cc.Vec3>(worldPoint: T, out?: T): T
   * @example
   * var newVec2 = node.convertToNodeSpaceAR(cc.v2(100, 100));
   * var newVec3 = node.convertToNodeSpaceAR(cc.v3(100, 100, 100));
   */
  convertToNodeSpaceAR: function convertToNodeSpaceAR(worldPoint, out) {
    this._updateWorldMatrix();

    _valueTypes.Mat4.invert(_mat4_temp, this._worldMatrix);

    if (worldPoint instanceof cc.Vec2) {
      out = out || new cc.Vec2();
      return _valueTypes.Vec2.transformMat4(out, worldPoint, _mat4_temp);
    } else {
      out = out || new cc.Vec3();
      return _valueTypes.Vec3.transformMat4(out, worldPoint, _mat4_temp);
    }
  },

  /**
   * !#en
   * Converts a Point in node coordinates to world space coordinates.
   * !#zh
   * 将节点坐标系下的一个点转换到世界空间坐标系。
   * @method convertToWorldSpaceAR
   * @param {Vec3|Vec2} nodePoint
   * @param {Vec3|Vec2} [out]
   * @return {Vec3|Vec2}
   * @typescript
   * convertToWorldSpaceAR<T extends cc.Vec2 | cc.Vec3>(nodePoint: T, out?: T): T
   * @example
   * var newVec2 = node.convertToWorldSpaceAR(cc.v2(100, 100));
   * var newVec3 = node.convertToWorldSpaceAR(cc.v3(100, 100, 100));
   */
  convertToWorldSpaceAR: function convertToWorldSpaceAR(nodePoint, out) {
    this._updateWorldMatrix();

    if (nodePoint instanceof cc.Vec2) {
      out = out || new cc.Vec2();
      return _valueTypes.Vec2.transformMat4(out, nodePoint, this._worldMatrix);
    } else {
      out = out || new cc.Vec3();
      return _valueTypes.Vec3.transformMat4(out, nodePoint, this._worldMatrix);
    }
  },
  // OLD TRANSFORM ACCESS APIs

  /**
      * !#en Converts a Point to node (local) space coordinates then add the anchor point position.
      * So the return position will be related to the left bottom corner of the node's bounding box.
      * This equals to the API behavior of cocos2d-x, you probably want to use convertToNodeSpaceAR instead
      * !#zh 将一个点转换到节点 (局部) 坐标系，并加上锚点的坐标。<br/>
      * 也就是说返回的坐标是相对于节点包围盒左下角的坐标。<br/>
      * 这个 API 的设计是为了和 cocos2d-x 中行为一致，更多情况下你可能需要使用 convertToNodeSpaceAR。
      * @method convertToNodeSpace
      * @deprecated since v2.1.3
      * @param {Vec2} worldPoint
      * @return {Vec2}
      * @example
      * var newVec2 = node.convertToNodeSpace(cc.v2(100, 100));
      */
  convertToNodeSpace: function convertToNodeSpace(worldPoint) {
    this._updateWorldMatrix();

    _valueTypes.Mat4.invert(_mat4_temp, this._worldMatrix);

    var out = new cc.Vec2();

    _valueTypes.Vec2.transformMat4(out, worldPoint, _mat4_temp);

    out.x += this._anchorPoint.x * this._contentSize.width;
    out.y += this._anchorPoint.y * this._contentSize.height;
    return out;
  },

  /**
   * !#en Converts a Point related to the left bottom corner of the node's bounding box to world space coordinates.
   * This equals to the API behavior of cocos2d-x, you probably want to use convertToWorldSpaceAR instead
   * !#zh 将一个相对于节点左下角的坐标位置转换到世界空间坐标系。
   * 这个 API 的设计是为了和 cocos2d-x 中行为一致，更多情况下你可能需要使用 convertToWorldSpaceAR
   * @method convertToWorldSpace
   * @deprecated since v2.1.3
   * @param {Vec2} nodePoint
   * @return {Vec2}
   * @example
   * var newVec2 = node.convertToWorldSpace(cc.v2(100, 100));
   */
  convertToWorldSpace: function convertToWorldSpace(nodePoint) {
    this._updateWorldMatrix();

    var out = new cc.Vec2(nodePoint.x - this._anchorPoint.x * this._contentSize.width, nodePoint.y - this._anchorPoint.y * this._contentSize.height);
    return _valueTypes.Vec2.transformMat4(out, out, this._worldMatrix);
  },

  /**
   * !#en
   * Returns the matrix that transform the node's (local) space coordinates into the parent's space coordinates.<br/>
   * The matrix is in Pixels.
   * !#zh 返回这个将节点（局部）的空间坐标系转换成父节点的空间坐标系的矩阵。这个矩阵以像素为单位。
   * @method getNodeToParentTransform
   * @deprecated since v2.0
   * @param {AffineTransform} [out] The affine transform object to be filled with data
   * @return {AffineTransform} Same as the out affine transform object
   * @example
   * let affineTransform = cc.AffineTransform.create();
   * node.getNodeToParentTransform(affineTransform);
   */
  getNodeToParentTransform: function getNodeToParentTransform(out) {
    if (!out) {
      out = AffineTrans.identity();
    }

    this._updateLocalMatrix();

    var contentSize = this._contentSize;
    _vec3_temp.x = -this._anchorPoint.x * contentSize.width;
    _vec3_temp.y = -this._anchorPoint.y * contentSize.height;

    _valueTypes.Mat4.copy(_mat4_temp, this._matrix);

    _valueTypes.Mat4.transform(_mat4_temp, _mat4_temp, _vec3_temp);

    return AffineTrans.fromMat4(out, _mat4_temp);
  },

  /**
   * !#en
   * Returns the matrix that transform the node's (local) space coordinates into the parent's space coordinates.<br/>
   * The matrix is in Pixels.<br/>
   * This method is AR (Anchor Relative).
   * !#zh
   * 返回这个将节点（局部）的空间坐标系转换成父节点的空间坐标系的矩阵。<br/>
   * 这个矩阵以像素为单位。<br/>
   * 该方法基于节点坐标。
   * @method getNodeToParentTransformAR
   * @deprecated since v2.0
   * @param {AffineTransform} [out] The affine transform object to be filled with data
   * @return {AffineTransform} Same as the out affine transform object
   * @example
   * let affineTransform = cc.AffineTransform.create();
   * node.getNodeToParentTransformAR(affineTransform);
   */
  getNodeToParentTransformAR: function getNodeToParentTransformAR(out) {
    if (!out) {
      out = AffineTrans.identity();
    }

    this._updateLocalMatrix();

    return AffineTrans.fromMat4(out, this._matrix);
  },

  /**
   * !#en Returns the world affine transform matrix. The matrix is in Pixels.
   * !#zh 返回节点到世界坐标系的仿射变换矩阵。矩阵单位是像素。
   * @method getNodeToWorldTransform
   * @deprecated since v2.0
   * @param {AffineTransform} [out] The affine transform object to be filled with data
   * @return {AffineTransform} Same as the out affine transform object
   * @example
   * let affineTransform = cc.AffineTransform.create();
   * node.getNodeToWorldTransform(affineTransform);
   */
  getNodeToWorldTransform: function getNodeToWorldTransform(out) {
    if (!out) {
      out = AffineTrans.identity();
    }

    this._updateWorldMatrix();

    var contentSize = this._contentSize;
    _vec3_temp.x = -this._anchorPoint.x * contentSize.width;
    _vec3_temp.y = -this._anchorPoint.y * contentSize.height;

    _valueTypes.Mat4.copy(_mat4_temp, this._worldMatrix);

    _valueTypes.Mat4.transform(_mat4_temp, _mat4_temp, _vec3_temp);

    return AffineTrans.fromMat4(out, _mat4_temp);
  },

  /**
   * !#en
   * Returns the world affine transform matrix. The matrix is in Pixels.<br/>
   * This method is AR (Anchor Relative).
   * !#zh
   * 返回节点到世界坐标仿射变换矩阵。矩阵单位是像素。<br/>
   * 该方法基于节点坐标。
   * @method getNodeToWorldTransformAR
   * @deprecated since v2.0
   * @param {AffineTransform} [out] The affine transform object to be filled with data
   * @return {AffineTransform} Same as the out affine transform object
   * @example
   * let affineTransform = cc.AffineTransform.create();
   * node.getNodeToWorldTransformAR(affineTransform);
   */
  getNodeToWorldTransformAR: function getNodeToWorldTransformAR(out) {
    if (!out) {
      out = AffineTrans.identity();
    }

    this._updateWorldMatrix();

    return AffineTrans.fromMat4(out, this._worldMatrix);
  },

  /**
   * !#en
   * Returns the matrix that transform parent's space coordinates to the node's (local) space coordinates.<br/>
   * The matrix is in Pixels. The returned transform is readonly and cannot be changed.
   * !#zh
   * 返回将父节点的坐标系转换成节点（局部）的空间坐标系的矩阵。<br/>
   * 该矩阵以像素为单位。返回的矩阵是只读的，不能更改。
   * @method getParentToNodeTransform
   * @deprecated since v2.0
   * @param {AffineTransform} [out] The affine transform object to be filled with data
   * @return {AffineTransform} Same as the out affine transform object
   * @example
   * let affineTransform = cc.AffineTransform.create();
   * node.getParentToNodeTransform(affineTransform);
   */
  getParentToNodeTransform: function getParentToNodeTransform(out) {
    if (!out) {
      out = AffineTrans.identity();
    }

    this._updateLocalMatrix();

    _valueTypes.Mat4.invert(_mat4_temp, this._matrix);

    return AffineTrans.fromMat4(out, _mat4_temp);
  },

  /**
   * !#en Returns the inverse world affine transform matrix. The matrix is in Pixels.
   * !#en 返回世界坐标系到节点坐标系的逆矩阵。
   * @method getWorldToNodeTransform
   * @deprecated since v2.0
   * @param {AffineTransform} [out] The affine transform object to be filled with data
   * @return {AffineTransform} Same as the out affine transform object
   * @example
   * let affineTransform = cc.AffineTransform.create();
   * node.getWorldToNodeTransform(affineTransform);
   */
  getWorldToNodeTransform: function getWorldToNodeTransform(out) {
    if (!out) {
      out = AffineTrans.identity();
    }

    this._updateWorldMatrix();

    _valueTypes.Mat4.invert(_mat4_temp, this._worldMatrix);

    return AffineTrans.fromMat4(out, _mat4_temp);
  },

  /**
   * !#en convenience methods which take a cc.Touch instead of cc.Vec2.
   * !#zh 将触摸点转换成本地坐标系中位置。
   * @method convertTouchToNodeSpace
   * @deprecated since v2.0
   * @param {Touch} touch - The touch object
   * @return {Vec2}
   * @example
   * var newVec2 = node.convertTouchToNodeSpace(touch);
   */
  convertTouchToNodeSpace: function convertTouchToNodeSpace(touch) {
    return this.convertToNodeSpace(touch.getLocation());
  },

  /**
   * !#en converts a cc.Touch (world coordinates) into a local coordinate. This method is AR (Anchor Relative).
   * !#zh 转换一个 cc.Touch（世界坐标）到一个局部坐标，该方法基于节点坐标。
   * @method convertTouchToNodeSpaceAR
   * @deprecated since v2.0
   * @param {Touch} touch - The touch object
   * @return {Vec2}
   * @example
   * var newVec2 = node.convertTouchToNodeSpaceAR(touch);
   */
  convertTouchToNodeSpaceAR: function convertTouchToNodeSpaceAR(touch) {
    return this.convertToNodeSpaceAR(touch.getLocation());
  },

  /**
   * !#en
   * Returns a "local" axis aligned bounding box of the node. <br/>
   * The returned box is relative only to its parent.
   * !#zh 返回父节坐标系下的轴向对齐的包围盒。
   * @method getBoundingBox
   * @return {Rect} The calculated bounding box of the node
   * @example
   * var boundingBox = node.getBoundingBox();
   */
  getBoundingBox: function getBoundingBox() {
    this._updateLocalMatrix();

    var width = this._contentSize.width;
    var height = this._contentSize.height;
    var rect = cc.rect(-this._anchorPoint.x * width, -this._anchorPoint.y * height, width, height);
    return rect.transformMat4(rect, this._matrix);
  },

  /**
   * !#en
   * Returns a "world" axis aligned bounding box of the node.<br/>
   * The bounding box contains self and active children's world bounding box.
   * !#zh
   * 返回节点在世界坐标系下的对齐轴向的包围盒（AABB）。<br/>
   * 该边框包含自身和已激活的子节点的世界边框。
   * @method getBoundingBoxToWorld
   * @return {Rect}
   * @example
   * var newRect = node.getBoundingBoxToWorld();
   */
  getBoundingBoxToWorld: function getBoundingBoxToWorld() {
    if (this._parent) {
      this._parent._updateWorldMatrix();

      return this._getBoundingBoxTo();
    } else {
      return this.getBoundingBox();
    }
  },
  _getBoundingBoxTo: function _getBoundingBoxTo() {
    var width = this._contentSize.width;
    var height = this._contentSize.height;
    var rect = cc.rect(-this._anchorPoint.x * width, -this._anchorPoint.y * height, width, height);

    this._calculWorldMatrix();

    rect.transformMat4(rect, this._worldMatrix); //query child's BoundingBox

    if (!this._children) return rect;
    var locChildren = this._children;

    for (var i = 0; i < locChildren.length; i++) {
      var child = locChildren[i];

      if (child && child.active) {
        var childRect = child._getBoundingBoxTo();

        if (childRect) rect.union(rect, childRect);
      }
    }

    return rect;
  },
  _updateOrderOfArrival: function _updateOrderOfArrival() {
    var arrivalOrder = this._parent ? ++this._parent._childArrivalOrder : 0;
    this._localZOrder = this._localZOrder & 0xffff0000 | arrivalOrder;
    this.emit(EventType.SIBLING_ORDER_CHANGED);
  },

  /**
   * !#en
   * Adds a child to the node with z order and name.
   * !#zh
   * 添加子节点，并且可以修改该节点的 局部 Z 顺序和名字。
   * @method addChild
   * @param {Node} child - A child node
   * @param {Number} [zIndex] - Z order for drawing priority. Please refer to zIndex property
   * @param {String} [name] - A name to identify the node easily. Please refer to name property
   * @example
   * node.addChild(newNode, 1, "node");
   */
  addChild: function addChild(child, zIndex, name) {
    if (CC_DEV && !cc.Node.isNode(child)) {
      return cc.errorID(1634, cc.js.getClassName(child));
    }

    cc.assertID(child, 1606);
    cc.assertID(child._parent === null, 1605); // invokes the parent setter

    child.parent = this;

    if (zIndex !== undefined) {
      child.zIndex = zIndex;
    }

    if (name !== undefined) {
      child.name = name;
    }
  },

  /**
   * !#en Stops all running actions and schedulers.
   * !#zh 停止所有正在播放的动作和计时器。
   * @method cleanup
   * @example
   * node.cleanup();
   */
  cleanup: function cleanup() {
    // actions
    ActionManagerExist && cc.director.getActionManager().removeAllActionsFromTarget(this); // event

    eventManager.removeListeners(this); // children

    var i,
        len = this._children.length,
        node;

    for (i = 0; i < len; ++i) {
      node = this._children[i];
      if (node) node.cleanup();
    }
  },

  /**
   * !#en Sorts the children array depends on children's zIndex and arrivalOrder,
   * normally you won't need to invoke this function.
   * !#zh 根据子节点的 zIndex 和 arrivalOrder 进行排序，正常情况下开发者不需要手动调用这个函数。
   *
   * @method sortAllChildren
   */
  sortAllChildren: function sortAllChildren() {
    if (this._reorderChildDirty) {
      this._reorderChildDirty = false; // delay update arrivalOrder before sort children

      var _children = this._children,
          child; // reset arrivalOrder before sort children

      this._childArrivalOrder = 1;

      for (var i = 0, len = _children.length; i < len; i++) {
        child = _children[i];

        child._updateOrderOfArrival();
      } // Optimize reordering event code to fix problems with setting zindex
      // https://github.com/cocos-creator/2d-tasks/issues/1186


      eventManager._setDirtyForNode(this);

      if (_children.length > 1) {
        // insertion sort
        var j, child;

        for (var _i = 1, _len = _children.length; _i < _len; _i++) {
          child = _children[_i];
          j = _i - 1; //continue moving element downwards while zOrder is smaller or when zOrder is the same but mutatedIndex is smaller

          while (j >= 0) {
            if (child._localZOrder < _children[j]._localZOrder) {
              _children[j + 1] = _children[j];
            } else {
              break;
            }

            j--;
          }

          _children[j + 1] = child;
        }

        this.emit(EventType.CHILD_REORDER, this);
      }

      cc.director.__fastOff(cc.Director.EVENT_AFTER_UPDATE, this.sortAllChildren, this);
    }
  },
  _delaySort: function _delaySort() {
    if (!this._reorderChildDirty) {
      this._reorderChildDirty = true;

      cc.director.__fastOn(cc.Director.EVENT_AFTER_UPDATE, this.sortAllChildren, this);
    }
  },
  _restoreProperties: CC_EDITOR && function () {
    /*
     * TODO: Refine this code after completing undo/redo 2.0.
     * The node will be destroyed when deleting in the editor,
     * but it will be reserved and reused for undo.
    */
    // restore 3d node
    this.is3DNode = this.is3DNode;

    if (!this._matrix) {
      this._matrix = cc.mat4(this._spaceInfo.localMat);

      _valueTypes.Mat4.identity(this._matrix);
    }

    if (!this._worldMatrix) {
      this._worldMatrix = cc.mat4(this._spaceInfo.worldMat);

      _valueTypes.Mat4.identity(this._worldMatrix);
    }

    this._localMatDirty = LocalDirtyFlag.ALL;
    this._worldMatDirty = true;

    this._fromEuler();

    this._renderFlag |= RenderFlow.FLAG_TRANSFORM;

    if (this._renderComponent) {
      this._renderComponent.markForRender(true);
    }

    if (this._children.length > 0) {
      this._renderFlag |= RenderFlow.FLAG_CHILDREN;
    }
  },
  onRestore: CC_EDITOR && function () {
    this._onRestoreBase();

    this._restoreProperties();

    var actionManager = cc.director.getActionManager();

    if (this._activeInHierarchy) {
      actionManager && actionManager.resumeTarget(this);
      eventManager.resumeTarget(this);
    } else {
      actionManager && actionManager.pauseTarget(this);
      eventManager.pauseTarget(this);
    }
  }
};

if (CC_EDITOR) {
  // deprecated, only used to import old data in editor
  js.mixin(NodeDefines.properties, {
    _scaleX: {
      "default": undefined,
      type: cc.Float,
      editorOnly: true
    },
    _scaleY: {
      "default": undefined,
      type: cc.Float,
      editorOnly: true
    }
  });
}

var Node = cc.Class(NodeDefines); // 3D Node Property
// Node Event

/**
 * !#en
 * The position changing event, you can listen to this event through the statement this.node.on(cc.Node.EventType.POSITION_CHANGED, callback, this);
 * !#zh
 * 位置变动监听事件, 通过 this.node.on(cc.Node.EventType.POSITION_CHANGED, callback, this); 进行监听。
 * @event position-changed
 * @param {Vec2} oldPos - The old position, but this parameter is only available in editor!
 */

/**
 * !#en
 * The size changing event, you can listen to this event through the statement this.node.on(cc.Node.EventType.SIZE_CHANGED, callback, this);
 * !#zh
 * 尺寸变动监听事件，通过 this.node.on(cc.Node.EventType.SIZE_CHANGED, callback, this); 进行监听。
 * @event size-changed
 * @param {Size} oldSize - The old size, but this parameter is only available in editor!
 */

/**
 * !#en
 * The anchor changing event, you can listen to this event through the statement this.node.on(cc.Node.EventType.ANCHOR_CHANGED, callback, this);
 * !#zh
 * 锚点变动监听事件，通过 this.node.on(cc.Node.EventType.ANCHOR_CHANGED, callback, this); 进行监听。
 * @event anchor-changed
 */

/**
 * !#en
 * The adding child event, you can listen to this event through the statement this.node.on(cc.Node.EventType.CHILD_ADDED, callback, this);
 * !#zh
 * 增加子节点监听事件，通过 this.node.on(cc.Node.EventType.CHILD_ADDED, callback, this); 进行监听。
 * @event child-added
 * @param {Node} child - child which have been added
 */

/**
 * !#en
 * The removing child event, you can listen to this event through the statement this.node.on(cc.Node.EventType.CHILD_REMOVED, callback, this);
 * !#zh
 * 删除子节点监听事件，通过 this.node.on(cc.Node.EventType.CHILD_REMOVED, callback, this); 进行监听。
 * @event child-removed
 * @param {Node} child - child which have been removed
 */

/**
 * !#en
 * The reordering child event, you can listen to this event through the statement this.node.on(cc.Node.EventType.CHILD_REORDER, callback, this);
 * !#zh
 * 子节点顺序变动监听事件，通过 this.node.on(cc.Node.EventType.CHILD_REORDER, callback, this); 进行监听。
 * @event child-reorder
 * @param {Node} node - node whose children have been reordered
 */

/**
 * !#en
 * The group changing event, you can listen to this event through the statement this.node.on(cc.Node.EventType.GROUP_CHANGED, callback, this);
 * !#zh
 * 节点分组变动监听事件，通过 this.node.on(cc.Node.EventType.GROUP_CHANGED, callback, this); 进行监听。
 * @event group-changed
 * @param {Node} node - node whose group has changed
 */
// Deprecated APIs

/**
 * !#en
 * Returns the displayed opacity of Node,
 * the difference between displayed opacity and opacity is that displayed opacity is calculated based on opacity and parent node's opacity when cascade opacity enabled.
 * !#zh
 * 获取节点显示透明度，
 * 显示透明度和透明度之间的不同之处在于当启用级连透明度时，
 * 显示透明度是基于自身透明度和父节点透明度计算的。
 *
 * @method getDisplayedOpacity
 * @return {number} displayed opacity
 * @deprecated since v2.0, please use opacity property, cascade opacity is removed
 */

/**
 * !#en
 * Returns the displayed color of Node,
 * the difference between displayed color and color is that displayed color is calculated based on color and parent node's color when cascade color enabled.
 * !#zh
 * 获取节点的显示颜色，
 * 显示颜色和颜色之间的不同之处在于当启用级连颜色时，
 * 显示颜色是基于自身颜色和父节点颜色计算的。
 *
 * @method getDisplayedColor
 * @return {Color}
 * @deprecated since v2.0, please use color property, cascade color is removed
 */

/**
 * !#en Cascade opacity is removed from v2.0
 * Indicate whether node's opacity value affect its child nodes, default value is true.
 * !#zh 透明度级联功能从 v2.0 开始已移除
 * 节点的不透明度值是否影响其子节点，默认值为 true。
 * @property cascadeOpacity
 * @deprecated since v2.0
 * @type {Boolean}
 */

/**
 * !#en Cascade opacity is removed from v2.0
 * Returns whether node's opacity value affect its child nodes.
 * !#zh 透明度级联功能从 v2.0 开始已移除
 * 返回节点的不透明度值是否影响其子节点。
 * @method isCascadeOpacityEnabled
 * @deprecated since v2.0
 * @return {Boolean}
 */

/**
 * !#en Cascade opacity is removed from v2.0
 * Enable or disable cascade opacity, if cascade enabled, child nodes' opacity will be the multiplication of parent opacity and its own opacity.
 * !#zh 透明度级联功能从 v2.0 开始已移除
 * 启用或禁用级连不透明度，如果级连启用，子节点的不透明度将是父不透明度乘上它自己的不透明度。
 * @method setCascadeOpacityEnabled
 * @deprecated since v2.0
 * @param {Boolean} cascadeOpacityEnabled
 */

/**
 * !#en Opacity modify RGB have been removed since v2.0
 * Set whether color should be changed with the opacity value,
 * useless in ccsg.Node, but this function is override in some class to have such behavior.
 * !#zh 透明度影响颜色配置已经被废弃
 * 设置更改透明度时是否修改RGB值，
 * @method setOpacityModifyRGB
 * @deprecated since v2.0
 * @param {Boolean} opacityValue
 */

/**
 * !#en Opacity modify RGB have been removed since v2.0
 * Get whether color should be changed with the opacity value.
 * !#zh 透明度影响颜色配置已经被废弃
 * 获取更改透明度时是否修改RGB值。
 * @method isOpacityModifyRGB
 * @deprecated since v2.0
 * @return {Boolean}
 */

var _p = Node.prototype;
js.getset(_p, 'position', _p.getPosition, _p.setPosition, false, true);

if (CC_EDITOR) {
  var vec3_tmp = new _valueTypes.Vec3();
  cc.js.getset(_p, 'worldEulerAngles', function () {
    var angles = new _valueTypes.Vec3(this._eulerAngles);
    var parent = this.parent;

    while (parent) {
      angles.addSelf(parent._eulerAngles);
      parent = parent.parent;
    }

    return angles;
  }, function (v) {
    vec3_tmp.set(v);
    var parent = this.parent;

    while (parent) {
      vec3_tmp.subSelf(parent._eulerAngles);
      parent = parent.parent;
    }

    this.eulerAngles = vec3_tmp;
  });
}

cc.Node = module.exports = Node;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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