
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/skeleton/CCSkinnedMeshRenderer.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

var _mat = _interopRequireDefault(require("../../value-types/mat4"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos.com

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var Skeleton = require('./CCSkeleton');

var MeshRenderer = require('../../mesh/CCMeshRenderer');

var RenderFlow = require('../../renderer/render-flow');

var enums = require('../../../renderer/enums');

var _m4_tmp = cc.mat4();

var _m4_tmp2 = cc.mat4();
/**
 * !#en
 * Skinned Mesh Renderer
 * !#zh
 * 蒙皮渲染组件
 * @class SkinnedMeshRenderer
 */


var SkinnedMeshRenderer = cc.Class({
  name: 'cc.SkinnedMeshRenderer',
  "extends": MeshRenderer,
  editor: CC_EDITOR && {
    menu: 'i18n:MAIN_MENU.component.mesh/Skinned Mesh Renderer'
  },
  ctor: function ctor() {
    this._jointsData = this._jointsFloat32Data = null;
    this._jointsTexture = null;
    this._joints = [];
    this._dummyNode = new cc.Node();
    this._jointsTextureOptions = null;
    this._usingRGBA8Texture = false;
  },
  properties: {
    _skeleton: Skeleton,
    _rootBone: cc.Node,

    /**
     * !#en
     * Skeleton Asset
     * !#zh
     * 骨骼资源
     * @property {Skeleton} skeleton
     */
    skeleton: {
      get: function get() {
        return this._skeleton;
      },
      set: function set(val) {
        this._skeleton = val;

        this._init();
      },
      type: Skeleton
    },

    /**
     * !#en
     * Root Bone
     * !#zh
     * 骨骼根节点
     * @property {Node} rootBone
     */
    rootBone: {
      get: function get() {
        return this._rootBone;
      },
      set: function set(val) {
        this._rootBone = val;

        this._init();
      },
      type: cc.Node
    },
    // SkinnedMeshRenderer cannot batch
    enableAutoBatch: {
      get: function get() {
        return false;
      },
      visible: false,
      override: true
    }
  },
  __preload: function __preload() {
    this._super();

    this._init();
  },
  _init: function _init() {
    this._model = this._skeleton && this._skeleton.model;
    this._calFunc = null;

    this._initJoints();

    this._initJointsTexture();

    this._initCalcFunc();

    this._updateRenderNode();
  },
  _calcWorldMatrixToRoot: function _calcWorldMatrixToRoot(joint) {
    var worldMatrixToRoot = joint._worldMatrixToRoot;

    if (!worldMatrixToRoot) {
      joint._worldMatrixToRoot = worldMatrixToRoot = cc.mat4();
      joint.getLocalMatrix(worldMatrixToRoot);
    } else {
      return;
    }

    var parent = joint.parent;

    if (parent !== this.rootBone) {
      if (!parent._worldMatrixToRoot) {
        this._calcWorldMatrixToRoot(parent);
      }

      _mat["default"].mul(worldMatrixToRoot, parent._worldMatrixToRoot, worldMatrixToRoot);
    }
  },
  _validateRender: function _validateRender() {
    if (!this._jointsData) {
      this.disableRender();
      return;
    }

    this._super();
  },
  _initJoints: function _initJoints() {
    var joints = this._joints;
    joints.length = 0;
    if (!this.skeleton || !this.rootBone) return;

    var useJointMatrix = this._useJointMatrix();

    var jointPaths = this.skeleton.jointPaths;
    var rootBone = this.rootBone;

    for (var i = 0; i < jointPaths.length; i++) {
      var joint = cc.find(jointPaths[i], rootBone);

      if (!joint) {
        cc.warn('Can not find joint in root bone [%s] with path [%s]', rootBone.name, jointPaths[i]);
      }

      if (useJointMatrix) {
        joint._renderFlag &= ~RenderFlow.FLAG_CHILDREN;

        this._calcWorldMatrixToRoot(joint);
      }

      joints.push(joint);
    }

    if (useJointMatrix) {
      var uniqueBindPoses = this.skeleton.uniqueBindPoses;

      for (var _i = 0; _i < jointPaths.length; _i++) {
        var _joint = joints[_i];

        if (uniqueBindPoses[_i]) {
          _mat["default"].mul(_m4_tmp, _joint._worldMatrixToRoot, uniqueBindPoses[_i]);

          _joint._jointMatrix = _mat["default"].toArray([], _m4_tmp);
        } else {
          _joint._jointMatrix = _joint._worldMatrixToRoot;
        }
      }
    }
  },
  _initJointsTexture: function _initJointsTexture() {
    if (!this._skeleton) return;
    var jointCount = this._joints.length;
    var inited = false;

    if (jointCount <= cc.sys.getMaxJointMatrixSize()) {
      inited = true;
      this._jointsData = this._jointsFloat32Data = new Float32Array(jointCount * 16);
    }

    if (!inited) {
      var SUPPORT_FLOAT_TEXTURE = !!cc.sys.glExtension('OES_texture_float');
      var size;

      if (jointCount > 256) {
        size = 64;
      } else if (jointCount > 64) {
        size = 32;
      } else if (jointCount > 16) {
        size = 16;
      } else {
        size = 8;
      }

      this._jointsData = this._jointsFloat32Data = new Float32Array(size * size * 4);
      var pixelFormat = cc.Texture2D.PixelFormat.RGBA32F,
          width = size,
          height = size;

      if (!SUPPORT_FLOAT_TEXTURE) {
        this._jointsData = new Uint8Array(this._jointsFloat32Data.buffer);
        pixelFormat = cc.Texture2D.PixelFormat.RGBA8888;
        width *= 4;
        this._usingRGBA8Texture = true;
        cc.warn("SkinnedMeshRenderer [" + this.node.name + "] has too many joints [" + jointCount + "] and device do not support float32 texture, fallback to use RGBA8888 texture, which is much slower.");
      }

      var texture = this._jointsTexture || new cc.Texture2D();
      var NEAREST = cc.Texture2D.Filter.NEAREST;
      texture.setFilters(NEAREST, NEAREST);
      texture.initWithData(this._jointsData, pixelFormat, width, height);
      this._jointsTexture = texture;
      this._jointsTextureOptions = {
        format: pixelFormat,
        width: texture.width,
        height: texture.height,
        images: []
      };
    }

    this._updateMaterial();
  },
  _updateMaterial: function _updateMaterial() {
    MeshRenderer.prototype._updateMaterial.call(this);

    var materials = this.getMaterials();

    for (var i = 0; i < materials.length; i++) {
      var material = materials[i];

      if (this._jointsTexture) {
        material.setProperty('jointsTexture', this._jointsTexture);
        material.setProperty('jointsTextureSize', new Float32Array([this._jointsTexture.width, this._jointsTexture.height]));
        material.define('CC_JOINTS_TEXTURE_FLOAT32', !!cc.sys.glExtension('OES_texture_float'));
        material.define('CC_USE_JOINTS_TEXTRUE', true);
      } else {
        if (this._jointsFloat32Data) {
          material.setProperty('jointMatrices', this._jointsFloat32Data, undefined, true);
        }

        material.define('CC_USE_JOINTS_TEXTRUE', false);
      }

      material.define('CC_USE_SKINNING', true);
    }
  },
  _setJointsDataWithArray: function _setJointsDataWithArray(iMatrix, matrixArray) {
    var data = this._jointsFloat32Data;
    data.set(matrixArray, iMatrix * 16);
  },
  _setJointsDataWithMatrix: function _setJointsDataWithMatrix(iMatrix, matrix) {
    this._jointsFloat32Data.set(matrix.m, 16 * iMatrix);
  },
  _commitJointsData: function _commitJointsData() {
    if (this._jointsTexture) {
      this._jointsTextureOptions.images[0] = this._jointsData;

      this._jointsTexture.update(this._jointsTextureOptions);
    }
  },
  _useJointMatrix: function _useJointMatrix() {
    return this._model && this._model.precomputeJointMatrix;
  },
  _updateRenderNode: function _updateRenderNode() {
    if (this._useJointMatrix() || this._usingRGBA8Texture) {
      this._assembler.setRenderNode(this.rootBone);
    } else {
      this._assembler.setRenderNode(this._dummyNode);
    }
  },
  _initCalcFunc: function _initCalcFunc() {
    if (this._useJointMatrix()) {
      this._calFunc = this._calJointMatrix;
    } else if (this._usingRGBA8Texture) {
      this._calFunc = this._calRGBA8WorldMatrix;
    } else {
      this._calFunc = this._calWorldMatrix;
    }
  },
  _calJointMatrix: function _calJointMatrix() {
    var joints = this._joints;
    var bindposes = this.skeleton.bindposes;
    var uniqueBindPoses = this.skeleton.uniqueBindPoses;

    for (var i = 0; i < joints.length; ++i) {
      var joint = joints[i];
      var jointMatrix = joint._jointMatrix;

      if (uniqueBindPoses[i]) {
        this._setJointsDataWithArray(i, jointMatrix);
      } else {
        _mat["default"].multiply(_m4_tmp, jointMatrix, bindposes[i]);

        this._setJointsDataWithMatrix(i, _m4_tmp);
      }
    }
  },
  // Some device rgba8 texture precision is low, when encode a big number it may loss precision.
  // Invert root bone matrix can effectively avoid big position encode into rgba8 texture.
  _calRGBA8WorldMatrix: function _calRGBA8WorldMatrix() {
    var joints = this._joints;
    var bindposes = this.skeleton.bindposes;

    this.rootBone._updateWorldMatrix();

    var rootMatrix = this.rootBone._worldMatrix;

    var invRootMat = _mat["default"].invert(_m4_tmp2, rootMatrix);

    for (var i = 0; i < joints.length; ++i) {
      var joint = joints[i];

      joint._updateWorldMatrix();

      _mat["default"].multiply(_m4_tmp, invRootMat, joint._worldMatrix);

      _mat["default"].multiply(_m4_tmp, _m4_tmp, bindposes[i]);

      this._setJointsDataWithMatrix(i, _m4_tmp);
    }
  },
  _calWorldMatrix: function _calWorldMatrix() {
    var joints = this._joints;
    var bindposes = this.skeleton.bindposes;

    for (var i = 0; i < joints.length; ++i) {
      var joint = joints[i];

      joint._updateWorldMatrix();

      _mat["default"].multiply(_m4_tmp, joint._worldMatrix, bindposes[i]);

      this._setJointsDataWithMatrix(i, _m4_tmp);
    }
  },
  calcJointMatrix: function calcJointMatrix() {
    if (!this.skeleton || !this.rootBone) return;

    this._calFunc.call(this);

    this._commitJointsData();
  }
});
cc.SkinnedMeshRenderer = module.exports = SkinnedMeshRenderer;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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