
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/skeleton/CCSkeletonAnimationClip.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

var _mat = _interopRequireDefault(require("../../value-types/mat4"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos.com

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var AnimationClip = require('../../../animation/animation-clip');

var JointMatrixCurve = require('./CCJointMatrixCurve');

function maxtrixToArray(matrix) {
  var data = new Float32Array(16);
  data.set(matrix.m);
  return data;
}
/**
* @module cc
*/

/**
 * !#en SkeletonAnimationClip Asset.
 * !#zh 骨骼动画剪辑。
 * @class SkeletonAnimationClip
 * @extends AnimationClip
 */


var SkeletonAnimationClip = cc.Class({
  name: 'cc.SkeletonAnimationClip',
  "extends": AnimationClip,
  properties: {
    _nativeAsset: {
      override: true,
      get: function get() {
        return this._buffer;
      },
      set: function set(bin) {
        var buffer = ArrayBuffer.isView(bin) ? bin.buffer : bin;
        this._buffer = new Float32Array(buffer || bin, 0, buffer.byteLength / 4);
      }
    },

    /**
     * Describe the data structure.
     * { path: { offset, frameCount, property } }
     */
    description: {
      "default": null,
      type: Object
    },

    /**
     * SkeletonAnimationClip's curveData is generated from binary buffer.
     * So should not serialize curveData.
     */
    curveData: {
      visible: false,
      override: true,
      get: function get() {
        return this._curveData || {};
      },
      set: function set() {}
    }
  },
  statics: {
    preventDeferredLoadDependents: true
  },
  _init: function _init() {
    if (this._curveData) {
      return this._curveData;
    }

    this._curveData = {};

    this._generateCommonCurve();

    if (this._model.precomputeJointMatrix) {
      this._generateJointMatrixCurve();
    }

    return this._curveData;
  },
  _generateCommonCurve: function _generateCommonCurve() {
    var buffer = this._buffer;
    var description = this.description;
    var offset = 0;

    function getValue() {
      return buffer[offset++];
    }

    if (!this._curveData.paths) {
      this._curveData.paths = {};
    }

    var paths = this._curveData.paths;

    for (var path in description) {
      var des = description[path];
      var curves = {};
      paths[path] = {
        props: curves
      };

      for (var property in des) {
        var frames = [];
        var frameCount = des[property].frameCount;
        offset = des[property].offset;

        for (var i = 0; i < frameCount; i++) {
          var frame = getValue();
          var value = void 0;

          if (property === 'position' || property === 'scale') {
            value = cc.v3(getValue(), getValue(), getValue());
          } else if (property === 'quat') {
            value = cc.quat(getValue(), getValue(), getValue(), getValue());
          }

          frames.push({
            frame: frame,
            value: value
          });
        }

        curves[property] = frames;
      }
    }
  },
  _generateJointMatrixCurve: function _generateJointMatrixCurve() {
    var rootNode = this._model.rootNode;
    var curveData = this._curveData;
    var paths = curveData.paths;
    var newCurveData = {
      ratios: [],
      jointMatrixMap: {}
    };
    var jointMatrixMap = newCurveData.jointMatrixMap; // walk through node tree to calculate node's joint matrix at time.

    function walk(node, time, pm) {
      var matrix;
      var EPSILON = 10e-5;
      var path = paths[node.path];

      if (node !== rootNode && path) {
        var props = path.props;

        for (var prop in props) {
          var frames = props[prop];

          for (var i = 0; i < frames.length; i++) {
            var end = frames[i];

            if (Math.abs(end.frame - time) < EPSILON) {
              node[prop].set(end.value);
              break;
            } else if (end.frame > time) {
              var start = frames[i - 1];
              var ratio = (time - start.frame) / (end.frame - start.frame);
              start.value.lerp(end.value, ratio, node[prop]);
              break;
            }
          }
        }

        matrix = cc.mat4();

        _mat["default"].fromRTS(matrix, node.quat, node.position, node.scale);

        if (pm) {
          _mat["default"].mul(matrix, pm, matrix);
        }

        if (!props._jointMatrix) {
          props._jointMatrix = [];
        }

        var bindWorldMatrix;

        if (node.uniqueBindPose) {
          bindWorldMatrix = cc.mat4();

          _mat["default"].mul(bindWorldMatrix, matrix, node.uniqueBindPose);
        }

        if (!jointMatrixMap[node.path]) {
          jointMatrixMap[node.path] = [];
        }

        if (bindWorldMatrix) {
          jointMatrixMap[node.path].push(maxtrixToArray(bindWorldMatrix));
        } else {
          jointMatrixMap[node.path].push(matrix);
        }
      }

      var children = node.children;

      for (var name in children) {
        var child = children[name];
        walk(child, time, matrix);
      }
    }

    var time = 0;
    var duration = this.duration;
    var step = 1 / this.sample;

    while (time < duration) {
      newCurveData.ratios.push(time / duration);
      walk(rootNode, time);
      time += step;
    }

    this._curveData = newCurveData;
  },
  _createJointMatrixCurve: function _createJointMatrixCurve(state, root) {
    var curve = new JointMatrixCurve();
    curve.ratios = this.curveData.ratios;
    curve.pairs = [];
    var jointMatrixMap = this.curveData.jointMatrixMap;

    for (var path in jointMatrixMap) {
      var target = cc.find(path, root);
      if (!target) continue;
      curve.pairs.push({
        target: target,
        values: jointMatrixMap[path]
      });
    }

    return [curve];
  },
  createCurves: function createCurves(state, root) {
    if (!this._model) {
      cc.warn("Skeleton Animation Clip [" + this.name + "] Can not find model");
      return [];
    }

    this._init();

    if (this._model.precomputeJointMatrix) {
      return this._createJointMatrixCurve(state, root);
    } else {
      return AnimationClip.prototype.createCurves.call(this, state, root);
    }
  }
});
cc.SkeletonAnimationClip = module.exports = SkeletonAnimationClip;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvY29jb3MyZC9jb3JlLzNkL3NrZWxldG9uL0NDU2tlbGV0b25BbmltYXRpb25DbGlwLmpzIl0sIm5hbWVzIjpbIkFuaW1hdGlvbkNsaXAiLCJyZXF1aXJlIiwiSm9pbnRNYXRyaXhDdXJ2ZSIsIm1heHRyaXhUb0FycmF5IiwibWF0cml4IiwiZGF0YSIsIkZsb2F0MzJBcnJheSIsInNldCIsIm0iLCJTa2VsZXRvbkFuaW1hdGlvbkNsaXAiLCJjYyIsIkNsYXNzIiwibmFtZSIsInByb3BlcnRpZXMiLCJfbmF0aXZlQXNzZXQiLCJvdmVycmlkZSIsImdldCIsIl9idWZmZXIiLCJiaW4iLCJidWZmZXIiLCJBcnJheUJ1ZmZlciIsImlzVmlldyIsImJ5dGVMZW5ndGgiLCJkZXNjcmlwdGlvbiIsInR5cGUiLCJPYmplY3QiLCJjdXJ2ZURhdGEiLCJ2aXNpYmxlIiwiX2N1cnZlRGF0YSIsInN0YXRpY3MiLCJwcmV2ZW50RGVmZXJyZWRMb2FkRGVwZW5kZW50cyIsIl9pbml0IiwiX2dlbmVyYXRlQ29tbW9uQ3VydmUiLCJfbW9kZWwiLCJwcmVjb21wdXRlSm9pbnRNYXRyaXgiLCJfZ2VuZXJhdGVKb2ludE1hdHJpeEN1cnZlIiwib2Zmc2V0IiwiZ2V0VmFsdWUiLCJwYXRocyIsInBhdGgiLCJkZXMiLCJjdXJ2ZXMiLCJwcm9wcyIsInByb3BlcnR5IiwiZnJhbWVzIiwiZnJhbWVDb3VudCIsImkiLCJmcmFtZSIsInZhbHVlIiwidjMiLCJxdWF0IiwicHVzaCIsInJvb3ROb2RlIiwibmV3Q3VydmVEYXRhIiwicmF0aW9zIiwiam9pbnRNYXRyaXhNYXAiLCJ3YWxrIiwibm9kZSIsInRpbWUiLCJwbSIsIkVQU0lMT04iLCJwcm9wIiwibGVuZ3RoIiwiZW5kIiwiTWF0aCIsImFicyIsInN0YXJ0IiwicmF0aW8iLCJsZXJwIiwibWF0NCIsIk1hdDQiLCJmcm9tUlRTIiwicG9zaXRpb24iLCJzY2FsZSIsIm11bCIsIl9qb2ludE1hdHJpeCIsImJpbmRXb3JsZE1hdHJpeCIsInVuaXF1ZUJpbmRQb3NlIiwiY2hpbGRyZW4iLCJjaGlsZCIsImR1cmF0aW9uIiwic3RlcCIsInNhbXBsZSIsIl9jcmVhdGVKb2ludE1hdHJpeEN1cnZlIiwic3RhdGUiLCJyb290IiwiY3VydmUiLCJwYWlycyIsInRhcmdldCIsImZpbmQiLCJ2YWx1ZXMiLCJjcmVhdGVDdXJ2ZXMiLCJ3YXJuIiwicHJvdG90eXBlIiwiY2FsbCIsIm1vZHVsZSIsImV4cG9ydHMiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7QUF5QkE7Ozs7QUF6QkE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQTJCQSxJQUFNQSxhQUFhLEdBQUdDLE9BQU8sQ0FBQyxtQ0FBRCxDQUE3Qjs7QUFDQSxJQUFNQyxnQkFBZ0IsR0FBR0QsT0FBTyxDQUFDLHNCQUFELENBQWhDOztBQUVBLFNBQVNFLGNBQVQsQ0FBeUJDLE1BQXpCLEVBQWlDO0FBQzdCLE1BQUlDLElBQUksR0FBRyxJQUFJQyxZQUFKLENBQWlCLEVBQWpCLENBQVg7QUFDQUQsRUFBQUEsSUFBSSxDQUFDRSxHQUFMLENBQVNILE1BQU0sQ0FBQ0ksQ0FBaEI7QUFDQSxTQUFPSCxJQUFQO0FBQ0g7QUFFRDs7OztBQUdBOzs7Ozs7OztBQU1BLElBQUlJLHFCQUFxQixHQUFHQyxFQUFFLENBQUNDLEtBQUgsQ0FBUztBQUNqQ0MsRUFBQUEsSUFBSSxFQUFFLDBCQUQyQjtBQUVqQyxhQUFTWixhQUZ3QjtBQUlqQ2EsRUFBQUEsVUFBVSxFQUFFO0FBQ1JDLElBQUFBLFlBQVksRUFBRTtBQUNWQyxNQUFBQSxRQUFRLEVBQUUsSUFEQTtBQUVWQyxNQUFBQSxHQUZVLGlCQUVIO0FBQ0gsZUFBTyxLQUFLQyxPQUFaO0FBQ0gsT0FKUztBQUtWVixNQUFBQSxHQUxVLGVBS0xXLEdBTEssRUFLQTtBQUNOLFlBQUlDLE1BQU0sR0FBR0MsV0FBVyxDQUFDQyxNQUFaLENBQW1CSCxHQUFuQixJQUEwQkEsR0FBRyxDQUFDQyxNQUE5QixHQUF1Q0QsR0FBcEQ7QUFDQSxhQUFLRCxPQUFMLEdBQWUsSUFBSVgsWUFBSixDQUFpQmEsTUFBTSxJQUFJRCxHQUEzQixFQUFnQyxDQUFoQyxFQUFtQ0MsTUFBTSxDQUFDRyxVQUFQLEdBQW9CLENBQXZELENBQWY7QUFDSDtBQVJTLEtBRE47O0FBWVI7Ozs7QUFJQUMsSUFBQUEsV0FBVyxFQUFFO0FBQ1QsaUJBQVMsSUFEQTtBQUVUQyxNQUFBQSxJQUFJLEVBQUVDO0FBRkcsS0FoQkw7O0FBcUJSOzs7O0FBSUFDLElBQUFBLFNBQVMsRUFBRTtBQUNQQyxNQUFBQSxPQUFPLEVBQUUsS0FERjtBQUVQWixNQUFBQSxRQUFRLEVBQUUsSUFGSDtBQUdQQyxNQUFBQSxHQUhPLGlCQUdBO0FBQ0gsZUFBTyxLQUFLWSxVQUFMLElBQW1CLEVBQTFCO0FBQ0gsT0FMTTtBQU1QckIsTUFBQUEsR0FOTyxpQkFNQSxDQUFFO0FBTkY7QUF6QkgsR0FKcUI7QUF1Q2pDc0IsRUFBQUEsT0FBTyxFQUFFO0FBQ0xDLElBQUFBLDZCQUE2QixFQUFFO0FBRDFCLEdBdkN3QjtBQTJDakNDLEVBQUFBLEtBM0NpQyxtQkEyQ3hCO0FBQ0wsUUFBSSxLQUFLSCxVQUFULEVBQXFCO0FBQ2pCLGFBQU8sS0FBS0EsVUFBWjtBQUNIOztBQUVELFNBQUtBLFVBQUwsR0FBa0IsRUFBbEI7O0FBRUEsU0FBS0ksb0JBQUw7O0FBRUEsUUFBSSxLQUFLQyxNQUFMLENBQVlDLHFCQUFoQixFQUF1QztBQUNuQyxXQUFLQyx5QkFBTDtBQUNIOztBQUVELFdBQU8sS0FBS1AsVUFBWjtBQUNILEdBekRnQztBQTJEakNJLEVBQUFBLG9CQTNEaUMsa0NBMkRUO0FBQ3BCLFFBQUliLE1BQU0sR0FBRyxLQUFLRixPQUFsQjtBQUNBLFFBQUlNLFdBQVcsR0FBRyxLQUFLQSxXQUF2QjtBQUVBLFFBQUlhLE1BQU0sR0FBRyxDQUFiOztBQUNBLGFBQVNDLFFBQVQsR0FBcUI7QUFDakIsYUFBT2xCLE1BQU0sQ0FBQ2lCLE1BQU0sRUFBUCxDQUFiO0FBQ0g7O0FBRUQsUUFBSSxDQUFDLEtBQUtSLFVBQUwsQ0FBZ0JVLEtBQXJCLEVBQTRCO0FBQ3hCLFdBQUtWLFVBQUwsQ0FBZ0JVLEtBQWhCLEdBQXdCLEVBQXhCO0FBQ0g7O0FBQ0QsUUFBSUEsS0FBSyxHQUFHLEtBQUtWLFVBQUwsQ0FBZ0JVLEtBQTVCOztBQUVBLFNBQUssSUFBSUMsSUFBVCxJQUFpQmhCLFdBQWpCLEVBQThCO0FBQzFCLFVBQUlpQixHQUFHLEdBQUdqQixXQUFXLENBQUNnQixJQUFELENBQXJCO0FBQ0EsVUFBSUUsTUFBTSxHQUFHLEVBQWI7QUFDQUgsTUFBQUEsS0FBSyxDQUFDQyxJQUFELENBQUwsR0FBYztBQUFFRyxRQUFBQSxLQUFLLEVBQUVEO0FBQVQsT0FBZDs7QUFFQSxXQUFLLElBQUlFLFFBQVQsSUFBcUJILEdBQXJCLEVBQTBCO0FBQ3RCLFlBQUlJLE1BQU0sR0FBRyxFQUFiO0FBRUEsWUFBSUMsVUFBVSxHQUFHTCxHQUFHLENBQUNHLFFBQUQsQ0FBSCxDQUFjRSxVQUEvQjtBQUNBVCxRQUFBQSxNQUFNLEdBQUdJLEdBQUcsQ0FBQ0csUUFBRCxDQUFILENBQWNQLE1BQXZCOztBQUNBLGFBQUssSUFBSVUsQ0FBQyxHQUFHLENBQWIsRUFBZ0JBLENBQUMsR0FBR0QsVUFBcEIsRUFBZ0NDLENBQUMsRUFBakMsRUFBcUM7QUFDakMsY0FBSUMsS0FBSyxHQUFHVixRQUFRLEVBQXBCO0FBQ0EsY0FBSVcsS0FBSyxTQUFUOztBQUNBLGNBQUlMLFFBQVEsS0FBSyxVQUFiLElBQTJCQSxRQUFRLEtBQUssT0FBNUMsRUFBcUQ7QUFDakRLLFlBQUFBLEtBQUssR0FBR3RDLEVBQUUsQ0FBQ3VDLEVBQUgsQ0FBTVosUUFBUSxFQUFkLEVBQWtCQSxRQUFRLEVBQTFCLEVBQThCQSxRQUFRLEVBQXRDLENBQVI7QUFDSCxXQUZELE1BR0ssSUFBSU0sUUFBUSxLQUFLLE1BQWpCLEVBQXlCO0FBQzFCSyxZQUFBQSxLQUFLLEdBQUd0QyxFQUFFLENBQUN3QyxJQUFILENBQVFiLFFBQVEsRUFBaEIsRUFBb0JBLFFBQVEsRUFBNUIsRUFBZ0NBLFFBQVEsRUFBeEMsRUFBNENBLFFBQVEsRUFBcEQsQ0FBUjtBQUNIOztBQUNETyxVQUFBQSxNQUFNLENBQUNPLElBQVAsQ0FBWTtBQUFFSixZQUFBQSxLQUFLLEVBQUxBLEtBQUY7QUFBU0MsWUFBQUEsS0FBSyxFQUFMQTtBQUFULFdBQVo7QUFDSDs7QUFFRFAsUUFBQUEsTUFBTSxDQUFDRSxRQUFELENBQU4sR0FBbUJDLE1BQW5CO0FBQ0g7QUFDSjtBQUNKLEdBbEdnQztBQW9HakNULEVBQUFBLHlCQXBHaUMsdUNBb0dKO0FBQ3pCLFFBQUlpQixRQUFRLEdBQUcsS0FBS25CLE1BQUwsQ0FBWW1CLFFBQTNCO0FBQ0EsUUFBSTFCLFNBQVMsR0FBRyxLQUFLRSxVQUFyQjtBQUNBLFFBQUlVLEtBQUssR0FBR1osU0FBUyxDQUFDWSxLQUF0QjtBQUVBLFFBQUllLFlBQVksR0FBRztBQUFFQyxNQUFBQSxNQUFNLEVBQUUsRUFBVjtBQUFjQyxNQUFBQSxjQUFjLEVBQUU7QUFBOUIsS0FBbkI7QUFDQSxRQUFJQSxjQUFjLEdBQUdGLFlBQVksQ0FBQ0UsY0FBbEMsQ0FOeUIsQ0FRekI7O0FBQ0EsYUFBU0MsSUFBVCxDQUFlQyxJQUFmLEVBQXFCQyxJQUFyQixFQUEyQkMsRUFBM0IsRUFBK0I7QUFDM0IsVUFBSXZELE1BQUo7QUFDQSxVQUFJd0QsT0FBTyxHQUFHLEtBQWQ7QUFFQSxVQUFJckIsSUFBSSxHQUFHRCxLQUFLLENBQUNtQixJQUFJLENBQUNsQixJQUFOLENBQWhCOztBQUNBLFVBQUlrQixJQUFJLEtBQUtMLFFBQVQsSUFBcUJiLElBQXpCLEVBQStCO0FBQzNCLFlBQUlHLEtBQUssR0FBR0gsSUFBSSxDQUFDRyxLQUFqQjs7QUFDQSxhQUFLLElBQUltQixJQUFULElBQWlCbkIsS0FBakIsRUFBd0I7QUFDcEIsY0FBSUUsTUFBTSxHQUFHRixLQUFLLENBQUNtQixJQUFELENBQWxCOztBQUNBLGVBQUssSUFBSWYsQ0FBQyxHQUFHLENBQWIsRUFBZ0JBLENBQUMsR0FBR0YsTUFBTSxDQUFDa0IsTUFBM0IsRUFBbUNoQixDQUFDLEVBQXBDLEVBQXdDO0FBQ3BDLGdCQUFJaUIsR0FBRyxHQUFHbkIsTUFBTSxDQUFDRSxDQUFELENBQWhCOztBQUVBLGdCQUFJa0IsSUFBSSxDQUFDQyxHQUFMLENBQVNGLEdBQUcsQ0FBQ2hCLEtBQUosR0FBWVcsSUFBckIsSUFBNkJFLE9BQWpDLEVBQTBDO0FBQ3RDSCxjQUFBQSxJQUFJLENBQUNJLElBQUQsQ0FBSixDQUFXdEQsR0FBWCxDQUFld0QsR0FBRyxDQUFDZixLQUFuQjtBQUNBO0FBQ0gsYUFIRCxNQUlLLElBQUllLEdBQUcsQ0FBQ2hCLEtBQUosR0FBWVcsSUFBaEIsRUFBc0I7QUFDdkIsa0JBQUlRLEtBQUssR0FBR3RCLE1BQU0sQ0FBQ0UsQ0FBQyxHQUFHLENBQUwsQ0FBbEI7QUFDQSxrQkFBSXFCLEtBQUssR0FBRyxDQUFDVCxJQUFJLEdBQUdRLEtBQUssQ0FBQ25CLEtBQWQsS0FBd0JnQixHQUFHLENBQUNoQixLQUFKLEdBQVltQixLQUFLLENBQUNuQixLQUExQyxDQUFaO0FBQ0FtQixjQUFBQSxLQUFLLENBQUNsQixLQUFOLENBQVlvQixJQUFaLENBQWlCTCxHQUFHLENBQUNmLEtBQXJCLEVBQTRCbUIsS0FBNUIsRUFBbUNWLElBQUksQ0FBQ0ksSUFBRCxDQUF2QztBQUNBO0FBQ0g7QUFDSjtBQUNKOztBQUVEekQsUUFBQUEsTUFBTSxHQUFHTSxFQUFFLENBQUMyRCxJQUFILEVBQVQ7O0FBQ0FDLHdCQUFLQyxPQUFMLENBQWFuRSxNQUFiLEVBQXFCcUQsSUFBSSxDQUFDUCxJQUExQixFQUFnQ08sSUFBSSxDQUFDZSxRQUFyQyxFQUErQ2YsSUFBSSxDQUFDZ0IsS0FBcEQ7O0FBRUEsWUFBSWQsRUFBSixFQUFRO0FBQ0pXLDBCQUFLSSxHQUFMLENBQVN0RSxNQUFULEVBQWlCdUQsRUFBakIsRUFBcUJ2RCxNQUFyQjtBQUNIOztBQUVELFlBQUksQ0FBQ3NDLEtBQUssQ0FBQ2lDLFlBQVgsRUFBeUI7QUFDckJqQyxVQUFBQSxLQUFLLENBQUNpQyxZQUFOLEdBQXFCLEVBQXJCO0FBQ0g7O0FBRUQsWUFBSUMsZUFBSjs7QUFDQSxZQUFJbkIsSUFBSSxDQUFDb0IsY0FBVCxFQUF5QjtBQUNyQkQsVUFBQUEsZUFBZSxHQUFHbEUsRUFBRSxDQUFDMkQsSUFBSCxFQUFsQjs7QUFDQUMsMEJBQUtJLEdBQUwsQ0FBU0UsZUFBVCxFQUEwQnhFLE1BQTFCLEVBQWtDcUQsSUFBSSxDQUFDb0IsY0FBdkM7QUFDSDs7QUFFRCxZQUFJLENBQUN0QixjQUFjLENBQUNFLElBQUksQ0FBQ2xCLElBQU4sQ0FBbkIsRUFBZ0M7QUFDNUJnQixVQUFBQSxjQUFjLENBQUNFLElBQUksQ0FBQ2xCLElBQU4sQ0FBZCxHQUE0QixFQUE1QjtBQUNIOztBQUVELFlBQUlxQyxlQUFKLEVBQXFCO0FBQ2pCckIsVUFBQUEsY0FBYyxDQUFDRSxJQUFJLENBQUNsQixJQUFOLENBQWQsQ0FBMEJZLElBQTFCLENBQStCaEQsY0FBYyxDQUFDeUUsZUFBRCxDQUE3QztBQUNILFNBRkQsTUFHSztBQUNEckIsVUFBQUEsY0FBYyxDQUFDRSxJQUFJLENBQUNsQixJQUFOLENBQWQsQ0FBMEJZLElBQTFCLENBQStCL0MsTUFBL0I7QUFDSDtBQUNKOztBQUVELFVBQUkwRSxRQUFRLEdBQUdyQixJQUFJLENBQUNxQixRQUFwQjs7QUFDQSxXQUFLLElBQUlsRSxJQUFULElBQWlCa0UsUUFBakIsRUFBMkI7QUFDdkIsWUFBSUMsS0FBSyxHQUFHRCxRQUFRLENBQUNsRSxJQUFELENBQXBCO0FBQ0E0QyxRQUFBQSxJQUFJLENBQUN1QixLQUFELEVBQVFyQixJQUFSLEVBQWN0RCxNQUFkLENBQUo7QUFDSDtBQUNKOztBQUVELFFBQUlzRCxJQUFJLEdBQUcsQ0FBWDtBQUNBLFFBQUlzQixRQUFRLEdBQUcsS0FBS0EsUUFBcEI7QUFDQSxRQUFJQyxJQUFJLEdBQUcsSUFBSSxLQUFLQyxNQUFwQjs7QUFFQSxXQUFPeEIsSUFBSSxHQUFHc0IsUUFBZCxFQUF3QjtBQUNwQjNCLE1BQUFBLFlBQVksQ0FBQ0MsTUFBYixDQUFvQkgsSUFBcEIsQ0FBeUJPLElBQUksR0FBR3NCLFFBQWhDO0FBQ0F4QixNQUFBQSxJQUFJLENBQUNKLFFBQUQsRUFBV00sSUFBWCxDQUFKO0FBQ0FBLE1BQUFBLElBQUksSUFBSXVCLElBQVI7QUFDSDs7QUFFRCxTQUFLckQsVUFBTCxHQUFrQnlCLFlBQWxCO0FBQ0gsR0FyTGdDO0FBdUxqQzhCLEVBQUFBLHVCQXZMaUMsbUNBdUxSQyxLQXZMUSxFQXVMREMsSUF2TEMsRUF1TEs7QUFDbEMsUUFBSUMsS0FBSyxHQUFHLElBQUlwRixnQkFBSixFQUFaO0FBQ0FvRixJQUFBQSxLQUFLLENBQUNoQyxNQUFOLEdBQWUsS0FBSzVCLFNBQUwsQ0FBZTRCLE1BQTlCO0FBRUFnQyxJQUFBQSxLQUFLLENBQUNDLEtBQU4sR0FBYyxFQUFkO0FBRUEsUUFBSWhDLGNBQWMsR0FBRyxLQUFLN0IsU0FBTCxDQUFlNkIsY0FBcEM7O0FBQ0EsU0FBSyxJQUFJaEIsSUFBVCxJQUFpQmdCLGNBQWpCLEVBQWlDO0FBQzdCLFVBQUlpQyxNQUFNLEdBQUc5RSxFQUFFLENBQUMrRSxJQUFILENBQVFsRCxJQUFSLEVBQWM4QyxJQUFkLENBQWI7QUFDQSxVQUFJLENBQUNHLE1BQUwsRUFBYTtBQUViRixNQUFBQSxLQUFLLENBQUNDLEtBQU4sQ0FBWXBDLElBQVosQ0FBaUI7QUFDYnFDLFFBQUFBLE1BQU0sRUFBRUEsTUFESztBQUViRSxRQUFBQSxNQUFNLEVBQUVuQyxjQUFjLENBQUNoQixJQUFEO0FBRlQsT0FBakI7QUFJSDs7QUFFRCxXQUFPLENBQUMrQyxLQUFELENBQVA7QUFDSCxHQXpNZ0M7QUEyTWpDSyxFQUFBQSxZQTNNaUMsd0JBMk1uQlAsS0EzTW1CLEVBMk1aQyxJQTNNWSxFQTJNTjtBQUN2QixRQUFJLENBQUMsS0FBS3BELE1BQVYsRUFBa0I7QUFDZHZCLE1BQUFBLEVBQUUsQ0FBQ2tGLElBQUgsK0JBQW9DLEtBQUtoRixJQUF6QztBQUNBLGFBQU8sRUFBUDtBQUNIOztBQUVELFNBQUttQixLQUFMOztBQUVBLFFBQUksS0FBS0UsTUFBTCxDQUFZQyxxQkFBaEIsRUFBdUM7QUFDbkMsYUFBTyxLQUFLaUQsdUJBQUwsQ0FBNkJDLEtBQTdCLEVBQW9DQyxJQUFwQyxDQUFQO0FBQ0gsS0FGRCxNQUdLO0FBQ0QsYUFBT3JGLGFBQWEsQ0FBQzZGLFNBQWQsQ0FBd0JGLFlBQXhCLENBQXFDRyxJQUFyQyxDQUEwQyxJQUExQyxFQUFnRFYsS0FBaEQsRUFBdURDLElBQXZELENBQVA7QUFDSDtBQUNKO0FBek5nQyxDQUFULENBQTVCO0FBNE5BM0UsRUFBRSxDQUFDRCxxQkFBSCxHQUEyQnNGLE1BQU0sQ0FBQ0MsT0FBUCxHQUFpQnZGLHFCQUE1QyIsInNvdXJjZXNDb250ZW50IjpbIi8qKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqXG4gQ29weXJpZ2h0IChjKSAyMDE3LTIwMTggWGlhbWVuIFlhamkgU29mdHdhcmUgQ28uLCBMdGQuXG5cbiBodHRwOi8vd3d3LmNvY29zLmNvbVxuXG4gUGVybWlzc2lvbiBpcyBoZXJlYnkgZ3JhbnRlZCwgZnJlZSBvZiBjaGFyZ2UsIHRvIGFueSBwZXJzb24gb2J0YWluaW5nIGEgY29weVxuIG9mIHRoaXMgc29mdHdhcmUgYW5kIGFzc29jaWF0ZWQgZW5naW5lIHNvdXJjZSBjb2RlICh0aGUgXCJTb2Z0d2FyZVwiKSwgYSBsaW1pdGVkLFxuICB3b3JsZHdpZGUsIHJveWFsdHktZnJlZSwgbm9uLWFzc2lnbmFibGUsIHJldm9jYWJsZSBhbmQgbm9uLWV4Y2x1c2l2ZSBsaWNlbnNlXG4gdG8gdXNlIENvY29zIENyZWF0b3Igc29sZWx5IHRvIGRldmVsb3AgZ2FtZXMgb24geW91ciB0YXJnZXQgcGxhdGZvcm1zLiBZb3Ugc2hhbGxcbiAgbm90IHVzZSBDb2NvcyBDcmVhdG9yIHNvZnR3YXJlIGZvciBkZXZlbG9waW5nIG90aGVyIHNvZnR3YXJlIG9yIHRvb2xzIHRoYXQnc1xuICB1c2VkIGZvciBkZXZlbG9waW5nIGdhbWVzLiBZb3UgYXJlIG5vdCBncmFudGVkIHRvIHB1Ymxpc2gsIGRpc3RyaWJ1dGUsXG4gIHN1YmxpY2Vuc2UsIGFuZC9vciBzZWxsIGNvcGllcyBvZiBDb2NvcyBDcmVhdG9yLlxuXG4gVGhlIHNvZnR3YXJlIG9yIHRvb2xzIGluIHRoaXMgTGljZW5zZSBBZ3JlZW1lbnQgYXJlIGxpY2Vuc2VkLCBub3Qgc29sZC5cbiBYaWFtZW4gWWFqaSBTb2Z0d2FyZSBDby4sIEx0ZC4gcmVzZXJ2ZXMgYWxsIHJpZ2h0cyBub3QgZXhwcmVzc2x5IGdyYW50ZWQgdG8geW91LlxuXG4gVEhFIFNPRlRXQVJFIElTIFBST1ZJREVEIFwiQVMgSVNcIiwgV0lUSE9VVCBXQVJSQU5UWSBPRiBBTlkgS0lORCwgRVhQUkVTUyBPUlxuIElNUExJRUQsIElOQ0xVRElORyBCVVQgTk9UIExJTUlURUQgVE8gVEhFIFdBUlJBTlRJRVMgT0YgTUVSQ0hBTlRBQklMSVRZLFxuIEZJVE5FU1MgRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFIEFORCBOT05JTkZSSU5HRU1FTlQuIElOIE5PIEVWRU5UIFNIQUxMIFRIRVxuIEFVVEhPUlMgT1IgQ09QWVJJR0hUIEhPTERFUlMgQkUgTElBQkxFIEZPUiBBTlkgQ0xBSU0sIERBTUFHRVMgT1IgT1RIRVJcbiBMSUFCSUxJVFksIFdIRVRIRVIgSU4gQU4gQUNUSU9OIE9GIENPTlRSQUNULCBUT1JUIE9SIE9USEVSV0lTRSwgQVJJU0lORyBGUk9NLFxuIE9VVCBPRiBPUiBJTiBDT05ORUNUSU9OIFdJVEggVEhFIFNPRlRXQVJFIE9SIFRIRSBVU0UgT1IgT1RIRVIgREVBTElOR1MgSU5cbiBUSEUgU09GVFdBUkUuXG4gKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKi9cblxuaW1wb3J0IE1hdDQgZnJvbSAnLi4vLi4vdmFsdWUtdHlwZXMvbWF0NCc7XG5cbmNvbnN0IEFuaW1hdGlvbkNsaXAgPSByZXF1aXJlKCcuLi8uLi8uLi9hbmltYXRpb24vYW5pbWF0aW9uLWNsaXAnKTtcbmNvbnN0IEpvaW50TWF0cml4Q3VydmUgPSByZXF1aXJlKCcuL0NDSm9pbnRNYXRyaXhDdXJ2ZScpO1xuXG5mdW5jdGlvbiBtYXh0cml4VG9BcnJheSAobWF0cml4KSB7XG4gICAgbGV0IGRhdGEgPSBuZXcgRmxvYXQzMkFycmF5KDE2KTtcbiAgICBkYXRhLnNldChtYXRyaXgubSk7XG4gICAgcmV0dXJuIGRhdGE7XG59XG5cbi8qKlxuKiBAbW9kdWxlIGNjXG4qL1xuLyoqXG4gKiAhI2VuIFNrZWxldG9uQW5pbWF0aW9uQ2xpcCBBc3NldC5cbiAqICEjemgg6aqo6aq85Yqo55S75Ymq6L6R44CCXG4gKiBAY2xhc3MgU2tlbGV0b25BbmltYXRpb25DbGlwXG4gKiBAZXh0ZW5kcyBBbmltYXRpb25DbGlwXG4gKi9cbmxldCBTa2VsZXRvbkFuaW1hdGlvbkNsaXAgPSBjYy5DbGFzcyh7XG4gICAgbmFtZTogJ2NjLlNrZWxldG9uQW5pbWF0aW9uQ2xpcCcsXG4gICAgZXh0ZW5kczogQW5pbWF0aW9uQ2xpcCxcblxuICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgX25hdGl2ZUFzc2V0OiB7XG4gICAgICAgICAgICBvdmVycmlkZTogdHJ1ZSxcbiAgICAgICAgICAgIGdldCAoKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIHRoaXMuX2J1ZmZlcjtcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBzZXQgKGJpbikge1xuICAgICAgICAgICAgICAgIGxldCBidWZmZXIgPSBBcnJheUJ1ZmZlci5pc1ZpZXcoYmluKSA/IGJpbi5idWZmZXIgOiBiaW47XG4gICAgICAgICAgICAgICAgdGhpcy5fYnVmZmVyID0gbmV3IEZsb2F0MzJBcnJheShidWZmZXIgfHwgYmluLCAwLCBidWZmZXIuYnl0ZUxlbmd0aCAvIDQpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9LFxuXG4gICAgICAgIC8qKlxuICAgICAgICAgKiBEZXNjcmliZSB0aGUgZGF0YSBzdHJ1Y3R1cmUuXG4gICAgICAgICAqIHsgcGF0aDogeyBvZmZzZXQsIGZyYW1lQ291bnQsIHByb3BlcnR5IH0gfVxuICAgICAgICAgKi9cbiAgICAgICAgZGVzY3JpcHRpb246IHtcbiAgICAgICAgICAgIGRlZmF1bHQ6IG51bGwsXG4gICAgICAgICAgICB0eXBlOiBPYmplY3QsXG4gICAgICAgIH0sXG5cbiAgICAgICAgLyoqXG4gICAgICAgICAqIFNrZWxldG9uQW5pbWF0aW9uQ2xpcCdzIGN1cnZlRGF0YSBpcyBnZW5lcmF0ZWQgZnJvbSBiaW5hcnkgYnVmZmVyLlxuICAgICAgICAgKiBTbyBzaG91bGQgbm90IHNlcmlhbGl6ZSBjdXJ2ZURhdGEuXG4gICAgICAgICAqL1xuICAgICAgICBjdXJ2ZURhdGE6IHtcbiAgICAgICAgICAgIHZpc2libGU6IGZhbHNlLFxuICAgICAgICAgICAgb3ZlcnJpZGU6IHRydWUsXG4gICAgICAgICAgICBnZXQgKCkge1xuICAgICAgICAgICAgICAgIHJldHVybiB0aGlzLl9jdXJ2ZURhdGEgfHwge307XG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgc2V0ICgpIHt9XG4gICAgICAgIH1cbiAgICB9LFxuXG4gICAgc3RhdGljczoge1xuICAgICAgICBwcmV2ZW50RGVmZXJyZWRMb2FkRGVwZW5kZW50czogdHJ1ZSxcbiAgICB9LFxuXG4gICAgX2luaXQgKCkge1xuICAgICAgICBpZiAodGhpcy5fY3VydmVEYXRhKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5fY3VydmVEYXRhO1xuICAgICAgICB9XG5cbiAgICAgICAgdGhpcy5fY3VydmVEYXRhID0ge307XG4gICAgICAgIFxuICAgICAgICB0aGlzLl9nZW5lcmF0ZUNvbW1vbkN1cnZlKCk7XG5cbiAgICAgICAgaWYgKHRoaXMuX21vZGVsLnByZWNvbXB1dGVKb2ludE1hdHJpeCkge1xuICAgICAgICAgICAgdGhpcy5fZ2VuZXJhdGVKb2ludE1hdHJpeEN1cnZlKCk7XG4gICAgICAgIH1cblxuICAgICAgICByZXR1cm4gdGhpcy5fY3VydmVEYXRhO1xuICAgIH0sXG5cbiAgICBfZ2VuZXJhdGVDb21tb25DdXJ2ZSAoKSB7XG4gICAgICAgIGxldCBidWZmZXIgPSB0aGlzLl9idWZmZXI7XG4gICAgICAgIGxldCBkZXNjcmlwdGlvbiA9IHRoaXMuZGVzY3JpcHRpb247XG5cbiAgICAgICAgbGV0IG9mZnNldCA9IDA7XG4gICAgICAgIGZ1bmN0aW9uIGdldFZhbHVlICgpIHtcbiAgICAgICAgICAgIHJldHVybiBidWZmZXJbb2Zmc2V0KytdO1xuICAgICAgICB9XG5cbiAgICAgICAgaWYgKCF0aGlzLl9jdXJ2ZURhdGEucGF0aHMpIHtcbiAgICAgICAgICAgIHRoaXMuX2N1cnZlRGF0YS5wYXRocyA9IHt9O1xuICAgICAgICB9XG4gICAgICAgIGxldCBwYXRocyA9IHRoaXMuX2N1cnZlRGF0YS5wYXRocztcblxuICAgICAgICBmb3IgKGxldCBwYXRoIGluIGRlc2NyaXB0aW9uKSB7XG4gICAgICAgICAgICBsZXQgZGVzID0gZGVzY3JpcHRpb25bcGF0aF07XG4gICAgICAgICAgICBsZXQgY3VydmVzID0ge307XG4gICAgICAgICAgICBwYXRoc1twYXRoXSA9IHsgcHJvcHM6IGN1cnZlcyB9O1xuXG4gICAgICAgICAgICBmb3IgKGxldCBwcm9wZXJ0eSBpbiBkZXMpIHtcbiAgICAgICAgICAgICAgICBsZXQgZnJhbWVzID0gW107XG5cbiAgICAgICAgICAgICAgICBsZXQgZnJhbWVDb3VudCA9IGRlc1twcm9wZXJ0eV0uZnJhbWVDb3VudDtcbiAgICAgICAgICAgICAgICBvZmZzZXQgPSBkZXNbcHJvcGVydHldLm9mZnNldDtcbiAgICAgICAgICAgICAgICBmb3IgKGxldCBpID0gMDsgaSA8IGZyYW1lQ291bnQ7IGkrKykge1xuICAgICAgICAgICAgICAgICAgICBsZXQgZnJhbWUgPSBnZXRWYWx1ZSgpO1xuICAgICAgICAgICAgICAgICAgICBsZXQgdmFsdWU7XG4gICAgICAgICAgICAgICAgICAgIGlmIChwcm9wZXJ0eSA9PT0gJ3Bvc2l0aW9uJyB8fCBwcm9wZXJ0eSA9PT0gJ3NjYWxlJykge1xuICAgICAgICAgICAgICAgICAgICAgICAgdmFsdWUgPSBjYy52MyhnZXRWYWx1ZSgpLCBnZXRWYWx1ZSgpLCBnZXRWYWx1ZSgpKTtcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICBlbHNlIGlmIChwcm9wZXJ0eSA9PT0gJ3F1YXQnKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICB2YWx1ZSA9IGNjLnF1YXQoZ2V0VmFsdWUoKSwgZ2V0VmFsdWUoKSwgZ2V0VmFsdWUoKSwgZ2V0VmFsdWUoKSk7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgZnJhbWVzLnB1c2goeyBmcmFtZSwgdmFsdWUgfSk7XG4gICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgY3VydmVzW3Byb3BlcnR5XSA9IGZyYW1lcztcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgIH0sXG5cbiAgICBfZ2VuZXJhdGVKb2ludE1hdHJpeEN1cnZlICgpIHtcbiAgICAgICAgbGV0IHJvb3ROb2RlID0gdGhpcy5fbW9kZWwucm9vdE5vZGU7XG4gICAgICAgIGxldCBjdXJ2ZURhdGEgPSB0aGlzLl9jdXJ2ZURhdGE7XG4gICAgICAgIGxldCBwYXRocyA9IGN1cnZlRGF0YS5wYXRocztcblxuICAgICAgICBsZXQgbmV3Q3VydmVEYXRhID0geyByYXRpb3M6IFtdLCBqb2ludE1hdHJpeE1hcDoge30gfTtcbiAgICAgICAgbGV0IGpvaW50TWF0cml4TWFwID0gbmV3Q3VydmVEYXRhLmpvaW50TWF0cml4TWFwO1xuXG4gICAgICAgIC8vIHdhbGsgdGhyb3VnaCBub2RlIHRyZWUgdG8gY2FsY3VsYXRlIG5vZGUncyBqb2ludCBtYXRyaXggYXQgdGltZS5cbiAgICAgICAgZnVuY3Rpb24gd2FsayAobm9kZSwgdGltZSwgcG0pIHtcbiAgICAgICAgICAgIGxldCBtYXRyaXg7XG4gICAgICAgICAgICBsZXQgRVBTSUxPTiA9IDEwZS01O1xuXG4gICAgICAgICAgICBsZXQgcGF0aCA9IHBhdGhzW25vZGUucGF0aF07XG4gICAgICAgICAgICBpZiAobm9kZSAhPT0gcm9vdE5vZGUgJiYgcGF0aCkge1xuICAgICAgICAgICAgICAgIGxldCBwcm9wcyA9IHBhdGgucHJvcHM7XG4gICAgICAgICAgICAgICAgZm9yIChsZXQgcHJvcCBpbiBwcm9wcykge1xuICAgICAgICAgICAgICAgICAgICBsZXQgZnJhbWVzID0gcHJvcHNbcHJvcF07XG4gICAgICAgICAgICAgICAgICAgIGZvciAobGV0IGkgPSAwOyBpIDwgZnJhbWVzLmxlbmd0aDsgaSsrKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBsZXQgZW5kID0gZnJhbWVzW2ldO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICBpZiAoTWF0aC5hYnMoZW5kLmZyYW1lIC0gdGltZSkgPCBFUFNJTE9OKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgbm9kZVtwcm9wXS5zZXQoZW5kLnZhbHVlKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgIGVsc2UgaWYgKGVuZC5mcmFtZSA+IHRpbWUpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBsZXQgc3RhcnQgPSBmcmFtZXNbaSAtIDFdO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGxldCByYXRpbyA9ICh0aW1lIC0gc3RhcnQuZnJhbWUpIC8gKGVuZC5mcmFtZSAtIHN0YXJ0LmZyYW1lKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBzdGFydC52YWx1ZS5sZXJwKGVuZC52YWx1ZSwgcmF0aW8sIG5vZGVbcHJvcF0pO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgbWF0cml4ID0gY2MubWF0NCgpO1xuICAgICAgICAgICAgICAgIE1hdDQuZnJvbVJUUyhtYXRyaXgsIG5vZGUucXVhdCwgbm9kZS5wb3NpdGlvbiwgbm9kZS5zY2FsZSk7XG5cbiAgICAgICAgICAgICAgICBpZiAocG0pIHtcbiAgICAgICAgICAgICAgICAgICAgTWF0NC5tdWwobWF0cml4LCBwbSwgbWF0cml4KTtcbiAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICBpZiAoIXByb3BzLl9qb2ludE1hdHJpeCkge1xuICAgICAgICAgICAgICAgICAgICBwcm9wcy5fam9pbnRNYXRyaXggPSBbXTtcbiAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICBsZXQgYmluZFdvcmxkTWF0cml4O1xuICAgICAgICAgICAgICAgIGlmIChub2RlLnVuaXF1ZUJpbmRQb3NlKSB7XG4gICAgICAgICAgICAgICAgICAgIGJpbmRXb3JsZE1hdHJpeCA9IGNjLm1hdDQoKTtcbiAgICAgICAgICAgICAgICAgICAgTWF0NC5tdWwoYmluZFdvcmxkTWF0cml4LCBtYXRyaXgsIG5vZGUudW5pcXVlQmluZFBvc2UpO1xuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIGlmICgham9pbnRNYXRyaXhNYXBbbm9kZS5wYXRoXSkge1xuICAgICAgICAgICAgICAgICAgICBqb2ludE1hdHJpeE1hcFtub2RlLnBhdGhdID0gW107XG4gICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgaWYgKGJpbmRXb3JsZE1hdHJpeCkge1xuICAgICAgICAgICAgICAgICAgICBqb2ludE1hdHJpeE1hcFtub2RlLnBhdGhdLnB1c2gobWF4dHJpeFRvQXJyYXkoYmluZFdvcmxkTWF0cml4KSlcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIGpvaW50TWF0cml4TWFwW25vZGUucGF0aF0ucHVzaChtYXRyaXgpXG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBsZXQgY2hpbGRyZW4gPSBub2RlLmNoaWxkcmVuO1xuICAgICAgICAgICAgZm9yIChsZXQgbmFtZSBpbiBjaGlsZHJlbikge1xuICAgICAgICAgICAgICAgIGxldCBjaGlsZCA9IGNoaWxkcmVuW25hbWVdO1xuICAgICAgICAgICAgICAgIHdhbGsoY2hpbGQsIHRpbWUsIG1hdHJpeCk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cblxuICAgICAgICBsZXQgdGltZSA9IDA7XG4gICAgICAgIGxldCBkdXJhdGlvbiA9IHRoaXMuZHVyYXRpb247XG4gICAgICAgIGxldCBzdGVwID0gMSAvIHRoaXMuc2FtcGxlO1xuXG4gICAgICAgIHdoaWxlICh0aW1lIDwgZHVyYXRpb24pIHtcbiAgICAgICAgICAgIG5ld0N1cnZlRGF0YS5yYXRpb3MucHVzaCh0aW1lIC8gZHVyYXRpb24pO1xuICAgICAgICAgICAgd2Fsayhyb290Tm9kZSwgdGltZSk7XG4gICAgICAgICAgICB0aW1lICs9IHN0ZXA7XG4gICAgICAgIH1cblxuICAgICAgICB0aGlzLl9jdXJ2ZURhdGEgPSBuZXdDdXJ2ZURhdGE7XG4gICAgfSxcblxuICAgIF9jcmVhdGVKb2ludE1hdHJpeEN1cnZlIChzdGF0ZSwgcm9vdCkge1xuICAgICAgICBsZXQgY3VydmUgPSBuZXcgSm9pbnRNYXRyaXhDdXJ2ZSgpO1xuICAgICAgICBjdXJ2ZS5yYXRpb3MgPSB0aGlzLmN1cnZlRGF0YS5yYXRpb3M7XG5cbiAgICAgICAgY3VydmUucGFpcnMgPSBbXTtcblxuICAgICAgICBsZXQgam9pbnRNYXRyaXhNYXAgPSB0aGlzLmN1cnZlRGF0YS5qb2ludE1hdHJpeE1hcDtcbiAgICAgICAgZm9yIChsZXQgcGF0aCBpbiBqb2ludE1hdHJpeE1hcCkge1xuICAgICAgICAgICAgbGV0IHRhcmdldCA9IGNjLmZpbmQocGF0aCwgcm9vdCk7XG4gICAgICAgICAgICBpZiAoIXRhcmdldCkgY29udGludWU7XG5cbiAgICAgICAgICAgIGN1cnZlLnBhaXJzLnB1c2goe1xuICAgICAgICAgICAgICAgIHRhcmdldDogdGFyZ2V0LFxuICAgICAgICAgICAgICAgIHZhbHVlczogam9pbnRNYXRyaXhNYXBbcGF0aF1cbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9XG5cbiAgICAgICAgcmV0dXJuIFtjdXJ2ZV07XG4gICAgfSxcblxuICAgIGNyZWF0ZUN1cnZlcyAoc3RhdGUsIHJvb3QpIHtcbiAgICAgICAgaWYgKCF0aGlzLl9tb2RlbCkge1xuICAgICAgICAgICAgY2Mud2FybihgU2tlbGV0b24gQW5pbWF0aW9uIENsaXAgWyR7dGhpcy5uYW1lfV0gQ2FuIG5vdCBmaW5kIG1vZGVsYCk7XG4gICAgICAgICAgICByZXR1cm4gW107XG4gICAgICAgIH1cblxuICAgICAgICB0aGlzLl9pbml0KCk7XG5cbiAgICAgICAgaWYgKHRoaXMuX21vZGVsLnByZWNvbXB1dGVKb2ludE1hdHJpeCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMuX2NyZWF0ZUpvaW50TWF0cml4Q3VydmUoc3RhdGUsIHJvb3QpO1xuICAgICAgICB9XG4gICAgICAgIGVsc2Uge1xuICAgICAgICAgICAgcmV0dXJuIEFuaW1hdGlvbkNsaXAucHJvdG90eXBlLmNyZWF0ZUN1cnZlcy5jYWxsKHRoaXMsIHN0YXRlLCByb290KTtcbiAgICAgICAgfVxuICAgIH1cbn0pO1xuXG5jYy5Ta2VsZXRvbkFuaW1hdGlvbkNsaXAgPSBtb2R1bGUuZXhwb3J0cyA9IFNrZWxldG9uQW5pbWF0aW9uQ2xpcDtcbiJdLCJzb3VyY2VSb290IjoiLyJ9