
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/primitive/polyhedron.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports.polyhedron = exports.PolyhedronType = void 0;

var _utils = require("./utils");

var _vertexData = _interopRequireDefault(require("./vertex-data"));

var _valueTypes = require("../../value-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * @enum primitive.PolyhedronType
 * @static
 * @namespace primitive
 */
var PolyhedronType = cc.Enum({
  /**
   * @property Tetrahedron
   * @static
   */
  Tetrahedron: 0,

  /**
   * @property Octahedron
   * @static
   */
  Octahedron: 1,

  /**
   * @property Dodecahedron
   * @static
   */
  Dodecahedron: 2,

  /**
   * @property Icosahedron
   * @static
   */
  Icosahedron: 3,

  /**
   * @property Rhombicuboctahedron
   * @static
   */
  Rhombicuboctahedron: 4,

  /**
   * @property TriangularPrism
   * @static
   */
  TriangularPrism: 5,

  /**
   * @property PentagonalPrism
   * @static
   */
  PentagonalPrism: 6,

  /**
   * @property HexagonalPrism
   * @static
   */
  HexagonalPrism: 7,

  /**
   * @property SquarePyramid
   * @static
   */
  SquarePyramid: 8,

  /**
   * @property PentagonalPyramid
   * @static
   */
  PentagonalPyramid: 9,

  /**
   * @property TriangularDipyramid
   * @static
   */
  TriangularDipyramid: 10,

  /**
   * @property PentagonalDipyramid
   * @static
   */
  PentagonalDipyramid: 11,

  /**
   * @property ElongatedSquareDipyramid
   * @static
   */
  ElongatedSquareDipyramid: 12,

  /**
   * @property ElongatedPentagonalDipyramid
   * @static
   */
  ElongatedPentagonalDipyramid: 13,

  /**
   * @property ElongatedPentagonalCupola
   * @static
   */
  ElongatedPentagonalCupola: 14
}); // precached polyhedra data

exports.PolyhedronType = PolyhedronType;
var polyhedra = [];
polyhedra[0] = {
  vertex: [[0, 0, 1.732051], [1.632993, 0, -0.5773503], [-0.8164966, 1.414214, -0.5773503], [-0.8164966, -1.414214, -0.5773503]],
  face: [[0, 1, 2], [0, 2, 3], [0, 3, 1], [1, 3, 2]]
};
polyhedra[1] = {
  vertex: [[0, 0, 1.414214], [1.414214, 0, 0], [0, 1.414214, 0], [-1.414214, 0, 0], [0, -1.414214, 0], [0, 0, -1.414214]],
  face: [[0, 1, 2], [0, 2, 3], [0, 3, 4], [0, 4, 1], [1, 4, 5], [1, 5, 2], [2, 5, 3], [3, 5, 4]]
};
polyhedra[2] = {
  vertex: [[0, 0, 1.070466], [0.7136442, 0, 0.7978784], [-0.3568221, 0.618034, 0.7978784], [-0.3568221, -0.618034, 0.7978784], [0.7978784, 0.618034, 0.3568221], [0.7978784, -0.618034, 0.3568221], [-0.9341724, 0.381966, 0.3568221], [0.1362939, 1, 0.3568221], [0.1362939, -1, 0.3568221], [-0.9341724, -0.381966, 0.3568221], [0.9341724, 0.381966, -0.3568221], [0.9341724, -0.381966, -0.3568221], [-0.7978784, 0.618034, -0.3568221], [-0.1362939, 1, -0.3568221], [-0.1362939, -1, -0.3568221], [-0.7978784, -0.618034, -0.3568221], [0.3568221, 0.618034, -0.7978784], [0.3568221, -0.618034, -0.7978784], [-0.7136442, 0, -0.7978784], [0, 0, -1.070466]],
  face: [[0, 1, 4, 7, 2], [0, 2, 6, 9, 3], [0, 3, 8, 5, 1], [1, 5, 11, 10, 4], [2, 7, 13, 12, 6], [3, 9, 15, 14, 8], [4, 10, 16, 13, 7], [5, 8, 14, 17, 11], [6, 12, 18, 15, 9], [10, 11, 17, 19, 16], [12, 13, 16, 19, 18], [14, 15, 18, 19, 17]]
};
polyhedra[3] = {
  vertex: [[0, 0, 1.175571], [1.051462, 0, 0.5257311], [0.3249197, 1, 0.5257311], [-0.8506508, 0.618034, 0.5257311], [-0.8506508, -0.618034, 0.5257311], [0.3249197, -1, 0.5257311], [0.8506508, 0.618034, -0.5257311], [0.8506508, -0.618034, -0.5257311], [-0.3249197, 1, -0.5257311], [-1.051462, 0, -0.5257311], [-0.3249197, -1, -0.5257311], [0, 0, -1.175571]],
  face: [[0, 1, 2], [0, 2, 3], [0, 3, 4], [0, 4, 5], [0, 5, 1], [1, 5, 7], [1, 7, 6], [1, 6, 2], [2, 6, 8], [2, 8, 3], [3, 8, 9], [3, 9, 4], [4, 9, 10], [4, 10, 5], [5, 10, 7], [6, 7, 11], [6, 11, 8], [7, 10, 11], [8, 11, 9], [9, 11, 10]]
};
polyhedra[4] = {
  vertex: [[0, 0, 1.070722], [0.7148135, 0, 0.7971752], [-0.104682, 0.7071068, 0.7971752], [-0.6841528, 0.2071068, 0.7971752], [-0.104682, -0.7071068, 0.7971752], [0.6101315, 0.7071068, 0.5236279], [1.04156, 0.2071068, 0.1367736], [0.6101315, -0.7071068, 0.5236279], [-0.3574067, 1, 0.1367736], [-0.7888348, -0.5, 0.5236279], [-0.9368776, 0.5, 0.1367736], [-0.3574067, -1, 0.1367736], [0.3574067, 1, -0.1367736], [0.9368776, -0.5, -0.1367736], [0.7888348, 0.5, -0.5236279], [0.3574067, -1, -0.1367736], [-0.6101315, 0.7071068, -0.5236279], [-1.04156, -0.2071068, -0.1367736], [-0.6101315, -0.7071068, -0.5236279], [0.104682, 0.7071068, -0.7971752], [0.6841528, -0.2071068, -0.7971752], [0.104682, -0.7071068, -0.7971752], [-0.7148135, 0, -0.7971752], [0, 0, -1.070722]],
  face: [[0, 2, 3], [1, 6, 5], [4, 9, 11], [7, 15, 13], [8, 16, 10], [12, 14, 19], [17, 22, 18], [20, 21, 23], [0, 1, 5, 2], [0, 3, 9, 4], [0, 4, 7, 1], [1, 7, 13, 6], [2, 5, 12, 8], [2, 8, 10, 3], [3, 10, 17, 9], [4, 11, 15, 7], [5, 6, 14, 12], [6, 13, 20, 14], [8, 12, 19, 16], [9, 17, 18, 11], [10, 16, 22, 17], [11, 18, 21, 15], [13, 15, 21, 20], [14, 20, 23, 19], [16, 19, 23, 22], [18, 22, 23, 21]]
};
polyhedra[5] = {
  vertex: [[0, 0, 1.322876], [1.309307, 0, 0.1889822], [-0.9819805, 0.8660254, 0.1889822], [0.1636634, -1.299038, 0.1889822], [0.3273268, 0.8660254, -0.9449112], [-0.8183171, -0.4330127, -0.9449112]],
  face: [[0, 3, 1], [2, 4, 5], [0, 1, 4, 2], [0, 2, 5, 3], [1, 3, 5, 4]]
};
polyhedra[6] = {
  vertex: [[0, 0, 1.159953], [1.013464, 0, 0.5642542], [-0.3501431, 0.9510565, 0.5642542], [-0.7715208, -0.6571639, 0.5642542], [0.6633206, 0.9510565, -0.03144481], [0.8682979, -0.6571639, -0.3996071], [-1.121664, 0.2938926, -0.03144481], [-0.2348831, -1.063314, -0.3996071], [0.5181548, 0.2938926, -0.9953061], [-0.5850262, -0.112257, -0.9953061]],
  face: [[0, 1, 4, 2], [0, 2, 6, 3], [1, 5, 8, 4], [3, 6, 9, 7], [5, 7, 9, 8], [0, 3, 7, 5, 1], [2, 4, 8, 9, 6]]
};
polyhedra[7] = {
  vertex: [[0, 0, 1.118034], [0.8944272, 0, 0.6708204], [-0.2236068, 0.8660254, 0.6708204], [-0.7826238, -0.4330127, 0.6708204], [0.6708204, 0.8660254, 0.2236068], [1.006231, -0.4330127, -0.2236068], [-1.006231, 0.4330127, 0.2236068], [-0.6708204, -0.8660254, -0.2236068], [0.7826238, 0.4330127, -0.6708204], [0.2236068, -0.8660254, -0.6708204], [-0.8944272, 0, -0.6708204], [0, 0, -1.118034]],
  face: [[0, 1, 4, 2], [0, 2, 6, 3], [1, 5, 8, 4], [3, 6, 10, 7], [5, 9, 11, 8], [7, 10, 11, 9], [0, 3, 7, 9, 5, 1], [2, 4, 8, 11, 10, 6]]
};
polyhedra[8] = {
  vertex: [[-0.729665, 0.670121, 0.319155], [-0.655235, -0.29213, -0.754096], [-0.093922, -0.607123, 0.537818], [0.702196, 0.595691, 0.485187], [0.776626, -0.36656, -0.588064]],
  face: [[1, 4, 2], [0, 1, 2], [3, 0, 2], [4, 3, 2], [4, 1, 0, 3]]
};
polyhedra[9] = {
  vertex: [[-0.868849, -0.100041, 0.61257], [-0.329458, 0.976099, 0.28078], [-0.26629, -0.013796, -0.477654], [-0.13392, -1.034115, 0.229829], [0.738834, 0.707117, -0.307018], [0.859683, -0.535264, -0.338508]],
  face: [[3, 0, 2], [5, 3, 2], [4, 5, 2], [1, 4, 2], [0, 1, 2], [0, 3, 5, 4, 1]]
};
polyhedra[10] = {
  vertex: [[-0.610389, 0.243975, 0.531213], [-0.187812, -0.48795, -0.664016], [-0.187812, 0.9759, -0.664016], [0.187812, -0.9759, 0.664016], [0.798201, 0.243975, 0.132803]],
  face: [[1, 3, 0], [3, 4, 0], [3, 1, 4], [0, 2, 1], [0, 4, 2], [2, 4, 1]]
};
polyhedra[11] = {
  vertex: [[-1.028778, 0.392027, -0.048786], [-0.640503, -0.646161, 0.621837], [-0.125162, -0.395663, -0.540059], [0.004683, 0.888447, -0.651988], [0.125161, 0.395663, 0.540059], [0.632925, -0.791376, 0.433102], [1.031672, 0.157063, -0.354165]],
  face: [[3, 2, 0], [2, 1, 0], [2, 5, 1], [0, 4, 3], [0, 1, 4], [4, 1, 5], [2, 3, 6], [3, 4, 6], [5, 2, 6], [4, 5, 6]]
};
polyhedra[12] = {
  vertex: [[-0.669867, 0.334933, -0.529576], [-0.669867, 0.334933, 0.529577], [-0.4043, 1.212901, 0], [-0.334933, -0.669867, -0.529576], [-0.334933, -0.669867, 0.529577], [0.334933, 0.669867, -0.529576], [0.334933, 0.669867, 0.529577], [0.4043, -1.212901, 0], [0.669867, -0.334933, -0.529576], [0.669867, -0.334933, 0.529577]],
  face: [[8, 9, 7], [6, 5, 2], [3, 8, 7], [5, 0, 2], [4, 3, 7], [0, 1, 2], [9, 4, 7], [1, 6, 2], [9, 8, 5, 6], [8, 3, 0, 5], [3, 4, 1, 0], [4, 9, 6, 1]]
};
polyhedra[13] = {
  vertex: [[-0.931836, 0.219976, -0.264632], [-0.636706, 0.318353, 0.692816], [-0.613483, -0.735083, -0.264632], [-0.326545, 0.979634, 0], [-0.318353, -0.636706, 0.692816], [-0.159176, 0.477529, -0.856368], [0.159176, -0.477529, -0.856368], [0.318353, 0.636706, 0.692816], [0.326545, -0.979634, 0], [0.613482, 0.735082, -0.264632], [0.636706, -0.318353, 0.692816], [0.931835, -0.219977, -0.264632]],
  face: [[11, 10, 8], [7, 9, 3], [6, 11, 8], [9, 5, 3], [2, 6, 8], [5, 0, 3], [4, 2, 8], [0, 1, 3], [10, 4, 8], [1, 7, 3], [10, 11, 9, 7], [11, 6, 5, 9], [6, 2, 0, 5], [2, 4, 1, 0], [4, 10, 7, 1]]
};
polyhedra[14] = {
  vertex: [[-0.93465, 0.300459, -0.271185], [-0.838689, -0.260219, -0.516017], [-0.711319, 0.717591, 0.128359], [-0.710334, -0.156922, 0.080946], [-0.599799, 0.556003, -0.725148], [-0.503838, -0.004675, -0.969981], [-0.487004, 0.26021, 0.48049], [-0.460089, -0.750282, -0.512622], [-0.376468, 0.973135, -0.325605], [-0.331735, -0.646985, 0.084342], [-0.254001, 0.831847, 0.530001], [-0.125239, -0.494738, -0.966586], [0.029622, 0.027949, 0.730817], [0.056536, -0.982543, -0.262295], [0.08085, 1.087391, 0.076037], [0.125583, -0.532729, 0.485984], [0.262625, 0.599586, 0.780328], [0.391387, -0.726999, -0.716259], [0.513854, -0.868287, 0.139347], [0.597475, 0.85513, 0.326364], [0.641224, 0.109523, 0.783723], [0.737185, -0.451155, 0.538891], [0.848705, -0.612742, -0.314616], [0.976075, 0.365067, 0.32976], [1.072036, -0.19561, 0.084927]],
  face: [[15, 18, 21], [12, 20, 16], [6, 10, 2], [3, 0, 1], [9, 7, 13], [2, 8, 4, 0], [0, 4, 5, 1], [1, 5, 11, 7], [7, 11, 17, 13], [13, 17, 22, 18], [18, 22, 24, 21], [21, 24, 23, 20], [20, 23, 19, 16], [16, 19, 14, 10], [10, 14, 8, 2], [15, 9, 13, 18], [12, 15, 21, 20], [6, 12, 16, 10], [3, 6, 2, 0], [9, 3, 1, 7], [9, 15, 12, 6, 3], [22, 17, 11, 5, 4, 8, 14, 19, 23, 24]]
};

var polyhedron = function polyhedron(type, size, opts) {
  if (size === void 0) {
    size = 1;
  }

  if (opts === void 0) {
    opts = {
      sizeX: 0,
      sizeY: 0,
      sizeZ: 0
    };
  }

  type = type && (type < 0 || type >= polyhedra.length) ? 0 : type || 0;
  var sizeX = opts.sizeX || size;
  var sizeY = opts.sizeY || size;
  var sizeZ = opts.sizeZ || size;
  var data = polyhedra[type];
  var nbfaces = data.face.length;
  var positions = [];
  var indices = [];
  var normals = [];
  var uvs = [];
  var minPos = new _valueTypes.Vec3(Infinity, Infinity, Infinity);
  var maxPos = new _valueTypes.Vec3(-Infinity, -Infinity, -Infinity);

  for (var i = 0; i < data.vertex.length; i++) {
    var x = data.vertex[i][0] * sizeX;
    var y = data.vertex[i][1] * sizeY;
    var z = data.vertex[i][2] * sizeZ;
    minPos.x = Math.min(minPos.x, x);
    minPos.y = Math.min(minPos.y, y);
    minPos.z = Math.min(minPos.z, z);
    maxPos.x = Math.max(maxPos.x, x);
    maxPos.y = Math.max(maxPos.y, y);
    maxPos.z = Math.max(maxPos.z, z);
    positions.push(x, y, z);
    uvs.push(0, 0);
  }

  for (var f = 0; f < nbfaces; f++) {
    for (var _i = 0; _i < data.face[f].length - 2; _i++) {
      indices.push(data.face[f][0], data.face[f][_i + 2], data.face[f][_i + 1]);
    }
  }

  (0, _utils.calcNormals)(positions, indices, normals);
  var boundingRadius = Math.sqrt(Math.pow(maxPos.x - minPos.x, 2), Math.pow(maxPos.y - minPos.y, 2), Math.pow(maxPos.z - minPos.z, 2));
  return new _vertexData["default"](positions, normals, uvs, indices, minPos, maxPos, boundingRadius);
};

exports.polyhedron = polyhedron;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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