
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/primitive/cylinder.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}'use strict';

exports.__esModule = true;
exports["default"] = _default;

var _vec = _interopRequireDefault(require("../../value-types/vec3"));

var _vertexData = _interopRequireDefault(require("./vertex-data"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var temp1 = new _vec["default"]();
var temp2 = new _vec["default"]();
/**
 * @param {Number} radiusTop
 * @param {Number} radiusBottom
 * @param {Number} height
 * @param {Object} opts
 * @param {Number} opts.radialSegments
 * @param {Number} opts.heightSegments
 * @param {Boolean} opts.capped
 * @param {Number} opts.arc
 */

function _default(radiusTop, radiusBottom, height, opts) {
  if (radiusTop === void 0) {
    radiusTop = 0.5;
  }

  if (radiusBottom === void 0) {
    radiusBottom = 0.5;
  }

  if (height === void 0) {
    height = 2;
  }

  if (opts === void 0) {
    opts = {
      radialSegments: 32,
      heightSegments: 1,
      capped: true,
      arc: 2.0 * Math.PI
    };
  }

  var halfHeight = height * 0.5;
  var radialSegments = opts.radialSegments;
  var heightSegments = opts.heightSegments;
  var capped = opts.capped;
  var arc = opts.arc;
  var cntCap = 0;

  if (!capped) {
    if (radiusTop > 0) {
      cntCap++;
    }

    if (radiusBottom > 0) {
      cntCap++;
    }
  } // calculate vertex count


  var vertCount = (radialSegments + 1) * (heightSegments + 1);

  if (capped) {
    vertCount += (radialSegments + 1) * cntCap + radialSegments * cntCap;
  } // calculate index count


  var indexCount = radialSegments * heightSegments * 2 * 3;

  if (capped) {
    indexCount += radialSegments * cntCap * 3;
  }

  var indices = new Array(indexCount);
  var positions = new Array(vertCount * 3);
  var normals = new Array(vertCount * 3);
  var uvs = new Array(vertCount * 2);
  var maxRadius = Math.max(radiusTop, radiusBottom);
  var minPos = new _vec["default"](-maxRadius, -halfHeight, -maxRadius);
  var maxPos = new _vec["default"](maxRadius, halfHeight, maxRadius);
  var boundingRadius = Math.sqrt(maxRadius * maxRadius + halfHeight * halfHeight);
  var index = 0;
  var indexOffset = 0;
  generateTorso();

  if (capped) {
    if (radiusBottom > 0) {
      generateCap(false);
    }

    if (radiusTop > 0) {
      generateCap(true);
    }
  }

  return new _vertexData["default"](positions, normals, uvs, indices, minPos, maxPos, boundingRadius); // =======================
  // internal fucntions
  // =======================

  function generateTorso() {
    var indexArray = []; // this will be used to calculate the normal

    var r = radiusTop - radiusBottom;
    var slope = r * r / height * Math.sign(r); // generate positions, normals and uvs

    for (var y = 0; y <= heightSegments; y++) {
      var indexRow = [];
      var v = y / heightSegments; // calculate the radius of the current row

      var radius = v * r + radiusBottom;

      for (var x = 0; x <= radialSegments; ++x) {
        var u = x / radialSegments;
        var theta = u * arc;
        var sinTheta = Math.sin(theta);
        var cosTheta = Math.cos(theta); // vertex

        positions[3 * index] = radius * sinTheta;
        positions[3 * index + 1] = v * height - halfHeight;
        positions[3 * index + 2] = radius * cosTheta; // normal

        _vec["default"].normalize(temp1, _vec["default"].set(temp2, sinTheta, -slope, cosTheta));

        normals[3 * index] = temp1.x;
        normals[3 * index + 1] = temp1.y;
        normals[3 * index + 2] = temp1.z; // uv

        uvs[2 * index] = (1 - u) * 2 % 1;
        uvs[2 * index + 1] = v; // save index of vertex in respective row

        indexRow.push(index); // increase index

        ++index;
      } // now save positions of the row in our index array


      indexArray.push(indexRow);
    } // generate indices


    for (var _y = 0; _y < heightSegments; ++_y) {
      for (var _x = 0; _x < radialSegments; ++_x) {
        // we use the index array to access the correct indices
        var i1 = indexArray[_y][_x];
        var i2 = indexArray[_y + 1][_x];
        var i3 = indexArray[_y + 1][_x + 1];
        var i4 = indexArray[_y][_x + 1]; // face one

        indices[indexOffset] = i1;
        ++indexOffset;
        indices[indexOffset] = i4;
        ++indexOffset;
        indices[indexOffset] = i2;
        ++indexOffset; // face two

        indices[indexOffset] = i4;
        ++indexOffset;
        indices[indexOffset] = i3;
        ++indexOffset;
        indices[indexOffset] = i2;
        ++indexOffset;
      }
    }
  }

  function generateCap(top) {
    var centerIndexStart, centerIndexEnd;
    var radius = top ? radiusTop : radiusBottom;
    var sign = top ? 1 : -1; // save the index of the first center vertex

    centerIndexStart = index; // first we generate the center vertex data of the cap.
    // because the geometry needs one set of uvs per face,
    // we must generate a center vertex per face/segment

    for (var x = 1; x <= radialSegments; ++x) {
      // vertex
      positions[3 * index] = 0;
      positions[3 * index + 1] = halfHeight * sign;
      positions[3 * index + 2] = 0; // normal

      normals[3 * index] = 0;
      normals[3 * index + 1] = sign;
      normals[3 * index + 2] = 0; // uv

      uvs[2 * index] = 0.5;
      uvs[2 * index + 1] = 0.5; // increase index

      ++index;
    } // save the index of the last center vertex


    centerIndexEnd = index; // now we generate the surrounding positions, normals and uvs

    for (var _x2 = 0; _x2 <= radialSegments; ++_x2) {
      var u = _x2 / radialSegments;
      var theta = u * arc;
      var cosTheta = Math.cos(theta);
      var sinTheta = Math.sin(theta); // vertex

      positions[3 * index] = radius * sinTheta;
      positions[3 * index + 1] = halfHeight * sign;
      positions[3 * index + 2] = radius * cosTheta; // normal

      normals[3 * index] = 0;
      normals[3 * index + 1] = sign;
      normals[3 * index + 2] = 0; // uv

      uvs[2 * index] = 0.5 - sinTheta * 0.5 * sign;
      uvs[2 * index + 1] = 0.5 + cosTheta * 0.5; // increase index

      ++index;
    } // generate indices


    for (var _x3 = 0; _x3 < radialSegments; ++_x3) {
      var c = centerIndexStart + _x3;
      var i = centerIndexEnd + _x3;

      if (top) {
        // face top
        indices[indexOffset] = i + 1;
        ++indexOffset;
        indices[indexOffset] = c;
        ++indexOffset;
        indices[indexOffset] = i;
        ++indexOffset;
      } else {
        // face bottom
        indices[indexOffset] = c;
        ++indexOffset;
        indices[indexOffset] = i + 1;
        ++indexOffset;
        indices[indexOffset] = i;
        ++indexOffset;
      }
    }
  }
}

module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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