
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/primitive/capsule.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}'use strict';

exports.__esModule = true;
exports["default"] = _default;

var _vec = _interopRequireDefault(require("../../value-types/vec3"));

var _vertexData = _interopRequireDefault(require("./vertex-data"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var temp1 = cc.v3(0, 0, 0);
var temp2 = cc.v3(0, 0, 0);
/**
 * @param {Number} radiusTop
 * @param {Number} radiusBottom
 * @param {Number} height
 * @param {Object} opts
 * @param {Number} opts.sides
 * @param {Number} opts.heightSegments
 * @param {Boolean} opts.capped
 * @param {Number} opts.arc
 */

function _default(radiusTop, radiusBottom, height, opts) {
  if (radiusTop === void 0) {
    radiusTop = 0.5;
  }

  if (radiusBottom === void 0) {
    radiusBottom = 0.5;
  }

  if (height === void 0) {
    height = 2;
  }

  if (opts === void 0) {
    opts = {
      sides: 32,
      heightSegments: 32,
      arc: 2.0 * Math.PI
    };
  }

  var torsoHeight = height - radiusTop - radiusBottom;
  var sides = opts.sides;
  var heightSegments = opts.heightSegments;
  var bottomProp = radiusBottom / height;
  var torProp = torsoHeight / height;
  var topProp = radiusTop / height;
  var bottomSegments = Math.floor(heightSegments * bottomProp);
  var topSegments = Math.floor(heightSegments * topProp);
  var torSegments = Math.floor(heightSegments * torProp);
  var topOffset = torsoHeight + radiusBottom - height / 2;
  var torOffset = radiusBottom - height / 2;
  var bottomOffset = radiusBottom - height / 2;
  var arc = opts.arc; // calculate vertex count

  var positions = [];
  var normals = [];
  var uvs = [];
  var indices = [];
  var maxRadius = Math.max(radiusTop, radiusBottom);
  var minPos = cc.v3(-maxRadius, -height / 2, -maxRadius);
  var maxPos = cc.v3(maxRadius, height / 2, maxRadius);
  var boundingRadius = height / 2;
  var index = 0;
  var indexArray = [];
  generateBottom();
  generateTorso();
  generateTop();
  return new _vertexData["default"](positions, normals, uvs, indices, minPos, maxPos, boundingRadius); // =======================
  // internal fucntions
  // =======================

  function generateTorso() {
    // this will be used to calculate the normal
    var slope = (radiusTop - radiusBottom) / torsoHeight; // generate positions, normals and uvs

    for (var y = 0; y <= torSegments; y++) {
      var indexRow = [];
      var lat = y / torSegments;
      var radius = lat * (radiusTop - radiusBottom) + radiusBottom;

      for (var x = 0; x <= sides; ++x) {
        var u = x / sides;
        var v = lat * torProp + bottomProp;
        var theta = u * arc - arc / 4;
        var sinTheta = Math.sin(theta);
        var cosTheta = Math.cos(theta); // vertex

        positions.push(radius * sinTheta);
        positions.push(lat * torsoHeight + torOffset);
        positions.push(radius * cosTheta); // normal

        _vec["default"].normalize(temp1, _vec["default"].set(temp2, sinTheta, -slope, cosTheta));

        normals.push(temp1.x);
        normals.push(temp1.y);
        normals.push(temp1.z); // uv

        uvs.push(u, v); // save index of vertex in respective row

        indexRow.push(index); // increase index

        ++index;
      } // now save positions of the row in our index array


      indexArray.push(indexRow);
    } // generate indices


    for (var _y = 0; _y < torSegments; ++_y) {
      for (var _x = 0; _x < sides; ++_x) {
        // we use the index array to access the correct indices
        var i1 = indexArray[_y][_x];
        var i2 = indexArray[_y + 1][_x];
        var i3 = indexArray[_y + 1][_x + 1];
        var i4 = indexArray[_y][_x + 1]; // face one

        indices.push(i1);
        indices.push(i4);
        indices.push(i2); // face two

        indices.push(i4);
        indices.push(i3);
        indices.push(i2);
      }
    }
  }

  function generateBottom() {
    for (var lat = 0; lat <= bottomSegments; ++lat) {
      var theta = lat * Math.PI / bottomSegments / 2;
      var sinTheta = Math.sin(theta);
      var cosTheta = -Math.cos(theta);

      for (var lon = 0; lon <= sides; ++lon) {
        var phi = lon * 2 * Math.PI / sides - Math.PI / 2.0;
        var sinPhi = Math.sin(phi);
        var cosPhi = Math.cos(phi);
        var x = sinPhi * sinTheta;
        var y = cosTheta;
        var z = cosPhi * sinTheta;
        var u = lon / sides;
        var v = lat / heightSegments;
        positions.push(x * radiusBottom, y * radiusBottom + bottomOffset, z * radiusBottom);
        normals.push(x, y, z);
        uvs.push(u, v);

        if (lat < bottomSegments && lon < sides) {
          var seg1 = sides + 1;
          var a = seg1 * lat + lon;
          var b = seg1 * (lat + 1) + lon;
          var c = seg1 * (lat + 1) + lon + 1;
          var d = seg1 * lat + lon + 1;
          indices.push(a, d, b);
          indices.push(d, c, b);
        }

        ++index;
      }
    }
  }

  function generateTop() {
    for (var lat = 0; lat <= topSegments; ++lat) {
      var theta = lat * Math.PI / topSegments / 2 + Math.PI / 2;
      var sinTheta = Math.sin(theta);
      var cosTheta = -Math.cos(theta);

      for (var lon = 0; lon <= sides; ++lon) {
        var phi = lon * 2 * Math.PI / sides - Math.PI / 2.0;
        var sinPhi = Math.sin(phi);
        var cosPhi = Math.cos(phi);
        var x = sinPhi * sinTheta;
        var y = cosTheta;
        var z = cosPhi * sinTheta;
        var u = lon / sides;
        var v = lat / heightSegments + (1 - topProp);
        positions.push(x * radiusTop, y * radiusTop + topOffset, z * radiusTop);
        normals.push(x, y, z);
        uvs.push(u, v);

        if (lat < topSegments && lon < sides) {
          var seg1 = sides + 1;
          var a = seg1 * lat + lon + indexArray[torSegments][sides] + 1;
          var b = seg1 * (lat + 1) + lon + indexArray[torSegments][sides] + 1;
          var c = seg1 * (lat + 1) + lon + 1 + indexArray[torSegments][sides] + 1;
          var d = seg1 * lat + lon + 1 + indexArray[torSegments][sides] + 1;
          indices.push(a, d, b);
          indices.push(d, c, b);
        }
      }
    }
  }
}

module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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