
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/primitive/box.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}'use strict';

exports.__esModule = true;
exports["default"] = _default;

var _vec = _interopRequireDefault(require("../../value-types/vec3"));

var _vertexData = _interopRequireDefault(require("./vertex-data"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var temp1 = new _vec["default"]();
var temp2 = new _vec["default"]();
var temp3 = new _vec["default"]();
var r = new _vec["default"]();
var c0 = new _vec["default"]();
var c1 = new _vec["default"]();
var c2 = new _vec["default"]();
var c3 = new _vec["default"]();
var c4 = new _vec["default"]();
var c5 = new _vec["default"]();
var c6 = new _vec["default"]();
var c7 = new _vec["default"]();
/**
 * @param {Number} width
 * @param {Number} height
 * @param {Number} length
 * @param {Object} opts
 * @param {Number} opts.widthSegments
 * @param {Number} opts.heightSegments
 * @param {Number} opts.lengthSegments
 */

function _default(width, height, length, opts) {
  if (width === void 0) {
    width = 1;
  }

  if (height === void 0) {
    height = 1;
  }

  if (length === void 0) {
    length = 1;
  }

  if (opts === void 0) {
    opts = {
      widthSegments: 1,
      heightSegments: 1,
      lengthSegments: 1,
      invWinding: false
    };
  }

  var ws = opts.widthSegments;
  var hs = opts.heightSegments;
  var ls = opts.lengthSegments;
  var inv = opts.invWinding;
  var hw = width * 0.5;
  var hh = height * 0.5;
  var hl = length * 0.5;
  var corners = [_vec["default"].set(c0, -hw, -hh, hl), _vec["default"].set(c1, hw, -hh, hl), _vec["default"].set(c2, hw, hh, hl), _vec["default"].set(c3, -hw, hh, hl), _vec["default"].set(c4, hw, -hh, -hl), _vec["default"].set(c5, -hw, -hh, -hl), _vec["default"].set(c6, -hw, hh, -hl), _vec["default"].set(c7, hw, hh, -hl)];
  var faceAxes = [[2, 3, 1], // FRONT
  [4, 5, 7], // BACK
  [7, 6, 2], // TOP
  [1, 0, 4], // BOTTOM
  [1, 4, 2], // RIGHT
  [5, 0, 6] // LEFT
  ];
  var faceNormals = [[0, 0, 1], // FRONT
  [0, 0, -1], // BACK
  [0, 1, 0], // TOP
  [0, -1, 0], // BOTTOM
  [1, 0, 0], // RIGHT
  [-1, 0, 0] // LEFT
  ];
  var positions = [];
  var normals = [];
  var uvs = [];
  var indices = [];
  var minPos = new _vec["default"](-hw, -hh, -hl);
  var maxPos = new _vec["default"](hw, hh, hl);
  var boundingRadius = Math.sqrt(hw * hw + hh * hh + hl * hl);

  function _buildPlane(side, uSegments, vSegments) {
    var u, v;
    var ix, iy;
    var offset = positions.length / 3;
    var faceAxe = faceAxes[side];
    var faceNormal = faceNormals[side];

    for (iy = 0; iy <= vSegments; iy++) {
      for (ix = 0; ix <= uSegments; ix++) {
        u = ix / uSegments;
        v = iy / vSegments;

        _vec["default"].lerp(temp1, corners[faceAxe[0]], corners[faceAxe[1]], u);

        _vec["default"].lerp(temp2, corners[faceAxe[0]], corners[faceAxe[2]], v);

        _vec["default"].subtract(temp3, temp2, corners[faceAxe[0]]);

        _vec["default"].add(r, temp1, temp3);

        positions.push(r.x, r.y, r.z);
        normals.push(faceNormal[0], faceNormal[1], faceNormal[2]);
        uvs.push(u, v);

        if (ix < uSegments && iy < vSegments) {
          var useg1 = uSegments + 1;
          var a = ix + iy * useg1;
          var b = ix + (iy + 1) * useg1;
          var c = ix + 1 + (iy + 1) * useg1;
          var d = ix + 1 + iy * useg1;

          if (inv) {
            indices.push(offset + a, offset + b, offset + d);
            indices.push(offset + d, offset + b, offset + c);
          } else {
            indices.push(offset + a, offset + d, offset + b);
            indices.push(offset + b, offset + d, offset + c);
          }
        }
      }
    }
  }

  _buildPlane(0, ws, hs); // FRONT


  _buildPlane(4, ls, hs); // RIGHT


  _buildPlane(1, ws, hs); // BACK


  _buildPlane(5, ls, hs); // LEFT


  _buildPlane(3, ws, ls); // BOTTOM


  _buildPlane(2, ws, ls); // TOP


  return new _vertexData["default"](positions, normals, uvs, indices, minPos, maxPos, boundingRadius);
}

module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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