
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/physics/framework/components/rigid-body-component.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports.RigidBody3D = void 0;

var _instance = require("../instance");

var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _dec9, _dec10, _dec11, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _temp;

function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

var _cc$_decorator = cc._decorator,
    ccclass = _cc$_decorator.ccclass,
    disallowMultiple = _cc$_decorator.disallowMultiple,
    executeInEditMode = _cc$_decorator.executeInEditMode,
    executionOrder = _cc$_decorator.executionOrder,
    menu = _cc$_decorator.menu,
    property = _cc$_decorator.property;
var Vec3 = cc.Vec3;
/**
 * !#en
 * Rigid body.
 * !#zh
 * 刚体组件。
 * @class RigidBody3D
 * @extends Component
 */

var RigidBody3D = (_dec = ccclass('cc.RigidBody3D'), _dec2 = executionOrder(99), _dec3 = menu('i18n:MAIN_MENU.component.physics/Rigid Body 3D'), _dec4 = property({
  displayOrder: 0
}), _dec5 = property({
  displayOrder: 1
}), _dec6 = property({
  displayOrder: 2
}), _dec7 = property({
  displayOrder: 3
}), _dec8 = property({
  displayOrder: 4
}), _dec9 = property({
  displayOrder: 5
}), _dec10 = property({
  displayOrder: 6
}), _dec11 = property({
  displayOrder: 7
}), _dec(_class = _dec2(_class = _dec3(_class = executeInEditMode(_class = disallowMultiple(_class = (_class2 = (_temp =
/*#__PURE__*/
function (_cc$Component) {
  _inheritsLoose(RigidBody3D, _cc$Component);

  _createClass(RigidBody3D, [{
    key: "allowSleep",
    /// PUBLIC PROPERTY GETTER\SETTER ///

    /**
     * !#en
     * Gets or sets whether sleep is allowed
     * !#zh
     * 获取或设置是否允许休眠
     * @property {boolean} allowSleep
     */
    get: function get() {
      return this._allowSleep;
    },
    set: function set(v) {
      this._allowSleep = v;

      if (!CC_EDITOR && !CC_PHYSICS_BUILTIN) {
        this._body.allowSleep = v;
      }
    }
    /**
     * !#en
     * Gets or sets the mass of the rigid body.
     * !#zh
     * 获取或设置刚体的质量。
     * @property {number} mass
     */

  }, {
    key: "mass",
    get: function get() {
      return this._mass;
    },
    set: function set(value) {
      this._mass = value;

      if (!CC_EDITOR && !CC_PHYSICS_BUILTIN) {
        this._body.mass = value;
      }
    }
    /**
     * !#en
     * Gets or sets linear damping.
     * !#zh
     * 获取或设置线性阻尼。
     * @property {number} linearDamping
     */

  }, {
    key: "linearDamping",
    get: function get() {
      return this._linearDamping;
    },
    set: function set(value) {
      this._linearDamping = value;

      if (!CC_EDITOR && !CC_PHYSICS_BUILTIN) {
        this._body.linearDamping = value;
      }
    }
    /**
     * !#en
     * Gets or sets rotational damping.
     * !#zh
     * 获取或设置旋转阻尼。
     * @property {number} angularDamping
     */

  }, {
    key: "angularDamping",
    get: function get() {
      return this._angularDamping;
    },
    set: function set(value) {
      this._angularDamping = value;

      if (!CC_EDITOR && !CC_PHYSICS_BUILTIN) {
        this._body.angularDamping = value;
      }
    }
    /**
     * !#en
     * Gets or sets whether the rigid body is controlled by a physical system.
     * !#zh
     * 获取或设置刚体是否由物理系统控制运动。
     * @property {boolean} isKinematic
     */

  }, {
    key: "isKinematic",
    get: function get() {
      return this._isKinematic;
    },
    set: function set(value) {
      this._isKinematic = value;

      if (!CC_EDITOR && !CC_PHYSICS_BUILTIN) {
        this._body.isKinematic = value;
      }
    }
    /**
     * !#en
     * Gets or sets whether the rigid body uses gravity.
     * !#zh
     * 获取或设置刚体是否使用重力。
     * @property {boolean} useGravity
     */

  }, {
    key: "useGravity",
    get: function get() {
      return this._useGravity;
    },
    set: function set(value) {
      this._useGravity = value;

      if (!CC_EDITOR && !CC_PHYSICS_BUILTIN) {
        this._body.useGravity = value;
      }
    }
    /**
     * !#en
     * Gets or sets whether the rigid body is fixed for rotation.
     * !#zh
     * 获取或设置刚体是否固定旋转。
     * @property {boolean} fixedRotation
     */

  }, {
    key: "fixedRotation",
    get: function get() {
      return this._fixedRotation;
    },
    set: function set(value) {
      this._fixedRotation = value;

      if (!CC_EDITOR && !CC_PHYSICS_BUILTIN) {
        this._body.fixedRotation = value;
      }
    }
    /**
     * !#en
     * Gets or sets a factor of linear velocity that can be used to control the scaling of velocity in each axis direction.
     * !#zh
     * 获取或设置线性速度的因子，可以用来控制每个轴方向上的速度的缩放。
     * @property {Vec3} linearFactor
     */

  }, {
    key: "linearFactor",
    get: function get() {
      return this._linearFactor;
    },
    set: function set(value) {
      Vec3.copy(this._linearFactor, value);

      if (!CC_EDITOR && !CC_PHYSICS_BUILTIN) {
        this._body.linearFactor = this._linearFactor;
      }
    }
    /**
     * !#en
     * Gets or sets the rotation speed factor that can be used to control the rotation speed scaling in each axis direction.
     * !#zh
     * 获取或设置旋转速度的因子，可以用来控制每个轴方向上的旋转速度的缩放。
     * @property {Vec3} angularFactor
     */

  }, {
    key: "angularFactor",
    get: function get() {
      return this._angularFactor;
    },
    set: function set(value) {
      Vec3.copy(this._angularFactor, value);

      if (!CC_EDITOR && !CC_PHYSICS_BUILTIN) {
        this._body.angularFactor = this._angularFactor;
      }
    }
    /**
     * !#en
     * Gets whether the state is awakened.
     * !#zh
     * 获取是否是唤醒的状态。
     * @property {boolean} isAwake
     * @readonly
     */

  }, {
    key: "isAwake",
    get: function get() {
      if (this._assertOnload && !CC_EDITOR && !CC_PHYSICS_BUILTIN) {
        return this._body.isAwake;
      }

      return false;
    }
    /**
     * !#en
     * Gets whether or not a dormant state can be entered.
     * !#zh
     * 获取是否是可进入休眠的状态。
     * @property {boolean} isSleepy
     * @readonly
     */

  }, {
    key: "isSleepy",
    get: function get() {
      if (this._assertOnload && !CC_EDITOR && !CC_PHYSICS_BUILTIN) {
        return this._body.isSleepy;
      }

      return false;
    }
    /**
     * !#en
     * Gets whether the state is dormant.
     * !#zh
     * 获取是否是正在休眠的状态。
     * @property {boolean} isSleeping
     * @readonly
     */

  }, {
    key: "isSleeping",
    get: function get() {
      if (this._assertOnload && !CC_EDITOR && !CC_PHYSICS_BUILTIN) {
        return this._body.isSleeping;
      }

      return false;
    }
    /**
     * !#en
     * Gets physics engine rigid body object.
     * !#zh
     * 获得物理引擎内部刚体对象
     * @property {IRigidBody} rigidBody
     * @readonly
     */

  }, {
    key: "rigidBody",
    get: function get() {
      return this._body;
    }
  }, {
    key: "_assertOnload",
    get: function get() {
      var r = this._isOnLoadCalled == 0;

      if (r) {
        cc.error('Physics Error: Please make sure that the node has been added to the scene');
      }

      return !r;
    }
  }]);

  function RigidBody3D() {
    var _this;

    _this = _cc$Component.call(this) || this;
    _this._body = void 0;
    _this._allowSleep = true;

    _initializerDefineProperty(_this, "_mass", _descriptor, _assertThisInitialized(_this));

    _initializerDefineProperty(_this, "_linearDamping", _descriptor2, _assertThisInitialized(_this));

    _initializerDefineProperty(_this, "_angularDamping", _descriptor3, _assertThisInitialized(_this));

    _initializerDefineProperty(_this, "_fixedRotation", _descriptor4, _assertThisInitialized(_this));

    _initializerDefineProperty(_this, "_isKinematic", _descriptor5, _assertThisInitialized(_this));

    _initializerDefineProperty(_this, "_useGravity", _descriptor6, _assertThisInitialized(_this));

    _initializerDefineProperty(_this, "_linearFactor", _descriptor7, _assertThisInitialized(_this));

    _initializerDefineProperty(_this, "_angularFactor", _descriptor8, _assertThisInitialized(_this));

    if (!CC_EDITOR && !CC_PHYSICS_BUILTIN) {
      _this._body = (0, _instance.createRigidBody)();
    }

    return _this;
  } /// COMPONENT LIFECYCLE ///


  var _proto = RigidBody3D.prototype;

  _proto.__preload = function __preload() {
    if (!CC_EDITOR && !CC_PHYSICS_BUILTIN) {
      this._body.__preload(this);
    }
  };

  _proto.onEnable = function onEnable() {
    if (!CC_EDITOR && !CC_PHYSICS_BUILTIN) {
      this._body.onEnable();
    }
  };

  _proto.onDisable = function onDisable() {
    if (!CC_EDITOR && !CC_PHYSICS_BUILTIN) {
      this._body.onDisable();
    }
  };

  _proto.onDestroy = function onDestroy() {
    if (!CC_EDITOR && !CC_PHYSICS_BUILTIN) {
      this._body.onDestroy();
    }
  } /// PUBLIC METHOD ///

  /**
   * !#en
   * A force is applied to a rigid body at a point in world space.
   * !#zh
   * 在世界空间中的某点上对刚体施加一个作用力。
   * @method applyForce
   * @param {Vec3} force
   * @param {Vec3} relativePoint The point of action, relative to the center of the rigid body
   */
  ;

  _proto.applyForce = function applyForce(force, relativePoint) {
    if (this._assertOnload && !CC_EDITOR && !CC_PHYSICS_BUILTIN) {
      this._body.applyForce(force, relativePoint);
    }
  }
  /**
   * !#en
   * Apply a force on the rigid body at a point in local space.
   * !#zh
   * 在本地空间中的某点上对刚体施加一个作用力。
   * @method applyLocalForce
   * @param {Vec3} force 
   * @param {Vec3} localPoint Point of application
   */
  ;

  _proto.applyLocalForce = function applyLocalForce(force, localPoint) {
    if (this._assertOnload && !CC_EDITOR && !CC_PHYSICS_BUILTIN) {
      this._body.applyLocalForce(force, localPoint);
    }
  }
  /**
   * !#en
   * Apply an impulse to a rigid body at a point in world space.
   * !#zh
   * 在世界空间的某点上对刚体施加一个冲量。
   * @method applyImpulse
   * @param {Vec3} impulse
   * @param {Vec3} relativePoint The point of action, relative to the center of the rigid body
   */
  ;

  _proto.applyImpulse = function applyImpulse(impulse, relativePoint) {
    if (this._assertOnload && !CC_EDITOR && !CC_PHYSICS_BUILTIN) {
      this._body.applyImpulse(impulse, relativePoint);
    }
  }
  /**
   * !#en
   * Apply an impulse to the rigid body at a point in local space.
   * !#zh
   * 在本地空间的某点上对刚体施加一个冲量。
   * @method applyLocalImpulse
   * @param {Vec3} impulse
   * @param {Vec3} localPoint Point of application
   */
  ;

  _proto.applyLocalImpulse = function applyLocalImpulse(impulse, localPoint) {
    if (this._assertOnload && !CC_EDITOR && !CC_PHYSICS_BUILTIN) {
      this._body.applyLocalImpulse(impulse, localPoint);
    }
  }
  /**
   * !#en
   * Apply a torque to the rigid body.
   * !#zh
   * 对刚体施加扭转力。
   * @method applyTorque
   * @param {Vec3} torque
   */
  ;

  _proto.applyTorque = function applyTorque(torque) {
    if (this._assertOnload && !CC_EDITOR && !CC_PHYSICS_BUILTIN) {
      this._body.applyTorque(torque);
    }
  }
  /**
   * !#en
   * Apply a local torque to the rigid body.
   * !#zh
   * 对刚体施加本地扭转力。
   * @method applyLocalTorque
   * @param {Vec3} torque
   */
  ;

  _proto.applyLocalTorque = function applyLocalTorque(torque) {
    if (this._assertOnload && !CC_EDITOR && !CC_PHYSICS_BUILTIN) {
      this._body.applyLocalTorque(torque);
    }
  }
  /**
   * !#en
   * Awaken the rigid body.
   * !#zh
   * 唤醒刚体。
   * @method wakeUp
   */
  ;

  _proto.wakeUp = function wakeUp() {
    if (this._assertOnload && !CC_EDITOR && !CC_PHYSICS_BUILTIN) {
      this._body.wakeUp();
    }
  }
  /**
   * !#en
   * Dormant rigid body.
   * !#zh
   * 休眠刚体。
   * @method sleep
   */
  ;

  _proto.sleep = function sleep() {
    if (this._assertOnload && !CC_EDITOR && !CC_PHYSICS_BUILTIN) {
      this._body.sleep();
    }
  }
  /**
   * !#en
   * Get linear velocity.
   * !#zh
   * 获取线性速度。
   * @method getLinearVelocity
   * @param {Vec3} out
   */
  ;

  _proto.getLinearVelocity = function getLinearVelocity(out) {
    if (this._assertOnload && !CC_EDITOR && !CC_PHYSICS_BUILTIN) {
      this._body.getLinearVelocity(out);
    }
  }
  /**
   * !#en
   * Set linear speed.
   * !#zh
   * 设置线性速度。
   * @method setLinearVelocity
   * @param {Vec3} value 
   */
  ;

  _proto.setLinearVelocity = function setLinearVelocity(value) {
    if (this._assertOnload && !CC_EDITOR && !CC_PHYSICS_BUILTIN) {
      this._body.setLinearVelocity(value);
    }
  }
  /**
   * !#en
   * Gets the rotation speed.
   * !#zh
   * 获取旋转速度。
   * @method getAngularVelocity
   * @param {Vec3} out 
   */
  ;

  _proto.getAngularVelocity = function getAngularVelocity(out) {
    if (this._assertOnload && !CC_EDITOR && !CC_PHYSICS_BUILTIN) {
      this._body.getAngularVelocity(out);
    }
  }
  /**
   * !#en
   * Set rotation speed.
   * !#zh
   * 设置旋转速度。
   * @method setAngularVelocity
   * @param {Vec3} value 
   */
  ;

  _proto.setAngularVelocity = function setAngularVelocity(value) {
    if (this._assertOnload && !CC_EDITOR && !CC_PHYSICS_BUILTIN) {
      this._body.setAngularVelocity(value);
    }
  };

  return RigidBody3D;
}(cc.Component), _temp), (_applyDecoratedDescriptor(_class2.prototype, "mass", [_dec4], Object.getOwnPropertyDescriptor(_class2.prototype, "mass"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "linearDamping", [_dec5], Object.getOwnPropertyDescriptor(_class2.prototype, "linearDamping"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "angularDamping", [_dec6], Object.getOwnPropertyDescriptor(_class2.prototype, "angularDamping"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "isKinematic", [_dec7], Object.getOwnPropertyDescriptor(_class2.prototype, "isKinematic"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "useGravity", [_dec8], Object.getOwnPropertyDescriptor(_class2.prototype, "useGravity"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "fixedRotation", [_dec9], Object.getOwnPropertyDescriptor(_class2.prototype, "fixedRotation"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "linearFactor", [_dec10], Object.getOwnPropertyDescriptor(_class2.prototype, "linearFactor"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "angularFactor", [_dec11], Object.getOwnPropertyDescriptor(_class2.prototype, "angularFactor"), _class2.prototype), _descriptor = _applyDecoratedDescriptor(_class2.prototype, "_mass", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 10;
  }
}), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "_linearDamping", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 0.1;
  }
}), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "_angularDamping", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 0.1;
  }
}), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "_fixedRotation", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return false;
  }
}), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "_isKinematic", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return false;
  }
}), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "_useGravity", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return true;
  }
}), _descriptor7 = _applyDecoratedDescriptor(_class2.prototype, "_linearFactor", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new Vec3(1, 1, 1);
  }
}), _descriptor8 = _applyDecoratedDescriptor(_class2.prototype, "_angularFactor", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new Vec3(1, 1, 1);
  }
})), _class2)) || _class) || _class) || _class) || _class) || _class);
exports.RigidBody3D = RigidBody3D;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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