
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/physics/framework/components/constant-force.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports.ConstantForce = void 0;

var _rigidBodyComponent = require("./rigid-body-component");

var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _temp;

function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

var _cc$_decorator = cc._decorator,
    ccclass = _cc$_decorator.ccclass,
    executeInEditMode = _cc$_decorator.executeInEditMode,
    executionOrder = _cc$_decorator.executionOrder,
    menu = _cc$_decorator.menu,
    property = _cc$_decorator.property,
    requireComponent = _cc$_decorator.requireComponent,
    disallowMultiple = _cc$_decorator.disallowMultiple;
var Vec3 = cc.Vec3;
/**
 * !#en
 * Each frame applies a constant force to a rigid body, depending on the RigidBody3D
 * !#zh
 * 在每帧对一个刚体施加持续的力，依赖 RigidBody3D 组件
 * @class ConstantForce
 * @extends Component
 */

var ConstantForce = (_dec = ccclass('cc.ConstantForce'), _dec2 = executionOrder(98), _dec3 = requireComponent(_rigidBodyComponent.RigidBody3D), _dec4 = menu('i18n:MAIN_MENU.component.physics/Constant Force 3D'), _dec5 = property({
  displayOrder: 0
}), _dec6 = property({
  displayOrder: 1
}), _dec7 = property({
  displayOrder: 2
}), _dec8 = property({
  displayOrder: 3
}), _dec(_class = _dec2(_class = _dec3(_class = _dec4(_class = disallowMultiple(_class = executeInEditMode(_class = (_class2 = (_temp =
/*#__PURE__*/
function (_cc$Component) {
  _inheritsLoose(ConstantForce, _cc$Component);

  function ConstantForce() {
    var _this;

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _cc$Component.call.apply(_cc$Component, [this].concat(args)) || this;
    _this._rigidbody = null;

    _initializerDefineProperty(_this, "_force", _descriptor, _assertThisInitialized(_this));

    _initializerDefineProperty(_this, "_localForce", _descriptor2, _assertThisInitialized(_this));

    _initializerDefineProperty(_this, "_torque", _descriptor3, _assertThisInitialized(_this));

    _initializerDefineProperty(_this, "_localTorque", _descriptor4, _assertThisInitialized(_this));

    _this._mask = 0;
    return _this;
  }

  var _proto = ConstantForce.prototype;

  _proto.onLoad = function onLoad() {
    if (!CC_PHYSICS_BUILTIN) {
      this._rigidbody = this.node.getComponent(_rigidBodyComponent.RigidBody3D);

      this._maskUpdate(this._force, 1);

      this._maskUpdate(this._localForce, 2);

      this._maskUpdate(this._torque, 4);

      this._maskUpdate(this._localTorque, 8);
    }
  };

  _proto.lateUpdate = function lateUpdate(dt) {
    if (!CC_PHYSICS_BUILTIN) {
      if (this._rigidbody != null && this._mask != 0) {
        if (this._mask & 1) {
          this._rigidbody.applyForce(this._force);
        }

        if (this._mask & 2) {
          this._rigidbody.applyLocalForce(this.localForce);
        }

        if (this._mask & 4) {
          this._rigidbody.applyTorque(this._torque);
        }

        if (this._mask & 8) {
          this._rigidbody.applyLocalTorque(this._localTorque);
        }
      }
    }
  };

  _proto._maskUpdate = function _maskUpdate(t, m) {
    if (Vec3.strictEquals(t, Vec3.ZERO)) {
      this._mask &= ~m;
    } else {
      this._mask |= m;
    }
  };

  _createClass(ConstantForce, [{
    key: "force",

    /**
     * !#en
     * To get and set the force that the world is facing, use this.force = otherVec3
     * !#zh
     * 获取和设置世界朝向的力, 设置时请用 this.force = otherVec3 的方式
     * @property {Vec3} force
     */
    get: function get() {
      return this._force;
    },
    set: function set(value) {
      Vec3.copy(this._force, value);

      this._maskUpdate(this._force, 1);
    }
    /**
     * !#en
     * Get and set the force of the local orientation, using this.localforce = otherVec3
     * !#zh
     * 获取和设置本地朝向的力, 设置时请用 this.localForce = otherVec3 的方式
     * @property {Vec3} localForce
     */

  }, {
    key: "localForce",
    get: function get() {
      return this._localForce;
    },
    set: function set(value) {
      Vec3.copy(this._localForce, value);

      this._maskUpdate(this.localForce, 2);
    }
    /**
     * !#zh
     * 获取和设置世界朝向的扭转力
     * @note
     * 设置时请用 this.torque = otherVec3 的方式
     * @property {Vec3} torque
     */

  }, {
    key: "torque",
    get: function get() {
      return this._torque;
    },
    set: function set(value) {
      Vec3.copy(this._torque, value);

      this._maskUpdate(this._torque, 4);
    }
    /**
     * !#en
     * Get and set the torque of the local orientation using this.localtorque = otherVec3
     * !#zh
     * 获取和设置本地朝向的扭转力, 设置时请用 this.localTorque = otherVec3 的方式
     * @property {Vec3} localTorque
     */

  }, {
    key: "localTorque",
    get: function get() {
      return this._localTorque;
    },
    set: function set(value) {
      Vec3.copy(this._localTorque, value);

      this._maskUpdate(this._localTorque, 8);
    }
  }]);

  return ConstantForce;
}(cc.Component), _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "_force", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new Vec3();
  }
}), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "_localForce", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new Vec3();
  }
}), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "_torque", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new Vec3();
  }
}), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "_localTorque", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new Vec3();
  }
}), _applyDecoratedDescriptor(_class2.prototype, "force", [_dec5], Object.getOwnPropertyDescriptor(_class2.prototype, "force"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "localForce", [_dec6], Object.getOwnPropertyDescriptor(_class2.prototype, "localForce"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "torque", [_dec7], Object.getOwnPropertyDescriptor(_class2.prototype, "torque"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "localTorque", [_dec8], Object.getOwnPropertyDescriptor(_class2.prototype, "localTorque"), _class2.prototype)), _class2)) || _class) || _class) || _class) || _class) || _class) || _class);
exports.ConstantForce = ConstantForce;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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