
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/physics/framework/components/collider/collider-component.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports.Collider3D = void 0;

var _physicsMaterial = require("../../assets/physics-material");

var _dec, _dec2, _dec3, _dec4, _dec5, _class, _class2, _descriptor, _descriptor2, _descriptor3, _temp;

function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

var _cc$_decorator = cc._decorator,
    ccclass = _cc$_decorator.ccclass,
    property = _cc$_decorator.property;
var Vec3 = cc.Vec3;
/**
 * !#en
 * The base class of the collider
 * !#zh
 * 碰撞器的基类
 * @class Collider3D
 * @extends Component
 * @uses EventTarget
 */

var Collider3D = (_dec = ccclass('cc.Collider3D'), _dec2 = property({
  type: _physicsMaterial.PhysicsMaterial,
  displayName: 'Material',
  displayOrder: -1
}), _dec3 = property({
  displayOrder: 0
}), _dec4 = property({
  type: cc.Vec3,
  displayOrder: 1
}), _dec5 = property({
  type: _physicsMaterial.PhysicsMaterial
}), _dec(_class = (_class2 = (_temp =
/*#__PURE__*/
function (_cc$Component) {
  _inheritsLoose(Collider3D, _cc$Component);

  _createClass(Collider3D, [{
    key: "sharedMaterial",

    /**
     * @property {PhysicsMaterial} sharedMaterial
     */
    get: function get() {
      return this._material;
    },
    set: function set(value) {
      this.material = value;
    }
  }, {
    key: "material",
    get: function get() {
      if (!CC_PHYSICS_BUILTIN) {
        if (this._isSharedMaterial && this._material != null) {
          this._material.off('physics_material_update', this._updateMaterial, this);

          this._material = this._material.clone();

          this._material.on('physics_material_update', this._updateMaterial, this);

          this._isSharedMaterial = false;
        }
      }

      return this._material;
    },
    set: function set(value) {
      if (CC_EDITOR || CC_PHYSICS_BUILTIN) {
        this._material = value;
        return;
      }

      if (value != null && this._material != null) {
        if (this._material._uuid != value._uuid) {
          this._material.off('physics_material_update', this._updateMaterial, this);

          value.on('physics_material_update', this._updateMaterial, this);
          this._isSharedMaterial = false;
          this._material = value;
        }
      } else if (value != null && this._material == null) {
        value.on('physics_material_update', this._updateMaterial, this);
        this._material = value;
      } else if (value == null && this._material != null) {
        this._material.off('physics_material_update', this._updateMaterial, this);

        this._material = value;
      }

      this._updateMaterial();
    }
    /**
     * !#en
     * get or set the collider is trigger, this will be always trigger if using builtin.
     * !#zh
     * 获取或设置碰撞器是否为触发器
     * @property {Boolean} isTrigger
     */

  }, {
    key: "isTrigger",
    get: function get() {
      return this._isTrigger;
    },
    set: function set(value) {
      this._isTrigger = value;

      if (!CC_EDITOR) {
        this._shape.isTrigger = this._isTrigger;
      }
    }
    /**
     * !#en
     * get or set the center of the collider, in local space.
     * !#zh
     * 获取或设置碰撞器的中心点。
     * @property {Vec3} center
     */

  }, {
    key: "center",
    get: function get() {
      return this._center;
    },
    set: function set(value) {
      Vec3.copy(this._center, value);

      if (!CC_EDITOR) {
        this._shape.center = this._center;
      }
    }
    /**
     * !#en
     * get the collider attached rigidbody, this may be null
     * !#zh
     * 获取碰撞器所绑定的刚体组件，可能为 null
     * @property {RigidBody3D|null} attachedRigidbody
     * @readonly
     */

  }, {
    key: "attachedRigidbody",
    get: function get() {
      return this.shape.attachedRigidBody;
    }
    /**
     * !#en
     * get collider shape
     * !#zh
     * 获取碰撞器形状
     * @property {IBaseShape} shape
     * @readonly
     */

  }, {
    key: "shape",
    get: function get() {
      return this._shape;
    } /// PRIVATE PROPERTY ///

  }, {
    key: "_assertOnload",
    get: function get() {
      var r = this._isOnLoadCalled == 0;

      if (r) {
        cc.error('Physics Error: Please make sure that the node has been added to the scene');
      }

      return !r;
    }
  }]);

  function Collider3D() {
    var _this;

    _this = _cc$Component.call(this) || this;
    _this._shape = void 0;
    _this._isSharedMaterial = true;

    _initializerDefineProperty(_this, "_material", _descriptor, _assertThisInitialized(_this));

    _initializerDefineProperty(_this, "_isTrigger", _descriptor2, _assertThisInitialized(_this));

    _initializerDefineProperty(_this, "_center", _descriptor3, _assertThisInitialized(_this));

    cc.EventTarget.call(_assertThisInitialized(_this));
    return _this;
  } /// EVENT INTERFACE ///

  /**
   * !#en
   * Register an callback of a specific event type on the EventTarget.
   * This type of event should be triggered via `emit`.
   * !#zh
   * 注册事件目标的特定事件类型回调。这种类型的事件应该被 `emit` 触发。
   *
   * @method on
   * @param {String} type - The type of collider event can be 'trigger-enter', 'trigger-stay', 'trigger-exit' or 'collision-enter', 'collision-stay', 'collision-exit'.
   * @param {Function} callback - The callback that will be invoked when the event is dispatched.
   *                              The callback is ignored if it is a duplicate (the callbacks are unique).
   * @param {ITriggerEvent|ICollisionEvent} callback.event callback function argument
   * @param {Object} [target] - The target (this object) to invoke the callback, can be null
   * @return {Function} - Just returns the incoming callback so you can save the anonymous function easier.
   * @typescript
   * on<T extends Function>(type: string, callback: T, target?: any, useCapture?: boolean): T
   * @example
   * eventTarget.on('fire', function (event) {
   *     // event is ITriggerEvent or ICollisionEvent
   * }, node);
   */


  var _proto = Collider3D.prototype;

  _proto.on = function on(type, callback, target, useCapture) {}
  /**
   * !#en
   * Removes the listeners previously registered with the same type, callback, target and or useCapture,
   * if only type is passed as parameter, all listeners registered with that type will be removed.
   * !#zh
   * 删除之前用同类型，回调，目标或 useCapture 注册的事件监听器，如果只传递 type，将会删除 type 类型的所有事件监听器。
   *
   * @method off
   * @param {String} type - The type of collider event can be 'trigger-enter', 'trigger-stay', 'trigger-exit' or 'collision-enter', 'collision-stay', 'collision-exit'.
   * @param {Function} [callback] - The callback to remove.
   * @param {Object} [target] - The target (this object) to invoke the callback, if it's not given, only callback without target will be removed
   * @example
   * // register fire eventListener
   * var callback = eventTarget.on('fire', function () {
   *     cc.log("fire in the hole");
   * }, target);
   * // remove fire event listener
   * eventTarget.off('fire', callback, target);
   * // remove all fire event listeners
   * eventTarget.off('fire');
   */
  ;

  _proto.off = function off(type, callback, target) {}
  /**
   * !#en
   * Register an callback of a specific event type on the EventTarget,
   * the callback will remove itself after the first time it is triggered.
   * !#zh
   * 注册事件目标的特定事件类型回调，回调会在第一时间被触发后删除自身。
   *
   * @method once
   * @param {String} type - The type of collider event can be 'trigger-enter', 'trigger-stay', 'trigger-exit' or 'collision-enter', 'collision-stay', 'collision-exit'.
   * @param {Function} callback - The callback that will be invoked when the event is dispatched.
   *                              The callback is ignored if it is a duplicate (the callbacks are unique).
   * @param {ITriggerEvent|ICollisionEvent} callback.event callback function argument.
   * @param {Object} [target] - The target (this object) to invoke the callback, can be null
   * @example
   * eventTarget.once('fire', function (event) {
   *     // event is ITriggerEvent or ICollisionEvent
   * }, node);
   */
  ;

  _proto.once = function once(type, callback, target) {}
  /* declare for typescript tip */
  ;

  _proto.emit = function emit(key) {} /// COMPONENT LIFECYCLE ///
  ;

  _proto.__preload = function __preload() {
    if (!CC_EDITOR) {
      this._shape.__preload(this);
    }
  };

  _proto.onLoad = function onLoad() {
    if (!CC_EDITOR) {
      if (!CC_PHYSICS_BUILTIN) {
        this.sharedMaterial = this._material == null ? cc.director.getPhysics3DManager().defaultMaterial : this._material;
      }

      this._shape.onLoad();
    }
  };

  _proto.onEnable = function onEnable() {
    if (!CC_EDITOR) {
      this._shape.onEnable();
    }
  };

  _proto.onDisable = function onDisable() {
    if (!CC_EDITOR) {
      this._shape.onDisable();
    }
  };

  _proto.onDestroy = function onDestroy() {
    if (!CC_EDITOR) {
      this._shape.onDestroy();
    }
  };

  _proto._updateMaterial = function _updateMaterial() {
    if (!CC_EDITOR) {
      this._shape.material = this._material;
    }
  };

  return Collider3D;
}(cc.Component), _temp), (_applyDecoratedDescriptor(_class2.prototype, "sharedMaterial", [_dec2], Object.getOwnPropertyDescriptor(_class2.prototype, "sharedMaterial"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "isTrigger", [_dec3], Object.getOwnPropertyDescriptor(_class2.prototype, "isTrigger"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "center", [_dec4], Object.getOwnPropertyDescriptor(_class2.prototype, "center"), _class2.prototype), _descriptor = _applyDecoratedDescriptor(_class2.prototype, "_material", [_dec5], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return null;
  }
}), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "_isTrigger", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return false;
  }
}), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "_center", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new Vec3();
  }
})), _class2)) || _class);
exports.Collider3D = Collider3D;
cc.js.mixin(Collider3D.prototype, cc.EventTarget.prototype);
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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