
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/physics/cocos/utils/array-collision-matrix.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports.ArrayCollisionMatrix = void 0;

/****************************************************************************
 Copyright (c) 2019 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

/**
 * Collision "matrix". It's actually a triangular-shaped array of whether two bodies are touching this step, for reference next step
 */
var ArrayCollisionMatrix =
/*#__PURE__*/
function () {
  function ArrayCollisionMatrix() {
    this.matrix = [];
  }

  var _proto = ArrayCollisionMatrix.prototype;

  /**
   * !#en Get an element
   * @method get
   * @param  {Number} i
   * @param  {Number} j
   * @return {Number}
   */
  _proto.get = function get(i, j) {
    if (j > i) {
      var temp = j;
      j = i;
      i = temp;
    }

    return this.matrix[(i * (i + 1) >> 1) + j - 1];
  }
  /**
   * !#en Set an element
   * @method set
   * @param {Number} i
   * @param {Number} j
   * @param {boolean} value
   */
  ;

  _proto.set = function set(i, j, value) {
    if (j > i) {
      var temp = j;
      j = i;
      i = temp;
    }

    this.matrix[(i * (i + 1) >> 1) + j - 1] = value ? 1 : 0;
  }
  /**
   * !#en Sets all elements to zero
   * @method reset
   */
  ;

  _proto.reset = function reset() {
    for (var i = 0, l = this.matrix.length; i !== l; i++) {
      this.matrix[i] = 0;
    }
  }
  /**
   * !#en Sets the max number of objects
   * @param {Number} n
   */
  ;

  _proto.setNumObjects = function setNumObjects(n) {
    this.matrix.length = n * (n - 1) >> 1;
  };

  return ArrayCollisionMatrix;
}();

exports.ArrayCollisionMatrix = ArrayCollisionMatrix;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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