
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/physics/cocos/builtin-world.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports.BuiltInWorld = void 0;

var _builtinSharedBody = require("./builtin-shared-body");

var _arrayCollisionMatrix = require("./utils/array-collision-matrix");

var _util = require("../framework/util");

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var fastRemove = cc.js.array.fastRemove;
var intersect = cc.geomUtils.intersect;
var Vec3 = cc.Vec3;
var hitPoint = new Vec3();
var TriggerEventObject = {
  type: 'collision-enter',
  selfCollider: null,
  otherCollider: null
};
/**
 * Built-in collision system, intended for use as a
 * efficient discrete collision detector,
 * not a full physical simulator
 */

var BuiltInWorld =
/*#__PURE__*/
function () {
  function BuiltInWorld() {
    this.shapeArr = [];
    this.bodies = [];
    this._shapeArrOld = [];
    this._collisionMatrix = new _arrayCollisionMatrix.ArrayCollisionMatrix();
    this._collisionMatrixPrev = new _arrayCollisionMatrix.ArrayCollisionMatrix();
  }

  var _proto = BuiltInWorld.prototype;

  _proto.step = function step() {
    // store and reset collsion array
    this._shapeArrOld = this.shapeArr.slice();
    this.shapeArr.length = 0;
    (0, _util.clearNodeTransformRecord)(); // sync scene to collision

    for (var i = 0; i < this.bodies.length; i++) {
      this.bodies[i].syncSceneToPhysics();
    }

    (0, _util.clearNodeTransformDirtyFlag)();
    var collisionMatrix = cc.game.collisionMatrix; // collision detection

    for (var _i = 0; _i < this.bodies.length; _i++) {
      var bodyA = this.bodies[_i];
      var nodeA = bodyA.node;
      var nodeACollisionMatrix = collisionMatrix[nodeA.groupIndex];
      if (!nodeACollisionMatrix) continue;

      for (var j = _i + 1; j < this.bodies.length; j++) {
        var bodyB = this.bodies[j];
        var nodeB = bodyB.node;

        if (nodeA !== nodeB && nodeACollisionMatrix[nodeB.groupIndex]) {
          bodyA.intersects(bodyB);
        }
      }
    } // emit collider event


    this.emitColliderEvent();
  };

  _proto.raycastClosest = function raycastClosest(worldRay, options, out) {
    var tmp_d = Infinity;
    var max_d = options.maxDistance;
    var groupIndex = options.groupIndex;
    var collisionMatrix = cc.game.collisionMatrix;
    var rayCollisionMatrix = collisionMatrix[groupIndex];
    if (!rayCollisionMatrix) return false;

    for (var i = 0; i < this.bodies.length; i++) {
      var body = this.bodies[i];
      var bodyGroupIndex = body.node.groupIndex;
      var canCollider = rayCollisionMatrix[bodyGroupIndex];
      if (!canCollider) continue;

      for (var _i2 = 0; _i2 < body.shapes.length; _i2++) {
        var shape = body.shapes[_i2];
        var distance = intersect.resolve(worldRay, shape.worldShape);

        if (distance == 0 || distance > max_d) {
          continue;
        }

        if (tmp_d > distance) {
          tmp_d = distance;
          Vec3.normalize(hitPoint, worldRay.d);
          Vec3.scaleAndAdd(hitPoint, worldRay.o, hitPoint, distance);

          out._assign(hitPoint, distance, shape.collider);
        }
      }
    }

    return !(tmp_d == Infinity);
  };

  _proto.raycast = function raycast(worldRay, options, pool, results) {
    var max_d = options.maxDistance;
    var groupIndex = options.groupIndex;
    var collisionMatrix = cc.game.collisionMatrix;
    var rayCollisionMatrix = collisionMatrix[groupIndex];
    if (!rayCollisionMatrix) return false;

    for (var i = 0; i < this.bodies.length; i++) {
      var body = this.bodies[i];
      var bodyGroupIndex = body.node.groupIndex;
      var canCollider = rayCollisionMatrix[bodyGroupIndex];
      if (!canCollider) continue;

      for (var _i3 = 0; _i3 < body.shapes.length; _i3++) {
        var shape = body.shapes[_i3];
        var distance = intersect.resolve(worldRay, shape.worldShape);

        if (distance == 0 || distance > max_d) {
          continue;
        } else {
          var r = pool.add();
          worldRay.computeHit(hitPoint, distance);

          r._assign(hitPoint, distance, shape.collider);

          results.push(r);
        }
      }
    }

    return results.length > 0;
  };

  _proto.getSharedBody = function getSharedBody(node) {
    return _builtinSharedBody.BuiltinSharedBody.getSharedBody(node, this);
  };

  _proto.addSharedBody = function addSharedBody(body) {
    var index = this.bodies.indexOf(body);

    if (index < 0) {
      this.bodies.push(body);
    }
  };

  _proto.removeSharedBody = function removeSharedBody(body) {
    fastRemove(this.bodies, body);
  };

  _proto.emitColliderEvent = function emitColliderEvent() {
    var shapeA;
    var shapeB;

    for (var i = 0; i < this.shapeArr.length; i += 2) {
      shapeA = this.shapeArr[i];
      shapeB = this.shapeArr[i + 1];
      TriggerEventObject.selfCollider = shapeA.collider;
      TriggerEventObject.otherCollider = shapeB.collider;

      this._collisionMatrix.set(shapeA.id, shapeB.id, true);

      if (this._collisionMatrixPrev.get(shapeA.id, shapeB.id)) {
        // emit stay
        TriggerEventObject.type = 'trigger-stay';
      } else {
        // first collider, emit enter
        TriggerEventObject.type = 'trigger-enter';
      }

      if (shapeA.collider) {
        shapeA.collider.emit(TriggerEventObject.type, TriggerEventObject);
      }

      TriggerEventObject.selfCollider = shapeB.collider;
      TriggerEventObject.otherCollider = shapeA.collider;

      if (shapeB.collider) {
        shapeB.collider.emit(TriggerEventObject.type, TriggerEventObject);
      }
    }

    for (var _i4 = 0; _i4 < this._shapeArrOld.length; _i4 += 2) {
      shapeA = this._shapeArrOld[_i4];
      shapeB = this._shapeArrOld[_i4 + 1];

      if (this._collisionMatrixPrev.get(shapeA.id, shapeB.id)) {
        if (!this._collisionMatrix.get(shapeA.id, shapeB.id)) {
          // emit exit
          TriggerEventObject.type = 'trigger-exit';
          TriggerEventObject.selfCollider = shapeA.collider;
          TriggerEventObject.otherCollider = shapeB.collider;

          if (shapeA.collider) {
            shapeA.collider.emit(TriggerEventObject.type, TriggerEventObject);
          }

          TriggerEventObject.selfCollider = shapeB.collider;
          TriggerEventObject.otherCollider = shapeA.collider;

          if (shapeB.collider) {
            shapeB.collider.emit(TriggerEventObject.type, TriggerEventObject);
          }

          this._collisionMatrix.set(shapeA.id, shapeB.id, false);
        }
      }
    }

    this._collisionMatrixPrev.matrix = this._collisionMatrix.matrix.slice();

    this._collisionMatrix.reset();
  };

  _createClass(BuiltInWorld, [{
    key: "gravity",
    set: function set(v) {}
  }, {
    key: "allowSleep",
    set: function set(v) {}
  }, {
    key: "defaultMaterial",
    set: function set(v) {}
  }]);

  return BuiltInWorld;
}();

exports.BuiltInWorld = BuiltInWorld;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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