
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/physics/cocos/builtin-shared-body.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports.BuiltinSharedBody = void 0;

var _util = require("../framework/util");

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var intersect = cc.geomUtils.intersect;
var fastRemove = cc.js.array.fastRemove;
/**
 * Built-in static collider, no physical forces involved
 */

var BuiltinSharedBody =
/*#__PURE__*/
function () {
  BuiltinSharedBody.getSharedBody = function getSharedBody(node, wrappedWorld) {
    var key = node._id;

    if (BuiltinSharedBody.sharedBodiesMap.has(key)) {
      return BuiltinSharedBody.sharedBodiesMap.get(key);
    } else {
      var newSB = new BuiltinSharedBody(node, wrappedWorld);
      BuiltinSharedBody.sharedBodiesMap.set(node._id, newSB);
      return newSB;
    }
  };

  _createClass(BuiltinSharedBody, [{
    key: "id",
    get: function get() {
      return this._id;
    }
    /**
     * add or remove from world \
     * add, if enable \
     * remove, if disable & shapes.length == 0 & wrappedBody disable
     */

  }, {
    key: "enabled",
    set: function set(v) {
      if (v) {
        if (this.index < 0) {
          this.index = this.world.bodies.length;
          this.world.addSharedBody(this);
          this.syncSceneToPhysics(true);
        }
      } else {
        if (this.index >= 0) {
          var isRemove = this.shapes.length == 0;

          if (isRemove) {
            this.index = -1;
            this.world.removeSharedBody(this);
          }
        }
      }
    }
  }, {
    key: "reference",
    set: function set(v) {
      v ? this.ref++ : this.ref--;

      if (this.ref == 0) {
        this.destory();
      }
    }
    /** id generator */

  }]);

  function BuiltinSharedBody(node, world) {
    this._id = void 0;
    this.index = -1;
    this.ref = 0;
    this.node = void 0;
    this.world = void 0;
    this.shapes = [];
    this._id = BuiltinSharedBody.idCounter++;
    this.node = node;
    this.world = world;
  }

  var _proto = BuiltinSharedBody.prototype;

  _proto.intersects = function intersects(body) {
    for (var i = 0; i < this.shapes.length; i++) {
      var shapeA = this.shapes[i];

      for (var j = 0; j < body.shapes.length; j++) {
        var shapeB = body.shapes[j];

        if (intersect.resolve(shapeA.worldShape, shapeB.worldShape)) {
          this.world.shapeArr.push(shapeA);
          this.world.shapeArr.push(shapeB);
        }
      }
    }
  };

  _proto.addShape = function addShape(shape) {
    var i = this.shapes.indexOf(shape);

    if (i < 0) {
      this.shapes.push(shape);
    }
  };

  _proto.removeShape = function removeShape(shape) {
    fastRemove(this.shapes, shape);
  };

  _proto.syncSceneToPhysics = function syncSceneToPhysics(force) {
    if (force === void 0) {
      force = false;
    }

    var node = this.node;
    var needUpdateTransform = (0, _util.updateWorldTransform)(node, force);
    if (!force && !needUpdateTransform) return;

    for (var i = 0; i < this.shapes.length; i++) {
      this.shapes[i].transform(node._worldMatrix, node.__wpos, node.__wrot, node.__wscale);
    }
  };

  _proto.destory = function destory() {
    BuiltinSharedBody.sharedBodiesMap["delete"](this.node._id);
    this.node = null;
    this.world = null;
    this.shapes = null;
  };

  return BuiltinSharedBody;
}();

exports.BuiltinSharedBody = BuiltinSharedBody;
BuiltinSharedBody.sharedBodiesMap = new Map();
BuiltinSharedBody.idCounter = 0;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvY29jb3MyZC9jb3JlLzNkL3BoeXNpY3MvY29jb3MvYnVpbHRpbi1zaGFyZWQtYm9keS50cyJdLCJuYW1lcyI6WyJpbnRlcnNlY3QiLCJjYyIsImdlb21VdGlscyIsImZhc3RSZW1vdmUiLCJqcyIsImFycmF5IiwiQnVpbHRpblNoYXJlZEJvZHkiLCJnZXRTaGFyZWRCb2R5Iiwibm9kZSIsIndyYXBwZWRXb3JsZCIsImtleSIsIl9pZCIsInNoYXJlZEJvZGllc01hcCIsImhhcyIsImdldCIsIm5ld1NCIiwic2V0IiwidiIsImluZGV4Iiwid29ybGQiLCJib2RpZXMiLCJsZW5ndGgiLCJhZGRTaGFyZWRCb2R5Iiwic3luY1NjZW5lVG9QaHlzaWNzIiwiaXNSZW1vdmUiLCJzaGFwZXMiLCJyZW1vdmVTaGFyZWRCb2R5IiwicmVmIiwiZGVzdG9yeSIsImlkQ291bnRlciIsImludGVyc2VjdHMiLCJib2R5IiwiaSIsInNoYXBlQSIsImoiLCJzaGFwZUIiLCJyZXNvbHZlIiwid29ybGRTaGFwZSIsInNoYXBlQXJyIiwicHVzaCIsImFkZFNoYXBlIiwic2hhcGUiLCJpbmRleE9mIiwicmVtb3ZlU2hhcGUiLCJmb3JjZSIsIm5lZWRVcGRhdGVUcmFuc2Zvcm0iLCJ0cmFuc2Zvcm0iLCJfd29ybGRNYXRyaXgiLCJfX3dwb3MiLCJfX3dyb3QiLCJfX3dzY2FsZSIsIk1hcCJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7OztBQTBCQTs7Ozs7O0FBRUEsSUFBTUEsU0FBUyxHQUFHQyxFQUFFLENBQUNDLFNBQUgsQ0FBYUYsU0FBL0I7QUFDQSxJQUFNRyxVQUFVLEdBQUdGLEVBQUUsQ0FBQ0csRUFBSCxDQUFNQyxLQUFOLENBQVlGLFVBQS9CO0FBRUE7Ozs7SUFHYUc7OztvQkFJRkMsZ0JBQVAsdUJBQXNCQyxJQUF0QixFQUFxQ0MsWUFBckMsRUFBaUU7QUFDN0QsUUFBTUMsR0FBRyxHQUFHRixJQUFJLENBQUNHLEdBQWpCOztBQUNBLFFBQUlMLGlCQUFpQixDQUFDTSxlQUFsQixDQUFrQ0MsR0FBbEMsQ0FBc0NILEdBQXRDLENBQUosRUFBZ0Q7QUFDNUMsYUFBT0osaUJBQWlCLENBQUNNLGVBQWxCLENBQWtDRSxHQUFsQyxDQUFzQ0osR0FBdEMsQ0FBUDtBQUNILEtBRkQsTUFFTztBQUNILFVBQU1LLEtBQUssR0FBRyxJQUFJVCxpQkFBSixDQUFzQkUsSUFBdEIsRUFBNEJDLFlBQTVCLENBQWQ7QUFDQUgsTUFBQUEsaUJBQWlCLENBQUNNLGVBQWxCLENBQWtDSSxHQUFsQyxDQUFzQ1IsSUFBSSxDQUFDRyxHQUEzQyxFQUFnREksS0FBaEQ7QUFDQSxhQUFPQSxLQUFQO0FBQ0g7QUFDSjs7Ozt3QkFFUztBQUNOLGFBQU8sS0FBS0osR0FBWjtBQUNIO0FBRUQ7Ozs7Ozs7O3NCQUthTSxHQUFZO0FBQ3JCLFVBQUlBLENBQUosRUFBTztBQUNILFlBQUksS0FBS0MsS0FBTCxHQUFhLENBQWpCLEVBQW9CO0FBQ2hCLGVBQUtBLEtBQUwsR0FBYSxLQUFLQyxLQUFMLENBQVdDLE1BQVgsQ0FBa0JDLE1BQS9CO0FBQ0EsZUFBS0YsS0FBTCxDQUFXRyxhQUFYLENBQXlCLElBQXpCO0FBQ0EsZUFBS0Msa0JBQUwsQ0FBd0IsSUFBeEI7QUFDSDtBQUNKLE9BTkQsTUFNTztBQUNILFlBQUksS0FBS0wsS0FBTCxJQUFjLENBQWxCLEVBQXFCO0FBQ2pCLGNBQU1NLFFBQVEsR0FBSSxLQUFLQyxNQUFMLENBQVlKLE1BQVosSUFBc0IsQ0FBeEM7O0FBQ0EsY0FBSUcsUUFBSixFQUFjO0FBQ1YsaUJBQUtOLEtBQUwsR0FBYSxDQUFDLENBQWQ7QUFDQSxpQkFBS0MsS0FBTCxDQUFXTyxnQkFBWCxDQUE0QixJQUE1QjtBQUNIO0FBQ0o7QUFDSjtBQUNKOzs7c0JBRWNULEdBQVk7QUFDdkJBLE1BQUFBLENBQUMsR0FBRyxLQUFLVSxHQUFMLEVBQUgsR0FBZ0IsS0FBS0EsR0FBTCxFQUFqQjs7QUFDQSxVQUFJLEtBQUtBLEdBQUwsSUFBWSxDQUFoQixFQUFtQjtBQUFFLGFBQUtDLE9BQUw7QUFBaUI7QUFDekM7QUFFRDs7OztBQVVBLDZCQUFxQnBCLElBQXJCLEVBQW9DVyxLQUFwQyxFQUF5RDtBQUFBLFNBUnhDUixHQVF3QztBQUFBLFNBUGpETyxLQU9pRCxHQVBqQyxDQUFDLENBT2dDO0FBQUEsU0FOakRTLEdBTWlELEdBTm5DLENBTW1DO0FBQUEsU0FKaERuQixJQUlnRDtBQUFBLFNBSGhEVyxLQUdnRDtBQUFBLFNBRmhETSxNQUVnRCxHQUZ2QixFQUV1QjtBQUNyRCxTQUFLZCxHQUFMLEdBQVdMLGlCQUFpQixDQUFDdUIsU0FBbEIsRUFBWDtBQUNBLFNBQUtyQixJQUFMLEdBQVlBLElBQVo7QUFDQSxTQUFLVyxLQUFMLEdBQWFBLEtBQWI7QUFDSDs7OztTQUVEVyxhQUFBLG9CQUFZQyxJQUFaLEVBQXFDO0FBQ2pDLFNBQUssSUFBSUMsQ0FBQyxHQUFHLENBQWIsRUFBZ0JBLENBQUMsR0FBRyxLQUFLUCxNQUFMLENBQVlKLE1BQWhDLEVBQXdDVyxDQUFDLEVBQXpDLEVBQTZDO0FBQ3pDLFVBQU1DLE1BQU0sR0FBRyxLQUFLUixNQUFMLENBQVlPLENBQVosQ0FBZjs7QUFFQSxXQUFLLElBQUlFLENBQUMsR0FBRyxDQUFiLEVBQWdCQSxDQUFDLEdBQUdILElBQUksQ0FBQ04sTUFBTCxDQUFZSixNQUFoQyxFQUF3Q2EsQ0FBQyxFQUF6QyxFQUE2QztBQUN6QyxZQUFNQyxNQUFNLEdBQUdKLElBQUksQ0FBQ04sTUFBTCxDQUFZUyxDQUFaLENBQWY7O0FBRUEsWUFBSWxDLFNBQVMsQ0FBQ29DLE9BQVYsQ0FBa0JILE1BQU0sQ0FBQ0ksVUFBekIsRUFBcUNGLE1BQU0sQ0FBQ0UsVUFBNUMsQ0FBSixFQUE2RDtBQUN6RCxlQUFLbEIsS0FBTCxDQUFXbUIsUUFBWCxDQUFvQkMsSUFBcEIsQ0FBeUJOLE1BQXpCO0FBQ0EsZUFBS2QsS0FBTCxDQUFXbUIsUUFBWCxDQUFvQkMsSUFBcEIsQ0FBeUJKLE1BQXpCO0FBQ0g7QUFDSjtBQUNKO0FBQ0o7O1NBRURLLFdBQUEsa0JBQVVDLEtBQVYsRUFBcUM7QUFDakMsUUFBTVQsQ0FBQyxHQUFHLEtBQUtQLE1BQUwsQ0FBWWlCLE9BQVosQ0FBb0JELEtBQXBCLENBQVY7O0FBQ0EsUUFBSVQsQ0FBQyxHQUFHLENBQVIsRUFBVztBQUNQLFdBQUtQLE1BQUwsQ0FBWWMsSUFBWixDQUFpQkUsS0FBakI7QUFDSDtBQUNKOztTQUVERSxjQUFBLHFCQUFhRixLQUFiLEVBQXdDO0FBQ3BDdEMsSUFBQUEsVUFBVSxDQUFDLEtBQUtzQixNQUFOLEVBQWNnQixLQUFkLENBQVY7QUFDSDs7U0FFRGxCLHFCQUFBLDRCQUFvQnFCLEtBQXBCLEVBQTRDO0FBQUEsUUFBeEJBLEtBQXdCO0FBQXhCQSxNQUFBQSxLQUF3QixHQUFQLEtBQU87QUFBQTs7QUFDeEMsUUFBSXBDLElBQUksR0FBRyxLQUFLQSxJQUFoQjtBQUNBLFFBQUlxQyxtQkFBbUIsR0FBRyxnQ0FBcUJyQyxJQUFyQixFQUEyQm9DLEtBQTNCLENBQTFCO0FBQ0EsUUFBSSxDQUFDQSxLQUFELElBQVUsQ0FBQ0MsbUJBQWYsRUFBb0M7O0FBRXBDLFNBQUssSUFBSWIsQ0FBQyxHQUFHLENBQWIsRUFBZ0JBLENBQUMsR0FBRyxLQUFLUCxNQUFMLENBQVlKLE1BQWhDLEVBQXdDVyxDQUFDLEVBQXpDLEVBQTZDO0FBQ3pDLFdBQUtQLE1BQUwsQ0FBWU8sQ0FBWixFQUFlYyxTQUFmLENBQXlCdEMsSUFBSSxDQUFDdUMsWUFBOUIsRUFBNEN2QyxJQUFJLENBQUN3QyxNQUFqRCxFQUF5RHhDLElBQUksQ0FBQ3lDLE1BQTlELEVBQXNFekMsSUFBSSxDQUFDMEMsUUFBM0U7QUFDSDtBQUNKOztTQUVPdEIsVUFBUixtQkFBbUI7QUFDZnRCLElBQUFBLGlCQUFpQixDQUFDTSxlQUFsQixXQUF5QyxLQUFLSixJQUFMLENBQVVHLEdBQW5EO0FBQ0MsU0FBS0gsSUFBTixHQUFxQixJQUFyQjtBQUNDLFNBQUtXLEtBQU4sR0FBc0IsSUFBdEI7QUFDQyxTQUFLTSxNQUFOLEdBQXVCLElBQXZCO0FBQ0g7Ozs7OztBQXhHUW5CLGtCQUVlTSxrQkFBa0IsSUFBSXVDLEdBQUo7QUFGakM3QyxrQkFnRE11QixZQUFvQiIsInNvdXJjZXNDb250ZW50IjpbIi8qKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqXG4gQ29weXJpZ2h0IChjKSAyMDE5IFhpYW1lbiBZYWppIFNvZnR3YXJlIENvLiwgTHRkLlxuXG4gaHR0cHM6Ly93d3cuY29jb3MuY29tL1xuXG4gUGVybWlzc2lvbiBpcyBoZXJlYnkgZ3JhbnRlZCwgZnJlZSBvZiBjaGFyZ2UsIHRvIGFueSBwZXJzb24gb2J0YWluaW5nIGEgY29weVxuIG9mIHRoaXMgc29mdHdhcmUgYW5kIGFzc29jaWF0ZWQgZW5naW5lIHNvdXJjZSBjb2RlICh0aGUgXCJTb2Z0d2FyZVwiKSwgYSBsaW1pdGVkLFxuIHdvcmxkd2lkZSwgcm95YWx0eS1mcmVlLCBub24tYXNzaWduYWJsZSwgcmV2b2NhYmxlIGFuZCBub24tZXhjbHVzaXZlIGxpY2Vuc2VcbiB0byB1c2UgQ29jb3MgQ3JlYXRvciBzb2xlbHkgdG8gZGV2ZWxvcCBnYW1lcyBvbiB5b3VyIHRhcmdldCBwbGF0Zm9ybXMuIFlvdSBzaGFsbFxuIG5vdCB1c2UgQ29jb3MgQ3JlYXRvciBzb2Z0d2FyZSBmb3IgZGV2ZWxvcGluZyBvdGhlciBzb2Z0d2FyZSBvciB0b29scyB0aGF0J3NcbiB1c2VkIGZvciBkZXZlbG9waW5nIGdhbWVzLiBZb3UgYXJlIG5vdCBncmFudGVkIHRvIHB1Ymxpc2gsIGRpc3RyaWJ1dGUsXG4gc3VibGljZW5zZSwgYW5kL29yIHNlbGwgY29waWVzIG9mIENvY29zIENyZWF0b3IuXG5cbiBUaGUgc29mdHdhcmUgb3IgdG9vbHMgaW4gdGhpcyBMaWNlbnNlIEFncmVlbWVudCBhcmUgbGljZW5zZWQsIG5vdCBzb2xkLlxuIFhpYW1lbiBZYWppIFNvZnR3YXJlIENvLiwgTHRkLiByZXNlcnZlcyBhbGwgcmlnaHRzIG5vdCBleHByZXNzbHkgZ3JhbnRlZCB0byB5b3UuXG5cbiBUSEUgU09GVFdBUkUgSVMgUFJPVklERUQgXCJBUyBJU1wiLCBXSVRIT1VUIFdBUlJBTlRZIE9GIEFOWSBLSU5ELCBFWFBSRVNTIE9SXG4gSU1QTElFRCwgSU5DTFVESU5HIEJVVCBOT1QgTElNSVRFRCBUTyBUSEUgV0FSUkFOVElFUyBPRiBNRVJDSEFOVEFCSUxJVFksXG4gRklUTkVTUyBGT1IgQSBQQVJUSUNVTEFSIFBVUlBPU0UgQU5EIE5PTklORlJJTkdFTUVOVC4gSU4gTk8gRVZFTlQgU0hBTEwgVEhFXG4gQVVUSE9SUyBPUiBDT1BZUklHSFQgSE9MREVSUyBCRSBMSUFCTEUgRk9SIEFOWSBDTEFJTSwgREFNQUdFUyBPUiBPVEhFUlxuIExJQUJJTElUWSwgV0hFVEhFUiBJTiBBTiBBQ1RJT04gT0YgQ09OVFJBQ1QsIFRPUlQgT1IgT1RIRVJXSVNFLCBBUklTSU5HIEZST00sXG4gT1VUIE9GIE9SIElOIENPTk5FQ1RJT04gV0lUSCBUSEUgU09GVFdBUkUgT1IgVEhFIFVTRSBPUiBPVEhFUiBERUFMSU5HUyBJTlxuIFRIRSBTT0ZUV0FSRS5cbiAqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqL1xuaW1wb3J0IHsgQnVpbHRJbldvcmxkIH0gZnJvbSAnLi9idWlsdGluLXdvcmxkJztcbmltcG9ydCB7IEJ1aWx0aW5TaGFwZSB9IGZyb20gJy4vc2hhcGVzL2J1aWx0aW4tc2hhcGUnO1xuaW1wb3J0IHsgdXBkYXRlV29ybGRUcmFuc2Zvcm0gfSBmcm9tIFwiLi4vZnJhbWV3b3JrL3V0aWxcIlxuXG5jb25zdCBpbnRlcnNlY3QgPSBjYy5nZW9tVXRpbHMuaW50ZXJzZWN0O1xuY29uc3QgZmFzdFJlbW92ZSA9IGNjLmpzLmFycmF5LmZhc3RSZW1vdmU7XG5cbi8qKlxuICogQnVpbHQtaW4gc3RhdGljIGNvbGxpZGVyLCBubyBwaHlzaWNhbCBmb3JjZXMgaW52b2x2ZWRcbiAqL1xuZXhwb3J0IGNsYXNzIEJ1aWx0aW5TaGFyZWRCb2R5IHtcblxuICAgIHByaXZhdGUgc3RhdGljIHJlYWRvbmx5IHNoYXJlZEJvZGllc01hcCA9IG5ldyBNYXA8c3RyaW5nLCBCdWlsdGluU2hhcmVkQm9keT4oKTtcblxuICAgIHN0YXRpYyBnZXRTaGFyZWRCb2R5IChub2RlOiBjYy5Ob2RlLCB3cmFwcGVkV29ybGQ6IEJ1aWx0SW5Xb3JsZCkge1xuICAgICAgICBjb25zdCBrZXkgPSBub2RlLl9pZDtcbiAgICAgICAgaWYgKEJ1aWx0aW5TaGFyZWRCb2R5LnNoYXJlZEJvZGllc01hcC5oYXMoa2V5KSkge1xuICAgICAgICAgICAgcmV0dXJuIEJ1aWx0aW5TaGFyZWRCb2R5LnNoYXJlZEJvZGllc01hcC5nZXQoa2V5KSE7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICBjb25zdCBuZXdTQiA9IG5ldyBCdWlsdGluU2hhcmVkQm9keShub2RlLCB3cmFwcGVkV29ybGQpO1xuICAgICAgICAgICAgQnVpbHRpblNoYXJlZEJvZHkuc2hhcmVkQm9kaWVzTWFwLnNldChub2RlLl9pZCwgbmV3U0IpO1xuICAgICAgICAgICAgcmV0dXJuIG5ld1NCO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgZ2V0IGlkICgpIHtcbiAgICAgICAgcmV0dXJuIHRoaXMuX2lkO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIGFkZCBvciByZW1vdmUgZnJvbSB3b3JsZCBcXFxuICAgICAqIGFkZCwgaWYgZW5hYmxlIFxcXG4gICAgICogcmVtb3ZlLCBpZiBkaXNhYmxlICYgc2hhcGVzLmxlbmd0aCA9PSAwICYgd3JhcHBlZEJvZHkgZGlzYWJsZVxuICAgICAqL1xuICAgIHNldCBlbmFibGVkICh2OiBib29sZWFuKSB7XG4gICAgICAgIGlmICh2KSB7XG4gICAgICAgICAgICBpZiAodGhpcy5pbmRleCA8IDApIHtcbiAgICAgICAgICAgICAgICB0aGlzLmluZGV4ID0gdGhpcy53b3JsZC5ib2RpZXMubGVuZ3RoO1xuICAgICAgICAgICAgICAgIHRoaXMud29ybGQuYWRkU2hhcmVkQm9keSh0aGlzKTtcbiAgICAgICAgICAgICAgICB0aGlzLnN5bmNTY2VuZVRvUGh5c2ljcyh0cnVlKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIGlmICh0aGlzLmluZGV4ID49IDApIHtcbiAgICAgICAgICAgICAgICBjb25zdCBpc1JlbW92ZSA9ICh0aGlzLnNoYXBlcy5sZW5ndGggPT0gMCk7XG4gICAgICAgICAgICAgICAgaWYgKGlzUmVtb3ZlKSB7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMuaW5kZXggPSAtMTtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy53b3JsZC5yZW1vdmVTaGFyZWRCb2R5KHRoaXMpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgIH1cblxuICAgIHNldCByZWZlcmVuY2UgKHY6IGJvb2xlYW4pIHtcbiAgICAgICAgdiA/IHRoaXMucmVmKysgOiB0aGlzLnJlZi0tO1xuICAgICAgICBpZiAodGhpcy5yZWYgPT0gMCkgeyB0aGlzLmRlc3RvcnkoKTsgfVxuICAgIH1cblxuICAgIC8qKiBpZCBnZW5lcmF0b3IgKi9cbiAgICBwcml2YXRlIHN0YXRpYyBpZENvdW50ZXI6IG51bWJlciA9IDA7XG4gICAgcHJpdmF0ZSByZWFkb25seSBfaWQ6IG51bWJlcjtcbiAgICBwcml2YXRlIGluZGV4OiBudW1iZXIgPSAtMTtcbiAgICBwcml2YXRlIHJlZjogbnVtYmVyID0gMDtcblxuICAgIHJlYWRvbmx5IG5vZGU6IGNjLk5vZGU7XG4gICAgcmVhZG9ubHkgd29ybGQ6IEJ1aWx0SW5Xb3JsZDtcbiAgICByZWFkb25seSBzaGFwZXM6IEJ1aWx0aW5TaGFwZVtdID0gW107XG5cbiAgICBwcml2YXRlIGNvbnN0cnVjdG9yIChub2RlOiBjYy5Ob2RlLCB3b3JsZDogQnVpbHRJbldvcmxkKSB7XG4gICAgICAgIHRoaXMuX2lkID0gQnVpbHRpblNoYXJlZEJvZHkuaWRDb3VudGVyKys7XG4gICAgICAgIHRoaXMubm9kZSA9IG5vZGU7XG4gICAgICAgIHRoaXMud29ybGQgPSB3b3JsZDtcbiAgICB9XG5cbiAgICBpbnRlcnNlY3RzIChib2R5OiBCdWlsdGluU2hhcmVkQm9keSkge1xuICAgICAgICBmb3IgKGxldCBpID0gMDsgaSA8IHRoaXMuc2hhcGVzLmxlbmd0aDsgaSsrKSB7XG4gICAgICAgICAgICBjb25zdCBzaGFwZUEgPSB0aGlzLnNoYXBlc1tpXTtcblxuICAgICAgICAgICAgZm9yIChsZXQgaiA9IDA7IGogPCBib2R5LnNoYXBlcy5sZW5ndGg7IGorKykge1xuICAgICAgICAgICAgICAgIGNvbnN0IHNoYXBlQiA9IGJvZHkuc2hhcGVzW2pdO1xuXG4gICAgICAgICAgICAgICAgaWYgKGludGVyc2VjdC5yZXNvbHZlKHNoYXBlQS53b3JsZFNoYXBlLCBzaGFwZUIud29ybGRTaGFwZSkpIHtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy53b3JsZC5zaGFwZUFyci5wdXNoKHNoYXBlQSk7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMud29ybGQuc2hhcGVBcnIucHVzaChzaGFwZUIpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgIH1cblxuICAgIGFkZFNoYXBlIChzaGFwZTogQnVpbHRpblNoYXBlKTogdm9pZCB7XG4gICAgICAgIGNvbnN0IGkgPSB0aGlzLnNoYXBlcy5pbmRleE9mKHNoYXBlKTtcbiAgICAgICAgaWYgKGkgPCAwKSB7XG4gICAgICAgICAgICB0aGlzLnNoYXBlcy5wdXNoKHNoYXBlKTtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIHJlbW92ZVNoYXBlIChzaGFwZTogQnVpbHRpblNoYXBlKTogdm9pZCB7XG4gICAgICAgIGZhc3RSZW1vdmUodGhpcy5zaGFwZXMsIHNoYXBlKTtcbiAgICB9XG5cbiAgICBzeW5jU2NlbmVUb1BoeXNpY3MgKGZvcmNlOiBib29sZWFuID0gZmFsc2UpIHtcbiAgICAgICAgbGV0IG5vZGUgPSB0aGlzLm5vZGU7XG4gICAgICAgIGxldCBuZWVkVXBkYXRlVHJhbnNmb3JtID0gdXBkYXRlV29ybGRUcmFuc2Zvcm0obm9kZSwgZm9yY2UpO1xuICAgICAgICBpZiAoIWZvcmNlICYmICFuZWVkVXBkYXRlVHJhbnNmb3JtKSByZXR1cm47ICAgICAgICBcblxuICAgICAgICBmb3IgKGxldCBpID0gMDsgaSA8IHRoaXMuc2hhcGVzLmxlbmd0aDsgaSsrKSB7XG4gICAgICAgICAgICB0aGlzLnNoYXBlc1tpXS50cmFuc2Zvcm0obm9kZS5fd29ybGRNYXRyaXgsIG5vZGUuX193cG9zLCBub2RlLl9fd3JvdCwgbm9kZS5fX3dzY2FsZSk7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICBwcml2YXRlIGRlc3RvcnkgKCkge1xuICAgICAgICBCdWlsdGluU2hhcmVkQm9keS5zaGFyZWRCb2RpZXNNYXAuZGVsZXRlKHRoaXMubm9kZS5faWQpO1xuICAgICAgICAodGhpcy5ub2RlIGFzIGFueSkgPSBudWxsO1xuICAgICAgICAodGhpcy53b3JsZCBhcyBhbnkpID0gbnVsbDtcbiAgICAgICAgKHRoaXMuc2hhcGVzIGFzIGFueSkgPSBudWxsO1xuICAgIH1cbn1cbiJdLCJzb3VyY2VSb290IjoiLyJ9