
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/physics/cannon/shapes/cannon-shape.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports.CannonShape = void 0;

var _cannon = _interopRequireDefault(require("../../../../../../external/cannon/cannon"));

var _util = require("../../framework/util");

var _cannonUtil = require("../cannon-util");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var TriggerEventObject = {
  type: 'trigger-enter',
  selfCollider: null,
  otherCollider: null
};
var Vec3 = cc.Vec3;
var v3_0 = new Vec3();

var CannonShape =
/*#__PURE__*/
function () {
  function CannonShape() {
    this._collider = void 0;
    this._shape = void 0;
    this._offset = new _cannon["default"].Vec3();
    this._orient = new _cannon["default"].Quaternion();
    this._index = -1;
    this._sharedBody = void 0;
    this.onTriggerListener = this.onTrigger.bind(this);
  }

  var _proto = CannonShape.prototype;

  /** LIFECYCLE */
  _proto.__preload = function __preload(comp) {
    this._collider = comp;
    (0, _util.setWrap)(this._shape, this);

    this._shape.addEventListener('triggered', this.onTriggerListener);

    this._sharedBody = cc.director.getPhysics3DManager().physicsWorld.getSharedBody(this._collider.node);
    this._sharedBody.reference = true;
  };

  _proto.onLoad = function onLoad() {
    this.center = this._collider.center;
    this.isTrigger = this._collider.isTrigger;
  };

  _proto.onEnable = function onEnable() {
    this._sharedBody.addShape(this);

    this._sharedBody.enabled = true;
  };

  _proto.onDisable = function onDisable() {
    this._sharedBody.removeShape(this);

    this._sharedBody.enabled = false;
  };

  _proto.onDestroy = function onDestroy() {
    this._sharedBody.reference = false;
    this._sharedBody = null;
    (0, _util.setWrap)(this._shape, null);
    this._offset = null;
    this._orient = null;
    this._shape = null;
    this._collider = null;
    this.onTriggerListener = null;
  }
  /**
   * change scale will recalculate center & size \
   * size handle by child class
   * @param scale 
   */
  ;

  _proto.setScale = function setScale(scale) {
    this.center = this._collider.center;
  };

  _proto.setIndex = function setIndex(index) {
    this._index = index;
  };

  _proto.setOffsetAndOrient = function setOffsetAndOrient(offset, Orient) {
    this._offset = offset;
    this._orient = Orient;
  };

  _proto.onTrigger = function onTrigger(event) {
    TriggerEventObject.type = event.event;
    var self = (0, _util.getWrap)(event.selfShape);
    var other = (0, _util.getWrap)(event.otherShape);

    if (self) {
      TriggerEventObject.selfCollider = self.collider;
      TriggerEventObject.otherCollider = other ? other.collider : null;

      this._collider.emit(TriggerEventObject.type, TriggerEventObject);
    }
  };

  _createClass(CannonShape, [{
    key: "shape",
    get: function get() {
      return this._shape;
    }
  }, {
    key: "collider",
    get: function get() {
      return this._collider;
    }
  }, {
    key: "attachedRigidBody",
    get: function get() {
      if (this._sharedBody.wrappedBody) {
        return this._sharedBody.wrappedBody.rigidBody;
      }

      return null;
    }
  }, {
    key: "sharedBody",
    get: function get() {
      return this._sharedBody;
    }
  }, {
    key: "material",
    set: function set(mat) {
      if (mat == null) {
        this._shape.material = null;
      } else {
        if (CannonShape.idToMaterial[mat._uuid] == null) {
          CannonShape.idToMaterial[mat._uuid] = new _cannon["default"].Material(mat._uuid);
        }

        this._shape.material = CannonShape.idToMaterial[mat._uuid];
        this._shape.material.friction = mat.friction;
        this._shape.material.restitution = mat.restitution;
      }
    }
  }, {
    key: "isTrigger",
    set: function set(v) {
      this._shape.collisionResponse = !v;

      if (this._index >= 0) {
        this._body.updateHasTrigger();
      }
    }
  }, {
    key: "center",
    set: function set(v) {
      var lpos = this._offset;
      Vec3.copy(lpos, v);

      this._collider.node.getWorldScale(v3_0);

      Vec3.multiply(lpos, lpos, v3_0);

      if (this._index >= 0) {
        (0, _cannonUtil.commitShapeUpdates)(this._body);
      }
    }
  }, {
    key: "_body",
    get: function get() {
      return this._sharedBody.body;
    }
  }]);

  return CannonShape;
}();

exports.CannonShape = CannonShape;
CannonShape.idToMaterial = {};
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvY29jb3MyZC9jb3JlLzNkL3BoeXNpY3MvY2Fubm9uL3NoYXBlcy9jYW5ub24tc2hhcGUudHMiXSwibmFtZXMiOlsiVHJpZ2dlckV2ZW50T2JqZWN0IiwidHlwZSIsInNlbGZDb2xsaWRlciIsIm90aGVyQ29sbGlkZXIiLCJWZWMzIiwiY2MiLCJ2M18wIiwiQ2Fubm9uU2hhcGUiLCJfY29sbGlkZXIiLCJfc2hhcGUiLCJfb2Zmc2V0IiwiQ0FOTk9OIiwiX29yaWVudCIsIlF1YXRlcm5pb24iLCJfaW5kZXgiLCJfc2hhcmVkQm9keSIsIm9uVHJpZ2dlckxpc3RlbmVyIiwib25UcmlnZ2VyIiwiYmluZCIsIl9fcHJlbG9hZCIsImNvbXAiLCJhZGRFdmVudExpc3RlbmVyIiwiZGlyZWN0b3IiLCJnZXRQaHlzaWNzM0RNYW5hZ2VyIiwicGh5c2ljc1dvcmxkIiwiZ2V0U2hhcmVkQm9keSIsIm5vZGUiLCJyZWZlcmVuY2UiLCJvbkxvYWQiLCJjZW50ZXIiLCJpc1RyaWdnZXIiLCJvbkVuYWJsZSIsImFkZFNoYXBlIiwiZW5hYmxlZCIsIm9uRGlzYWJsZSIsInJlbW92ZVNoYXBlIiwib25EZXN0cm95Iiwic2V0U2NhbGUiLCJzY2FsZSIsInNldEluZGV4IiwiaW5kZXgiLCJzZXRPZmZzZXRBbmRPcmllbnQiLCJvZmZzZXQiLCJPcmllbnQiLCJldmVudCIsInNlbGYiLCJzZWxmU2hhcGUiLCJvdGhlciIsIm90aGVyU2hhcGUiLCJjb2xsaWRlciIsImVtaXQiLCJ3cmFwcGVkQm9keSIsInJpZ2lkQm9keSIsIm1hdCIsIm1hdGVyaWFsIiwiaWRUb01hdGVyaWFsIiwiX3V1aWQiLCJNYXRlcmlhbCIsImZyaWN0aW9uIiwicmVzdGl0dXRpb24iLCJ2IiwiY29sbGlzaW9uUmVzcG9uc2UiLCJfYm9keSIsInVwZGF0ZUhhc1RyaWdnZXIiLCJscG9zIiwiY29weSIsImdldFdvcmxkU2NhbGUiLCJtdWx0aXBseSIsImJvZHkiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7QUF5QkE7O0FBQ0E7O0FBQ0E7Ozs7Ozs7O0FBU0EsSUFBTUEsa0JBQWtCLEdBQUc7QUFDdkJDLEVBQUFBLElBQUksRUFBRSxlQURpQjtBQUV2QkMsRUFBQUEsWUFBWSxFQUFFLElBRlM7QUFHdkJDLEVBQUFBLGFBQWEsRUFBRTtBQUhRLENBQTNCO0FBTUEsSUFBTUMsSUFBSSxHQUFHQyxFQUFFLENBQUNELElBQWhCO0FBQ0EsSUFBTUUsSUFBSSxHQUFHLElBQUlGLElBQUosRUFBYjs7SUFFYUc7Ozs7U0E4Q1RDO1NBRVVDO1NBQ0FDLFVBQVUsSUFBSUMsbUJBQU9QLElBQVg7U0FDVlEsVUFBVSxJQUFJRCxtQkFBT0UsVUFBWDtTQUNWQyxTQUFpQixDQUFDO1NBQ2xCQztTQUVBQyxvQkFBb0IsS0FBS0MsU0FBTCxDQUFlQyxJQUFmLENBQW9CLElBQXBCOzs7OztBQUU5QjtTQUVBQyxZQUFBLG1CQUFXQyxJQUFYLEVBQTZCO0FBQ3pCLFNBQUtaLFNBQUwsR0FBaUJZLElBQWpCO0FBQ0EsdUJBQVEsS0FBS1gsTUFBYixFQUFxQixJQUFyQjs7QUFDQSxTQUFLQSxNQUFMLENBQVlZLGdCQUFaLENBQTZCLFdBQTdCLEVBQTBDLEtBQUtMLGlCQUEvQzs7QUFDQSxTQUFLRCxXQUFMLEdBQW9CVixFQUFFLENBQUNpQixRQUFILENBQVlDLG1CQUFaLEdBQWtDQyxZQUFuQyxDQUFnRUMsYUFBaEUsQ0FBOEUsS0FBS2pCLFNBQUwsQ0FBZWtCLElBQTdGLENBQW5CO0FBQ0EsU0FBS1gsV0FBTCxDQUFpQlksU0FBakIsR0FBNkIsSUFBN0I7QUFDSDs7U0FFREMsU0FBQSxrQkFBVTtBQUNOLFNBQUtDLE1BQUwsR0FBYyxLQUFLckIsU0FBTCxDQUFlcUIsTUFBN0I7QUFDQSxTQUFLQyxTQUFMLEdBQWlCLEtBQUt0QixTQUFMLENBQWVzQixTQUFoQztBQUNIOztTQUVEQyxXQUFBLG9CQUFZO0FBQ1IsU0FBS2hCLFdBQUwsQ0FBaUJpQixRQUFqQixDQUEwQixJQUExQjs7QUFDQSxTQUFLakIsV0FBTCxDQUFpQmtCLE9BQWpCLEdBQTJCLElBQTNCO0FBQ0g7O1NBRURDLFlBQUEscUJBQWE7QUFDVCxTQUFLbkIsV0FBTCxDQUFpQm9CLFdBQWpCLENBQTZCLElBQTdCOztBQUNBLFNBQUtwQixXQUFMLENBQWlCa0IsT0FBakIsR0FBMkIsS0FBM0I7QUFDSDs7U0FFREcsWUFBQSxxQkFBYTtBQUNULFNBQUtyQixXQUFMLENBQWlCWSxTQUFqQixHQUE2QixLQUE3QjtBQUNDLFNBQUtaLFdBQU4sR0FBNEIsSUFBNUI7QUFDQSx1QkFBUSxLQUFLTixNQUFiLEVBQXFCLElBQXJCO0FBQ0MsU0FBS0MsT0FBTixHQUF3QixJQUF4QjtBQUNDLFNBQUtFLE9BQU4sR0FBd0IsSUFBeEI7QUFDQyxTQUFLSCxNQUFOLEdBQXVCLElBQXZCO0FBQ0MsU0FBS0QsU0FBTixHQUEwQixJQUExQjtBQUNDLFNBQUtRLGlCQUFOLEdBQWtDLElBQWxDO0FBQ0g7QUFFRDs7Ozs7OztTQUtBcUIsV0FBQSxrQkFBVUMsS0FBVixFQUE0QjtBQUN4QixTQUFLVCxNQUFMLEdBQWMsS0FBS3JCLFNBQUwsQ0FBZXFCLE1BQTdCO0FBQ0g7O1NBRURVLFdBQUEsa0JBQVVDLEtBQVYsRUFBeUI7QUFDckIsU0FBSzFCLE1BQUwsR0FBYzBCLEtBQWQ7QUFDSDs7U0FFREMscUJBQUEsNEJBQW9CQyxNQUFwQixFQUF5Q0MsTUFBekMsRUFBb0U7QUFDaEUsU0FBS2pDLE9BQUwsR0FBZWdDLE1BQWY7QUFDQSxTQUFLOUIsT0FBTCxHQUFlK0IsTUFBZjtBQUNIOztTQUVPMUIsWUFBUixtQkFBbUIyQixLQUFuQixFQUFrRDtBQUM5QzVDLElBQUFBLGtCQUFrQixDQUFDQyxJQUFuQixHQUEwQjJDLEtBQUssQ0FBQ0EsS0FBaEM7QUFDQSxRQUFNQyxJQUFJLEdBQUcsbUJBQXFCRCxLQUFLLENBQUNFLFNBQTNCLENBQWI7QUFDQSxRQUFNQyxLQUFLLEdBQUcsbUJBQXFCSCxLQUFLLENBQUNJLFVBQTNCLENBQWQ7O0FBRUEsUUFBSUgsSUFBSixFQUFVO0FBQ043QyxNQUFBQSxrQkFBa0IsQ0FBQ0UsWUFBbkIsR0FBa0MyQyxJQUFJLENBQUNJLFFBQXZDO0FBQ0FqRCxNQUFBQSxrQkFBa0IsQ0FBQ0csYUFBbkIsR0FBbUM0QyxLQUFLLEdBQUdBLEtBQUssQ0FBQ0UsUUFBVCxHQUFvQixJQUE1RDs7QUFDQSxXQUFLekMsU0FBTCxDQUFlMEMsSUFBZixDQUFvQmxELGtCQUFrQixDQUFDQyxJQUF2QyxFQUE2Q0Qsa0JBQTdDO0FBQ0g7QUFDSjs7Ozt3QkFwSFk7QUFBRSxhQUFPLEtBQUtTLE1BQVo7QUFBc0I7Ozt3QkFFckI7QUFBRSxhQUFPLEtBQUtELFNBQVo7QUFBd0I7Ozt3QkFFakI7QUFDckIsVUFBSSxLQUFLTyxXQUFMLENBQWlCb0MsV0FBckIsRUFBa0M7QUFBRSxlQUFPLEtBQUtwQyxXQUFMLENBQWlCb0MsV0FBakIsQ0FBNkJDLFNBQXBDO0FBQWdEOztBQUNwRixhQUFPLElBQVA7QUFDSDs7O3dCQUVtQztBQUFFLGFBQU8sS0FBS3JDLFdBQVo7QUFBMEI7OztzQkFFbERzQyxLQUFzQjtBQUNoQyxVQUFJQSxHQUFHLElBQUksSUFBWCxFQUFpQjtBQUNaLGFBQUs1QyxNQUFMLENBQWE2QyxRQUFkLEdBQXFDLElBQXJDO0FBQ0gsT0FGRCxNQUVPO0FBQ0gsWUFBSS9DLFdBQVcsQ0FBQ2dELFlBQVosQ0FBeUJGLEdBQUcsQ0FBQ0csS0FBN0IsS0FBdUMsSUFBM0MsRUFBaUQ7QUFDN0NqRCxVQUFBQSxXQUFXLENBQUNnRCxZQUFaLENBQXlCRixHQUFHLENBQUNHLEtBQTdCLElBQXNDLElBQUk3QyxtQkFBTzhDLFFBQVgsQ0FBb0JKLEdBQUcsQ0FBQ0csS0FBeEIsQ0FBdEM7QUFDSDs7QUFFRCxhQUFLL0MsTUFBTCxDQUFhNkMsUUFBYixHQUF3Qi9DLFdBQVcsQ0FBQ2dELFlBQVosQ0FBeUJGLEdBQUcsQ0FBQ0csS0FBN0IsQ0FBeEI7QUFDQSxhQUFLL0MsTUFBTCxDQUFhNkMsUUFBYixDQUFzQkksUUFBdEIsR0FBaUNMLEdBQUcsQ0FBQ0ssUUFBckM7QUFDQSxhQUFLakQsTUFBTCxDQUFhNkMsUUFBYixDQUFzQkssV0FBdEIsR0FBb0NOLEdBQUcsQ0FBQ00sV0FBeEM7QUFDSDtBQUNKOzs7c0JBRWNDLEdBQVk7QUFDdkIsV0FBS25ELE1BQUwsQ0FBWW9ELGlCQUFaLEdBQWdDLENBQUNELENBQWpDOztBQUNBLFVBQUksS0FBSzlDLE1BQUwsSUFBZSxDQUFuQixFQUFzQjtBQUNsQixhQUFLZ0QsS0FBTCxDQUFXQyxnQkFBWDtBQUNIO0FBQ0o7OztzQkFFV0gsR0FBYztBQUN0QixVQUFNSSxJQUFJLEdBQUcsS0FBS3RELE9BQWxCO0FBQ0FOLE1BQUFBLElBQUksQ0FBQzZELElBQUwsQ0FBVUQsSUFBVixFQUFnQkosQ0FBaEI7O0FBQ0EsV0FBS3BELFNBQUwsQ0FBZWtCLElBQWYsQ0FBb0J3QyxhQUFwQixDQUFrQzVELElBQWxDOztBQUNBRixNQUFBQSxJQUFJLENBQUMrRCxRQUFMLENBQWNILElBQWQsRUFBb0JBLElBQXBCLEVBQTBCMUQsSUFBMUI7O0FBQ0EsVUFBSSxLQUFLUSxNQUFMLElBQWUsQ0FBbkIsRUFBc0I7QUFDbEIsNENBQW1CLEtBQUtnRCxLQUF4QjtBQUNIO0FBQ0o7Ozt3QkFTbUM7QUFBRSxhQUFPLEtBQUsvQyxXQUFMLENBQWlCcUQsSUFBeEI7QUFBK0I7Ozs7Ozs7QUFyRDVEN0QsWUFFT2dELGVBQWUiLCJzb3VyY2VzQ29udGVudCI6WyIvKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKlxuIENvcHlyaWdodCAoYykgMjAxOSBYaWFtZW4gWWFqaSBTb2Z0d2FyZSBDby4sIEx0ZC5cblxuIGh0dHBzOi8vd3d3LmNvY29zLmNvbS9cblxuIFBlcm1pc3Npb24gaXMgaGVyZWJ5IGdyYW50ZWQsIGZyZWUgb2YgY2hhcmdlLCB0byBhbnkgcGVyc29uIG9idGFpbmluZyBhIGNvcHlcbiBvZiB0aGlzIHNvZnR3YXJlIGFuZCBhc3NvY2lhdGVkIGVuZ2luZSBzb3VyY2UgY29kZSAodGhlIFwiU29mdHdhcmVcIiksIGEgbGltaXRlZCxcbiB3b3JsZHdpZGUsIHJveWFsdHktZnJlZSwgbm9uLWFzc2lnbmFibGUsIHJldm9jYWJsZSBhbmQgbm9uLWV4Y2x1c2l2ZSBsaWNlbnNlXG4gdG8gdXNlIENvY29zIENyZWF0b3Igc29sZWx5IHRvIGRldmVsb3AgZ2FtZXMgb24geW91ciB0YXJnZXQgcGxhdGZvcm1zLiBZb3Ugc2hhbGxcbiBub3QgdXNlIENvY29zIENyZWF0b3Igc29mdHdhcmUgZm9yIGRldmVsb3Bpbmcgb3RoZXIgc29mdHdhcmUgb3IgdG9vbHMgdGhhdCdzXG4gdXNlZCBmb3IgZGV2ZWxvcGluZyBnYW1lcy4gWW91IGFyZSBub3QgZ3JhbnRlZCB0byBwdWJsaXNoLCBkaXN0cmlidXRlLFxuIHN1YmxpY2Vuc2UsIGFuZC9vciBzZWxsIGNvcGllcyBvZiBDb2NvcyBDcmVhdG9yLlxuXG4gVGhlIHNvZnR3YXJlIG9yIHRvb2xzIGluIHRoaXMgTGljZW5zZSBBZ3JlZW1lbnQgYXJlIGxpY2Vuc2VkLCBub3Qgc29sZC5cbiBYaWFtZW4gWWFqaSBTb2Z0d2FyZSBDby4sIEx0ZC4gcmVzZXJ2ZXMgYWxsIHJpZ2h0cyBub3QgZXhwcmVzc2x5IGdyYW50ZWQgdG8geW91LlxuXG4gVEhFIFNPRlRXQVJFIElTIFBST1ZJREVEIFwiQVMgSVNcIiwgV0lUSE9VVCBXQVJSQU5UWSBPRiBBTlkgS0lORCwgRVhQUkVTUyBPUlxuIElNUExJRUQsIElOQ0xVRElORyBCVVQgTk9UIExJTUlURUQgVE8gVEhFIFdBUlJBTlRJRVMgT0YgTUVSQ0hBTlRBQklMSVRZLFxuIEZJVE5FU1MgRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFIEFORCBOT05JTkZSSU5HRU1FTlQuIElOIE5PIEVWRU5UIFNIQUxMIFRIRVxuIEFVVEhPUlMgT1IgQ09QWVJJR0hUIEhPTERFUlMgQkUgTElBQkxFIEZPUiBBTlkgQ0xBSU0sIERBTUFHRVMgT1IgT1RIRVJcbiBMSUFCSUxJVFksIFdIRVRIRVIgSU4gQU4gQUNUSU9OIE9GIENPTlRSQUNULCBUT1JUIE9SIE9USEVSV0lTRSwgQVJJU0lORyBGUk9NLFxuIE9VVCBPRiBPUiBJTiBDT05ORUNUSU9OIFdJVEggVEhFIFNPRlRXQVJFIE9SIFRIRSBVU0UgT1IgT1RIRVIgREVBTElOR1MgSU5cbiBUSEUgU09GVFdBUkUuXG4gKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKi9cblxuaW1wb3J0IENBTk5PTiBmcm9tICcuLi8uLi8uLi8uLi8uLi8uLi9leHRlcm5hbC9jYW5ub24vY2Fubm9uJztcbmltcG9ydCB7IGdldFdyYXAsIHNldFdyYXAgfSBmcm9tICcuLi8uLi9mcmFtZXdvcmsvdXRpbCc7XG5pbXBvcnQgeyBjb21taXRTaGFwZVVwZGF0ZXMgfSBmcm9tICcuLi9jYW5ub24tdXRpbCc7XG5pbXBvcnQgeyBQaHlzaWNzTWF0ZXJpYWwgfSBmcm9tICcuLi8uLi9mcmFtZXdvcmsvYXNzZXRzL3BoeXNpY3MtbWF0ZXJpYWwnO1xuaW1wb3J0IHsgSUJhc2VTaGFwZSB9IGZyb20gJy4uLy4uL3NwZWMvaS1waHlzaWNzLXNoYXBlJztcbmltcG9ydCB7IElWZWMzTGlrZSB9IGZyb20gJy4uLy4uL3NwZWMvaS1jb21tb24nO1xuaW1wb3J0IHsgQ2Fubm9uU2hhcmVkQm9keSB9IGZyb20gJy4uL2Nhbm5vbi1zaGFyZWQtYm9keSc7XG5pbXBvcnQgeyBDYW5ub25Xb3JsZCB9IGZyb20gJy4uL2Nhbm5vbi13b3JsZCc7XG5pbXBvcnQgeyBUcmlnZ2VyRXZlbnRUeXBlIH0gZnJvbSAnLi4vLi4vZnJhbWV3b3JrL3BoeXNpY3MtaW50ZXJmYWNlJztcbmltcG9ydCB7IENvbGxpZGVyM0QgfSBmcm9tICcuLi8uLi9mcmFtZXdvcmsnO1xuXG5jb25zdCBUcmlnZ2VyRXZlbnRPYmplY3QgPSB7XG4gICAgdHlwZTogJ3RyaWdnZXItZW50ZXInIGFzIFRyaWdnZXJFdmVudFR5cGUsXG4gICAgc2VsZkNvbGxpZGVyOiBudWxsIGFzIENvbGxpZGVyM0QgfCBudWxsLFxuICAgIG90aGVyQ29sbGlkZXI6IG51bGwgYXMgQ29sbGlkZXIzRCB8IG51bGwsXG59O1xuXG5jb25zdCBWZWMzID0gY2MuVmVjMztcbmNvbnN0IHYzXzAgPSBuZXcgVmVjMygpO1xuXG5leHBvcnQgY2xhc3MgQ2Fubm9uU2hhcGUgaW1wbGVtZW50cyBJQmFzZVNoYXBlIHtcblxuICAgIHN0YXRpYyByZWFkb25seSBpZFRvTWF0ZXJpYWwgPSB7fTtcblxuICAgIGdldCBzaGFwZSAoKSB7IHJldHVybiB0aGlzLl9zaGFwZSE7IH1cblxuICAgIGdldCBjb2xsaWRlciAoKSB7IHJldHVybiB0aGlzLl9jb2xsaWRlcjsgfVxuXG4gICAgZ2V0IGF0dGFjaGVkUmlnaWRCb2R5ICgpIHtcbiAgICAgICAgaWYgKHRoaXMuX3NoYXJlZEJvZHkud3JhcHBlZEJvZHkpIHsgcmV0dXJuIHRoaXMuX3NoYXJlZEJvZHkud3JhcHBlZEJvZHkucmlnaWRCb2R5OyB9XG4gICAgICAgIHJldHVybiBudWxsO1xuICAgIH1cblxuICAgIGdldCBzaGFyZWRCb2R5ICgpOiBDYW5ub25TaGFyZWRCb2R5IHsgcmV0dXJuIHRoaXMuX3NoYXJlZEJvZHk7IH1cblxuICAgIHNldCBtYXRlcmlhbCAobWF0OiBQaHlzaWNzTWF0ZXJpYWwpIHtcbiAgICAgICAgaWYgKG1hdCA9PSBudWxsKSB7XG4gICAgICAgICAgICAodGhpcy5fc2hhcGUhLm1hdGVyaWFsIGFzIHVua25vd24pID0gbnVsbDtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIGlmIChDYW5ub25TaGFwZS5pZFRvTWF0ZXJpYWxbbWF0Ll91dWlkXSA9PSBudWxsKSB7XG4gICAgICAgICAgICAgICAgQ2Fubm9uU2hhcGUuaWRUb01hdGVyaWFsW21hdC5fdXVpZF0gPSBuZXcgQ0FOTk9OLk1hdGVyaWFsKG1hdC5fdXVpZCk7XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIHRoaXMuX3NoYXBlIS5tYXRlcmlhbCA9IENhbm5vblNoYXBlLmlkVG9NYXRlcmlhbFttYXQuX3V1aWRdO1xuICAgICAgICAgICAgdGhpcy5fc2hhcGUhLm1hdGVyaWFsLmZyaWN0aW9uID0gbWF0LmZyaWN0aW9uO1xuICAgICAgICAgICAgdGhpcy5fc2hhcGUhLm1hdGVyaWFsLnJlc3RpdHV0aW9uID0gbWF0LnJlc3RpdHV0aW9uO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgc2V0IGlzVHJpZ2dlciAodjogYm9vbGVhbikge1xuICAgICAgICB0aGlzLl9zaGFwZS5jb2xsaXNpb25SZXNwb25zZSA9ICF2O1xuICAgICAgICBpZiAodGhpcy5faW5kZXggPj0gMCkge1xuICAgICAgICAgICAgdGhpcy5fYm9keS51cGRhdGVIYXNUcmlnZ2VyKCk7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICBzZXQgY2VudGVyICh2OiBJVmVjM0xpa2UpIHtcbiAgICAgICAgY29uc3QgbHBvcyA9IHRoaXMuX29mZnNldCBhcyBJVmVjM0xpa2U7XG4gICAgICAgIFZlYzMuY29weShscG9zLCB2KTtcbiAgICAgICAgdGhpcy5fY29sbGlkZXIubm9kZS5nZXRXb3JsZFNjYWxlKHYzXzApO1xuICAgICAgICBWZWMzLm11bHRpcGx5KGxwb3MsIGxwb3MsIHYzXzApO1xuICAgICAgICBpZiAodGhpcy5faW5kZXggPj0gMCkge1xuICAgICAgICAgICAgY29tbWl0U2hhcGVVcGRhdGVzKHRoaXMuX2JvZHkpO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgX2NvbGxpZGVyITogQ29sbGlkZXIzRDtcblxuICAgIHByb3RlY3RlZCBfc2hhcGUhOiBDQU5OT04uU2hhcGU7XG4gICAgcHJvdGVjdGVkIF9vZmZzZXQgPSBuZXcgQ0FOTk9OLlZlYzMoKTtcbiAgICBwcm90ZWN0ZWQgX29yaWVudCA9IG5ldyBDQU5OT04uUXVhdGVybmlvbigpO1xuICAgIHByb3RlY3RlZCBfaW5kZXg6IG51bWJlciA9IC0xO1xuICAgIHByb3RlY3RlZCBfc2hhcmVkQm9keSE6IENhbm5vblNoYXJlZEJvZHk7XG4gICAgcHJvdGVjdGVkIGdldCBfYm9keSAoKTogQ0FOTk9OLkJvZHkgeyByZXR1cm4gdGhpcy5fc2hhcmVkQm9keS5ib2R5OyB9XG4gICAgcHJvdGVjdGVkIG9uVHJpZ2dlckxpc3RlbmVyID0gdGhpcy5vblRyaWdnZXIuYmluZCh0aGlzKTtcblxuICAgIC8qKiBMSUZFQ1lDTEUgKi9cblxuICAgIF9fcHJlbG9hZCAoY29tcDogQ29sbGlkZXIzRCkge1xuICAgICAgICB0aGlzLl9jb2xsaWRlciA9IGNvbXA7XG4gICAgICAgIHNldFdyYXAodGhpcy5fc2hhcGUsIHRoaXMpO1xuICAgICAgICB0aGlzLl9zaGFwZS5hZGRFdmVudExpc3RlbmVyKCd0cmlnZ2VyZWQnLCB0aGlzLm9uVHJpZ2dlckxpc3RlbmVyKTtcbiAgICAgICAgdGhpcy5fc2hhcmVkQm9keSA9IChjYy5kaXJlY3Rvci5nZXRQaHlzaWNzM0RNYW5hZ2VyKCkucGh5c2ljc1dvcmxkIGFzIENhbm5vbldvcmxkKS5nZXRTaGFyZWRCb2R5KHRoaXMuX2NvbGxpZGVyLm5vZGUpO1xuICAgICAgICB0aGlzLl9zaGFyZWRCb2R5LnJlZmVyZW5jZSA9IHRydWU7XG4gICAgfVxuXG4gICAgb25Mb2FkICgpIHtcbiAgICAgICAgdGhpcy5jZW50ZXIgPSB0aGlzLl9jb2xsaWRlci5jZW50ZXI7XG4gICAgICAgIHRoaXMuaXNUcmlnZ2VyID0gdGhpcy5fY29sbGlkZXIuaXNUcmlnZ2VyO1xuICAgIH1cblxuICAgIG9uRW5hYmxlICgpIHtcbiAgICAgICAgdGhpcy5fc2hhcmVkQm9keS5hZGRTaGFwZSh0aGlzKTtcbiAgICAgICAgdGhpcy5fc2hhcmVkQm9keS5lbmFibGVkID0gdHJ1ZTtcbiAgICB9XG5cbiAgICBvbkRpc2FibGUgKCkge1xuICAgICAgICB0aGlzLl9zaGFyZWRCb2R5LnJlbW92ZVNoYXBlKHRoaXMpO1xuICAgICAgICB0aGlzLl9zaGFyZWRCb2R5LmVuYWJsZWQgPSBmYWxzZTtcbiAgICB9XG5cbiAgICBvbkRlc3Ryb3kgKCkge1xuICAgICAgICB0aGlzLl9zaGFyZWRCb2R5LnJlZmVyZW5jZSA9IGZhbHNlO1xuICAgICAgICAodGhpcy5fc2hhcmVkQm9keSBhcyBhbnkpID0gbnVsbDtcbiAgICAgICAgc2V0V3JhcCh0aGlzLl9zaGFwZSwgbnVsbCk7XG4gICAgICAgICh0aGlzLl9vZmZzZXQgYXMgYW55KSA9IG51bGw7XG4gICAgICAgICh0aGlzLl9vcmllbnQgYXMgYW55KSA9IG51bGw7XG4gICAgICAgICh0aGlzLl9zaGFwZSBhcyBhbnkpID0gbnVsbDtcbiAgICAgICAgKHRoaXMuX2NvbGxpZGVyIGFzIGFueSkgPSBudWxsO1xuICAgICAgICAodGhpcy5vblRyaWdnZXJMaXN0ZW5lciBhcyBhbnkpID0gbnVsbDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBjaGFuZ2Ugc2NhbGUgd2lsbCByZWNhbGN1bGF0ZSBjZW50ZXIgJiBzaXplIFxcXG4gICAgICogc2l6ZSBoYW5kbGUgYnkgY2hpbGQgY2xhc3NcbiAgICAgKiBAcGFyYW0gc2NhbGUgXG4gICAgICovXG4gICAgc2V0U2NhbGUgKHNjYWxlOiBJVmVjM0xpa2UpIHtcbiAgICAgICAgdGhpcy5jZW50ZXIgPSB0aGlzLl9jb2xsaWRlci5jZW50ZXI7XG4gICAgfVxuXG4gICAgc2V0SW5kZXggKGluZGV4OiBudW1iZXIpIHtcbiAgICAgICAgdGhpcy5faW5kZXggPSBpbmRleDtcbiAgICB9XG5cbiAgICBzZXRPZmZzZXRBbmRPcmllbnQgKG9mZnNldDogQ0FOTk9OLlZlYzMsIE9yaWVudDogQ0FOTk9OLlF1YXRlcm5pb24pIHtcbiAgICAgICAgdGhpcy5fb2Zmc2V0ID0gb2Zmc2V0O1xuICAgICAgICB0aGlzLl9vcmllbnQgPSBPcmllbnQ7XG4gICAgfVxuXG4gICAgcHJpdmF0ZSBvblRyaWdnZXIgKGV2ZW50OiBDQU5OT04uSVRyaWdnZXJlZEV2ZW50KSB7XG4gICAgICAgIFRyaWdnZXJFdmVudE9iamVjdC50eXBlID0gZXZlbnQuZXZlbnQ7XG4gICAgICAgIGNvbnN0IHNlbGYgPSBnZXRXcmFwPENhbm5vblNoYXBlPihldmVudC5zZWxmU2hhcGUpO1xuICAgICAgICBjb25zdCBvdGhlciA9IGdldFdyYXA8Q2Fubm9uU2hhcGU+KGV2ZW50Lm90aGVyU2hhcGUpO1xuXG4gICAgICAgIGlmIChzZWxmKSB7XG4gICAgICAgICAgICBUcmlnZ2VyRXZlbnRPYmplY3Quc2VsZkNvbGxpZGVyID0gc2VsZi5jb2xsaWRlcjtcbiAgICAgICAgICAgIFRyaWdnZXJFdmVudE9iamVjdC5vdGhlckNvbGxpZGVyID0gb3RoZXIgPyBvdGhlci5jb2xsaWRlciA6IG51bGw7XG4gICAgICAgICAgICB0aGlzLl9jb2xsaWRlci5lbWl0KFRyaWdnZXJFdmVudE9iamVjdC50eXBlLCBUcmlnZ2VyRXZlbnRPYmplY3QpO1xuICAgICAgICB9XG4gICAgfVxufVxuIl0sInNvdXJjZVJvb3QiOiIvIn0=