
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/physics/cannon/cannon-shared-body.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports.CannonSharedBody = void 0;

var _cannon = _interopRequireDefault(require("../../../../../external/cannon/cannon"));

var _physicsEnum = require("../framework/physics-enum");

var _util = require("../framework/util");

var _cannonUtil = require("./cannon-util");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var LocalDirtyFlag = cc.Node._LocalDirtyFlag;
var PHYSICS_SCALE = LocalDirtyFlag.PHYSICS_SCALE;
var Quat = cc.Quat;
var Vec3 = cc.Vec3;
var fastRemoveAt = cc.js.array.fastRemoveAt;
var v3_0 = new Vec3();
var quat_0 = new Quat();
var contactsPool = [];
var CollisionEventObject = {
  type: 'collision-enter',
  selfCollider: null,
  otherCollider: null,
  contacts: []
};
/**
 * sharedbody, node : sharedbody = 1 : 1
 * static
 */

var CannonSharedBody =
/*#__PURE__*/
function () {
  CannonSharedBody.getSharedBody = function getSharedBody(node, wrappedWorld) {
    var key = node._id;

    if (CannonSharedBody.sharedBodiesMap.has(key)) {
      return CannonSharedBody.sharedBodiesMap.get(key);
    } else {
      var newSB = new CannonSharedBody(node, wrappedWorld);
      CannonSharedBody.sharedBodiesMap.set(node._id, newSB);
      return newSB;
    }
  };

  _createClass(CannonSharedBody, [{
    key: "enabled",

    /**
     * add or remove from world \
     * add, if enable \
     * remove, if disable & shapes.length == 0 & wrappedBody disable
     */
    set: function set(v) {
      if (v) {
        if (this.index < 0) {
          this.index = this.wrappedWorld.bodies.length;
          this.wrappedWorld.addSharedBody(this);
          this.syncSceneToPhysics(true);
        }
      } else {
        if (this.index >= 0) {
          var isRemove = this.shapes.length == 0 && this.wrappedBody == null || this.shapes.length == 0 && this.wrappedBody != null && !this.wrappedBody.rigidBody.enabledInHierarchy || this.shapes.length == 0 && this.wrappedBody != null && !this.wrappedBody.isEnabled;

          if (isRemove) {
            this.body.sleep(); // clear velocity etc.

            this.index = -1;
            this.wrappedWorld.removeSharedBody(this);
          }
        }
      }
    }
  }, {
    key: "reference",
    set: function set(v) {
      v ? this.ref++ : this.ref--;

      if (this.ref == 0) {
        this.destroy();
      }
    }
  }]);

  function CannonSharedBody(node, wrappedWorld) {
    this.node = void 0;
    this.wrappedWorld = void 0;
    this.body = new _cannon["default"].Body();
    this.shapes = [];
    this.wrappedBody = null;
    this.index = -1;
    this.ref = 0;
    this.onCollidedListener = this.onCollided.bind(this);
    this.wrappedWorld = wrappedWorld;
    this.node = node;
    this.body.material = this.wrappedWorld.world.defaultMaterial;
    this.body.addEventListener('collide', this.onCollidedListener);

    this._updateGroup();

    this.node.on(cc.Node.EventType.GROUP_CHANGED, this._updateGroup, this);
  }

  var _proto = CannonSharedBody.prototype;

  _proto._updateGroup = function _updateGroup() {
    (0, _cannonUtil.groupIndexToBitMask)(this.node.groupIndex, this.body);
  };

  _proto.addShape = function addShape(v) {
    var index = this.shapes.indexOf(v);

    if (index < 0) {
      var _index = this.body.shapes.length;
      this.body.addShape(v.shape);
      this.shapes.push(v);
      v.setIndex(_index);
      var offset = this.body.shapeOffsets[_index];
      var orient = this.body.shapeOrientations[_index];
      v.setOffsetAndOrient(offset, orient);
    }
  };

  _proto.removeShape = function removeShape(v) {
    var index = this.shapes.indexOf(v);

    if (index >= 0) {
      fastRemoveAt(this.shapes, index);
      this.body.removeShape(v.shape);
      v.setIndex(-1);
    }
  };

  _proto.syncSceneToPhysics = function syncSceneToPhysics(force) {
    if (force === void 0) {
      force = false;
    }

    var node = this.node;
    var needUpdateTransform = (0, _util.updateWorldTransform)(node, force);

    if (!force && !needUpdateTransform) {
      return;
    }

    Vec3.copy(this.body.position, node.__wpos);
    Quat.copy(this.body.quaternion, node.__wrot);

    if (node._localMatDirty & PHYSICS_SCALE) {
      var wscale = node.__wscale;

      for (var i = 0; i < this.shapes.length; i++) {
        this.shapes[i].setScale(wscale);
      }
    }

    if (this.body.isSleeping()) {
      this.body.wakeUp();
    } // body world aabb need to be recalculated


    this.body.aabbNeedsUpdate = true;
  };

  _proto.syncPhysicsToScene = function syncPhysicsToScene() {
    if (this.body.type != _physicsEnum.ERigidBodyType.STATIC) {
      Vec3.copy(v3_0, this.body.position);
      Quat.copy(quat_0, this.body.quaternion);
      (0, _util.updateWorldRT)(this.node, v3_0, quat_0);
    }
  };

  _proto.destroy = function destroy() {
    this.node.off(cc.Node.EventType.GROUP_CHANGED, this._updateGroup, this);
    CannonSharedBody.sharedBodiesMap["delete"](this.node._id);
    this.node = null;
    this.wrappedWorld = null;
    this.body = null;
    this.shapes = null;
    this.onCollidedListener = null;
  };

  _proto.onCollided = function onCollided(event) {
    CollisionEventObject.type = event.event;
    var self = (0, _util.getWrap)(event.selfShape);
    var other = (0, _util.getWrap)(event.otherShape);

    if (self) {
      CollisionEventObject.selfCollider = self.collider;
      CollisionEventObject.otherCollider = other ? other.collider : null;
      var i = 0;

      for (i = CollisionEventObject.contacts.length; i--;) {
        contactsPool.push(CollisionEventObject.contacts.pop());
      }

      for (i = 0; i < event.contacts.length; i++) {
        var cq = event.contacts[i];

        if (contactsPool.length > 0) {
          var c = contactsPool.pop();
          Vec3.copy(c.contactA, cq.ri);
          Vec3.copy(c.contactB, cq.rj);
          Vec3.copy(c.normal, cq.ni);
          CollisionEventObject.contacts.push(c);
        } else {
          var _c = {
            contactA: Vec3.copy(new Vec3(), cq.ri),
            contactB: Vec3.copy(new Vec3(), cq.rj),
            normal: Vec3.copy(new Vec3(), cq.ni)
          };
          CollisionEventObject.contacts.push(_c);
        }
      }

      for (i = 0; i < this.shapes.length; i++) {
        var shape = this.shapes[i];
        shape.collider.emit(CollisionEventObject.type, CollisionEventObject);
      }
    }
  };

  return CannonSharedBody;
}();

exports.CannonSharedBody = CannonSharedBody;
CannonSharedBody.sharedBodiesMap = new Map();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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