
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/particle/renderer/trail.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _CCClassDecorator = require("../../../platform/CCClassDecorator");

var _valueTypes = require("../../../value-types");

var _gfx = _interopRequireDefault(require("../../../../renderer/gfx"));

var _pool = _interopRequireDefault(require("../../../../renderer/memop/pool"));

var _curveRange = _interopRequireDefault(require("../animator/curve-range"));

var _gradientRange = _interopRequireDefault(require("../animator/gradient-range"));

var _enum = require("../enum");

var _utils = _interopRequireDefault(require("../utils"));

var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _descriptor9, _descriptor10, _descriptor11, _descriptor12, _temp;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

// tslint:disable: max-line-length
var PRE_TRIANGLE_INDEX = 1;
var NEXT_TRIANGLE_INDEX = 1 << 2;
var DIRECTION_THRESHOLD = Math.cos((0, _valueTypes.toRadian)(100));
var _temp_trailEle = {
  position: cc.v3(),
  velocity: cc.v3()
};

var _temp_quat = cc.quat();

var _temp_xform = cc.mat4();

var _temp_Vec3 = cc.v3();

var _temp_Vec3_1 = cc.v3();

var _temp_color = cc.color(); // var barycentric = [1, 0, 0, 0, 1, 0, 0, 0, 1]; // <wireframe debug>
// var _bcIdx = 0;


var ITrailElement = function ITrailElement() {
  this.position = void 0;
  this.lifetime = void 0;
  this.width = void 0;
  this.velocity = void 0;
  this.color = void 0;
}; // the valid element is in [start,end) range.if start equals -1,it represents the array is empty.


var TrailSegment =
/*#__PURE__*/
function () {
  function TrailSegment(maxTrailElementNum) {
    this.start = void 0;
    this.end = void 0;
    this.trailElements = [];
    this.start = -1;
    this.end = -1;
    this.trailElements = [];

    while (maxTrailElementNum--) {
      this.trailElements.push({
        position: cc.v3(),
        lifetime: 0,
        width: 0,
        velocity: cc.v3(),
        direction: 0,
        color: cc.color()
      });
    }
  }

  var _proto = TrailSegment.prototype;

  _proto.getElement = function getElement(idx) {
    if (this.start === -1) {
      return null;
    }

    if (idx < 0) {
      idx = (idx + this.trailElements.length) % this.trailElements.length;
    }

    if (idx >= this.trailElements.length) {
      idx %= this.trailElements.length;
    }

    return this.trailElements[idx];
  };

  _proto.addElement = function addElement() {
    if (this.trailElements.length === 0) {
      return null;
    }

    if (this.start === -1) {
      this.start = 0;
      this.end = 1;
      return this.trailElements[0];
    }

    if (this.start === this.end) {
      this.trailElements.splice(this.end, 0, {
        position: cc.v3(),
        lifetime: 0,
        width: 0,
        velocity: cc.v3(),
        direction: 0,
        color: cc.color()
      });
      this.start++;
      this.start %= this.trailElements.length;
    }

    var newEleLoc = this.end++;
    this.end %= this.trailElements.length;
    return this.trailElements[newEleLoc];
  };

  _proto.iterateElement = function iterateElement(target, f, p, dt) {
    var end = this.start >= this.end ? this.end + this.trailElements.length : this.end;

    for (var i = this.start; i < end; i++) {
      if (f(target, this.trailElements[i % this.trailElements.length], p, dt)) {
        this.start++;
        this.start %= this.trailElements.length;
      }
    }

    if (this.start === end) {
      this.start = -1;
      this.end = -1;
    }
  };

  _proto.count = function count() {
    if (this.start < this.end) {
      return this.end - this.start;
    } else {
      return this.trailElements.length + this.end - this.start;
    }
  };

  _proto.clear = function clear() {
    this.start = -1;
    this.end = -1;
  };

  return TrailSegment;
}();
/**
 * !#en The trail module of 3d particle.
 * !#zh 3D 粒子拖尾模块
 * @class TrailModule
 */


var TrailModule = (_dec = (0, _CCClassDecorator.ccclass)('cc.TrailModule'), _dec2 = (0, _CCClassDecorator.property)({
  type: _enum.TrailMode
}), _dec3 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"]
}), _dec4 = (0, _CCClassDecorator.property)({
  type: _enum.Space
}), _dec5 = (0, _CCClassDecorator.property)({
  type: _enum.TextureMode
}), _dec6 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"]
}), _dec7 = (0, _CCClassDecorator.property)({
  type: _gradientRange["default"]
}), _dec8 = (0, _CCClassDecorator.property)({
  type: _gradientRange["default"]
}), _dec(_class = (_class2 = (_temp =
/*#__PURE__*/
function () {
  _createClass(TrailModule, [{
    key: "enable",

    /**
     * !#en The enable of trailModule.
     * !#zh 是否启用
     * @property {Boolean} enable
     */
    get: function get() {
      return this._enable;
    },
    set: function set(val) {
      if (val) {
        this._createTrailData();
      }

      if (val && !this._enable) {
        this._enable = val;

        this._particleSystem._assembler._updateTrailMaterial();
      }

      this._enable = val;

      this._particleSystem._assembler._updateTrailEnable(this._enable);
    }
    /**
     * !#en Sets how particles generate trajectories.
     * !#zh 设定粒子生成轨迹的方式。
     * @property {TrailMode} mode
     */

  }, {
    key: "minParticleDistance",

    /**
     * !#en Minimum spacing between each track particle
     * !#zh 每个轨迹粒子之间的最小间距。
     * @property {Number} minParticleDistance
     */
    get: function get() {
      return this._minParticleDistance;
    },
    set: function set(val) {
      this._minParticleDistance = val;
      this._minSquaredDistance = val * val;
    }
  }, {
    key: "space",

    /**
     * !#en The coordinate system of trajectories.
     * !#zh 轨迹设定时的坐标系。
     * @property {Space} space
     */
    get: function get() {
      return this._space;
    },
    set: function set(val) {
      this._space = val;

      if (this._particleSystem) {
        this._particleSystem._assembler._updateTrailMaterial();
      }
    }
    /**
     * !#en Whether the particle itself exists.
     * !#zh 粒子本身是否存在。
     * @property {Boolean} existWithParticles
     */

  }]);

  function TrailModule() {
    _initializerDefineProperty(this, "_enable", _descriptor, this);

    _initializerDefineProperty(this, "mode", _descriptor2, this);

    _initializerDefineProperty(this, "lifeTime", _descriptor3, this);

    _initializerDefineProperty(this, "_minParticleDistance", _descriptor4, this);

    _initializerDefineProperty(this, "_space", _descriptor5, this);

    _initializerDefineProperty(this, "existWithParticles", _descriptor6, this);

    _initializerDefineProperty(this, "textureMode", _descriptor7, this);

    _initializerDefineProperty(this, "widthFromParticle", _descriptor8, this);

    _initializerDefineProperty(this, "widthRatio", _descriptor9, this);

    _initializerDefineProperty(this, "colorFromParticle", _descriptor10, this);

    _initializerDefineProperty(this, "colorOverTrail", _descriptor11, this);

    _initializerDefineProperty(this, "colorOvertime", _descriptor12, this);

    this._particleSystem = null;
    this._minSquaredDistance = 0;
    this._vertSize = 0;
    this._trailNum = 0;
    this._trailLifetime = 0;
    this.vbOffset = 0;
    this.ibOffset = 0;
    this._trailSegments = null;
    this._particleTrail = null;
    this._ia = null;
    this._gfxVFmt = null;
    this._vbF32 = null;
    this._vbUint32 = null;
    this._iBuffer = null;
    this._needTransform = null;
    this._defaultMat = null;
    this._material = null;
    this._gfxVFmt = new _gfx["default"].VertexFormat([{
      name: _gfx["default"].ATTR_POSITION,
      type: _gfx["default"].ATTR_TYPE_FLOAT32,
      num: 3
    }, {
      name: _gfx["default"].ATTR_TEX_COORD,
      type: _gfx["default"].ATTR_TYPE_FLOAT32,
      num: 4
    }, //{ name: gfx.ATTR_TEX_COORD2, type: gfx.ATTR_TYPE_FLOAT32, num: 3 }, // <wireframe debug>
    {
      name: _gfx["default"].ATTR_TEX_COORD1,
      type: _gfx["default"].ATTR_TYPE_FLOAT32,
      num: 3
    }, {
      name: _gfx["default"].ATTR_COLOR,
      type: _gfx["default"].ATTR_TYPE_UINT8,
      num: 4,
      normalize: true
    }]);
    this._vertSize = this._gfxVFmt._bytes;
    this._particleTrail = new _utils["default"](); // Map<Particle, TrailSegment>();
  }

  var _proto2 = TrailModule.prototype;

  _proto2.onInit = function onInit(ps) {
    this._particleSystem = ps;
    this.minParticleDistance = this._minParticleDistance;
    var burstCount = 0;

    for (var _iterator = ps.bursts, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _iterator[Symbol.iterator]();;) {
      var _ref;

      if (_isArray) {
        if (_i >= _iterator.length) break;
        _ref = _iterator[_i++];
      } else {
        _i = _iterator.next();
        if (_i.done) break;
        _ref = _i.value;
      }

      var b = _ref;
      burstCount += b.getMaxCount(ps);
    }

    this.lifeTime.constant = 1;
    this._trailNum = Math.ceil(ps.startLifetime.getMax() * this.lifeTime.getMax() * 60 * (ps.rateOverTime.getMax() * ps.duration + burstCount));
    this._trailSegments = new _pool["default"](function () {
      return new TrailSegment(10);
    }, Math.ceil(ps.rateOverTime.getMax() * ps.duration));

    if (this._enable) {
      this.enable = this._enable;

      this._updateMaterial();
    }
  };

  _proto2.onEnable = function onEnable() {};

  _proto2.onDisable = function onDisable() {};

  _proto2.destroy = function destroy() {
    if (this._trailSegments) {
      this._trailSegments.clear(function (obj) {
        obj.trailElements.length = 0;
      });

      this._trailSegments = null;
    }
  };

  _proto2.clear = function clear() {
    if (this.enable) {
      var trailIter = this._particleTrail.values();

      var trail = trailIter.next();

      while (!trail.done) {
        trail.value.clear();
        trail = trailIter.next();
      }

      this._particleTrail.clear();

      this.updateTrailBuffer();
    }
  };

  _proto2._createTrailData = function _createTrailData() {
    var model = this._particleSystem._assembler._model;

    if (model) {
      model.createTrailData(this._gfxVFmt, this._trailNum);
      var subData = model._subDatas[1];
      this._vbF32 = subData.getVData();
      this._vbUint32 = subData.getVData(Uint32Array);
      this._iBuffer = subData.iData;
    }
  };

  _proto2._updateMaterial = function _updateMaterial() {
    if (this._particleSystem) {
      var mat = this._particleSystem.trailMaterial;

      if (mat) {
        this._material = mat;
      } else {
        this._material = this._particleSystem._assembler._defaultTrailMat;
      }
    }
  };

  _proto2.update = function update() {
    this._trailLifetime = this.lifeTime.evaluate(this._particleSystem._time, 1);

    if (this.space === _enum.Space.World && this._particleSystem._simulationSpace === _enum.Space.Local) {
      this._needTransform = true;

      this._particleSystem.node.getWorldMatrix(_temp_xform);

      this._particleSystem.node.getWorldRotation(_temp_quat);
    } else {
      this._needTransform = false;
    }
  };

  _proto2.animate = function animate(p, scaledDt) {
    if (!this._trailSegments) {
      return;
    }

    var trail = this._particleTrail.get(p);

    if (!trail) {
      trail = this._trailSegments.alloc();

      this._particleTrail.set(p, trail);

      return;
    }

    var lastSeg = trail.getElement(trail.end - 1);

    if (this._needTransform) {
      _valueTypes.Vec3.transformMat4(_temp_Vec3, p.position, _temp_xform);
    } else {
      _valueTypes.Vec3.copy(_temp_Vec3, p.position);
    }

    if (lastSeg) {
      trail.iterateElement(this, this._updateTrailElement, p, scaledDt);

      if (_valueTypes.Vec3.squaredDistance(lastSeg.position, _temp_Vec3) < this._minSquaredDistance) {
        return;
      }
    }

    lastSeg = trail.addElement();

    if (!lastSeg) {
      return;
    }

    _valueTypes.Vec3.copy(lastSeg.position, _temp_Vec3);

    lastSeg.lifetime = 0;

    if (this.widthFromParticle) {
      lastSeg.width = p.size.x * this.widthRatio.evaluate(0, 1);
    } else {
      lastSeg.width = this.widthRatio.evaluate(0, 1);
    }

    var trailNum = trail.count();

    if (trailNum === 2) {
      var lastSecondTrail = trail.getElement(trail.end - 2);

      _valueTypes.Vec3.subtract(lastSecondTrail.velocity, lastSeg.position, lastSecondTrail.position);
    } else if (trailNum > 2) {
      var _lastSecondTrail = trail.getElement(trail.end - 2);

      var lastThirdTrail = trail.getElement(trail.end - 3);

      _valueTypes.Vec3.subtract(_temp_Vec3, lastThirdTrail.position, _lastSecondTrail.position);

      _valueTypes.Vec3.subtract(_temp_Vec3_1, lastSeg.position, _lastSecondTrail.position);

      _valueTypes.Vec3.subtract(_lastSecondTrail.velocity, _temp_Vec3_1, _temp_Vec3);

      if (_valueTypes.Vec3.equals(cc.Vec3.ZERO, _lastSecondTrail.velocity)) {
        _valueTypes.Vec3.copy(_lastSecondTrail.velocity, _temp_Vec3);
      }
    }

    if (this.colorFromParticle) {
      lastSeg.color.set(p.color);
    } else {
      lastSeg.color.set(this.colorOvertime.evaluate(0, 1));
    }
  };

  _proto2._updateTrailElement = function _updateTrailElement(trail, trailEle, p, dt) {
    trailEle.lifetime += dt;

    if (trail.colorFromParticle) {
      trailEle.color.set(p.color);
      trailEle.color.multiply(trail.colorOvertime.evaluate(1.0 - p.remainingLifetime / p.startLifetime, 1));
    } else {
      trailEle.color.set(trail.colorOvertime.evaluate(1.0 - p.remainingLifetime / p.startLifetime, 1));
    }

    if (trail.widthFromParticle) {
      trailEle.width = p.size.x * trail.widthRatio.evaluate(trailEle.lifetime / trail._trailLifetime, 1);
    } else {
      trailEle.width = trail.widthRatio.evaluate(trailEle.lifetime / trail._trailLifetime, 1);
    }

    return trailEle.lifetime > trail._trailLifetime;
  };

  _proto2.removeParticle = function removeParticle(p) {
    var trail = this._particleTrail.get(p);

    if (trail && this._trailSegments) {
      trail.clear();

      this._trailSegments.free(trail);

      this._particleTrail["delete"](p);
    }
  };

  _proto2.updateTrailBuffer = function updateTrailBuffer() {
    this.vbOffset = 0;
    this.ibOffset = 0;

    for (var _iterator2 = this._particleTrail.keys(), _isArray2 = Array.isArray(_iterator2), _i2 = 0, _iterator2 = _isArray2 ? _iterator2 : _iterator2[Symbol.iterator]();;) {
      var _ref2;

      if (_isArray2) {
        if (_i2 >= _iterator2.length) break;
        _ref2 = _iterator2[_i2++];
      } else {
        _i2 = _iterator2.next();
        if (_i2.done) break;
        _ref2 = _i2.value;
      }

      var p = _ref2;

      var trailSeg = this._particleTrail.get(p);

      if (trailSeg.start === -1) {
        continue;
      }

      var indexOffset = this.vbOffset * 4 / this._vertSize;
      var end = trailSeg.start >= trailSeg.end ? trailSeg.end + trailSeg.trailElements.length : trailSeg.end;
      var trailNum = end - trailSeg.start; // const lastSegRatio = Vec3.distance(trailSeg.getTailElement()!.position, p.position) / this._minParticleDistance;

      var textCoordSeg = 1 / trailNum
      /*- 1 + lastSegRatio*/
      ;
      var startSegEle = trailSeg.trailElements[trailSeg.start];

      this._fillVertexBuffer(startSegEle, this.colorOverTrail.evaluate(1, 1), indexOffset, 1, 0, NEXT_TRIANGLE_INDEX);

      for (var i = trailSeg.start + 1; i < end; i++) {
        var segEle = trailSeg.trailElements[i % trailSeg.trailElements.length];
        var j = i - trailSeg.start;

        this._fillVertexBuffer(segEle, this.colorOverTrail.evaluate(1 - j / trailNum, 1), indexOffset, 1 - j * textCoordSeg, j, PRE_TRIANGLE_INDEX | NEXT_TRIANGLE_INDEX);
      }

      if (this._needTransform) {
        _valueTypes.Vec3.transformMat4(_temp_trailEle.position, p.position, _temp_xform);
      } else {
        _valueTypes.Vec3.copy(_temp_trailEle.position, p.position);
      }

      if (trailNum === 1 || trailNum === 2) {
        var lastSecondTrail = trailSeg.getElement(trailSeg.end - 1);

        _valueTypes.Vec3.subtract(lastSecondTrail.velocity, _temp_trailEle.position, lastSecondTrail.position);

        this._vbF32[this.vbOffset - this._vertSize / 4 - 4] = lastSecondTrail.velocity.x;
        this._vbF32[this.vbOffset - this._vertSize / 4 - 3] = lastSecondTrail.velocity.y;
        this._vbF32[this.vbOffset - this._vertSize / 4 - 2] = lastSecondTrail.velocity.z;
        this._vbF32[this.vbOffset - 4] = lastSecondTrail.velocity.x;
        this._vbF32[this.vbOffset - 3] = lastSecondTrail.velocity.y;
        this._vbF32[this.vbOffset - 2] = lastSecondTrail.velocity.z;

        _valueTypes.Vec3.subtract(_temp_trailEle.velocity, _temp_trailEle.position, lastSecondTrail.position);

        this._checkDirectionReverse(_temp_trailEle, lastSecondTrail);
      } else if (trailNum > 2) {
        var _lastSecondTrail2 = trailSeg.getElement(trailSeg.end - 1);

        var lastThirdTrail = trailSeg.getElement(trailSeg.end - 2);

        _valueTypes.Vec3.subtract(_temp_Vec3, lastThirdTrail.position, _lastSecondTrail2.position);

        _valueTypes.Vec3.subtract(_temp_Vec3_1, _temp_trailEle.position, _lastSecondTrail2.position);

        _valueTypes.Vec3.normalize(_temp_Vec3, _temp_Vec3);

        _valueTypes.Vec3.normalize(_temp_Vec3_1, _temp_Vec3_1);

        _valueTypes.Vec3.subtract(_lastSecondTrail2.velocity, _temp_Vec3_1, _temp_Vec3);

        _valueTypes.Vec3.normalize(_lastSecondTrail2.velocity, _lastSecondTrail2.velocity);

        this._checkDirectionReverse(_lastSecondTrail2, lastThirdTrail);

        this.vbOffset -= this._vertSize / 4 * 2;
        this.ibOffset -= 6; //_bcIdx = (_bcIdx - 6 + 9) % 9;  // <wireframe debug>

        this._fillVertexBuffer(_lastSecondTrail2, this.colorOverTrail.evaluate(textCoordSeg, 1), indexOffset, textCoordSeg, trailNum - 1, PRE_TRIANGLE_INDEX | NEXT_TRIANGLE_INDEX);

        _valueTypes.Vec3.subtract(_temp_trailEle.velocity, _temp_trailEle.position, _lastSecondTrail2.position);

        _valueTypes.Vec3.normalize(_temp_trailEle.velocity, _temp_trailEle.velocity);

        this._checkDirectionReverse(_temp_trailEle, _lastSecondTrail2);
      }

      if (this.widthFromParticle) {
        _temp_trailEle.width = p.size.x * this.widthRatio.evaluate(0, 1);
      } else {
        _temp_trailEle.width = this.widthRatio.evaluate(0, 1);
      }

      _temp_trailEle.color = p.color;

      if (_valueTypes.Vec3.equals(_temp_trailEle.velocity, cc.Vec3.ZERO)) {
        this.ibOffset -= 3;
      } else {
        this._fillVertexBuffer(_temp_trailEle, this.colorOverTrail.evaluate(0, 1), indexOffset, 0, trailNum, PRE_TRIANGLE_INDEX);
      }
    }

    this._updateIA(this.ibOffset);
  };

  _proto2._fillVertexBuffer = function _fillVertexBuffer(trailSeg, colorModifer, indexOffset, xTexCoord, trailEleIdx, indexSet) {
    this._vbF32[this.vbOffset++] = trailSeg.position.x;
    this._vbF32[this.vbOffset++] = trailSeg.position.y;
    this._vbF32[this.vbOffset++] = trailSeg.position.z;
    this._vbF32[this.vbOffset++] = 0;
    this._vbF32[this.vbOffset++] = trailSeg.width;
    this._vbF32[this.vbOffset++] = xTexCoord;
    this._vbF32[this.vbOffset++] = 0; // this._vbF32[this.vbOffset++] = barycentric[_bcIdx++];  // <wireframe debug>
    // this._vbF32[this.vbOffset++] = barycentric[_bcIdx++];
    // this._vbF32[this.vbOffset++] = barycentric[_bcIdx++];
    // _bcIdx %= 9;

    this._vbF32[this.vbOffset++] = trailSeg.velocity.x;
    this._vbF32[this.vbOffset++] = trailSeg.velocity.y;
    this._vbF32[this.vbOffset++] = trailSeg.velocity.z;

    _temp_color.set(trailSeg.color);

    _temp_color.multiply(colorModifer);

    this._vbUint32[this.vbOffset++] = _temp_color._val;
    this._vbF32[this.vbOffset++] = trailSeg.position.x;
    this._vbF32[this.vbOffset++] = trailSeg.position.y;
    this._vbF32[this.vbOffset++] = trailSeg.position.z;
    this._vbF32[this.vbOffset++] = 1;
    this._vbF32[this.vbOffset++] = trailSeg.width;
    this._vbF32[this.vbOffset++] = xTexCoord;
    this._vbF32[this.vbOffset++] = 1; // this._vbF32[this.vbOffset++] = barycentric[_bcIdx++];  // <wireframe debug>
    // this._vbF32[this.vbOffset++] = barycentric[_bcIdx++];
    // this._vbF32[this.vbOffset++] = barycentric[_bcIdx++];
    // _bcIdx %= 9;

    this._vbF32[this.vbOffset++] = trailSeg.velocity.x;
    this._vbF32[this.vbOffset++] = trailSeg.velocity.y;
    this._vbF32[this.vbOffset++] = trailSeg.velocity.z;
    this._vbUint32[this.vbOffset++] = _temp_color._val;

    if (indexSet & PRE_TRIANGLE_INDEX) {
      this._iBuffer[this.ibOffset++] = indexOffset + 2 * trailEleIdx;
      this._iBuffer[this.ibOffset++] = indexOffset + 2 * trailEleIdx - 1;
      this._iBuffer[this.ibOffset++] = indexOffset + 2 * trailEleIdx + 1;
    }

    if (indexSet & NEXT_TRIANGLE_INDEX) {
      this._iBuffer[this.ibOffset++] = indexOffset + 2 * trailEleIdx;
      this._iBuffer[this.ibOffset++] = indexOffset + 2 * trailEleIdx + 1;
      this._iBuffer[this.ibOffset++] = indexOffset + 2 * trailEleIdx + 2;
    }
  };

  _proto2._updateIA = function _updateIA(count) {
    if (this._particleSystem && this._particleSystem._assembler) {
      this._particleSystem._assembler.updateIA(1, count, true, true);
    }
  };

  _proto2._checkDirectionReverse = function _checkDirectionReverse(currElement, prevElement) {
    if (_valueTypes.Vec3.dot(currElement.velocity, prevElement.velocity) < DIRECTION_THRESHOLD) {
      currElement.direction = 1 - prevElement.direction;
    } else {
      currElement.direction = prevElement.direction;
    }
  };

  return TrailModule;
}(), _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "_enable", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return false;
  }
}), _applyDecoratedDescriptor(_class2.prototype, "enable", [_CCClassDecorator.property], Object.getOwnPropertyDescriptor(_class2.prototype, "enable"), _class2.prototype), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "mode", [_dec2], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return _enum.TrailMode.Particles;
  }
}), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "lifeTime", [_dec3], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "_minParticleDistance", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 0.1;
  }
}), _applyDecoratedDescriptor(_class2.prototype, "minParticleDistance", [_CCClassDecorator.property], Object.getOwnPropertyDescriptor(_class2.prototype, "minParticleDistance"), _class2.prototype), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "_space", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return _enum.Space.World;
  }
}), _applyDecoratedDescriptor(_class2.prototype, "space", [_dec4], Object.getOwnPropertyDescriptor(_class2.prototype, "space"), _class2.prototype), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "existWithParticles", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return true;
  }
}), _descriptor7 = _applyDecoratedDescriptor(_class2.prototype, "textureMode", [_dec5], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return _enum.TextureMode.Stretch;
  }
}), _descriptor8 = _applyDecoratedDescriptor(_class2.prototype, "widthFromParticle", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return true;
  }
}), _descriptor9 = _applyDecoratedDescriptor(_class2.prototype, "widthRatio", [_dec6], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor10 = _applyDecoratedDescriptor(_class2.prototype, "colorFromParticle", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return false;
  }
}), _descriptor11 = _applyDecoratedDescriptor(_class2.prototype, "colorOverTrail", [_dec7], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _gradientRange["default"]();
  }
}), _descriptor12 = _applyDecoratedDescriptor(_class2.prototype, "colorOvertime", [_dec8], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _gradientRange["default"]();
  }
})), _class2)) || _class);
exports["default"] = TrailModule;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvY29jb3MyZC9jb3JlLzNkL3BhcnRpY2xlL3JlbmRlcmVyL3RyYWlsLnRzIl0sIm5hbWVzIjpbIlBSRV9UUklBTkdMRV9JTkRFWCIsIk5FWFRfVFJJQU5HTEVfSU5ERVgiLCJESVJFQ1RJT05fVEhSRVNIT0xEIiwiTWF0aCIsImNvcyIsIl90ZW1wX3RyYWlsRWxlIiwicG9zaXRpb24iLCJjYyIsInYzIiwidmVsb2NpdHkiLCJfdGVtcF9xdWF0IiwicXVhdCIsIl90ZW1wX3hmb3JtIiwibWF0NCIsIl90ZW1wX1ZlYzMiLCJfdGVtcF9WZWMzXzEiLCJfdGVtcF9jb2xvciIsImNvbG9yIiwiSVRyYWlsRWxlbWVudCIsImxpZmV0aW1lIiwid2lkdGgiLCJUcmFpbFNlZ21lbnQiLCJtYXhUcmFpbEVsZW1lbnROdW0iLCJzdGFydCIsImVuZCIsInRyYWlsRWxlbWVudHMiLCJwdXNoIiwiZGlyZWN0aW9uIiwiZ2V0RWxlbWVudCIsImlkeCIsImxlbmd0aCIsImFkZEVsZW1lbnQiLCJzcGxpY2UiLCJuZXdFbGVMb2MiLCJpdGVyYXRlRWxlbWVudCIsInRhcmdldCIsImYiLCJwIiwiZHQiLCJpIiwiY291bnQiLCJjbGVhciIsIlRyYWlsTW9kdWxlIiwidHlwZSIsIlRyYWlsTW9kZSIsIkN1cnZlUmFuZ2UiLCJTcGFjZSIsIlRleHR1cmVNb2RlIiwiR3JhZGllbnRSYW5nZSIsIl9lbmFibGUiLCJ2YWwiLCJfY3JlYXRlVHJhaWxEYXRhIiwiX3BhcnRpY2xlU3lzdGVtIiwiX2Fzc2VtYmxlciIsIl91cGRhdGVUcmFpbE1hdGVyaWFsIiwiX3VwZGF0ZVRyYWlsRW5hYmxlIiwiX21pblBhcnRpY2xlRGlzdGFuY2UiLCJfbWluU3F1YXJlZERpc3RhbmNlIiwiX3NwYWNlIiwiX3ZlcnRTaXplIiwiX3RyYWlsTnVtIiwiX3RyYWlsTGlmZXRpbWUiLCJ2Yk9mZnNldCIsImliT2Zmc2V0IiwiX3RyYWlsU2VnbWVudHMiLCJfcGFydGljbGVUcmFpbCIsIl9pYSIsIl9nZnhWRm10IiwiX3ZiRjMyIiwiX3ZiVWludDMyIiwiX2lCdWZmZXIiLCJfbmVlZFRyYW5zZm9ybSIsIl9kZWZhdWx0TWF0IiwiX21hdGVyaWFsIiwiZ2Z4IiwiVmVydGV4Rm9ybWF0IiwibmFtZSIsIkFUVFJfUE9TSVRJT04iLCJBVFRSX1RZUEVfRkxPQVQzMiIsIm51bSIsIkFUVFJfVEVYX0NPT1JEIiwiQVRUUl9URVhfQ09PUkQxIiwiQVRUUl9DT0xPUiIsIkFUVFJfVFlQRV9VSU5UOCIsIm5vcm1hbGl6ZSIsIl9ieXRlcyIsIk1hcFV0aWxzIiwib25Jbml0IiwicHMiLCJtaW5QYXJ0aWNsZURpc3RhbmNlIiwiYnVyc3RDb3VudCIsImJ1cnN0cyIsImIiLCJnZXRNYXhDb3VudCIsImxpZmVUaW1lIiwiY29uc3RhbnQiLCJjZWlsIiwic3RhcnRMaWZldGltZSIsImdldE1heCIsInJhdGVPdmVyVGltZSIsImR1cmF0aW9uIiwiUG9vbCIsImVuYWJsZSIsIl91cGRhdGVNYXRlcmlhbCIsIm9uRW5hYmxlIiwib25EaXNhYmxlIiwiZGVzdHJveSIsIm9iaiIsInRyYWlsSXRlciIsInZhbHVlcyIsInRyYWlsIiwibmV4dCIsImRvbmUiLCJ2YWx1ZSIsInVwZGF0ZVRyYWlsQnVmZmVyIiwibW9kZWwiLCJfbW9kZWwiLCJjcmVhdGVUcmFpbERhdGEiLCJzdWJEYXRhIiwiX3N1YkRhdGFzIiwiZ2V0VkRhdGEiLCJVaW50MzJBcnJheSIsImlEYXRhIiwibWF0IiwidHJhaWxNYXRlcmlhbCIsIl9kZWZhdWx0VHJhaWxNYXQiLCJ1cGRhdGUiLCJldmFsdWF0ZSIsIl90aW1lIiwic3BhY2UiLCJXb3JsZCIsIl9zaW11bGF0aW9uU3BhY2UiLCJMb2NhbCIsIm5vZGUiLCJnZXRXb3JsZE1hdHJpeCIsImdldFdvcmxkUm90YXRpb24iLCJhbmltYXRlIiwic2NhbGVkRHQiLCJnZXQiLCJhbGxvYyIsInNldCIsImxhc3RTZWciLCJWZWMzIiwidHJhbnNmb3JtTWF0NCIsImNvcHkiLCJfdXBkYXRlVHJhaWxFbGVtZW50Iiwic3F1YXJlZERpc3RhbmNlIiwid2lkdGhGcm9tUGFydGljbGUiLCJzaXplIiwieCIsIndpZHRoUmF0aW8iLCJ0cmFpbE51bSIsImxhc3RTZWNvbmRUcmFpbCIsInN1YnRyYWN0IiwibGFzdFRoaXJkVHJhaWwiLCJlcXVhbHMiLCJaRVJPIiwiY29sb3JGcm9tUGFydGljbGUiLCJjb2xvck92ZXJ0aW1lIiwidHJhaWxFbGUiLCJtdWx0aXBseSIsInJlbWFpbmluZ0xpZmV0aW1lIiwicmVtb3ZlUGFydGljbGUiLCJmcmVlIiwia2V5cyIsInRyYWlsU2VnIiwiaW5kZXhPZmZzZXQiLCJ0ZXh0Q29vcmRTZWciLCJzdGFydFNlZ0VsZSIsIl9maWxsVmVydGV4QnVmZmVyIiwiY29sb3JPdmVyVHJhaWwiLCJzZWdFbGUiLCJqIiwieSIsInoiLCJfY2hlY2tEaXJlY3Rpb25SZXZlcnNlIiwiX3VwZGF0ZUlBIiwiY29sb3JNb2RpZmVyIiwieFRleENvb3JkIiwidHJhaWxFbGVJZHgiLCJpbmRleFNldCIsIl92YWwiLCJ1cGRhdGVJQSIsImN1cnJFbGVtZW50IiwicHJldkVsZW1lbnQiLCJkb3QiLCJwcm9wZXJ0eSIsIlBhcnRpY2xlcyIsIlN0cmV0Y2giXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7Ozs7Ozs7Ozs7Ozs7OztBQUVBO0FBQ0EsSUFBTUEsa0JBQWtCLEdBQUcsQ0FBM0I7QUFDQSxJQUFNQyxtQkFBbUIsR0FBRyxLQUFLLENBQWpDO0FBQ0EsSUFBTUMsbUJBQW1CLEdBQUdDLElBQUksQ0FBQ0MsR0FBTCxDQUFTLDBCQUFTLEdBQVQsQ0FBVCxDQUE1QjtBQUVBLElBQU1DLGNBQWMsR0FBRztBQUFFQyxFQUFBQSxRQUFRLEVBQUVDLEVBQUUsQ0FBQ0MsRUFBSCxFQUFaO0FBQXFCQyxFQUFBQSxRQUFRLEVBQUVGLEVBQUUsQ0FBQ0MsRUFBSDtBQUEvQixDQUF2Qjs7QUFDQSxJQUFNRSxVQUFVLEdBQUdILEVBQUUsQ0FBQ0ksSUFBSCxFQUFuQjs7QUFDQSxJQUFNQyxXQUFXLEdBQUdMLEVBQUUsQ0FBQ00sSUFBSCxFQUFwQjs7QUFDQSxJQUFNQyxVQUFVLEdBQUdQLEVBQUUsQ0FBQ0MsRUFBSCxFQUFuQjs7QUFDQSxJQUFNTyxZQUFZLEdBQUdSLEVBQUUsQ0FBQ0MsRUFBSCxFQUFyQjs7QUFDQSxJQUFNUSxXQUFXLEdBQUdULEVBQUUsQ0FBQ1UsS0FBSCxFQUFwQixFQUVBO0FBQ0E7OztJQUdNQztPQUNGWjtPQUNBYTtPQUNBQztPQUNBWDtPQUNBUTtHQUdKOzs7SUFDTUk7OztBQUtGLHdCQUFhQyxrQkFBYixFQUFpQztBQUFBLFNBSmpDQyxLQUlpQztBQUFBLFNBSGpDQyxHQUdpQztBQUFBLFNBRmpDQyxhQUVpQyxHQUZqQixFQUVpQjtBQUM3QixTQUFLRixLQUFMLEdBQWEsQ0FBQyxDQUFkO0FBQ0EsU0FBS0MsR0FBTCxHQUFXLENBQUMsQ0FBWjtBQUNBLFNBQUtDLGFBQUwsR0FBcUIsRUFBckI7O0FBQ0EsV0FBT0gsa0JBQWtCLEVBQXpCLEVBQTZCO0FBQ3pCLFdBQUtHLGFBQUwsQ0FBbUJDLElBQW5CLENBQXdCO0FBQ3BCcEIsUUFBQUEsUUFBUSxFQUFFQyxFQUFFLENBQUNDLEVBQUgsRUFEVTtBQUVwQlcsUUFBQUEsUUFBUSxFQUFFLENBRlU7QUFHcEJDLFFBQUFBLEtBQUssRUFBRSxDQUhhO0FBSXBCWCxRQUFBQSxRQUFRLEVBQUVGLEVBQUUsQ0FBQ0MsRUFBSCxFQUpVO0FBS3BCbUIsUUFBQUEsU0FBUyxFQUFFLENBTFM7QUFNcEJWLFFBQUFBLEtBQUssRUFBRVYsRUFBRSxDQUFDVSxLQUFIO0FBTmEsT0FBeEI7QUFRSDtBQUNKOzs7O1NBRURXLGFBQUEsb0JBQVlDLEdBQVosRUFBaUI7QUFDYixRQUFJLEtBQUtOLEtBQUwsS0FBZSxDQUFDLENBQXBCLEVBQXVCO0FBQ25CLGFBQU8sSUFBUDtBQUNIOztBQUNELFFBQUlNLEdBQUcsR0FBRyxDQUFWLEVBQWE7QUFDVEEsTUFBQUEsR0FBRyxHQUFHLENBQUNBLEdBQUcsR0FBRyxLQUFLSixhQUFMLENBQW1CSyxNQUExQixJQUFvQyxLQUFLTCxhQUFMLENBQW1CSyxNQUE3RDtBQUNIOztBQUNELFFBQUlELEdBQUcsSUFBSSxLQUFLSixhQUFMLENBQW1CSyxNQUE5QixFQUFzQztBQUNsQ0QsTUFBQUEsR0FBRyxJQUFJLEtBQUtKLGFBQUwsQ0FBbUJLLE1BQTFCO0FBQ0g7O0FBQ0QsV0FBTyxLQUFLTCxhQUFMLENBQW1CSSxHQUFuQixDQUFQO0FBQ0g7O1NBRURFLGFBQUEsc0JBQWM7QUFDVixRQUFJLEtBQUtOLGFBQUwsQ0FBbUJLLE1BQW5CLEtBQThCLENBQWxDLEVBQXFDO0FBQ2pDLGFBQU8sSUFBUDtBQUNIOztBQUNELFFBQUksS0FBS1AsS0FBTCxLQUFlLENBQUMsQ0FBcEIsRUFBdUI7QUFDbkIsV0FBS0EsS0FBTCxHQUFhLENBQWI7QUFDQSxXQUFLQyxHQUFMLEdBQVcsQ0FBWDtBQUNBLGFBQU8sS0FBS0MsYUFBTCxDQUFtQixDQUFuQixDQUFQO0FBQ0g7O0FBQ0QsUUFBSSxLQUFLRixLQUFMLEtBQWUsS0FBS0MsR0FBeEIsRUFBNkI7QUFDekIsV0FBS0MsYUFBTCxDQUFtQk8sTUFBbkIsQ0FBMEIsS0FBS1IsR0FBL0IsRUFBb0MsQ0FBcEMsRUFBdUM7QUFDbkNsQixRQUFBQSxRQUFRLEVBQUVDLEVBQUUsQ0FBQ0MsRUFBSCxFQUR5QjtBQUVuQ1csUUFBQUEsUUFBUSxFQUFFLENBRnlCO0FBR25DQyxRQUFBQSxLQUFLLEVBQUUsQ0FINEI7QUFJbkNYLFFBQUFBLFFBQVEsRUFBRUYsRUFBRSxDQUFDQyxFQUFILEVBSnlCO0FBS25DbUIsUUFBQUEsU0FBUyxFQUFFLENBTHdCO0FBTW5DVixRQUFBQSxLQUFLLEVBQUVWLEVBQUUsQ0FBQ1UsS0FBSDtBQU40QixPQUF2QztBQVFBLFdBQUtNLEtBQUw7QUFDQSxXQUFLQSxLQUFMLElBQWMsS0FBS0UsYUFBTCxDQUFtQkssTUFBakM7QUFDSDs7QUFDRCxRQUFNRyxTQUFTLEdBQUcsS0FBS1QsR0FBTCxFQUFsQjtBQUNBLFNBQUtBLEdBQUwsSUFBWSxLQUFLQyxhQUFMLENBQW1CSyxNQUEvQjtBQUNBLFdBQU8sS0FBS0wsYUFBTCxDQUFtQlEsU0FBbkIsQ0FBUDtBQUNIOztTQUVEQyxpQkFBQSx3QkFBZ0JDLE1BQWhCLEVBQXdCQyxDQUF4QixFQUEyQkMsQ0FBM0IsRUFBOEJDLEVBQTlCLEVBQWtDO0FBQzlCLFFBQU1kLEdBQUcsR0FBRyxLQUFLRCxLQUFMLElBQWMsS0FBS0MsR0FBbkIsR0FBeUIsS0FBS0EsR0FBTCxHQUFXLEtBQUtDLGFBQUwsQ0FBbUJLLE1BQXZELEdBQWdFLEtBQUtOLEdBQWpGOztBQUNBLFNBQUssSUFBSWUsQ0FBQyxHQUFHLEtBQUtoQixLQUFsQixFQUF5QmdCLENBQUMsR0FBR2YsR0FBN0IsRUFBa0NlLENBQUMsRUFBbkMsRUFBdUM7QUFDbkMsVUFBSUgsQ0FBQyxDQUFDRCxNQUFELEVBQVMsS0FBS1YsYUFBTCxDQUFtQmMsQ0FBQyxHQUFHLEtBQUtkLGFBQUwsQ0FBbUJLLE1BQTFDLENBQVQsRUFBNERPLENBQTVELEVBQStEQyxFQUEvRCxDQUFMLEVBQXlFO0FBQ3JFLGFBQUtmLEtBQUw7QUFDQSxhQUFLQSxLQUFMLElBQWMsS0FBS0UsYUFBTCxDQUFtQkssTUFBakM7QUFDSDtBQUNKOztBQUNELFFBQUksS0FBS1AsS0FBTCxLQUFlQyxHQUFuQixFQUF3QjtBQUNwQixXQUFLRCxLQUFMLEdBQWEsQ0FBQyxDQUFkO0FBQ0EsV0FBS0MsR0FBTCxHQUFXLENBQUMsQ0FBWjtBQUNIO0FBQ0o7O1NBRURnQixRQUFBLGlCQUFTO0FBQ0wsUUFBSSxLQUFLakIsS0FBTCxHQUFhLEtBQUtDLEdBQXRCLEVBQTJCO0FBQ3ZCLGFBQU8sS0FBS0EsR0FBTCxHQUFXLEtBQUtELEtBQXZCO0FBQ0gsS0FGRCxNQUVPO0FBQ0gsYUFBTyxLQUFLRSxhQUFMLENBQW1CSyxNQUFuQixHQUE0QixLQUFLTixHQUFqQyxHQUF1QyxLQUFLRCxLQUFuRDtBQUNIO0FBQ0o7O1NBRURrQixRQUFBLGlCQUFTO0FBQ0wsU0FBS2xCLEtBQUwsR0FBYSxDQUFDLENBQWQ7QUFDQSxTQUFLQyxHQUFMLEdBQVcsQ0FBQyxDQUFaO0FBQ0g7Ozs7QUFHTDs7Ozs7OztJQU1xQmtCLHNCQURwQiwrQkFBUSxnQkFBUixXQW1DSSxnQ0FBUztBQUNOQyxFQUFBQSxJQUFJLEVBQUVDO0FBREEsQ0FBVCxXQVVBLGdDQUFTO0FBQ05ELEVBQUFBLElBQUksRUFBRUU7QUFEQSxDQUFULFdBK0JBLGdDQUFTO0FBQ05GLEVBQUFBLElBQUksRUFBRUc7QUFEQSxDQUFULFdBMkJBLGdDQUFTO0FBQ05ILEVBQUFBLElBQUksRUFBRUk7QUFEQSxDQUFULFdBbUJBLGdDQUFTO0FBQ05KLEVBQUFBLElBQUksRUFBRUU7QUFEQSxDQUFULFdBa0JBLGdDQUFTO0FBQ05GLEVBQUFBLElBQUksRUFBRUs7QUFEQSxDQUFULFdBVUEsZ0NBQVM7QUFDTkwsRUFBQUEsSUFBSSxFQUFFSztBQURBLENBQVQ7Ozs7OztBQWhKRDs7Ozs7d0JBTWM7QUFDVixhQUFPLEtBQUtDLE9BQVo7QUFDSDtzQkFFV0MsS0FBSztBQUNiLFVBQUlBLEdBQUosRUFBUztBQUNMLGFBQUtDLGdCQUFMO0FBQ0g7O0FBRUQsVUFBSUQsR0FBRyxJQUFJLENBQUMsS0FBS0QsT0FBakIsRUFBMEI7QUFDdEIsYUFBS0EsT0FBTCxHQUFlQyxHQUFmOztBQUNBLGFBQUtFLGVBQUwsQ0FBcUJDLFVBQXJCLENBQWdDQyxvQkFBaEM7QUFDSDs7QUFFRCxXQUFLTCxPQUFMLEdBQWVDLEdBQWY7O0FBQ0EsV0FBS0UsZUFBTCxDQUFxQkMsVUFBckIsQ0FBZ0NFLGtCQUFoQyxDQUFtRCxLQUFLTixPQUF4RDtBQUNIO0FBRUQ7Ozs7Ozs7OztBQXVCQTs7Ozs7d0JBTTJCO0FBQ3ZCLGFBQU8sS0FBS08sb0JBQVo7QUFDSDtzQkFFd0JOLEtBQUs7QUFDMUIsV0FBS00sb0JBQUwsR0FBNEJOLEdBQTVCO0FBQ0EsV0FBS08sbUJBQUwsR0FBMkJQLEdBQUcsR0FBR0EsR0FBakM7QUFDSDs7OztBQUtEOzs7Ozt3QkFRYTtBQUNULGFBQU8sS0FBS1EsTUFBWjtBQUNIO3NCQUVVUixLQUFLO0FBQ1osV0FBS1EsTUFBTCxHQUFjUixHQUFkOztBQUNBLFVBQUksS0FBS0UsZUFBVCxFQUEwQjtBQUN0QixhQUFLQSxlQUFMLENBQXFCQyxVQUFyQixDQUFnQ0Msb0JBQWhDO0FBQ0g7QUFDSjtBQUVEOzs7Ozs7OztBQW1GQSx5QkFBZTtBQUFBOztBQUFBOztBQUFBOztBQUFBOztBQUFBOztBQUFBOztBQUFBOztBQUFBOztBQUFBOztBQUFBOztBQUFBOztBQUFBOztBQUFBLFNBbEJmRixlQWtCZSxHQWxCRyxJQWtCSDtBQUFBLFNBakJmSyxtQkFpQmUsR0FqQk8sQ0FpQlA7QUFBQSxTQWhCZkUsU0FnQmUsR0FoQkgsQ0FnQkc7QUFBQSxTQWZmQyxTQWVlLEdBZkgsQ0FlRztBQUFBLFNBZGZDLGNBY2UsR0FkRSxDQWNGO0FBQUEsU0FiZkMsUUFhZSxHQWJKLENBYUk7QUFBQSxTQVpmQyxRQVllLEdBWkosQ0FZSTtBQUFBLFNBWGZDLGNBV2UsR0FYRSxJQVdGO0FBQUEsU0FWZkMsY0FVZSxHQVZFLElBVUY7QUFBQSxTQVRmQyxHQVNlLEdBVFQsSUFTUztBQUFBLFNBUmZDLFFBUWUsR0FSSixJQVFJO0FBQUEsU0FQZkMsTUFPZSxHQVBOLElBT007QUFBQSxTQU5mQyxTQU1lLEdBTkgsSUFNRztBQUFBLFNBTGZDLFFBS2UsR0FMSixJQUtJO0FBQUEsU0FKZkMsY0FJZSxHQUpFLElBSUY7QUFBQSxTQUhmQyxXQUdlLEdBSEQsSUFHQztBQUFBLFNBRmZDLFNBRWUsR0FGSCxJQUVHO0FBQ1gsU0FBS04sUUFBTCxHQUFnQixJQUFJTyxnQkFBSUMsWUFBUixDQUFxQixDQUNqQztBQUFFQyxNQUFBQSxJQUFJLEVBQUVGLGdCQUFJRyxhQUFaO0FBQTJCbEMsTUFBQUEsSUFBSSxFQUFFK0IsZ0JBQUlJLGlCQUFyQztBQUF3REMsTUFBQUEsR0FBRyxFQUFFO0FBQTdELEtBRGlDLEVBRWpDO0FBQUVILE1BQUFBLElBQUksRUFBRUYsZ0JBQUlNLGNBQVo7QUFBNEJyQyxNQUFBQSxJQUFJLEVBQUUrQixnQkFBSUksaUJBQXRDO0FBQXlEQyxNQUFBQSxHQUFHLEVBQUU7QUFBOUQsS0FGaUMsRUFHakM7QUFDQTtBQUFFSCxNQUFBQSxJQUFJLEVBQUVGLGdCQUFJTyxlQUFaO0FBQTZCdEMsTUFBQUEsSUFBSSxFQUFFK0IsZ0JBQUlJLGlCQUF2QztBQUEwREMsTUFBQUEsR0FBRyxFQUFFO0FBQS9ELEtBSmlDLEVBS2pDO0FBQUVILE1BQUFBLElBQUksRUFBRUYsZ0JBQUlRLFVBQVo7QUFBd0J2QyxNQUFBQSxJQUFJLEVBQUUrQixnQkFBSVMsZUFBbEM7QUFBbURKLE1BQUFBLEdBQUcsRUFBRSxDQUF4RDtBQUEyREssTUFBQUEsU0FBUyxFQUFFO0FBQXRFLEtBTGlDLENBQXJCLENBQWhCO0FBUUEsU0FBS3pCLFNBQUwsR0FBaUIsS0FBS1EsUUFBTCxDQUFja0IsTUFBL0I7QUFFQSxTQUFLcEIsY0FBTCxHQUFzQixJQUFJcUIsaUJBQUosRUFBdEIsQ0FYVyxDQVcyQjtBQUN6Qzs7OztVQUVEQyxTQUFBLGdCQUFRQyxFQUFSLEVBQVk7QUFDUixTQUFLcEMsZUFBTCxHQUF1Qm9DLEVBQXZCO0FBQ0EsU0FBS0MsbUJBQUwsR0FBMkIsS0FBS2pDLG9CQUFoQztBQUNBLFFBQUlrQyxVQUFVLEdBQUcsQ0FBakI7O0FBQ0EseUJBQWdCRixFQUFFLENBQUNHLE1BQW5CLGtIQUEyQjtBQUFBOztBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7O0FBQUEsVUFBaEJDLENBQWdCO0FBQ3ZCRixNQUFBQSxVQUFVLElBQUlFLENBQUMsQ0FBQ0MsV0FBRixDQUFjTCxFQUFkLENBQWQ7QUFDSDs7QUFDRCxTQUFLTSxRQUFMLENBQWNDLFFBQWQsR0FBeUIsQ0FBekI7QUFDQSxTQUFLbkMsU0FBTCxHQUFpQnpELElBQUksQ0FBQzZGLElBQUwsQ0FBVVIsRUFBRSxDQUFDUyxhQUFILENBQWlCQyxNQUFqQixLQUE0QixLQUFLSixRQUFMLENBQWNJLE1BQWQsRUFBNUIsR0FBcUQsRUFBckQsSUFBMkRWLEVBQUUsQ0FBQ1csWUFBSCxDQUFnQkQsTUFBaEIsS0FBMkJWLEVBQUUsQ0FBQ1ksUUFBOUIsR0FBeUNWLFVBQXBHLENBQVYsQ0FBakI7QUFDQSxTQUFLMUIsY0FBTCxHQUFzQixJQUFJcUMsZ0JBQUosQ0FBUztBQUFBLGFBQU0sSUFBSWhGLFlBQUosQ0FBaUIsRUFBakIsQ0FBTjtBQUFBLEtBQVQsRUFBcUNsQixJQUFJLENBQUM2RixJQUFMLENBQVVSLEVBQUUsQ0FBQ1csWUFBSCxDQUFnQkQsTUFBaEIsS0FBMkJWLEVBQUUsQ0FBQ1ksUUFBeEMsQ0FBckMsQ0FBdEI7O0FBQ0EsUUFBSSxLQUFLbkQsT0FBVCxFQUFrQjtBQUNkLFdBQUtxRCxNQUFMLEdBQWMsS0FBS3JELE9BQW5COztBQUNBLFdBQUtzRCxlQUFMO0FBQ0g7QUFDSjs7VUFFREMsV0FBQSxvQkFBWSxDQUNYOztVQUVEQyxZQUFBLHFCQUFhLENBQ1o7O1VBRURDLFVBQUEsbUJBQVc7QUFDUCxRQUFJLEtBQUsxQyxjQUFULEVBQXlCO0FBQ3JCLFdBQUtBLGNBQUwsQ0FBb0J2QixLQUFwQixDQUEwQixVQUFDa0UsR0FBRCxFQUFTO0FBQUVBLFFBQUFBLEdBQUcsQ0FBQ2xGLGFBQUosQ0FBa0JLLE1BQWxCLEdBQTJCLENBQTNCO0FBQStCLE9BQXBFOztBQUNBLFdBQUtrQyxjQUFMLEdBQXNCLElBQXRCO0FBQ0g7QUFDSjs7VUFFRHZCLFFBQUEsaUJBQVM7QUFDTCxRQUFJLEtBQUs2RCxNQUFULEVBQWlCO0FBQ2IsVUFBTU0sU0FBUyxHQUFHLEtBQUszQyxjQUFMLENBQW9CNEMsTUFBcEIsRUFBbEI7O0FBQ0EsVUFBSUMsS0FBSyxHQUFHRixTQUFTLENBQUNHLElBQVYsRUFBWjs7QUFDQSxhQUFPLENBQUNELEtBQUssQ0FBQ0UsSUFBZCxFQUFvQjtBQUNoQkYsUUFBQUEsS0FBSyxDQUFDRyxLQUFOLENBQVl4RSxLQUFaO0FBQ0FxRSxRQUFBQSxLQUFLLEdBQUdGLFNBQVMsQ0FBQ0csSUFBVixFQUFSO0FBQ0g7O0FBQ0QsV0FBSzlDLGNBQUwsQ0FBb0J4QixLQUFwQjs7QUFDQSxXQUFLeUUsaUJBQUw7QUFDSDtBQUNKOztVQUVEL0QsbUJBQUEsNEJBQW9CO0FBQ2hCLFFBQUlnRSxLQUFLLEdBQUcsS0FBSy9ELGVBQUwsQ0FBcUJDLFVBQXJCLENBQWdDK0QsTUFBNUM7O0FBRUEsUUFBSUQsS0FBSixFQUFXO0FBQ1BBLE1BQUFBLEtBQUssQ0FBQ0UsZUFBTixDQUFzQixLQUFLbEQsUUFBM0IsRUFBcUMsS0FBS1AsU0FBMUM7QUFFQSxVQUFJMEQsT0FBTyxHQUFHSCxLQUFLLENBQUNJLFNBQU4sQ0FBZ0IsQ0FBaEIsQ0FBZDtBQUNBLFdBQUtuRCxNQUFMLEdBQWNrRCxPQUFPLENBQUNFLFFBQVIsRUFBZDtBQUNBLFdBQUtuRCxTQUFMLEdBQWlCaUQsT0FBTyxDQUFDRSxRQUFSLENBQWlCQyxXQUFqQixDQUFqQjtBQUNBLFdBQUtuRCxRQUFMLEdBQWdCZ0QsT0FBTyxDQUFDSSxLQUF4QjtBQUNIO0FBQ0o7O1VBRURuQixrQkFBQSwyQkFBbUI7QUFDZixRQUFJLEtBQUtuRCxlQUFULEVBQTBCO0FBQ3RCLFVBQU11RSxHQUFHLEdBQUcsS0FBS3ZFLGVBQUwsQ0FBcUJ3RSxhQUFqQzs7QUFDQSxVQUFJRCxHQUFKLEVBQVM7QUFDTCxhQUFLbEQsU0FBTCxHQUFpQmtELEdBQWpCO0FBQ0gsT0FGRCxNQUVPO0FBQ0gsYUFBS2xELFNBQUwsR0FBaUIsS0FBS3JCLGVBQUwsQ0FBcUJDLFVBQXJCLENBQWdDd0UsZ0JBQWpEO0FBQ0g7QUFDSjtBQUNKOztVQUVEQyxTQUFBLGtCQUFVO0FBQ04sU0FBS2pFLGNBQUwsR0FBc0IsS0FBS2lDLFFBQUwsQ0FBY2lDLFFBQWQsQ0FBdUIsS0FBSzNFLGVBQUwsQ0FBcUI0RSxLQUE1QyxFQUFtRCxDQUFuRCxDQUF0Qjs7QUFDQSxRQUFJLEtBQUtDLEtBQUwsS0FBZW5GLFlBQU1vRixLQUFyQixJQUE4QixLQUFLOUUsZUFBTCxDQUFxQitFLGdCQUFyQixLQUEwQ3JGLFlBQU1zRixLQUFsRixFQUF5RjtBQUNyRixXQUFLN0QsY0FBTCxHQUFzQixJQUF0Qjs7QUFDQSxXQUFLbkIsZUFBTCxDQUFxQmlGLElBQXJCLENBQTBCQyxjQUExQixDQUF5QzFILFdBQXpDOztBQUNBLFdBQUt3QyxlQUFMLENBQXFCaUYsSUFBckIsQ0FBMEJFLGdCQUExQixDQUEyQzdILFVBQTNDO0FBQ0gsS0FKRCxNQUlPO0FBQ0gsV0FBSzZELGNBQUwsR0FBc0IsS0FBdEI7QUFDSDtBQUNKOztVQUVEaUUsVUFBQSxpQkFBU25HLENBQVQsRUFBWW9HLFFBQVosRUFBc0I7QUFDbEIsUUFBSSxDQUFDLEtBQUt6RSxjQUFWLEVBQTBCO0FBQ3RCO0FBQ0g7O0FBQ0QsUUFBSThDLEtBQUssR0FBRyxLQUFLN0MsY0FBTCxDQUFvQnlFLEdBQXBCLENBQXdCckcsQ0FBeEIsQ0FBWjs7QUFDQSxRQUFJLENBQUN5RSxLQUFMLEVBQVk7QUFDUkEsTUFBQUEsS0FBSyxHQUFHLEtBQUs5QyxjQUFMLENBQW9CMkUsS0FBcEIsRUFBUjs7QUFDQSxXQUFLMUUsY0FBTCxDQUFvQjJFLEdBQXBCLENBQXdCdkcsQ0FBeEIsRUFBMkJ5RSxLQUEzQjs7QUFDQTtBQUNIOztBQUNELFFBQUkrQixPQUFPLEdBQUcvQixLQUFLLENBQUNsRixVQUFOLENBQWlCa0YsS0FBSyxDQUFDdEYsR0FBTixHQUFZLENBQTdCLENBQWQ7O0FBQ0EsUUFBSSxLQUFLK0MsY0FBVCxFQUF5QjtBQUNyQnVFLHVCQUFLQyxhQUFMLENBQW1CakksVUFBbkIsRUFBK0J1QixDQUFDLENBQUMvQixRQUFqQyxFQUEyQ00sV0FBM0M7QUFDSCxLQUZELE1BRU87QUFDSGtJLHVCQUFLRSxJQUFMLENBQVVsSSxVQUFWLEVBQXNCdUIsQ0FBQyxDQUFDL0IsUUFBeEI7QUFDSDs7QUFDRCxRQUFJdUksT0FBSixFQUFhO0FBQ1QvQixNQUFBQSxLQUFLLENBQUM1RSxjQUFOLENBQXFCLElBQXJCLEVBQTJCLEtBQUsrRyxtQkFBaEMsRUFBcUQ1RyxDQUFyRCxFQUF3RG9HLFFBQXhEOztBQUNBLFVBQUlLLGlCQUFLSSxlQUFMLENBQXFCTCxPQUFPLENBQUN2SSxRQUE3QixFQUF1Q1EsVUFBdkMsSUFBcUQsS0FBSzJDLG1CQUE5RCxFQUFtRjtBQUMvRTtBQUNIO0FBQ0o7O0FBQ0RvRixJQUFBQSxPQUFPLEdBQUcvQixLQUFLLENBQUMvRSxVQUFOLEVBQVY7O0FBQ0EsUUFBSSxDQUFDOEcsT0FBTCxFQUFjO0FBQ1Y7QUFDSDs7QUFDREMscUJBQUtFLElBQUwsQ0FBVUgsT0FBTyxDQUFDdkksUUFBbEIsRUFBNEJRLFVBQTVCOztBQUNBK0gsSUFBQUEsT0FBTyxDQUFDMUgsUUFBUixHQUFtQixDQUFuQjs7QUFDQSxRQUFJLEtBQUtnSSxpQkFBVCxFQUE0QjtBQUN4Qk4sTUFBQUEsT0FBTyxDQUFDekgsS0FBUixHQUFnQmlCLENBQUMsQ0FBQytHLElBQUYsQ0FBT0MsQ0FBUCxHQUFXLEtBQUtDLFVBQUwsQ0FBZ0J2QixRQUFoQixDQUF5QixDQUF6QixFQUE0QixDQUE1QixDQUEzQjtBQUNILEtBRkQsTUFFTztBQUNIYyxNQUFBQSxPQUFPLENBQUN6SCxLQUFSLEdBQWdCLEtBQUtrSSxVQUFMLENBQWdCdkIsUUFBaEIsQ0FBeUIsQ0FBekIsRUFBNEIsQ0FBNUIsQ0FBaEI7QUFDSDs7QUFDRCxRQUFNd0IsUUFBUSxHQUFHekMsS0FBSyxDQUFDdEUsS0FBTixFQUFqQjs7QUFDQSxRQUFJK0csUUFBUSxLQUFLLENBQWpCLEVBQW9CO0FBQ2hCLFVBQU1DLGVBQWUsR0FBRzFDLEtBQUssQ0FBQ2xGLFVBQU4sQ0FBaUJrRixLQUFLLENBQUN0RixHQUFOLEdBQVksQ0FBN0IsQ0FBeEI7O0FBQ0FzSCx1QkFBS1csUUFBTCxDQUFjRCxlQUFlLENBQUMvSSxRQUE5QixFQUF3Q29JLE9BQU8sQ0FBQ3ZJLFFBQWhELEVBQTBEa0osZUFBZSxDQUFDbEosUUFBMUU7QUFDSCxLQUhELE1BR08sSUFBSWlKLFFBQVEsR0FBRyxDQUFmLEVBQWtCO0FBQ3JCLFVBQU1DLGdCQUFlLEdBQUcxQyxLQUFLLENBQUNsRixVQUFOLENBQWlCa0YsS0FBSyxDQUFDdEYsR0FBTixHQUFZLENBQTdCLENBQXhCOztBQUNBLFVBQU1rSSxjQUFjLEdBQUc1QyxLQUFLLENBQUNsRixVQUFOLENBQWlCa0YsS0FBSyxDQUFDdEYsR0FBTixHQUFZLENBQTdCLENBQXZCOztBQUNBc0gsdUJBQUtXLFFBQUwsQ0FBYzNJLFVBQWQsRUFBMEI0SSxjQUFjLENBQUNwSixRQUF6QyxFQUFtRGtKLGdCQUFlLENBQUNsSixRQUFuRTs7QUFDQXdJLHVCQUFLVyxRQUFMLENBQWMxSSxZQUFkLEVBQTRCOEgsT0FBTyxDQUFDdkksUUFBcEMsRUFBOENrSixnQkFBZSxDQUFDbEosUUFBOUQ7O0FBQ0F3SSx1QkFBS1csUUFBTCxDQUFjRCxnQkFBZSxDQUFDL0ksUUFBOUIsRUFBd0NNLFlBQXhDLEVBQXNERCxVQUF0RDs7QUFDQSxVQUFJZ0ksaUJBQUthLE1BQUwsQ0FBWXBKLEVBQUUsQ0FBQ3VJLElBQUgsQ0FBUWMsSUFBcEIsRUFBMEJKLGdCQUFlLENBQUMvSSxRQUExQyxDQUFKLEVBQXlEO0FBQ3JEcUkseUJBQUtFLElBQUwsQ0FBVVEsZ0JBQWUsQ0FBQy9JLFFBQTFCLEVBQW9DSyxVQUFwQztBQUNIO0FBQ0o7O0FBQ0QsUUFBSSxLQUFLK0ksaUJBQVQsRUFBNEI7QUFDeEJoQixNQUFBQSxPQUFPLENBQUM1SCxLQUFSLENBQWMySCxHQUFkLENBQWtCdkcsQ0FBQyxDQUFDcEIsS0FBcEI7QUFDSCxLQUZELE1BRU87QUFDSDRILE1BQUFBLE9BQU8sQ0FBQzVILEtBQVIsQ0FBYzJILEdBQWQsQ0FBa0IsS0FBS2tCLGFBQUwsQ0FBbUIvQixRQUFuQixDQUE0QixDQUE1QixFQUErQixDQUEvQixDQUFsQjtBQUNIO0FBQ0o7O1VBRURrQixzQkFBQSw2QkFBcUJuQyxLQUFyQixFQUE0QmlELFFBQTVCLEVBQXNDMUgsQ0FBdEMsRUFBeUNDLEVBQXpDLEVBQTZDO0FBQ3pDeUgsSUFBQUEsUUFBUSxDQUFDNUksUUFBVCxJQUFxQm1CLEVBQXJCOztBQUNBLFFBQUl3RSxLQUFLLENBQUMrQyxpQkFBVixFQUE2QjtBQUN6QkUsTUFBQUEsUUFBUSxDQUFDOUksS0FBVCxDQUFlMkgsR0FBZixDQUFtQnZHLENBQUMsQ0FBQ3BCLEtBQXJCO0FBQ0E4SSxNQUFBQSxRQUFRLENBQUM5SSxLQUFULENBQWUrSSxRQUFmLENBQXdCbEQsS0FBSyxDQUFDZ0QsYUFBTixDQUFvQi9CLFFBQXBCLENBQTZCLE1BQU0xRixDQUFDLENBQUM0SCxpQkFBRixHQUFzQjVILENBQUMsQ0FBQzRELGFBQTNELEVBQTBFLENBQTFFLENBQXhCO0FBQ0gsS0FIRCxNQUdPO0FBQ0g4RCxNQUFBQSxRQUFRLENBQUM5SSxLQUFULENBQWUySCxHQUFmLENBQW1COUIsS0FBSyxDQUFDZ0QsYUFBTixDQUFvQi9CLFFBQXBCLENBQTZCLE1BQU0xRixDQUFDLENBQUM0SCxpQkFBRixHQUFzQjVILENBQUMsQ0FBQzRELGFBQTNELEVBQTBFLENBQTFFLENBQW5CO0FBQ0g7O0FBQ0QsUUFBSWEsS0FBSyxDQUFDcUMsaUJBQVYsRUFBNkI7QUFDekJZLE1BQUFBLFFBQVEsQ0FBQzNJLEtBQVQsR0FBaUJpQixDQUFDLENBQUMrRyxJQUFGLENBQU9DLENBQVAsR0FBV3ZDLEtBQUssQ0FBQ3dDLFVBQU4sQ0FBaUJ2QixRQUFqQixDQUEwQmdDLFFBQVEsQ0FBQzVJLFFBQVQsR0FBb0IyRixLQUFLLENBQUNqRCxjQUFwRCxFQUFvRSxDQUFwRSxDQUE1QjtBQUNILEtBRkQsTUFFTztBQUNIa0csTUFBQUEsUUFBUSxDQUFDM0ksS0FBVCxHQUFpQjBGLEtBQUssQ0FBQ3dDLFVBQU4sQ0FBaUJ2QixRQUFqQixDQUEwQmdDLFFBQVEsQ0FBQzVJLFFBQVQsR0FBb0IyRixLQUFLLENBQUNqRCxjQUFwRCxFQUFvRSxDQUFwRSxDQUFqQjtBQUNIOztBQUNELFdBQU9rRyxRQUFRLENBQUM1SSxRQUFULEdBQW9CMkYsS0FBSyxDQUFDakQsY0FBakM7QUFDSDs7VUFFRHFHLGlCQUFBLHdCQUFnQjdILENBQWhCLEVBQW1CO0FBQ2YsUUFBTXlFLEtBQUssR0FBRyxLQUFLN0MsY0FBTCxDQUFvQnlFLEdBQXBCLENBQXdCckcsQ0FBeEIsQ0FBZDs7QUFDQSxRQUFJeUUsS0FBSyxJQUFJLEtBQUs5QyxjQUFsQixFQUFrQztBQUM5QjhDLE1BQUFBLEtBQUssQ0FBQ3JFLEtBQU47O0FBQ0EsV0FBS3VCLGNBQUwsQ0FBb0JtRyxJQUFwQixDQUF5QnJELEtBQXpCOztBQUNBLFdBQUs3QyxjQUFMLFdBQTJCNUIsQ0FBM0I7QUFDSDtBQUNKOztVQUVENkUsb0JBQUEsNkJBQXFCO0FBQ2pCLFNBQUtwRCxRQUFMLEdBQWdCLENBQWhCO0FBQ0EsU0FBS0MsUUFBTCxHQUFnQixDQUFoQjs7QUFFQSwwQkFBZ0IsS0FBS0UsY0FBTCxDQUFvQm1HLElBQXBCLEVBQWhCLHlIQUE0QztBQUFBOztBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7O0FBQUEsVUFBakMvSCxDQUFpQzs7QUFDeEMsVUFBTWdJLFFBQVEsR0FBRyxLQUFLcEcsY0FBTCxDQUFvQnlFLEdBQXBCLENBQXdCckcsQ0FBeEIsQ0FBakI7O0FBQ0EsVUFBSWdJLFFBQVEsQ0FBQzlJLEtBQVQsS0FBbUIsQ0FBQyxDQUF4QixFQUEyQjtBQUN2QjtBQUNIOztBQUNELFVBQU0rSSxXQUFXLEdBQUcsS0FBS3hHLFFBQUwsR0FBZ0IsQ0FBaEIsR0FBb0IsS0FBS0gsU0FBN0M7QUFDQSxVQUFNbkMsR0FBRyxHQUFHNkksUUFBUSxDQUFDOUksS0FBVCxJQUFrQjhJLFFBQVEsQ0FBQzdJLEdBQTNCLEdBQWlDNkksUUFBUSxDQUFDN0ksR0FBVCxHQUFlNkksUUFBUSxDQUFDNUksYUFBVCxDQUF1QkssTUFBdkUsR0FBZ0Z1SSxRQUFRLENBQUM3SSxHQUFyRztBQUNBLFVBQU0rSCxRQUFRLEdBQUcvSCxHQUFHLEdBQUc2SSxRQUFRLENBQUM5SSxLQUFoQyxDQVB3QyxDQVF4Qzs7QUFDQSxVQUFNZ0osWUFBWSxHQUFHLElBQUtoQjtBQUFTO0FBQW5DO0FBQ0EsVUFBTWlCLFdBQVcsR0FBR0gsUUFBUSxDQUFDNUksYUFBVCxDQUF1QjRJLFFBQVEsQ0FBQzlJLEtBQWhDLENBQXBCOztBQUNBLFdBQUtrSixpQkFBTCxDQUF1QkQsV0FBdkIsRUFBb0MsS0FBS0UsY0FBTCxDQUFvQjNDLFFBQXBCLENBQTZCLENBQTdCLEVBQWdDLENBQWhDLENBQXBDLEVBQXdFdUMsV0FBeEUsRUFBcUYsQ0FBckYsRUFBd0YsQ0FBeEYsRUFBMkZySyxtQkFBM0Y7O0FBQ0EsV0FBSyxJQUFJc0MsQ0FBQyxHQUFHOEgsUUFBUSxDQUFDOUksS0FBVCxHQUFpQixDQUE5QixFQUFpQ2dCLENBQUMsR0FBR2YsR0FBckMsRUFBMENlLENBQUMsRUFBM0MsRUFBK0M7QUFDM0MsWUFBTW9JLE1BQU0sR0FBR04sUUFBUSxDQUFDNUksYUFBVCxDQUF1QmMsQ0FBQyxHQUFHOEgsUUFBUSxDQUFDNUksYUFBVCxDQUF1QkssTUFBbEQsQ0FBZjtBQUNBLFlBQU04SSxDQUFDLEdBQUdySSxDQUFDLEdBQUc4SCxRQUFRLENBQUM5SSxLQUF2Qjs7QUFDQSxhQUFLa0osaUJBQUwsQ0FBdUJFLE1BQXZCLEVBQStCLEtBQUtELGNBQUwsQ0FBb0IzQyxRQUFwQixDQUE2QixJQUFJNkMsQ0FBQyxHQUFHckIsUUFBckMsRUFBK0MsQ0FBL0MsQ0FBL0IsRUFBa0ZlLFdBQWxGLEVBQStGLElBQUlNLENBQUMsR0FBR0wsWUFBdkcsRUFBcUhLLENBQXJILEVBQXdINUssa0JBQWtCLEdBQUdDLG1CQUE3STtBQUNIOztBQUNELFVBQUksS0FBS3NFLGNBQVQsRUFBeUI7QUFDckJ1RSx5QkFBS0MsYUFBTCxDQUFtQjFJLGNBQWMsQ0FBQ0MsUUFBbEMsRUFBNEMrQixDQUFDLENBQUMvQixRQUE5QyxFQUF3RE0sV0FBeEQ7QUFDSCxPQUZELE1BRU87QUFDSGtJLHlCQUFLRSxJQUFMLENBQVUzSSxjQUFjLENBQUNDLFFBQXpCLEVBQW1DK0IsQ0FBQyxDQUFDL0IsUUFBckM7QUFDSDs7QUFDRCxVQUFJaUosUUFBUSxLQUFLLENBQWIsSUFBa0JBLFFBQVEsS0FBSyxDQUFuQyxFQUFzQztBQUNsQyxZQUFNQyxlQUFlLEdBQUdhLFFBQVEsQ0FBQ3pJLFVBQVQsQ0FBb0J5SSxRQUFRLENBQUM3SSxHQUFULEdBQWUsQ0FBbkMsQ0FBeEI7O0FBQ0FzSCx5QkFBS1csUUFBTCxDQUFjRCxlQUFlLENBQUMvSSxRQUE5QixFQUF3Q0osY0FBYyxDQUFDQyxRQUF2RCxFQUFpRWtKLGVBQWUsQ0FBQ2xKLFFBQWpGOztBQUNBLGFBQUs4RCxNQUFMLENBQVksS0FBS04sUUFBTCxHQUFnQixLQUFLSCxTQUFMLEdBQWlCLENBQWpDLEdBQXFDLENBQWpELElBQXNENkYsZUFBZSxDQUFDL0ksUUFBaEIsQ0FBeUI0SSxDQUEvRTtBQUNBLGFBQUtqRixNQUFMLENBQVksS0FBS04sUUFBTCxHQUFnQixLQUFLSCxTQUFMLEdBQWlCLENBQWpDLEdBQXFDLENBQWpELElBQXNENkYsZUFBZSxDQUFDL0ksUUFBaEIsQ0FBeUJvSyxDQUEvRTtBQUNBLGFBQUt6RyxNQUFMLENBQVksS0FBS04sUUFBTCxHQUFnQixLQUFLSCxTQUFMLEdBQWlCLENBQWpDLEdBQXFDLENBQWpELElBQXNENkYsZUFBZSxDQUFDL0ksUUFBaEIsQ0FBeUJxSyxDQUEvRTtBQUNBLGFBQUsxRyxNQUFMLENBQVksS0FBS04sUUFBTCxHQUFnQixDQUE1QixJQUFpQzBGLGVBQWUsQ0FBQy9JLFFBQWhCLENBQXlCNEksQ0FBMUQ7QUFDQSxhQUFLakYsTUFBTCxDQUFZLEtBQUtOLFFBQUwsR0FBZ0IsQ0FBNUIsSUFBaUMwRixlQUFlLENBQUMvSSxRQUFoQixDQUF5Qm9LLENBQTFEO0FBQ0EsYUFBS3pHLE1BQUwsQ0FBWSxLQUFLTixRQUFMLEdBQWdCLENBQTVCLElBQWlDMEYsZUFBZSxDQUFDL0ksUUFBaEIsQ0FBeUJxSyxDQUExRDs7QUFDQWhDLHlCQUFLVyxRQUFMLENBQWNwSixjQUFjLENBQUNJLFFBQTdCLEVBQXVDSixjQUFjLENBQUNDLFFBQXRELEVBQWdFa0osZUFBZSxDQUFDbEosUUFBaEY7O0FBQ0EsYUFBS3lLLHNCQUFMLENBQTRCMUssY0FBNUIsRUFBNENtSixlQUE1QztBQUNILE9BWEQsTUFXTyxJQUFJRCxRQUFRLEdBQUcsQ0FBZixFQUFrQjtBQUNyQixZQUFNQyxpQkFBZSxHQUFHYSxRQUFRLENBQUN6SSxVQUFULENBQW9CeUksUUFBUSxDQUFDN0ksR0FBVCxHQUFlLENBQW5DLENBQXhCOztBQUNBLFlBQU1rSSxjQUFjLEdBQUdXLFFBQVEsQ0FBQ3pJLFVBQVQsQ0FBb0J5SSxRQUFRLENBQUM3SSxHQUFULEdBQWUsQ0FBbkMsQ0FBdkI7O0FBQ0FzSCx5QkFBS1csUUFBTCxDQUFjM0ksVUFBZCxFQUEwQjRJLGNBQWMsQ0FBQ3BKLFFBQXpDLEVBQW1Ea0osaUJBQWUsQ0FBQ2xKLFFBQW5FOztBQUNBd0kseUJBQUtXLFFBQUwsQ0FBYzFJLFlBQWQsRUFBNEJWLGNBQWMsQ0FBQ0MsUUFBM0MsRUFBcURrSixpQkFBZSxDQUFDbEosUUFBckU7O0FBQ0F3SSx5QkFBSzFELFNBQUwsQ0FBZXRFLFVBQWYsRUFBMkJBLFVBQTNCOztBQUNBZ0kseUJBQUsxRCxTQUFMLENBQWVyRSxZQUFmLEVBQTZCQSxZQUE3Qjs7QUFDQStILHlCQUFLVyxRQUFMLENBQWNELGlCQUFlLENBQUMvSSxRQUE5QixFQUF3Q00sWUFBeEMsRUFBc0RELFVBQXREOztBQUNBZ0kseUJBQUsxRCxTQUFMLENBQWVvRSxpQkFBZSxDQUFDL0ksUUFBL0IsRUFBeUMrSSxpQkFBZSxDQUFDL0ksUUFBekQ7O0FBQ0EsYUFBS3NLLHNCQUFMLENBQTRCdkIsaUJBQTVCLEVBQTZDRSxjQUE3Qzs7QUFDQSxhQUFLNUYsUUFBTCxJQUFpQixLQUFLSCxTQUFMLEdBQWlCLENBQWpCLEdBQXFCLENBQXRDO0FBQ0EsYUFBS0ksUUFBTCxJQUFpQixDQUFqQixDQVhxQixDQVlyQjs7QUFDQSxhQUFLMEcsaUJBQUwsQ0FBdUJqQixpQkFBdkIsRUFBd0MsS0FBS2tCLGNBQUwsQ0FBb0IzQyxRQUFwQixDQUE2QndDLFlBQTdCLEVBQTJDLENBQTNDLENBQXhDLEVBQXVGRCxXQUF2RixFQUFvR0MsWUFBcEcsRUFBa0hoQixRQUFRLEdBQUcsQ0FBN0gsRUFBZ0l2SixrQkFBa0IsR0FBR0MsbUJBQXJKOztBQUNBNkkseUJBQUtXLFFBQUwsQ0FBY3BKLGNBQWMsQ0FBQ0ksUUFBN0IsRUFBdUNKLGNBQWMsQ0FBQ0MsUUFBdEQsRUFBZ0VrSixpQkFBZSxDQUFDbEosUUFBaEY7O0FBQ0F3SSx5QkFBSzFELFNBQUwsQ0FBZS9FLGNBQWMsQ0FBQ0ksUUFBOUIsRUFBd0NKLGNBQWMsQ0FBQ0ksUUFBdkQ7O0FBQ0EsYUFBS3NLLHNCQUFMLENBQTRCMUssY0FBNUIsRUFBNENtSixpQkFBNUM7QUFDSDs7QUFDRCxVQUFJLEtBQUtMLGlCQUFULEVBQTRCO0FBQ3hCOUksUUFBQUEsY0FBYyxDQUFDZSxLQUFmLEdBQXVCaUIsQ0FBQyxDQUFDK0csSUFBRixDQUFPQyxDQUFQLEdBQVcsS0FBS0MsVUFBTCxDQUFnQnZCLFFBQWhCLENBQXlCLENBQXpCLEVBQTRCLENBQTVCLENBQWxDO0FBQ0gsT0FGRCxNQUVPO0FBQ0gxSCxRQUFBQSxjQUFjLENBQUNlLEtBQWYsR0FBdUIsS0FBS2tJLFVBQUwsQ0FBZ0J2QixRQUFoQixDQUF5QixDQUF6QixFQUE0QixDQUE1QixDQUF2QjtBQUNIOztBQUNEMUgsTUFBQUEsY0FBYyxDQUFDWSxLQUFmLEdBQXVCb0IsQ0FBQyxDQUFDcEIsS0FBekI7O0FBRUEsVUFBSTZILGlCQUFLYSxNQUFMLENBQVl0SixjQUFjLENBQUNJLFFBQTNCLEVBQXFDRixFQUFFLENBQUN1SSxJQUFILENBQVFjLElBQTdDLENBQUosRUFBd0Q7QUFDcEQsYUFBSzdGLFFBQUwsSUFBaUIsQ0FBakI7QUFDSCxPQUZELE1BRU87QUFDSCxhQUFLMEcsaUJBQUwsQ0FBdUJwSyxjQUF2QixFQUF1QyxLQUFLcUssY0FBTCxDQUFvQjNDLFFBQXBCLENBQTZCLENBQTdCLEVBQWdDLENBQWhDLENBQXZDLEVBQTJFdUMsV0FBM0UsRUFBd0YsQ0FBeEYsRUFBMkZmLFFBQTNGLEVBQXFHdkosa0JBQXJHO0FBQ0g7QUFDSjs7QUFDRCxTQUFLZ0wsU0FBTCxDQUFlLEtBQUtqSCxRQUFwQjtBQUNIOztVQUVEMEcsb0JBQUEsMkJBQW1CSixRQUFuQixFQUE2QlksWUFBN0IsRUFBMkNYLFdBQTNDLEVBQXdEWSxTQUF4RCxFQUFtRUMsV0FBbkUsRUFBZ0ZDLFFBQWhGLEVBQTBGO0FBQ3RGLFNBQUtoSCxNQUFMLENBQVksS0FBS04sUUFBTCxFQUFaLElBQStCdUcsUUFBUSxDQUFDL0osUUFBVCxDQUFrQitJLENBQWpEO0FBQ0EsU0FBS2pGLE1BQUwsQ0FBWSxLQUFLTixRQUFMLEVBQVosSUFBK0J1RyxRQUFRLENBQUMvSixRQUFULENBQWtCdUssQ0FBakQ7QUFDQSxTQUFLekcsTUFBTCxDQUFZLEtBQUtOLFFBQUwsRUFBWixJQUErQnVHLFFBQVEsQ0FBQy9KLFFBQVQsQ0FBa0J3SyxDQUFqRDtBQUNBLFNBQUsxRyxNQUFMLENBQVksS0FBS04sUUFBTCxFQUFaLElBQStCLENBQS9CO0FBQ0EsU0FBS00sTUFBTCxDQUFZLEtBQUtOLFFBQUwsRUFBWixJQUErQnVHLFFBQVEsQ0FBQ2pKLEtBQXhDO0FBQ0EsU0FBS2dELE1BQUwsQ0FBWSxLQUFLTixRQUFMLEVBQVosSUFBK0JvSCxTQUEvQjtBQUNBLFNBQUs5RyxNQUFMLENBQVksS0FBS04sUUFBTCxFQUFaLElBQStCLENBQS9CLENBUHNGLENBUXRGO0FBQ0E7QUFDQTtBQUNBOztBQUNBLFNBQUtNLE1BQUwsQ0FBWSxLQUFLTixRQUFMLEVBQVosSUFBK0J1RyxRQUFRLENBQUM1SixRQUFULENBQWtCNEksQ0FBakQ7QUFDQSxTQUFLakYsTUFBTCxDQUFZLEtBQUtOLFFBQUwsRUFBWixJQUErQnVHLFFBQVEsQ0FBQzVKLFFBQVQsQ0FBa0JvSyxDQUFqRDtBQUNBLFNBQUt6RyxNQUFMLENBQVksS0FBS04sUUFBTCxFQUFaLElBQStCdUcsUUFBUSxDQUFDNUosUUFBVCxDQUFrQnFLLENBQWpEOztBQUNBOUosSUFBQUEsV0FBVyxDQUFDNEgsR0FBWixDQUFnQnlCLFFBQVEsQ0FBQ3BKLEtBQXpCOztBQUNBRCxJQUFBQSxXQUFXLENBQUNnSixRQUFaLENBQXFCaUIsWUFBckI7O0FBQ0EsU0FBSzVHLFNBQUwsQ0FBZSxLQUFLUCxRQUFMLEVBQWYsSUFBa0M5QyxXQUFXLENBQUNxSyxJQUE5QztBQUNBLFNBQUtqSCxNQUFMLENBQVksS0FBS04sUUFBTCxFQUFaLElBQStCdUcsUUFBUSxDQUFDL0osUUFBVCxDQUFrQitJLENBQWpEO0FBQ0EsU0FBS2pGLE1BQUwsQ0FBWSxLQUFLTixRQUFMLEVBQVosSUFBK0J1RyxRQUFRLENBQUMvSixRQUFULENBQWtCdUssQ0FBakQ7QUFDQSxTQUFLekcsTUFBTCxDQUFZLEtBQUtOLFFBQUwsRUFBWixJQUErQnVHLFFBQVEsQ0FBQy9KLFFBQVQsQ0FBa0J3SyxDQUFqRDtBQUNBLFNBQUsxRyxNQUFMLENBQVksS0FBS04sUUFBTCxFQUFaLElBQStCLENBQS9CO0FBQ0EsU0FBS00sTUFBTCxDQUFZLEtBQUtOLFFBQUwsRUFBWixJQUErQnVHLFFBQVEsQ0FBQ2pKLEtBQXhDO0FBQ0EsU0FBS2dELE1BQUwsQ0FBWSxLQUFLTixRQUFMLEVBQVosSUFBK0JvSCxTQUEvQjtBQUNBLFNBQUs5RyxNQUFMLENBQVksS0FBS04sUUFBTCxFQUFaLElBQStCLENBQS9CLENBeEJzRixDQXlCdEY7QUFDQTtBQUNBO0FBQ0E7O0FBQ0EsU0FBS00sTUFBTCxDQUFZLEtBQUtOLFFBQUwsRUFBWixJQUErQnVHLFFBQVEsQ0FBQzVKLFFBQVQsQ0FBa0I0SSxDQUFqRDtBQUNBLFNBQUtqRixNQUFMLENBQVksS0FBS04sUUFBTCxFQUFaLElBQStCdUcsUUFBUSxDQUFDNUosUUFBVCxDQUFrQm9LLENBQWpEO0FBQ0EsU0FBS3pHLE1BQUwsQ0FBWSxLQUFLTixRQUFMLEVBQVosSUFBK0J1RyxRQUFRLENBQUM1SixRQUFULENBQWtCcUssQ0FBakQ7QUFDQSxTQUFLekcsU0FBTCxDQUFlLEtBQUtQLFFBQUwsRUFBZixJQUFrQzlDLFdBQVcsQ0FBQ3FLLElBQTlDOztBQUNBLFFBQUlELFFBQVEsR0FBR3BMLGtCQUFmLEVBQW1DO0FBQy9CLFdBQUtzRSxRQUFMLENBQWMsS0FBS1AsUUFBTCxFQUFkLElBQWlDdUcsV0FBVyxHQUFHLElBQUlhLFdBQW5EO0FBQ0EsV0FBSzdHLFFBQUwsQ0FBYyxLQUFLUCxRQUFMLEVBQWQsSUFBaUN1RyxXQUFXLEdBQUcsSUFBSWEsV0FBbEIsR0FBZ0MsQ0FBakU7QUFDQSxXQUFLN0csUUFBTCxDQUFjLEtBQUtQLFFBQUwsRUFBZCxJQUFpQ3VHLFdBQVcsR0FBRyxJQUFJYSxXQUFsQixHQUFnQyxDQUFqRTtBQUNIOztBQUNELFFBQUlDLFFBQVEsR0FBR25MLG1CQUFmLEVBQW9DO0FBQ2hDLFdBQUtxRSxRQUFMLENBQWMsS0FBS1AsUUFBTCxFQUFkLElBQWlDdUcsV0FBVyxHQUFHLElBQUlhLFdBQW5EO0FBQ0EsV0FBSzdHLFFBQUwsQ0FBYyxLQUFLUCxRQUFMLEVBQWQsSUFBaUN1RyxXQUFXLEdBQUcsSUFBSWEsV0FBbEIsR0FBZ0MsQ0FBakU7QUFDQSxXQUFLN0csUUFBTCxDQUFjLEtBQUtQLFFBQUwsRUFBZCxJQUFpQ3VHLFdBQVcsR0FBRyxJQUFJYSxXQUFsQixHQUFnQyxDQUFqRTtBQUNIO0FBQ0o7O1VBRURILFlBQUEsbUJBQVd4SSxLQUFYLEVBQWtCO0FBQ2QsUUFBSSxLQUFLWSxlQUFMLElBQXdCLEtBQUtBLGVBQUwsQ0FBcUJDLFVBQWpELEVBQTZEO0FBQ3pELFdBQUtELGVBQUwsQ0FBcUJDLFVBQXJCLENBQWdDaUksUUFBaEMsQ0FBeUMsQ0FBekMsRUFBNEM5SSxLQUE1QyxFQUFtRCxJQUFuRCxFQUF5RCxJQUF6RDtBQUNIO0FBQ0o7O1VBRUR1SSx5QkFBQSxnQ0FBd0JRLFdBQXhCLEVBQXFDQyxXQUFyQyxFQUFrRDtBQUM5QyxRQUFJMUMsaUJBQUsyQyxHQUFMLENBQVNGLFdBQVcsQ0FBQzlLLFFBQXJCLEVBQStCK0ssV0FBVyxDQUFDL0ssUUFBM0MsSUFBdURQLG1CQUEzRCxFQUFnRjtBQUM1RXFMLE1BQUFBLFdBQVcsQ0FBQzVKLFNBQVosR0FBd0IsSUFBSTZKLFdBQVcsQ0FBQzdKLFNBQXhDO0FBQ0gsS0FGRCxNQUVPO0FBQ0g0SixNQUFBQSxXQUFXLENBQUM1SixTQUFaLEdBQXdCNkosV0FBVyxDQUFDN0osU0FBcEM7QUFDSDtBQUNKOzs7cUZBcGRBK0o7Ozs7O1dBQ1M7OzREQU9UQTs7Ozs7V0EyQk05SSxnQkFBVStJOzs7Ozs7O1dBVU4sSUFBSTlJLHNCQUFKOzt5RkFFVjZJOzs7OztXQUNzQjs7eUVBT3RCQSxtTUFVQUE7Ozs7O1dBQ1E1SSxZQUFNb0Y7O3VPQTBCZHdEOzs7OztXQUNvQjs7Ozs7OztXQVVQM0ksa0JBQVk2STs7c0ZBT3pCRjs7Ozs7V0FDbUI7Ozs7Ozs7V0FXUCxJQUFJN0ksc0JBQUo7O3VGQU9aNkk7Ozs7O1dBQ21COzs7Ozs7O1dBVUgsSUFBSTFJLHlCQUFKOzs7Ozs7O1dBVUQsSUFBSUEseUJBQUoiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBjY2NsYXNzLCBwcm9wZXJ0eSB9IGZyb20gJy4uLy4uLy4uL3BsYXRmb3JtL0NDQ2xhc3NEZWNvcmF0b3InO1xuaW1wb3J0IHsgVmVjMywgdG9SYWRpYW4sIENvbG9yfSBmcm9tICcuLi8uLi8uLi92YWx1ZS10eXBlcyc7XG5pbXBvcnQgZ2Z4IGZyb20gJy4uLy4uLy4uLy4uL3JlbmRlcmVyL2dmeCc7XG5pbXBvcnQgUG9vbCBmcm9tICcuLi8uLi8uLi8uLi9yZW5kZXJlci9tZW1vcC9wb29sJztcbmltcG9ydCBDdXJ2ZVJhbmdlIGZyb20gJy4uL2FuaW1hdG9yL2N1cnZlLXJhbmdlJztcbmltcG9ydCBHcmFkaWVudFJhbmdlIGZyb20gJy4uL2FuaW1hdG9yL2dyYWRpZW50LXJhbmdlJztcbmltcG9ydCB7IFNwYWNlLCBUZXh0dXJlTW9kZSwgVHJhaWxNb2RlIH0gZnJvbSAnLi4vZW51bSc7XG5pbXBvcnQgTWFwVXRpbHMgZnJvbSAnLi4vdXRpbHMnO1xuXG4vLyB0c2xpbnQ6ZGlzYWJsZTogbWF4LWxpbmUtbGVuZ3RoXG5jb25zdCBQUkVfVFJJQU5HTEVfSU5ERVggPSAxO1xuY29uc3QgTkVYVF9UUklBTkdMRV9JTkRFWCA9IDEgPDwgMjtcbmNvbnN0IERJUkVDVElPTl9USFJFU0hPTEQgPSBNYXRoLmNvcyh0b1JhZGlhbigxMDApKTtcblxuY29uc3QgX3RlbXBfdHJhaWxFbGUgPSB7IHBvc2l0aW9uOiBjYy52MygpLCB2ZWxvY2l0eTogY2MudjMoKSB9O1xuY29uc3QgX3RlbXBfcXVhdCA9IGNjLnF1YXQoKTtcbmNvbnN0IF90ZW1wX3hmb3JtID0gY2MubWF0NCgpO1xuY29uc3QgX3RlbXBfVmVjMyA9IGNjLnYzKCk7XG5jb25zdCBfdGVtcF9WZWMzXzEgPSBjYy52MygpO1xuY29uc3QgX3RlbXBfY29sb3IgPSBjYy5jb2xvcigpO1xuXG4vLyB2YXIgYmFyeWNlbnRyaWMgPSBbMSwgMCwgMCwgMCwgMSwgMCwgMCwgMCwgMV07IC8vIDx3aXJlZnJhbWUgZGVidWc+XG4vLyB2YXIgX2JjSWR4ID0gMDtcblxuXG5jbGFzcyBJVHJhaWxFbGVtZW50IHtcbiAgICBwb3NpdGlvbjtcbiAgICBsaWZldGltZTtcbiAgICB3aWR0aDtcbiAgICB2ZWxvY2l0eTtcbiAgICBjb2xvcjtcbn1cblxuLy8gdGhlIHZhbGlkIGVsZW1lbnQgaXMgaW4gW3N0YXJ0LGVuZCkgcmFuZ2UuaWYgc3RhcnQgZXF1YWxzIC0xLGl0IHJlcHJlc2VudHMgdGhlIGFycmF5IGlzIGVtcHR5LlxuY2xhc3MgVHJhaWxTZWdtZW50IHtcbiAgICBzdGFydDtcbiAgICBlbmQ7XG4gICAgdHJhaWxFbGVtZW50cyA9IFtdO1xuXG4gICAgY29uc3RydWN0b3IgKG1heFRyYWlsRWxlbWVudE51bSkge1xuICAgICAgICB0aGlzLnN0YXJ0ID0gLTE7XG4gICAgICAgIHRoaXMuZW5kID0gLTE7XG4gICAgICAgIHRoaXMudHJhaWxFbGVtZW50cyA9IFtdO1xuICAgICAgICB3aGlsZSAobWF4VHJhaWxFbGVtZW50TnVtLS0pIHtcbiAgICAgICAgICAgIHRoaXMudHJhaWxFbGVtZW50cy5wdXNoKHtcbiAgICAgICAgICAgICAgICBwb3NpdGlvbjogY2MudjMoKSxcbiAgICAgICAgICAgICAgICBsaWZldGltZTogMCxcbiAgICAgICAgICAgICAgICB3aWR0aDogMCxcbiAgICAgICAgICAgICAgICB2ZWxvY2l0eTogY2MudjMoKSxcbiAgICAgICAgICAgICAgICBkaXJlY3Rpb246IDAsXG4gICAgICAgICAgICAgICAgY29sb3I6IGNjLmNvbG9yKCksXG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIGdldEVsZW1lbnQgKGlkeCkge1xuICAgICAgICBpZiAodGhpcy5zdGFydCA9PT0gLTEpIHtcbiAgICAgICAgICAgIHJldHVybiBudWxsO1xuICAgICAgICB9XG4gICAgICAgIGlmIChpZHggPCAwKSB7XG4gICAgICAgICAgICBpZHggPSAoaWR4ICsgdGhpcy50cmFpbEVsZW1lbnRzLmxlbmd0aCkgJSB0aGlzLnRyYWlsRWxlbWVudHMubGVuZ3RoO1xuICAgICAgICB9XG4gICAgICAgIGlmIChpZHggPj0gdGhpcy50cmFpbEVsZW1lbnRzLmxlbmd0aCkge1xuICAgICAgICAgICAgaWR4ICU9IHRoaXMudHJhaWxFbGVtZW50cy5sZW5ndGg7XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHRoaXMudHJhaWxFbGVtZW50c1tpZHhdO1xuICAgIH1cblxuICAgIGFkZEVsZW1lbnQgKCkge1xuICAgICAgICBpZiAodGhpcy50cmFpbEVsZW1lbnRzLmxlbmd0aCA9PT0gMCkge1xuICAgICAgICAgICAgcmV0dXJuIG51bGw7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKHRoaXMuc3RhcnQgPT09IC0xKSB7XG4gICAgICAgICAgICB0aGlzLnN0YXJ0ID0gMDtcbiAgICAgICAgICAgIHRoaXMuZW5kID0gMTtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLnRyYWlsRWxlbWVudHNbMF07XG4gICAgICAgIH1cbiAgICAgICAgaWYgKHRoaXMuc3RhcnQgPT09IHRoaXMuZW5kKSB7XG4gICAgICAgICAgICB0aGlzLnRyYWlsRWxlbWVudHMuc3BsaWNlKHRoaXMuZW5kLCAwLCB7XG4gICAgICAgICAgICAgICAgcG9zaXRpb246IGNjLnYzKCksXG4gICAgICAgICAgICAgICAgbGlmZXRpbWU6IDAsXG4gICAgICAgICAgICAgICAgd2lkdGg6IDAsXG4gICAgICAgICAgICAgICAgdmVsb2NpdHk6IGNjLnYzKCksXG4gICAgICAgICAgICAgICAgZGlyZWN0aW9uOiAwLFxuICAgICAgICAgICAgICAgIGNvbG9yOiBjYy5jb2xvcigpLFxuICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICB0aGlzLnN0YXJ0Kys7XG4gICAgICAgICAgICB0aGlzLnN0YXJ0ICU9IHRoaXMudHJhaWxFbGVtZW50cy5sZW5ndGg7XG4gICAgICAgIH1cbiAgICAgICAgY29uc3QgbmV3RWxlTG9jID0gdGhpcy5lbmQrKztcbiAgICAgICAgdGhpcy5lbmQgJT0gdGhpcy50cmFpbEVsZW1lbnRzLmxlbmd0aDtcbiAgICAgICAgcmV0dXJuIHRoaXMudHJhaWxFbGVtZW50c1tuZXdFbGVMb2NdO1xuICAgIH1cblxuICAgIGl0ZXJhdGVFbGVtZW50ICh0YXJnZXQsIGYsIHAsIGR0KSB7XG4gICAgICAgIGNvbnN0IGVuZCA9IHRoaXMuc3RhcnQgPj0gdGhpcy5lbmQgPyB0aGlzLmVuZCArIHRoaXMudHJhaWxFbGVtZW50cy5sZW5ndGggOiB0aGlzLmVuZDtcbiAgICAgICAgZm9yIChsZXQgaSA9IHRoaXMuc3RhcnQ7IGkgPCBlbmQ7IGkrKykge1xuICAgICAgICAgICAgaWYgKGYodGFyZ2V0LCB0aGlzLnRyYWlsRWxlbWVudHNbaSAlIHRoaXMudHJhaWxFbGVtZW50cy5sZW5ndGhdLCBwLCBkdCkpIHtcbiAgICAgICAgICAgICAgICB0aGlzLnN0YXJ0Kys7XG4gICAgICAgICAgICAgICAgdGhpcy5zdGFydCAlPSB0aGlzLnRyYWlsRWxlbWVudHMubGVuZ3RoO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIGlmICh0aGlzLnN0YXJ0ID09PSBlbmQpIHtcbiAgICAgICAgICAgIHRoaXMuc3RhcnQgPSAtMTtcbiAgICAgICAgICAgIHRoaXMuZW5kID0gLTE7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICBjb3VudCAoKSB7XG4gICAgICAgIGlmICh0aGlzLnN0YXJ0IDwgdGhpcy5lbmQpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLmVuZCAtIHRoaXMuc3RhcnQ7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy50cmFpbEVsZW1lbnRzLmxlbmd0aCArIHRoaXMuZW5kIC0gdGhpcy5zdGFydDtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIGNsZWFyICgpIHtcbiAgICAgICAgdGhpcy5zdGFydCA9IC0xO1xuICAgICAgICB0aGlzLmVuZCA9IC0xO1xuICAgIH1cbn1cblxuLyoqXG4gKiAhI2VuIFRoZSB0cmFpbCBtb2R1bGUgb2YgM2QgcGFydGljbGUuXG4gKiAhI3poIDNEIOeykuWtkOaLluWwvuaooeWdl1xuICogQGNsYXNzIFRyYWlsTW9kdWxlXG4gKi9cbkBjY2NsYXNzKCdjYy5UcmFpbE1vZHVsZScpXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBUcmFpbE1vZHVsZSB7XG5cbiAgICBAcHJvcGVydHlcbiAgICBfZW5hYmxlID0gZmFsc2U7XG5cbiAgICAvKipcbiAgICAgKiAhI2VuIFRoZSBlbmFibGUgb2YgdHJhaWxNb2R1bGUuXG4gICAgICogISN6aCDmmK/lkKblkK/nlKhcbiAgICAgKiBAcHJvcGVydHkge0Jvb2xlYW59IGVuYWJsZVxuICAgICAqL1xuICAgIEBwcm9wZXJ0eVxuICAgIGdldCBlbmFibGUgKCkge1xuICAgICAgICByZXR1cm4gdGhpcy5fZW5hYmxlO1xuICAgIH1cblxuICAgIHNldCBlbmFibGUgKHZhbCkge1xuICAgICAgICBpZiAodmFsKSB7XG4gICAgICAgICAgICB0aGlzLl9jcmVhdGVUcmFpbERhdGEoKTtcbiAgICAgICAgfVxuXG4gICAgICAgIGlmICh2YWwgJiYgIXRoaXMuX2VuYWJsZSkge1xuICAgICAgICAgICAgdGhpcy5fZW5hYmxlID0gdmFsO1xuICAgICAgICAgICAgdGhpcy5fcGFydGljbGVTeXN0ZW0uX2Fzc2VtYmxlci5fdXBkYXRlVHJhaWxNYXRlcmlhbCgpO1xuICAgICAgICB9XG5cbiAgICAgICAgdGhpcy5fZW5hYmxlID0gdmFsO1xuICAgICAgICB0aGlzLl9wYXJ0aWNsZVN5c3RlbS5fYXNzZW1ibGVyLl91cGRhdGVUcmFpbEVuYWJsZSh0aGlzLl9lbmFibGUpO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqICEjZW4gU2V0cyBob3cgcGFydGljbGVzIGdlbmVyYXRlIHRyYWplY3Rvcmllcy5cbiAgICAgKiAhI3poIOiuvuWumueykuWtkOeUn+aIkOi9qOi/ueeahOaWueW8j+OAglxuICAgICAqIEBwcm9wZXJ0eSB7VHJhaWxNb2RlfSBtb2RlXG4gICAgICovXG4gICAgQHByb3BlcnR5KHtcbiAgICAgICAgdHlwZTogVHJhaWxNb2RlLFxuICAgIH0pXG4gICAgbW9kZSA9IFRyYWlsTW9kZS5QYXJ0aWNsZXM7XG5cbiAgICAvKipcbiAgICAgKiAhI2VuIExpZmUgY3ljbGUgb2YgdHJhamVjdG9yeS5cbiAgICAgKiAhI3poIOi9qOi/ueWtmOWcqOeahOeUn+WRveWRqOacn+OAglxuICAgICAqIEBwcm9wZXJ0eSB7Q3VydmVSYW5nZX0gbGlmZVRpbWVcbiAgICAgKi9cbiAgICBAcHJvcGVydHkoe1xuICAgICAgICB0eXBlOiBDdXJ2ZVJhbmdlLFxuICAgIH0pXG4gICAgbGlmZVRpbWUgPSBuZXcgQ3VydmVSYW5nZSgpO1xuXG4gICAgQHByb3BlcnR5XG4gICAgX21pblBhcnRpY2xlRGlzdGFuY2UgPSAwLjE7XG5cbiAgICAvKipcbiAgICAgKiAhI2VuIE1pbmltdW0gc3BhY2luZyBiZXR3ZWVuIGVhY2ggdHJhY2sgcGFydGljbGVcbiAgICAgKiAhI3poIOavj+S4qui9qOi/ueeykuWtkOS5i+mXtOeahOacgOWwj+mXtOi3neOAglxuICAgICAqIEBwcm9wZXJ0eSB7TnVtYmVyfSBtaW5QYXJ0aWNsZURpc3RhbmNlXG4gICAgICovXG4gICAgQHByb3BlcnR5XG4gICAgZ2V0IG1pblBhcnRpY2xlRGlzdGFuY2UgKCkge1xuICAgICAgICByZXR1cm4gdGhpcy5fbWluUGFydGljbGVEaXN0YW5jZTtcbiAgICB9XG5cbiAgICBzZXQgbWluUGFydGljbGVEaXN0YW5jZSAodmFsKSB7XG4gICAgICAgIHRoaXMuX21pblBhcnRpY2xlRGlzdGFuY2UgPSB2YWw7XG4gICAgICAgIHRoaXMuX21pblNxdWFyZWREaXN0YW5jZSA9IHZhbCAqIHZhbDtcbiAgICB9XG5cbiAgICBAcHJvcGVydHlcbiAgICBfc3BhY2UgPSBTcGFjZS5Xb3JsZDtcblxuICAgIC8qKlxuICAgICAqICEjZW4gVGhlIGNvb3JkaW5hdGUgc3lzdGVtIG9mIHRyYWplY3Rvcmllcy5cbiAgICAgKiAhI3poIOi9qOi/ueiuvuWumuaXtueahOWdkOagh+ezu+OAglxuICAgICAqIEBwcm9wZXJ0eSB7U3BhY2V9IHNwYWNlXG4gICAgICovXG4gICAgQHByb3BlcnR5KHtcbiAgICAgICAgdHlwZTogU3BhY2UsXG4gICAgfSlcbiAgICBnZXQgc3BhY2UgKCkge1xuICAgICAgICByZXR1cm4gdGhpcy5fc3BhY2U7XG4gICAgfVxuXG4gICAgc2V0IHNwYWNlICh2YWwpIHtcbiAgICAgICAgdGhpcy5fc3BhY2UgPSB2YWw7XG4gICAgICAgIGlmICh0aGlzLl9wYXJ0aWNsZVN5c3RlbSkge1xuICAgICAgICAgICAgdGhpcy5fcGFydGljbGVTeXN0ZW0uX2Fzc2VtYmxlci5fdXBkYXRlVHJhaWxNYXRlcmlhbCgpO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogISNlbiBXaGV0aGVyIHRoZSBwYXJ0aWNsZSBpdHNlbGYgZXhpc3RzLlxuICAgICAqICEjemgg57KS5a2Q5pys6Lqr5piv5ZCm5a2Y5Zyo44CCXG4gICAgICogQHByb3BlcnR5IHtCb29sZWFufSBleGlzdFdpdGhQYXJ0aWNsZXNcbiAgICAgKi9cbiAgICBAcHJvcGVydHlcbiAgICBleGlzdFdpdGhQYXJ0aWNsZXMgPSB0cnVlO1xuXG4gICAgLyoqXG4gICAgICogISNlbiBTZXQgdGhlIHRleHR1cmUgZmlsbCBtZXRob2RcbiAgICAgKiAhI3poIOiuvuWumue6ueeQhuWhq+WFheaWueW8j+OAglxuICAgICAqIEBwcm9wZXJ0eSB7VGV4dHVyZU1vZGV9IHRleHR1cmVNb2RlXG4gICAgICovXG4gICAgQHByb3BlcnR5KHtcbiAgICAgICAgdHlwZTogVGV4dHVyZU1vZGUsXG4gICAgfSlcbiAgICB0ZXh0dXJlTW9kZSA9IFRleHR1cmVNb2RlLlN0cmV0Y2g7XG5cbiAgICAvKipcbiAgICAgKiAhI2VuIFdoZXRoZXIgdG8gdXNlIHBhcnRpY2xlIHdpZHRoXG4gICAgICogISN6aCDmmK/lkKbkvb/nlKjnspLlrZDnmoTlrr3luqbjgIJcbiAgICAgKiBAcHJvcGVydHkge0Jvb2xlYW59IHdpZHRoRnJvbVBhcnRpY2xlXG4gICAgICovXG4gICAgQHByb3BlcnR5XG4gICAgd2lkdGhGcm9tUGFydGljbGUgPSB0cnVlO1xuXG5cbiAgICAvKipcbiAgICAgKiAhI2VuIEN1cnZlcyB0aGF0IGNvbnRyb2wgdHJhY2sgbGVuZ3RoXG4gICAgICogISN6aCDmjqfliLbovajov7nplb/luqbnmoTmm7Lnur/jgIJcbiAgICAgKiBAcHJvcGVydHkge0N1cnZlUmFuZ2V9IHdpZHRoUmF0aW9cbiAgICAgKi9cbiAgICBAcHJvcGVydHkoe1xuICAgICAgICB0eXBlOiBDdXJ2ZVJhbmdlLFxuICAgIH0pXG4gICAgd2lkdGhSYXRpbyA9IG5ldyBDdXJ2ZVJhbmdlKCk7XG5cbiAgICAvKipcbiAgICAgKiAhI2VuIFdoZXRoZXIgdG8gdXNlIHBhcnRpY2xlIGNvbG9yXG4gICAgICogISN6aCDmmK/lkKbkvb/nlKjnspLlrZDnmoTpopzoibLjgIJcbiAgICAgKiBAcHJvcGVydHkge0Jvb2xlYW59IGNvbG9yRnJvbVBhcnRpY2xlXG4gICAgICovXG4gICAgQHByb3BlcnR5XG4gICAgY29sb3JGcm9tUGFydGljbGUgPSBmYWxzZTtcblxuICAgIC8qKlxuICAgICAqICEjZW4gVGhlIGNvbG9yIG9mIHRyYWplY3Rvcmllcy5cbiAgICAgKiAhI3poIOi9qOi/ueeahOminOiJsuOAglxuICAgICAqIEBwcm9wZXJ0eSB7R3JhZGllbnRSYW5nZX0gY29sb3JPdmVyVHJhaWxcbiAgICAgKi9cbiAgICBAcHJvcGVydHkoe1xuICAgICAgICB0eXBlOiBHcmFkaWVudFJhbmdlLFxuICAgIH0pXG4gICAgY29sb3JPdmVyVHJhaWwgPSBuZXcgR3JhZGllbnRSYW5nZSgpO1xuXG4gICAgLyoqXG4gICAgICogISNlbiBUcmFqZWN0b3JpZXMgY29sb3Igb3ZlciB0aW1lLlxuICAgICAqICEjemgg6L2o6L+56ZqP5pe26Ze05Y+Y5YyW55qE6aKc6Imy44CCXG4gICAgICogQHByb3BlcnR5IHtHcmFkaWVudFJhbmdlfSBjb2xvck92ZXJ0aW1lXG4gICAgICovXG4gICAgQHByb3BlcnR5KHtcbiAgICAgICAgdHlwZTogR3JhZGllbnRSYW5nZSxcbiAgICB9KVxuICAgIGNvbG9yT3ZlcnRpbWUgPSBuZXcgR3JhZGllbnRSYW5nZSgpO1xuXG4gICAgX3BhcnRpY2xlU3lzdGVtID0gbnVsbDtcbiAgICBfbWluU3F1YXJlZERpc3RhbmNlID0gMDtcbiAgICBfdmVydFNpemUgPSAwO1xuICAgIF90cmFpbE51bSA9IDA7XG4gICAgX3RyYWlsTGlmZXRpbWUgPSAwO1xuICAgIHZiT2Zmc2V0ID0gMDtcbiAgICBpYk9mZnNldCA9IDA7XG4gICAgX3RyYWlsU2VnbWVudHMgPSBudWxsO1xuICAgIF9wYXJ0aWNsZVRyYWlsID0gbnVsbDtcbiAgICBfaWEgPSBudWxsO1xuICAgIF9nZnhWRm10ID0gbnVsbDtcbiAgICBfdmJGMzIgPSBudWxsO1xuICAgIF92YlVpbnQzMiA9IG51bGw7XG4gICAgX2lCdWZmZXIgPSBudWxsO1xuICAgIF9uZWVkVHJhbnNmb3JtID0gbnVsbDtcbiAgICBfZGVmYXVsdE1hdCA9IG51bGw7XG4gICAgX21hdGVyaWFsID0gbnVsbDtcblxuICAgIGNvbnN0cnVjdG9yICgpIHtcbiAgICAgICAgdGhpcy5fZ2Z4VkZtdCA9IG5ldyBnZnguVmVydGV4Rm9ybWF0KFtcbiAgICAgICAgICAgIHsgbmFtZTogZ2Z4LkFUVFJfUE9TSVRJT04sIHR5cGU6IGdmeC5BVFRSX1RZUEVfRkxPQVQzMiwgbnVtOiAzfSxcbiAgICAgICAgICAgIHsgbmFtZTogZ2Z4LkFUVFJfVEVYX0NPT1JELCB0eXBlOiBnZnguQVRUUl9UWVBFX0ZMT0FUMzIsIG51bTogNH0sXG4gICAgICAgICAgICAvL3sgbmFtZTogZ2Z4LkFUVFJfVEVYX0NPT1JEMiwgdHlwZTogZ2Z4LkFUVFJfVFlQRV9GTE9BVDMyLCBudW06IDMgfSwgLy8gPHdpcmVmcmFtZSBkZWJ1Zz5cbiAgICAgICAgICAgIHsgbmFtZTogZ2Z4LkFUVFJfVEVYX0NPT1JEMSwgdHlwZTogZ2Z4LkFUVFJfVFlQRV9GTE9BVDMyLCBudW06IDN9LFxuICAgICAgICAgICAgeyBuYW1lOiBnZnguQVRUUl9DT0xPUiwgdHlwZTogZ2Z4LkFUVFJfVFlQRV9VSU5UOCwgbnVtOiA0LCBub3JtYWxpemU6IHRydWUgfSxcbiAgICAgICAgXSk7XG5cbiAgICAgICAgdGhpcy5fdmVydFNpemUgPSB0aGlzLl9nZnhWRm10Ll9ieXRlcztcblxuICAgICAgICB0aGlzLl9wYXJ0aWNsZVRyYWlsID0gbmV3IE1hcFV0aWxzKCk7IC8vIE1hcDxQYXJ0aWNsZSwgVHJhaWxTZWdtZW50PigpO1xuICAgIH1cblxuICAgIG9uSW5pdCAocHMpIHtcbiAgICAgICAgdGhpcy5fcGFydGljbGVTeXN0ZW0gPSBwcztcbiAgICAgICAgdGhpcy5taW5QYXJ0aWNsZURpc3RhbmNlID0gdGhpcy5fbWluUGFydGljbGVEaXN0YW5jZTtcbiAgICAgICAgbGV0IGJ1cnN0Q291bnQgPSAwO1xuICAgICAgICBmb3IgKGNvbnN0IGIgb2YgcHMuYnVyc3RzKSB7XG4gICAgICAgICAgICBidXJzdENvdW50ICs9IGIuZ2V0TWF4Q291bnQocHMpO1xuICAgICAgICB9XG4gICAgICAgIHRoaXMubGlmZVRpbWUuY29uc3RhbnQgPSAxO1xuICAgICAgICB0aGlzLl90cmFpbE51bSA9IE1hdGguY2VpbChwcy5zdGFydExpZmV0aW1lLmdldE1heCgpICogdGhpcy5saWZlVGltZS5nZXRNYXgoKSAqIDYwICogKHBzLnJhdGVPdmVyVGltZS5nZXRNYXgoKSAqIHBzLmR1cmF0aW9uICsgYnVyc3RDb3VudCkpO1xuICAgICAgICB0aGlzLl90cmFpbFNlZ21lbnRzID0gbmV3IFBvb2woKCkgPT4gbmV3IFRyYWlsU2VnbWVudCgxMCksIE1hdGguY2VpbChwcy5yYXRlT3ZlclRpbWUuZ2V0TWF4KCkgKiBwcy5kdXJhdGlvbikpO1xuICAgICAgICBpZiAodGhpcy5fZW5hYmxlKSB7XG4gICAgICAgICAgICB0aGlzLmVuYWJsZSA9IHRoaXMuX2VuYWJsZTtcbiAgICAgICAgICAgIHRoaXMuX3VwZGF0ZU1hdGVyaWFsKCk7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICBvbkVuYWJsZSAoKSB7XG4gICAgfVxuXG4gICAgb25EaXNhYmxlICgpIHtcbiAgICB9XG5cbiAgICBkZXN0cm95ICgpIHtcbiAgICAgICAgaWYgKHRoaXMuX3RyYWlsU2VnbWVudHMpIHtcbiAgICAgICAgICAgIHRoaXMuX3RyYWlsU2VnbWVudHMuY2xlYXIoKG9iaikgPT4geyBvYmoudHJhaWxFbGVtZW50cy5sZW5ndGggPSAwOyB9KTtcbiAgICAgICAgICAgIHRoaXMuX3RyYWlsU2VnbWVudHMgPSBudWxsO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgY2xlYXIgKCkge1xuICAgICAgICBpZiAodGhpcy5lbmFibGUpIHtcbiAgICAgICAgICAgIGNvbnN0IHRyYWlsSXRlciA9IHRoaXMuX3BhcnRpY2xlVHJhaWwudmFsdWVzKCk7XG4gICAgICAgICAgICBsZXQgdHJhaWwgPSB0cmFpbEl0ZXIubmV4dCgpO1xuICAgICAgICAgICAgd2hpbGUgKCF0cmFpbC5kb25lKSB7XG4gICAgICAgICAgICAgICAgdHJhaWwudmFsdWUuY2xlYXIoKTtcbiAgICAgICAgICAgICAgICB0cmFpbCA9IHRyYWlsSXRlci5uZXh0KCk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICB0aGlzLl9wYXJ0aWNsZVRyYWlsLmNsZWFyKCk7XG4gICAgICAgICAgICB0aGlzLnVwZGF0ZVRyYWlsQnVmZmVyKCk7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICBfY3JlYXRlVHJhaWxEYXRhICgpIHtcbiAgICAgICAgbGV0IG1vZGVsID0gdGhpcy5fcGFydGljbGVTeXN0ZW0uX2Fzc2VtYmxlci5fbW9kZWw7XG4gICAgICAgIFxuICAgICAgICBpZiAobW9kZWwpIHtcbiAgICAgICAgICAgIG1vZGVsLmNyZWF0ZVRyYWlsRGF0YSh0aGlzLl9nZnhWRm10LCB0aGlzLl90cmFpbE51bSk7XG5cbiAgICAgICAgICAgIGxldCBzdWJEYXRhID0gbW9kZWwuX3N1YkRhdGFzWzFdO1xuICAgICAgICAgICAgdGhpcy5fdmJGMzIgPSBzdWJEYXRhLmdldFZEYXRhKCk7XG4gICAgICAgICAgICB0aGlzLl92YlVpbnQzMiA9IHN1YkRhdGEuZ2V0VkRhdGEoVWludDMyQXJyYXkpO1xuICAgICAgICAgICAgdGhpcy5faUJ1ZmZlciA9IHN1YkRhdGEuaURhdGE7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICBfdXBkYXRlTWF0ZXJpYWwgKCkge1xuICAgICAgICBpZiAodGhpcy5fcGFydGljbGVTeXN0ZW0pIHtcbiAgICAgICAgICAgIGNvbnN0IG1hdCA9IHRoaXMuX3BhcnRpY2xlU3lzdGVtLnRyYWlsTWF0ZXJpYWw7XG4gICAgICAgICAgICBpZiAobWF0KSB7XG4gICAgICAgICAgICAgICAgdGhpcy5fbWF0ZXJpYWwgPSBtYXQ7XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIHRoaXMuX21hdGVyaWFsID0gdGhpcy5fcGFydGljbGVTeXN0ZW0uX2Fzc2VtYmxlci5fZGVmYXVsdFRyYWlsTWF0O1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgfVxuXG4gICAgdXBkYXRlICgpIHtcbiAgICAgICAgdGhpcy5fdHJhaWxMaWZldGltZSA9IHRoaXMubGlmZVRpbWUuZXZhbHVhdGUodGhpcy5fcGFydGljbGVTeXN0ZW0uX3RpbWUsIDEpO1xuICAgICAgICBpZiAodGhpcy5zcGFjZSA9PT0gU3BhY2UuV29ybGQgJiYgdGhpcy5fcGFydGljbGVTeXN0ZW0uX3NpbXVsYXRpb25TcGFjZSA9PT0gU3BhY2UuTG9jYWwpIHtcbiAgICAgICAgICAgIHRoaXMuX25lZWRUcmFuc2Zvcm0gPSB0cnVlO1xuICAgICAgICAgICAgdGhpcy5fcGFydGljbGVTeXN0ZW0ubm9kZS5nZXRXb3JsZE1hdHJpeChfdGVtcF94Zm9ybSk7XG4gICAgICAgICAgICB0aGlzLl9wYXJ0aWNsZVN5c3RlbS5ub2RlLmdldFdvcmxkUm90YXRpb24oX3RlbXBfcXVhdCk7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICB0aGlzLl9uZWVkVHJhbnNmb3JtID0gZmFsc2U7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICBhbmltYXRlIChwLCBzY2FsZWREdCkge1xuICAgICAgICBpZiAoIXRoaXMuX3RyYWlsU2VnbWVudHMpIHtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuICAgICAgICBsZXQgdHJhaWwgPSB0aGlzLl9wYXJ0aWNsZVRyYWlsLmdldChwKTtcbiAgICAgICAgaWYgKCF0cmFpbCkge1xuICAgICAgICAgICAgdHJhaWwgPSB0aGlzLl90cmFpbFNlZ21lbnRzLmFsbG9jKCk7XG4gICAgICAgICAgICB0aGlzLl9wYXJ0aWNsZVRyYWlsLnNldChwLCB0cmFpbCk7XG4gICAgICAgICAgICByZXR1cm47XG4gICAgICAgIH1cbiAgICAgICAgbGV0IGxhc3RTZWcgPSB0cmFpbC5nZXRFbGVtZW50KHRyYWlsLmVuZCAtIDEpO1xuICAgICAgICBpZiAodGhpcy5fbmVlZFRyYW5zZm9ybSkge1xuICAgICAgICAgICAgVmVjMy50cmFuc2Zvcm1NYXQ0KF90ZW1wX1ZlYzMsIHAucG9zaXRpb24sIF90ZW1wX3hmb3JtKTtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIFZlYzMuY29weShfdGVtcF9WZWMzLCBwLnBvc2l0aW9uKTtcbiAgICAgICAgfVxuICAgICAgICBpZiAobGFzdFNlZykge1xuICAgICAgICAgICAgdHJhaWwuaXRlcmF0ZUVsZW1lbnQodGhpcywgdGhpcy5fdXBkYXRlVHJhaWxFbGVtZW50LCBwLCBzY2FsZWREdCk7XG4gICAgICAgICAgICBpZiAoVmVjMy5zcXVhcmVkRGlzdGFuY2UobGFzdFNlZy5wb3NpdGlvbiwgX3RlbXBfVmVjMykgPCB0aGlzLl9taW5TcXVhcmVkRGlzdGFuY2UpIHtcbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgbGFzdFNlZyA9IHRyYWlsLmFkZEVsZW1lbnQoKTtcbiAgICAgICAgaWYgKCFsYXN0U2VnKSB7XG4gICAgICAgICAgICByZXR1cm47XG4gICAgICAgIH1cbiAgICAgICAgVmVjMy5jb3B5KGxhc3RTZWcucG9zaXRpb24sIF90ZW1wX1ZlYzMpO1xuICAgICAgICBsYXN0U2VnLmxpZmV0aW1lID0gMDtcbiAgICAgICAgaWYgKHRoaXMud2lkdGhGcm9tUGFydGljbGUpIHtcbiAgICAgICAgICAgIGxhc3RTZWcud2lkdGggPSBwLnNpemUueCAqIHRoaXMud2lkdGhSYXRpby5ldmFsdWF0ZSgwLCAxKTtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIGxhc3RTZWcud2lkdGggPSB0aGlzLndpZHRoUmF0aW8uZXZhbHVhdGUoMCwgMSk7XG4gICAgICAgIH1cbiAgICAgICAgY29uc3QgdHJhaWxOdW0gPSB0cmFpbC5jb3VudCgpO1xuICAgICAgICBpZiAodHJhaWxOdW0gPT09IDIpIHtcbiAgICAgICAgICAgIGNvbnN0IGxhc3RTZWNvbmRUcmFpbCA9IHRyYWlsLmdldEVsZW1lbnQodHJhaWwuZW5kIC0gMik7XG4gICAgICAgICAgICBWZWMzLnN1YnRyYWN0KGxhc3RTZWNvbmRUcmFpbC52ZWxvY2l0eSwgbGFzdFNlZy5wb3NpdGlvbiwgbGFzdFNlY29uZFRyYWlsLnBvc2l0aW9uKTtcbiAgICAgICAgfSBlbHNlIGlmICh0cmFpbE51bSA+IDIpIHtcbiAgICAgICAgICAgIGNvbnN0IGxhc3RTZWNvbmRUcmFpbCA9IHRyYWlsLmdldEVsZW1lbnQodHJhaWwuZW5kIC0gMik7XG4gICAgICAgICAgICBjb25zdCBsYXN0VGhpcmRUcmFpbCA9IHRyYWlsLmdldEVsZW1lbnQodHJhaWwuZW5kIC0gMyk7XG4gICAgICAgICAgICBWZWMzLnN1YnRyYWN0KF90ZW1wX1ZlYzMsIGxhc3RUaGlyZFRyYWlsLnBvc2l0aW9uLCBsYXN0U2Vjb25kVHJhaWwucG9zaXRpb24pO1xuICAgICAgICAgICAgVmVjMy5zdWJ0cmFjdChfdGVtcF9WZWMzXzEsIGxhc3RTZWcucG9zaXRpb24sIGxhc3RTZWNvbmRUcmFpbC5wb3NpdGlvbik7XG4gICAgICAgICAgICBWZWMzLnN1YnRyYWN0KGxhc3RTZWNvbmRUcmFpbC52ZWxvY2l0eSwgX3RlbXBfVmVjM18xLCBfdGVtcF9WZWMzKTtcbiAgICAgICAgICAgIGlmIChWZWMzLmVxdWFscyhjYy5WZWMzLlpFUk8sIGxhc3RTZWNvbmRUcmFpbC52ZWxvY2l0eSkpIHtcbiAgICAgICAgICAgICAgICBWZWMzLmNvcHkobGFzdFNlY29uZFRyYWlsLnZlbG9jaXR5LCBfdGVtcF9WZWMzKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICBpZiAodGhpcy5jb2xvckZyb21QYXJ0aWNsZSkge1xuICAgICAgICAgICAgbGFzdFNlZy5jb2xvci5zZXQocC5jb2xvcik7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICBsYXN0U2VnLmNvbG9yLnNldCh0aGlzLmNvbG9yT3ZlcnRpbWUuZXZhbHVhdGUoMCwgMSkpO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgX3VwZGF0ZVRyYWlsRWxlbWVudCAodHJhaWwsIHRyYWlsRWxlLCBwLCBkdCkge1xuICAgICAgICB0cmFpbEVsZS5saWZldGltZSArPSBkdDtcbiAgICAgICAgaWYgKHRyYWlsLmNvbG9yRnJvbVBhcnRpY2xlKSB7XG4gICAgICAgICAgICB0cmFpbEVsZS5jb2xvci5zZXQocC5jb2xvcik7XG4gICAgICAgICAgICB0cmFpbEVsZS5jb2xvci5tdWx0aXBseSh0cmFpbC5jb2xvck92ZXJ0aW1lLmV2YWx1YXRlKDEuMCAtIHAucmVtYWluaW5nTGlmZXRpbWUgLyBwLnN0YXJ0TGlmZXRpbWUsIDEpKTtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIHRyYWlsRWxlLmNvbG9yLnNldCh0cmFpbC5jb2xvck92ZXJ0aW1lLmV2YWx1YXRlKDEuMCAtIHAucmVtYWluaW5nTGlmZXRpbWUgLyBwLnN0YXJ0TGlmZXRpbWUsIDEpKTtcbiAgICAgICAgfVxuICAgICAgICBpZiAodHJhaWwud2lkdGhGcm9tUGFydGljbGUpIHtcbiAgICAgICAgICAgIHRyYWlsRWxlLndpZHRoID0gcC5zaXplLnggKiB0cmFpbC53aWR0aFJhdGlvLmV2YWx1YXRlKHRyYWlsRWxlLmxpZmV0aW1lIC8gdHJhaWwuX3RyYWlsTGlmZXRpbWUsIDEpO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgdHJhaWxFbGUud2lkdGggPSB0cmFpbC53aWR0aFJhdGlvLmV2YWx1YXRlKHRyYWlsRWxlLmxpZmV0aW1lIC8gdHJhaWwuX3RyYWlsTGlmZXRpbWUsIDEpO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiB0cmFpbEVsZS5saWZldGltZSA+IHRyYWlsLl90cmFpbExpZmV0aW1lO1xuICAgIH1cblxuICAgIHJlbW92ZVBhcnRpY2xlIChwKSB7XG4gICAgICAgIGNvbnN0IHRyYWlsID0gdGhpcy5fcGFydGljbGVUcmFpbC5nZXQocCk7XG4gICAgICAgIGlmICh0cmFpbCAmJiB0aGlzLl90cmFpbFNlZ21lbnRzKSB7XG4gICAgICAgICAgICB0cmFpbC5jbGVhcigpO1xuICAgICAgICAgICAgdGhpcy5fdHJhaWxTZWdtZW50cy5mcmVlKHRyYWlsKTtcbiAgICAgICAgICAgIHRoaXMuX3BhcnRpY2xlVHJhaWwuZGVsZXRlKHApO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgdXBkYXRlVHJhaWxCdWZmZXIgKCkge1xuICAgICAgICB0aGlzLnZiT2Zmc2V0ID0gMDtcbiAgICAgICAgdGhpcy5pYk9mZnNldCA9IDA7XG4gICAgICAgIFxuICAgICAgICBmb3IgKGNvbnN0IHAgb2YgdGhpcy5fcGFydGljbGVUcmFpbC5rZXlzKCkpIHtcbiAgICAgICAgICAgIGNvbnN0IHRyYWlsU2VnID0gdGhpcy5fcGFydGljbGVUcmFpbC5nZXQocCk7XG4gICAgICAgICAgICBpZiAodHJhaWxTZWcuc3RhcnQgPT09IC0xKSB7XG4gICAgICAgICAgICAgICAgY29udGludWU7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBjb25zdCBpbmRleE9mZnNldCA9IHRoaXMudmJPZmZzZXQgKiA0IC8gdGhpcy5fdmVydFNpemU7XG4gICAgICAgICAgICBjb25zdCBlbmQgPSB0cmFpbFNlZy5zdGFydCA+PSB0cmFpbFNlZy5lbmQgPyB0cmFpbFNlZy5lbmQgKyB0cmFpbFNlZy50cmFpbEVsZW1lbnRzLmxlbmd0aCA6IHRyYWlsU2VnLmVuZDtcbiAgICAgICAgICAgIGNvbnN0IHRyYWlsTnVtID0gZW5kIC0gdHJhaWxTZWcuc3RhcnQ7XG4gICAgICAgICAgICAvLyBjb25zdCBsYXN0U2VnUmF0aW8gPSBWZWMzLmRpc3RhbmNlKHRyYWlsU2VnLmdldFRhaWxFbGVtZW50KCkhLnBvc2l0aW9uLCBwLnBvc2l0aW9uKSAvIHRoaXMuX21pblBhcnRpY2xlRGlzdGFuY2U7XG4gICAgICAgICAgICBjb25zdCB0ZXh0Q29vcmRTZWcgPSAxIC8gKHRyYWlsTnVtIC8qLSAxICsgbGFzdFNlZ1JhdGlvKi8pO1xuICAgICAgICAgICAgY29uc3Qgc3RhcnRTZWdFbGUgPSB0cmFpbFNlZy50cmFpbEVsZW1lbnRzW3RyYWlsU2VnLnN0YXJ0XTtcbiAgICAgICAgICAgIHRoaXMuX2ZpbGxWZXJ0ZXhCdWZmZXIoc3RhcnRTZWdFbGUsIHRoaXMuY29sb3JPdmVyVHJhaWwuZXZhbHVhdGUoMSwgMSksIGluZGV4T2Zmc2V0LCAxLCAwLCBORVhUX1RSSUFOR0xFX0lOREVYKTtcbiAgICAgICAgICAgIGZvciAobGV0IGkgPSB0cmFpbFNlZy5zdGFydCArIDE7IGkgPCBlbmQ7IGkrKykge1xuICAgICAgICAgICAgICAgIGNvbnN0IHNlZ0VsZSA9IHRyYWlsU2VnLnRyYWlsRWxlbWVudHNbaSAlIHRyYWlsU2VnLnRyYWlsRWxlbWVudHMubGVuZ3RoXTtcbiAgICAgICAgICAgICAgICBjb25zdCBqID0gaSAtIHRyYWlsU2VnLnN0YXJ0O1xuICAgICAgICAgICAgICAgIHRoaXMuX2ZpbGxWZXJ0ZXhCdWZmZXIoc2VnRWxlLCB0aGlzLmNvbG9yT3ZlclRyYWlsLmV2YWx1YXRlKDEgLSBqIC8gdHJhaWxOdW0sIDEpLCBpbmRleE9mZnNldCwgMSAtIGogKiB0ZXh0Q29vcmRTZWcsIGosIFBSRV9UUklBTkdMRV9JTkRFWCB8IE5FWFRfVFJJQU5HTEVfSU5ERVgpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKHRoaXMuX25lZWRUcmFuc2Zvcm0pIHtcbiAgICAgICAgICAgICAgICBWZWMzLnRyYW5zZm9ybU1hdDQoX3RlbXBfdHJhaWxFbGUucG9zaXRpb24sIHAucG9zaXRpb24sIF90ZW1wX3hmb3JtKTtcbiAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgVmVjMy5jb3B5KF90ZW1wX3RyYWlsRWxlLnBvc2l0aW9uLCBwLnBvc2l0aW9uKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmICh0cmFpbE51bSA9PT0gMSB8fCB0cmFpbE51bSA9PT0gMikge1xuICAgICAgICAgICAgICAgIGNvbnN0IGxhc3RTZWNvbmRUcmFpbCA9IHRyYWlsU2VnLmdldEVsZW1lbnQodHJhaWxTZWcuZW5kIC0gMSk7XG4gICAgICAgICAgICAgICAgVmVjMy5zdWJ0cmFjdChsYXN0U2Vjb25kVHJhaWwudmVsb2NpdHksIF90ZW1wX3RyYWlsRWxlLnBvc2l0aW9uLCBsYXN0U2Vjb25kVHJhaWwucG9zaXRpb24pO1xuICAgICAgICAgICAgICAgIHRoaXMuX3ZiRjMyW3RoaXMudmJPZmZzZXQgLSB0aGlzLl92ZXJ0U2l6ZSAvIDQgLSA0XSA9IGxhc3RTZWNvbmRUcmFpbC52ZWxvY2l0eS54O1xuICAgICAgICAgICAgICAgIHRoaXMuX3ZiRjMyW3RoaXMudmJPZmZzZXQgLSB0aGlzLl92ZXJ0U2l6ZSAvIDQgLSAzXSA9IGxhc3RTZWNvbmRUcmFpbC52ZWxvY2l0eS55O1xuICAgICAgICAgICAgICAgIHRoaXMuX3ZiRjMyW3RoaXMudmJPZmZzZXQgLSB0aGlzLl92ZXJ0U2l6ZSAvIDQgLSAyXSA9IGxhc3RTZWNvbmRUcmFpbC52ZWxvY2l0eS56O1xuICAgICAgICAgICAgICAgIHRoaXMuX3ZiRjMyW3RoaXMudmJPZmZzZXQgLSA0XSA9IGxhc3RTZWNvbmRUcmFpbC52ZWxvY2l0eS54O1xuICAgICAgICAgICAgICAgIHRoaXMuX3ZiRjMyW3RoaXMudmJPZmZzZXQgLSAzXSA9IGxhc3RTZWNvbmRUcmFpbC52ZWxvY2l0eS55O1xuICAgICAgICAgICAgICAgIHRoaXMuX3ZiRjMyW3RoaXMudmJPZmZzZXQgLSAyXSA9IGxhc3RTZWNvbmRUcmFpbC52ZWxvY2l0eS56O1xuICAgICAgICAgICAgICAgIFZlYzMuc3VidHJhY3QoX3RlbXBfdHJhaWxFbGUudmVsb2NpdHksIF90ZW1wX3RyYWlsRWxlLnBvc2l0aW9uLCBsYXN0U2Vjb25kVHJhaWwucG9zaXRpb24pO1xuICAgICAgICAgICAgICAgIHRoaXMuX2NoZWNrRGlyZWN0aW9uUmV2ZXJzZShfdGVtcF90cmFpbEVsZSwgbGFzdFNlY29uZFRyYWlsKTtcbiAgICAgICAgICAgIH0gZWxzZSBpZiAodHJhaWxOdW0gPiAyKSB7XG4gICAgICAgICAgICAgICAgY29uc3QgbGFzdFNlY29uZFRyYWlsID0gdHJhaWxTZWcuZ2V0RWxlbWVudCh0cmFpbFNlZy5lbmQgLSAxKTtcbiAgICAgICAgICAgICAgICBjb25zdCBsYXN0VGhpcmRUcmFpbCA9IHRyYWlsU2VnLmdldEVsZW1lbnQodHJhaWxTZWcuZW5kIC0gMik7XG4gICAgICAgICAgICAgICAgVmVjMy5zdWJ0cmFjdChfdGVtcF9WZWMzLCBsYXN0VGhpcmRUcmFpbC5wb3NpdGlvbiwgbGFzdFNlY29uZFRyYWlsLnBvc2l0aW9uKTtcbiAgICAgICAgICAgICAgICBWZWMzLnN1YnRyYWN0KF90ZW1wX1ZlYzNfMSwgX3RlbXBfdHJhaWxFbGUucG9zaXRpb24sIGxhc3RTZWNvbmRUcmFpbC5wb3NpdGlvbik7XG4gICAgICAgICAgICAgICAgVmVjMy5ub3JtYWxpemUoX3RlbXBfVmVjMywgX3RlbXBfVmVjMyk7XG4gICAgICAgICAgICAgICAgVmVjMy5ub3JtYWxpemUoX3RlbXBfVmVjM18xLCBfdGVtcF9WZWMzXzEpO1xuICAgICAgICAgICAgICAgIFZlYzMuc3VidHJhY3QobGFzdFNlY29uZFRyYWlsLnZlbG9jaXR5LCBfdGVtcF9WZWMzXzEsIF90ZW1wX1ZlYzMpO1xuICAgICAgICAgICAgICAgIFZlYzMubm9ybWFsaXplKGxhc3RTZWNvbmRUcmFpbC52ZWxvY2l0eSwgbGFzdFNlY29uZFRyYWlsLnZlbG9jaXR5KTtcbiAgICAgICAgICAgICAgICB0aGlzLl9jaGVja0RpcmVjdGlvblJldmVyc2UobGFzdFNlY29uZFRyYWlsLCBsYXN0VGhpcmRUcmFpbCk7XG4gICAgICAgICAgICAgICAgdGhpcy52Yk9mZnNldCAtPSB0aGlzLl92ZXJ0U2l6ZSAvIDQgKiAyO1xuICAgICAgICAgICAgICAgIHRoaXMuaWJPZmZzZXQgLT0gNjtcbiAgICAgICAgICAgICAgICAvL19iY0lkeCA9IChfYmNJZHggLSA2ICsgOSkgJSA5OyAgLy8gPHdpcmVmcmFtZSBkZWJ1Zz5cbiAgICAgICAgICAgICAgICB0aGlzLl9maWxsVmVydGV4QnVmZmVyKGxhc3RTZWNvbmRUcmFpbCwgdGhpcy5jb2xvck92ZXJUcmFpbC5ldmFsdWF0ZSh0ZXh0Q29vcmRTZWcsIDEpLCBpbmRleE9mZnNldCwgdGV4dENvb3JkU2VnLCB0cmFpbE51bSAtIDEsIFBSRV9UUklBTkdMRV9JTkRFWCB8IE5FWFRfVFJJQU5HTEVfSU5ERVgpO1xuICAgICAgICAgICAgICAgIFZlYzMuc3VidHJhY3QoX3RlbXBfdHJhaWxFbGUudmVsb2NpdHksIF90ZW1wX3RyYWlsRWxlLnBvc2l0aW9uLCBsYXN0U2Vjb25kVHJhaWwucG9zaXRpb24pO1xuICAgICAgICAgICAgICAgIFZlYzMubm9ybWFsaXplKF90ZW1wX3RyYWlsRWxlLnZlbG9jaXR5LCBfdGVtcF90cmFpbEVsZS52ZWxvY2l0eSk7XG4gICAgICAgICAgICAgICAgdGhpcy5fY2hlY2tEaXJlY3Rpb25SZXZlcnNlKF90ZW1wX3RyYWlsRWxlLCBsYXN0U2Vjb25kVHJhaWwpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKHRoaXMud2lkdGhGcm9tUGFydGljbGUpIHtcbiAgICAgICAgICAgICAgICBfdGVtcF90cmFpbEVsZS53aWR0aCA9IHAuc2l6ZS54ICogdGhpcy53aWR0aFJhdGlvLmV2YWx1YXRlKDAsIDEpO1xuICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICBfdGVtcF90cmFpbEVsZS53aWR0aCA9IHRoaXMud2lkdGhSYXRpby5ldmFsdWF0ZSgwLCAxKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIF90ZW1wX3RyYWlsRWxlLmNvbG9yID0gcC5jb2xvcjtcblxuICAgICAgICAgICAgaWYgKFZlYzMuZXF1YWxzKF90ZW1wX3RyYWlsRWxlLnZlbG9jaXR5LCBjYy5WZWMzLlpFUk8pKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5pYk9mZnNldCAtPSAzO1xuICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICB0aGlzLl9maWxsVmVydGV4QnVmZmVyKF90ZW1wX3RyYWlsRWxlLCB0aGlzLmNvbG9yT3ZlclRyYWlsLmV2YWx1YXRlKDAsIDEpLCBpbmRleE9mZnNldCwgMCwgdHJhaWxOdW0sIFBSRV9UUklBTkdMRV9JTkRFWCk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgdGhpcy5fdXBkYXRlSUEodGhpcy5pYk9mZnNldCk7XG4gICAgfVxuXG4gICAgX2ZpbGxWZXJ0ZXhCdWZmZXIgKHRyYWlsU2VnLCBjb2xvck1vZGlmZXIsIGluZGV4T2Zmc2V0LCB4VGV4Q29vcmQsIHRyYWlsRWxlSWR4LCBpbmRleFNldCkge1xuICAgICAgICB0aGlzLl92YkYzMlt0aGlzLnZiT2Zmc2V0KytdID0gdHJhaWxTZWcucG9zaXRpb24ueDtcbiAgICAgICAgdGhpcy5fdmJGMzJbdGhpcy52Yk9mZnNldCsrXSA9IHRyYWlsU2VnLnBvc2l0aW9uLnk7XG4gICAgICAgIHRoaXMuX3ZiRjMyW3RoaXMudmJPZmZzZXQrK10gPSB0cmFpbFNlZy5wb3NpdGlvbi56O1xuICAgICAgICB0aGlzLl92YkYzMlt0aGlzLnZiT2Zmc2V0KytdID0gMDtcbiAgICAgICAgdGhpcy5fdmJGMzJbdGhpcy52Yk9mZnNldCsrXSA9IHRyYWlsU2VnLndpZHRoO1xuICAgICAgICB0aGlzLl92YkYzMlt0aGlzLnZiT2Zmc2V0KytdID0geFRleENvb3JkO1xuICAgICAgICB0aGlzLl92YkYzMlt0aGlzLnZiT2Zmc2V0KytdID0gMDtcbiAgICAgICAgLy8gdGhpcy5fdmJGMzJbdGhpcy52Yk9mZnNldCsrXSA9IGJhcnljZW50cmljW19iY0lkeCsrXTsgIC8vIDx3aXJlZnJhbWUgZGVidWc+XG4gICAgICAgIC8vIHRoaXMuX3ZiRjMyW3RoaXMudmJPZmZzZXQrK10gPSBiYXJ5Y2VudHJpY1tfYmNJZHgrK107XG4gICAgICAgIC8vIHRoaXMuX3ZiRjMyW3RoaXMudmJPZmZzZXQrK10gPSBiYXJ5Y2VudHJpY1tfYmNJZHgrK107XG4gICAgICAgIC8vIF9iY0lkeCAlPSA5O1xuICAgICAgICB0aGlzLl92YkYzMlt0aGlzLnZiT2Zmc2V0KytdID0gdHJhaWxTZWcudmVsb2NpdHkueDtcbiAgICAgICAgdGhpcy5fdmJGMzJbdGhpcy52Yk9mZnNldCsrXSA9IHRyYWlsU2VnLnZlbG9jaXR5Lnk7XG4gICAgICAgIHRoaXMuX3ZiRjMyW3RoaXMudmJPZmZzZXQrK10gPSB0cmFpbFNlZy52ZWxvY2l0eS56O1xuICAgICAgICBfdGVtcF9jb2xvci5zZXQodHJhaWxTZWcuY29sb3IpO1xuICAgICAgICBfdGVtcF9jb2xvci5tdWx0aXBseShjb2xvck1vZGlmZXIpO1xuICAgICAgICB0aGlzLl92YlVpbnQzMlt0aGlzLnZiT2Zmc2V0KytdID0gX3RlbXBfY29sb3IuX3ZhbDtcbiAgICAgICAgdGhpcy5fdmJGMzJbdGhpcy52Yk9mZnNldCsrXSA9IHRyYWlsU2VnLnBvc2l0aW9uLng7XG4gICAgICAgIHRoaXMuX3ZiRjMyW3RoaXMudmJPZmZzZXQrK10gPSB0cmFpbFNlZy5wb3NpdGlvbi55O1xuICAgICAgICB0aGlzLl92YkYzMlt0aGlzLnZiT2Zmc2V0KytdID0gdHJhaWxTZWcucG9zaXRpb24uejtcbiAgICAgICAgdGhpcy5fdmJGMzJbdGhpcy52Yk9mZnNldCsrXSA9IDE7XG4gICAgICAgIHRoaXMuX3ZiRjMyW3RoaXMudmJPZmZzZXQrK10gPSB0cmFpbFNlZy53aWR0aDtcbiAgICAgICAgdGhpcy5fdmJGMzJbdGhpcy52Yk9mZnNldCsrXSA9IHhUZXhDb29yZDtcbiAgICAgICAgdGhpcy5fdmJGMzJbdGhpcy52Yk9mZnNldCsrXSA9IDE7XG4gICAgICAgIC8vIHRoaXMuX3ZiRjMyW3RoaXMudmJPZmZzZXQrK10gPSBiYXJ5Y2VudHJpY1tfYmNJZHgrK107ICAvLyA8d2lyZWZyYW1lIGRlYnVnPlxuICAgICAgICAvLyB0aGlzLl92YkYzMlt0aGlzLnZiT2Zmc2V0KytdID0gYmFyeWNlbnRyaWNbX2JjSWR4KytdO1xuICAgICAgICAvLyB0aGlzLl92YkYzMlt0aGlzLnZiT2Zmc2V0KytdID0gYmFyeWNlbnRyaWNbX2JjSWR4KytdO1xuICAgICAgICAvLyBfYmNJZHggJT0gOTtcbiAgICAgICAgdGhpcy5fdmJGMzJbdGhpcy52Yk9mZnNldCsrXSA9IHRyYWlsU2VnLnZlbG9jaXR5Lng7XG4gICAgICAgIHRoaXMuX3ZiRjMyW3RoaXMudmJPZmZzZXQrK10gPSB0cmFpbFNlZy52ZWxvY2l0eS55O1xuICAgICAgICB0aGlzLl92YkYzMlt0aGlzLnZiT2Zmc2V0KytdID0gdHJhaWxTZWcudmVsb2NpdHkuejtcbiAgICAgICAgdGhpcy5fdmJVaW50MzJbdGhpcy52Yk9mZnNldCsrXSA9IF90ZW1wX2NvbG9yLl92YWw7XG4gICAgICAgIGlmIChpbmRleFNldCAmIFBSRV9UUklBTkdMRV9JTkRFWCkge1xuICAgICAgICAgICAgdGhpcy5faUJ1ZmZlclt0aGlzLmliT2Zmc2V0KytdID0gaW5kZXhPZmZzZXQgKyAyICogdHJhaWxFbGVJZHg7XG4gICAgICAgICAgICB0aGlzLl9pQnVmZmVyW3RoaXMuaWJPZmZzZXQrK10gPSBpbmRleE9mZnNldCArIDIgKiB0cmFpbEVsZUlkeCAtIDE7XG4gICAgICAgICAgICB0aGlzLl9pQnVmZmVyW3RoaXMuaWJPZmZzZXQrK10gPSBpbmRleE9mZnNldCArIDIgKiB0cmFpbEVsZUlkeCArIDE7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKGluZGV4U2V0ICYgTkVYVF9UUklBTkdMRV9JTkRFWCkge1xuICAgICAgICAgICAgdGhpcy5faUJ1ZmZlclt0aGlzLmliT2Zmc2V0KytdID0gaW5kZXhPZmZzZXQgKyAyICogdHJhaWxFbGVJZHg7XG4gICAgICAgICAgICB0aGlzLl9pQnVmZmVyW3RoaXMuaWJPZmZzZXQrK10gPSBpbmRleE9mZnNldCArIDIgKiB0cmFpbEVsZUlkeCArIDE7XG4gICAgICAgICAgICB0aGlzLl9pQnVmZmVyW3RoaXMuaWJPZmZzZXQrK10gPSBpbmRleE9mZnNldCArIDIgKiB0cmFpbEVsZUlkeCArIDI7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICBfdXBkYXRlSUEgKGNvdW50KSB7XG4gICAgICAgIGlmICh0aGlzLl9wYXJ0aWNsZVN5c3RlbSAmJiB0aGlzLl9wYXJ0aWNsZVN5c3RlbS5fYXNzZW1ibGVyKSB7XG4gICAgICAgICAgICB0aGlzLl9wYXJ0aWNsZVN5c3RlbS5fYXNzZW1ibGVyLnVwZGF0ZUlBKDEsIGNvdW50LCB0cnVlLCB0cnVlKTtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIF9jaGVja0RpcmVjdGlvblJldmVyc2UgKGN1cnJFbGVtZW50LCBwcmV2RWxlbWVudCkge1xuICAgICAgICBpZiAoVmVjMy5kb3QoY3VyckVsZW1lbnQudmVsb2NpdHksIHByZXZFbGVtZW50LnZlbG9jaXR5KSA8IERJUkVDVElPTl9USFJFU0hPTEQpIHtcbiAgICAgICAgICAgIGN1cnJFbGVtZW50LmRpcmVjdGlvbiA9IDEgLSBwcmV2RWxlbWVudC5kaXJlY3Rpb247XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICBjdXJyRWxlbWVudC5kaXJlY3Rpb24gPSBwcmV2RWxlbWVudC5kaXJlY3Rpb247XG4gICAgICAgIH1cbiAgICB9XG59XG4iXSwic291cmNlUm9vdCI6Ii8ifQ==