
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/particle/renderer/particle-system-3d-renderer.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _valueTypes = require("../../../value-types");

var _gfx = _interopRequireDefault(require("../../../../renderer/gfx"));

var _particleBatchModel = _interopRequireDefault(require("./particle-batch-model"));

var _materialVariant = _interopRequireDefault(require("../../../assets/material/material-variant"));

var _recyclePool = _interopRequireDefault(require("../../../../renderer/memop/recycle-pool"));

var _enum = require("../enum");

var _particle = _interopRequireDefault(require("../particle"));

var _assembler = _interopRequireDefault(require("../../../renderer/assembler"));

var _particleSystem3d = _interopRequireDefault(require("../particle-system-3d"));

var _dec, _class, _temp;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var _require = require('../../../platform/CCClassDecorator'),
    ccclass = _require.ccclass,
    property = _require.property; // tslint:disable: max-line-length


var _tempAttribUV = new _valueTypes.Vec3();

var _tempAttribUV0 = new _valueTypes.Vec2();

var _tempAttribColor = new _valueTypes.Vec4();

var _tempWorldTrans = new _valueTypes.Mat4();

var _uvs = [0, 0, // bottom-left
1, 0, // bottom-right
0, 1, // top-left
1, 1 // top-right
];
var CC_USE_WORLD_SPACE = 'CC_USE_WORLD_SPACE';
var CC_USE_BILLBOARD = 'CC_USE_BILLBOARD';
var CC_USE_STRETCHED_BILLBOARD = 'CC_USE_STRETCHED_BILLBOARD';
var CC_USE_HORIZONTAL_BILLBOARD = 'CC_USE_HORIZONTAL_BILLBOARD';
var CC_USE_VERTICAL_BILLBOARD = 'CC_USE_VERTICAL_BILLBOARD';
var CC_USE_MESH = 'CC_USE_MESH'; //const CC_DRAW_WIRE_FRAME = 'CC_DRAW_WIRE_FRAME'; // <wireframe debug>

var vfmtNormal = new _gfx["default"].VertexFormat([{
  name: _gfx["default"].ATTR_POSITION,
  type: _gfx["default"].ATTR_TYPE_FLOAT32,
  num: 3
}, {
  name: _gfx["default"].ATTR_TEX_COORD,
  type: _gfx["default"].ATTR_TYPE_FLOAT32,
  num: 3
}, {
  name: _gfx["default"].ATTR_TEX_COORD1,
  type: _gfx["default"].ATTR_TYPE_FLOAT32,
  num: 3
}, {
  name: _gfx["default"].ATTR_TEX_COORD2,
  type: _gfx["default"].ATTR_TYPE_FLOAT32,
  num: 3
}, {
  name: _gfx["default"].ATTR_COLOR,
  type: _gfx["default"].ATTR_TYPE_UINT8,
  num: 4,
  normalize: true
}]);
vfmtNormal.name = 'vfmtNormal';
var vfmtStretch = new _gfx["default"].VertexFormat([{
  name: _gfx["default"].ATTR_POSITION,
  type: _gfx["default"].ATTR_TYPE_FLOAT32,
  num: 3
}, {
  name: _gfx["default"].ATTR_TEX_COORD,
  type: _gfx["default"].ATTR_TYPE_FLOAT32,
  num: 3
}, {
  name: _gfx["default"].ATTR_TEX_COORD1,
  type: _gfx["default"].ATTR_TYPE_FLOAT32,
  num: 3
}, {
  name: _gfx["default"].ATTR_TEX_COORD2,
  type: _gfx["default"].ATTR_TYPE_FLOAT32,
  num: 3
}, {
  name: _gfx["default"].ATTR_COLOR,
  type: _gfx["default"].ATTR_TYPE_UINT8,
  num: 4,
  normalize: true
}, {
  name: _gfx["default"].ATTR_COLOR1,
  type: _gfx["default"].ATTR_TYPE_FLOAT32,
  num: 3
}]);
vfmtStretch.name = 'vfmtStretch';
var vfmtMesh = new _gfx["default"].VertexFormat([{
  name: _gfx["default"].ATTR_POSITION,
  type: _gfx["default"].ATTR_TYPE_FLOAT32,
  num: 3
}, {
  name: _gfx["default"].ATTR_TEX_COORD,
  type: _gfx["default"].ATTR_TYPE_FLOAT32,
  num: 3
}, {
  name: _gfx["default"].ATTR_TEX_COORD1,
  type: _gfx["default"].ATTR_TYPE_FLOAT32,
  num: 3
}, {
  name: _gfx["default"].ATTR_TEX_COORD2,
  type: _gfx["default"].ATTR_TYPE_FLOAT32,
  num: 3
}, {
  name: _gfx["default"].ATTR_COLOR,
  type: _gfx["default"].ATTR_TYPE_UINT8,
  num: 4,
  normalize: true
}, {
  name: _gfx["default"].ATTR_TEX_COORD3,
  type: _gfx["default"].ATTR_TYPE_FLOAT32,
  num: 3
}, {
  name: _gfx["default"].ATTR_NORMAL,
  type: _gfx["default"].ATTR_TYPE_FLOAT32,
  num: 3
}, {
  name: _gfx["default"].ATTR_COLOR1,
  type: _gfx["default"].ATTR_TYPE_UINT8,
  num: 4,
  normalize: true
}]);
vfmtMesh.name = 'vfmtMesh';
var ParticleSystem3DAssembler = (_dec = ccclass('cc.ParticleSystem3DAssembler'), _dec(_class = (_temp =
/*#__PURE__*/
function (_Assembler) {
  _inheritsLoose(ParticleSystem3DAssembler, _Assembler);

  function ParticleSystem3DAssembler() {
    var _this;

    _this = _Assembler.call(this) || this;
    _this._defines = null;
    _this._trailDefines = null;
    _this._model = null;
    _this.frameTile_velLenScale = null;
    _this.attrs = [];
    _this._vertFormat = [];
    _this._particleSystem = null;
    _this._particles = null;
    _this._defaultMat = null;
    _this._isAssetReady = false;
    _this._defaultTrailMat = null;
    _this._customProperties = null;
    _this._node_scale = null;
    _this._model = null;
    _this.frameTile_velLenScale = cc.v4(1, 1, 0, 0);
    _this._node_scale = cc.v4();
    _this.attrs = new Array(5);
    _this._trailDefines = {
      CC_USE_WORLD_SPACE: true //CC_DRAW_WIRE_FRAME: true,   // <wireframe debug>

    };
    return _this;
  }

  var _proto = ParticleSystem3DAssembler.prototype;

  _proto.onInit = function onInit(ps) {
    var _this2 = this;

    this._particleSystem = ps;
    this._particles = new _recyclePool["default"](function () {
      return new _particle["default"](_this2);
    }, 16);

    this._setVertexAttrib();

    this.onEnable();

    this._updateModel();

    this._updateMaterialParams();

    this._updateTrailMaterial();
  };

  _proto.onEnable = function onEnable() {
    if (!this._particleSystem) {
      return;
    }

    if (this._model == null) {
      this._model = new _particleBatchModel["default"]();
    }

    if (!this._model.inited) {
      this._model.setCapacity(this._particleSystem.capacity);
    }

    this._model.enabled = this._particleSystem.enabledInHierarchy;
  };

  _proto.onDisable = function onDisable() {
    if (this._model) {
      this._model.enabled = this._particleSystem.enabledInHierarchy;
    }
  };

  _proto.onDestroy = function onDestroy() {
    this._model = null;
  };

  _proto.clear = function clear() {
    this._particles.reset();

    this.updateParticleBuffer();
  };

  _proto._getFreeParticle = function _getFreeParticle() {
    if (this._particles.length >= this._particleSystem.capacity) {
      return null;
    }

    return this._particles.add();
  };

  _proto._setNewParticle = function _setNewParticle(p) {};

  _proto._updateParticles = function _updateParticles(dt) {
    this._particleSystem.node.getWorldMatrix(_tempWorldTrans);

    switch (this._particleSystem.scaleSpace) {
      case _enum.Space.Local:
        this._particleSystem.node.getScale(this._node_scale);

        break;

      case _enum.Space.World:
        this._particleSystem.node.getWorldScale(this._node_scale);

        break;
    }

    var material = this._particleSystem.materials[0];
    var mat = material ? this._particleSystem.particleMaterial : this._defaultMat;
    mat.setProperty('scale', this._node_scale);

    if (this._particleSystem.velocityOvertimeModule.enable) {
      this._particleSystem.velocityOvertimeModule.update(this._particleSystem._simulationSpace, _tempWorldTrans);
    }

    if (this._particleSystem.forceOvertimeModule.enable) {
      this._particleSystem.forceOvertimeModule.update(this._particleSystem._simulationSpace, _tempWorldTrans);
    }

    if (this._particleSystem.trailModule.enable) {
      this._particleSystem.trailModule.update();
    }

    for (var i = 0; i < this._particles.length; ++i) {
      var p = this._particles.data[i];
      p.remainingLifetime -= dt;

      _valueTypes.Vec3.set(p.animatedVelocity, 0, 0, 0);

      if (p.remainingLifetime < 0.0) {
        if (this._particleSystem.trailModule.enable) {
          this._particleSystem.trailModule.removeParticle(p);
        }

        this._particles.remove(i);

        --i;
        continue;
      }

      p.velocity.y -= this._particleSystem.gravityModifier.evaluate(1 - p.remainingLifetime / p.startLifetime, p.randomSeed) * 9.8 * dt; // apply gravity.

      if (this._particleSystem.sizeOvertimeModule.enable) {
        this._particleSystem.sizeOvertimeModule.animate(p);
      }

      if (this._particleSystem.colorOverLifetimeModule.enable) {
        this._particleSystem.colorOverLifetimeModule.animate(p);
      }

      if (this._particleSystem.forceOvertimeModule.enable) {
        this._particleSystem.forceOvertimeModule.animate(p, dt);
      }

      if (this._particleSystem.velocityOvertimeModule.enable) {
        this._particleSystem.velocityOvertimeModule.animate(p);
      } else {
        _valueTypes.Vec3.copy(p.ultimateVelocity, p.velocity);
      }

      if (this._particleSystem.limitVelocityOvertimeModule.enable) {
        this._particleSystem.limitVelocityOvertimeModule.animate(p);
      }

      if (this._particleSystem.rotationOvertimeModule.enable) {
        this._particleSystem.rotationOvertimeModule.animate(p, dt);
      }

      if (this._particleSystem.textureAnimationModule.enable) {
        this._particleSystem.textureAnimationModule.animate(p);
      }

      _valueTypes.Vec3.scaleAndAdd(p.position, p.position, p.ultimateVelocity, dt); // apply velocity.


      if (this._particleSystem.trailModule.enable) {
        this._particleSystem.trailModule.animate(p, dt);
      }
    }

    return this._particles.length;
  } // internal function
  ;

  _proto.updateParticleBuffer = function updateParticleBuffer() {
    // update vertex buffer
    var idx = 0;
    var uploadVel = this._particleSystem.renderMode === _enum.RenderMode.StrecthedBillboard;

    for (var i = 0; i < this._particles.length; ++i) {
      var p = this._particles.data[i];
      var fi = 0;

      if (this._particleSystem.textureAnimationModule.enable) {
        fi = p.frameIndex;
      }

      idx = i * 4;
      var attrNum = 0;

      if (this._particleSystem.renderMode !== _enum.RenderMode.Mesh) {
        for (var j = 0; j < 4; ++j) {
          // four verts per particle.
          attrNum = 0;
          this.attrs[attrNum++] = p.position;
          _tempAttribUV.x = _uvs[2 * j];
          _tempAttribUV.y = _uvs[2 * j + 1];
          _tempAttribUV.z = fi;
          this.attrs[attrNum++] = _tempAttribUV;
          this.attrs[attrNum++] = p.size;
          this.attrs[attrNum++] = p.rotation;
          this.attrs[attrNum++] = p.color._val;

          if (uploadVel) {
            this.attrs[attrNum++] = p.ultimateVelocity;
          } else {
            this.attrs[attrNum++] = null;
          }

          this._model.addParticleVertexData(idx++, this.attrs);
        }
      } else {
        attrNum = 0;
        this.attrs[attrNum++] = p.position;
        _tempAttribUV.z = fi;
        this.attrs[attrNum++] = _tempAttribUV;
        this.attrs[attrNum++] = p.size;
        this.attrs[attrNum++] = p.rotation;
        this.attrs[attrNum++] = p.color._val;

        this._model.addParticleVertexData(i, this.attrs);
      }
    }

    this.updateIA(0, this._particles.length * this._model._indexCount, true);
  };

  _proto.updateShaderUniform = function updateShaderUniform() {};

  _proto.updateIA = function updateIA(index, count, vDirty, iDirty) {
    if (!this._model) return;

    this._model.updateIA(index, count, vDirty, iDirty);
  };

  _proto.getParticleCount = function getParticleCount() {
    return this._particles.data.length;
  };

  _proto._onMaterialModified = function _onMaterialModified(index, material) {
    if (index === 0) {
      this._updateModel();

      this._updateMaterialParams();
    } else {
      this._updateTrailMaterial();
    }
  };

  _proto._onRebuildPSO = function _onRebuildPSO(index, material) {
    if (this._model && index === 0) {
      this._model.setModelMaterial(material);
    }

    if (this._particleSystem.trailModule._trailModel && index === 1) {
      this._particleSystem.trailModule._trailModel.setModelMaterial(material);
    }
  };

  _proto._ensureLoadMesh = function _ensureLoadMesh() {
    if (this._particleSystem.mesh && !this._particleSystem.mesh.loaded) {
      postLoadMesh(this._particleSystem.mesh);
    }
  };

  _proto.setCapacity = function setCapacity(capacity) {
    if (!this._model) return;

    this._model.setCapacity(capacity);
  };

  _proto._setVertexAttrib = function _setVertexAttrib() {
    switch (this._particleSystem.renderMode) {
      case _enum.RenderMode.StrecthedBillboard:
        this._vertFormat = vfmtStretch;
        break;

      case _enum.RenderMode.Mesh:
        this._vertFormat = vfmtMesh;
        break;

      default:
        this._vertFormat = vfmtNormal;
    }
  };

  _proto._updateMaterialParams = function _updateMaterialParams() {
    if (!this._particleSystem) {
      return;
    }

    var mat = this._particleSystem.materials[0];

    if (mat == null && this._defaultMat == null) {
      mat = this._defaultMat = _materialVariant["default"].createWithBuiltin('3d-particle', this);
    } else {
      mat = _materialVariant["default"].create(mat, this._particleSystem);
    }

    mat = mat || this._defaultMat;

    if (this._particleSystem._simulationSpace === _enum.Space.World) {
      mat.define(CC_USE_WORLD_SPACE, true);
    } else {
      mat.define(CC_USE_WORLD_SPACE, false);
    }

    if (this._particleSystem.renderMode === _enum.RenderMode.Billboard) {
      mat.define(CC_USE_BILLBOARD, true);
      mat.define(CC_USE_STRETCHED_BILLBOARD, false);
      mat.define(CC_USE_HORIZONTAL_BILLBOARD, false);
      mat.define(CC_USE_VERTICAL_BILLBOARD, false);
      mat.define(CC_USE_MESH, false);
    } else if (this._particleSystem.renderMode === _enum.RenderMode.StrecthedBillboard) {
      mat.define(CC_USE_BILLBOARD, false);
      mat.define(CC_USE_STRETCHED_BILLBOARD, true);
      mat.define(CC_USE_HORIZONTAL_BILLBOARD, false);
      mat.define(CC_USE_VERTICAL_BILLBOARD, false);
      mat.define(CC_USE_MESH, false);
      this.frameTile_velLenScale.z = this._particleSystem.velocityScale;
      this.frameTile_velLenScale.w = this._particleSystem.lengthScale;
    } else if (this._particleSystem.renderMode === _enum.RenderMode.HorizontalBillboard) {
      mat.define(CC_USE_BILLBOARD, false);
      mat.define(CC_USE_STRETCHED_BILLBOARD, false);
      mat.define(CC_USE_HORIZONTAL_BILLBOARD, true);
      mat.define(CC_USE_VERTICAL_BILLBOARD, false);
      mat.define(CC_USE_MESH, false);
    } else if (this._particleSystem.renderMode === _enum.RenderMode.VerticalBillboard) {
      mat.define(CC_USE_BILLBOARD, false);
      mat.define(CC_USE_STRETCHED_BILLBOARD, false);
      mat.define(CC_USE_HORIZONTAL_BILLBOARD, false);
      mat.define(CC_USE_VERTICAL_BILLBOARD, true);
      mat.define(CC_USE_MESH, false);
    } else if (this._particleSystem.renderMode === _enum.RenderMode.Mesh) {
      mat.define(CC_USE_BILLBOARD, false);
      mat.define(CC_USE_STRETCHED_BILLBOARD, false);
      mat.define(CC_USE_HORIZONTAL_BILLBOARD, false);
      mat.define(CC_USE_VERTICAL_BILLBOARD, false);
      mat.define(CC_USE_MESH, true);
    } else {
      console.warn("particle system renderMode " + this._particleSystem.renderMode + " not support.");
    }

    if (this._particleSystem.textureAnimationModule.enable) {
      _valueTypes.Vec2.set(this.frameTile_velLenScale, this._particleSystem.textureAnimationModule.numTilesX, this._particleSystem.textureAnimationModule.numTilesY);
    }

    mat.setProperty('frameTile_velLenScale', this.frameTile_velLenScale);

    this._particleSystem.setMaterial(0, mat);
  };

  _proto._updateTrailMaterial = function _updateTrailMaterial() {
    // Here need to create a material variant through the getter call.
    var mat = this._particleSystem.trailMaterial;

    if (this._particleSystem.trailModule.enable) {
      if (mat === null && this._defaultTrailMat === null) {
        this._defaultTrailMat = _materialVariant["default"].createWithBuiltin('3d-trail', this);
      }

      if (mat === null) {
        mat = this._defaultTrailMat;
        this._particleSystem.trailMaterial = mat;
      }

      if (this._particleSystem._simulationSpace === _enum.Space.World || this._particleSystem.trailModule.space === _enum.Space.World) {
        mat.define(CC_USE_WORLD_SPACE, true);
      } else {
        mat.define(CC_USE_WORLD_SPACE, false);
      } //mat.define(CC_DRAW_WIRE_FRAME, true); // <wireframe debug>


      this._particleSystem.trailModule._updateMaterial();
    }
  };

  _proto._updateTrailEnable = function _updateTrailEnable(enable) {
    if (!this._model) {
      return;
    }

    var subData = this._model._subDatas[1];

    if (subData) {
      subData.enable = enable;
    }
  };

  _proto._updateModel = function _updateModel() {
    if (!this._model) {
      return;
    }

    this._model.setVertexAttributes(this._particleSystem.renderMode === _enum.RenderMode.Mesh ? this._particleSystem.mesh : null, this._vertFormat);
  };

  _proto.setVertexAttributes = function setVertexAttributes(mesh, vfmt) {
    if (!this._model) {
      return;
    }

    this._model.setVertexAttributes(mesh, vfmt);
  };

  _proto.fillBuffers = function fillBuffers(comp, renderer) {
    if (!this._model) return;

    this._model._uploadData();

    var submeshes = this._model._subMeshes;
    var subDatas = this._model._subDatas;
    var materials = comp.materials;

    renderer._flush();

    for (var i = 0, len = submeshes.length; i < len; i++) {
      var ia = submeshes[i];
      var meshData = subDatas[i];
      var material = materials[i];

      if (meshData.enable) {
        renderer.material = material;
        renderer.cullingMask = comp.node._cullingMask;
        renderer.node = comp.node;

        renderer._flushIA(ia);
      }
    }
  };

  return ParticleSystem3DAssembler;
}(_assembler["default"]), _temp)) || _class);
exports["default"] = ParticleSystem3DAssembler;
Object.assign(ParticleSystem3DAssembler, {
  uv: _uvs
});

_assembler["default"].register(_particleSystem3d["default"], ParticleSystem3DAssembler);

module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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