
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/particle/renderer/particle-batch-model.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _gfx = _interopRequireDefault(require("../../../../renderer/gfx"));

var _inputAssembler = _interopRequireDefault(require("../../../../renderer/core/input-assembler"));

var _meshData = require("../../../mesh/mesh-data");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.
var renderer = require('../../../renderer');

var ParticleBatchModel =
/*#__PURE__*/
function () {
  function ParticleBatchModel() {
    this._capacity = 0;
    this._vertFormat = null;
    this._vertAttrsFloatCount = 0;
    this._mesh = null;
    this._vertCount = 0;
    this._indexCount = 0;
    this._material = null;
    this._capacity = 0;
    this._vertFormat = null;
    this._vertAttrsFloatCount = 0;
    this._mesh = null;
    this._subDatas = [];
    this._subMeshes = [];
  }

  var _proto = ParticleBatchModel.prototype;

  _proto.setCapacity = function setCapacity(capacity) {
    var capChanged = this._capacity !== capacity;
    this._capacity = capacity;

    if (this._inited && capChanged) {
      this._recreateBuffer();
    }
  };

  _proto.setVertexAttributes = function setVertexAttributes(mesh, vfmt) {
    if (this._mesh === mesh && this._vertFormat === vfmt) {
      return;
    }

    this._mesh = mesh;
    this._vertFormat = vfmt;
    this._vertAttrsFloatCount = this._vertFormat._bytes / 4; // number of float
    // rebuid

    this._createParticleData();

    this._inited = true;
  };

  _proto._recreateBuffer = function _recreateBuffer() {
    this._createParticleData();
  };

  _proto._createParticleData = function _createParticleData() {
    this.destroyIAData();
    this._vertCount = 4;
    this._indexCount = 6;
    var vbData = null;
    var ibData = null;
    var vertSize = this._vertFormat._bytes;

    if (this._mesh) {
      var subData = this._mesh._subDatas[0];
      this._vertCount = subData.vData.byteLength / subData.vfm._bytes;
      this._indexCount = subData.iData.byteLength / 2;
      vbData = new Float32Array(vertSize * this._capacity * this._vertCount / 4);
      ibData = new Uint16Array(this._capacity * this._indexCount);

      var posEle = this._vertFormat.element(_gfx["default"].ATTR_TEX_COORD3);

      var normalEle = this._vertFormat.element(_gfx["default"].ATTR_NORMAL);

      var uvEle = this._vertFormat.element(_gfx["default"].ATTR_TEX_COORD);

      var colorEle = this._vertFormat.element(_gfx["default"].ATTR_COLOR1);

      this._mesh.copyAttribute(0, _gfx["default"].ATTR_POSITION, vbData.buffer, vertSize, posEle.offset);

      this._mesh.copyAttribute(0, _gfx["default"].ATTR_NORMAL, vbData.buffer, vertSize, normalEle.offset);

      this._mesh.copyAttribute(0, _gfx["default"].ATTR_UV0, vbData.buffer, vertSize, uvEle.offset);

      if (!this._mesh.copyAttribute(0, _gfx["default"].ATTR_COLOR, vbData.buffer, vertSize, colorEle.offset)) {
        // copy mesh color to ATTR_COLOR1
        var vb = new Uint32Array(vbData.buffer);

        for (var i = 0; i < this._vertCount; ++i) {
          vb[i * this._vertAttrsFloatCount + colorEle.offset / 4] = cc.Color.WHITE._val;
        }
      }

      var vbFloatArray = new Float32Array(vbData.buffer);

      for (var i = 1; i < this._capacity; i++) {
        vbFloatArray.copyWithin(i * vertSize * this._vertCount / 4, 0, vertSize * this._vertCount / 4);
      }

      this._mesh.copyIndices(0, ibData); // indices


      for (var i = 1; i < this._capacity; i++) {
        for (var j = 0; j < this._indexCount; j++) {
          ibData[i * this._indexCount + j] = ibData[j] + i * this._vertCount;
        }
      }
    } else {
      vbData = new Float32Array(vertSize * this._capacity * this._vertCount / 4);
      ibData = new Uint16Array(this._capacity * this._indexCount);
      var dst = 0;

      for (var i = 0; i < this._capacity; ++i) {
        var baseIdx = 4 * i;
        ibData[dst++] = baseIdx;
        ibData[dst++] = baseIdx + 1;
        ibData[dst++] = baseIdx + 2;
        ibData[dst++] = baseIdx + 3;
        ibData[dst++] = baseIdx + 2;
        ibData[dst++] = baseIdx + 1;
      }
    }

    var meshData = new _meshData.MeshData();
    meshData.vData = vbData;
    meshData.iData = ibData;
    meshData.vfm = this._vertFormat;
    meshData.vDirty = true;
    meshData.iDirty = true;
    meshData.enable = true;
    this._subDatas[0] = meshData;

    if (CC_JSB && CC_NATIVERENDERER) {
      meshData.vDirty = true;
    } else {
      var _vb = new _gfx["default"].VertexBuffer(renderer.device, this._vertFormat, _gfx["default"].USAGE_DYNAMIC, vbData);

      var ib = new _gfx["default"].IndexBuffer(renderer.device, _gfx["default"].INDEX_FMT_UINT16, _gfx["default"].USAGE_STATIC, ibData, ibData.length);
      this._subMeshes[0] = new _inputAssembler["default"](_vb, ib);
    }
  };

  _proto.createTrailData = function createTrailData(vfmt, num) {
    if (this._subDatas[1]) {
      return;
    }

    var vertSize = vfmt._bytes;
    var vBuffer = new ArrayBuffer(vertSize * (num + 1) * 2);
    var ibData = new Uint16Array(num * 6);
    var meshData = new _meshData.MeshData();
    meshData.vData = new Float32Array(vBuffer);
    meshData.iData = ibData;
    meshData.vfm = vfmt;
    meshData.vDirty = true;
    meshData.iDirty = true;
    meshData.enable = true;
    this._subDatas[1] = meshData;

    if (CC_JSB && CC_NATIVERENDERER) {
      meshData.vDirty = true;
    } else {
      var vb = new _gfx["default"].VertexBuffer(renderer.device, vfmt, _gfx["default"].USAGE_DYNAMIC, vBuffer);
      var ib = new _gfx["default"].IndexBuffer(renderer.device, _gfx["default"].INDEX_FMT_UINT16, _gfx["default"].USAGE_DYNAMIC, ibData, num * 6);
      this._subMeshes[1] = new _inputAssembler["default"](vb, ib);
    }
  };

  _proto.setModelMaterial = function setModelMaterial(mat) {
    this._material = mat;
  };

  _proto.addParticleVertexData = function addParticleVertexData(index, pvdata) {
    var subData = this._subDatas[0];
    var vData = subData.getVData();
    var uintVData = subData.getVData(Uint32Array);

    if (!this._mesh) {
      var offset = index * this._vertAttrsFloatCount;
      vData[offset++] = pvdata[0].x; // position

      vData[offset++] = pvdata[0].y;
      vData[offset++] = pvdata[0].z;
      vData[offset++] = pvdata[1].x; // uv

      vData[offset++] = pvdata[1].y;
      vData[offset++] = pvdata[1].z; // frame idx

      vData[offset++] = pvdata[2].x; // size

      vData[offset++] = pvdata[2].y;
      vData[offset++] = pvdata[2].z;
      vData[offset++] = pvdata[3].x; // rotation

      vData[offset++] = pvdata[3].y;
      vData[offset++] = pvdata[3].z;
      uintVData[offset++] = pvdata[4]; // color

      if (pvdata[5]) {
        vData[offset++] = pvdata[5].x; // velocity

        vData[offset++] = pvdata[5].y;
        vData[offset++] = pvdata[5].z;
      }
    } else {
      for (var i = 0; i < this._vertCount; i++) {
        var _offset = (index * this._vertCount + i) * this._vertAttrsFloatCount;

        vData[_offset++] = pvdata[0].x; // position

        vData[_offset++] = pvdata[0].y;
        vData[_offset++] = pvdata[0].z;
        _offset += 2;
        vData[_offset++] = pvdata[1].z; // frame idx

        vData[_offset++] = pvdata[2].x; // size

        vData[_offset++] = pvdata[2].y;
        vData[_offset++] = pvdata[2].z;
        vData[_offset++] = pvdata[3].x; // rotation

        vData[_offset++] = pvdata[3].y;
        vData[_offset++] = pvdata[3].z;
        uintVData[_offset++] = pvdata[4]; // color
      }
    }
  };

  _proto._uploadData = function _uploadData() {
    var subDatas = this._subDatas;
    var subMeshes = this._subMeshes;

    for (var i = 0, len = subDatas.length; i < len; i++) {
      var subData = subDatas[i];
      var subMesh = subMeshes[i];

      if (subData.vDirty) {
        var vBuffer = subMesh._vertexBuffer,
            vData = subData.vData;
        vBuffer.update(0, vData);
        subData.vDirty = false;
      }

      if (subData.iDirty) {
        var iBuffer = subMesh._indexBuffer,
            iData = subData.iData;
        iBuffer.update(0, iData);
        subData.iDirty = false;
      }
    }
  };

  _proto.updateIA = function updateIA(index, count, vDirty, iDirty) {
    if (CC_JSB && CC_NATIVERENDERER) return;
    this._subMeshes[index]._count = count;
    var subData = this._subDatas[index];
    subData.vDirty = vDirty;
    subData.iDirty = iDirty;
  };

  _proto.clear = function clear() {
    var subMesh = this._subMeshes[0];

    if (subMesh) {
      subMesh.indexCount = 0;
    }
  };

  _proto.destroy = function destroy() {
    this._subDatas.length = 0;
    var subMeshes = this._subMeshes;

    for (var i = 0, len = subMeshes.length; i < len; i++) {
      var vb = subMeshes[i]._vertexBuffer;

      if (vb) {
        vb.destroy();
      }

      var ib = subMeshes[i]._indexBuffer;

      if (ib) {
        ib.destroy();
      }
    }

    subMeshes.length = 0;
  };

  _proto.destroyIAData = function destroyIAData() {
    if (this._subMeshes[0]) {
      this._subMeshes[0]._vertexBuffer.destroy();

      this._subMeshes[0]._indexBuffer.destroy();

      this._subMeshes[0] = null;
    }

    this._subDatas[0] = null;
  };

  return ParticleBatchModel;
}();

exports["default"] = ParticleBatchModel;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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