
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/particle/particle-system-3d.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _valueTypes = require("../../value-types");

var _utils = require("../../value-types/utils");

var _CCMaterial = _interopRequireDefault(require("../../assets/material/CCMaterial"));

var _colorOvertime = _interopRequireDefault(require("./animator/color-overtime"));

var _curveRange = _interopRequireWildcard(require("./animator/curve-range"));

var _forceOvertime = _interopRequireDefault(require("./animator/force-overtime"));

var _gradientRange = _interopRequireDefault(require("./animator/gradient-range"));

var _limitVelocityOvertime = _interopRequireDefault(require("./animator/limit-velocity-overtime"));

var _rotationOvertime = _interopRequireDefault(require("./animator/rotation-overtime"));

var _sizeOvertime = _interopRequireDefault(require("./animator/size-overtime"));

var _textureAnimation = _interopRequireDefault(require("./animator/texture-animation"));

var _velocityOvertime = _interopRequireDefault(require("./animator/velocity-overtime"));

var _burst = _interopRequireDefault(require("./burst"));

var _shapeModule = _interopRequireDefault(require("./emitter/shape-module"));

var _enum = require("./enum");

var _particleGeneralFunction = require("./particle-general-function");

var _trail = _interopRequireDefault(require("./renderer/trail"));

var _CCMesh = _interopRequireDefault(require("../../mesh/CCMesh"));

var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _dec9, _dec10, _dec11, _dec12, _dec13, _dec14, _dec15, _dec16, _dec17, _dec18, _dec19, _dec20, _dec21, _dec22, _dec23, _dec24, _dec25, _dec26, _dec27, _dec28, _dec29, _dec30, _dec31, _dec32, _dec33, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _descriptor9, _descriptor10, _descriptor11, _descriptor12, _descriptor13, _descriptor14, _descriptor15, _descriptor16, _descriptor17, _descriptor18, _descriptor19, _descriptor20, _descriptor21, _descriptor22, _descriptor23, _descriptor24, _descriptor25, _descriptor26, _descriptor27, _descriptor28, _descriptor29, _descriptor30, _descriptor31, _temp;

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

var _require = require('../../platform/CCClassDecorator'),
    ccclass = _require.ccclass,
    menu = _require.menu,
    property = _require.property,
    executeInEditMode = _require.executeInEditMode,
    executionOrder = _require.executionOrder;

var RenderComponent = require('../../components/CCRenderComponent');

var _world_mat = new _valueTypes.Mat4();

var _module_props = CC_EDITOR && ["_colorOverLifetimeModule", "_shapeModule", "_sizeOvertimeModule", "_velocityOvertimeModule", "_forceOvertimeModule", "_limitVelocityOvertimeModule", "_rotationOvertimeModule", "_textureAnimationModule", "_trailModule"];
/**
 * !#en The ParticleSystem3D Component.
 * !#zh 3D 粒子组件
 * @class ParticleSystem3D
 * @extends RenderComponent
 */


var ParticleSystem3D = (_dec = ccclass('cc.ParticleSystem3D'), _dec2 = menu('i18n:MAIN_MENU.component.renderers/ParticleSystem3D'), _dec3 = executionOrder(99), _dec4 = property({
  animatable: false
}), _dec5 = property({
  animatable: false
}), _dec6 = property({
  type: _enum.Space,
  animatable: false
}), _dec7 = property({
  type: _curveRange["default"]
}), _dec8 = property({
  type: _curveRange["default"]
}), _dec9 = property({
  type: _gradientRange["default"]
}), _dec10 = property({
  type: _enum.Space
}), _dec11 = property({
  type: _curveRange["default"]
}), _dec12 = property({
  type: _curveRange["default"],
  range: [-1, 1]
}), _dec13 = property({
  type: _curveRange["default"],
  range: [-1, 1],
  radian: true
}), _dec14 = property({
  type: _curveRange["default"],
  range: [-1, 1]
}), _dec15 = property({
  type: _curveRange["default"]
}), _dec16 = property({
  type: _curveRange["default"]
}), _dec17 = property({
  type: [_burst["default"]],
  animatable: false
}), _dec18 = property({
  type: [_CCMaterial["default"]],
  displayName: 'Materials',
  visible: false,
  override: true
}), _dec19 = property({
  type: _shapeModule["default"],
  animatable: false
}), _dec20 = property({
  type: _colorOvertime["default"],
  animatable: false
}), _dec21 = property({
  type: _sizeOvertime["default"],
  animatable: false
}), _dec22 = property({
  type: _velocityOvertime["default"],
  animatable: false
}), _dec23 = property({
  type: _forceOvertime["default"],
  animatable: false
}), _dec24 = property({
  type: _limitVelocityOvertime["default"],
  animatable: false
}), _dec25 = property({
  type: _rotationOvertime["default"],
  animatable: false
}), _dec26 = property({
  type: _textureAnimation["default"],
  animatable: false
}), _dec27 = property({
  type: _trail["default"],
  animatable: false
}), _dec28 = property({
  type: _enum.RenderMode,
  animatable: false
}), _dec29 = property({
  animatable: false
}), _dec30 = property({
  animatable: false
}), _dec31 = property({
  type: _CCMesh["default"],
  animatable: false
}), _dec32 = property({
  type: _CCMaterial["default"],
  animatable: false
}), _dec33 = property({
  type: _CCMaterial["default"],
  animatable: false
}), _dec(_class = _dec2(_class = _dec3(_class = executeInEditMode(_class = (_class2 = (_temp =
/*#__PURE__*/
function (_RenderComponent) {
  _inheritsLoose(ParticleSystem3D, _RenderComponent);

  _createClass(ParticleSystem3D, [{
    key: "capacity",

    /**
     * !#en The run time of particle.
     * !#zh 粒子系统运行时间
     * @property {Number} duration
     */

    /**
     * !#en The maximum number of particles that a particle system can generate.
     * !#zh 粒子系统能生成的最大粒子数量
     * @property {Number} capacity
     */
    get: function get() {
      return this._capacity;
    },
    set: function set(val) {
      this._capacity = val;

      if (this._assembler) {
        this._assembler.setCapacity(this._capacity);
      }
    }
    /**
     * !#en Whether the particle system loops.
     * !#zh 粒子系统是否循环播放
     * @property {Boolean} loop
     */

  }, {
    key: "prewarm",

    /**
     * !#en When selected, the particle system will start playing after one round has been played (only effective when loop is enabled).
     * !#zh 选中之后，粒子系统会以已播放完一轮之后的状态开始播放（仅当循环播放启用时有效）
     * @property {Boolean} prewarm
     */
    get: function get() {
      return this._prewarm;
    },
    set: function set(val) {
      if (val === true && this.loop === false) {// console.warn('prewarm only works if loop is also enabled.');
      }

      this._prewarm = val;
    }
  }, {
    key: "simulationSpace",

    /**
     * !#en The coordinate system in which the particle system is located.<br>
     * World coordinates (does not change when the position of other objects changes)<br>
     * Local coordinates (moving as the position of the parent node changes)<br>
     * Custom coordinates (moving with the position of a custom node)
     * !#zh 选择粒子系统所在的坐标系<br>
     * 世界坐标（不随其他物体位置改变而变换）<br>
     * 局部坐标（跟随父节点位置改变而移动）<br>
     * 自定坐标（跟随自定义节点的位置改变而移动）
     * @property {Space} simulationSpace
     */
    get: function get() {
      return this._simulationSpace;
    },
    set: function set(val) {
      if (val !== this._simulationSpace) {
        this._simulationSpace = val;

        this._assembler._updateMaterialParams();

        this._assembler._updateTrailMaterial();
      }
    }
    /**
     * !#en Controlling the update speed of the entire particle system.
     * !#zh 控制整个粒子系统的更新速度。
     * @property {Number} simulationSpeed
     */

  }, {
    key: "materials",
    get: function get() {
      // if we don't create an array copy, the editor will modify the original array directly.
      return this._materials;
    },
    set: function set(val) {
      this._materials = val;

      this._activateMaterial();
    }
  }, {
    key: "shapeModule",

    /**
     * !#en Particle emitter module
     * !#zh 粒子发射器模块
     * @property {ShapeModule} shapeModule
     */
    get: function get() {
      return this._shapeModule;
    },
    set: function set(val) {
      this._shapeModule = val;

      this._shapeModule.onInit(this);
    }
  }, {
    key: "colorOverLifetimeModule",

    /**
     * !#en Color control module
     * !#zh 颜色控制模块
     * @property {ColorOverLifetimeModule} colorOverLifetimeModule
     */
    get: function get() {
      return this._colorOverLifetimeModule;
    },
    set: function set(val) {
      this._colorOverLifetimeModule = val;
    }
  }, {
    key: "sizeOvertimeModule",

    /**
     * !#en Particle size module
     * !#zh 粒子大小模块
     * @property {SizeOvertimeModule} sizeOvertimeModule
     */
    get: function get() {
      return this._sizeOvertimeModule;
    },
    set: function set(val) {
      this._sizeOvertimeModule = val;
    }
  }, {
    key: "velocityOvertimeModule",

    /**
     * !#en Particle speed module
     * !#zh 粒子速度模块
     * @property {VelocityOvertimeModule} velocityOvertimeModule
     */
    get: function get() {
      return this._velocityOvertimeModule;
    },
    set: function set(val) {
      this._velocityOvertimeModule = val;
    }
  }, {
    key: "forceOvertimeModule",

    /**
     * !#en Particle acceleration module
     * !#zh 粒子加速度模块
     * @property {ForceOvertimeModule} forceOvertimeModule
     */
    get: function get() {
      return this._forceOvertimeModule;
    },
    set: function set(val) {
      this._forceOvertimeModule = val;
    }
  }, {
    key: "limitVelocityOvertimeModule",

    /**
     * !#en Particle limit speed module (only CPU particles are supported)
     * !#zh 粒子限制速度模块（只支持 CPU 粒子）
     * @property {LimitVelocityOvertimeModule} limitVelocityOvertimeModule
     */
    get: function get() {
      return this._limitVelocityOvertimeModule;
    },
    set: function set(val) {
      this._limitVelocityOvertimeModule = val;
    }
  }, {
    key: "rotationOvertimeModule",

    /**
     * !#en Particle rotation module
     * !#zh 粒子旋转模块
     * @property {RotationOvertimeModule} rotationOvertimeModule
     */
    get: function get() {
      return this._rotationOvertimeModule;
    },
    set: function set(val) {
      this._rotationOvertimeModule = val;
    }
  }, {
    key: "textureAnimationModule",

    /**
     * !#en Texture Animation Module
     * !#zh 贴图动画模块
     * @property {TextureAnimationModule} textureAnimationModule
     */
    get: function get() {
      return this._textureAnimationModule;
    },
    set: function set(val) {
      this._textureAnimationModule = val;

      this._textureAnimationModule.onInit(this);
    }
  }, {
    key: "trailModule",

    /**
     * !#en Particle Trajectory Module
     * !#zh 粒子轨迹模块
     * @property {TrailModule} trailModule
     */
    get: function get() {
      return this._trailModule;
    },
    set: function set(val) {
      this._trailModule = val;

      this._trailModule.onInit(this);
    }
  }, {
    key: "renderMode",

    /**
     * !#en Particle generation mode
     * !#zh 设定粒子生成模式
     * @property {RenderMode} renderMode
     */
    get: function get() {
      return this._renderMode;
    },
    set: function set(val) {
      if (this._renderMode === val) {
        return;
      }

      this._renderMode = val;

      this._assembler._setVertexAttrib();

      this._assembler._updateModel();

      this._assembler._updateMaterialParams();
    }
  }, {
    key: "velocityScale",

    /**
     * !#en When the particle generation mode is StrecthedBillboard, in the direction of movement of the particles is stretched by velocity magnitude
     * !#zh 在粒子生成方式为 StrecthedBillboard 时,对粒子在运动方向上按速度大小进行拉伸
     * @property {Number} velocityScale
     */
    get: function get() {
      return this._velocityScale;
    },
    set: function set(val) {
      this._velocityScale = val;

      this._assembler._updateMaterialParams();
    }
  }, {
    key: "lengthScale",

    /**
     * !#en When the particle generation method is StrecthedBillboard, the particles are stretched according to the particle size in the direction of motion
     * !#zh 在粒子生成方式为 StrecthedBillboard 时,对粒子在运动方向上按粒子大小进行拉伸
     * @property {Number} lengthScale
     */
    get: function get() {
      return this._lengthScale;
    },
    set: function set(val) {
      this._lengthScale = val;

      this._assembler._updateMaterialParams();
    }
  }, {
    key: "mesh",

    /**
     * !#en Particle model
     * !#zh 粒子模型
     * @property {Mesh} mesh
     */
    get: function get() {
      return this._mesh;
    },
    set: function set(val) {
      this._mesh = val;

      this._assembler._updateModel();
    }
    /**
     * !#en Particle material
     * !#zh 粒子材质
     * @property {Material} particleMaterial
     */

  }, {
    key: "particleMaterial",
    get: function get() {
      return this.getMaterial(0);
    },
    set: function set(val) {
      this.setMaterial(0, val);

      this._onMaterialModified(0, val);
    }
    /**
     * !#en Particle trail material
     * !#zh 粒子轨迹材质
     * @property {Material} trailMaterial
     */

  }, {
    key: "trailMaterial",
    get: function get() {
      return this.getMaterial(1);
    },
    set: function set(val) {
      this.setMaterial(1, val);

      this._onMaterialModified(1, val);
    }
  }]);

  // array of { emitter: ParticleSystem3D, type: 'birth', 'collision' or 'death'}
  function ParticleSystem3D() {
    var _this2;

    _this2 = _RenderComponent.call(this) || this;

    _initializerDefineProperty(_this2, "duration", _descriptor, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "_capacity", _descriptor2, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "loop", _descriptor3, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "playOnAwake", _descriptor4, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "_prewarm", _descriptor5, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "_simulationSpace", _descriptor6, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "simulationSpeed", _descriptor7, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "startDelay", _descriptor8, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "startLifetime", _descriptor9, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "startColor", _descriptor10, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "scaleSpace", _descriptor11, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "startSize", _descriptor12, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "startSpeed", _descriptor13, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "startRotation", _descriptor14, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "gravityModifier", _descriptor15, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "rateOverTime", _descriptor16, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "rateOverDistance", _descriptor17, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "bursts", _descriptor18, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "_shapeModule", _descriptor19, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "_colorOverLifetimeModule", _descriptor20, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "_sizeOvertimeModule", _descriptor21, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "_velocityOvertimeModule", _descriptor22, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "_forceOvertimeModule", _descriptor23, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "_limitVelocityOvertimeModule", _descriptor24, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "_rotationOvertimeModule", _descriptor25, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "_textureAnimationModule", _descriptor26, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "_trailModule", _descriptor27, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "_renderMode", _descriptor28, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "_velocityScale", _descriptor29, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "_lengthScale", _descriptor30, _assertThisInitialized(_this2));

    _initializerDefineProperty(_this2, "_mesh", _descriptor31, _assertThisInitialized(_this2));

    _this2._isPlaying = void 0;
    _this2._isPaused = void 0;
    _this2._isStopped = void 0;
    _this2._isEmitting = void 0;
    _this2._time = void 0;
    _this2._emitRateTimeCounter = void 0;
    _this2._emitRateDistanceCounter = void 0;
    _this2._oldWPos = void 0;
    _this2._curWPos = void 0;
    _this2._customData1 = void 0;
    _this2._customData2 = void 0;
    _this2._subEmitters = void 0;
    _this2.rateOverTime.constant = 10;
    _this2.startLifetime.constant = 5;
    _this2.startSize.constant = 1;
    _this2.startSpeed.constant = 5; // internal status

    _this2._isPlaying = false;
    _this2._isPaused = false;
    _this2._isStopped = true;
    _this2._isEmitting = false;
    _this2._time = 0.0; // playback position in seconds.

    _this2._emitRateTimeCounter = 0.0;
    _this2._emitRateDistanceCounter = 0.0;
    _this2._oldWPos = new _valueTypes.Vec3(0, 0, 0);
    _this2._curWPos = new _valueTypes.Vec3(0, 0, 0);
    _this2._customData1 = new _valueTypes.Vec2(0, 0);
    _this2._customData2 = new _valueTypes.Vec2(0, 0);
    _this2._subEmitters = []; // array of { emitter: ParticleSystemComponent, type: 'birth', 'collision' or 'death'}

    return _this2;
  }

  var _proto = ParticleSystem3D.prototype;

  _proto.onLoad = function onLoad() {
    this._assembler.onInit(this);

    this.shapeModule.onInit(this);
    this.trailModule.onInit(this);
    this.textureAnimationModule.onInit(this);

    this._resetPosition(); // this._system.add(this);

  };

  _proto._onMaterialModified = function _onMaterialModified(index, material) {
    this._assembler._onMaterialModified(index, material);
  };

  _proto._onRebuildPSO = function _onRebuildPSO(index, material) {
    this._assembler._onRebuildPSO(index, material);
  } // TODO: fastforward current particle system by simulating particles over given period of time, then pause it.
  // simulate(time, withChildren, restart, fixedTimeStep) {
  // }

  /**
   * !#en Playing particle effects
   * !#zh 播放粒子效果
   * @method play
   */
  ;

  _proto.play = function play() {
    if (this._isPaused) {
      this._isPaused = false;
    }

    if (this._isStopped) {
      this._isStopped = false;
    }

    this._isPlaying = true;
    this._isEmitting = true;

    this._resetPosition(); // prewarm


    if (this._prewarm) {
      this._prewarmSystem();
    }
  }
  /**
   * !#en Pause particle effect
   * !#zh 暂停播放粒子效果
   * @method pause
   */
  ;

  _proto.pause = function pause() {
    if (this._isStopped) {
      console.warn('pause(): particle system is already stopped.');
      return;
    }

    if (this._isPlaying) {
      this._isPlaying = false;
    }

    this._isPaused = true;
  }
  /**
   * !#en Stop particle effect
   * !#zh 停止播放粒子效果
   * @method stop
   */
  ;

  _proto.stop = function stop() {
    if (this._isPlaying || this._isPaused) {
      this.clear();
    }

    if (this._isPlaying) {
      this._isPlaying = false;
    }

    if (this._isPaused) {
      this._isPaused = false;
    }

    this._time = 0.0;
    this._emitRateTimeCounter = 0.0;
    this._emitRateDistanceCounter = 0.0;
    this._isStopped = true;
  } // remove all particles from current particle system.

  /**
   * !#en Remove all particle effect
   * !#zh 将所有粒子从粒子系统中清除
   * @method clear
   */
  ;

  _proto.clear = function clear() {
    if (this.enabledInHierarchy) {
      this._assembler.clear();

      this.trailModule.clear();
    }
  };

  _proto.getParticleCount = function getParticleCount() {
    return this._assembler.getParticleCount();
  };

  _proto.setCustomData1 = function setCustomData1(x, y) {
    _valueTypes.Vec2.set(this._customData1, x, y);
  };

  _proto.setCustomData2 = function setCustomData2(x, y) {
    _valueTypes.Vec2.set(this._customData2, x, y);
  };

  _proto.onDestroy = function onDestroy() {
    // this._system.remove(this);
    this._assembler.onDestroy();

    this.trailModule.destroy();
  };

  _proto.onEnable = function onEnable() {
    _RenderComponent.prototype.onEnable.call(this);

    if (this.playOnAwake) {
      this.play();
    }

    this._assembler.onEnable();

    this.trailModule.onEnable();
  };

  _proto.onDisable = function onDisable() {
    _RenderComponent.prototype.onDisable.call(this);

    this._assembler.onDisable();

    this.trailModule.onDisable();
  };

  _proto.update = function update(dt) {
    var scaledDeltaTime = dt * this.simulationSpeed;

    if (this._isPlaying) {
      this._time += scaledDeltaTime; // excute emission

      this._emit(scaledDeltaTime); // simulation, update particles.


      if (this._assembler._updateParticles(scaledDeltaTime) === 0 && !this._isEmitting) {
        this.stop();
      } // update render data


      this._assembler.updateParticleBuffer(); // update trail


      if (this.trailModule.enable) {
        this.trailModule.updateTrailBuffer();
      }
    }
  };

  _proto.emit = function emit(count, dt) {
    if (this._simulationSpace === _enum.Space.World) {
      this.node.getWorldMatrix(_world_mat);
    }

    for (var i = 0; i < count; ++i) {
      var particle = this._assembler._getFreeParticle();

      if (particle === null) {
        return;
      }

      var rand = (0, _valueTypes.pseudoRandom)((0, _valueTypes.randomRangeInt)(0, _utils.INT_MAX));

      if (this.shapeModule.enable) {
        this.shapeModule.emit(particle);
      } else {
        _valueTypes.Vec3.set(particle.position, 0, 0, 0);

        _valueTypes.Vec3.copy(particle.velocity, _particleGeneralFunction.particleEmitZAxis);
      }

      if (this.textureAnimationModule.enable) {
        this.textureAnimationModule.init(particle);
      }

      _valueTypes.Vec3.scale(particle.velocity, particle.velocity, this.startSpeed.evaluate(this._time / this.duration, rand));

      switch (this._simulationSpace) {
        case _enum.Space.Local:
          break;

        case _enum.Space.World:
          _valueTypes.Vec3.transformMat4(particle.position, particle.position, _world_mat);

          var worldRot = new _valueTypes.Quat();
          this.node.getWorldRotation(worldRot);

          _valueTypes.Vec3.transformQuat(particle.velocity, particle.velocity, worldRot);

          break;

        case _enum.Space.Custom:
          // TODO:
          break;
      }

      _valueTypes.Vec3.copy(particle.ultimateVelocity, particle.velocity); // apply startRotation. now 2D only.


      _valueTypes.Vec3.set(particle.rotation, 0, 0, this.startRotation.evaluate(this._time / this.duration, rand)); // apply startSize. now 2D only.


      _valueTypes.Vec3.set(particle.startSize, this.startSize.evaluate(this._time / this.duration, rand), 1, 1);

      particle.startSize.y = particle.startSize.x;

      _valueTypes.Vec3.copy(particle.size, particle.startSize); // apply startColor.


      particle.startColor.set(this.startColor.evaluate(this._time / this.duration, rand));
      particle.color.set(particle.startColor); // apply startLifetime.

      particle.startLifetime = this.startLifetime.evaluate(this._time / this.duration, rand) + dt;
      particle.remainingLifetime = particle.startLifetime;
      particle.randomSeed = (0, _valueTypes.randomRangeInt)(0, 233280);

      this._assembler._setNewParticle(particle);
    } // end of particles forLoop.

  } // initialize particle system as though it had already completed a full cycle.
  ;

  _proto._prewarmSystem = function _prewarmSystem() {
    this.startDelay.mode = _curveRange.Mode.Constant; // clear startDelay.

    this.startDelay.constant = 0;
    var dt = 1.0; // should use varying value?

    var cnt = this.duration / dt;

    for (var i = 0; i < cnt; ++i) {
      this._time += dt;

      this._emit(dt);

      this._assembler._updateParticles(dt);
    }
  } // internal function
  ;

  _proto._emit = function _emit(dt) {
    // emit particles.
    var startDelay = this.startDelay.evaluate(0, 1);

    if (this._time > startDelay) {
      if (this._time > this.duration + startDelay) {
        // this._time = startDelay; // delay will not be applied from the second loop.(Unity)
        // this._emitRateTimeCounter = 0.0;
        // this._emitRateDistanceCounter = 0.0;
        if (!this.loop) {
          this._isEmitting = false;
          return;
        }
      } // emit by rateOverTime


      this._emitRateTimeCounter += this.rateOverTime.evaluate(this._time / this.duration, 1) * dt;

      if (this._emitRateTimeCounter > 1 && this._isEmitting) {
        var emitNum = Math.floor(this._emitRateTimeCounter);
        this._emitRateTimeCounter -= emitNum;
        this.emit(emitNum, dt);
      } // emit by rateOverDistance


      this.node.getWorldPosition(this._curWPos);

      var distance = _valueTypes.Vec3.distance(this._curWPos, this._oldWPos);

      _valueTypes.Vec3.copy(this._oldWPos, this._curWPos);

      this._emitRateDistanceCounter += distance * this.rateOverDistance.evaluate(this._time / this.duration, 1);

      if (this._emitRateDistanceCounter > 1 && this._isEmitting) {
        var _emitNum = Math.floor(this._emitRateDistanceCounter);

        this._emitRateDistanceCounter -= _emitNum;
        this.emit(_emitNum, dt);
      } // bursts


      for (var _iterator = this.bursts, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _iterator[Symbol.iterator]();;) {
        var _ref;

        if (_isArray) {
          if (_i >= _iterator.length) break;
          _ref = _iterator[_i++];
        } else {
          _i = _iterator.next();
          if (_i.done) break;
          _ref = _i.value;
        }

        var burst = _ref;
        burst.update(this, dt);
      }
    }
  };

  _proto._activateMaterial = function _activateMaterial() {};

  _proto._resetPosition = function _resetPosition() {
    this.node.getWorldPosition(this._oldWPos);

    _valueTypes.Vec3.copy(this._curWPos, this._oldWPos);
  };

  _proto.addSubEmitter = function addSubEmitter(subEmitter) {
    this._subEmitters.push(subEmitter);
  };

  _proto.removeSubEmitter = function removeSubEmitter(idx) {
    this._subEmitters.splice(this._subEmitters.indexOf(idx), 1);
  };

  _proto.addBurst = function addBurst(burst) {
    this.bursts.push(burst);
  };

  _proto.removeBurst = function removeBurst(idx) {
    this.bursts.splice(this.bursts.indexOf(idx), 1);
  };

  _proto._checkBacth = function _checkBacth() {};

  _createClass(ParticleSystem3D, [{
    key: "isPlaying",
    get: function get() {
      return this._isPlaying;
    }
  }, {
    key: "isPaused",
    get: function get() {
      return this._isPaused;
    }
  }, {
    key: "isStopped",
    get: function get() {
      return this._isStopped;
    }
  }, {
    key: "isEmitting",
    get: function get() {
      return this._isEmitting;
    }
  }, {
    key: "time",
    get: function get() {
      return this._time;
    }
  }]);

  return ParticleSystem3D;
}(RenderComponent), _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "duration", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 5.0;
  }
}), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "_capacity", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 100;
  }
}), _applyDecoratedDescriptor(_class2.prototype, "capacity", [property], Object.getOwnPropertyDescriptor(_class2.prototype, "capacity"), _class2.prototype), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "loop", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return true;
  }
}), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "playOnAwake", [_dec4], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return true;
  }
}), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "_prewarm", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return false;
  }
}), _applyDecoratedDescriptor(_class2.prototype, "prewarm", [_dec5], Object.getOwnPropertyDescriptor(_class2.prototype, "prewarm"), _class2.prototype), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "_simulationSpace", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return _enum.Space.Local;
  }
}), _applyDecoratedDescriptor(_class2.prototype, "simulationSpace", [_dec6], Object.getOwnPropertyDescriptor(_class2.prototype, "simulationSpace"), _class2.prototype), _descriptor7 = _applyDecoratedDescriptor(_class2.prototype, "simulationSpeed", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 1.0;
  }
}), _descriptor8 = _applyDecoratedDescriptor(_class2.prototype, "startDelay", [_dec7], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor9 = _applyDecoratedDescriptor(_class2.prototype, "startLifetime", [_dec8], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor10 = _applyDecoratedDescriptor(_class2.prototype, "startColor", [_dec9], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _gradientRange["default"]();
  }
}), _descriptor11 = _applyDecoratedDescriptor(_class2.prototype, "scaleSpace", [_dec10], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return _enum.Space.Local;
  }
}), _descriptor12 = _applyDecoratedDescriptor(_class2.prototype, "startSize", [_dec11], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor13 = _applyDecoratedDescriptor(_class2.prototype, "startSpeed", [_dec12], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor14 = _applyDecoratedDescriptor(_class2.prototype, "startRotation", [_dec13], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor15 = _applyDecoratedDescriptor(_class2.prototype, "gravityModifier", [_dec14], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor16 = _applyDecoratedDescriptor(_class2.prototype, "rateOverTime", [_dec15], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor17 = _applyDecoratedDescriptor(_class2.prototype, "rateOverDistance", [_dec16], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor18 = _applyDecoratedDescriptor(_class2.prototype, "bursts", [_dec17], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new Array();
  }
}), _applyDecoratedDescriptor(_class2.prototype, "materials", [_dec18], Object.getOwnPropertyDescriptor(_class2.prototype, "materials"), _class2.prototype), _descriptor19 = _applyDecoratedDescriptor(_class2.prototype, "_shapeModule", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _shapeModule["default"]();
  }
}), _applyDecoratedDescriptor(_class2.prototype, "shapeModule", [_dec19], Object.getOwnPropertyDescriptor(_class2.prototype, "shapeModule"), _class2.prototype), _descriptor20 = _applyDecoratedDescriptor(_class2.prototype, "_colorOverLifetimeModule", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _colorOvertime["default"]();
  }
}), _applyDecoratedDescriptor(_class2.prototype, "colorOverLifetimeModule", [_dec20], Object.getOwnPropertyDescriptor(_class2.prototype, "colorOverLifetimeModule"), _class2.prototype), _descriptor21 = _applyDecoratedDescriptor(_class2.prototype, "_sizeOvertimeModule", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _sizeOvertime["default"]();
  }
}), _applyDecoratedDescriptor(_class2.prototype, "sizeOvertimeModule", [_dec21], Object.getOwnPropertyDescriptor(_class2.prototype, "sizeOvertimeModule"), _class2.prototype), _descriptor22 = _applyDecoratedDescriptor(_class2.prototype, "_velocityOvertimeModule", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _velocityOvertime["default"]();
  }
}), _applyDecoratedDescriptor(_class2.prototype, "velocityOvertimeModule", [_dec22], Object.getOwnPropertyDescriptor(_class2.prototype, "velocityOvertimeModule"), _class2.prototype), _descriptor23 = _applyDecoratedDescriptor(_class2.prototype, "_forceOvertimeModule", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _forceOvertime["default"]();
  }
}), _applyDecoratedDescriptor(_class2.prototype, "forceOvertimeModule", [_dec23], Object.getOwnPropertyDescriptor(_class2.prototype, "forceOvertimeModule"), _class2.prototype), _descriptor24 = _applyDecoratedDescriptor(_class2.prototype, "_limitVelocityOvertimeModule", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _limitVelocityOvertime["default"]();
  }
}), _applyDecoratedDescriptor(_class2.prototype, "limitVelocityOvertimeModule", [_dec24], Object.getOwnPropertyDescriptor(_class2.prototype, "limitVelocityOvertimeModule"), _class2.prototype), _descriptor25 = _applyDecoratedDescriptor(_class2.prototype, "_rotationOvertimeModule", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _rotationOvertime["default"]();
  }
}), _applyDecoratedDescriptor(_class2.prototype, "rotationOvertimeModule", [_dec25], Object.getOwnPropertyDescriptor(_class2.prototype, "rotationOvertimeModule"), _class2.prototype), _descriptor26 = _applyDecoratedDescriptor(_class2.prototype, "_textureAnimationModule", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _textureAnimation["default"]();
  }
}), _applyDecoratedDescriptor(_class2.prototype, "textureAnimationModule", [_dec26], Object.getOwnPropertyDescriptor(_class2.prototype, "textureAnimationModule"), _class2.prototype), _descriptor27 = _applyDecoratedDescriptor(_class2.prototype, "_trailModule", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _trail["default"]();
  }
}), _applyDecoratedDescriptor(_class2.prototype, "trailModule", [_dec27], Object.getOwnPropertyDescriptor(_class2.prototype, "trailModule"), _class2.prototype), _descriptor28 = _applyDecoratedDescriptor(_class2.prototype, "_renderMode", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return _enum.RenderMode.Billboard;
  }
}), _applyDecoratedDescriptor(_class2.prototype, "renderMode", [_dec28], Object.getOwnPropertyDescriptor(_class2.prototype, "renderMode"), _class2.prototype), _descriptor29 = _applyDecoratedDescriptor(_class2.prototype, "_velocityScale", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 1;
  }
}), _applyDecoratedDescriptor(_class2.prototype, "velocityScale", [_dec29], Object.getOwnPropertyDescriptor(_class2.prototype, "velocityScale"), _class2.prototype), _descriptor30 = _applyDecoratedDescriptor(_class2.prototype, "_lengthScale", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 1;
  }
}), _applyDecoratedDescriptor(_class2.prototype, "lengthScale", [_dec30], Object.getOwnPropertyDescriptor(_class2.prototype, "lengthScale"), _class2.prototype), _descriptor31 = _applyDecoratedDescriptor(_class2.prototype, "_mesh", [property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return null;
  }
}), _applyDecoratedDescriptor(_class2.prototype, "mesh", [_dec31], Object.getOwnPropertyDescriptor(_class2.prototype, "mesh"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "particleMaterial", [_dec32], Object.getOwnPropertyDescriptor(_class2.prototype, "particleMaterial"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "trailMaterial", [_dec33], Object.getOwnPropertyDescriptor(_class2.prototype, "trailMaterial"), _class2.prototype)), _class2)) || _class) || _class) || _class) || _class);
exports["default"] = ParticleSystem3D;
CC_EDITOR && (ParticleSystem3D.prototype._onBeforeSerialize = function (props) {
  var _this = this;

  return props.filter(function (p) {
    return !_module_props.includes(p) || _this[p].enable;
  });
});
cc.ParticleSystem3D = ParticleSystem3D;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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