
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/particle/curve.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports.evalOptCurve = evalOptCurve;
exports.AnimationCurve = exports.OptimizedKey = exports.Keyframe = void 0;

var _CCEnum = _interopRequireDefault(require("../../platform/CCEnum"));

var _valueTypes = require("../../value-types");

var _CCClassDecorator = require("../../platform/CCClassDecorator");

var _dec, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _temp, _dec2, _dec3, _dec4, _dec5, _class4, _class5, _descriptor5, _descriptor6, _descriptor7, _temp2;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

var LOOK_FORWARD = 3;
var WrapMode = (0, _CCEnum["default"])({
  Default: 0,
  Once: 1,
  Loop: 2,
  PingPong: 3,
  ClampForever: 4
});
var Keyframe = (_dec = (0, _CCClassDecorator.ccclass)('cc.Keyframe'), _dec(_class = (_class2 = (_temp = function Keyframe(time, value, inTangent, outTangent) {
  _initializerDefineProperty(this, "time", _descriptor, this);

  _initializerDefineProperty(this, "value", _descriptor2, this);

  _initializerDefineProperty(this, "inTangent", _descriptor3, this);

  _initializerDefineProperty(this, "outTangent", _descriptor4, this);

  this.time = time || 0;
  this.value = value || 0;
  this.inTangent = inTangent || 0;
  this.outTangent = outTangent || 0;
}, _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "time", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 0;
  }
}), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "value", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 0;
  }
}), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "inTangent", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 0;
  }
}), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "outTangent", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 0;
  }
})), _class2)) || _class);
exports.Keyframe = Keyframe;

var OptimizedKey =
/*#__PURE__*/
function () {
  function OptimizedKey() {
    this.index = 0;
    this.time = 0;
    this.endTime = 0;
    this.coefficient = null;
    this.index = -1;
    this.time = 0;
    this.endTime = 0;
    this.coefficient = new Float32Array(4);
  }

  var _proto = OptimizedKey.prototype;

  _proto.evaluate = function evaluate(T) {
    var t = T - this.time;
    return evalOptCurve(t, this.coefficient);
  };

  return OptimizedKey;
}();

exports.OptimizedKey = OptimizedKey;

function evalOptCurve(t, coefs) {
  return t * (t * (t * coefs[0] + coefs[1]) + coefs[2]) + coefs[3];
}

var defaultKFStart = new Keyframe(0, 1, 0, 0);
var defaultKFEnd = new Keyframe(1, 1, 0, 0);
/**
 * !#en The animation curve of 3d particle.
 * !#zh 3D 粒子动画曲线
 * @class AnimationCurve
 */

var AnimationCurve = (_dec2 = (0, _CCClassDecorator.ccclass)('cc.AnimationCurve'), _dec3 = (0, _CCClassDecorator.property)({
  "default": [],
  type: [Keyframe]
}), _dec4 = (0, _CCClassDecorator.property)({
  type: cc.Enum(WrapMode),
  visible: false
}), _dec5 = (0, _CCClassDecorator.property)({
  type: cc.Enum(WrapMode),
  visible: false
}), _dec2(_class4 = (_class5 = (_temp2 =
/*#__PURE__*/
function () {
  function AnimationCurve(keyFrames) {
    if (keyFrames === void 0) {
      keyFrames = null;
    }

    _initializerDefineProperty(this, "keyFrames", _descriptor5, this);

    _initializerDefineProperty(this, "preWrapMode", _descriptor6, this);

    _initializerDefineProperty(this, "postWrapMode", _descriptor7, this);

    this.cachedKey = null;

    if (keyFrames) {
      this.keyFrames = keyFrames;
    } else {
      this.keyFrames.push(defaultKFStart);
      this.keyFrames.push(defaultKFEnd);
    }

    this.cachedKey = new OptimizedKey();
  }

  var _proto2 = AnimationCurve.prototype;

  _proto2.addKey = function addKey(keyFrame) {
    if (this.keyFrames == null) {
      this.keyFrames = [];
    }

    this.keyFrames.push(keyFrame);
  } // cubic Hermite spline
  ;

  _proto2.evaluate_slow = function evaluate_slow(time) {
    var wrappedTime = time;
    var wrapMode = time < 0 ? this.preWrapMode : this.postWrapMode;
    var startTime = this.keyFrames[0].time;
    var endTime = this.keyFrames[this.keyFrames.length - 1].time;

    switch (wrapMode) {
      case WrapMode.Loop:
        wrappedTime = (0, _valueTypes.repeat)(time - startTime, endTime - startTime) + startTime;
        break;

      case WrapMode.PingPong:
        wrappedTime = (0, _valueTypes.pingPong)(time - startTime, endTime - startTime) + startTime;
        break;

      case WrapMode.ClampForever:
        wrappedTime = (0, _valueTypes.clamp)(time, startTime, endTime);
        break;
    }

    var preKFIndex = 0;

    if (wrappedTime > this.keyFrames[0].time) {
      if (wrappedTime >= this.keyFrames[this.keyFrames.length - 1].time) {
        preKFIndex = this.keyFrames.length - 2;
      } else {
        for (var i = 0; i < this.keyFrames.length - 1; i++) {
          if (wrappedTime >= this.keyFrames[0].time && wrappedTime <= this.keyFrames[i + 1].time) {
            preKFIndex = i;
            break;
          }
        }
      }
    }

    var keyframe0 = this.keyFrames[preKFIndex];
    var keyframe1 = this.keyFrames[preKFIndex + 1];
    var t = (0, _valueTypes.inverseLerp)(keyframe0.time, keyframe1.time, wrappedTime);
    var dt = keyframe1.time - keyframe0.time;
    var m0 = keyframe0.outTangent * dt;
    var m1 = keyframe1.inTangent * dt;
    var t2 = t * t;
    var t3 = t2 * t;
    var a = 2 * t3 - 3 * t2 + 1;
    var b = t3 - 2 * t2 + t;
    var c = t3 - t2;
    var d = -2 * t3 + 3 * t2;
    return a * keyframe0.value + b * m0 + c * m1 + d * keyframe1.value;
  };

  _proto2.evaluate = function evaluate(time) {
    var wrappedTime = time;
    var wrapMode = time < 0 ? this.preWrapMode : this.postWrapMode;
    var startTime = this.keyFrames[0].time;
    var endTime = this.keyFrames[this.keyFrames.length - 1].time;

    switch (wrapMode) {
      case WrapMode.Loop:
        wrappedTime = (0, _valueTypes.repeat)(time - startTime, endTime - startTime) + startTime;
        break;

      case WrapMode.PingPong:
        wrappedTime = (0, _valueTypes.pingPong)(time - startTime, endTime - startTime) + startTime;
        break;

      case WrapMode.ClampForever:
        wrappedTime = (0, _valueTypes.clamp)(time, startTime, endTime);
        break;
    }

    if (wrappedTime >= this.cachedKey.time && wrappedTime < this.cachedKey.endTime) {
      return this.cachedKey.evaluate(wrappedTime);
    } else {
      var leftIndex = this.findIndex(this.cachedKey, wrappedTime);
      var rightIndex = leftIndex + 1;

      if (rightIndex === this.keyFrames.length) {
        rightIndex -= 1;
      }

      this.calcOptimizedKey(this.cachedKey, leftIndex, rightIndex);
      return this.cachedKey.evaluate(wrappedTime);
    }
  };

  _proto2.calcOptimizedKey = function calcOptimizedKey(optKey, leftIndex, rightIndex) {
    var lhs = this.keyFrames[leftIndex];
    var rhs = this.keyFrames[rightIndex];
    optKey.index = leftIndex;
    optKey.time = lhs.time;
    optKey.endTime = rhs.time;
    var dx = rhs.time - lhs.time;
    var dy = rhs.value - lhs.value;
    var length = 1 / (dx * dx);
    var d1 = lhs.outTangent * dx;
    var d2 = rhs.inTangent * dx;
    optKey.coefficient[0] = (d1 + d2 - dy - dy) * length / dx;
    optKey.coefficient[1] = (dy + dy + dy - d1 - d1 - d2) * length;
    optKey.coefficient[2] = lhs.outTangent;
    optKey.coefficient[3] = lhs.value;
  };

  _proto2.findIndex = function findIndex(optKey, t) {
    var cachedIndex = optKey.index;

    if (cachedIndex !== -1) {
      var cachedTime = this.keyFrames[cachedIndex].time;

      if (t > cachedTime) {
        for (var i = 0; i < LOOK_FORWARD; i++) {
          var currIndex = cachedIndex + i;

          if (currIndex + 1 < this.keyFrames.length && this.keyFrames[currIndex + 1].time > t) {
            return currIndex;
          }
        }
      } else {
        for (var _i = 0; _i < LOOK_FORWARD; _i++) {
          var _currIndex = cachedIndex - _i;

          if (_currIndex >= 0 && this.keyFrames[_currIndex - 1].time <= t) {
            return _currIndex - 1;
          }
        }
      }
    }

    var left = 0;
    var right = this.keyFrames.length;
    var mid = Math.floor((left + right) / 2);

    while (right - left > 1) {
      if (this.keyFrames[mid].time >= t) {
        right = mid;
      } else {
        left = mid + 1;
      }

      mid = Math.floor((left + right) / 2);
    }

    return left;
  };

  return AnimationCurve;
}(), _temp2), (_descriptor5 = _applyDecoratedDescriptor(_class5.prototype, "keyFrames", [_dec3], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new Array();
  }
}), _descriptor6 = _applyDecoratedDescriptor(_class5.prototype, "preWrapMode", [_dec4], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return WrapMode.Loop;
  }
}), _descriptor7 = _applyDecoratedDescriptor(_class5.prototype, "postWrapMode", [_dec5], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return WrapMode.Loop;
  }
})), _class5)) || _class4);
exports.AnimationCurve = AnimationCurve;
cc.Keyframe = Keyframe;
cc.AnimationCurve = AnimationCurve;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvY29jb3MyZC9jb3JlLzNkL3BhcnRpY2xlL2N1cnZlLnRzIl0sIm5hbWVzIjpbIkxPT0tfRk9SV0FSRCIsIldyYXBNb2RlIiwiRGVmYXVsdCIsIk9uY2UiLCJMb29wIiwiUGluZ1BvbmciLCJDbGFtcEZvcmV2ZXIiLCJLZXlmcmFtZSIsInRpbWUiLCJ2YWx1ZSIsImluVGFuZ2VudCIsIm91dFRhbmdlbnQiLCJwcm9wZXJ0eSIsIk9wdGltaXplZEtleSIsImluZGV4IiwiZW5kVGltZSIsImNvZWZmaWNpZW50IiwiRmxvYXQzMkFycmF5IiwiZXZhbHVhdGUiLCJUIiwidCIsImV2YWxPcHRDdXJ2ZSIsImNvZWZzIiwiZGVmYXVsdEtGU3RhcnQiLCJkZWZhdWx0S0ZFbmQiLCJBbmltYXRpb25DdXJ2ZSIsInR5cGUiLCJjYyIsIkVudW0iLCJ2aXNpYmxlIiwia2V5RnJhbWVzIiwiY2FjaGVkS2V5IiwicHVzaCIsImFkZEtleSIsImtleUZyYW1lIiwiZXZhbHVhdGVfc2xvdyIsIndyYXBwZWRUaW1lIiwid3JhcE1vZGUiLCJwcmVXcmFwTW9kZSIsInBvc3RXcmFwTW9kZSIsInN0YXJ0VGltZSIsImxlbmd0aCIsInByZUtGSW5kZXgiLCJpIiwia2V5ZnJhbWUwIiwia2V5ZnJhbWUxIiwiZHQiLCJtMCIsIm0xIiwidDIiLCJ0MyIsImEiLCJiIiwiYyIsImQiLCJsZWZ0SW5kZXgiLCJmaW5kSW5kZXgiLCJyaWdodEluZGV4IiwiY2FsY09wdGltaXplZEtleSIsIm9wdEtleSIsImxocyIsInJocyIsImR4IiwiZHkiLCJkMSIsImQyIiwiY2FjaGVkSW5kZXgiLCJjYWNoZWRUaW1lIiwiY3VyckluZGV4IiwibGVmdCIsInJpZ2h0IiwibWlkIiwiTWF0aCIsImZsb29yIiwiQXJyYXkiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBQUE7O0FBQ0E7O0FBQ0E7Ozs7Ozs7Ozs7OztBQUVBLElBQU1BLFlBQVksR0FBRyxDQUFyQjtBQUVBLElBQU1DLFFBQVEsR0FBRyx3QkFBSztBQUNsQkMsRUFBQUEsT0FBTyxFQUFFLENBRFM7QUFFbEJDLEVBQUFBLElBQUksRUFBRSxDQUZZO0FBR2xCQyxFQUFBQSxJQUFJLEVBQUUsQ0FIWTtBQUlsQkMsRUFBQUEsUUFBUSxFQUFFLENBSlE7QUFLbEJDLEVBQUFBLFlBQVksRUFBRTtBQUxJLENBQUwsQ0FBakI7SUFTYUMsbUJBRFosK0JBQVEsYUFBUixxQ0FjRyxrQkFBYUMsSUFBYixFQUFtQkMsS0FBbkIsRUFBMEJDLFNBQTFCLEVBQXFDQyxVQUFyQyxFQUFpRDtBQUFBOztBQUFBOztBQUFBOztBQUFBOztBQUM3QyxPQUFLSCxJQUFMLEdBQVlBLElBQUksSUFBSSxDQUFwQjtBQUNBLE9BQUtDLEtBQUwsR0FBYUEsS0FBSyxJQUFJLENBQXRCO0FBQ0EsT0FBS0MsU0FBTCxHQUFpQkEsU0FBUyxJQUFJLENBQTlCO0FBQ0EsT0FBS0MsVUFBTCxHQUFrQkEsVUFBVSxJQUFJLENBQWhDO0FBQ0gsZ0ZBakJBQzs7Ozs7V0FDTTs7MEVBRU5BOzs7OztXQUNPOzs4RUFFUEE7Ozs7O1dBQ1c7OytFQUVYQTs7Ozs7V0FDWTs7Ozs7SUFVSkM7OztBQU1ULDBCQUFlO0FBQUEsU0FMZkMsS0FLZSxHQUxQLENBS087QUFBQSxTQUpmTixJQUllLEdBSlIsQ0FJUTtBQUFBLFNBSGZPLE9BR2UsR0FITCxDQUdLO0FBQUEsU0FGZkMsV0FFZSxHQUZELElBRUM7QUFDWCxTQUFLRixLQUFMLEdBQWEsQ0FBQyxDQUFkO0FBQ0EsU0FBS04sSUFBTCxHQUFZLENBQVo7QUFDQSxTQUFLTyxPQUFMLEdBQWUsQ0FBZjtBQUNBLFNBQUtDLFdBQUwsR0FBbUIsSUFBSUMsWUFBSixDQUFpQixDQUFqQixDQUFuQjtBQUNIOzs7O1NBRURDLFdBQUEsa0JBQVVDLENBQVYsRUFBYTtBQUNULFFBQU1DLENBQUMsR0FBR0QsQ0FBQyxHQUFHLEtBQUtYLElBQW5CO0FBQ0EsV0FBT2EsWUFBWSxDQUFDRCxDQUFELEVBQUksS0FBS0osV0FBVCxDQUFuQjtBQUNIOzs7Ozs7O0FBR0UsU0FBU0ssWUFBVCxDQUF1QkQsQ0FBdkIsRUFBMEJFLEtBQTFCLEVBQWlDO0FBQ3BDLFNBQVFGLENBQUMsSUFBSUEsQ0FBQyxJQUFJQSxDQUFDLEdBQUdFLEtBQUssQ0FBQyxDQUFELENBQVQsR0FBZUEsS0FBSyxDQUFDLENBQUQsQ0FBeEIsQ0FBRCxHQUFnQ0EsS0FBSyxDQUFDLENBQUQsQ0FBekMsQ0FBRixHQUFtREEsS0FBSyxDQUFDLENBQUQsQ0FBL0Q7QUFDSDs7QUFFRCxJQUFNQyxjQUFjLEdBQUcsSUFBSWhCLFFBQUosQ0FBYSxDQUFiLEVBQWdCLENBQWhCLEVBQW1CLENBQW5CLEVBQXNCLENBQXRCLENBQXZCO0FBQ0EsSUFBTWlCLFlBQVksR0FBRyxJQUFJakIsUUFBSixDQUFhLENBQWIsRUFBZ0IsQ0FBaEIsRUFBbUIsQ0FBbkIsRUFBc0IsQ0FBdEIsQ0FBckI7QUFHQTs7Ozs7O0lBT2FrQiwwQkFGWiwrQkFBUSxtQkFBUixXQUdJLGdDQUFTO0FBQ04sYUFBUyxFQURIO0FBRU5DLEVBQUFBLElBQUksRUFBRSxDQUFDbkIsUUFBRDtBQUZBLENBQVQsV0FNQSxnQ0FBUztBQUNObUIsRUFBQUEsSUFBSSxFQUFFQyxFQUFFLENBQUNDLElBQUgsQ0FBUTNCLFFBQVIsQ0FEQTtBQUVONEIsRUFBQUEsT0FBTyxFQUFFO0FBRkgsQ0FBVCxXQU1BLGdDQUFTO0FBQ05ILEVBQUFBLElBQUksRUFBRUMsRUFBRSxDQUFDQyxJQUFILENBQVEzQixRQUFSLENBREE7QUFFTjRCLEVBQUFBLE9BQU8sRUFBRTtBQUZILENBQVQ7OztBQVFELDBCQUFhQyxTQUFiLEVBQStCO0FBQUEsUUFBbEJBLFNBQWtCO0FBQWxCQSxNQUFBQSxTQUFrQixHQUFOLElBQU07QUFBQTs7QUFBQTs7QUFBQTs7QUFBQTs7QUFBQSxTQUYvQkMsU0FFK0IsR0FGbkIsSUFFbUI7O0FBQzNCLFFBQUlELFNBQUosRUFBZTtBQUNYLFdBQUtBLFNBQUwsR0FBaUJBLFNBQWpCO0FBQ0gsS0FGRCxNQUVPO0FBQ0gsV0FBS0EsU0FBTCxDQUFlRSxJQUFmLENBQW9CVCxjQUFwQjtBQUNBLFdBQUtPLFNBQUwsQ0FBZUUsSUFBZixDQUFvQlIsWUFBcEI7QUFDSDs7QUFDRCxTQUFLTyxTQUFMLEdBQWlCLElBQUlsQixZQUFKLEVBQWpCO0FBQ0g7Ozs7VUFFRG9CLFNBQUEsZ0JBQVFDLFFBQVIsRUFBa0I7QUFDZCxRQUFJLEtBQUtKLFNBQUwsSUFBa0IsSUFBdEIsRUFBNEI7QUFDeEIsV0FBS0EsU0FBTCxHQUFpQixFQUFqQjtBQUNIOztBQUNELFNBQUtBLFNBQUwsQ0FBZUUsSUFBZixDQUFvQkUsUUFBcEI7QUFDSCxJQUVEOzs7VUFDQUMsZ0JBQUEsdUJBQWUzQixJQUFmLEVBQXFCO0FBQ2pCLFFBQUk0QixXQUFXLEdBQUc1QixJQUFsQjtBQUNBLFFBQU02QixRQUFRLEdBQUc3QixJQUFJLEdBQUcsQ0FBUCxHQUFXLEtBQUs4QixXQUFoQixHQUE4QixLQUFLQyxZQUFwRDtBQUNBLFFBQU1DLFNBQVMsR0FBRyxLQUFLVixTQUFMLENBQWUsQ0FBZixFQUFrQnRCLElBQXBDO0FBQ0EsUUFBTU8sT0FBTyxHQUFHLEtBQUtlLFNBQUwsQ0FBZSxLQUFLQSxTQUFMLENBQWVXLE1BQWYsR0FBd0IsQ0FBdkMsRUFBMENqQyxJQUExRDs7QUFDQSxZQUFRNkIsUUFBUjtBQUNJLFdBQUtwQyxRQUFRLENBQUNHLElBQWQ7QUFDSWdDLFFBQUFBLFdBQVcsR0FBRyx3QkFBTzVCLElBQUksR0FBR2dDLFNBQWQsRUFBeUJ6QixPQUFPLEdBQUd5QixTQUFuQyxJQUFnREEsU0FBOUQ7QUFDQTs7QUFDSixXQUFLdkMsUUFBUSxDQUFDSSxRQUFkO0FBQ0krQixRQUFBQSxXQUFXLEdBQUcsMEJBQVM1QixJQUFJLEdBQUdnQyxTQUFoQixFQUEyQnpCLE9BQU8sR0FBR3lCLFNBQXJDLElBQWtEQSxTQUFoRTtBQUNBOztBQUNKLFdBQUt2QyxRQUFRLENBQUNLLFlBQWQ7QUFDSThCLFFBQUFBLFdBQVcsR0FBRyx1QkFBTTVCLElBQU4sRUFBWWdDLFNBQVosRUFBdUJ6QixPQUF2QixDQUFkO0FBQ0E7QUFUUjs7QUFXQSxRQUFJMkIsVUFBVSxHQUFHLENBQWpCOztBQUNBLFFBQUlOLFdBQVcsR0FBRyxLQUFLTixTQUFMLENBQWUsQ0FBZixFQUFrQnRCLElBQXBDLEVBQTBDO0FBQ3RDLFVBQUk0QixXQUFXLElBQUksS0FBS04sU0FBTCxDQUFlLEtBQUtBLFNBQUwsQ0FBZVcsTUFBZixHQUF3QixDQUF2QyxFQUEwQ2pDLElBQTdELEVBQW1FO0FBQy9Ea0MsUUFBQUEsVUFBVSxHQUFHLEtBQUtaLFNBQUwsQ0FBZVcsTUFBZixHQUF3QixDQUFyQztBQUNILE9BRkQsTUFHSztBQUNELGFBQUssSUFBSUUsQ0FBQyxHQUFHLENBQWIsRUFBZ0JBLENBQUMsR0FBRyxLQUFLYixTQUFMLENBQWVXLE1BQWYsR0FBd0IsQ0FBNUMsRUFBK0NFLENBQUMsRUFBaEQsRUFBb0Q7QUFDaEQsY0FBSVAsV0FBVyxJQUFJLEtBQUtOLFNBQUwsQ0FBZSxDQUFmLEVBQWtCdEIsSUFBakMsSUFBeUM0QixXQUFXLElBQUksS0FBS04sU0FBTCxDQUFlYSxDQUFDLEdBQUcsQ0FBbkIsRUFBc0JuQyxJQUFsRixFQUF3RjtBQUNwRmtDLFlBQUFBLFVBQVUsR0FBR0MsQ0FBYjtBQUNBO0FBQ0g7QUFDSjtBQUNKO0FBQ0o7O0FBQ0QsUUFBTUMsU0FBUyxHQUFHLEtBQUtkLFNBQUwsQ0FBZVksVUFBZixDQUFsQjtBQUNBLFFBQU1HLFNBQVMsR0FBRyxLQUFLZixTQUFMLENBQWVZLFVBQVUsR0FBRyxDQUE1QixDQUFsQjtBQUVBLFFBQU10QixDQUFDLEdBQUcsNkJBQVl3QixTQUFTLENBQUNwQyxJQUF0QixFQUE0QnFDLFNBQVMsQ0FBQ3JDLElBQXRDLEVBQTRDNEIsV0FBNUMsQ0FBVjtBQUNBLFFBQU1VLEVBQUUsR0FBR0QsU0FBUyxDQUFDckMsSUFBVixHQUFpQm9DLFNBQVMsQ0FBQ3BDLElBQXRDO0FBRUEsUUFBTXVDLEVBQUUsR0FBR0gsU0FBUyxDQUFDakMsVUFBVixHQUF1Qm1DLEVBQWxDO0FBQ0EsUUFBTUUsRUFBRSxHQUFHSCxTQUFTLENBQUNuQyxTQUFWLEdBQXNCb0MsRUFBakM7QUFFQSxRQUFNRyxFQUFFLEdBQUc3QixDQUFDLEdBQUdBLENBQWY7QUFDQSxRQUFNOEIsRUFBRSxHQUFHRCxFQUFFLEdBQUc3QixDQUFoQjtBQUVBLFFBQU0rQixDQUFDLEdBQUcsSUFBSUQsRUFBSixHQUFTLElBQUlELEVBQWIsR0FBa0IsQ0FBNUI7QUFDQSxRQUFNRyxDQUFDLEdBQUdGLEVBQUUsR0FBRyxJQUFJRCxFQUFULEdBQWM3QixDQUF4QjtBQUNBLFFBQU1pQyxDQUFDLEdBQUdILEVBQUUsR0FBR0QsRUFBZjtBQUNBLFFBQU1LLENBQUMsR0FBRyxDQUFDLENBQUQsR0FBS0osRUFBTCxHQUFVLElBQUlELEVBQXhCO0FBRUEsV0FBT0UsQ0FBQyxHQUFHUCxTQUFTLENBQUNuQyxLQUFkLEdBQXNCMkMsQ0FBQyxHQUFHTCxFQUExQixHQUErQk0sQ0FBQyxHQUFHTCxFQUFuQyxHQUF3Q00sQ0FBQyxHQUFHVCxTQUFTLENBQUNwQyxLQUE3RDtBQUNIOztVQUVEUyxXQUFBLGtCQUFVVixJQUFWLEVBQWdCO0FBQ1osUUFBSTRCLFdBQVcsR0FBRzVCLElBQWxCO0FBQ0EsUUFBTTZCLFFBQVEsR0FBRzdCLElBQUksR0FBRyxDQUFQLEdBQVcsS0FBSzhCLFdBQWhCLEdBQThCLEtBQUtDLFlBQXBEO0FBQ0EsUUFBTUMsU0FBUyxHQUFHLEtBQUtWLFNBQUwsQ0FBZSxDQUFmLEVBQWtCdEIsSUFBcEM7QUFDQSxRQUFNTyxPQUFPLEdBQUcsS0FBS2UsU0FBTCxDQUFlLEtBQUtBLFNBQUwsQ0FBZVcsTUFBZixHQUF3QixDQUF2QyxFQUEwQ2pDLElBQTFEOztBQUNBLFlBQVE2QixRQUFSO0FBQ0ksV0FBS3BDLFFBQVEsQ0FBQ0csSUFBZDtBQUNJZ0MsUUFBQUEsV0FBVyxHQUFHLHdCQUFPNUIsSUFBSSxHQUFHZ0MsU0FBZCxFQUF5QnpCLE9BQU8sR0FBR3lCLFNBQW5DLElBQWdEQSxTQUE5RDtBQUNBOztBQUNKLFdBQUt2QyxRQUFRLENBQUNJLFFBQWQ7QUFDSStCLFFBQUFBLFdBQVcsR0FBRywwQkFBUzVCLElBQUksR0FBR2dDLFNBQWhCLEVBQTJCekIsT0FBTyxHQUFHeUIsU0FBckMsSUFBa0RBLFNBQWhFO0FBQ0E7O0FBQ0osV0FBS3ZDLFFBQVEsQ0FBQ0ssWUFBZDtBQUNJOEIsUUFBQUEsV0FBVyxHQUFHLHVCQUFNNUIsSUFBTixFQUFZZ0MsU0FBWixFQUF1QnpCLE9BQXZCLENBQWQ7QUFDQTtBQVRSOztBQVdBLFFBQUlxQixXQUFXLElBQUksS0FBS0wsU0FBTCxDQUFldkIsSUFBOUIsSUFBc0M0QixXQUFXLEdBQUcsS0FBS0wsU0FBTCxDQUFlaEIsT0FBdkUsRUFBZ0Y7QUFDNUUsYUFBTyxLQUFLZ0IsU0FBTCxDQUFlYixRQUFmLENBQXdCa0IsV0FBeEIsQ0FBUDtBQUNILEtBRkQsTUFFTztBQUNILFVBQU1tQixTQUFTLEdBQUcsS0FBS0MsU0FBTCxDQUFlLEtBQUt6QixTQUFwQixFQUErQkssV0FBL0IsQ0FBbEI7QUFDQSxVQUFJcUIsVUFBVSxHQUFHRixTQUFTLEdBQUcsQ0FBN0I7O0FBQ0EsVUFBSUUsVUFBVSxLQUFLLEtBQUszQixTQUFMLENBQWVXLE1BQWxDLEVBQTBDO0FBQ3RDZ0IsUUFBQUEsVUFBVSxJQUFJLENBQWQ7QUFDSDs7QUFDRCxXQUFLQyxnQkFBTCxDQUFzQixLQUFLM0IsU0FBM0IsRUFBc0N3QixTQUF0QyxFQUFpREUsVUFBakQ7QUFDQSxhQUFPLEtBQUsxQixTQUFMLENBQWViLFFBQWYsQ0FBd0JrQixXQUF4QixDQUFQO0FBQ0g7QUFDSjs7VUFFRHNCLG1CQUFBLDBCQUFrQkMsTUFBbEIsRUFBMEJKLFNBQTFCLEVBQXFDRSxVQUFyQyxFQUFpRDtBQUM3QyxRQUFNRyxHQUFHLEdBQUcsS0FBSzlCLFNBQUwsQ0FBZXlCLFNBQWYsQ0FBWjtBQUNBLFFBQU1NLEdBQUcsR0FBRyxLQUFLL0IsU0FBTCxDQUFlMkIsVUFBZixDQUFaO0FBQ0FFLElBQUFBLE1BQU0sQ0FBQzdDLEtBQVAsR0FBZXlDLFNBQWY7QUFDQUksSUFBQUEsTUFBTSxDQUFDbkQsSUFBUCxHQUFjb0QsR0FBRyxDQUFDcEQsSUFBbEI7QUFDQW1ELElBQUFBLE1BQU0sQ0FBQzVDLE9BQVAsR0FBaUI4QyxHQUFHLENBQUNyRCxJQUFyQjtBQUVBLFFBQU1zRCxFQUFFLEdBQUdELEdBQUcsQ0FBQ3JELElBQUosR0FBV29ELEdBQUcsQ0FBQ3BELElBQTFCO0FBQ0EsUUFBTXVELEVBQUUsR0FBR0YsR0FBRyxDQUFDcEQsS0FBSixHQUFZbUQsR0FBRyxDQUFDbkQsS0FBM0I7QUFDQSxRQUFNZ0MsTUFBTSxHQUFHLEtBQUtxQixFQUFFLEdBQUdBLEVBQVYsQ0FBZjtBQUNBLFFBQU1FLEVBQUUsR0FBR0osR0FBRyxDQUFDakQsVUFBSixHQUFpQm1ELEVBQTVCO0FBQ0EsUUFBTUcsRUFBRSxHQUFHSixHQUFHLENBQUNuRCxTQUFKLEdBQWdCb0QsRUFBM0I7QUFFQUgsSUFBQUEsTUFBTSxDQUFDM0MsV0FBUCxDQUFtQixDQUFuQixJQUF3QixDQUFDZ0QsRUFBRSxHQUFHQyxFQUFMLEdBQVVGLEVBQVYsR0FBZUEsRUFBaEIsSUFBc0J0QixNQUF0QixHQUErQnFCLEVBQXZEO0FBQ0FILElBQUFBLE1BQU0sQ0FBQzNDLFdBQVAsQ0FBbUIsQ0FBbkIsSUFBd0IsQ0FBQytDLEVBQUUsR0FBR0EsRUFBTCxHQUFVQSxFQUFWLEdBQWVDLEVBQWYsR0FBb0JBLEVBQXBCLEdBQXlCQyxFQUExQixJQUFnQ3hCLE1BQXhEO0FBQ0FrQixJQUFBQSxNQUFNLENBQUMzQyxXQUFQLENBQW1CLENBQW5CLElBQXdCNEMsR0FBRyxDQUFDakQsVUFBNUI7QUFDQWdELElBQUFBLE1BQU0sQ0FBQzNDLFdBQVAsQ0FBbUIsQ0FBbkIsSUFBd0I0QyxHQUFHLENBQUNuRCxLQUE1QjtBQUNIOztVQUVEK0MsWUFBQSxtQkFBV0csTUFBWCxFQUFtQnZDLENBQW5CLEVBQXNCO0FBQ2xCLFFBQU04QyxXQUFXLEdBQUdQLE1BQU0sQ0FBQzdDLEtBQTNCOztBQUNBLFFBQUlvRCxXQUFXLEtBQUssQ0FBQyxDQUFyQixFQUF3QjtBQUNwQixVQUFNQyxVQUFVLEdBQUcsS0FBS3JDLFNBQUwsQ0FBZW9DLFdBQWYsRUFBNEIxRCxJQUEvQzs7QUFDQSxVQUFJWSxDQUFDLEdBQUcrQyxVQUFSLEVBQW9CO0FBQ2hCLGFBQUssSUFBSXhCLENBQUMsR0FBRyxDQUFiLEVBQWdCQSxDQUFDLEdBQUczQyxZQUFwQixFQUFrQzJDLENBQUMsRUFBbkMsRUFBdUM7QUFDbkMsY0FBTXlCLFNBQVMsR0FBR0YsV0FBVyxHQUFHdkIsQ0FBaEM7O0FBQ0EsY0FBSXlCLFNBQVMsR0FBRyxDQUFaLEdBQWdCLEtBQUt0QyxTQUFMLENBQWVXLE1BQS9CLElBQXlDLEtBQUtYLFNBQUwsQ0FBZXNDLFNBQVMsR0FBRyxDQUEzQixFQUE4QjVELElBQTlCLEdBQXFDWSxDQUFsRixFQUFxRjtBQUNqRixtQkFBT2dELFNBQVA7QUFDSDtBQUNKO0FBQ0osT0FQRCxNQU9PO0FBQ0gsYUFBSyxJQUFJekIsRUFBQyxHQUFHLENBQWIsRUFBZ0JBLEVBQUMsR0FBRzNDLFlBQXBCLEVBQWtDMkMsRUFBQyxFQUFuQyxFQUF1QztBQUNuQyxjQUFNeUIsVUFBUyxHQUFHRixXQUFXLEdBQUd2QixFQUFoQzs7QUFDQSxjQUFJeUIsVUFBUyxJQUFJLENBQWIsSUFBa0IsS0FBS3RDLFNBQUwsQ0FBZXNDLFVBQVMsR0FBRyxDQUEzQixFQUE4QjVELElBQTlCLElBQXNDWSxDQUE1RCxFQUErRDtBQUMzRCxtQkFBT2dELFVBQVMsR0FBRyxDQUFuQjtBQUNIO0FBQ0o7QUFDSjtBQUNKOztBQUNELFFBQUlDLElBQUksR0FBRyxDQUFYO0FBQ0EsUUFBSUMsS0FBSyxHQUFHLEtBQUt4QyxTQUFMLENBQWVXLE1BQTNCO0FBQ0EsUUFBSThCLEdBQUcsR0FBR0MsSUFBSSxDQUFDQyxLQUFMLENBQVcsQ0FBQ0osSUFBSSxHQUFHQyxLQUFSLElBQWlCLENBQTVCLENBQVY7O0FBQ0EsV0FBT0EsS0FBSyxHQUFHRCxJQUFSLEdBQWUsQ0FBdEIsRUFBeUI7QUFDckIsVUFBSSxLQUFLdkMsU0FBTCxDQUFleUMsR0FBZixFQUFvQi9ELElBQXBCLElBQTRCWSxDQUFoQyxFQUFtQztBQUMvQmtELFFBQUFBLEtBQUssR0FBR0MsR0FBUjtBQUNILE9BRkQsTUFFTztBQUNIRixRQUFBQSxJQUFJLEdBQUdFLEdBQUcsR0FBRyxDQUFiO0FBQ0g7O0FBQ0RBLE1BQUFBLEdBQUcsR0FBR0MsSUFBSSxDQUFDQyxLQUFMLENBQVcsQ0FBQ0osSUFBSSxHQUFHQyxLQUFSLElBQWlCLENBQTVCLENBQU47QUFDSDs7QUFDRCxXQUFPRCxJQUFQO0FBQ0g7Ozs7Ozs7O1dBcEtXLElBQUlLLEtBQUo7Ozs7Ozs7V0FNRXpFLFFBQVEsQ0FBQ0c7Ozs7Ozs7V0FNUkgsUUFBUSxDQUFDRzs7OztBQTJKNUJ1QixFQUFFLENBQUNwQixRQUFILEdBQWNBLFFBQWQ7QUFDQW9CLEVBQUUsQ0FBQ0YsY0FBSCxHQUFvQkEsY0FBcEIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgRW51bSAgZnJvbSAnLi4vLi4vcGxhdGZvcm0vQ0NFbnVtJztcbmltcG9ydCB7IGNsYW1wLCBpbnZlcnNlTGVycCwgcGluZ1BvbmcsIHJlcGVhdCB9IGZyb20gJy4uLy4uL3ZhbHVlLXR5cGVzJztcbmltcG9ydCB7IGNjY2xhc3MgLCBwcm9wZXJ0eX0gZnJvbSAnLi4vLi4vcGxhdGZvcm0vQ0NDbGFzc0RlY29yYXRvcic7XG5cbmNvbnN0IExPT0tfRk9SV0FSRCA9IDM7XG5cbmNvbnN0IFdyYXBNb2RlID0gRW51bSh7XG4gICAgRGVmYXVsdDogMCxcbiAgICBPbmNlOiAxLFxuICAgIExvb3A6IDIsXG4gICAgUGluZ1Bvbmc6IDMsXG4gICAgQ2xhbXBGb3JldmVyOiA0LFxufSk7XG5cbkBjY2NsYXNzKCdjYy5LZXlmcmFtZScpXG5leHBvcnQgY2xhc3MgS2V5ZnJhbWUge1xuICAgIEBwcm9wZXJ0eVxuICAgIHRpbWUgPSAwO1xuXG4gICAgQHByb3BlcnR5XG4gICAgdmFsdWUgPSAwO1xuXG4gICAgQHByb3BlcnR5XG4gICAgaW5UYW5nZW50ID0gMDtcblxuICAgIEBwcm9wZXJ0eVxuICAgIG91dFRhbmdlbnQgPSAwO1xuXG4gICAgY29uc3RydWN0b3IgKHRpbWUsIHZhbHVlLCBpblRhbmdlbnQsIG91dFRhbmdlbnQpIHtcbiAgICAgICAgdGhpcy50aW1lID0gdGltZSB8fCAwO1xuICAgICAgICB0aGlzLnZhbHVlID0gdmFsdWUgfHwgMDtcbiAgICAgICAgdGhpcy5pblRhbmdlbnQgPSBpblRhbmdlbnQgfHwgMDtcbiAgICAgICAgdGhpcy5vdXRUYW5nZW50ID0gb3V0VGFuZ2VudCB8fCAwO1xuICAgIH1cbn1cblxuZXhwb3J0IGNsYXNzIE9wdGltaXplZEtleSB7XG4gICAgaW5kZXggPSAwO1xuICAgIHRpbWUgPSAwO1xuICAgIGVuZFRpbWUgPSAwO1xuICAgIGNvZWZmaWNpZW50ID0gbnVsbDtcblxuICAgIGNvbnN0cnVjdG9yICgpIHtcbiAgICAgICAgdGhpcy5pbmRleCA9IC0xO1xuICAgICAgICB0aGlzLnRpbWUgPSAwO1xuICAgICAgICB0aGlzLmVuZFRpbWUgPSAwO1xuICAgICAgICB0aGlzLmNvZWZmaWNpZW50ID0gbmV3IEZsb2F0MzJBcnJheSg0KTtcbiAgICB9XG5cbiAgICBldmFsdWF0ZSAoVCkge1xuICAgICAgICBjb25zdCB0ID0gVCAtIHRoaXMudGltZTtcbiAgICAgICAgcmV0dXJuIGV2YWxPcHRDdXJ2ZSh0LCB0aGlzLmNvZWZmaWNpZW50KTtcbiAgICB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBldmFsT3B0Q3VydmUgKHQsIGNvZWZzKSB7XG4gICAgcmV0dXJuICh0ICogKHQgKiAodCAqIGNvZWZzWzBdICsgY29lZnNbMV0pICsgY29lZnNbMl0pKSArIGNvZWZzWzNdO1xufVxuXG5jb25zdCBkZWZhdWx0S0ZTdGFydCA9IG5ldyBLZXlmcmFtZSgwLCAxLCAwLCAwKTtcbmNvbnN0IGRlZmF1bHRLRkVuZCA9IG5ldyBLZXlmcmFtZSgxLCAxLCAwLCAwKTtcblxuXG4vKipcbiAqICEjZW4gVGhlIGFuaW1hdGlvbiBjdXJ2ZSBvZiAzZCBwYXJ0aWNsZS5cbiAqICEjemggM0Qg57KS5a2Q5Yqo55S75puy57q/XG4gKiBAY2xhc3MgQW5pbWF0aW9uQ3VydmVcbiAqL1xuQGNjY2xhc3MoJ2NjLkFuaW1hdGlvbkN1cnZlJylcblxuZXhwb3J0IGNsYXNzIEFuaW1hdGlvbkN1cnZlIHtcbiAgICBAcHJvcGVydHkoe1xuICAgICAgICBkZWZhdWx0OiBbXSxcbiAgICAgICAgdHlwZTogW0tleWZyYW1lXSxcbiAgICB9KVxuICAgIGtleUZyYW1lcyA9IG5ldyBBcnJheSgpO1xuICAgIFxuICAgIEBwcm9wZXJ0eSh7XG4gICAgICAgIHR5cGU6IGNjLkVudW0oV3JhcE1vZGUpLFxuICAgICAgICB2aXNpYmxlOiBmYWxzZSxcbiAgICB9KVxuICAgIHByZVdyYXBNb2RlID0gV3JhcE1vZGUuTG9vcDtcblxuICAgIEBwcm9wZXJ0eSh7XG4gICAgICAgIHR5cGU6IGNjLkVudW0oV3JhcE1vZGUpLFxuICAgICAgICB2aXNpYmxlOiBmYWxzZSxcbiAgICB9KVxuICAgIHBvc3RXcmFwTW9kZSA9IFdyYXBNb2RlLkxvb3A7XG5cbiAgICBjYWNoZWRLZXkgPSBudWxsO1xuXG4gICAgY29uc3RydWN0b3IgKGtleUZyYW1lcyA9IG51bGwpIHtcbiAgICAgICAgaWYgKGtleUZyYW1lcykge1xuICAgICAgICAgICAgdGhpcy5rZXlGcmFtZXMgPSBrZXlGcmFtZXNcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIHRoaXMua2V5RnJhbWVzLnB1c2goZGVmYXVsdEtGU3RhcnQpO1xuICAgICAgICAgICAgdGhpcy5rZXlGcmFtZXMucHVzaChkZWZhdWx0S0ZFbmQpO1xuICAgICAgICB9XG4gICAgICAgIHRoaXMuY2FjaGVkS2V5ID0gbmV3IE9wdGltaXplZEtleSgpO1xuICAgIH1cblxuICAgIGFkZEtleSAoa2V5RnJhbWUpIHtcbiAgICAgICAgaWYgKHRoaXMua2V5RnJhbWVzID09IG51bGwpIHtcbiAgICAgICAgICAgIHRoaXMua2V5RnJhbWVzID0gW107XG4gICAgICAgIH1cbiAgICAgICAgdGhpcy5rZXlGcmFtZXMucHVzaChrZXlGcmFtZSk7XG4gICAgfVxuXG4gICAgLy8gY3ViaWMgSGVybWl0ZSBzcGxpbmVcbiAgICBldmFsdWF0ZV9zbG93ICh0aW1lKSB7XG4gICAgICAgIGxldCB3cmFwcGVkVGltZSA9IHRpbWU7XG4gICAgICAgIGNvbnN0IHdyYXBNb2RlID0gdGltZSA8IDAgPyB0aGlzLnByZVdyYXBNb2RlIDogdGhpcy5wb3N0V3JhcE1vZGU7XG4gICAgICAgIGNvbnN0IHN0YXJ0VGltZSA9IHRoaXMua2V5RnJhbWVzWzBdLnRpbWU7XG4gICAgICAgIGNvbnN0IGVuZFRpbWUgPSB0aGlzLmtleUZyYW1lc1t0aGlzLmtleUZyYW1lcy5sZW5ndGggLSAxXS50aW1lO1xuICAgICAgICBzd2l0Y2ggKHdyYXBNb2RlKSB7XG4gICAgICAgICAgICBjYXNlIFdyYXBNb2RlLkxvb3A6XG4gICAgICAgICAgICAgICAgd3JhcHBlZFRpbWUgPSByZXBlYXQodGltZSAtIHN0YXJ0VGltZSwgZW5kVGltZSAtIHN0YXJ0VGltZSkgKyBzdGFydFRpbWU7XG4gICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICBjYXNlIFdyYXBNb2RlLlBpbmdQb25nOlxuICAgICAgICAgICAgICAgIHdyYXBwZWRUaW1lID0gcGluZ1BvbmcodGltZSAtIHN0YXJ0VGltZSwgZW5kVGltZSAtIHN0YXJ0VGltZSkgKyBzdGFydFRpbWU7XG4gICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICBjYXNlIFdyYXBNb2RlLkNsYW1wRm9yZXZlcjpcbiAgICAgICAgICAgICAgICB3cmFwcGVkVGltZSA9IGNsYW1wKHRpbWUsIHN0YXJ0VGltZSwgZW5kVGltZSk7XG4gICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgIH1cbiAgICAgICAgbGV0IHByZUtGSW5kZXggPSAwO1xuICAgICAgICBpZiAod3JhcHBlZFRpbWUgPiB0aGlzLmtleUZyYW1lc1swXS50aW1lKSB7XG4gICAgICAgICAgICBpZiAod3JhcHBlZFRpbWUgPj0gdGhpcy5rZXlGcmFtZXNbdGhpcy5rZXlGcmFtZXMubGVuZ3RoIC0gMV0udGltZSkge1xuICAgICAgICAgICAgICAgIHByZUtGSW5kZXggPSB0aGlzLmtleUZyYW1lcy5sZW5ndGggLSAyO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICAgICAgZm9yIChsZXQgaSA9IDA7IGkgPCB0aGlzLmtleUZyYW1lcy5sZW5ndGggLSAxOyBpKyspIHtcbiAgICAgICAgICAgICAgICAgICAgaWYgKHdyYXBwZWRUaW1lID49IHRoaXMua2V5RnJhbWVzWzBdLnRpbWUgJiYgd3JhcHBlZFRpbWUgPD0gdGhpcy5rZXlGcmFtZXNbaSArIDFdLnRpbWUpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHByZUtGSW5kZXggPSBpO1xuICAgICAgICAgICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgY29uc3Qga2V5ZnJhbWUwID0gdGhpcy5rZXlGcmFtZXNbcHJlS0ZJbmRleF07XG4gICAgICAgIGNvbnN0IGtleWZyYW1lMSA9IHRoaXMua2V5RnJhbWVzW3ByZUtGSW5kZXggKyAxXTtcblxuICAgICAgICBjb25zdCB0ID0gaW52ZXJzZUxlcnAoa2V5ZnJhbWUwLnRpbWUsIGtleWZyYW1lMS50aW1lLCB3cmFwcGVkVGltZSk7XG4gICAgICAgIGNvbnN0IGR0ID0ga2V5ZnJhbWUxLnRpbWUgLSBrZXlmcmFtZTAudGltZTtcblxuICAgICAgICBjb25zdCBtMCA9IGtleWZyYW1lMC5vdXRUYW5nZW50ICogZHQ7XG4gICAgICAgIGNvbnN0IG0xID0ga2V5ZnJhbWUxLmluVGFuZ2VudCAqIGR0O1xuXG4gICAgICAgIGNvbnN0IHQyID0gdCAqIHQ7XG4gICAgICAgIGNvbnN0IHQzID0gdDIgKiB0O1xuXG4gICAgICAgIGNvbnN0IGEgPSAyICogdDMgLSAzICogdDIgKyAxO1xuICAgICAgICBjb25zdCBiID0gdDMgLSAyICogdDIgKyB0O1xuICAgICAgICBjb25zdCBjID0gdDMgLSB0MjtcbiAgICAgICAgY29uc3QgZCA9IC0yICogdDMgKyAzICogdDI7XG5cbiAgICAgICAgcmV0dXJuIGEgKiBrZXlmcmFtZTAudmFsdWUgKyBiICogbTAgKyBjICogbTEgKyBkICoga2V5ZnJhbWUxLnZhbHVlO1xuICAgIH1cblxuICAgIGV2YWx1YXRlICh0aW1lKSB7XG4gICAgICAgIGxldCB3cmFwcGVkVGltZSA9IHRpbWU7XG4gICAgICAgIGNvbnN0IHdyYXBNb2RlID0gdGltZSA8IDAgPyB0aGlzLnByZVdyYXBNb2RlIDogdGhpcy5wb3N0V3JhcE1vZGU7XG4gICAgICAgIGNvbnN0IHN0YXJ0VGltZSA9IHRoaXMua2V5RnJhbWVzWzBdLnRpbWU7XG4gICAgICAgIGNvbnN0IGVuZFRpbWUgPSB0aGlzLmtleUZyYW1lc1t0aGlzLmtleUZyYW1lcy5sZW5ndGggLSAxXS50aW1lO1xuICAgICAgICBzd2l0Y2ggKHdyYXBNb2RlKSB7XG4gICAgICAgICAgICBjYXNlIFdyYXBNb2RlLkxvb3A6XG4gICAgICAgICAgICAgICAgd3JhcHBlZFRpbWUgPSByZXBlYXQodGltZSAtIHN0YXJ0VGltZSwgZW5kVGltZSAtIHN0YXJ0VGltZSkgKyBzdGFydFRpbWU7XG4gICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICBjYXNlIFdyYXBNb2RlLlBpbmdQb25nOlxuICAgICAgICAgICAgICAgIHdyYXBwZWRUaW1lID0gcGluZ1BvbmcodGltZSAtIHN0YXJ0VGltZSwgZW5kVGltZSAtIHN0YXJ0VGltZSkgKyBzdGFydFRpbWU7XG4gICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICBjYXNlIFdyYXBNb2RlLkNsYW1wRm9yZXZlcjpcbiAgICAgICAgICAgICAgICB3cmFwcGVkVGltZSA9IGNsYW1wKHRpbWUsIHN0YXJ0VGltZSwgZW5kVGltZSk7XG4gICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKHdyYXBwZWRUaW1lID49IHRoaXMuY2FjaGVkS2V5LnRpbWUgJiYgd3JhcHBlZFRpbWUgPCB0aGlzLmNhY2hlZEtleS5lbmRUaW1lKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5jYWNoZWRLZXkuZXZhbHVhdGUod3JhcHBlZFRpbWUpO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgY29uc3QgbGVmdEluZGV4ID0gdGhpcy5maW5kSW5kZXgodGhpcy5jYWNoZWRLZXksIHdyYXBwZWRUaW1lKTtcbiAgICAgICAgICAgIGxldCByaWdodEluZGV4ID0gbGVmdEluZGV4ICsgMTtcbiAgICAgICAgICAgIGlmIChyaWdodEluZGV4ID09PSB0aGlzLmtleUZyYW1lcy5sZW5ndGgpIHtcbiAgICAgICAgICAgICAgICByaWdodEluZGV4IC09IDE7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICB0aGlzLmNhbGNPcHRpbWl6ZWRLZXkodGhpcy5jYWNoZWRLZXksIGxlZnRJbmRleCwgcmlnaHRJbmRleCk7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5jYWNoZWRLZXkuZXZhbHVhdGUod3JhcHBlZFRpbWUpO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgY2FsY09wdGltaXplZEtleSAob3B0S2V5LCBsZWZ0SW5kZXgsIHJpZ2h0SW5kZXgpIHtcbiAgICAgICAgY29uc3QgbGhzID0gdGhpcy5rZXlGcmFtZXNbbGVmdEluZGV4XTtcbiAgICAgICAgY29uc3QgcmhzID0gdGhpcy5rZXlGcmFtZXNbcmlnaHRJbmRleF07XG4gICAgICAgIG9wdEtleS5pbmRleCA9IGxlZnRJbmRleDtcbiAgICAgICAgb3B0S2V5LnRpbWUgPSBsaHMudGltZTtcbiAgICAgICAgb3B0S2V5LmVuZFRpbWUgPSByaHMudGltZTtcblxuICAgICAgICBjb25zdCBkeCA9IHJocy50aW1lIC0gbGhzLnRpbWU7XG4gICAgICAgIGNvbnN0IGR5ID0gcmhzLnZhbHVlIC0gbGhzLnZhbHVlO1xuICAgICAgICBjb25zdCBsZW5ndGggPSAxIC8gKGR4ICogZHgpO1xuICAgICAgICBjb25zdCBkMSA9IGxocy5vdXRUYW5nZW50ICogZHg7XG4gICAgICAgIGNvbnN0IGQyID0gcmhzLmluVGFuZ2VudCAqIGR4O1xuXG4gICAgICAgIG9wdEtleS5jb2VmZmljaWVudFswXSA9IChkMSArIGQyIC0gZHkgLSBkeSkgKiBsZW5ndGggLyBkeDtcbiAgICAgICAgb3B0S2V5LmNvZWZmaWNpZW50WzFdID0gKGR5ICsgZHkgKyBkeSAtIGQxIC0gZDEgLSBkMikgKiBsZW5ndGg7XG4gICAgICAgIG9wdEtleS5jb2VmZmljaWVudFsyXSA9IGxocy5vdXRUYW5nZW50O1xuICAgICAgICBvcHRLZXkuY29lZmZpY2llbnRbM10gPSBsaHMudmFsdWU7XG4gICAgfVxuXG4gICAgZmluZEluZGV4IChvcHRLZXksIHQpIHtcbiAgICAgICAgY29uc3QgY2FjaGVkSW5kZXggPSBvcHRLZXkuaW5kZXg7XG4gICAgICAgIGlmIChjYWNoZWRJbmRleCAhPT0gLTEpIHtcbiAgICAgICAgICAgIGNvbnN0IGNhY2hlZFRpbWUgPSB0aGlzLmtleUZyYW1lc1tjYWNoZWRJbmRleF0udGltZTtcbiAgICAgICAgICAgIGlmICh0ID4gY2FjaGVkVGltZSkge1xuICAgICAgICAgICAgICAgIGZvciAobGV0IGkgPSAwOyBpIDwgTE9PS19GT1JXQVJEOyBpKyspIHtcbiAgICAgICAgICAgICAgICAgICAgY29uc3QgY3VyckluZGV4ID0gY2FjaGVkSW5kZXggKyBpO1xuICAgICAgICAgICAgICAgICAgICBpZiAoY3VyckluZGV4ICsgMSA8IHRoaXMua2V5RnJhbWVzLmxlbmd0aCAmJiB0aGlzLmtleUZyYW1lc1tjdXJySW5kZXggKyAxXS50aW1lID4gdCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIGN1cnJJbmRleDtcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgZm9yIChsZXQgaSA9IDA7IGkgPCBMT09LX0ZPUldBUkQ7IGkrKykge1xuICAgICAgICAgICAgICAgICAgICBjb25zdCBjdXJySW5kZXggPSBjYWNoZWRJbmRleCAtIGk7XG4gICAgICAgICAgICAgICAgICAgIGlmIChjdXJySW5kZXggPj0gMCAmJiB0aGlzLmtleUZyYW1lc1tjdXJySW5kZXggLSAxXS50aW1lIDw9IHQpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBjdXJySW5kZXggLSAxO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIGxldCBsZWZ0ID0gMDtcbiAgICAgICAgbGV0IHJpZ2h0ID0gdGhpcy5rZXlGcmFtZXMubGVuZ3RoO1xuICAgICAgICBsZXQgbWlkID0gTWF0aC5mbG9vcigobGVmdCArIHJpZ2h0KSAvIDIpO1xuICAgICAgICB3aGlsZSAocmlnaHQgLSBsZWZ0ID4gMSkge1xuICAgICAgICAgICAgaWYgKHRoaXMua2V5RnJhbWVzW21pZF0udGltZSA+PSB0KSB7XG4gICAgICAgICAgICAgICAgcmlnaHQgPSBtaWQ7XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIGxlZnQgPSBtaWQgKyAxO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgbWlkID0gTWF0aC5mbG9vcigobGVmdCArIHJpZ2h0KSAvIDIpO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiBsZWZ0O1xuICAgIH1cbn1cblxuY2MuS2V5ZnJhbWUgPSBLZXlmcmFtZTtcbmNjLkFuaW1hdGlvbkN1cnZlID0gQW5pbWF0aW9uQ3VydmU7Il0sInNvdXJjZVJvb3QiOiIvIn0=