
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/particle/burst.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _CCClassDecorator = require("../../platform/CCClassDecorator");

var _valueTypes = require("../../value-types");

var _curveRange = _interopRequireDefault(require("./animator/curve-range"));

var _dec, _dec2, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _temp;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

var Burst = (
/**
 * !#en The burst of 3d particle.
 * !#zh 3D 粒子发射时的爆发个数
 * @class Burst
 */
_dec = (0, _CCClassDecorator.ccclass)('cc.Burst'), _dec2 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"]
}), _dec(_class = (_class2 = (_temp =
/*#__PURE__*/
function () {
  _createClass(Burst, [{
    key: "time",

    /**
     * !#en Time between the start of the particle system and the trigger of this Brust
     * !#zh 粒子系统开始运行到触发此次 Brust 的时间
     * @property {Number} time
     */
    get: function get() {
      return this._time;
    },
    set: function set(val) {
      this._time = val;
      this._curTime = val;
    }
    /**
     * !#en Minimum number of emitted particles
     * !#zh 发射粒子的最小数量
     * @property {Number} minCount
     */

  }, {
    key: "repeatCount",

    /**
     * !#en The number of times Burst was triggered.
     * !#zh Burst 的触发次数
     * @property {Number} repeatCount
     */
    get: function get() {
      return this._repeatCount;
    },
    set: function set(val) {
      this._repeatCount = val;
      this._remainingCount = val;
    }
    /**
     * !#en Interval of each trigger
     * !#zh 每次触发的间隔时间
     * @property {Number} repeatInterval
     */

  }]);

  function Burst() {
    _initializerDefineProperty(this, "_time", _descriptor, this);

    _initializerDefineProperty(this, "minCount", _descriptor2, this);

    _initializerDefineProperty(this, "maxCount", _descriptor3, this);

    _initializerDefineProperty(this, "_repeatCount", _descriptor4, this);

    _initializerDefineProperty(this, "repeatInterval", _descriptor5, this);

    _initializerDefineProperty(this, "count", _descriptor6, this);

    this._remainingCount = 0;
    this._curTime = 0;
    this._remainingCount = 0;
    this._curTime = 0.0;
  }

  var _proto = Burst.prototype;

  _proto.update = function update(psys, dt) {
    if (this._remainingCount === 0) {
      this._remainingCount = this._repeatCount;
      this._curTime = this._time;
    }

    if (this._remainingCount > 0) {
      var preFrameTime = (0, _valueTypes.repeat)(psys._time - psys.startDelay.evaluate(0, 1), psys.duration) - dt;
      preFrameTime = preFrameTime > 0.0 ? preFrameTime : 0.0;
      var curFrameTime = (0, _valueTypes.repeat)(psys.time - psys.startDelay.evaluate(0, 1), psys.duration);

      if (this._curTime >= preFrameTime && this._curTime < curFrameTime) {
        psys.emit(this.count.evaluate(this._curTime / psys.duration, 1), dt - (curFrameTime - this._curTime));
        this._curTime += this.repeatInterval;
        --this._remainingCount;
      }
    }
  };

  _proto.getMaxCount = function getMaxCount(psys) {
    return this.count.getMax() * Math.min(Math.ceil(psys.duration / this.repeatInterval), this.repeatCount);
  };

  return Burst;
}(), _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "_time", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 0;
  }
}), _applyDecoratedDescriptor(_class2.prototype, "time", [_CCClassDecorator.property], Object.getOwnPropertyDescriptor(_class2.prototype, "time"), _class2.prototype), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "minCount", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 30;
  }
}), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "maxCount", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 30;
  }
}), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "_repeatCount", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 1;
  }
}), _applyDecoratedDescriptor(_class2.prototype, "repeatCount", [_CCClassDecorator.property], Object.getOwnPropertyDescriptor(_class2.prototype, "repeatCount"), _class2.prototype), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "repeatInterval", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 1;
  }
}), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "count", [_dec2], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
})), _class2)) || _class);
exports["default"] = Burst;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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