
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/particle/animator/velocity-overtime.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _CCClassDecorator = require("../../../platform/CCClassDecorator");

var _valueTypes = require("../../../value-types");

var _enum = require("../enum");

var _particleGeneralFunction = require("../particle-general-function");

var _curveRange = _interopRequireDefault(require("./curve-range"));

var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _temp;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

// tslint:disable: max-line-length
var VELOCITY_OVERTIME_RAND_OFFSET = 197866;

var _temp_v3 = cc.v3();
/**
 * !#en The velocity module of 3d particle.
 * !#zh 3D 粒子的速度模块
 * @class VelocityOvertimeModule
 */


var VelocityOvertimeModule = (_dec = (0, _CCClassDecorator.ccclass)('cc.VelocityOvertimeModule'), _dec2 = (0, _CCClassDecorator.property)({
  type: _enum.Space
}), _dec3 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"],
  range: [-1, 1]
}), _dec4 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"],
  range: [-1, 1]
}), _dec5 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"],
  range: [-1, 1]
}), _dec6 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"],
  range: [-1, 1]
}), _dec(_class = (_class2 = (_temp =
/*#__PURE__*/
function () {
  /**
   * !#en The enable of VelocityOvertimeModule.
   * !#zh 是否启用
   * @property {Boolean} enable
   */

  /**
   * !#en Coordinate system used in speed calculation.
   * !#zh 速度计算时采用的坐标系。
   * @property {Space} space
   */

  /**
   * !#en Velocity component in X axis direction
   * !#zh X 轴方向上的速度分量。
   * @property {CurveRange} x
   */

  /**
   * !#en Velocity component in Y axis direction
   * !#zh Y 轴方向上的速度分量。
   * @property {CurveRange} y
   */

  /**
   * !#en Velocity component in Z axis direction
   * !#zh Z 轴方向上的速度分量。
   * @property {CurveRange} z
   */

  /**
   * !#en Speed correction factor (only supports CPU particles).
   * !#zh 速度修正系数（只支持 CPU 粒子）。
   * @property {CurveRange} speedModifier
   */
  function VelocityOvertimeModule() {
    _initializerDefineProperty(this, "enable", _descriptor, this);

    _initializerDefineProperty(this, "space", _descriptor2, this);

    _initializerDefineProperty(this, "x", _descriptor3, this);

    _initializerDefineProperty(this, "y", _descriptor4, this);

    _initializerDefineProperty(this, "z", _descriptor5, this);

    _initializerDefineProperty(this, "speedModifier", _descriptor6, this);

    this.rotation = null;
    this.needTransform = false;
    this.rotation = new _valueTypes.Quat();
    this.speedModifier.constant = 1;
    this.needTransform = false;
  }

  var _proto = VelocityOvertimeModule.prototype;

  _proto.update = function update(space, worldTransform) {
    this.needTransform = (0, _particleGeneralFunction.calculateTransform)(space, this.space, worldTransform, this.rotation);
  };

  _proto.animate = function animate(p) {
    var normalizedTime = 1 - p.remainingLifetime / p.startLifetime;

    var vel = _valueTypes.Vec3.set(_temp_v3, this.x.evaluate(normalizedTime, (0, _valueTypes.pseudoRandom)(p.randomSeed + VELOCITY_OVERTIME_RAND_OFFSET)), this.y.evaluate(normalizedTime, (0, _valueTypes.pseudoRandom)(p.randomSeed + VELOCITY_OVERTIME_RAND_OFFSET)), this.z.evaluate(normalizedTime, (0, _valueTypes.pseudoRandom)(p.randomSeed + VELOCITY_OVERTIME_RAND_OFFSET)));

    if (this.needTransform) {
      _valueTypes.Vec3.transformQuat(vel, vel, this.rotation);
    }

    _valueTypes.Vec3.add(p.animatedVelocity, p.animatedVelocity, vel);

    _valueTypes.Vec3.add(p.ultimateVelocity, p.velocity, p.animatedVelocity);

    _valueTypes.Vec3.scale(p.ultimateVelocity, p.ultimateVelocity, this.speedModifier.evaluate(1 - p.remainingLifetime / p.startLifetime, (0, _valueTypes.pseudoRandom)(p.randomSeed + VELOCITY_OVERTIME_RAND_OFFSET)));
  };

  return VelocityOvertimeModule;
}(), _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "enable", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return false;
  }
}), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "space", [_dec2], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return _enum.Space.Local;
  }
}), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "x", [_dec3], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "y", [_dec4], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "z", [_dec5], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "speedModifier", [_dec6], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
})), _class2)) || _class);
exports["default"] = VelocityOvertimeModule;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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