
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/particle/animator/texture-animation.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _CCClassDecorator = require("../../../platform/CCClassDecorator");

var _CCEnum = _interopRequireDefault(require("../../../platform/CCEnum"));

var _valueTypes = require("../../../value-types");

var _curveRange = _interopRequireDefault(require("./curve-range"));

var _dec, _dec2, _dec3, _dec4, _dec5, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _descriptor9, _descriptor10, _temp;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

// tslint:disable: max-line-length
var TEXTURE_ANIMATION_RAND_OFFSET = 90794;
/**
 * 粒子贴图动画类型
 * @enum textureAnimationModule.Mode
 */

var Mode = (0, _CCEnum["default"])({
  /**
   * 网格类型
   */
  Grid: 0
  /**
   * 精灵类型（暂未支持）
   */
  //Sprites: 1,

});
/**
 * 贴图动画的播放方式
 * @enum textureAnimationModule.Animation
 */

var Animation = (0, _CCEnum["default"])({
  /**
   * 播放贴图中的所有帧
   */
  WholeSheet: 0,

  /**
   * 播放贴图中的其中一行动画
   */
  SingleRow: 1
});
/**
 * !#en The texture animation module of 3d particle.
 * !#zh 3D 粒子的贴图动画模块
 * @class TextureAnimationModule
 */

var TextureAnimationModule = (_dec = (0, _CCClassDecorator.ccclass)('cc.TextureAnimationModule'), _dec2 = (0, _CCClassDecorator.property)({
  type: Mode
}), _dec3 = (0, _CCClassDecorator.property)({
  type: Animation
}), _dec4 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"]
}), _dec5 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"]
}), _dec(_class = (_class2 = (_temp =
/*#__PURE__*/
function () {
  function TextureAnimationModule() {
    _initializerDefineProperty(this, "_enable", _descriptor, this);

    _initializerDefineProperty(this, "_mode", _descriptor2, this);

    _initializerDefineProperty(this, "numTilesX", _descriptor3, this);

    _initializerDefineProperty(this, "numTilesY", _descriptor4, this);

    _initializerDefineProperty(this, "animation", _descriptor5, this);

    _initializerDefineProperty(this, "randomRow", _descriptor6, this);

    _initializerDefineProperty(this, "rowIndex", _descriptor7, this);

    _initializerDefineProperty(this, "frameOverTime", _descriptor8, this);

    _initializerDefineProperty(this, "startFrame", _descriptor9, this);

    _initializerDefineProperty(this, "cycleCount", _descriptor10, this);

    this._flipU = 0;
    this._flipV = 0;
    this._uvChannelMask = -1;
    this.ps = null;
  }

  var _proto = TextureAnimationModule.prototype;

  _proto.onInit = function onInit(ps) {
    this.ps = ps;
  };

  _proto.init = function init(p) {
    p.startRow = Math.floor(Math.random() * this.numTilesY);
  };

  _proto.animate = function animate(p) {
    var normalizedTime = 1 - p.remainingLifetime / p.startLifetime;
    var startFrame = this.startFrame.evaluate(normalizedTime, (0, _valueTypes.pseudoRandom)(p.randomSeed + TEXTURE_ANIMATION_RAND_OFFSET)) / (this.numTilesX * this.numTilesY);

    if (this.animation === Animation.WholeSheet) {
      p.frameIndex = (0, _valueTypes.repeat)(this.cycleCount * (this.frameOverTime.evaluate(normalizedTime, (0, _valueTypes.pseudoRandom)(p.randomSeed + TEXTURE_ANIMATION_RAND_OFFSET)) + startFrame), 1);
    } else if (this.animation === Animation.SingleRow) {
      var rowLength = 1 / this.numTilesY;

      if (this.randomRow) {
        var f = (0, _valueTypes.repeat)(this.cycleCount * (this.frameOverTime.evaluate(normalizedTime, (0, _valueTypes.pseudoRandom)(p.randomSeed + TEXTURE_ANIMATION_RAND_OFFSET)) + startFrame), 1);
        var from = p.startRow * rowLength;
        var to = from + rowLength;
        p.frameIndex = (0, _valueTypes.lerp)(from, to, f);
      } else {
        var _from = this.rowIndex * rowLength;

        var _to = _from + rowLength;

        p.frameIndex = (0, _valueTypes.lerp)(_from, _to, (0, _valueTypes.repeat)(this.cycleCount * (this.frameOverTime.evaluate(normalizedTime, (0, _valueTypes.pseudoRandom)(p.randomSeed + TEXTURE_ANIMATION_RAND_OFFSET)) + startFrame), 1));
      }
    }
  };

  _createClass(TextureAnimationModule, [{
    key: "enable",

    /**
     * !#en The enable of TextureAnimationModule.
     * !#zh 是否启用
     * @property {Boolean} enable
     */
    get: function get() {
      return this._enable;
    },
    set: function set(val) {
      this._enable = val;

      this.ps._assembler._updateMaterialParams();
    }
  }, {
    key: "mode",

    /**
     * !#en Set the type of particle map animation (only supports Grid mode for the time being)
     * !#zh 设定粒子贴图动画的类型（暂只支持 Grid 模式。
     * @property {Mode} mode
     */
    get: function get() {
      return this._mode;
    },
    set: function set(val) {
      if (val !== Mode.Grid) {
        console.error('particle texture animation\'s sprites is not supported!');
        return;
      }
    }
    /**
     * !#en Animation frames in X direction.
     * !#zh X 方向动画帧数。
     * @property {Number} numTilesX
     */

  }, {
    key: "flipU",
    get: function get() {
      return this._flipU;
    },
    set: function set(val) {
      console.error('particle texture animation\'s flipU is not supported!');
    }
  }, {
    key: "flipV",
    get: function get() {
      return this._flipV;
    },
    set: function set(val) {
      console.error('particle texture animation\'s flipV is not supported!');
    }
  }, {
    key: "uvChannelMask",
    get: function get() {
      return this._uvChannelMask;
    },
    set: function set(val) {
      console.error('particle texture animation\'s uvChannelMask is not supported!');
    }
  }]);

  return TextureAnimationModule;
}(), _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "_enable", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return false;
  }
}), _applyDecoratedDescriptor(_class2.prototype, "enable", [_CCClassDecorator.property], Object.getOwnPropertyDescriptor(_class2.prototype, "enable"), _class2.prototype), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "_mode", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return Mode.Grid;
  }
}), _applyDecoratedDescriptor(_class2.prototype, "mode", [_dec2], Object.getOwnPropertyDescriptor(_class2.prototype, "mode"), _class2.prototype), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "numTilesX", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 0;
  }
}), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "numTilesY", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 0;
  }
}), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "animation", [_dec3], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return Animation.WholeSheet;
  }
}), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "randomRow", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return false;
  }
}), _descriptor7 = _applyDecoratedDescriptor(_class2.prototype, "rowIndex", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 0;
  }
}), _descriptor8 = _applyDecoratedDescriptor(_class2.prototype, "frameOverTime", [_dec4], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor9 = _applyDecoratedDescriptor(_class2.prototype, "startFrame", [_dec5], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor10 = _applyDecoratedDescriptor(_class2.prototype, "cycleCount", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 0;
  }
}), _applyDecoratedDescriptor(_class2.prototype, "flipU", [_CCClassDecorator.property], Object.getOwnPropertyDescriptor(_class2.prototype, "flipU"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "flipV", [_CCClassDecorator.property], Object.getOwnPropertyDescriptor(_class2.prototype, "flipV"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "uvChannelMask", [_CCClassDecorator.property], Object.getOwnPropertyDescriptor(_class2.prototype, "uvChannelMask"), _class2.prototype)), _class2)) || _class);
exports["default"] = TextureAnimationModule;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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