
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/particle/animator/size-overtime.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _CCClassDecorator = require("../../../platform/CCClassDecorator");

var _valueTypes = require("../../../value-types");

var _curveRange = _interopRequireDefault(require("./curve-range"));

var _dec, _dec2, _dec3, _dec4, _dec5, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _temp;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

// tslint:disable: max-line-length
var SIZE_OVERTIME_RAND_OFFSET = 39825;
/**
 * !#en The size module of 3d particle.
 * !#zh 3D 粒子的大小模块
 * @class SizeOvertimeModule
 */

var SizeOvertimeModule = (_dec = (0, _CCClassDecorator.ccclass)('cc.SizeOvertimeModule'), _dec2 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"]
}), _dec3 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"]
}), _dec4 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"]
}), _dec5 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"]
}), _dec(_class = (_class2 = (_temp =
/*#__PURE__*/
function () {
  function SizeOvertimeModule() {
    _initializerDefineProperty(this, "enable", _descriptor, this);

    _initializerDefineProperty(this, "separateAxes", _descriptor2, this);

    _initializerDefineProperty(this, "size", _descriptor3, this);

    _initializerDefineProperty(this, "x", _descriptor4, this);

    _initializerDefineProperty(this, "y", _descriptor5, this);

    _initializerDefineProperty(this, "z", _descriptor6, this);
  }

  var _proto = SizeOvertimeModule.prototype;

  _proto.animate = function animate(particle) {
    if (!this.separateAxes) {
      _valueTypes.Vec3.scale(particle.size, particle.startSize, this.size.evaluate(1 - particle.remainingLifetime / particle.startLifetime, (0, _valueTypes.pseudoRandom)(particle.randomSeed + SIZE_OVERTIME_RAND_OFFSET)));
    } else {
      var currLifetime = 1 - particle.remainingLifetime / particle.startLifetime;
      var sizeRand = (0, _valueTypes.pseudoRandom)(particle.randomSeed + SIZE_OVERTIME_RAND_OFFSET);
      particle.size.x = particle.startSize.x * this.x.evaluate(currLifetime, sizeRand);
      particle.size.y = particle.startSize.y * this.y.evaluate(currLifetime, sizeRand);
      particle.size.z = particle.startSize.z * this.z.evaluate(currLifetime, sizeRand);
    }
  };

  return SizeOvertimeModule;
}(), _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "enable", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return false;
  }
}), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "separateAxes", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return false;
  }
}), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "size", [_dec2], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "x", [_dec3], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "y", [_dec4], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "z", [_dec5], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
})), _class2)) || _class);
exports["default"] = SizeOvertimeModule;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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