
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/particle/animator/rotation-overtime.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _CCClassDecorator = require("../../../platform/CCClassDecorator");

var _valueTypes = require("../../../value-types");

var _curveRange = _interopRequireDefault(require("./curve-range"));

var _dec, _dec2, _dec3, _dec4, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _temp;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

// tslint:disable: max-line-length
var ROTATION_OVERTIME_RAND_OFFSET = 125292;
/**
 * !#en The rotation module of 3d particle.
 * !#zh 3D 粒子的旋转模块
 * @class RotationOvertimeModule
 */

var RotationOvertimeModule = (_dec = (0, _CCClassDecorator.ccclass)('cc.RotationOvertimeModule'), _dec2 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"],
  range: [-1, 1],
  radian: true
}), _dec3 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"],
  range: [-1, 1],
  radian: true
}), _dec4 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"],
  range: [-1, 1],
  radian: true
}), _dec(_class = (_class2 = (_temp =
/*#__PURE__*/
function () {
  _createClass(RotationOvertimeModule, [{
    key: "separateAxes",

    /**
     * !#en The enable of RotationOvertimeModule.
     * !#zh 是否启用
     * @property {Boolean} enable
     */

    /**
     * !#en Whether to set the rotation of three axes separately (not currently supported)
     * !#zh 是否三个轴分开设定旋转（暂不支持）。
     * @property {Boolean} separateAxes
     */
    get: function get() {
      return this._separateAxes;
    },
    set: function set(val) {
      if (!val) {
        this._separateAxes = val;
      } else {
        console.error('rotation overtime separateAxes is not supported!');
      }
    }
    /**
     * !#en Set rotation around X axis.
     * !#zh 绕 X 轴设定旋转。
     * @property {CurveRange} x
     */

  }]);

  function RotationOvertimeModule() {
    _initializerDefineProperty(this, "enable", _descriptor, this);

    _initializerDefineProperty(this, "_separateAxes", _descriptor2, this);

    _initializerDefineProperty(this, "x", _descriptor3, this);

    _initializerDefineProperty(this, "y", _descriptor4, this);

    _initializerDefineProperty(this, "z", _descriptor5, this);
  }

  var _proto = RotationOvertimeModule.prototype;

  _proto.animate = function animate(p, dt) {
    var normalizedTime = 1 - p.remainingLifetime / p.startLifetime;

    if (!this._separateAxes) {
      p.rotation.x += this.z.evaluate(normalizedTime, (0, _valueTypes.pseudoRandom)(p.randomSeed + ROTATION_OVERTIME_RAND_OFFSET)) * dt;
    } else {
      // TODO: separateAxes is temporarily not supported!
      var rotationRand = (0, _valueTypes.pseudoRandom)(p.randomSeed + ROTATION_OVERTIME_RAND_OFFSET);
      p.rotation.x += this.x.evaluate(normalizedTime, rotationRand) * dt;
      p.rotation.y += this.y.evaluate(normalizedTime, rotationRand) * dt;
      p.rotation.z += this.z.evaluate(normalizedTime, rotationRand) * dt;
    }
  };

  return RotationOvertimeModule;
}(), _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "enable", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return false;
  }
}), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "_separateAxes", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return false;
  }
}), _applyDecoratedDescriptor(_class2.prototype, "separateAxes", [_CCClassDecorator.property], Object.getOwnPropertyDescriptor(_class2.prototype, "separateAxes"), _class2.prototype), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "x", [_dec2], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "y", [_dec3], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "z", [_dec4], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
})), _class2)) || _class);
exports["default"] = RotationOvertimeModule;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvY29jb3MyZC9jb3JlLzNkL3BhcnRpY2xlL2FuaW1hdG9yL3JvdGF0aW9uLW92ZXJ0aW1lLnRzIl0sIm5hbWVzIjpbIlJPVEFUSU9OX09WRVJUSU1FX1JBTkRfT0ZGU0VUIiwiUm90YXRpb25PdmVydGltZU1vZHVsZSIsInR5cGUiLCJDdXJ2ZVJhbmdlIiwicmFuZ2UiLCJyYWRpYW4iLCJfc2VwYXJhdGVBeGVzIiwidmFsIiwiY29uc29sZSIsImVycm9yIiwiYW5pbWF0ZSIsInAiLCJkdCIsIm5vcm1hbGl6ZWRUaW1lIiwicmVtYWluaW5nTGlmZXRpbWUiLCJzdGFydExpZmV0aW1lIiwicm90YXRpb24iLCJ4IiwieiIsImV2YWx1YXRlIiwicmFuZG9tU2VlZCIsInJvdGF0aW9uUmFuZCIsInkiLCJwcm9wZXJ0eSJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7OztBQUFBOztBQUNBOztBQUNBOzs7Ozs7Ozs7Ozs7Ozs7O0FBRUE7QUFDQSxJQUFNQSw2QkFBNkIsR0FBRyxNQUF0QztBQUVBOzs7Ozs7SUFNcUJDLGlDQURwQiwrQkFBUSwyQkFBUixXQXNDSSxnQ0FBUztBQUNOQyxFQUFBQSxJQUFJLEVBQUVDLHNCQURBO0FBRU5DLEVBQUFBLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBRixFQUFLLENBQUwsQ0FGRDtBQUdOQyxFQUFBQSxNQUFNLEVBQUU7QUFIRixDQUFULFdBWUEsZ0NBQVM7QUFDTkgsRUFBQUEsSUFBSSxFQUFFQyxzQkFEQTtBQUVOQyxFQUFBQSxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUYsRUFBSyxDQUFMLENBRkQ7QUFHTkMsRUFBQUEsTUFBTSxFQUFFO0FBSEYsQ0FBVCxXQVlBLGdDQUFTO0FBQ05ILEVBQUFBLElBQUksRUFBRUMsc0JBREE7QUFFTkMsRUFBQUEsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFGLEVBQUssQ0FBTCxDQUZEO0FBR05DLEVBQUFBLE1BQU0sRUFBRTtBQUhGLENBQVQ7Ozs7OztBQTNERDs7Ozs7O0FBV0E7Ozs7O3dCQU1vQjtBQUNoQixhQUFPLEtBQUtDLGFBQVo7QUFDSDtzQkFFaUJDLEtBQUs7QUFDbkIsVUFBSSxDQUFDQSxHQUFMLEVBQVU7QUFDTixhQUFLRCxhQUFMLEdBQXFCQyxHQUFyQjtBQUNILE9BRkQsTUFHSztBQUNEQyxRQUFBQSxPQUFPLENBQUNDLEtBQVIsQ0FBYyxrREFBZDtBQUNIO0FBQ0o7QUFFRDs7Ozs7Ozs7QUFvQ0Esb0NBQWU7QUFBQTs7QUFBQTs7QUFBQTs7QUFBQTs7QUFBQTtBQUVkOzs7O1NBRURDLFVBQUEsaUJBQVNDLENBQVQsRUFBWUMsRUFBWixFQUFnQjtBQUNaLFFBQU1DLGNBQWMsR0FBRyxJQUFJRixDQUFDLENBQUNHLGlCQUFGLEdBQXNCSCxDQUFDLENBQUNJLGFBQW5EOztBQUNBLFFBQUksQ0FBQyxLQUFLVCxhQUFWLEVBQXlCO0FBQ3JCSyxNQUFBQSxDQUFDLENBQUNLLFFBQUYsQ0FBV0MsQ0FBWCxJQUFnQixLQUFLQyxDQUFMLENBQU9DLFFBQVAsQ0FBZ0JOLGNBQWhCLEVBQWdDLDhCQUFhRixDQUFDLENBQUNTLFVBQUYsR0FBZXBCLDZCQUE1QixDQUFoQyxJQUE4RlksRUFBOUc7QUFDSCxLQUZELE1BR0s7QUFDRDtBQUNBLFVBQU1TLFlBQVksR0FBRyw4QkFBYVYsQ0FBQyxDQUFDUyxVQUFGLEdBQWVwQiw2QkFBNUIsQ0FBckI7QUFDQVcsTUFBQUEsQ0FBQyxDQUFDSyxRQUFGLENBQVdDLENBQVgsSUFBZ0IsS0FBS0EsQ0FBTCxDQUFPRSxRQUFQLENBQWdCTixjQUFoQixFQUFnQ1EsWUFBaEMsSUFBZ0RULEVBQWhFO0FBQ0FELE1BQUFBLENBQUMsQ0FBQ0ssUUFBRixDQUFXTSxDQUFYLElBQWdCLEtBQUtBLENBQUwsQ0FBT0gsUUFBUCxDQUFnQk4sY0FBaEIsRUFBZ0NRLFlBQWhDLElBQWdEVCxFQUFoRTtBQUNBRCxNQUFBQSxDQUFDLENBQUNLLFFBQUYsQ0FBV0UsQ0FBWCxJQUFnQixLQUFLQSxDQUFMLENBQU9DLFFBQVAsQ0FBZ0JOLGNBQWhCLEVBQWdDUSxZQUFoQyxJQUFnRFQsRUFBaEU7QUFDSDtBQUNKOzs7b0ZBN0VBVzs7Ozs7V0FDUTs7a0ZBRVJBOzs7OztXQUNlOztrRUFPZkE7Ozs7O1dBd0JHLElBQUlwQixzQkFBSjs7Ozs7OztXQVlBLElBQUlBLHNCQUFKOzs7Ozs7O1dBWUEsSUFBSUEsc0JBQUoiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBjY2NsYXNzLCBwcm9wZXJ0eSB9IGZyb20gJy4uLy4uLy4uL3BsYXRmb3JtL0NDQ2xhc3NEZWNvcmF0b3InO1xuaW1wb3J0IHsgcHNldWRvUmFuZG9tIH0gZnJvbSAnLi4vLi4vLi4vdmFsdWUtdHlwZXMnO1xuaW1wb3J0IEN1cnZlUmFuZ2UgZnJvbSAnLi9jdXJ2ZS1yYW5nZSc7XG5cbi8vIHRzbGludDpkaXNhYmxlOiBtYXgtbGluZS1sZW5ndGhcbmNvbnN0IFJPVEFUSU9OX09WRVJUSU1FX1JBTkRfT0ZGU0VUID0gMTI1MjkyO1xuXG4vKipcbiAqICEjZW4gVGhlIHJvdGF0aW9uIG1vZHVsZSBvZiAzZCBwYXJ0aWNsZS5cbiAqICEjemggM0Qg57KS5a2Q55qE5peL6L2s5qih5Z2XXG4gKiBAY2xhc3MgUm90YXRpb25PdmVydGltZU1vZHVsZVxuICovXG5AY2NjbGFzcygnY2MuUm90YXRpb25PdmVydGltZU1vZHVsZScpXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBSb3RhdGlvbk92ZXJ0aW1lTW9kdWxlIHtcblxuICAgIC8qKlxuICAgICAqICEjZW4gVGhlIGVuYWJsZSBvZiBSb3RhdGlvbk92ZXJ0aW1lTW9kdWxlLlxuICAgICAqICEjemgg5piv5ZCm5ZCv55SoXG4gICAgICogQHByb3BlcnR5IHtCb29sZWFufSBlbmFibGVcbiAgICAgKi9cbiAgICBAcHJvcGVydHlcbiAgICBlbmFibGUgPSBmYWxzZTtcblxuICAgIEBwcm9wZXJ0eVxuICAgIF9zZXBhcmF0ZUF4ZXMgPSBmYWxzZTtcblxuICAgIC8qKlxuICAgICAqICEjZW4gV2hldGhlciB0byBzZXQgdGhlIHJvdGF0aW9uIG9mIHRocmVlIGF4ZXMgc2VwYXJhdGVseSAobm90IGN1cnJlbnRseSBzdXBwb3J0ZWQpXG4gICAgICogISN6aCDmmK/lkKbkuInkuKrovbTliIblvIDorr7lrprml4vovazvvIjmmoLkuI3mlK/mjIHvvInjgIJcbiAgICAgKiBAcHJvcGVydHkge0Jvb2xlYW59IHNlcGFyYXRlQXhlc1xuICAgICAqL1xuICAgIEBwcm9wZXJ0eVxuICAgIGdldCBzZXBhcmF0ZUF4ZXMgKCkge1xuICAgICAgICByZXR1cm4gdGhpcy5fc2VwYXJhdGVBeGVzO1xuICAgIH1cblxuICAgIHNldCBzZXBhcmF0ZUF4ZXMgKHZhbCkge1xuICAgICAgICBpZiAoIXZhbCkge1xuICAgICAgICAgICAgdGhpcy5fc2VwYXJhdGVBeGVzID0gdmFsO1xuICAgICAgICB9XG4gICAgICAgIGVsc2Uge1xuICAgICAgICAgICAgY29uc29sZS5lcnJvcigncm90YXRpb24gb3ZlcnRpbWUgc2VwYXJhdGVBeGVzIGlzIG5vdCBzdXBwb3J0ZWQhJyk7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiAhI2VuIFNldCByb3RhdGlvbiBhcm91bmQgWCBheGlzLlxuICAgICAqICEjemgg57uVIFgg6L206K6+5a6a5peL6L2s44CCXG4gICAgICogQHByb3BlcnR5IHtDdXJ2ZVJhbmdlfSB4XG4gICAgICovXG4gICAgQHByb3BlcnR5KHtcbiAgICAgICAgdHlwZTogQ3VydmVSYW5nZSxcbiAgICAgICAgcmFuZ2U6IFstMSwgMV0sXG4gICAgICAgIHJhZGlhbjogdHJ1ZSxcbiAgICB9KVxuICAgIHggPSBuZXcgQ3VydmVSYW5nZSgpO1xuXG4gICAgLyoqXG4gICAgICogISNlbiBTZXQgcm90YXRpb24gYXJvdW5kIFkgYXhpcy5cbiAgICAgKiAhI3poIOe7lSBZIOi9tOiuvuWumuaXi+i9rOOAglxuICAgICAqIEBwcm9wZXJ0eSB7Q3VydmVSYW5nZX0geVxuICAgICAqL1xuICAgIEBwcm9wZXJ0eSh7XG4gICAgICAgIHR5cGU6IEN1cnZlUmFuZ2UsXG4gICAgICAgIHJhbmdlOiBbLTEsIDFdLFxuICAgICAgICByYWRpYW46IHRydWUsXG4gICAgfSlcbiAgICB5ID0gbmV3IEN1cnZlUmFuZ2UoKTtcblxuICAgIC8qKlxuICAgICAqICEjZW4gU2V0IHJvdGF0aW9uIGFyb3VuZCBaIGF4aXMuXG4gICAgICogISN6aCDnu5UgWiDovbTorr7lrprml4vovazjgIJcbiAgICAgKiBAcHJvcGVydHkge0N1cnZlUmFuZ2V9IHpcbiAgICAgKi9cbiAgICBAcHJvcGVydHkoe1xuICAgICAgICB0eXBlOiBDdXJ2ZVJhbmdlLFxuICAgICAgICByYW5nZTogWy0xLCAxXSxcbiAgICAgICAgcmFkaWFuOiB0cnVlLFxuICAgIH0pXG4gICAgeiA9IG5ldyBDdXJ2ZVJhbmdlKCk7XG5cbiAgICBjb25zdHJ1Y3RvciAoKSB7XG5cbiAgICB9XG5cbiAgICBhbmltYXRlIChwLCBkdCkge1xuICAgICAgICBjb25zdCBub3JtYWxpemVkVGltZSA9IDEgLSBwLnJlbWFpbmluZ0xpZmV0aW1lIC8gcC5zdGFydExpZmV0aW1lO1xuICAgICAgICBpZiAoIXRoaXMuX3NlcGFyYXRlQXhlcykge1xuICAgICAgICAgICAgcC5yb3RhdGlvbi54ICs9IHRoaXMuei5ldmFsdWF0ZShub3JtYWxpemVkVGltZSwgcHNldWRvUmFuZG9tKHAucmFuZG9tU2VlZCArIFJPVEFUSU9OX09WRVJUSU1FX1JBTkRfT0ZGU0VUKSkgKiBkdDtcbiAgICAgICAgfVxuICAgICAgICBlbHNlIHtcbiAgICAgICAgICAgIC8vIFRPRE86IHNlcGFyYXRlQXhlcyBpcyB0ZW1wb3JhcmlseSBub3Qgc3VwcG9ydGVkIVxuICAgICAgICAgICAgY29uc3Qgcm90YXRpb25SYW5kID0gcHNldWRvUmFuZG9tKHAucmFuZG9tU2VlZCArIFJPVEFUSU9OX09WRVJUSU1FX1JBTkRfT0ZGU0VUKTtcbiAgICAgICAgICAgIHAucm90YXRpb24ueCArPSB0aGlzLnguZXZhbHVhdGUobm9ybWFsaXplZFRpbWUsIHJvdGF0aW9uUmFuZCkgKiBkdDtcbiAgICAgICAgICAgIHAucm90YXRpb24ueSArPSB0aGlzLnkuZXZhbHVhdGUobm9ybWFsaXplZFRpbWUsIHJvdGF0aW9uUmFuZCkgKiBkdDtcbiAgICAgICAgICAgIHAucm90YXRpb24ueiArPSB0aGlzLnouZXZhbHVhdGUobm9ybWFsaXplZFRpbWUsIHJvdGF0aW9uUmFuZCkgKiBkdDtcbiAgICAgICAgfVxuICAgIH1cbn1cbiJdLCJzb3VyY2VSb290IjoiLyJ9