
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/particle/animator/limit-velocity-overtime.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _CCClassDecorator = require("../../../platform/CCClassDecorator");

var _valueTypes = require("../../../value-types");

var _enum = require("../enum");

var _curveRange = _interopRequireDefault(require("./curve-range"));

var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _temp;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

// tslint:disable: max-line-length
var LIMIT_VELOCITY_RAND_OFFSET = 23541;

var _temp_v3 = cc.v3();

var _temp_v3_1 = cc.v3();

function dampenBeyondLimit(vel, limit, dampen) {
  var sgn = Math.sign(vel);
  var abs = Math.abs(vel);

  if (abs > limit) {
    abs = (0, _valueTypes.lerp)(abs, limit, dampen);
  }

  return abs * sgn;
}
/**
 * !#en The limit velocity module of 3d particle.
 * !#zh 3D 粒子的限速模块
 * @class LimitVelocityOvertimeModule
 */


var LimitVelocityOvertimeModule = (_dec = (0, _CCClassDecorator.ccclass)('cc.LimitVelocityOvertimeModule'), _dec2 = (0, _CCClassDecorator.property)({
  type: _enum.Space
}), _dec3 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"],
  range: [-1, 1]
}), _dec4 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"],
  range: [-1, 1]
}), _dec5 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"],
  range: [-1, 1]
}), _dec6 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"],
  range: [-1, 1]
}), _dec(_class = (_class2 = (_temp =
/*#__PURE__*/
function () {
  /**
   * !#en The enable of LimitVelocityOvertimeModule.
   * !#zh 是否启用
   * @property {Boolean} enable
   */

  /**
   * !#en The coordinate system used when calculating the lower speed limit.
   * !#zh 计算速度下限时采用的坐标系。
   * @property {Space} space
   */

  /**
   * !#en Whether to limit the three axes separately.
   * !#zh 是否三个轴分开限制。
   * @property {Boolean} separateAxes
   */

  /**
   * !#en Lower speed limit
   * !#zh 速度下限。
   * @property {CurveRange} limit
   */

  /**
   * !#en Lower speed limit in X direction.
   * !#zh X 轴方向上的速度下限。
   * @property {CurveRange} limitX
   */

  /**
   * !#en Lower speed limit in Y direction.
   * !#zh Y 轴方向上的速度下限。
   * @property {CurveRange} limitY
   */

  /**
   * !#en Lower speed limit in Z direction.
   * !#zh Z 轴方向上的速度下限。
   * @property {CurveRange} limitZ
   */

  /**
   * !#en Interpolation of current speed and lower speed limit.
   * !#zh 当前速度与速度下限的插值。
   * @property {Number} dampen
   */
  // TODO:functions related to drag are temporarily not supported
  function LimitVelocityOvertimeModule() {
    _initializerDefineProperty(this, "enable", _descriptor, this);

    _initializerDefineProperty(this, "space", _descriptor2, this);

    _initializerDefineProperty(this, "separateAxes", _descriptor3, this);

    _initializerDefineProperty(this, "limit", _descriptor4, this);

    _initializerDefineProperty(this, "limitX", _descriptor5, this);

    _initializerDefineProperty(this, "limitY", _descriptor6, this);

    _initializerDefineProperty(this, "limitZ", _descriptor7, this);

    _initializerDefineProperty(this, "dampen", _descriptor8, this);

    this.drag = null;
    this.multiplyDragByParticleSize = false;
    this.multiplyDragByParticleVelocity = false;
    this.rotation = null;
    this.needTransform = false;
    this.rotation = new _valueTypes.Quat();
    this.needTransform = false;
  }

  var _proto = LimitVelocityOvertimeModule.prototype;

  _proto.update = function update(space, worldTransform) {
    this.needTransform = calculateTransform(space, this.space, worldTransform, this.rotation);
  };

  _proto.animate = function animate(p) {
    var normalizedTime = 1 - p.remainingLifetime / p.startLifetime;
    var dampedVel = _temp_v3;

    if (this.separateAxes) {
      _valueTypes.Vec3.set(_temp_v3_1, this.limitX.evaluate(normalizedTime, (0, _valueTypes.pseudoRandom)(p.randomSeed + LIMIT_VELOCITY_RAND_OFFSET)), this.limitY.evaluate(normalizedTime, (0, _valueTypes.pseudoRandom)(p.randomSeed + LIMIT_VELOCITY_RAND_OFFSET)), this.limitZ.evaluate(normalizedTime, (0, _valueTypes.pseudoRandom)(p.randomSeed + LIMIT_VELOCITY_RAND_OFFSET)));

      if (this.needTransform) {
        _valueTypes.Vec3.transformQuat(_temp_v3_1, _temp_v3_1, this.rotation);
      }

      _valueTypes.Vec3.set(dampedVel, dampenBeyondLimit(p.ultimateVelocity.x, _temp_v3_1.x, this.dampen), dampenBeyondLimit(p.ultimateVelocity.y, _temp_v3_1.y, this.dampen), dampenBeyondLimit(p.ultimateVelocity.z, _temp_v3_1.z, this.dampen));
    } else {
      _valueTypes.Vec3.normalize(dampedVel, p.ultimateVelocity);

      _valueTypes.Vec3.scale(dampedVel, dampedVel, dampenBeyondLimit(p.ultimateVelocity.len(), this.limit.evaluate(normalizedTime, (0, _valueTypes.pseudoRandom)(p.randomSeed + LIMIT_VELOCITY_RAND_OFFSET)), this.dampen));
    }

    _valueTypes.Vec3.copy(p.ultimateVelocity, dampedVel);
  };

  return LimitVelocityOvertimeModule;
}(), _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "enable", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return false;
  }
}), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "space", [_dec2], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return _enum.Space.Local;
  }
}), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "separateAxes", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return false;
  }
}), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "limit", [_dec3], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "limitX", [_dec4], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "limitY", [_dec5], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor7 = _applyDecoratedDescriptor(_class2.prototype, "limitZ", [_dec6], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor8 = _applyDecoratedDescriptor(_class2.prototype, "dampen", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 3;
  }
})), _class2)) || _class);
exports["default"] = LimitVelocityOvertimeModule;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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