
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/particle/animator/gradient.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports.Gradient = exports.AlphaKey = exports.ColorKey = void 0;

var _CCClassDecorator = require("../../../platform/CCClassDecorator");

var _CCEnum = _interopRequireDefault(require("../../../platform/CCEnum"));

var _valueTypes = require("../../../value-types");

var _dec, _class, _class2, _descriptor, _descriptor2, _temp, _dec2, _class4, _class5, _descriptor3, _descriptor4, _temp2, _dec3, _dec4, _dec5, _dec6, _class7, _class8, _descriptor5, _descriptor6, _descriptor7, _class9, _temp3;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

// tslint:disable: max-line-length
var Mode = (0, _CCEnum["default"])({
  Blend: 0,
  Fixed: 1
});
/**
 * !#en The color key of gradient.
 * !#zh color 关键帧
 * @class ColorKey
 */

var ColorKey = (_dec = (0, _CCClassDecorator.ccclass)('cc.ColorKey'), _dec(_class = (_class2 = (_temp = function ColorKey() {
  _initializerDefineProperty(this, "color", _descriptor, this);

  _initializerDefineProperty(this, "time", _descriptor2, this);
}, _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "color", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return cc.Color.WHITE.clone();
  }
}), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "time", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 0;
  }
})), _class2)) || _class);
/**
 * !#en The alpha key of gradient.
 * !#zh alpha 关键帧
 * @class AlphaKey
 */

exports.ColorKey = ColorKey;
var AlphaKey = (_dec2 = (0, _CCClassDecorator.ccclass)('cc.AlphaKey'), _dec2(_class4 = (_class5 = (_temp2 = function AlphaKey() {
  _initializerDefineProperty(this, "alpha", _descriptor3, this);

  _initializerDefineProperty(this, "time", _descriptor4, this);
}, _temp2), (_descriptor3 = _applyDecoratedDescriptor(_class5.prototype, "alpha", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 1;
  }
}), _descriptor4 = _applyDecoratedDescriptor(_class5.prototype, "time", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return 0;
  }
})), _class5)) || _class4);
/**
 * !#en The gradient data of color.
 * !#zh 颜色渐变数据
 * @class Gradient
 */

exports.AlphaKey = AlphaKey;
var Gradient = (_dec3 = (0, _CCClassDecorator.ccclass)('cc.Gradient'), _dec4 = (0, _CCClassDecorator.property)({
  type: [ColorKey]
}), _dec5 = (0, _CCClassDecorator.property)({
  type: [AlphaKey]
}), _dec6 = (0, _CCClassDecorator.property)({
  type: Mode
}), _dec3(_class7 = (_class8 = (_temp3 = _class9 =
/*#__PURE__*/
function () {
  function Gradient() {
    _initializerDefineProperty(this, "colorKeys", _descriptor5, this);

    _initializerDefineProperty(this, "alphaKeys", _descriptor6, this);

    _initializerDefineProperty(this, "mode", _descriptor7, this);

    this._color = null;
    this._color = cc.Color.WHITE.clone();
  }

  var _proto = Gradient.prototype;

  _proto.setKeys = function setKeys(colorKeys, alphaKeys) {
    this.colorKeys = colorKeys;
    this.alphaKeys = alphaKeys;
  };

  _proto.sortKeys = function sortKeys() {
    if (this.colorKeys.length > 1) {
      this.colorKeys.sort(function (a, b) {
        return a.time - b.time;
      });
    }

    if (this.alphaKeys.length > 1) {
      this.alphaKeys.sort(function (a, b) {
        return a.time - b.time;
      });
    }
  };

  _proto.evaluate = function evaluate(time) {
    this.getRGB(time);

    this._color._fastSetA(this.getAlpha(time));

    return this._color;
  };

  _proto.randomColor = function randomColor() {
    var c = this.colorKeys[Math.trunc(Math.random() * this.colorKeys.length)];
    var a = this.alphaKeys[Math.trunc(Math.random() * this.alphaKeys.length)];

    this._color.set(c.color);

    this._color._fastSetA(a.alpha);

    return this._color;
  };

  _proto.getRGB = function getRGB(time) {
    if (this.colorKeys.length > 1) {
      time = (0, _valueTypes.repeat)(time, 1);

      for (var i = 1; i < this.colorKeys.length; ++i) {
        var preTime = this.colorKeys[i - 1].time;
        var curTime = this.colorKeys[i].time;

        if (time >= preTime && time < curTime) {
          if (this.mode === Mode.Fixed) {
            return this.colorKeys[i].color;
          }

          var factor = (time - preTime) / (curTime - preTime);
          this.colorKeys[i - 1].color.lerp(this.colorKeys[i].color, factor, this._color);
          return this._color;
        }
      }

      var lastIndex = this.colorKeys.length - 1;

      if (time < this.colorKeys[0].time) {
        cc.Color.BLACK.lerp(this.colorKeys[0].color, time / this.colorKeys[0].time, this._color);
      } else if (time > this.colorKeys[lastIndex].time) {
        this.colorKeys[lastIndex].color.lerp(cc.Color.BLACK, (time - this.colorKeys[lastIndex].time) / (1 - this.colorKeys[lastIndex].time), this._color);
      } // console.warn('something went wrong. can not get gradient color.');

    } else if (this.colorKeys.length === 1) {
      this._color.set(this.colorKeys[0].color);

      return this._color;
    } else {
      this._color.set(cc.Color.WHITE);

      return this._color;
    }
  };

  _proto.getAlpha = function getAlpha(time) {
    if (this.alphaKeys.length > 1) {
      time = (0, _valueTypes.repeat)(time, 1);

      for (var i = 1; i < this.alphaKeys.length; ++i) {
        var preTime = this.alphaKeys[i - 1].time;
        var curTime = this.alphaKeys[i].time;

        if (time >= preTime && time < curTime) {
          if (this.mode === Mode.Fixed) {
            return this.alphaKeys[i].alpha;
          }

          var factor = (time - preTime) / (curTime - preTime);
          return (0, _valueTypes.lerp)(this.alphaKeys[i - 1].alpha, this.alphaKeys[i].alpha, factor);
        }
      }

      var lastIndex = this.alphaKeys.length - 1;

      if (time < this.alphaKeys[0].time) {
        return (0, _valueTypes.lerp)(255, this.alphaKeys[0].alpha, time / this.alphaKeys[0].time);
      } else if (time > this.alphaKeys[lastIndex].time) {
        return (0, _valueTypes.lerp)(this.alphaKeys[lastIndex].alpha, 255, (time - this.alphaKeys[lastIndex].time) / (1 - this.alphaKeys[lastIndex].time));
      }
    } else if (this.alphaKeys.length === 1) {
      return this.alphaKeys[0].alpha;
    } else {
      return 255;
    }
  };

  return Gradient;
}(), _class9.Mode = Mode, _temp3), (_descriptor5 = _applyDecoratedDescriptor(_class8.prototype, "colorKeys", [_dec4], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new Array();
  }
}), _descriptor6 = _applyDecoratedDescriptor(_class8.prototype, "alphaKeys", [_dec5], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new Array();
  }
}), _descriptor7 = _applyDecoratedDescriptor(_class8.prototype, "mode", [_dec6], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return Mode.Blend;
  }
})), _class8)) || _class7);
exports.Gradient = Gradient;
cc.ColorKey = ColorKey;
cc.AlphaKey = AlphaKey;
cc.Gradient = Gradient;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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