
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/particle/animator/gradient-range.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _CCClassDecorator = require("../../../platform/CCClassDecorator");

var _CCEnum = _interopRequireDefault(require("../../../platform/CCEnum"));

var _gradient = require("./gradient");

var _dec, _dec2, _dec3, _dec4, _dec5, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _class3, _temp;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

var GRADIENT_MODE_FIX = 0;
var GRADIENT_MODE_BLEND = 1;
var GRADIENT_RANGE_MODE_COLOR = 0;
var GRADIENT_RANGE_MODE_TWO_COLOR = 1;
var GRADIENT_RANGE_MODE_RANDOM_COLOR = 2;
var GRADIENT_RANGE_MODE_GRADIENT = 3;
var GRADIENT_RANGE_MODE_TWO_GRADIENT = 4;
var SerializableTable = CC_EDITOR && [["_mode", "color"], ["_mode", "gradient"], ["_mode", "colorMin", "colorMax"], ["_mode", "gradientMin", "gradientMax"], ["_mode", "gradient"]];
var Mode = (0, _CCEnum["default"])({
  Color: 0,
  Gradient: 1,
  TwoColors: 2,
  TwoGradients: 3,
  RandomColor: 4
});
/**
 * !#en The gradient range of color.
 * !#zh 颜色值的渐变范围
 * @class GradientRange
 */

var GradientRange = (_dec = (0, _CCClassDecorator.ccclass)('cc.GradientRange'), _dec2 = (0, _CCClassDecorator.property)({
  type: Mode
}), _dec3 = (0, _CCClassDecorator.property)({
  type: _gradient.Gradient
}), _dec4 = (0, _CCClassDecorator.property)({
  type: _gradient.Gradient
}), _dec5 = (0, _CCClassDecorator.property)({
  type: _gradient.Gradient
}), _dec(_class = (_class2 = (_temp = _class3 =
/*#__PURE__*/
function () {
  function GradientRange() {
    _initializerDefineProperty(this, "_mode", _descriptor, this);

    _initializerDefineProperty(this, "_color", _descriptor2, this);

    _initializerDefineProperty(this, "color", _descriptor3, this);

    _initializerDefineProperty(this, "colorMin", _descriptor4, this);

    _initializerDefineProperty(this, "colorMax", _descriptor5, this);

    _initializerDefineProperty(this, "gradient", _descriptor6, this);

    _initializerDefineProperty(this, "gradientMin", _descriptor7, this);

    _initializerDefineProperty(this, "gradientMax", _descriptor8, this);
  }

  var _proto = GradientRange.prototype;

  _proto.evaluate = function evaluate(time, rndRatio) {
    switch (this._mode) {
      case Mode.Color:
        return this.color;

      case Mode.TwoColors:
        this.colorMin.lerp(this.colorMax, rndRatio, this._color);
        return this._color;

      case Mode.RandomColor:
        return this.gradient.randomColor();

      case Mode.Gradient:
        return this.gradient.evaluate(time);

      case Mode.TwoGradients:
        this.gradientMin.evaluate(time).lerp(this.gradientMax.evaluate(time), rndRatio, this._color);
        return this._color;

      default:
        return this.color;
    }
  };

  _createClass(GradientRange, [{
    key: "mode",

    /**
     * !#en Gradient type.
     * !#zh 渐变色类型。
     * @property {Mode} mode
     */
    get: function get() {
      return this._mode;
    },
    set: function set(m) {
      if (CC_EDITOR) {
        if (m === Mode.RandomColor) {
          if (this.gradient.colorKeys.length === 0) {
            this.gradient.colorKeys.push(new _gradient.ColorKey());
          }

          if (this.gradient.alphaKeys.length === 0) {
            this.gradient.alphaKeys.push(new _gradient.AlphaKey());
          }
        }
      }

      this._mode = m;
    }
  }]);

  return GradientRange;
}(), _class3.Mode = Mode, _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "_mode", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return Mode.Color;
  }
}), _applyDecoratedDescriptor(_class2.prototype, "mode", [_dec2], Object.getOwnPropertyDescriptor(_class2.prototype, "mode"), _class2.prototype), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "_color", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return cc.Color.WHITE.clone();
  }
}), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "color", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return cc.Color.WHITE.clone();
  }
}), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "colorMin", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return cc.Color.WHITE.clone();
  }
}), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "colorMax", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return cc.Color.WHITE.clone();
  }
}), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "gradient", [_dec3], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _gradient.Gradient();
  }
}), _descriptor7 = _applyDecoratedDescriptor(_class2.prototype, "gradientMin", [_dec4], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _gradient.Gradient();
  }
}), _descriptor8 = _applyDecoratedDescriptor(_class2.prototype, "gradientMax", [_dec5], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _gradient.Gradient();
  }
})), _class2)) || _class);
exports["default"] = GradientRange;
CC_EDITOR && (GradientRange.prototype._onBeforeSerialize = function (props) {
  return SerializableTable[this._mode];
});
cc.GradientRange = GradientRange;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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