
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/particle/animator/force-overtime.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _CCClassDecorator = require("../../../platform/CCClassDecorator");

var _valueTypes = require("../../../value-types");

var _enum = require("../enum");

var _particleGeneralFunction = require("../particle-general-function");

var _curveRange = _interopRequireDefault(require("./curve-range"));

var _dec, _dec2, _dec3, _dec4, _dec5, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _temp;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

// tslint:disable: max-line-length
var FORCE_OVERTIME_RAND_OFFSET = 212165;

var _temp_v3 = cc.v3();
/**
 * !#en The force over time module of 3d particle.
 * !#zh 3D 粒子的加速度模块
 * @class ForceOvertimeModule
 */


var ForceOvertimeModule = (_dec = (0, _CCClassDecorator.ccclass)('cc.ForceOvertimeModule'), _dec2 = (0, _CCClassDecorator.property)({
  type: _enum.Space
}), _dec3 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"],
  range: [-1, 1]
}), _dec4 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"],
  range: [-1, 1]
}), _dec5 = (0, _CCClassDecorator.property)({
  type: _curveRange["default"],
  range: [-1, 1],
  displayOrder: 4
}), _dec(_class = (_class2 = (_temp =
/*#__PURE__*/
function () {
  /**
   * !#en The enable of ColorOvertimeModule.
   * !#zh 是否启用
   * @property {Boolean} enable
   */

  /**
   * !#en Coordinate system used in acceleration calculation.
   * !#zh 加速度计算时采用的坐标系。
   * @property {Space} space
   */

  /**
   * !#en X-axis acceleration component.
   * !#zh X 轴方向上的加速度分量。
   * @property {CurveRange} x
   */

  /**
   * !#en Y-axis acceleration component.
   * !#zh Y 轴方向上的加速度分量。
   * @property {CurveRange} y
   */

  /**
   * !#en Z-axis acceleration component.
   * !#zh Z 轴方向上的加速度分量。
   * @property {CurveRange} z
   */
  // TODO:currently not supported
  function ForceOvertimeModule() {
    _initializerDefineProperty(this, "enable", _descriptor, this);

    _initializerDefineProperty(this, "space", _descriptor2, this);

    _initializerDefineProperty(this, "x", _descriptor3, this);

    _initializerDefineProperty(this, "y", _descriptor4, this);

    _initializerDefineProperty(this, "z", _descriptor5, this);

    this.randomized = false;
    this.rotation = null;
    this.needTransform = false;
    this.rotation = new _valueTypes.Quat();
    this.needTransform = false;
  }

  var _proto = ForceOvertimeModule.prototype;

  _proto.update = function update(space, worldTransform) {
    this.needTransform = (0, _particleGeneralFunction.calculateTransform)(space, this.space, worldTransform, this.rotation);
  };

  _proto.animate = function animate(p, dt) {
    var normalizedTime = 1 - p.remainingLifetime / p.startLifetime;

    var force = _valueTypes.Vec3.set(_temp_v3, this.x.evaluate(normalizedTime, (0, _valueTypes.pseudoRandom)(p.randomSeed + FORCE_OVERTIME_RAND_OFFSET)), this.y.evaluate(normalizedTime, (0, _valueTypes.pseudoRandom)(p.randomSeed + FORCE_OVERTIME_RAND_OFFSET)), this.z.evaluate(normalizedTime, (0, _valueTypes.pseudoRandom)(p.randomSeed + FORCE_OVERTIME_RAND_OFFSET)));

    if (this.needTransform) {
      _valueTypes.Vec3.transformQuat(force, force, this.rotation);
    }

    _valueTypes.Vec3.scaleAndAdd(p.velocity, p.velocity, force, dt);
  };

  return ForceOvertimeModule;
}(), _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "enable", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return false;
  }
}), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "space", [_dec2], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return _enum.Space.Local;
  }
}), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "x", [_dec3], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "y", [_dec4], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
}), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "z", [_dec5], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _curveRange["default"]();
  }
})), _class2)) || _class);
exports["default"] = ForceOvertimeModule;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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