
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/3d/particle/animator/color-overtime.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _CCClassDecorator = require("../../../platform/CCClassDecorator");

var _valueTypes = require("../../../value-types");

var _gradientRange = _interopRequireDefault(require("./gradient-range"));

var _dec, _dec2, _class, _class2, _descriptor, _descriptor2, _temp;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

var COLOR_OVERTIME_RAND_OFFSET = 91041;
/**
 * !#en The color over time module of 3d particle.
 * !#zh 3D 粒子颜色变化模块
 * @class ColorOvertimeModule
 */

var ColorOvertimeModule = (_dec = (0, _CCClassDecorator.ccclass)('cc.ColorOvertimeModule'), _dec2 = (0, _CCClassDecorator.property)({
  type: _gradientRange["default"]
}), _dec(_class = (_class2 = (_temp =
/*#__PURE__*/
function () {
  function ColorOvertimeModule() {
    _initializerDefineProperty(this, "enable", _descriptor, this);

    _initializerDefineProperty(this, "color", _descriptor2, this);
  }

  var _proto = ColorOvertimeModule.prototype;

  _proto.animate = function animate(particle) {
    if (this.enable) {
      particle.color.set(particle.startColor);
      particle.color.multiply(this.color.evaluate(1.0 - particle.remainingLifetime / particle.startLifetime, (0, _valueTypes.pseudoRandom)(particle.randomSeed + COLOR_OVERTIME_RAND_OFFSET)));
    }
  };

  return ColorOvertimeModule;
}(), _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "enable", [_CCClassDecorator.property], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return false;
  }
}), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "color", [_dec2], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new _gradientRange["default"]();
  }
})), _class2)) || _class);
exports["default"] = ColorOvertimeModule;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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