
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/audio/CCAudio.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2008-2010 Ricardo Quesada
 Copyright (c) 2011-2012 cocos2d-x.org
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var EventTarget = require('../core/event/event-target');

var sys = require('../core/platform/CCSys');

var LoadMode = require('../core/assets/CCAudioClip').LoadMode;

var touchBinded = false;
var touchPlayList = [//{ instance: Audio, offset: 0, audio: audio }
];

var Audio = function Audio(src) {
  EventTarget.call(this);
  this._shouldRecycleOnEnded = false;
  this._src = src;
  this._element = null;
  this.id = 0;
  this._volume = 1;
  this._loop = false;
  this._nextTime = 0; // playback position to set

  this._state = Audio.State.INITIALZING;

  this._onended = function () {
    this._state = Audio.State.STOPPED;
    this.emit('ended');
  }.bind(this);
};

cc.js.extend(Audio, EventTarget);
/**
 * !#en Audio state.
 * !#zh 声音播放状态
 * @enum audioEngine.AudioState
 * @memberof cc
 */
// TODO - At present, the state is mixed with two states of users and systems, and it is best to split into two types. A "loading" should also be added to the system state.

Audio.State = {
  /**
   * @property {Number} ERROR
   */
  ERROR: -1,

  /**
   * @property {Number} INITIALZING
   */
  INITIALZING: 0,

  /**
   * @property {Number} PLAYING
   */
  PLAYING: 1,

  /**
   * @property {Number} PAUSED
   */
  PAUSED: 2,

  /**
   * @property {Number} STOPPED
   */
  STOPPED: 3
};

(function (proto) {
  proto._bindEnded = function (callback) {
    callback = callback || this._onended;
    var elem = this._element;

    if (this._src && elem instanceof HTMLAudioElement) {
      elem.addEventListener('ended', callback);
    } else {
      elem.onended = callback;
    }
  };

  proto._unbindEnded = function () {
    var elem = this._element;

    if (elem instanceof HTMLAudioElement) {
      elem.removeEventListener('ended', this._onended);
    } else if (elem) {
      elem.onended = null;
    }
  }; // proto.mount = function (elem) {
  //     if (CC_DEBUG) {
  //         cc.warn('Audio.mount(value) is deprecated. Please use Audio._onLoaded().');
  //     }
  // };


  proto._onLoaded = function () {
    this._createElement();

    this.setVolume(this._volume);
    this.setLoop(this._loop);

    if (this._nextTime !== 0) {
      this.setCurrentTime(this._nextTime);
    } // need to skip forceUpdatingState when get state on load, because it's a hack operation


    if (this.getState(false) === Audio.State.PLAYING) {
      this.play();
    } else {
      this._state = Audio.State.INITIALZING;
    }
  };

  proto._createElement = function () {
    var elem = this._src._nativeAsset;

    if (elem instanceof HTMLAudioElement) {
      // Reuse dom audio element
      if (!this._element) {
        this._element = document.createElement('audio');
      }

      this._element.src = elem.src;
    } else {
      this._element = new WebAudioElement(elem, this);
    }
  };

  proto.play = function () {
    // marked as playing so it will playOnLoad
    this._state = Audio.State.PLAYING;

    if (!this._element) {
      return;
    }

    this._bindEnded();

    this._element.play();

    this._touchToPlay();
  };

  proto._touchToPlay = function () {
    if (this._src && this._src.loadMode === LoadMode.DOM_AUDIO && this._element.paused) {
      touchPlayList.push({
        instance: this,
        offset: 0,
        audio: this._element
      });
    }

    if (touchBinded) return;
    touchBinded = true;
    var touchEventName = 'ontouchend' in window ? 'touchend' : 'mousedown'; // Listen to the touchstart body event and play the audio when necessary.

    cc.game.canvas.addEventListener(touchEventName, function () {
      var item;

      while (item = touchPlayList.pop()) {
        item.audio.play(item.offset);
      }
    });
  };

  proto.destroy = function () {
    this._element = null;
  };

  proto.pause = function () {
    if (!this._element || this.getState() !== Audio.State.PLAYING) return;

    this._unbindEnded();

    this._element.pause();

    this._state = Audio.State.PAUSED;
  };

  proto.resume = function () {
    if (!this._element || this.getState() !== Audio.State.PAUSED) return;

    this._bindEnded();

    this._element.play();

    this._state = Audio.State.PLAYING;
  };

  proto.stop = function () {
    if (!this._element) return;

    this._element.pause();

    try {
      this._element.currentTime = 0;
    } catch (error) {} // remove touchPlayList


    for (var i = 0; i < touchPlayList.length; i++) {
      if (touchPlayList[i].instance === this) {
        touchPlayList.splice(i, 1);
        break;
      }
    }

    this._unbindEnded();

    this.emit('stop');
    this._state = Audio.State.STOPPED;
  };

  proto.setLoop = function (loop) {
    this._loop = loop;

    if (this._element) {
      this._element.loop = loop;
    }
  };

  proto.getLoop = function () {
    return this._loop;
  };

  proto.setVolume = function (num) {
    this._volume = num;

    if (this._element) {
      this._element.volume = num;
    }
  };

  proto.getVolume = function () {
    return this._volume;
  };

  proto.setCurrentTime = function (num) {
    if (this._element) {
      this._nextTime = 0;
    } else {
      this._nextTime = num;
      return;
    } // setCurrentTime would fire 'ended' event
    // so we need to change the callback to rebind ended callback after setCurrentTime


    this._unbindEnded();

    this._bindEnded(function () {
      this._bindEnded();
    }.bind(this));

    try {
      this._element.currentTime = num;
    } catch (err) {
      var _element = this._element;

      if (_element.addEventListener) {
        var func = function func() {
          _element.removeEventListener('loadedmetadata', func);

          _element.currentTime = num;
        };

        _element.addEventListener('loadedmetadata', func);
      }
    }
  };

  proto.getCurrentTime = function () {
    return this._element ? this._element.currentTime : 0;
  };

  proto.getDuration = function () {
    return this._element ? this._element.duration : 0;
  };

  proto.getState = function (forceUpdating) {
    if (forceUpdating === void 0) {
      forceUpdating = true;
    }

    // HACK: in some browser, audio may not fire 'ended' event
    // so we need to force updating the Audio state
    if (forceUpdating) {
      this._forceUpdatingState();
    }

    return this._state;
  };

  proto._forceUpdatingState = function () {
    var elem = this._element;

    if (elem) {
      if (Audio.State.PLAYING === this._state && elem.paused) {
        this._state = Audio.State.STOPPED;
      } else if (Audio.State.STOPPED === this._state && !elem.paused) {
        this._state = Audio.State.PLAYING;
      }
    }
  };

  Object.defineProperty(proto, 'src', {
    get: function get() {
      return this._src;
    },
    set: function set(clip) {
      this._unbindEnded();

      if (clip) {
        this._src = clip;

        if (clip.loaded) {
          this._onLoaded();
        } else {
          var self = this;
          clip.once('load', function () {
            if (clip === self._src) {
              self._onLoaded();
            }
          });
          cc.loader.load({
            url: clip.nativeUrl,
            // For audio, we should skip loader otherwise it will load a new audioClip.
            skips: ['Loader']
          }, function (err, audioNativeAsset) {
            if (err) {
              cc.error(err);
              return;
            }

            if (!clip.loaded) {
              clip._nativeAsset = audioNativeAsset;
            }
          });
        }
      } else {
        this._src = null;

        if (this._element instanceof WebAudioElement) {
          this._element = null;
        } else if (this._element) {
          this._element.src = '';
        }

        this._state = Audio.State.INITIALZING;
      }

      return clip;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(proto, 'paused', {
    get: function get() {
      return this._element ? this._element.paused : true;
    },
    enumerable: true,
    configurable: true
  }); // setFinishCallback
})(Audio.prototype); // TIME_CONSTANT is used as an argument of setTargetAtTime interface
// TIME_CONSTANT need to be a positive number on Edge and Baidu browser
// TIME_CONSTANT need to be 0 by default, or may fail to set volume at the very beginning of playing audio


var TIME_CONSTANT;

if (cc.sys.browserType === cc.sys.BROWSER_TYPE_EDGE || cc.sys.browserType === cc.sys.BROWSER_TYPE_BAIDU || cc.sys.browserType === cc.sys.BROWSER_TYPE_UC) {
  TIME_CONSTANT = 0.01;
} else {
  TIME_CONSTANT = 0;
} // Encapsulated WebAudio interface


var WebAudioElement = function WebAudioElement(buffer, audio) {
  this._audio = audio;
  this._context = sys.__audioSupport.context;
  this._buffer = buffer;
  this._gainObj = this._context['createGain']();
  this.volume = 1;

  this._gainObj['connect'](this._context['destination']);

  this._loop = false; // The time stamp on the audio time axis when the recording begins to play.

  this._startTime = -1; // Record the currently playing 'Source'

  this._currentSource = null; // Record the time has been played

  this.playedLength = 0;
  this._currentTimer = null;

  this._endCallback = function () {
    if (this.onended) {
      this.onended(this);
    }
  }.bind(this);
};

(function (proto) {
  proto.play = function (offset) {
    // If repeat play, you need to stop before an audio
    if (this._currentSource && !this.paused) {
      this._currentSource.onended = null;

      this._currentSource.stop(0);

      this.playedLength = 0;
    }

    var audio = this._context["createBufferSource"]();

    audio.buffer = this._buffer;
    audio["connect"](this._gainObj);
    audio.loop = this._loop;
    this._startTime = this._context.currentTime;
    offset = offset || this.playedLength;

    if (offset) {
      this._startTime -= offset;
    }

    var duration = this._buffer.duration;
    var startTime = offset;
    var endTime;

    if (this._loop) {
      if (audio.start) audio.start(0, startTime);else if (audio["notoGrainOn"]) audio["noteGrainOn"](0, startTime);else audio["noteOn"](0, startTime);
    } else {
      endTime = duration - offset;
      if (audio.start) audio.start(0, startTime, endTime);else if (audio["noteGrainOn"]) audio["noteGrainOn"](0, startTime, endTime);else audio["noteOn"](0, startTime, endTime);
    }

    this._currentSource = audio;
    audio.onended = this._endCallback; // If the current audio context time stamp is 0 and audio context state is suspended
    // There may be a need to touch events before you can actually start playing audio

    if ((!audio.context.state || audio.context.state === "suspended") && this._context.currentTime === 0) {
      var self = this;
      clearTimeout(this._currentTimer);
      this._currentTimer = setTimeout(function () {
        if (self._context.currentTime === 0) {
          touchPlayList.push({
            instance: self._audio,
            offset: offset,
            audio: self
          });
        }
      }, 10);
    } // HACK: fix mobile safari can't play


    if (cc.sys.browserType === cc.sys.BROWSER_TYPE_SAFARI && cc.sys.isMobile) {
      if (audio.context.state === 'interrupted') {
        audio.context.resume();
      }
    }
  };

  proto.pause = function () {
    clearTimeout(this._currentTimer);
    if (this.paused) return; // Record the time the current has been played

    this.playedLength = this._context.currentTime - this._startTime; // If more than the duration of the audio, Need to take the remainder

    this.playedLength %= this._buffer.duration;
    var audio = this._currentSource;
    this._currentSource = null;
    this._startTime = -1;
    if (audio) audio.stop(0);
  };

  Object.defineProperty(proto, 'paused', {
    get: function get() {
      // If the current audio is a loop, paused is false
      if (this._currentSource && this._currentSource.loop) return false; // startTime default is -1

      if (this._startTime === -1) return true; // Current time -  Start playing time > Audio duration

      return this._context.currentTime - this._startTime > this._buffer.duration;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(proto, 'loop', {
    get: function get() {
      return this._loop;
    },
    set: function set(bool) {
      if (this._currentSource) this._currentSource.loop = bool;
      return this._loop = bool;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(proto, 'volume', {
    get: function get() {
      return this._volume;
    },
    set: function set(num) {
      this._volume = num; // https://www.chromestatus.com/features/5287995770929152

      if (this._gainObj.gain.setTargetAtTime) {
        try {
          this._gainObj.gain.setTargetAtTime(num, this._context.currentTime, TIME_CONSTANT);
        } catch (e) {
          // Some other unknown browsers may crash if TIME_CONSTANT is 0
          this._gainObj.gain.setTargetAtTime(num, this._context.currentTime, 0.01);
        }
      } else {
        this._gainObj.gain.value = num;
      }

      if (sys.os === sys.OS_IOS && !this.paused && this._currentSource) {
        // IOS must be stop webAudio
        this._currentSource.onended = null;
        this.pause();
        this.play();
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(proto, 'currentTime', {
    get: function get() {
      if (this.paused) {
        return this.playedLength;
      } // Record the time the current has been played


      this.playedLength = this._context.currentTime - this._startTime; // If more than the duration of the audio, Need to take the remainder

      this.playedLength %= this._buffer.duration;
      return this.playedLength;
    },
    set: function set(num) {
      if (!this.paused) {
        this.pause();
        this.playedLength = num;
        this.play();
      } else {
        this.playedLength = num;
      }

      return num;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(proto, 'duration', {
    get: function get() {
      return this._buffer.duration;
    },
    enumerable: true,
    configurable: true
  });
})(WebAudioElement.prototype);

module.exports = cc.Audio = Audio;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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