
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/animation/motion-path-helper.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var DynamicAnimCurve = require('./animation-curves').DynamicAnimCurve;

var computeRatioByType = require('./animation-curves').computeRatioByType;

var bezier = require('./bezier').bezier;

var binarySearch = require('../core/utils/binary-search').binarySearchEpsilon;

var v2 = cc.v2;

function Curve(points) {
  this.points = points || [];
  this.beziers = [];
  this.ratios = [];
  this.progresses = [];
  this.length = 0;
  this.computeBeziers();
}

Curve.prototype.computeBeziers = function () {
  this.beziers.length = 0;
  this.ratios.length = 0;
  this.progresses.length = 0;
  this.length = 0;
  var bezier;

  for (var i = 1; i < this.points.length; i++) {
    var startPoint = this.points[i - 1];
    var endPoint = this.points[i];
    bezier = new Bezier();
    bezier.start = startPoint.pos;
    bezier.startCtrlPoint = startPoint.out;
    bezier.end = endPoint.pos;
    bezier.endCtrlPoint = endPoint["in"];
    this.beziers.push(bezier);
    this.length += bezier.getLength();
  }

  var current = 0;

  for (var i = 0; i < this.beziers.length; i++) {
    bezier = this.beziers[i];
    this.ratios[i] = bezier.getLength() / this.length;
    this.progresses[i] = current = current + this.ratios[i];
  }

  return this.beziers;
};

function Bezier() {
  this.start = v2();
  this.end = v2();
  this.startCtrlPoint = v2(); // cp0, cp1

  this.endCtrlPoint = v2(); // cp2, cp3
} // Get point at relative position in curve according to arc length
// - u [0 .. 1]


Bezier.prototype.getPointAt = function (u) {
  var t = this.getUtoTmapping(u);
  return this.getPoint(t);
}; // Get point at time t
//  - t [0 .. 1]


Bezier.prototype.getPoint = function (t) {
  var x = bezier(this.start.x, this.startCtrlPoint.x, this.endCtrlPoint.x, this.end.x, t);
  var y = bezier(this.start.y, this.startCtrlPoint.y, this.endCtrlPoint.y, this.end.y, t);
  return new v2(x, y);
}; // Get total curve arc length


Bezier.prototype.getLength = function () {
  var lengths = this.getLengths();
  return lengths[lengths.length - 1];
}; // Get list of cumulative segment lengths


Bezier.prototype.getLengths = function (divisions) {
  if (!divisions) divisions = this.__arcLengthDivisions ? this.__arcLengthDivisions : 200;

  if (this.cacheArcLengths && this.cacheArcLengths.length === divisions + 1) {
    //console.log( "cached", this.cacheArcLengths );
    return this.cacheArcLengths;
  }

  var cache = [];
  var current,
      last = this.getPoint(0),
      vector = v2();
  var p,
      sum = 0;
  cache.push(0);

  for (p = 1; p <= divisions; p++) {
    current = this.getPoint(p / divisions);
    vector.x = last.x - current.x;
    vector.y = last.y - current.y;
    sum += vector.mag();
    cache.push(sum);
    last = current;
  }

  this.cacheArcLengths = cache;
  return cache; // { sums: cache, sum:sum }; Sum is in the last element.
};

Bezier.prototype.getUtoTmapping = function (u, distance) {
  var arcLengths = this.getLengths();
  var i = 0,
      il = arcLengths.length;
  var targetArcLength; // The targeted u distance value to get

  if (distance) {
    targetArcLength = distance;
  } else {
    targetArcLength = u * arcLengths[il - 1];
  } //var time = Date.now();
  // binary search for the index with largest value smaller than target u distance


  var low = 0,
      high = il - 1,
      comparison;

  while (low <= high) {
    i = Math.floor(low + (high - low) / 2); // less likely to overflow, though probably not issue here, JS doesn't really have integers, all numbers are floats

    comparison = arcLengths[i] - targetArcLength;

    if (comparison < 0) {
      low = i + 1;
      continue;
    } else if (comparison > 0) {
      high = i - 1;
      continue;
    } else {
      high = i;
      break; // DONE
    }
  }

  i = high; //console.log('b' , i, low, high, Date.now()- time);

  if (arcLengths[i] === targetArcLength) {
    var t = i / (il - 1);
    return t;
  } // we could get finer grain at lengths, or use simple interpolatation between two points


  var lengthBefore = arcLengths[i];
  var lengthAfter = arcLengths[i + 1];
  var segmentLength = lengthAfter - lengthBefore; // determine where we are between the 'before' and 'after' points

  var segmentFraction = (targetArcLength - lengthBefore) / segmentLength; // add that fractional amount to t

  var t = (i + segmentFraction) / (il - 1);
  return t;
};

function checkMotionPath(motionPath) {
  if (!Array.isArray(motionPath)) return false;

  for (var i = 0, l = motionPath.length; i < l; i++) {
    var controls = motionPath[i];
    if (!Array.isArray(controls) || controls.length !== 6) return false;
  }

  return true;
}

function sampleMotionPaths(motionPaths, data, duration, fps, target) {
  function createControlPoints(array) {
    if (array instanceof cc.Vec2) {
      return {
        "in": array,
        pos: array,
        out: array
      };
    } else if (Array.isArray(array) && array.length === 6) {
      return {
        "in": v2(array[2], array[3]),
        pos: v2(array[0], array[1]),
        out: v2(array[4], array[5])
      };
    }

    return {
      "in": cc.Vec2.ZERO,
      pos: cc.Vec2.ZERO,
      out: cc.Vec2.ZERO
    };
  }

  var values = data.values = data.values.map(function (value) {
    if (Array.isArray(value)) {
      value = value.length === 2 ? cc.v2(value[0], value[1]) : cc.v3(value[0], value[1], value[2]);
    }

    return value;
  });

  if (motionPaths.length === 0 || values.length === 0) {
    return;
  }

  var motionPathValid = false;

  for (var _i = 0; _i < motionPaths.length; _i++) {
    var _motionPath = motionPaths[_i];

    if (_motionPath && !checkMotionPath(_motionPath)) {
      cc.errorID(3904, target ? target.name : '', 'position', _i);
      _motionPath = null;
    }

    if (_motionPath && _motionPath.length > 0) {
      motionPathValid = true;
      break;
    }
  }

  if (!motionPathValid) {
    return;
  }

  if (values.length === 1) {
    return;
  }

  var types = data.types;
  var ratios = data.ratios;
  var newValues = data.values = [];
  var newTypes = data.types = [];
  var newRatios = data.ratios = [];

  function addNewDatas(value, type, ratio) {
    newValues.push(value);
    newTypes.push(type);
    newRatios.push(ratio);
  } // ensure every ratio section's length is the same


  var startRatioOffset = 0;
  var EPSILON = 1e-6;
  var newType = DynamicAnimCurve.Linear; // do not need to compute last path

  for (var i = 0, l = motionPaths.length; i < l - 1; i++) {
    var motionPath = motionPaths[i];
    var ratio = ratios[i];
    var nextRatio = ratios[i + 1];
    var betweenRatio = nextRatio - ratio;
    var value = values[i];
    var nextValue = values[i + 1];
    var type = types[i];
    var results = [];
    var progress = startRatioOffset / betweenRatio;
    var speed = 1 / (betweenRatio * duration * fps);
    var finalProgress;

    if (motionPath && motionPath.length > 0) {
      var points = [];
      points.push(createControlPoints(value));

      for (var j = 0, l2 = motionPath.length; j < l2; j++) {
        var controlPoints = createControlPoints(motionPath[j]);
        points.push(controlPoints);
      }

      points.push(createControlPoints(nextValue)); // create Curve to compute beziers

      var curve = new Curve(points);
      curve.computeBeziers(); // sample beziers

      var progresses = curve.progresses;

      while (1 - progress > EPSILON) {
        finalProgress = progress;
        finalProgress = computeRatioByType(finalProgress, type);
        var pos, bezier, normal, length;

        if (finalProgress < 0) {
          bezier = curve.beziers[0];
          length = (0 - finalProgress) * bezier.getLength();
          normal = bezier.start.sub(bezier.endCtrlPoint).normalize();
          pos = bezier.start.add(normal.mul(length));
        } else if (finalProgress > 1) {
          bezier = curve.beziers[curve.beziers.length - 1];
          length = (finalProgress - 1) * bezier.getLength();
          normal = bezier.end.sub(bezier.startCtrlPoint).normalize();
          pos = bezier.end.add(normal.mul(length));
        } else {
          var bezierIndex = binarySearch(progresses, finalProgress);
          if (bezierIndex < 0) bezierIndex = ~bezierIndex;
          finalProgress -= bezierIndex > 0 ? progresses[bezierIndex - 1] : 0;
          finalProgress = finalProgress / curve.ratios[bezierIndex];
          pos = curve.beziers[bezierIndex].getPointAt(finalProgress);
        }

        results.push(pos);
        progress += speed;
      }
    } else {
      while (1 - progress > EPSILON) {
        finalProgress = progress;
        finalProgress = computeRatioByType(finalProgress, type);
        results.push(value.lerp(nextValue, finalProgress));
        progress += speed;
      }
    }

    newType = type === 'constant' ? type : DynamicAnimCurve.Linear;

    for (var j = 0, l2 = results.length; j < l2; j++) {
      var newRatio = ratio + startRatioOffset + speed * j * betweenRatio;
      addNewDatas(results[j], newType, newRatio);
    }

    if (Math.abs(progress - 1) > EPSILON) // progress > 1
      startRatioOffset = (progress - 1) * betweenRatio;else startRatioOffset = 0;
  }

  if (ratios[ratios.length - 1] !== newRatios[newRatios.length - 1]) {
    addNewDatas(values[values.length - 1], newType, ratios[ratios.length - 1]);
  }
}

if (CC_TEST) {
  cc._Test.sampleMotionPaths = sampleMotionPaths;
}

module.exports = {
  sampleMotionPaths: sampleMotionPaths,
  Curve: Curve,
  Bezier: Bezier
};
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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