
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/animation/bezier.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
//var bezier = (function () {
//    function B1 (t) { return (t * t * t); }
//    function B2 (t) { return (3 * t * t * (1 - t)); }
//    function B3 (t) { return (3 * t * (1 - t) * (1 - t)); }
//    function B4 (t) { return ((1 - t) * (1 - t) * (1 - t)); }
//    function bezier (C1, C2, C3, C4, t) {
//        return C1 * B1(t) + C2 * B2(t) + C3 * B3(t) + C4 * B4(t);
//    }
//
//    //function bezier (C1, C2, C3, C4, t, out) {
//    //    out.x = C1.x * B1(t) + C2.x * B2(t) + C3.x * B3(t) + C4.x * B4(t);
//    //    out.y = C1.y * B1(t) + C2.y * B2(t) + C3.y * B3(t) + C4.y * B4(t);
//    //}
//
//    return bezier;
//})();
function bezier(C1, C2, C3, C4, t) {
  var t1 = 1 - t;
  return t1 * (t1 * (C1 + (C2 * 3 - C1) * t) + C3 * 3 * t * t) + C4 * t * t * t;
} //function bezier (c0, c1, c2, c3, t) {
//    var cy = 3.0 * (c1);
//    var by = 3.0 * (c3 - c1) - cy;
//    var ay = 1 - cy - by;
//    return (ay * t * t * t) + (by * t * t) + (cy * t);
//}
//var sin = Math.sin;


var cos = Math.cos,
    acos = Math.acos,
    max = Math.max,
    //atan2 = Math.atan2,
pi = Math.PI,
    tau = 2 * pi,
    sqrt = Math.sqrt;

function crt(v) {
  if (v < 0) {
    return -Math.pow(-v, 1 / 3);
  } else {
    return Math.pow(v, 1 / 3);
  }
} //function align (curve, line) {
//    var tx = line.p1.x,
//        ty = line.p1.y,
//        a = -atan2(line.p2.y-ty, line.p2.x-tx);
//    curve = [{x:0, y:1}, {x: curve[0], y: 1-curve[1]}, {x: curve[2], y: 1-curve[3]}, {x:1, y:0}];
//    return curve.map(function(v) {
//        return {
//            x: (v.x-tx)*cos(a) - (v.y-ty)*sin(a),
//            y: (v.x-tx)*sin(a) + (v.y-ty)*cos(a)
//        };
//    });
//}
// Modified from http://jsbin.com/yibipofeqi/1/edit, optimized for animations.
// The origin Cardano's algorithm is based on http://www.trans4mind.com/personal_development/mathematics/polynomials/cubicAlgebra.htm


function cardano(curve, x) {
  // align curve with the intersecting line:
  //var line = {p1: {x: x, y: 0}, p2: {x: x, y: 1}};
  //var aligned = align(curve, line);
  //// and rewrite from [a(1-t)^3 + 3bt(1-t)^2 + 3c(1-t)t^2 + dt^3] form
  //    pa = aligned[0].y,
  //    pb = aligned[1].y,
  //    pc = aligned[2].y,
  //    pd = aligned[3].y;
  ////// curve = [{x:0, y:1}, {x: curve[0], y: 1-curve[1]}, {x: curve[2], y: 1-curve[3]}, {x:1, y:0}];
  var pa = x - 0;
  var pb = x - curve[0];
  var pc = x - curve[2];
  var pd = x - 1; // to [t^3 + at^2 + bt + c] form:

  var pa3 = pa * 3;
  var pb3 = pb * 3;
  var pc3 = pc * 3;
  var d = -pa + pb3 - pc3 + pd,
      rd = 1 / d,
      r3 = 1 / 3,
      a = (pa3 - 6 * pb + pc3) * rd,
      a3 = a * r3,
      b = (-pa3 + pb3) * rd,
      c = pa * rd,
      // then, determine p and q:
  p = (3 * b - a * a) * r3,
      p3 = p * r3,
      q = (2 * a * a * a - 9 * a * b + 27 * c) / 27,
      q2 = q / 2,
      // and determine the discriminant:
  discriminant = q2 * q2 + p3 * p3 * p3,
      // and some reserved variables
  u1,
      v1,
      x1,
      x2,
      x3; // If the discriminant is negative, use polar coordinates
  // to get around square roots of negative numbers

  if (discriminant < 0) {
    var mp3 = -p * r3,
        mp33 = mp3 * mp3 * mp3,
        r = sqrt(mp33),
        // compute cosphi corrected for IEEE float rounding:
    t = -q / (2 * r),
        cosphi = t < -1 ? -1 : t > 1 ? 1 : t,
        phi = acos(cosphi),
        crtr = crt(r),
        t1 = 2 * crtr;
    x1 = t1 * cos(phi * r3) - a3;
    x2 = t1 * cos((phi + tau) * r3) - a3;
    x3 = t1 * cos((phi + 2 * tau) * r3) - a3; // choose best percentage

    if (0 <= x1 && x1 <= 1) {
      if (0 <= x2 && x2 <= 1) {
        if (0 <= x3 && x3 <= 1) {
          return max(x1, x2, x3);
        } else {
          return max(x1, x2);
        }
      } else if (0 <= x3 && x3 <= 1) {
        return max(x1, x3);
      } else {
        return x1;
      }
    } else {
      if (0 <= x2 && x2 <= 1) {
        if (0 <= x3 && x3 <= 1) {
          return max(x2, x3);
        } else {
          return x2;
        }
      } else {
        return x3;
      }
    }
  } else if (discriminant === 0) {
    u1 = q2 < 0 ? crt(-q2) : -crt(q2);
    x1 = 2 * u1 - a3;
    x2 = -u1 - a3; // choose best percentage

    if (0 <= x1 && x1 <= 1) {
      if (0 <= x2 && x2 <= 1) {
        return max(x1, x2);
      } else {
        return x1;
      }
    } else {
      return x2;
    }
  } // one real root, and two imaginary roots
  else {
      var sd = sqrt(discriminant);
      u1 = crt(-q2 + sd);
      v1 = crt(q2 + sd);
      x1 = u1 - v1 - a3;
      return x1;
    }
}

function bezierByTime(controlPoints, x) {
  var percent = cardano(controlPoints, x); // t

  var p1y = controlPoints[1]; // b

  var p2y = controlPoints[3]; // c
  // return bezier(0, p1y, p2y, 1, percent);

  return ((1 - percent) * (p1y + (p2y - p1y) * percent) * 3 + percent * percent) * percent;
}

if (CC_TEST) {
  cc._Test.bezier = bezier;
  cc._Test.bezierByTime = bezierByTime;
}

module.exports = {
  bezier: bezier,
  bezierByTime: bezierByTime
};
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvY29jb3MyZC9hbmltYXRpb24vYmV6aWVyLmpzIl0sIm5hbWVzIjpbImJlemllciIsIkMxIiwiQzIiLCJDMyIsIkM0IiwidCIsInQxIiwiY29zIiwiTWF0aCIsImFjb3MiLCJtYXgiLCJwaSIsIlBJIiwidGF1Iiwic3FydCIsImNydCIsInYiLCJwb3ciLCJjYXJkYW5vIiwiY3VydmUiLCJ4IiwicGEiLCJwYiIsInBjIiwicGQiLCJwYTMiLCJwYjMiLCJwYzMiLCJkIiwicmQiLCJyMyIsImEiLCJhMyIsImIiLCJjIiwicCIsInAzIiwicSIsInEyIiwiZGlzY3JpbWluYW50IiwidTEiLCJ2MSIsIngxIiwieDIiLCJ4MyIsIm1wMyIsIm1wMzMiLCJyIiwiY29zcGhpIiwicGhpIiwiY3J0ciIsInNkIiwiYmV6aWVyQnlUaW1lIiwiY29udHJvbFBvaW50cyIsInBlcmNlbnQiLCJwMXkiLCJwMnkiLCJDQ19URVNUIiwiY2MiLCJfVGVzdCIsIm1vZHVsZSIsImV4cG9ydHMiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7QUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBeUJBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBU0EsTUFBVCxDQUFpQkMsRUFBakIsRUFBcUJDLEVBQXJCLEVBQXlCQyxFQUF6QixFQUE2QkMsRUFBN0IsRUFBaUNDLENBQWpDLEVBQW9DO0FBQ2hDLE1BQUlDLEVBQUUsR0FBRyxJQUFJRCxDQUFiO0FBQ0EsU0FBT0MsRUFBRSxJQUFJQSxFQUFFLElBQUlMLEVBQUUsR0FBRyxDQUFDQyxFQUFFLEdBQUcsQ0FBTCxHQUFTRCxFQUFWLElBQWdCSSxDQUF6QixDQUFGLEdBQWdDRixFQUFFLEdBQUcsQ0FBTCxHQUFTRSxDQUFULEdBQWFBLENBQWpELENBQUYsR0FBd0RELEVBQUUsR0FBR0MsQ0FBTCxHQUFTQSxDQUFULEdBQWFBLENBQTVFO0FBQ0gsRUFDRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFFQTs7O0FBQ0EsSUFBSUUsR0FBRyxHQUFHQyxJQUFJLENBQUNELEdBQWY7QUFBQSxJQUNJRSxJQUFJLEdBQUdELElBQUksQ0FBQ0MsSUFEaEI7QUFBQSxJQUVJQyxHQUFHLEdBQUdGLElBQUksQ0FBQ0UsR0FGZjtBQUFBLElBR0k7QUFDQUMsRUFBRSxHQUFHSCxJQUFJLENBQUNJLEVBSmQ7QUFBQSxJQUtJQyxHQUFHLEdBQUcsSUFBSUYsRUFMZDtBQUFBLElBTUlHLElBQUksR0FBR04sSUFBSSxDQUFDTSxJQU5oQjs7QUFRQSxTQUFTQyxHQUFULENBQWNDLENBQWQsRUFBaUI7QUFDYixNQUFJQSxDQUFDLEdBQUcsQ0FBUixFQUFXO0FBQ1AsV0FBTyxDQUFDUixJQUFJLENBQUNTLEdBQUwsQ0FBUyxDQUFDRCxDQUFWLEVBQWEsSUFBSSxDQUFqQixDQUFSO0FBQ0gsR0FGRCxNQUdLO0FBQ0QsV0FBT1IsSUFBSSxDQUFDUyxHQUFMLENBQVNELENBQVQsRUFBWSxJQUFJLENBQWhCLENBQVA7QUFDSDtBQUNKLEVBRUQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBRUE7QUFDQTs7O0FBQ0EsU0FBU0UsT0FBVCxDQUFrQkMsS0FBbEIsRUFBeUJDLENBQXpCLEVBQTRCO0FBQ3hCO0FBQ0k7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNKLE1BQUlDLEVBQUUsR0FBR0QsQ0FBQyxHQUFHLENBQWI7QUFDQSxNQUFJRSxFQUFFLEdBQUdGLENBQUMsR0FBR0QsS0FBSyxDQUFDLENBQUQsQ0FBbEI7QUFDQSxNQUFJSSxFQUFFLEdBQUdILENBQUMsR0FBR0QsS0FBSyxDQUFDLENBQUQsQ0FBbEI7QUFDQSxNQUFJSyxFQUFFLEdBQUdKLENBQUMsR0FBRyxDQUFiLENBYndCLENBZXhCOztBQUNBLE1BQUlLLEdBQUcsR0FBR0osRUFBRSxHQUFHLENBQWY7QUFDQSxNQUFJSyxHQUFHLEdBQUdKLEVBQUUsR0FBRyxDQUFmO0FBQ0EsTUFBSUssR0FBRyxHQUFHSixFQUFFLEdBQUcsQ0FBZjtBQUNBLE1BQUlLLENBQUMsR0FBSSxDQUFDUCxFQUFELEdBQU1LLEdBQU4sR0FBWUMsR0FBWixHQUFrQkgsRUFBM0I7QUFBQSxNQUNJSyxFQUFFLEdBQUcsSUFBSUQsQ0FEYjtBQUFBLE1BRUlFLEVBQUUsR0FBRyxJQUFJLENBRmI7QUFBQSxNQUdJQyxDQUFDLEdBQUcsQ0FBQ04sR0FBRyxHQUFHLElBQUlILEVBQVYsR0FBZUssR0FBaEIsSUFBdUJFLEVBSC9CO0FBQUEsTUFJSUcsRUFBRSxHQUFHRCxDQUFDLEdBQUdELEVBSmI7QUFBQSxNQUtJRyxDQUFDLEdBQUcsQ0FBQyxDQUFDUixHQUFELEdBQU9DLEdBQVIsSUFBZUcsRUFMdkI7QUFBQSxNQU1JSyxDQUFDLEdBQUdiLEVBQUUsR0FBR1EsRUFOYjtBQUFBLE1BT0E7QUFDSU0sRUFBQUEsQ0FBQyxHQUFHLENBQUMsSUFBSUYsQ0FBSixHQUFRRixDQUFDLEdBQUdBLENBQWIsSUFBa0JELEVBUjFCO0FBQUEsTUFTSU0sRUFBRSxHQUFHRCxDQUFDLEdBQUdMLEVBVGI7QUFBQSxNQVVJTyxDQUFDLEdBQUcsQ0FBQyxJQUFJTixDQUFKLEdBQVFBLENBQVIsR0FBWUEsQ0FBWixHQUFnQixJQUFJQSxDQUFKLEdBQVFFLENBQXhCLEdBQTRCLEtBQUtDLENBQWxDLElBQXVDLEVBVi9DO0FBQUEsTUFXSUksRUFBRSxHQUFHRCxDQUFDLEdBQUcsQ0FYYjtBQUFBLE1BWUE7QUFDSUUsRUFBQUEsWUFBWSxHQUFHRCxFQUFFLEdBQUdBLEVBQUwsR0FBVUYsRUFBRSxHQUFHQSxFQUFMLEdBQVVBLEVBYnZDO0FBQUEsTUFjQTtBQUNJSSxFQUFBQSxFQWZKO0FBQUEsTUFlUUMsRUFmUjtBQUFBLE1BZVlDLEVBZlo7QUFBQSxNQWVnQkMsRUFmaEI7QUFBQSxNQWVvQkMsRUFmcEIsQ0FuQndCLENBb0N4QjtBQUNBOztBQUNBLE1BQUlMLFlBQVksR0FBRyxDQUFuQixFQUFzQjtBQUNsQixRQUFJTSxHQUFHLEdBQUcsQ0FBQ1YsQ0FBRCxHQUFLTCxFQUFmO0FBQUEsUUFDSWdCLElBQUksR0FBR0QsR0FBRyxHQUFHQSxHQUFOLEdBQVlBLEdBRHZCO0FBQUEsUUFFSUUsQ0FBQyxHQUFHakMsSUFBSSxDQUFDZ0MsSUFBRCxDQUZaO0FBQUEsUUFHQTtBQUNJekMsSUFBQUEsQ0FBQyxHQUFHLENBQUNnQyxDQUFELElBQU0sSUFBSVUsQ0FBVixDQUpSO0FBQUEsUUFLSUMsTUFBTSxHQUFHM0MsQ0FBQyxHQUFHLENBQUMsQ0FBTCxHQUFTLENBQUMsQ0FBVixHQUFjQSxDQUFDLEdBQUcsQ0FBSixHQUFRLENBQVIsR0FBWUEsQ0FMdkM7QUFBQSxRQU1JNEMsR0FBRyxHQUFHeEMsSUFBSSxDQUFDdUMsTUFBRCxDQU5kO0FBQUEsUUFPSUUsSUFBSSxHQUFHbkMsR0FBRyxDQUFDZ0MsQ0FBRCxDQVBkO0FBQUEsUUFRSXpDLEVBQUUsR0FBRyxJQUFJNEMsSUFSYjtBQVNBUixJQUFBQSxFQUFFLEdBQUdwQyxFQUFFLEdBQUdDLEdBQUcsQ0FBQzBDLEdBQUcsR0FBR25CLEVBQVAsQ0FBUixHQUFxQkUsRUFBMUI7QUFDQVcsSUFBQUEsRUFBRSxHQUFHckMsRUFBRSxHQUFHQyxHQUFHLENBQUMsQ0FBQzBDLEdBQUcsR0FBR3BDLEdBQVAsSUFBY2lCLEVBQWYsQ0FBUixHQUE2QkUsRUFBbEM7QUFDQVksSUFBQUEsRUFBRSxHQUFHdEMsRUFBRSxHQUFHQyxHQUFHLENBQUMsQ0FBQzBDLEdBQUcsR0FBRyxJQUFJcEMsR0FBWCxJQUFrQmlCLEVBQW5CLENBQVIsR0FBaUNFLEVBQXRDLENBWmtCLENBY2xCOztBQUNBLFFBQUksS0FBS1UsRUFBTCxJQUFXQSxFQUFFLElBQUksQ0FBckIsRUFBd0I7QUFDcEIsVUFBSSxLQUFLQyxFQUFMLElBQVdBLEVBQUUsSUFBSSxDQUFyQixFQUF3QjtBQUNwQixZQUFJLEtBQUtDLEVBQUwsSUFBV0EsRUFBRSxJQUFJLENBQXJCLEVBQXdCO0FBQ3BCLGlCQUFPbEMsR0FBRyxDQUFDZ0MsRUFBRCxFQUFLQyxFQUFMLEVBQVNDLEVBQVQsQ0FBVjtBQUNILFNBRkQsTUFHSztBQUNELGlCQUFPbEMsR0FBRyxDQUFDZ0MsRUFBRCxFQUFLQyxFQUFMLENBQVY7QUFDSDtBQUNKLE9BUEQsTUFRSyxJQUFJLEtBQUtDLEVBQUwsSUFBV0EsRUFBRSxJQUFJLENBQXJCLEVBQXdCO0FBQ3pCLGVBQU9sQyxHQUFHLENBQUNnQyxFQUFELEVBQUtFLEVBQUwsQ0FBVjtBQUNILE9BRkksTUFHQTtBQUNELGVBQU9GLEVBQVA7QUFDSDtBQUNKLEtBZkQsTUFnQks7QUFDRCxVQUFJLEtBQUtDLEVBQUwsSUFBV0EsRUFBRSxJQUFJLENBQXJCLEVBQXdCO0FBQ3BCLFlBQUksS0FBS0MsRUFBTCxJQUFXQSxFQUFFLElBQUksQ0FBckIsRUFBd0I7QUFDcEIsaUJBQU9sQyxHQUFHLENBQUNpQyxFQUFELEVBQUtDLEVBQUwsQ0FBVjtBQUNILFNBRkQsTUFHSztBQUNELGlCQUFPRCxFQUFQO0FBQ0g7QUFDSixPQVBELE1BUUs7QUFDRCxlQUFPQyxFQUFQO0FBQ0g7QUFDSjtBQUNKLEdBNUNELE1BNkNLLElBQUlMLFlBQVksS0FBSyxDQUFyQixFQUF3QjtBQUN6QkMsSUFBQUEsRUFBRSxHQUFHRixFQUFFLEdBQUcsQ0FBTCxHQUFTdkIsR0FBRyxDQUFDLENBQUN1QixFQUFGLENBQVosR0FBb0IsQ0FBQ3ZCLEdBQUcsQ0FBQ3VCLEVBQUQsQ0FBN0I7QUFDQUksSUFBQUEsRUFBRSxHQUFHLElBQUlGLEVBQUosR0FBU1IsRUFBZDtBQUNBVyxJQUFBQSxFQUFFLEdBQUcsQ0FBQ0gsRUFBRCxHQUFNUixFQUFYLENBSHlCLENBS3pCOztBQUNBLFFBQUksS0FBS1UsRUFBTCxJQUFXQSxFQUFFLElBQUksQ0FBckIsRUFBd0I7QUFDcEIsVUFBSSxLQUFLQyxFQUFMLElBQVdBLEVBQUUsSUFBSSxDQUFyQixFQUF3QjtBQUNwQixlQUFPakMsR0FBRyxDQUFDZ0MsRUFBRCxFQUFLQyxFQUFMLENBQVY7QUFDSCxPQUZELE1BR0s7QUFDRCxlQUFPRCxFQUFQO0FBQ0g7QUFDSixLQVBELE1BUUs7QUFDRCxhQUFPQyxFQUFQO0FBQ0g7QUFDSixHQWpCSSxDQWtCTDtBQWxCSyxPQW1CQTtBQUNELFVBQUlRLEVBQUUsR0FBR3JDLElBQUksQ0FBQ3lCLFlBQUQsQ0FBYjtBQUNBQyxNQUFBQSxFQUFFLEdBQUd6QixHQUFHLENBQUMsQ0FBQ3VCLEVBQUQsR0FBTWEsRUFBUCxDQUFSO0FBQ0FWLE1BQUFBLEVBQUUsR0FBRzFCLEdBQUcsQ0FBQ3VCLEVBQUUsR0FBR2EsRUFBTixDQUFSO0FBQ0FULE1BQUFBLEVBQUUsR0FBR0YsRUFBRSxHQUFHQyxFQUFMLEdBQVVULEVBQWY7QUFDQSxhQUFPVSxFQUFQO0FBQ0g7QUFDSjs7QUFFRCxTQUFTVSxZQUFULENBQXVCQyxhQUF2QixFQUFzQ2pDLENBQXRDLEVBQXlDO0FBQ3JDLE1BQUlrQyxPQUFPLEdBQUdwQyxPQUFPLENBQUNtQyxhQUFELEVBQWdCakMsQ0FBaEIsQ0FBckIsQ0FEcUMsQ0FDTzs7QUFDNUMsTUFBSW1DLEdBQUcsR0FBR0YsYUFBYSxDQUFDLENBQUQsQ0FBdkIsQ0FGcUMsQ0FFVDs7QUFDNUIsTUFBSUcsR0FBRyxHQUFHSCxhQUFhLENBQUMsQ0FBRCxDQUF2QixDQUhxQyxDQUdUO0FBQzVCOztBQUNBLFNBQU8sQ0FBQyxDQUFDLElBQUlDLE9BQUwsS0FBaUJDLEdBQUcsR0FBRyxDQUFDQyxHQUFHLEdBQUdELEdBQVAsSUFBY0QsT0FBckMsSUFBZ0QsQ0FBaEQsR0FBb0RBLE9BQU8sR0FBR0EsT0FBL0QsSUFBMEVBLE9BQWpGO0FBQ0g7O0FBRUQsSUFBSUcsT0FBSixFQUFhO0FBQ1RDLEVBQUFBLEVBQUUsQ0FBQ0MsS0FBSCxDQUFTM0QsTUFBVCxHQUFrQkEsTUFBbEI7QUFDQTBELEVBQUFBLEVBQUUsQ0FBQ0MsS0FBSCxDQUFTUCxZQUFULEdBQXdCQSxZQUF4QjtBQUNIOztBQUVEUSxNQUFNLENBQUNDLE9BQVAsR0FBaUI7QUFDYjdELEVBQUFBLE1BQU0sRUFBRUEsTUFESztBQUVib0QsRUFBQUEsWUFBWSxFQUFFQTtBQUZELENBQWpCIiwic291cmNlc0NvbnRlbnQiOlsiLyoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKipcbiBDb3B5cmlnaHQgKGMpIDIwMTctMjAxOCBYaWFtZW4gWWFqaSBTb2Z0d2FyZSBDby4sIEx0ZC5cblxuIGh0dHBzOi8vd3d3LmNvY29zLmNvbS9cblxuIFBlcm1pc3Npb24gaXMgaGVyZWJ5IGdyYW50ZWQsIGZyZWUgb2YgY2hhcmdlLCB0byBhbnkgcGVyc29uIG9idGFpbmluZyBhIGNvcHlcbiBvZiB0aGlzIHNvZnR3YXJlIGFuZCBhc3NvY2lhdGVkIGVuZ2luZSBzb3VyY2UgY29kZSAodGhlIFwiU29mdHdhcmVcIiksIGEgbGltaXRlZCxcbiB3b3JsZHdpZGUsIHJveWFsdHktZnJlZSwgbm9uLWFzc2lnbmFibGUsIHJldm9jYWJsZSBhbmQgbm9uLWV4Y2x1c2l2ZSBsaWNlbnNlXG4gdG8gdXNlIENvY29zIENyZWF0b3Igc29sZWx5IHRvIGRldmVsb3AgZ2FtZXMgb24geW91ciB0YXJnZXQgcGxhdGZvcm1zLiBZb3Ugc2hhbGxcbiBub3QgdXNlIENvY29zIENyZWF0b3Igc29mdHdhcmUgZm9yIGRldmVsb3Bpbmcgb3RoZXIgc29mdHdhcmUgb3IgdG9vbHMgdGhhdCdzXG4gdXNlZCBmb3IgZGV2ZWxvcGluZyBnYW1lcy4gWW91IGFyZSBub3QgZ3JhbnRlZCB0byBwdWJsaXNoLCBkaXN0cmlidXRlLFxuIHN1YmxpY2Vuc2UsIGFuZC9vciBzZWxsIGNvcGllcyBvZiBDb2NvcyBDcmVhdG9yLlxuXG4gVGhlIHNvZnR3YXJlIG9yIHRvb2xzIGluIHRoaXMgTGljZW5zZSBBZ3JlZW1lbnQgYXJlIGxpY2Vuc2VkLCBub3Qgc29sZC5cbiBYaWFtZW4gWWFqaSBTb2Z0d2FyZSBDby4sIEx0ZC4gcmVzZXJ2ZXMgYWxsIHJpZ2h0cyBub3QgZXhwcmVzc2x5IGdyYW50ZWQgdG8geW91LlxuXG4gVEhFIFNPRlRXQVJFIElTIFBST1ZJREVEIFwiQVMgSVNcIiwgV0lUSE9VVCBXQVJSQU5UWSBPRiBBTlkgS0lORCwgRVhQUkVTUyBPUlxuIElNUExJRUQsIElOQ0xVRElORyBCVVQgTk9UIExJTUlURUQgVE8gVEhFIFdBUlJBTlRJRVMgT0YgTUVSQ0hBTlRBQklMSVRZLFxuIEZJVE5FU1MgRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFIEFORCBOT05JTkZSSU5HRU1FTlQuIElOIE5PIEVWRU5UIFNIQUxMIFRIRVxuIEFVVEhPUlMgT1IgQ09QWVJJR0hUIEhPTERFUlMgQkUgTElBQkxFIEZPUiBBTlkgQ0xBSU0sIERBTUFHRVMgT1IgT1RIRVJcbiBMSUFCSUxJVFksIFdIRVRIRVIgSU4gQU4gQUNUSU9OIE9GIENPTlRSQUNULCBUT1JUIE9SIE9USEVSV0lTRSwgQVJJU0lORyBGUk9NLFxuIE9VVCBPRiBPUiBJTiBDT05ORUNUSU9OIFdJVEggVEhFIFNPRlRXQVJFIE9SIFRIRSBVU0UgT1IgT1RIRVIgREVBTElOR1MgSU5cbiBUSEUgU09GVFdBUkUuXG4gKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKi9cblxuLy92YXIgYmV6aWVyID0gKGZ1bmN0aW9uICgpIHtcbi8vICAgIGZ1bmN0aW9uIEIxICh0KSB7IHJldHVybiAodCAqIHQgKiB0KTsgfVxuLy8gICAgZnVuY3Rpb24gQjIgKHQpIHsgcmV0dXJuICgzICogdCAqIHQgKiAoMSAtIHQpKTsgfVxuLy8gICAgZnVuY3Rpb24gQjMgKHQpIHsgcmV0dXJuICgzICogdCAqICgxIC0gdCkgKiAoMSAtIHQpKTsgfVxuLy8gICAgZnVuY3Rpb24gQjQgKHQpIHsgcmV0dXJuICgoMSAtIHQpICogKDEgLSB0KSAqICgxIC0gdCkpOyB9XG4vLyAgICBmdW5jdGlvbiBiZXppZXIgKEMxLCBDMiwgQzMsIEM0LCB0KSB7XG4vLyAgICAgICAgcmV0dXJuIEMxICogQjEodCkgKyBDMiAqIEIyKHQpICsgQzMgKiBCMyh0KSArIEM0ICogQjQodCk7XG4vLyAgICB9XG4vL1xuLy8gICAgLy9mdW5jdGlvbiBiZXppZXIgKEMxLCBDMiwgQzMsIEM0LCB0LCBvdXQpIHtcbi8vICAgIC8vICAgIG91dC54ID0gQzEueCAqIEIxKHQpICsgQzIueCAqIEIyKHQpICsgQzMueCAqIEIzKHQpICsgQzQueCAqIEI0KHQpO1xuLy8gICAgLy8gICAgb3V0LnkgPSBDMS55ICogQjEodCkgKyBDMi55ICogQjIodCkgKyBDMy55ICogQjModCkgKyBDNC55ICogQjQodCk7XG4vLyAgICAvL31cbi8vXG4vLyAgICByZXR1cm4gYmV6aWVyO1xuLy99KSgpO1xuZnVuY3Rpb24gYmV6aWVyIChDMSwgQzIsIEMzLCBDNCwgdCkge1xuICAgIHZhciB0MSA9IDEgLSB0O1xuICAgIHJldHVybiB0MSAqICh0MSAqIChDMSArIChDMiAqIDMgLSBDMSkgKiB0KSArIEMzICogMyAqIHQgKiB0KSArIEM0ICogdCAqIHQgKiB0O1xufVxuLy9mdW5jdGlvbiBiZXppZXIgKGMwLCBjMSwgYzIsIGMzLCB0KSB7XG4vLyAgICB2YXIgY3kgPSAzLjAgKiAoYzEpO1xuLy8gICAgdmFyIGJ5ID0gMy4wICogKGMzIC0gYzEpIC0gY3k7XG4vLyAgICB2YXIgYXkgPSAxIC0gY3kgLSBieTtcbi8vICAgIHJldHVybiAoYXkgKiB0ICogdCAqIHQpICsgKGJ5ICogdCAqIHQpICsgKGN5ICogdCk7XG4vL31cblxuLy92YXIgc2luID0gTWF0aC5zaW47XG52YXIgY29zID0gTWF0aC5jb3MsXG4gICAgYWNvcyA9IE1hdGguYWNvcyxcbiAgICBtYXggPSBNYXRoLm1heCxcbiAgICAvL2F0YW4yID0gTWF0aC5hdGFuMixcbiAgICBwaSA9IE1hdGguUEksXG4gICAgdGF1ID0gMiAqIHBpLFxuICAgIHNxcnQgPSBNYXRoLnNxcnQ7XG5cbmZ1bmN0aW9uIGNydCAodikge1xuICAgIGlmICh2IDwgMCkge1xuICAgICAgICByZXR1cm4gLU1hdGgucG93KC12LCAxIC8gMyk7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgICByZXR1cm4gTWF0aC5wb3codiwgMSAvIDMpO1xuICAgIH1cbn1cblxuLy9mdW5jdGlvbiBhbGlnbiAoY3VydmUsIGxpbmUpIHtcbi8vICAgIHZhciB0eCA9IGxpbmUucDEueCxcbi8vICAgICAgICB0eSA9IGxpbmUucDEueSxcbi8vICAgICAgICBhID0gLWF0YW4yKGxpbmUucDIueS10eSwgbGluZS5wMi54LXR4KTtcbi8vICAgIGN1cnZlID0gW3t4OjAsIHk6MX0sIHt4OiBjdXJ2ZVswXSwgeTogMS1jdXJ2ZVsxXX0sIHt4OiBjdXJ2ZVsyXSwgeTogMS1jdXJ2ZVszXX0sIHt4OjEsIHk6MH1dO1xuLy8gICAgcmV0dXJuIGN1cnZlLm1hcChmdW5jdGlvbih2KSB7XG4vLyAgICAgICAgcmV0dXJuIHtcbi8vICAgICAgICAgICAgeDogKHYueC10eCkqY29zKGEpIC0gKHYueS10eSkqc2luKGEpLFxuLy8gICAgICAgICAgICB5OiAodi54LXR4KSpzaW4oYSkgKyAodi55LXR5KSpjb3MoYSlcbi8vICAgICAgICB9O1xuLy8gICAgfSk7XG4vL31cblxuLy8gTW9kaWZpZWQgZnJvbSBodHRwOi8vanNiaW4uY29tL3lpYmlwb2ZlcWkvMS9lZGl0LCBvcHRpbWl6ZWQgZm9yIGFuaW1hdGlvbnMuXG4vLyBUaGUgb3JpZ2luIENhcmRhbm8ncyBhbGdvcml0aG0gaXMgYmFzZWQgb24gaHR0cDovL3d3dy50cmFuczRtaW5kLmNvbS9wZXJzb25hbF9kZXZlbG9wbWVudC9tYXRoZW1hdGljcy9wb2x5bm9taWFscy9jdWJpY0FsZ2VicmEuaHRtXG5mdW5jdGlvbiBjYXJkYW5vIChjdXJ2ZSwgeCkge1xuICAgIC8vIGFsaWduIGN1cnZlIHdpdGggdGhlIGludGVyc2VjdGluZyBsaW5lOlxuICAgICAgICAvL3ZhciBsaW5lID0ge3AxOiB7eDogeCwgeTogMH0sIHAyOiB7eDogeCwgeTogMX19O1xuICAgICAgICAvL3ZhciBhbGlnbmVkID0gYWxpZ24oY3VydmUsIGxpbmUpO1xuICAgICAgICAvLy8vIGFuZCByZXdyaXRlIGZyb20gW2EoMS10KV4zICsgM2J0KDEtdCleMiArIDNjKDEtdCl0XjIgKyBkdF4zXSBmb3JtXG4gICAgICAgIC8vICAgIHBhID0gYWxpZ25lZFswXS55LFxuICAgICAgICAvLyAgICBwYiA9IGFsaWduZWRbMV0ueSxcbiAgICAgICAgLy8gICAgcGMgPSBhbGlnbmVkWzJdLnksXG4gICAgICAgIC8vICAgIHBkID0gYWxpZ25lZFszXS55O1xuICAgICAgICAvLy8vLy8gY3VydmUgPSBbe3g6MCwgeToxfSwge3g6IGN1cnZlWzBdLCB5OiAxLWN1cnZlWzFdfSwge3g6IGN1cnZlWzJdLCB5OiAxLWN1cnZlWzNdfSwge3g6MSwgeTowfV07XG4gICAgdmFyIHBhID0geCAtIDA7XG4gICAgdmFyIHBiID0geCAtIGN1cnZlWzBdO1xuICAgIHZhciBwYyA9IHggLSBjdXJ2ZVsyXTtcbiAgICB2YXIgcGQgPSB4IC0gMTtcblxuICAgIC8vIHRvIFt0XjMgKyBhdF4yICsgYnQgKyBjXSBmb3JtOlxuICAgIHZhciBwYTMgPSBwYSAqIDM7XG4gICAgdmFyIHBiMyA9IHBiICogMztcbiAgICB2YXIgcGMzID0gcGMgKiAzO1xuICAgIHZhciBkID0gKC1wYSArIHBiMyAtIHBjMyArIHBkKSxcbiAgICAgICAgcmQgPSAxIC8gZCxcbiAgICAgICAgcjMgPSAxIC8gMyxcbiAgICAgICAgYSA9IChwYTMgLSA2ICogcGIgKyBwYzMpICogcmQsXG4gICAgICAgIGEzID0gYSAqIHIzLFxuICAgICAgICBiID0gKC1wYTMgKyBwYjMpICogcmQsXG4gICAgICAgIGMgPSBwYSAqIHJkLFxuICAgIC8vIHRoZW4sIGRldGVybWluZSBwIGFuZCBxOlxuICAgICAgICBwID0gKDMgKiBiIC0gYSAqIGEpICogcjMsXG4gICAgICAgIHAzID0gcCAqIHIzLFxuICAgICAgICBxID0gKDIgKiBhICogYSAqIGEgLSA5ICogYSAqIGIgKyAyNyAqIGMpIC8gMjcsXG4gICAgICAgIHEyID0gcSAvIDIsXG4gICAgLy8gYW5kIGRldGVybWluZSB0aGUgZGlzY3JpbWluYW50OlxuICAgICAgICBkaXNjcmltaW5hbnQgPSBxMiAqIHEyICsgcDMgKiBwMyAqIHAzLFxuICAgIC8vIGFuZCBzb21lIHJlc2VydmVkIHZhcmlhYmxlc1xuICAgICAgICB1MSwgdjEsIHgxLCB4MiwgeDM7XG5cbiAgICAvLyBJZiB0aGUgZGlzY3JpbWluYW50IGlzIG5lZ2F0aXZlLCB1c2UgcG9sYXIgY29vcmRpbmF0ZXNcbiAgICAvLyB0byBnZXQgYXJvdW5kIHNxdWFyZSByb290cyBvZiBuZWdhdGl2ZSBudW1iZXJzXG4gICAgaWYgKGRpc2NyaW1pbmFudCA8IDApIHtcbiAgICAgICAgdmFyIG1wMyA9IC1wICogcjMsXG4gICAgICAgICAgICBtcDMzID0gbXAzICogbXAzICogbXAzLFxuICAgICAgICAgICAgciA9IHNxcnQobXAzMyksXG4gICAgICAgIC8vIGNvbXB1dGUgY29zcGhpIGNvcnJlY3RlZCBmb3IgSUVFRSBmbG9hdCByb3VuZGluZzpcbiAgICAgICAgICAgIHQgPSAtcSAvICgyICogciksXG4gICAgICAgICAgICBjb3NwaGkgPSB0IDwgLTEgPyAtMSA6IHQgPiAxID8gMSA6IHQsXG4gICAgICAgICAgICBwaGkgPSBhY29zKGNvc3BoaSksXG4gICAgICAgICAgICBjcnRyID0gY3J0KHIpLFxuICAgICAgICAgICAgdDEgPSAyICogY3J0cjtcbiAgICAgICAgeDEgPSB0MSAqIGNvcyhwaGkgKiByMykgLSBhMztcbiAgICAgICAgeDIgPSB0MSAqIGNvcygocGhpICsgdGF1KSAqIHIzKSAtIGEzO1xuICAgICAgICB4MyA9IHQxICogY29zKChwaGkgKyAyICogdGF1KSAqIHIzKSAtIGEzO1xuXG4gICAgICAgIC8vIGNob29zZSBiZXN0IHBlcmNlbnRhZ2VcbiAgICAgICAgaWYgKDAgPD0geDEgJiYgeDEgPD0gMSkge1xuICAgICAgICAgICAgaWYgKDAgPD0geDIgJiYgeDIgPD0gMSkge1xuICAgICAgICAgICAgICAgIGlmICgwIDw9IHgzICYmIHgzIDw9IDEpIHtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIG1heCh4MSwgeDIsIHgzKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybiBtYXgoeDEsIHgyKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBlbHNlIGlmICgwIDw9IHgzICYmIHgzIDw9IDEpIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gbWF4KHgxLCB4Myk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBlbHNlIHtcbiAgICAgICAgICAgICAgICByZXR1cm4geDE7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICBpZiAoMCA8PSB4MiAmJiB4MiA8PSAxKSB7XG4gICAgICAgICAgICAgICAgaWYgKDAgPD0geDMgJiYgeDMgPD0gMSkge1xuICAgICAgICAgICAgICAgICAgICByZXR1cm4gbWF4KHgyLCB4Myk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICByZXR1cm4geDI7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIHgzO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgfVxuICAgIGVsc2UgaWYgKGRpc2NyaW1pbmFudCA9PT0gMCkge1xuICAgICAgICB1MSA9IHEyIDwgMCA/IGNydCgtcTIpIDogLWNydChxMik7XG4gICAgICAgIHgxID0gMiAqIHUxIC0gYTM7XG4gICAgICAgIHgyID0gLXUxIC0gYTM7XG5cbiAgICAgICAgLy8gY2hvb3NlIGJlc3QgcGVyY2VudGFnZVxuICAgICAgICBpZiAoMCA8PSB4MSAmJiB4MSA8PSAxKSB7XG4gICAgICAgICAgICBpZiAoMCA8PSB4MiAmJiB4MiA8PSAxKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIG1heCh4MSwgeDIpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIHgxO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIGVsc2Uge1xuICAgICAgICAgICAgcmV0dXJuIHgyO1xuICAgICAgICB9XG4gICAgfVxuICAgIC8vIG9uZSByZWFsIHJvb3QsIGFuZCB0d28gaW1hZ2luYXJ5IHJvb3RzXG4gICAgZWxzZSB7XG4gICAgICAgIHZhciBzZCA9IHNxcnQoZGlzY3JpbWluYW50KTtcbiAgICAgICAgdTEgPSBjcnQoLXEyICsgc2QpO1xuICAgICAgICB2MSA9IGNydChxMiArIHNkKTtcbiAgICAgICAgeDEgPSB1MSAtIHYxIC0gYTM7XG4gICAgICAgIHJldHVybiB4MTtcbiAgICB9XG59XG5cbmZ1bmN0aW9uIGJlemllckJ5VGltZSAoY29udHJvbFBvaW50cywgeCkge1xuICAgIHZhciBwZXJjZW50ID0gY2FyZGFubyhjb250cm9sUG9pbnRzLCB4KTsgICAgLy8gdFxuICAgIHZhciBwMXkgPSBjb250cm9sUG9pbnRzWzFdOyAvLyBiXG4gICAgdmFyIHAyeSA9IGNvbnRyb2xQb2ludHNbM107IC8vIGNcbiAgICAvLyByZXR1cm4gYmV6aWVyKDAsIHAxeSwgcDJ5LCAxLCBwZXJjZW50KTtcbiAgICByZXR1cm4gKCgxIC0gcGVyY2VudCkgKiAocDF5ICsgKHAyeSAtIHAxeSkgKiBwZXJjZW50KSAqIDMgKyBwZXJjZW50ICogcGVyY2VudCkgKiBwZXJjZW50O1xufVxuXG5pZiAoQ0NfVEVTVCkge1xuICAgIGNjLl9UZXN0LmJlemllciA9IGJlemllcjtcbiAgICBjYy5fVGVzdC5iZXppZXJCeVRpbWUgPSBiZXppZXJCeVRpbWU7XG59XG5cbm1vZHVsZS5leHBvcnRzID0ge1xuICAgIGJlemllcjogYmV6aWVyLFxuICAgIGJlemllckJ5VGltZTogYmV6aWVyQnlUaW1lXG59O1xuIl0sInNvdXJjZVJvb3QiOiIvIn0=