
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/animation/animation-curves.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var bezierByTime = require('./bezier').bezierByTime;

var binarySearch = require('../core/utils/binary-search').binarySearchEpsilon;

var WrapModeMask = require('./types').WrapModeMask;

var WrappedInfo = require('./types').WrappedInfo;
/**
 * Compute a new ratio by curve type
 * @param {Number} ratio - The origin ratio
 * @param {Array|String} type - If it's Array, then ratio will be computed with bezierByTime. If it's string, then ratio will be computed with cc.easing function
 */


function computeRatioByType(ratio, type) {
  if (typeof type === 'string') {
    var func = cc.easing[type];

    if (func) {
      ratio = func(ratio);
    } else {
      cc.errorID(3906, type);
    }
  } else if (Array.isArray(type)) {
    // bezier curve
    ratio = bezierByTime(type, ratio);
  }

  return ratio;
} //
// 动画数据类，相当于 AnimationClip。
// 虽然叫做 AnimCurve，但除了曲线，可以保存任何类型的值。
//
// @class AnimCurve
//
//


var AnimCurve = cc.Class({
  name: 'cc.AnimCurve',
  //
  // @method sample
  // @param {number} time
  // @param {number} ratio - The normalized time specified as a number between 0.0 and 1.0 inclusive.
  // @param {AnimationState} state
  //
  sample: function sample(time, ratio, state) {},
  onTimeChangedManually: undefined
});
/**
 * 当每两帧之前的间隔都一样的时候可以使用此函数快速查找 index
 */

function quickFindIndex(ratios, ratio) {
  var length = ratios.length - 1;
  if (length === 0) return 0;
  var start = ratios[0];
  if (ratio < start) return 0;
  var end = ratios[length];
  if (ratio > end) return ~ratios.length;
  ratio = (ratio - start) / (end - start);
  var eachLength = 1 / length;
  var index = ratio / eachLength;
  var floorIndex = index | 0;
  var EPSILON = 1e-6;

  if (index - floorIndex < EPSILON) {
    return floorIndex;
  } else if (floorIndex + 1 - index < EPSILON) {
    return floorIndex + 1;
  }

  return ~(floorIndex + 1);
} //
//
// @class DynamicAnimCurve
//
// @extends AnimCurve
//


var DynamicAnimCurve = cc.Class({
  name: 'cc.DynamicAnimCurve',
  "extends": AnimCurve,
  ctor: function ctor() {
    // cache last frame index
    this._cachedIndex = 0;
  },
  properties: {
    // The object being animated.
    // @property target
    // @type {object}
    target: null,
    // The name of the property being animated.
    // @property prop
    // @type {string}
    prop: '',
    // The values of the keyframes. (y)
    // @property values
    // @type {any[]}
    values: [],
    // The keyframe ratio of the keyframe specified as a number between 0.0 and 1.0 inclusive. (x)
    // @property ratios
    // @type {number[]}
    ratios: [],
    // @property types
    // @param {object[]}
    // Each array item maybe type:
    // - [x, x, x, x]: Four control points for bezier
    // - null: linear
    types: []
  },
  _findFrameIndex: binarySearch,
  _lerp: undefined,
  _lerpNumber: function _lerpNumber(from, to, t) {
    return from + (to - from) * t;
  },
  _lerpObject: function _lerpObject(from, to, t) {
    return from.lerp(to, t);
  },
  _lerpQuat: function () {
    var out = cc.quat();
    return function (from, to, t) {
      return from.lerp(to, t, out);
    };
  }(),
  _lerpVector: function () {
    var out = cc.v3();
    return function (from, to, t) {
      return from.lerp(to, t, out);
    };
  }(),
  sample: function sample(time, ratio, state) {
    var values = this.values;
    var ratios = this.ratios;
    var frameCount = ratios.length;

    if (frameCount === 0) {
      return;
    } // only need to refind frame index when ratio is out of range of last from ratio and to ratio.


    var shoudRefind = true;
    var cachedIndex = this._cachedIndex;

    if (cachedIndex < 0) {
      cachedIndex = ~cachedIndex;

      if (cachedIndex > 0 && cachedIndex < ratios.length) {
        var _fromRatio = ratios[cachedIndex - 1];
        var _toRatio = ratios[cachedIndex];

        if (ratio > _fromRatio && ratio < _toRatio) {
          shoudRefind = false;
        }
      }
    }

    if (shoudRefind) {
      this._cachedIndex = this._findFrameIndex(ratios, ratio);
    } // evaluate value


    var value;
    var index = this._cachedIndex;

    if (index < 0) {
      index = ~index;

      if (index <= 0) {
        value = values[0];
      } else if (index >= frameCount) {
        value = values[frameCount - 1];
      } else {
        var fromVal = values[index - 1];

        if (!this._lerp) {
          value = fromVal;
        } else {
          var fromRatio = ratios[index - 1];
          var toRatio = ratios[index];
          var type = this.types[index - 1];
          var ratioBetweenFrames = (ratio - fromRatio) / (toRatio - fromRatio);

          if (type) {
            ratioBetweenFrames = computeRatioByType(ratioBetweenFrames, type);
          } // calculate value


          var toVal = values[index];
          value = this._lerp(fromVal, toVal, ratioBetweenFrames);
        }
      }
    } else {
      value = values[index];
    }

    this.target[this.prop] = value;
  }
});
DynamicAnimCurve.Linear = null;

DynamicAnimCurve.Bezier = function (controlPoints) {
  return controlPoints;
};
/**
 * Event information,
 * @class EventInfo
 *
 */


var EventInfo = function EventInfo() {
  this.events = [];
};
/**
 * @param {Function} [func] event function
 * @param {Object[]} [params] event params
 */


EventInfo.prototype.add = function (func, params) {
  this.events.push({
    func: func || '',
    params: params || []
  });
};
/**
 *
 * @class EventAnimCurve
 *
 * @extends AnimCurve
 */


var EventAnimCurve = cc.Class({
  name: 'cc.EventAnimCurve',
  "extends": AnimCurve,
  properties: {
    /**
     * The object being animated.
     * @property target
     * @type {object}
     */
    target: null,

    /** The keyframe ratio of the keyframe specified as a number between 0.0 and 1.0 inclusive. (x)
     * @property ratios
     * @type {number[]}
     */
    ratios: [],

    /**
     * @property events
     * @type {EventInfo[]}
     */
    events: [],
    _wrappedInfo: {
      "default": function _default() {
        return new WrappedInfo();
      }
    },
    _lastWrappedInfo: null,
    _ignoreIndex: NaN
  },
  _wrapIterations: function _wrapIterations(iterations) {
    if (iterations - (iterations | 0) === 0) iterations -= 1;
    return iterations | 0;
  },
  sample: function sample(time, ratio, state) {
    var length = this.ratios.length;
    var currentWrappedInfo = state.getWrappedInfo(state.time, this._wrappedInfo);
    var direction = currentWrappedInfo.direction;
    var currentIndex = binarySearch(this.ratios, currentWrappedInfo.ratio);

    if (currentIndex < 0) {
      currentIndex = ~currentIndex - 1; // if direction is inverse, then increase index

      if (direction < 0) currentIndex += 1;
    }

    if (this._ignoreIndex !== currentIndex) {
      this._ignoreIndex = NaN;
    }

    currentWrappedInfo.frameIndex = currentIndex;

    if (!this._lastWrappedInfo) {
      this._fireEvent(currentIndex);

      this._lastWrappedInfo = new WrappedInfo(currentWrappedInfo);
      return;
    }

    var wrapMode = state.wrapMode;

    var currentIterations = this._wrapIterations(currentWrappedInfo.iterations);

    var lastWrappedInfo = this._lastWrappedInfo;

    var lastIterations = this._wrapIterations(lastWrappedInfo.iterations);

    var lastIndex = lastWrappedInfo.frameIndex;
    var lastDirection = lastWrappedInfo.direction;
    var interationsChanged = lastIterations !== -1 && currentIterations !== lastIterations;

    if (lastIndex === currentIndex && interationsChanged && length === 1) {
      this._fireEvent(0);
    } else if (lastIndex !== currentIndex || interationsChanged) {
      direction = lastDirection;

      do {
        if (lastIndex !== currentIndex) {
          if (direction === -1 && lastIndex === 0 && currentIndex > 0) {
            if ((wrapMode & WrapModeMask.PingPong) === WrapModeMask.PingPong) {
              direction *= -1;
            } else {
              lastIndex = length;
            }

            lastIterations++;
          } else if (direction === 1 && lastIndex === length - 1 && currentIndex < length - 1) {
            if ((wrapMode & WrapModeMask.PingPong) === WrapModeMask.PingPong) {
              direction *= -1;
            } else {
              lastIndex = -1;
            }

            lastIterations++;
          }

          if (lastIndex === currentIndex) break;
          if (lastIterations > currentIterations) break;
        }

        lastIndex += direction;
        cc.director.getAnimationManager().pushDelayEvent(this, '_fireEvent', [lastIndex]);
      } while (lastIndex !== currentIndex && lastIndex > -1 && lastIndex < length);
    }

    this._lastWrappedInfo.set(currentWrappedInfo);
  },
  _fireEvent: function _fireEvent(index) {
    if (index < 0 || index >= this.events.length || this._ignoreIndex === index) return;
    var eventInfo = this.events[index];
    var events = eventInfo.events;

    if (!this.target.isValid) {
      return;
    }

    var components = this.target._components;

    for (var i = 0; i < events.length; i++) {
      var event = events[i];
      var funcName = event.func;

      for (var j = 0; j < components.length; j++) {
        var component = components[j];
        var func = component[funcName];
        if (func) func.apply(component, event.params);
      }
    }
  },
  onTimeChangedManually: function onTimeChangedManually(time, state) {
    this._lastWrappedInfo = null;
    this._ignoreIndex = NaN;
    var info = state.getWrappedInfo(time, this._wrappedInfo);
    var direction = info.direction;
    var frameIndex = binarySearch(this.ratios, info.ratio); // only ignore when time not on a frame index

    if (frameIndex < 0) {
      frameIndex = ~frameIndex - 1; // if direction is inverse, then increase index

      if (direction < 0) frameIndex += 1;
      this._ignoreIndex = frameIndex;
    }
  }
});

if (CC_TEST) {
  cc._Test.DynamicAnimCurve = DynamicAnimCurve;
  cc._Test.EventAnimCurve = EventAnimCurve;
  cc._Test.quickFindIndex = quickFindIndex;
}

module.exports = {
  AnimCurve: AnimCurve,
  DynamicAnimCurve: DynamicAnimCurve,
  EventAnimCurve: EventAnimCurve,
  EventInfo: EventInfo,
  computeRatioByType: computeRatioByType,
  quickFindIndex: quickFindIndex
};
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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