
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/animation/animation-clip.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var WrapMode = require('./types').WrapMode;

var _require = require('./animation-curves'),
    DynamicAnimCurve = _require.DynamicAnimCurve,
    quickFindIndex = _require.quickFindIndex;

var sampleMotionPaths = require('./motion-path-helper').sampleMotionPaths;

var binarySearch = require('../core/utils/binary-search').binarySearchEpsilon;
/**
 * !#en Class for animation data handling.
 * !#zh 动画剪辑，用于存储动画数据。
 * @class AnimationClip
 * @extends Asset
 */


var AnimationClip = cc.Class({
  name: 'cc.AnimationClip',
  "extends": cc.Asset,
  properties: {
    _duration: {
      "default": 0,
      type: cc.Float
    },

    /**
     * !#en Duration of this animation.
     * !#zh 动画的持续时间。
     * @property duration
     * @type {Number}
     */
    duration: {
      get: function get() {
        return this._duration;
      }
    },

    /**
     * !#en FrameRate of this animation.
     * !#zh 动画的帧速率。
     * @property sample
     * @type {Number}
     */
    sample: {
      "default": 60
    },

    /**
     * !#en Speed of this animation.
     * !#zh 动画的播放速度。
     * @property speed
     * @type {Number}
     */
    speed: {
      "default": 1
    },

    /**
     * !#en WrapMode of this animation.
     * !#zh 动画的循环模式。
     * @property wrapMode
     * @type {WrapMode}
     */
    wrapMode: {
      "default": WrapMode.Normal
    },

    /**
     * !#en Curve data.
     * !#zh 曲线数据。
     * @property curveData
     * @type {Object}
     * @example {@link cocos2d/core/animation-clip/curve-data.js}
     */
    curveData: {
      "default": {},
      visible: false
    },

    /**
     * !#en Event data.
     * !#zh 事件数据。
     * @property events
     * @type {Object[]}
     * @example {@link cocos2d/core/animation-clip/event-data.js}
     * @typescript events: {frame: number, func: string, params: string[]}[]
     */
    events: {
      "default": [],
      visible: false
    }
  },
  statics: {
    /**
     * !#en Crate clip with a set of sprite frames
     * !#zh 使用一组序列帧图片来创建动画剪辑
     * @method createWithSpriteFrames
     * @param {[SpriteFrame]} spriteFrames
     * @param {Number} sample
     * @return {AnimationClip}
     * @static
     * @example
     *
     * var clip = cc.AnimationClip.createWithSpriteFrames(spriteFrames, 10);
     *
     */
    createWithSpriteFrames: function createWithSpriteFrames(spriteFrames, sample) {
      if (!Array.isArray(spriteFrames)) {
        cc.errorID(3905);
        return null;
      }

      var clip = new AnimationClip();
      clip.sample = sample || clip.sample;
      clip._duration = spriteFrames.length / clip.sample;
      var frames = [];
      var step = 1 / clip.sample;

      for (var i = 0, l = spriteFrames.length; i < l; i++) {
        frames[i] = {
          frame: i * step,
          value: spriteFrames[i]
        };
      }

      clip.curveData = {
        comps: {
          // component
          'cc.Sprite': {
            // component properties
            'spriteFrame': frames
          }
        }
      };
      return clip;
    }
  },
  onLoad: function onLoad() {
    this._duration = Number.parseFloat(this.duration);
    this.speed = Number.parseFloat(this.speed);
    this.wrapMode = Number.parseInt(this.wrapMode);
    this.frameRate = Number.parseFloat(this.sample);
  },
  createPropCurve: function createPropCurve(target, propPath, keyframes) {
    var motionPaths = [];
    var isMotionPathProp = target instanceof cc.Node && propPath === 'position';
    var curve = new DynamicAnimCurve(); // 缓存目标对象，所以 Component 必须一开始都创建好并且不能运行时动态替换……

    curve.target = target;
    curve.prop = propPath; // for each keyframes

    for (var i = 0, l = keyframes.length; i < l; i++) {
      var keyframe = keyframes[i];
      var ratio = keyframe.frame / this.duration;
      curve.ratios.push(ratio);

      if (isMotionPathProp) {
        motionPaths.push(keyframe.motionPath);
      }

      var curveValue = keyframe.value;
      curve.values.push(curveValue);
      var curveTypes = keyframe.curve;

      if (curveTypes) {
        if (typeof curveTypes === 'string') {
          curve.types.push(curveTypes);
          continue;
        } else if (Array.isArray(curveTypes)) {
          if (curveTypes[0] === curveTypes[1] && curveTypes[2] === curveTypes[3]) {
            curve.types.push(DynamicAnimCurve.Linear);
          } else {
            curve.types.push(DynamicAnimCurve.Bezier(curveTypes));
          }

          continue;
        }
      }

      curve.types.push(DynamicAnimCurve.Linear);
    }

    if (isMotionPathProp) {
      sampleMotionPaths(motionPaths, curve, this.duration, this.sample, target);
    } // if every piece of ratios are the same, we can use the quick function to find frame index.


    var ratios = curve.ratios;
    var currRatioDif, lastRatioDif;
    var canOptimize = true;
    var EPSILON = 1e-6;

    for (var _i = 1, _l = ratios.length; _i < _l; _i++) {
      currRatioDif = ratios[_i] - ratios[_i - 1];

      if (_i === 1) {
        lastRatioDif = currRatioDif;
      } else if (Math.abs(currRatioDif - lastRatioDif) > EPSILON) {
        canOptimize = false;
        break;
      }
    }

    curve._findFrameIndex = canOptimize ? quickFindIndex : binarySearch; // find the lerp function

    var firstValue = curve.values[0];

    if (firstValue !== undefined && firstValue !== null && !curve._lerp) {
      if (typeof firstValue === 'number') {
        curve._lerp = DynamicAnimCurve.prototype._lerpNumber;
      } else if (firstValue instanceof cc.Quat) {
        curve._lerp = DynamicAnimCurve.prototype._lerpQuat;
      } else if (firstValue instanceof cc.Vec2 || firstValue instanceof cc.Vec3) {
        curve._lerp = DynamicAnimCurve.prototype._lerpVector;
      } else if (firstValue.lerp) {
        curve._lerp = DynamicAnimCurve.prototype._lerpObject;
      }
    }

    return curve;
  },
  createTargetCurves: function createTargetCurves(target, curveData, curves) {
    var propsData = curveData.props;
    var compsData = curveData.comps;

    if (propsData) {
      for (var propPath in propsData) {
        var data = propsData[propPath];
        var curve = this.createPropCurve(target, propPath, data);
        curves.push(curve);
      }
    }

    if (compsData) {
      for (var compName in compsData) {
        var comp = target.getComponent(compName);

        if (!comp) {
          continue;
        }

        var compData = compsData[compName];

        for (var _propPath in compData) {
          var _data = compData[_propPath];

          var _curve = this.createPropCurve(comp, _propPath, _data);

          curves.push(_curve);
        }
      }
    }
  },
  createCurves: function createCurves(state, root) {
    var curveData = this.curveData;
    var childrenCurveDatas = curveData.paths;
    var curves = [];
    this.createTargetCurves(root, curveData, curves);

    for (var namePath in childrenCurveDatas) {
      var target = cc.find(namePath, root);

      if (!target) {
        continue;
      }

      var childCurveDatas = childrenCurveDatas[namePath];
      this.createTargetCurves(target, childCurveDatas, curves);
    }

    return curves;
  }
});
cc.AnimationClip = module.exports = AnimationClip;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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