
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/animation/animation-animator.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var js = cc.js;

var Playable = require('./playable');

var _require = require('./animation-curves'),
    EventAnimCurve = _require.EventAnimCurve,
    EventInfo = _require.EventInfo;

var WrapModeMask = require('./types').WrapModeMask;

var binarySearch = require('../core/utils/binary-search').binarySearchEpsilon; // The actual animator for Animation Component


function AnimationAnimator(target, animation) {
  Playable.call(this);
  this.target = target;
  this.animation = animation;
  this._anims = new js.array.MutableForwardIterator([]);
}

js.extend(AnimationAnimator, Playable);
var p = AnimationAnimator.prototype;

p.playState = function (state, startTime) {
  if (!state.clip) {
    return;
  }

  if (!state.curveLoaded) {
    initClipData(this.target, state);
  }

  state.animator = this;
  state.play();

  if (typeof startTime === 'number') {
    state.setTime(startTime);
  }

  this.play();
};

p.stopStatesExcept = function (state) {
  var iterator = this._anims;
  var array = iterator.array;

  for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
    var anim = array[iterator.i];

    if (anim === state) {
      continue;
    }

    this.stopState(anim);
  }
};

p.addAnimation = function (anim) {
  var index = this._anims.array.indexOf(anim);

  if (index === -1) {
    this._anims.push(anim);
  }

  anim._setEventTarget(this.animation);
};

p.removeAnimation = function (anim) {
  var index = this._anims.array.indexOf(anim);

  if (index >= 0) {
    this._anims.fastRemoveAt(index);

    if (this._anims.array.length === 0) {
      this.stop();
    }
  } else {
    cc.errorID(3907);
  }

  anim.animator = null;
};

p.sample = function () {
  var iterator = this._anims;
  var array = iterator.array;

  for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
    var anim = array[iterator.i];
    anim.sample();
  }
};

p.stopState = function (state) {
  if (state) {
    state.stop();
  }
};

p.pauseState = function (state) {
  if (state) {
    state.pause();
  }
};

p.resumeState = function (state) {
  if (state) {
    state.resume();
  }

  if (this.isPaused) {
    this.resume();
  }
};

p.setStateTime = function (state, time) {
  if (time !== undefined) {
    if (state) {
      state.setTime(time);
      state.sample();
    }
  } else {
    time = state;
    var array = this._anims.array;

    for (var i = 0; i < array.length; ++i) {
      var anim = array[i];
      anim.setTime(time);
      anim.sample();
    }
  }
};

p.onStop = function () {
  var iterator = this._anims;
  var array = iterator.array;

  for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
    var anim = array[iterator.i];
    anim.stop();
  }
};

p.onPause = function () {
  var array = this._anims.array;

  for (var i = 0; i < array.length; ++i) {
    var anim = array[i];
    anim.pause(); // need to unbind animator to anim, or it maybe cannot be gc.

    anim.animator = null;
  }
};

p.onResume = function () {
  var array = this._anims.array;

  for (var i = 0; i < array.length; ++i) {
    var anim = array[i]; // rebind animator to anim

    anim.animator = this;
    anim.resume();
  }
};

p._reloadClip = function (state) {
  initClipData(this.target, state);
}; // 这个方法应该是 SampledAnimCurve 才能用


function createBatchedProperty(propPath, firstDotIndex, mainValue, animValue) {
  mainValue = mainValue.clone();
  var nextValue = mainValue;
  var leftIndex = firstDotIndex + 1;
  var rightIndex = propPath.indexOf('.', leftIndex); // scan property path

  while (rightIndex !== -1) {
    var nextName = propPath.slice(leftIndex, rightIndex);
    nextValue = nextValue[nextName];
    leftIndex = rightIndex + 1;
    rightIndex = propPath.indexOf('.', leftIndex);
  }

  var lastPropName = propPath.slice(leftIndex);
  nextValue[lastPropName] = animValue;
  return mainValue;
}

if (CC_TEST) {
  cc._Test.createBatchedProperty = createBatchedProperty;
}

function initClipData(root, state) {
  var clip = state.clip;
  state.duration = clip.duration;
  state.speed = clip.speed;
  state.wrapMode = clip.wrapMode;
  state.frameRate = clip.sample;

  if ((state.wrapMode & WrapModeMask.Loop) === WrapModeMask.Loop) {
    state.repeatCount = Infinity;
  } else {
    state.repeatCount = 1;
  }

  var curves = state.curves = clip.createCurves(state, root); // events curve

  var events = clip.events;

  if (!CC_EDITOR && events) {
    var curve;

    for (var i = 0, l = events.length; i < l; i++) {
      if (!curve) {
        curve = new EventAnimCurve();
        curve.target = root;
        curves.push(curve);
      }

      var eventData = events[i];
      var ratio = eventData.frame / state.duration;
      var eventInfo = void 0;
      var index = binarySearch(curve.ratios, ratio);

      if (index >= 0) {
        eventInfo = curve.events[index];
      } else {
        eventInfo = new EventInfo();
        curve.ratios.push(ratio);
        curve.events.push(eventInfo);
      }

      eventInfo.add(eventData.func, eventData.params);
    }
  }
}

if (CC_TEST) {
  cc._Test.initClipData = initClipData;
}

module.exports = AnimationAnimator;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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