
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/index.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
// PREDEFINE
// window may be undefined when first load engine from editor
var _global = typeof window === 'undefined' ? global : window;
/**
 * !#en
 * The main namespace of Cocos2d-JS, all engine core classes, functions, properties and constants are defined in this namespace.
 * !#zh
 * Cocos 引擎的主要命名空间，引擎代码中所有的类，函数，属性和常量都在这个命名空间中定义。
 * @module cc
 * @main cc
 */


_global.cc = _global.cc || {}; // For internal usage

cc.internal = cc.internal || {};

require('./predefine'); // polyfills


require('./polyfill/string');

require('./polyfill/misc');

require('./polyfill/array');

require('./polyfill/object');

require('./polyfill/array-buffer');

require('./polyfill/number');

if (!(CC_EDITOR && Editor.isMainProcess)) {
  require('./polyfill/typescript');
}

require('./cocos2d/core/predefine'); // LOAD COCOS2D ENGINE CODE


if (!(CC_EDITOR && Editor.isMainProcess)) {
  require('./cocos2d');
} // LOAD EXTENDS


require('./extends');

if (CC_EDITOR) {
  if (Editor.isMainProcess) {
    Editor.versions['cocos2d'] = require('./package').version;
  }
}

module.exports = _global.cc;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/polyfill/object.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

// for IE11
if (!Object.assign) {
  Object.assign = function (target, source) {
    return cc.js.mixin(target, source);
  };
} // for Baidu browser
// Implementation reference to: 
// http://2ality.com/2016/02/object-getownpropertydescriptors.html
// http://docs.w3cub.com/javascript/global_objects/reflect/ownkeys/


if (!Object.getOwnPropertyDescriptors) {
  Object.getOwnPropertyDescriptors = function (obj) {
    var descriptors = {};
    var ownKeys = Object.getOwnPropertyNames(obj);

    if (Object.getOwnPropertySymbols) {
      // for IE 11
      ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(obj));
    }

    for (var i = 0; i < ownKeys.length; ++i) {
      var key = ownKeys[i];
      descriptors[key] = Object.getOwnPropertyDescriptor(obj, key);
    }

    return descriptors;
  };
}
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/predefine.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
// MACROS

/**
 * !#zh
 * 这里是一些用来判断执行环境的宏，这些宏都是全局变量，直接访问即可。<br>
 * 在项目构建时，这些宏将会被预处理并根据构建的平台剔除不需要的代码，例如
 *
 *     if (CC_DEBUG) {
 *         cc.log('debug');
 *     }
 *     else {
 *         cc.log('release');
 *     }
 *
 * 在构建后会只剩下
 *
 *     cc.log('release');
 *
 * <br>
 * 如需判断脚本是否运行于指定平台，可以用如下表达式：
 *
 *     {
 *         "编辑器":  CC_EDITOR,
 *         "编辑器 或 预览":  CC_DEV,
 *         "编辑器 或 预览 或 构建调试":  CC_DEBUG,
 *         "网页预览":  CC_PREVIEW && !CC_JSB,
 *         "模拟器预览":  CC_PREVIEW && CC_JSB,
 *         "构建调试":  CC_BUILD && CC_DEBUG,
 *         "构建发行":  CC_BUILD && !CC_DEBUG,
 *     }
 *
 * !#en
 * Here are some of the macro used to determine the execution environment, these macros are global variables, can be accessed directly.<br>
 * When the project is built, these macros will be preprocessed and discard unreachable code based on the built platform, for example:
 *
 *     if (CC_DEBUG) {
 *         cc.log('debug');
 *     }
 *     else {
 *         cc.log('release');
 *     }
 *
 * After build will become:
 *
 *     cc.log('release');
 *
 * <br>
 * To determine whether the script is running on the specified platform, you can use the following expression:
 *
 *     {
 *         "editor":  CC_EDITOR,
 *         "editor or preview":  CC_DEV,
 *         "editor or preview or build in debug mode":  CC_DEBUG,
 *         "web preview":  CC_PREVIEW && !CC_JSB,
 *         "simulator preview":  CC_PREVIEW && CC_JSB,
 *         "build in debug mode":  CC_BUILD && CC_DEBUG,
 *         "build in release mode":  CC_BUILD && !CC_DEBUG,
 *     }
 *
 * @module GLOBAL-MACROS
 */

/**
 * @property {Boolean} CC_EDITOR - Running in the editor.
 */

/**
 * @property {Boolean} CC_PREVIEW - Preview in browser or simulator.
 */

/**
 * @property {Boolean} CC_DEV - Running in the editor or preview.
 */

/**
 * @property {Boolean} CC_DEBUG - Running in the editor or preview, or build in debug mode.
 */

/**
 * @property {Boolean} CC_BUILD - Running in published project.
 */

/**
 * @property {Boolean} CC_JSB - Running in native platform (mobile app, desktop app, or simulator).
 */

/**
 * @property {Boolean} CC_TEST - Running in the engine's unit test.
 */

/**
 * @property {Boolean} CC_RUNTIME - Running in runtime environments.
 */
// window may be undefined when first load engine from editor
var _global = typeof window === 'undefined' ? global : window;
/*
 * @param defaultValue - The default value is only used in the editor or preview.
 */


function defineMacro(name, defaultValue) {
  // if "global_defs" not preprocessed by uglify, just declare them globally,
  // this may happened in release version's preview page.
  if (typeof _global[name] === 'undefined') {
    _global[name] = defaultValue;
  }
}

function defineDeprecatedMacroGetter(name, defaultValue) {
  if (typeof _global[name] === 'undefined') {
    Object.defineProperty(_global, name, {
      get: function get() {
        var recommandedUsage;

        if (name === 'CC_WECHATGAMESUB') {
          recommandedUsage = 'cc.sys.platform === cc.sys.WECHAT_GAME_SUB';
        } else if (name === 'CC_WECHATGAME') {
          recommandedUsage = 'cc.sys.platform === cc.sys.WECHAT_GAME';
        } else if (name === 'CC_QQPLAY') {
          recommandedUsage = 'cc.sys.platform === cc.sys.QQ_PLAY';
        }

        cc.warnID(1400, name, recommandedUsage);
        return defaultValue;
      }
    });
  }
}

function defined(name) {
  return typeof _global[name] === 'object';
} // ensure CC_BUILD is defined
// should not use window.CC_BUILD because we need get global_defs defined in uglify


defineMacro('CC_BUILD', false); // These default values can only be defined after building
// If you need to modify them
// please modify the `global_defs` in the option returned by `gulp/util/utils.js: getUglifyOptions`.

if (CC_BUILD) {
  _global.CC_BUILD = CC_BUILD;
  _global.CC_DEV = CC_DEV;
  _global.CC_DEBUG = CC_DEBUG;
  _global.CC_JSB = CC_JSB;
  _global.CC_NATIVERENDERER = CC_NATIVERENDERER;
  _global.CC_SUPPORT_JIT = CC_SUPPORT_JIT;
  _global.CC_PHYSICS_BUILTIN = CC_PHYSICS_BUILTIN;
  _global.CC_PHYSICS_CANNON = CC_PHYSICS_CANNON;
  _global.CC_EDITOR = CC_EDITOR;
  _global.CC_PREVIEW = CC_PREVIEW;
  _global.CC_TEST = CC_TEST;
  _global.CC_RUNTIME = CC_RUNTIME;
  _global.CC_JSB = CC_JSB;
} else {
  defineMacro('CC_DEV', true); // (CC_EDITOR && !CC_BUILD) || CC_PREVIEW || CC_TEST

  defineMacro('CC_DEBUG', true); // CC_DEV || Debug Build

  defineMacro('CC_JSB', defined('jsb'));
  defineMacro('CC_NATIVERENDERER', defined('jsb'));
  defineMacro('CC_SUPPORT_JIT', true);
  defineMacro('CC_PHYSICS_BUILTIN', false);
  defineMacro('CC_PHYSICS_CANNON', true);
  defineMacro('CC_EDITOR', defined('Editor') && defined('process') && 'electron' in process.versions);
  defineMacro('CC_PREVIEW', !CC_EDITOR);
  defineMacro('CC_TEST', defined('tap') || defined('QUnit'));
  defineMacro('CC_RUNTIME', 'function' === typeof loadRuntime);
  defineMacro('CC_JSB', defined('jsb') && !CC_RUNTIME);
} // deprecated 


var WECHATGAMESUB = !!(defined('wx') && wx.getSharedCanvas);
var WECHATGAME = !!(defined('wx') && (wx.getSystemInfoSync || wx.getSharedCanvas));
var QQPLAY = defined('bk');
defineDeprecatedMacroGetter('CC_WECHATGAMESUB', WECHATGAMESUB);
defineDeprecatedMacroGetter('CC_WECHATGAME', WECHATGAME);
defineDeprecatedMacroGetter('CC_QQPLAY', QQPLAY);

if (CC_DEV) {
  /**
   * contains internal apis for unit tests
   * @expose
   */
  cc._Test = {};
}
/**
 * @module cc
 */

/**
 * The current version of Cocos2d being used.<br/>
 * Please DO NOT remove this String, it is an important flag for bug tracking.<br/>
 * If you post a bug to forum, please attach this flag.
 * @property {String} ENGINE_VERSION
 */


var engineVersion = '2.3.3';
_global['CocosEngine'] = cc.ENGINE_VERSION = engineVersion;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvcHJlZGVmaW5lLmpzIl0sIm5hbWVzIjpbIl9nbG9iYWwiLCJ3aW5kb3ciLCJnbG9iYWwiLCJkZWZpbmVNYWNybyIsIm5hbWUiLCJkZWZhdWx0VmFsdWUiLCJkZWZpbmVEZXByZWNhdGVkTWFjcm9HZXR0ZXIiLCJPYmplY3QiLCJkZWZpbmVQcm9wZXJ0eSIsImdldCIsInJlY29tbWFuZGVkVXNhZ2UiLCJjYyIsIndhcm5JRCIsImRlZmluZWQiLCJDQ19CVUlMRCIsIkNDX0RFViIsIkNDX0RFQlVHIiwiQ0NfSlNCIiwiQ0NfTkFUSVZFUkVOREVSRVIiLCJDQ19TVVBQT1JUX0pJVCIsIkNDX1BIWVNJQ1NfQlVJTFRJTiIsIkNDX1BIWVNJQ1NfQ0FOTk9OIiwiQ0NfRURJVE9SIiwiQ0NfUFJFVklFVyIsIkNDX1RFU1QiLCJDQ19SVU5USU1FIiwicHJvY2VzcyIsInZlcnNpb25zIiwibG9hZFJ1bnRpbWUiLCJXRUNIQVRHQU1FU1VCIiwid3giLCJnZXRTaGFyZWRDYW52YXMiLCJXRUNIQVRHQU1FIiwiZ2V0U3lzdGVtSW5mb1N5bmMiLCJRUVBMQVkiLCJfVGVzdCIsImVuZ2luZVZlcnNpb24iLCJFTkdJTkVfVkVSU0lPTiJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7OztBQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUF5QkE7O0FBRUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQTJEQTs7OztBQUdBOzs7O0FBR0E7Ozs7QUFHQTs7OztBQUdBOzs7O0FBR0E7Ozs7QUFHQTs7OztBQUdBOzs7QUFJQTtBQUNBLElBQUlBLE9BQU8sR0FBRyxPQUFPQyxNQUFQLEtBQWtCLFdBQWxCLEdBQWdDQyxNQUFoQyxHQUF5Q0QsTUFBdkQ7QUFFQTs7Ozs7QUFHQSxTQUFTRSxXQUFULENBQXNCQyxJQUF0QixFQUE0QkMsWUFBNUIsRUFBMEM7QUFDdEM7QUFDQTtBQUNBLE1BQUksT0FBT0wsT0FBTyxDQUFDSSxJQUFELENBQWQsS0FBeUIsV0FBN0IsRUFBMEM7QUFDdENKLElBQUFBLE9BQU8sQ0FBQ0ksSUFBRCxDQUFQLEdBQWdCQyxZQUFoQjtBQUNIO0FBQ0o7O0FBRUQsU0FBU0MsMkJBQVQsQ0FBc0NGLElBQXRDLEVBQTRDQyxZQUE1QyxFQUEwRDtBQUN0RCxNQUFJLE9BQU9MLE9BQU8sQ0FBQ0ksSUFBRCxDQUFkLEtBQXlCLFdBQTdCLEVBQTBDO0FBQ3RDRyxJQUFBQSxNQUFNLENBQUNDLGNBQVAsQ0FBc0JSLE9BQXRCLEVBQStCSSxJQUEvQixFQUFxQztBQUNqQ0ssTUFBQUEsR0FBRyxFQUFFLGVBQVk7QUFDYixZQUFJQyxnQkFBSjs7QUFDQSxZQUFJTixJQUFJLEtBQUssa0JBQWIsRUFBaUM7QUFDN0JNLFVBQUFBLGdCQUFnQixHQUFHLDRDQUFuQjtBQUNILFNBRkQsTUFHSyxJQUFJTixJQUFJLEtBQUssZUFBYixFQUE4QjtBQUMvQk0sVUFBQUEsZ0JBQWdCLEdBQUcsd0NBQW5CO0FBQ0gsU0FGSSxNQUdBLElBQUlOLElBQUksS0FBSyxXQUFiLEVBQTBCO0FBQzNCTSxVQUFBQSxnQkFBZ0IsR0FBRyxvQ0FBbkI7QUFDSDs7QUFDREMsUUFBQUEsRUFBRSxDQUFDQyxNQUFILENBQVUsSUFBVixFQUFnQlIsSUFBaEIsRUFBc0JNLGdCQUF0QjtBQUNBLGVBQU9MLFlBQVA7QUFDSDtBQWRnQyxLQUFyQztBQWdCSDtBQUNKOztBQUVELFNBQVNRLE9BQVQsQ0FBa0JULElBQWxCLEVBQXdCO0FBQ3BCLFNBQU8sT0FBT0osT0FBTyxDQUFDSSxJQUFELENBQWQsS0FBeUIsUUFBaEM7QUFDSCxFQUVEO0FBQ0E7OztBQUNBRCxXQUFXLENBQUMsVUFBRCxFQUFhLEtBQWIsQ0FBWCxFQUVBO0FBQ0E7QUFDQTs7QUFDQSxJQUFJVyxRQUFKLEVBQWM7QUFDVmQsRUFBQUEsT0FBTyxDQUFDYyxRQUFSLEdBQW1CQSxRQUFuQjtBQUNBZCxFQUFBQSxPQUFPLENBQUNlLE1BQVIsR0FBaUJBLE1BQWpCO0FBQ0FmLEVBQUFBLE9BQU8sQ0FBQ2dCLFFBQVIsR0FBbUJBLFFBQW5CO0FBQ0FoQixFQUFBQSxPQUFPLENBQUNpQixNQUFSLEdBQWlCQSxNQUFqQjtBQUNBakIsRUFBQUEsT0FBTyxDQUFDa0IsaUJBQVIsR0FBNEJBLGlCQUE1QjtBQUNBbEIsRUFBQUEsT0FBTyxDQUFDbUIsY0FBUixHQUF5QkEsY0FBekI7QUFDQW5CLEVBQUFBLE9BQU8sQ0FBQ29CLGtCQUFSLEdBQTZCQSxrQkFBN0I7QUFDQXBCLEVBQUFBLE9BQU8sQ0FBQ3FCLGlCQUFSLEdBQTRCQSxpQkFBNUI7QUFDQXJCLEVBQUFBLE9BQU8sQ0FBQ3NCLFNBQVIsR0FBb0JBLFNBQXBCO0FBQ0F0QixFQUFBQSxPQUFPLENBQUN1QixVQUFSLEdBQXFCQSxVQUFyQjtBQUNBdkIsRUFBQUEsT0FBTyxDQUFDd0IsT0FBUixHQUFrQkEsT0FBbEI7QUFDQXhCLEVBQUFBLE9BQU8sQ0FBQ3lCLFVBQVIsR0FBcUJBLFVBQXJCO0FBQ0F6QixFQUFBQSxPQUFPLENBQUNpQixNQUFSLEdBQWlCQSxNQUFqQjtBQUNILENBZEQsTUFlSztBQUNEZCxFQUFBQSxXQUFXLENBQUMsUUFBRCxFQUFXLElBQVgsQ0FBWCxDQURDLENBQytCOztBQUNoQ0EsRUFBQUEsV0FBVyxDQUFDLFVBQUQsRUFBYSxJQUFiLENBQVgsQ0FGQyxDQUUrQjs7QUFDaENBLEVBQUFBLFdBQVcsQ0FBQyxRQUFELEVBQVdVLE9BQU8sQ0FBQyxLQUFELENBQWxCLENBQVg7QUFDQVYsRUFBQUEsV0FBVyxDQUFDLG1CQUFELEVBQXNCVSxPQUFPLENBQUMsS0FBRCxDQUE3QixDQUFYO0FBQ0FWLEVBQUFBLFdBQVcsQ0FBQyxnQkFBRCxFQUFtQixJQUFuQixDQUFYO0FBQ0FBLEVBQUFBLFdBQVcsQ0FBQyxvQkFBRCxFQUF1QixLQUF2QixDQUFYO0FBQ0FBLEVBQUFBLFdBQVcsQ0FBQyxtQkFBRCxFQUFzQixJQUF0QixDQUFYO0FBQ0FBLEVBQUFBLFdBQVcsQ0FBQyxXQUFELEVBQWNVLE9BQU8sQ0FBQyxRQUFELENBQVAsSUFBcUJBLE9BQU8sQ0FBQyxTQUFELENBQTVCLElBQTRDLGNBQWNhLE9BQU8sQ0FBQ0MsUUFBaEYsQ0FBWDtBQUNBeEIsRUFBQUEsV0FBVyxDQUFDLFlBQUQsRUFBZSxDQUFDbUIsU0FBaEIsQ0FBWDtBQUNBbkIsRUFBQUEsV0FBVyxDQUFDLFNBQUQsRUFBWVUsT0FBTyxDQUFDLEtBQUQsQ0FBUCxJQUFrQkEsT0FBTyxDQUFDLE9BQUQsQ0FBckMsQ0FBWDtBQUNBVixFQUFBQSxXQUFXLENBQUMsWUFBRCxFQUFlLGVBQWUsT0FBT3lCLFdBQXJDLENBQVg7QUFDQXpCLEVBQUFBLFdBQVcsQ0FBQyxRQUFELEVBQVdVLE9BQU8sQ0FBQyxLQUFELENBQVAsSUFBa0IsQ0FBQ1ksVUFBOUIsQ0FBWDtBQUNILEVBRUQ7OztBQUNBLElBQU1JLGFBQWEsR0FBRyxDQUFDLEVBQUVoQixPQUFPLENBQUMsSUFBRCxDQUFQLElBQWlCaUIsRUFBRSxDQUFDQyxlQUF0QixDQUF2QjtBQUNBLElBQU1DLFVBQVUsR0FBRyxDQUFDLEVBQUVuQixPQUFPLENBQUMsSUFBRCxDQUFQLEtBQWtCaUIsRUFBRSxDQUFDRyxpQkFBSCxJQUF3QkgsRUFBRSxDQUFDQyxlQUE3QyxDQUFGLENBQXBCO0FBQ0EsSUFBTUcsTUFBTSxHQUFHckIsT0FBTyxDQUFDLElBQUQsQ0FBdEI7QUFDQVAsMkJBQTJCLENBQUMsa0JBQUQsRUFBcUJ1QixhQUFyQixDQUEzQjtBQUNBdkIsMkJBQTJCLENBQUMsZUFBRCxFQUFrQjBCLFVBQWxCLENBQTNCO0FBQ0ExQiwyQkFBMkIsQ0FBQyxXQUFELEVBQWM0QixNQUFkLENBQTNCOztBQUVBLElBQUluQixNQUFKLEVBQVk7QUFDUjs7OztBQUlBSixFQUFBQSxFQUFFLENBQUN3QixLQUFILEdBQVcsRUFBWDtBQUNIO0FBRUQ7Ozs7QUFJQTs7Ozs7Ozs7QUFNQSxJQUFNQyxhQUFhLEdBQUcsT0FBdEI7QUFDQXBDLE9BQU8sQ0FBQyxhQUFELENBQVAsR0FBeUJXLEVBQUUsQ0FBQzBCLGNBQUgsR0FBb0JELGFBQTdDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKipcbiBDb3B5cmlnaHQgKGMpIDIwMTctMjAxOCBYaWFtZW4gWWFqaSBTb2Z0d2FyZSBDby4sIEx0ZC5cblxuIGh0dHBzOi8vd3d3LmNvY29zLmNvbS9cblxuIFBlcm1pc3Npb24gaXMgaGVyZWJ5IGdyYW50ZWQsIGZyZWUgb2YgY2hhcmdlLCB0byBhbnkgcGVyc29uIG9idGFpbmluZyBhIGNvcHlcbiBvZiB0aGlzIHNvZnR3YXJlIGFuZCBhc3NvY2lhdGVkIGVuZ2luZSBzb3VyY2UgY29kZSAodGhlIFwiU29mdHdhcmVcIiksIGEgbGltaXRlZCxcbiB3b3JsZHdpZGUsIHJveWFsdHktZnJlZSwgbm9uLWFzc2lnbmFibGUsIHJldm9jYWJsZSBhbmQgbm9uLWV4Y2x1c2l2ZSBsaWNlbnNlXG4gdG8gdXNlIENvY29zIENyZWF0b3Igc29sZWx5IHRvIGRldmVsb3AgZ2FtZXMgb24geW91ciB0YXJnZXQgcGxhdGZvcm1zLiBZb3Ugc2hhbGxcbiBub3QgdXNlIENvY29zIENyZWF0b3Igc29mdHdhcmUgZm9yIGRldmVsb3Bpbmcgb3RoZXIgc29mdHdhcmUgb3IgdG9vbHMgdGhhdCdzXG4gdXNlZCBmb3IgZGV2ZWxvcGluZyBnYW1lcy4gWW91IGFyZSBub3QgZ3JhbnRlZCB0byBwdWJsaXNoLCBkaXN0cmlidXRlLFxuIHN1YmxpY2Vuc2UsIGFuZC9vciBzZWxsIGNvcGllcyBvZiBDb2NvcyBDcmVhdG9yLlxuXG4gVGhlIHNvZnR3YXJlIG9yIHRvb2xzIGluIHRoaXMgTGljZW5zZSBBZ3JlZW1lbnQgYXJlIGxpY2Vuc2VkLCBub3Qgc29sZC5cbiBYaWFtZW4gWWFqaSBTb2Z0d2FyZSBDby4sIEx0ZC4gcmVzZXJ2ZXMgYWxsIHJpZ2h0cyBub3QgZXhwcmVzc2x5IGdyYW50ZWQgdG8geW91LlxuXG4gVEhFIFNPRlRXQVJFIElTIFBST1ZJREVEIFwiQVMgSVNcIiwgV0lUSE9VVCBXQVJSQU5UWSBPRiBBTlkgS0lORCwgRVhQUkVTUyBPUlxuIElNUExJRUQsIElOQ0xVRElORyBCVVQgTk9UIExJTUlURUQgVE8gVEhFIFdBUlJBTlRJRVMgT0YgTUVSQ0hBTlRBQklMSVRZLFxuIEZJVE5FU1MgRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFIEFORCBOT05JTkZSSU5HRU1FTlQuIElOIE5PIEVWRU5UIFNIQUxMIFRIRVxuIEFVVEhPUlMgT1IgQ09QWVJJR0hUIEhPTERFUlMgQkUgTElBQkxFIEZPUiBBTlkgQ0xBSU0sIERBTUFHRVMgT1IgT1RIRVJcbiBMSUFCSUxJVFksIFdIRVRIRVIgSU4gQU4gQUNUSU9OIE9GIENPTlRSQUNULCBUT1JUIE9SIE9USEVSV0lTRSwgQVJJU0lORyBGUk9NLFxuIE9VVCBPRiBPUiBJTiBDT05ORUNUSU9OIFdJVEggVEhFIFNPRlRXQVJFIE9SIFRIRSBVU0UgT1IgT1RIRVIgREVBTElOR1MgSU5cbiBUSEUgU09GVFdBUkUuXG4gKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKi9cblxuLy8gTUFDUk9TXG5cbi8qKlxuICogISN6aFxuICog6L+Z6YeM5piv5LiA5Lqb55So5p2l5Yik5pat5omn6KGM546v5aKD55qE5a6P77yM6L+Z5Lqb5a6P6YO95piv5YWo5bGA5Y+Y6YeP77yM55u05o6l6K6/6Zeu5Y2z5Y+v44CCPGJyPlxuICog5Zyo6aG555uu5p6E5bu65pe277yM6L+Z5Lqb5a6P5bCG5Lya6KKr6aKE5aSE55CG5bm25qC55o2u5p6E5bu655qE5bmz5Y+w5YmU6Zmk5LiN6ZyA6KaB55qE5Luj56CB77yM5L6L5aaCXG4gKlxuICogICAgIGlmIChDQ19ERUJVRykge1xuICogICAgICAgICBjYy5sb2coJ2RlYnVnJyk7XG4gKiAgICAgfVxuICogICAgIGVsc2Uge1xuICogICAgICAgICBjYy5sb2coJ3JlbGVhc2UnKTtcbiAqICAgICB9XG4gKlxuICog5Zyo5p6E5bu65ZCO5Lya5Y+q5Ymp5LiLXG4gKlxuICogICAgIGNjLmxvZygncmVsZWFzZScpO1xuICpcbiAqIDxicj5cbiAqIOWmgumcgOWIpOaWreiEmuacrOaYr+WQpui/kOihjOS6juaMh+WumuW5s+WPsO+8jOWPr+S7peeUqOWmguS4i+ihqOi+vuW8j++8mlxuICpcbiAqICAgICB7XG4gKiAgICAgICAgIFwi57yW6L6R5ZmoXCI6ICBDQ19FRElUT1IsXG4gKiAgICAgICAgIFwi57yW6L6R5ZmoIOaIliDpooTop4hcIjogIENDX0RFVixcbiAqICAgICAgICAgXCLnvJbovpHlmagg5oiWIOmihOiniCDmiJYg5p6E5bu66LCD6K+VXCI6ICBDQ19ERUJVRyxcbiAqICAgICAgICAgXCLnvZHpobXpooTop4hcIjogIENDX1BSRVZJRVcgJiYgIUNDX0pTQixcbiAqICAgICAgICAgXCLmqKHmi5/lmajpooTop4hcIjogIENDX1BSRVZJRVcgJiYgQ0NfSlNCLFxuICogICAgICAgICBcIuaehOW7uuiwg+ivlVwiOiAgQ0NfQlVJTEQgJiYgQ0NfREVCVUcsXG4gKiAgICAgICAgIFwi5p6E5bu65Y+R6KGMXCI6ICBDQ19CVUlMRCAmJiAhQ0NfREVCVUcsXG4gKiAgICAgfVxuICpcbiAqICEjZW5cbiAqIEhlcmUgYXJlIHNvbWUgb2YgdGhlIG1hY3JvIHVzZWQgdG8gZGV0ZXJtaW5lIHRoZSBleGVjdXRpb24gZW52aXJvbm1lbnQsIHRoZXNlIG1hY3JvcyBhcmUgZ2xvYmFsIHZhcmlhYmxlcywgY2FuIGJlIGFjY2Vzc2VkIGRpcmVjdGx5Ljxicj5cbiAqIFdoZW4gdGhlIHByb2plY3QgaXMgYnVpbHQsIHRoZXNlIG1hY3JvcyB3aWxsIGJlIHByZXByb2Nlc3NlZCBhbmQgZGlzY2FyZCB1bnJlYWNoYWJsZSBjb2RlIGJhc2VkIG9uIHRoZSBidWlsdCBwbGF0Zm9ybSwgZm9yIGV4YW1wbGU6XG4gKlxuICogICAgIGlmIChDQ19ERUJVRykge1xuICogICAgICAgICBjYy5sb2coJ2RlYnVnJyk7XG4gKiAgICAgfVxuICogICAgIGVsc2Uge1xuICogICAgICAgICBjYy5sb2coJ3JlbGVhc2UnKTtcbiAqICAgICB9XG4gKlxuICogQWZ0ZXIgYnVpbGQgd2lsbCBiZWNvbWU6XG4gKlxuICogICAgIGNjLmxvZygncmVsZWFzZScpO1xuICpcbiAqIDxicj5cbiAqIFRvIGRldGVybWluZSB3aGV0aGVyIHRoZSBzY3JpcHQgaXMgcnVubmluZyBvbiB0aGUgc3BlY2lmaWVkIHBsYXRmb3JtLCB5b3UgY2FuIHVzZSB0aGUgZm9sbG93aW5nIGV4cHJlc3Npb246XG4gKlxuICogICAgIHtcbiAqICAgICAgICAgXCJlZGl0b3JcIjogIENDX0VESVRPUixcbiAqICAgICAgICAgXCJlZGl0b3Igb3IgcHJldmlld1wiOiAgQ0NfREVWLFxuICogICAgICAgICBcImVkaXRvciBvciBwcmV2aWV3IG9yIGJ1aWxkIGluIGRlYnVnIG1vZGVcIjogIENDX0RFQlVHLFxuICogICAgICAgICBcIndlYiBwcmV2aWV3XCI6ICBDQ19QUkVWSUVXICYmICFDQ19KU0IsXG4gKiAgICAgICAgIFwic2ltdWxhdG9yIHByZXZpZXdcIjogIENDX1BSRVZJRVcgJiYgQ0NfSlNCLFxuICogICAgICAgICBcImJ1aWxkIGluIGRlYnVnIG1vZGVcIjogIENDX0JVSUxEICYmIENDX0RFQlVHLFxuICogICAgICAgICBcImJ1aWxkIGluIHJlbGVhc2UgbW9kZVwiOiAgQ0NfQlVJTEQgJiYgIUNDX0RFQlVHLFxuICogICAgIH1cbiAqXG4gKiBAbW9kdWxlIEdMT0JBTC1NQUNST1NcbiAqL1xuLyoqXG4gKiBAcHJvcGVydHkge0Jvb2xlYW59IENDX0VESVRPUiAtIFJ1bm5pbmcgaW4gdGhlIGVkaXRvci5cbiAqL1xuLyoqXG4gKiBAcHJvcGVydHkge0Jvb2xlYW59IENDX1BSRVZJRVcgLSBQcmV2aWV3IGluIGJyb3dzZXIgb3Igc2ltdWxhdG9yLlxuICovXG4vKipcbiAqIEBwcm9wZXJ0eSB7Qm9vbGVhbn0gQ0NfREVWIC0gUnVubmluZyBpbiB0aGUgZWRpdG9yIG9yIHByZXZpZXcuXG4gKi9cbi8qKlxuICogQHByb3BlcnR5IHtCb29sZWFufSBDQ19ERUJVRyAtIFJ1bm5pbmcgaW4gdGhlIGVkaXRvciBvciBwcmV2aWV3LCBvciBidWlsZCBpbiBkZWJ1ZyBtb2RlLlxuICovXG4vKipcbiAqIEBwcm9wZXJ0eSB7Qm9vbGVhbn0gQ0NfQlVJTEQgLSBSdW5uaW5nIGluIHB1Ymxpc2hlZCBwcm9qZWN0LlxuICovXG4vKipcbiAqIEBwcm9wZXJ0eSB7Qm9vbGVhbn0gQ0NfSlNCIC0gUnVubmluZyBpbiBuYXRpdmUgcGxhdGZvcm0gKG1vYmlsZSBhcHAsIGRlc2t0b3AgYXBwLCBvciBzaW11bGF0b3IpLlxuICovXG4vKipcbiAqIEBwcm9wZXJ0eSB7Qm9vbGVhbn0gQ0NfVEVTVCAtIFJ1bm5pbmcgaW4gdGhlIGVuZ2luZSdzIHVuaXQgdGVzdC5cbiAqL1xuLyoqXG4gKiBAcHJvcGVydHkge0Jvb2xlYW59IENDX1JVTlRJTUUgLSBSdW5uaW5nIGluIHJ1bnRpbWUgZW52aXJvbm1lbnRzLlxuICovXG5cbi8vIHdpbmRvdyBtYXkgYmUgdW5kZWZpbmVkIHdoZW4gZmlyc3QgbG9hZCBlbmdpbmUgZnJvbSBlZGl0b3JcbnZhciBfZ2xvYmFsID0gdHlwZW9mIHdpbmRvdyA9PT0gJ3VuZGVmaW5lZCcgPyBnbG9iYWwgOiB3aW5kb3c7XG5cbi8qXG4gKiBAcGFyYW0gZGVmYXVsdFZhbHVlIC0gVGhlIGRlZmF1bHQgdmFsdWUgaXMgb25seSB1c2VkIGluIHRoZSBlZGl0b3Igb3IgcHJldmlldy5cbiAqL1xuZnVuY3Rpb24gZGVmaW5lTWFjcm8gKG5hbWUsIGRlZmF1bHRWYWx1ZSkge1xuICAgIC8vIGlmIFwiZ2xvYmFsX2RlZnNcIiBub3QgcHJlcHJvY2Vzc2VkIGJ5IHVnbGlmeSwganVzdCBkZWNsYXJlIHRoZW0gZ2xvYmFsbHksXG4gICAgLy8gdGhpcyBtYXkgaGFwcGVuZWQgaW4gcmVsZWFzZSB2ZXJzaW9uJ3MgcHJldmlldyBwYWdlLlxuICAgIGlmICh0eXBlb2YgX2dsb2JhbFtuYW1lXSA9PT0gJ3VuZGVmaW5lZCcpIHtcbiAgICAgICAgX2dsb2JhbFtuYW1lXSA9IGRlZmF1bHRWYWx1ZTtcbiAgICB9XG59XG5cbmZ1bmN0aW9uIGRlZmluZURlcHJlY2F0ZWRNYWNyb0dldHRlciAobmFtZSwgZGVmYXVsdFZhbHVlKSB7XG4gICAgaWYgKHR5cGVvZiBfZ2xvYmFsW25hbWVdID09PSAndW5kZWZpbmVkJykge1xuICAgICAgICBPYmplY3QuZGVmaW5lUHJvcGVydHkoX2dsb2JhbCwgbmFtZSwge1xuICAgICAgICAgICAgZ2V0OiBmdW5jdGlvbiAoKSB7XG4gICAgICAgICAgICAgICAgbGV0IHJlY29tbWFuZGVkVXNhZ2U7XG4gICAgICAgICAgICAgICAgaWYgKG5hbWUgPT09ICdDQ19XRUNIQVRHQU1FU1VCJykge1xuICAgICAgICAgICAgICAgICAgICByZWNvbW1hbmRlZFVzYWdlID0gJ2NjLnN5cy5wbGF0Zm9ybSA9PT0gY2Muc3lzLldFQ0hBVF9HQU1FX1NVQic7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIGVsc2UgaWYgKG5hbWUgPT09ICdDQ19XRUNIQVRHQU1FJykge1xuICAgICAgICAgICAgICAgICAgICByZWNvbW1hbmRlZFVzYWdlID0gJ2NjLnN5cy5wbGF0Zm9ybSA9PT0gY2Muc3lzLldFQ0hBVF9HQU1FJzsgICAgICAgICAgICAgICAgICAgIFxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBlbHNlIGlmIChuYW1lID09PSAnQ0NfUVFQTEFZJykge1xuICAgICAgICAgICAgICAgICAgICByZWNvbW1hbmRlZFVzYWdlID0gJ2NjLnN5cy5wbGF0Zm9ybSA9PT0gY2Muc3lzLlFRX1BMQVknO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBjYy53YXJuSUQoMTQwMCwgbmFtZSwgcmVjb21tYW5kZWRVc2FnZSk7XG4gICAgICAgICAgICAgICAgcmV0dXJuIGRlZmF1bHRWYWx1ZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSk7XG4gICAgfVxufVxuXG5mdW5jdGlvbiBkZWZpbmVkIChuYW1lKSB7XG4gICAgcmV0dXJuIHR5cGVvZiBfZ2xvYmFsW25hbWVdID09PSAnb2JqZWN0Jztcbn1cblxuLy8gZW5zdXJlIENDX0JVSUxEIGlzIGRlZmluZWRcbi8vIHNob3VsZCBub3QgdXNlIHdpbmRvdy5DQ19CVUlMRCBiZWNhdXNlIHdlIG5lZWQgZ2V0IGdsb2JhbF9kZWZzIGRlZmluZWQgaW4gdWdsaWZ5XG5kZWZpbmVNYWNybygnQ0NfQlVJTEQnLCBmYWxzZSk7XG5cbi8vIFRoZXNlIGRlZmF1bHQgdmFsdWVzIGNhbiBvbmx5IGJlIGRlZmluZWQgYWZ0ZXIgYnVpbGRpbmdcbi8vIElmIHlvdSBuZWVkIHRvIG1vZGlmeSB0aGVtXG4vLyBwbGVhc2UgbW9kaWZ5IHRoZSBgZ2xvYmFsX2RlZnNgIGluIHRoZSBvcHRpb24gcmV0dXJuZWQgYnkgYGd1bHAvdXRpbC91dGlscy5qczogZ2V0VWdsaWZ5T3B0aW9uc2AuXG5pZiAoQ0NfQlVJTEQpIHtcbiAgICBfZ2xvYmFsLkNDX0JVSUxEID0gQ0NfQlVJTEQ7XG4gICAgX2dsb2JhbC5DQ19ERVYgPSBDQ19ERVY7XG4gICAgX2dsb2JhbC5DQ19ERUJVRyA9IENDX0RFQlVHO1xuICAgIF9nbG9iYWwuQ0NfSlNCID0gQ0NfSlNCO1xuICAgIF9nbG9iYWwuQ0NfTkFUSVZFUkVOREVSRVIgPSBDQ19OQVRJVkVSRU5ERVJFUjtcbiAgICBfZ2xvYmFsLkNDX1NVUFBPUlRfSklUID0gQ0NfU1VQUE9SVF9KSVQ7XG4gICAgX2dsb2JhbC5DQ19QSFlTSUNTX0JVSUxUSU4gPSBDQ19QSFlTSUNTX0JVSUxUSU47XG4gICAgX2dsb2JhbC5DQ19QSFlTSUNTX0NBTk5PTiA9IENDX1BIWVNJQ1NfQ0FOTk9OO1xuICAgIF9nbG9iYWwuQ0NfRURJVE9SID0gQ0NfRURJVE9SO1xuICAgIF9nbG9iYWwuQ0NfUFJFVklFVyA9IENDX1BSRVZJRVc7XG4gICAgX2dsb2JhbC5DQ19URVNUID0gQ0NfVEVTVDtcbiAgICBfZ2xvYmFsLkNDX1JVTlRJTUUgPSBDQ19SVU5USU1FO1xuICAgIF9nbG9iYWwuQ0NfSlNCID0gQ0NfSlNCO1xufVxuZWxzZSB7XG4gICAgZGVmaW5lTWFjcm8oJ0NDX0RFVicsIHRydWUpOyAgICAvLyAoQ0NfRURJVE9SICYmICFDQ19CVUlMRCkgfHwgQ0NfUFJFVklFVyB8fCBDQ19URVNUXG4gICAgZGVmaW5lTWFjcm8oJ0NDX0RFQlVHJywgdHJ1ZSk7ICAvLyBDQ19ERVYgfHwgRGVidWcgQnVpbGRcbiAgICBkZWZpbmVNYWNybygnQ0NfSlNCJywgZGVmaW5lZCgnanNiJykpO1xuICAgIGRlZmluZU1hY3JvKCdDQ19OQVRJVkVSRU5ERVJFUicsIGRlZmluZWQoJ2pzYicpKTtcbiAgICBkZWZpbmVNYWNybygnQ0NfU1VQUE9SVF9KSVQnLCB0cnVlKTtcbiAgICBkZWZpbmVNYWNybygnQ0NfUEhZU0lDU19CVUlMVElOJywgZmFsc2UpO1xuICAgIGRlZmluZU1hY3JvKCdDQ19QSFlTSUNTX0NBTk5PTicsIHRydWUpO1xuICAgIGRlZmluZU1hY3JvKCdDQ19FRElUT1InLCBkZWZpbmVkKCdFZGl0b3InKSAmJiBkZWZpbmVkKCdwcm9jZXNzJykgJiYgKCdlbGVjdHJvbicgaW4gcHJvY2Vzcy52ZXJzaW9ucykpO1xuICAgIGRlZmluZU1hY3JvKCdDQ19QUkVWSUVXJywgIUNDX0VESVRPUik7XG4gICAgZGVmaW5lTWFjcm8oJ0NDX1RFU1QnLCBkZWZpbmVkKCd0YXAnKSB8fCBkZWZpbmVkKCdRVW5pdCcpKTtcbiAgICBkZWZpbmVNYWNybygnQ0NfUlVOVElNRScsICdmdW5jdGlvbicgPT09IHR5cGVvZiBsb2FkUnVudGltZSk7XG4gICAgZGVmaW5lTWFjcm8oJ0NDX0pTQicsIGRlZmluZWQoJ2pzYicpICYmICFDQ19SVU5USU1FKTtcbn1cblxuLy8gZGVwcmVjYXRlZCBcbmNvbnN0IFdFQ0hBVEdBTUVTVUIgPSAhIShkZWZpbmVkKCd3eCcpICYmIHd4LmdldFNoYXJlZENhbnZhcyk7XG5jb25zdCBXRUNIQVRHQU1FID0gISEoZGVmaW5lZCgnd3gnKSAmJiAod3guZ2V0U3lzdGVtSW5mb1N5bmMgfHwgd3guZ2V0U2hhcmVkQ2FudmFzKSk7XG5jb25zdCBRUVBMQVkgPSBkZWZpbmVkKCdiaycpO1xuZGVmaW5lRGVwcmVjYXRlZE1hY3JvR2V0dGVyKCdDQ19XRUNIQVRHQU1FU1VCJywgV0VDSEFUR0FNRVNVQik7XG5kZWZpbmVEZXByZWNhdGVkTWFjcm9HZXR0ZXIoJ0NDX1dFQ0hBVEdBTUUnLCBXRUNIQVRHQU1FKTtcbmRlZmluZURlcHJlY2F0ZWRNYWNyb0dldHRlcignQ0NfUVFQTEFZJywgUVFQTEFZKTtcblxuaWYgKENDX0RFVikge1xuICAgIC8qKlxuICAgICAqIGNvbnRhaW5zIGludGVybmFsIGFwaXMgZm9yIHVuaXQgdGVzdHNcbiAgICAgKiBAZXhwb3NlXG4gICAgICovXG4gICAgY2MuX1Rlc3QgPSB7fTtcbn1cblxuLyoqXG4gKiBAbW9kdWxlIGNjXG4gKi9cblxuLyoqXG4gKiBUaGUgY3VycmVudCB2ZXJzaW9uIG9mIENvY29zMmQgYmVpbmcgdXNlZC48YnIvPlxuICogUGxlYXNlIERPIE5PVCByZW1vdmUgdGhpcyBTdHJpbmcsIGl0IGlzIGFuIGltcG9ydGFudCBmbGFnIGZvciBidWcgdHJhY2tpbmcuPGJyLz5cbiAqIElmIHlvdSBwb3N0IGEgYnVnIHRvIGZvcnVtLCBwbGVhc2UgYXR0YWNoIHRoaXMgZmxhZy5cbiAqIEBwcm9wZXJ0eSB7U3RyaW5nfSBFTkdJTkVfVkVSU0lPTlxuICovXG5jb25zdCBlbmdpbmVWZXJzaW9uID0gJzIuMy4zJztcbl9nbG9iYWxbJ0NvY29zRW5naW5lJ10gPSBjYy5FTkdJTkVfVkVSU0lPTiA9IGVuZ2luZVZlcnNpb247XG4iXSwic291cmNlUm9vdCI6Ii8ifQ==
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/extends.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
require('./cocos2d/core');

require('./cocos2d/animation');

if (CC_EDITOR && Editor.isMainProcess) {
  require('./cocos2d/particle/CCParticleAsset');

  require('./cocos2d/tilemap/CCTiledMapAsset');
} else {
  require('./cocos2d/particle');

  require('./cocos2d/tilemap');

  require('./cocos2d/videoplayer/CCVideoPlayer');

  require('./cocos2d/webview/CCWebView');

  require('./cocos2d/core/components/CCStudioComponent');

  require('./extensions/ccpool/CCNodePool');

  require('./cocos2d/actions');
}

require('./extensions/spine');

require('./extensions/dragonbones');

if (!CC_EDITOR || !Editor.isMainProcess) {
  require('./cocos2d/deprecated');
}
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/polyfill/array.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

if (!Array.isArray) {
  Array.isArray = function (arg) {
    return Object.prototype.toString.call(arg) === '[object Array]';
  };
}

if (!Array.prototype.find) {
  Array.prototype.find = function (callback) {
    var length = this.length;

    for (var i = 0; i < length; i++) {
      var element = this[i];

      if (callback.call(this, element, i, this)) {
        return element;
      }
    }

    return undefined;
  };
} // for ie 11


if (!Array.prototype.includes) {
  Array.prototype.includes = function (value) {
    return this.indexOf(value) !== -1;
  };
}
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/polyfill/misc.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

if (!Math.sign) {
  Math.sign = function (x) {
    x = +x; // convert to a number

    if (x === 0 || isNaN(x)) {
      return x;
    }

    return x > 0 ? 1 : -1;
  };
}

if (!Math.log2) {
  Math.log2 = function (x) {
    return Math.log(x) * Math.LOG2E;
  };
}

if (!Number.isInteger) {
  Number.isInteger = function (value) {
    return typeof value === 'number' && isFinite(value) && Math.floor(value) === value;
  };
}

if (CC_JSB || CC_RUNTIME || !console.time) {
  var Timer = window.performance || Date;

  var _timerTable = Object.create(null);

  console.time = function (label) {
    _timerTable[label] = Timer.now();
  };

  console.timeEnd = function (label) {
    var startTime = _timerTable[label];
    var duration = Timer.now() - startTime;
    console.log(label + ": " + duration + "ms");
  };
}
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/polyfill/array-buffer.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

if (!ArrayBuffer.isView) {
  var TypedArray = Object.getPrototypeOf(Int8Array);
  ArrayBuffer.isView = typeof TypedArray === 'function' ? function (obj) {
    return obj instanceof TypedArray;
  } : function (obj) {
    // old JSC, phantom, QtWebview
    if (typeof obj !== 'object') {
      return false;
    }

    var ctor = obj.constructor;
    return ctor === Float32Array || ctor === Uint8Array || ctor === Uint32Array || ctor === Int8Array;
  };
}
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvcG9seWZpbGwvYXJyYXktYnVmZmVyLmpzIl0sIm5hbWVzIjpbIkFycmF5QnVmZmVyIiwiaXNWaWV3IiwiVHlwZWRBcnJheSIsIk9iamVjdCIsImdldFByb3RvdHlwZU9mIiwiSW50OEFycmF5Iiwib2JqIiwiY3RvciIsImNvbnN0cnVjdG9yIiwiRmxvYXQzMkFycmF5IiwiVWludDhBcnJheSIsIlVpbnQzMkFycmF5Il0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7O0FBQUEsSUFBSSxDQUFDQSxXQUFXLENBQUNDLE1BQWpCLEVBQXlCO0FBQ3JCLE1BQU1DLFVBQVUsR0FBR0MsTUFBTSxDQUFDQyxjQUFQLENBQXNCQyxTQUF0QixDQUFuQjtBQUNBTCxFQUFBQSxXQUFXLENBQUNDLE1BQVosR0FBc0IsT0FBT0MsVUFBUCxLQUFzQixVQUF2QixHQUFxQyxVQUFVSSxHQUFWLEVBQWU7QUFDckUsV0FBT0EsR0FBRyxZQUFZSixVQUF0QjtBQUNILEdBRm9CLEdBRWpCLFVBQVVJLEdBQVYsRUFBZTtBQUNmO0FBQ0EsUUFBSSxPQUFPQSxHQUFQLEtBQWUsUUFBbkIsRUFBNkI7QUFDekIsYUFBTyxLQUFQO0FBQ0g7O0FBQ0QsUUFBSUMsSUFBSSxHQUFHRCxHQUFHLENBQUNFLFdBQWY7QUFDQSxXQUFPRCxJQUFJLEtBQUtFLFlBQVQsSUFBeUJGLElBQUksS0FBS0csVUFBbEMsSUFBZ0RILElBQUksS0FBS0ksV0FBekQsSUFBd0VKLElBQUksS0FBS0YsU0FBeEY7QUFDSCxHQVREO0FBVUgiLCJzb3VyY2VzQ29udGVudCI6WyJpZiAoIUFycmF5QnVmZmVyLmlzVmlldykge1xuICAgIGNvbnN0IFR5cGVkQXJyYXkgPSBPYmplY3QuZ2V0UHJvdG90eXBlT2YoSW50OEFycmF5KTtcbiAgICBBcnJheUJ1ZmZlci5pc1ZpZXcgPSAodHlwZW9mIFR5cGVkQXJyYXkgPT09ICdmdW5jdGlvbicpID8gZnVuY3Rpb24gKG9iaikge1xuICAgICAgICByZXR1cm4gb2JqIGluc3RhbmNlb2YgVHlwZWRBcnJheTtcbiAgICB9IDogZnVuY3Rpb24gKG9iaikge1xuICAgICAgICAvLyBvbGQgSlNDLCBwaGFudG9tLCBRdFdlYnZpZXdcbiAgICAgICAgaWYgKHR5cGVvZiBvYmogIT09ICdvYmplY3QnKSB7XG4gICAgICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICAgIH1cbiAgICAgICAgbGV0IGN0b3IgPSBvYmouY29uc3RydWN0b3I7XG4gICAgICAgIHJldHVybiBjdG9yID09PSBGbG9hdDMyQXJyYXkgfHwgY3RvciA9PT0gVWludDhBcnJheSB8fCBjdG9yID09PSBVaW50MzJBcnJheSB8fCBjdG9yID09PSBJbnQ4QXJyYXk7XG4gICAgfTtcbn0iXSwic291cmNlUm9vdCI6Ii8ifQ==
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/polyfill/number.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

Number.parseFloat = Number.parseFloat || parseFloat;
Number.parseInt = Number.parseInt || parseInt;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvcG9seWZpbGwvbnVtYmVyLmpzIl0sIm5hbWVzIjpbIk51bWJlciIsInBhcnNlRmxvYXQiLCJwYXJzZUludCJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7OztBQUNBQSxNQUFNLENBQUNDLFVBQVAsR0FBb0JELE1BQU0sQ0FBQ0MsVUFBUCxJQUFxQkEsVUFBekM7QUFDQUQsTUFBTSxDQUFDRSxRQUFQLEdBQWtCRixNQUFNLENBQUNFLFFBQVAsSUFBbUJBLFFBQXJDIiwic291cmNlc0NvbnRlbnQiOlsiXG5OdW1iZXIucGFyc2VGbG9hdCA9IE51bWJlci5wYXJzZUZsb2F0IHx8IHBhcnNlRmxvYXQ7XG5OdW1iZXIucGFyc2VJbnQgPSBOdW1iZXIucGFyc2VJbnQgfHwgcGFyc2VJbnQ7XG4iXSwic291cmNlUm9vdCI6Ii8ifQ==
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/package.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}module.exports = {
  "name": "cocos-creator-js",
  "version": "2.3.3",
  "description": "Cocos2d-html5 is a cross-platform 2D game engine written in Javascript, based on Cocos2d-X and licensed under MIT. It incorporates the same high level api as “Cocos2d JS-binding engine” and compatible with Cocos2d-X. It currently supports canvas and WebGL renderering.",
  "homepage": "http://www.cocos2d-x.org",
  "authors": [
    "AUTHORS.txt"
  ],
  "license": "MIT",
  "scripts": {
    "test": "gulp test-in-ci",
    "build-chunks": "node ./cocos2d/renderer/build/build-chunks",
    "build-mapping": "node ./cocos2d/renderer/build/build-mapping"
  },
  "devDependencies": {
    "@babel/core": "^7.4.4",
    "@babel/plugin-proposal-class-properties": "^7.1.0",
    "@babel/plugin-proposal-decorators": "^7.1.6",
    "@babel/preset-env": "^7.1.6",
    "@babel/preset-typescript": "^7.1.0",
    "babel-plugin-add-module-exports": "^0.2.1",
    "babel-plugin-parser-opts": "1.0.1",
    "babel-plugin-transform-export-extensions": "^6.22.0",
    "aliasify": "^2.1.0",
    "async": "1.5.2",
    "babelify": "10.0.0",
    "browserify": "13.0.0",
    "chalk": "1.1.0",
    "del": "3.0.0",
    "event-stream": "3.3.2",
    "fire-fs": "0.2.1",
    "glsl-tokenizer": "2.1.5",
    "gulp": "^4.0.2",
    "gulp-babel": "^8.0.0",
    "gulp-cached": "1.1.0",
    "gulp-concat": "2.6.0",
    "gulp-fb": "0.5.1",
    "gulp-header": "1.2.2",
    "gulp-jshint": "1.11.2",
    "gulp-mirror": "0.4.0",
    "gulp-optimize-js": "^1.1.0",
    "gulp-plumber": "0.6.6",
    "gulp-rename": "1.2.2",
    "gulp-shell": "0.4.1",
    "gulp-size": "2.1.0",
    "gulp-sourcemaps": "2.6.5",
    "gulp-uglify": "^3.0.0",
    "gulp-util": "3.0.6",
    "js-sha1": "^0.6.0",
    "jshint-stylish": "2.1.0",
    "multipipe": "0.3.0",
    "persistify": "^1.1.1",
    "require-dir": "0.3.0",
    "rollup": "^0.66.6",
    "rollup-plugin-node-resolve": "3.4.0",
    "uglify-es": "3.3.7",
    "vinyl": "1.1.0",
    "vinyl-buffer": "1.0.1",
    "vinyl-source-stream": "2.0.0",
    "watchify": "3.7.0"
  }
}

                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/polyfill/string.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

if (!String.prototype.startsWith) {
  String.prototype.startsWith = function (searchString, position) {
    position = position || 0;
    return this.lastIndexOf(searchString, position) === position;
  };
}

if (!String.prototype.endsWith) {
  String.prototype.endsWith = function (searchString, position) {
    if (typeof position === 'undefined' || position > this.length) {
      position = this.length;
    }

    position -= searchString.length;
    var lastIndex = this.indexOf(searchString, position);
    return lastIndex !== -1 && lastIndex === position;
  };
}

if (!String.prototype.trimLeft) {
  String.prototype.trimLeft = function () {
    return this.replace(/^\s+/, '');
  };
}
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/polyfill/typescript.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */

/* global global, define, System, Reflect, Promise */
// tslib 1.9.3
var extendStatics = Object.setPrototypeOf || {
  __proto__: []
} instanceof Array && function (d, b) {
  d.__proto__ = b;
} || function (d, b) {
  for (var p in b) {
    if (b.hasOwnProperty(p)) d[p] = b[p];
  }
};

window.__extends = function (d, b) {
  extendStatics(d, b);

  function __() {
    this.constructor = d;
  }

  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};

window.__assign = Object.assign || function (t) {
  for (var s, i = 1, n = arguments.length; i < n; i++) {
    s = arguments[i];

    for (var p in s) {
      if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
    }
  }

  return t;
};

window.__rest = function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0) t[p[i]] = s[p[i]];
  }
  return t;
};

window.__decorate = function (decorators, target, key, desc) {
  var c = arguments.length,
      r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
      d;
  if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);else for (var i = decorators.length - 1; i >= 0; i--) {
    if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
  }
  return c > 3 && r && Object.defineProperty(target, key, r), r;
};

window.__param = function (paramIndex, decorator) {
  return function (target, key) {
    decorator(target, key, paramIndex);
  };
};

window.__metadata = function (metadataKey, metadataValue) {
  if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
};

window.__awaiter = function (thisArg, _arguments, P, generator) {
  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : new P(function (resolve) {
        resolve(result.value);
      }).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

window.__generator = function (thisArg, body) {
  var _ = {
    label: 0,
    sent: function sent() {
      if (t[0] & 1) throw t[1];
      return t[1];
    },
    trys: [],
    ops: []
  },
      f,
      y,
      t,
      g;
  return g = {
    next: verb(0),
    "throw": verb(1),
    "return": verb(2)
  }, typeof Symbol === "function" && (g[Symbol.iterator] = function () {
    return this;
  }), g;

  function verb(n) {
    return function (v) {
      return step([n, v]);
    };
  }

  function step(op) {
    if (f) throw new TypeError("Generator is already executing.");

    while (_) {
      try {
        if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
        if (y = 0, t) op = [op[0] & 2, t.value];

        switch (op[0]) {
          case 0:
          case 1:
            t = op;
            break;

          case 4:
            _.label++;
            return {
              value: op[1],
              done: false
            };

          case 5:
            _.label++;
            y = op[1];
            op = [0];
            continue;

          case 7:
            op = _.ops.pop();

            _.trys.pop();

            continue;

          default:
            if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
              _ = 0;
              continue;
            }

            if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
              _.label = op[1];
              break;
            }

            if (op[0] === 6 && _.label < t[1]) {
              _.label = t[1];
              t = op;
              break;
            }

            if (t && _.label < t[2]) {
              _.label = t[2];

              _.ops.push(op);

              break;
            }

            if (t[2]) _.ops.pop();

            _.trys.pop();

            continue;
        }

        op = body.call(thisArg, _);
      } catch (e) {
        op = [6, e];
        y = 0;
      } finally {
        f = t = 0;
      }
    }

    if (op[0] & 5) throw op[1];
    return {
      value: op[0] ? op[1] : void 0,
      done: true
    };
  }
};

window.__exportStar = function (m, exports) {
  for (var p in m) {
    if (!exports.hasOwnProperty(p)) exports[p] = m[p];
  }
};

window.__values = function (o) {
  var m = typeof Symbol === "function" && o[Symbol.iterator],
      i = 0;
  if (m) return m.call(o);
  return {
    next: function next() {
      if (o && i >= o.length) o = void 0;
      return {
        value: o && o[i++],
        done: !o
      };
    }
  };
};

window.__read = function (o, n) {
  var m = typeof Symbol === "function" && o[Symbol.iterator];
  if (!m) return o;
  var i = m.call(o),
      r,
      ar = [],
      e;

  try {
    while ((n === void 0 || n-- > 0) && !(r = i.next()).done) {
      ar.push(r.value);
    }
  } catch (error) {
    e = {
      error: error
    };
  } finally {
    try {
      if (r && !r.done && (m = i["return"])) m.call(i);
    } finally {
      if (e) throw e.error;
    }
  }

  return ar;
};

window.__spread = function () {
  for (var ar = [], i = 0; i < arguments.length; i++) {
    ar = ar.concat(__read(arguments[i]));
  }

  return ar;
};

window.__await = function (v) {
  return this instanceof __await ? (this.v = v, this) : new __await(v);
};

window.__asyncGenerator = function (thisArg, _arguments, generator) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var g = generator.apply(thisArg, _arguments || []),
      i,
      q = [];
  return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () {
    return this;
  }, i;

  function verb(n) {
    if (g[n]) i[n] = function (v) {
      return new Promise(function (a, b) {
        q.push([n, v, a, b]) > 1 || resume(n, v);
      });
    };
  }

  function resume(n, v) {
    try {
      step(g[n](v));
    } catch (e) {
      settle(q[0][3], e);
    }
  }

  function step(r) {
    r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);
  }

  function fulfill(value) {
    resume("next", value);
  }

  function reject(value) {
    resume("throw", value);
  }

  function settle(f, v) {
    if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]);
  }
};

window.__asyncDelegator = function (o) {
  var i, p;
  return i = {}, verb("next"), verb("throw", function (e) {
    throw e;
  }), verb("return"), i[Symbol.iterator] = function () {
    return this;
  }, i;

  function verb(n, f) {
    i[n] = o[n] ? function (v) {
      return (p = !p) ? {
        value: __await(o[n](v)),
        done: n === "return"
      } : f ? f(v) : v;
    } : f;
  }
};

window.__asyncValues = function (o) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var m = o[Symbol.asyncIterator],
      i;
  return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () {
    return this;
  }, i);

  function verb(n) {
    i[n] = o[n] && function (v) {
      return new Promise(function (resolve, reject) {
        v = o[n](v), settle(resolve, reject, v.done, v.value);
      });
    };
  }

  function settle(resolve, reject, d, v) {
    Promise.resolve(v).then(function (v) {
      resolve({
        value: v,
        done: d
      });
    }, reject);
  }
};

window.__makeTemplateObject = function (cooked, raw) {
  if (Object.defineProperty) {
    Object.defineProperty(cooked, "raw", {
      value: raw
    });
  } else {
    cooked.raw = raw;
  }

  return cooked;
};

window.__importStar = function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
  }
  result["default"] = mod;
  return result;
};

window.__importDefault = function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/predefine.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
// predefine some modules for cocos
require('./platform/js');

require('./value-types');

require('./utils');

require('./platform/CCInputManager');

require('./platform/CCInputExtension');

require('./event');

require('./platform/CCSys');

require('./platform/CCMacro');

require('./load-pipeline');

require('./CCDirector');

require('./renderer');

if (!(CC_EDITOR && Editor.isMainProcess)) {
  require('./platform/CCView');

  require('./platform/CCScreen');

  require('./CCScheduler');

  require('./event-manager');
}
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/index.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
require('./core/CCGame'); // ensure modular-cocos2d can determine whether action module is included


require('./actions');
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/particle/CCParticleAsset.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var Asset = require('../core/assets/CCAsset');

var CCSpriteFrame = require('../core/assets/CCSpriteFrame');
/**
 * Class for particle asset handling.
 * @class ParticleAsset
 * @extends Asset
 */


var ParticleAsset = cc.Class({
  name: 'cc.ParticleAsset',
  "extends": Asset,
  properties: {
    spriteFrame: {
      "default": null,
      type: CCSpriteFrame
    }
  }
});
cc.ParticleAsset = module.exports = ParticleAsset;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/tilemap/CCTiledMapAsset.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

/**
 * Class for tiled map asset handling.
 * @class TiledMapAsset
 * @extends Asset
 *
 */
var TiledMapAsset = cc.Class({
  name: 'cc.TiledMapAsset',
  "extends": cc.Asset,
  properties: {
    tmxXmlStr: '',

    /**
     * @property {Texture2D[]} textures
     */
    textures: {
      "default": [],
      type: [cc.Texture2D]
    },

    /**
     * @property {String[]} textureNames
     */
    textureNames: [cc.String],

    /**
     * @property {Size[]} textureSizes
     */
    textureSizes: {
      "default": [],
      type: [cc.Size]
    },

    /**
     * @property {Texture2D[]} imageLayerTextures
     */
    imageLayerTextures: {
      "default": [],
      type: [cc.Texture2D]
    },

    /**
     * @property {String[]} imageLayerTextureNames
     */
    imageLayerTextureNames: [cc.String],
    tsxFiles: [cc.TextAsset],
    tsxFileNames: [cc.String]
  },
  statics: {
    preventDeferredLoadDependents: true
  },
  createNode: CC_EDITOR && function (callback) {
    var node = new cc.Node(this.name);
    var tiledMap = node.addComponent(cc.TiledMap);
    tiledMap.tmxAsset = this;
    return callback(null, node);
  }
});
cc.TiledMapAsset = TiledMapAsset;
module.exports = TiledMapAsset;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/videoplayer/CCVideoPlayer.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var VideoPlayerImpl = require('./video-player-impl');
/**
 * !#en Video event type
 * !#zh 视频事件类型
 * @enum VideoPlayer.EventType
 */

/**
 * !#en play
 * !#zh 播放
 * @property {Number} PLAYING
 */

/**
 * !#en pause
 * !#zh 暂停
 * @property {Number} PAUSED
 */

/**
 * !#en stop
 * !#zh 停止
 * @property {Number} STOPPED
 */

/**
 * !#en play end
 * !#zh 播放结束
 * @property {Number} COMPLETED
 */

/**
 * !#en meta data is loaded
 * !#zh 视频的元信息已加载完成，你可以调用 getDuration 来获取视频总时长
 * @property {Number} META_LOADED
 */

/**
 * !#en clicked by the user
 * !#zh 视频被用户点击了
 * @property {Number} CLICKED
 */

/**
 * !#en ready to play, this event is not guaranteed to be triggered on all platform or browser, please don't rely on it to play your video.<br/>
 * !#zh 视频准备好了，这个事件并不保障会在所有平台或浏览器中被触发，它依赖于平台实现，请不要依赖于这个事件做视频播放的控制。
 * @property {Number} READY_TO_PLAY
 */


var EventType = VideoPlayerImpl.EventType;
/**
 * !#en Enum for video resouce type type.
 * !#zh 视频来源
 * @enum VideoPlayer.ResourceType
 */

var ResourceType = cc.Enum({
  /**
   * !#en The remote resource type.
   * !#zh 远程视频
   * @property {Number} REMOTE
   */
  REMOTE: 0,

  /**
   * !#en The local resouce type.
   * !#zh 本地视频
   * @property {Number} LOCAL
   */
  LOCAL: 1
});
/**
 * !#en cc.VideoPlayer is a component for playing videos, you can use it for showing videos in your game. Because different platforms have different authorization, API and control methods for VideoPlayer component. And have not yet formed a unified standard, only Web, iOS, and Android platforms are currently supported.
 * !#zh Video 组件，用于在游戏中播放视频。由于不同平台对于 VideoPlayer 组件的授权、API、控制方式都不同，还没有形成统一的标准，所以目前只支持 Web、iOS 和 Android 平台。
 * @class VideoPlayer
 * @extends Component
 */

var VideoPlayer = cc.Class({
  name: 'cc.VideoPlayer',
  "extends": cc.Component,
  editor: CC_EDITOR && {
    menu: 'i18n:MAIN_MENU.component.ui/VideoPlayer',
    inspector: 'packages://inspector/inspectors/comps/videoplayer.js',
    help: 'i18n:COMPONENT.help_url.videoplayer',
    executeInEditMode: true
  },
  properties: {
    _resourceType: ResourceType.REMOTE,

    /**
     * !#en The resource type of videoplayer, REMOTE for remote url and LOCAL for local file path.
     * !#zh 视频来源：REMOTE 表示远程视频 URL，LOCAL 表示本地视频地址。
     * @property {VideoPlayer.ResourceType} resourceType
     */
    resourceType: {
      tooltip: CC_DEV && 'i18n:COMPONENT.videoplayer.resourceType',
      type: ResourceType,
      set: function set(value) {
        this._resourceType = value;

        this._updateVideoSource();
      },
      get: function get() {
        return this._resourceType;
      }
    },
    _remoteURL: '',

    /**
     * !#en The remote URL of video.
     * !#zh 远程视频的 URL
     * @property {String} remoteURL
     */
    remoteURL: {
      tooltip: CC_DEV && 'i18n:COMPONENT.videoplayer.url',
      type: cc.String,
      set: function set(url) {
        this._remoteURL = url;

        this._updateVideoSource();
      },
      get: function get() {
        return this._remoteURL;
      }
    },
    _clip: {
      "default": null,
      type: cc.Asset
    },

    /**
     * !#en The local video full path.
     * !#zh 本地视频的 URL
     * @property {String} clip
     */
    clip: {
      tooltip: CC_DEV && 'i18n:COMPONENT.videoplayer.video',
      get: function get() {
        return this._clip;
      },
      set: function set(value) {
        this._clip = value;

        this._updateVideoSource();
      },
      type: cc.Asset
    },

    /**
     * !#en The current playback time of the now playing item in seconds, you could also change the start playback time.
     * !#zh 指定视频从什么时间点开始播放，单位是秒，也可以用来获取当前视频播放的时间进度。
     * @property {Number} currentTime
     */
    currentTime: {
      tooltip: CC_DEV && 'i18n:COMPONENT.videoplayer.currentTime',
      type: cc.Float,
      set: function set(time) {
        if (this._impl) {
          this._impl.seekTo(time);
        }
      },
      get: function get() {
        if (this._impl) {
          // for used to make the current time of each platform consistent
          if (this._currentStatus === EventType.NONE || this._currentStatus === EventType.STOPPED || this._currentStatus === EventType.META_LOADED || this._currentStatus === EventType.READY_TO_PLAY) {
            return 0;
          } else if (this._currentStatus === EventType.COMPLETED) {
            return this._impl.duration();
          }

          return this._impl.currentTime();
        }

        return -1;
      }
    },
    _volume: 1,

    /**
     * !#en The volume of the video.
     * !#zh 视频的音量（0.0 ~ 1.0）
     * @property volume
     * @type {Number}
     * @default 1
     */
    volume: {
      get: function get() {
        return this._volume;
      },
      set: function set(value) {
        this._volume = value;

        if (this.isPlaying() && !this._mute) {
          this._syncVolume();
        }
      },
      range: [0, 1],
      type: cc.Float,
      tooltip: CC_DEV && 'i18n:COMPONENT.videoplayer.volume'
    },
    _mute: false,

    /**
     * !#en Mutes the VideoPlayer. Mute sets the volume=0, Un-Mute restore the original volume.
     * !#zh 是否静音视频。静音时设置音量为 0，取消静音是恢复原来的音量。
     * @property mute
     * @type {Boolean}
     * @default false
     */
    mute: {
      get: function get() {
        return this._mute;
      },
      set: function set(value) {
        this._mute = value;

        this._syncVolume();
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.videoplayer.mute'
    },

    /**
     * !#en Whether keep the aspect ration of the original video.
     * !#zh 是否保持视频原来的宽高比
     * @property {Boolean} keepAspectRatio
     * @type {Boolean}
     * @default true
     */
    keepAspectRatio: {
      tooltip: CC_DEV && 'i18n:COMPONENT.videoplayer.keepAspectRatio',
      "default": true,
      type: cc.Boolean,
      notify: function notify() {
        this._impl && this._impl.setKeepAspectRatioEnabled(this.keepAspectRatio);
      }
    },

    /**
     * !#en Whether play video in fullscreen mode.
     * !#zh 是否全屏播放视频
     * @property {Boolean} isFullscreen
     * @type {Boolean}
     * @default false
     */
    _isFullscreen: {
      "default": false,
      formerlySerializedAs: '_N$isFullscreen'
    },
    isFullscreen: {
      get: function get() {
        if (!CC_EDITOR) {
          this._isFullscreen = this._impl && this._impl.isFullScreenEnabled();
        }

        return this._isFullscreen;
      },
      set: function set(enable) {
        this._isFullscreen = enable;

        if (!CC_EDITOR) {
          this._impl && this._impl.setFullScreenEnabled(enable);
        }
      },
      animatable: false,
      tooltip: CC_DEV && 'i18n:COMPONENT.videoplayer.isFullscreen'
    },

    /**
     * !#en Always below the game view (only useful on Web. Note: The specific effects are not guaranteed to be consistent, depending on whether each browser supports or restricts).
     * !#zh 永远在游戏视图最底层（这个属性只有在 Web 平台上有效果。注意：具体效果无法保证一致，跟各个浏览器是否支持与限制有关）
     * @property {Boolean} stayOnBottom
     */
    _stayOnBottom: false,
    stayOnBottom: {
      get: function get() {
        return this._stayOnBottom;
      },
      set: function set(enable) {
        this._stayOnBottom = enable;

        if (this._impl) {
          this._impl.setStayOnBottom(enable);
        }
      },
      animatable: false,
      tooltip: CC_DEV && 'i18n:COMPONENT.videoplayer.stayOnBottom'
    },

    /**
     * !#en the video player's callback, it will be triggered when certain event occurs, like: playing, paused, stopped and completed.
     * !#zh 视频播放回调函数，该回调函数会在特定情况被触发，比如播放中，暂时，停止和完成播放。
     * @property {Component.EventHandler[]} videoPlayerEvent
     */
    videoPlayerEvent: {
      "default": [],
      type: cc.Component.EventHandler
    }
  },
  statics: {
    EventType: EventType,
    ResourceType: ResourceType,
    Impl: VideoPlayerImpl
  },
  ctor: function ctor() {
    this._impl = new VideoPlayerImpl();
    this._currentStatus = EventType.NONE;
  },
  _syncVolume: function _syncVolume() {
    var impl = this._impl;

    if (impl) {
      var volume = this._mute ? 0 : this._volume;
      impl.setVolume(volume);
    }
  },
  _updateVideoSource: function _updateVideoSource() {
    var url = '';

    if (this.resourceType === ResourceType.REMOTE) {
      url = this.remoteURL;
    } else if (this._clip) {
      url = this._clip.nativeUrl || '';
    }

    if (url && cc.loader.md5Pipe) {
      url = cc.loader.md5Pipe.transformURL(url);
    }

    this._impl.setURL(url, this._mute || this._volume === 0);

    this._impl.setKeepAspectRatioEnabled(this.keepAspectRatio);
  },
  onLoad: function onLoad() {
    var impl = this._impl;

    if (impl) {
      impl.createDomElementIfNeeded(this._mute || this._volume === 0);
      impl.setStayOnBottom(this._stayOnBottom);

      this._updateVideoSource();

      if (!CC_EDITOR) {
        impl.seekTo(this.currentTime);
        impl.setFullScreenEnabled(this._isFullscreen);
        this.pause();
        impl.setEventListener(EventType.PLAYING, this.onPlaying.bind(this));
        impl.setEventListener(EventType.PAUSED, this.onPasued.bind(this));
        impl.setEventListener(EventType.STOPPED, this.onStopped.bind(this));
        impl.setEventListener(EventType.COMPLETED, this.onCompleted.bind(this));
        impl.setEventListener(EventType.META_LOADED, this.onMetaLoaded.bind(this));
        impl.setEventListener(EventType.CLICKED, this.onClicked.bind(this));
        impl.setEventListener(EventType.READY_TO_PLAY, this.onReadyToPlay.bind(this));
      }
    }
  },
  onRestore: function onRestore() {
    if (!this._impl) {
      this._impl = new VideoPlayerImpl();
    }
  },
  onEnable: function onEnable() {
    if (this._impl) {
      this._impl.enable();
    }
  },
  onDisable: function onDisable() {
    if (this._impl) {
      this._impl.disable();
    }
  },
  onDestroy: function onDestroy() {
    if (this._impl) {
      this._impl.destroy();

      this._impl = null;
    }
  },
  update: function update(dt) {
    if (this._impl) {
      this._impl.updateMatrix(this.node);
    }
  },
  onReadyToPlay: function onReadyToPlay() {
    this._currentStatus = EventType.READY_TO_PLAY;
    cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.READY_TO_PLAY);
    this.node.emit('ready-to-play', this);
  },
  onMetaLoaded: function onMetaLoaded() {
    this._currentStatus = EventType.META_LOADED;
    cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.META_LOADED);
    this.node.emit('meta-loaded', this);
  },
  onClicked: function onClicked() {
    this._currentStatus = EventType.CLICKED;
    cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.CLICKED);
    this.node.emit('clicked', this);
  },
  onPlaying: function onPlaying() {
    this._currentStatus = EventType.PLAYING;
    cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.PLAYING);
    this.node.emit('playing', this);
  },
  onPasued: function onPasued() {
    this._currentStatus = EventType.PAUSED;
    cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.PAUSED);
    this.node.emit('paused', this);
  },
  onStopped: function onStopped() {
    this._currentStatus = EventType.STOPPED;
    cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.STOPPED);
    this.node.emit('stopped', this);
  },
  onCompleted: function onCompleted() {
    this._currentStatus = EventType.COMPLETED;
    cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.COMPLETED);
    this.node.emit('completed', this);
  },

  /**
   * !#en If a video is paused, call this method could resume playing. If a video is stopped, call this method to play from scratch.
   * !#zh 如果视频被暂停播放了，调用这个接口可以继续播放。如果视频被停止播放了，调用这个接口可以从头开始播放。
   * @method play
   */
  play: function play() {
    if (this._impl) {
      this._syncVolume();

      this._impl.play();
    }
  },

  /**
   * !#en If a video is paused, call this method to resume playing.
   * !#zh 如果一个视频播放被暂停播放了，调用这个接口可以继续播放。
   * @method resume
   */
  resume: function resume() {
    if (this._impl) {
      this._syncVolume();

      this._impl.resume();
    }
  },

  /**
   * !#en If a video is playing, call this method to pause playing.
   * !#zh 如果一个视频正在播放，调用这个接口可以暂停播放。
   * @method pause
   */
  pause: function pause() {
    if (this._impl) {
      this._impl.pause();
    }
  },

  /**
   * !#en If a video is playing, call this method to stop playing immediately.
   * !#zh 如果一个视频正在播放，调用这个接口可以立马停止播放。
   * @method stop
   */
  stop: function stop() {
    if (this._impl) {
      this._impl.stop();
    }
  },

  /**
   * !#en Gets the duration of the video
   * !#zh 获取视频文件的播放总时长
   * @method getDuration
   * @returns {Number}
   */
  getDuration: function getDuration() {
    if (this._impl) {
      return this._impl.duration();
    }

    return -1;
  },

  /**
   * !#en Determine whether video is playing or not.
   * !#zh 判断当前视频是否处于播放状态
   * @method isPlaying
   * @returns {Boolean}
   */
  isPlaying: function isPlaying() {
    if (this._impl) {
      return this._impl.isPlaying();
    }

    return false;
  }
  /**
   * !#en if you don't need the VideoPlayer and it isn't in any running Scene, you should
   * call the destroy method on this component or the associated node explicitly.
   * Otherwise, the created DOM element won't be removed from web page.
   * !#zh
   * 如果你不再使用 VideoPlayer，并且组件未添加到场景中，那么你必须手动对组件或所在节点调用 destroy。
   * 这样才能移除网页上的 DOM 节点，避免 Web 平台内存泄露。
   * @example
   * videoplayer.node.parent = null;  // or  videoplayer.node.removeFromParent(false);
   * // when you don't need videoplayer anymore
   * videoplayer.node.destroy();
   * @method destroy
   * @return {Boolean} whether it is the first time the destroy being called
   */

});
cc.VideoPlayer = module.exports = VideoPlayer;
/**
 * !#en
 * Note: This event is emitted from the node to which the component belongs.
 * !#zh
 * 注意：此事件是从该组件所属的 Node 上面派发出来的，需要用 node.on 来监听。
 * @event ready-to-play
 * @param {Event.EventCustom} event
 * @param {VideoPlayer} videoPlayer - The VideoPlayer component.
 */

/**
 * !#en
 * Note: This event is emitted from the node to which the component belongs.
 * !#zh
 * 注意：此事件是从该组件所属的 Node 上面派发出来的，需要用 node.on 来监听。
 * @event meta-loaded
 * @param {Event.EventCustom} event
 * @param {VideoPlayer} videoPlayer - The VideoPlayer component.
 */

/**
 * !#en
 * Note: This event is emitted from the node to which the component belongs.
 * !#zh
 * 注意：此事件是从该组件所属的 Node 上面派发出来的，需要用 node.on 来监听。
 * @event clicked
 * @param {Event.EventCustom} event
 * @param {VideoPlayer} videoPlayer - The VideoPlayer component.
 */

/**
 * !#en
 * Note: This event is emitted from the node to which the component belongs.
 * !#zh
 * 注意：此事件是从该组件所属的 Node 上面派发出来的，需要用 node.on 来监听。
 * @event playing
 * @param {Event.EventCustom} event
 * @param {VideoPlayer} videoPlayer - The VideoPlayer component.
 */

/**
 * !#en
 * Note: This event is emitted from the node to which the component belongs.
 * !#zh
 * 注意：此事件是从该组件所属的 Node 上面派发出来的，需要用 node.on 来监听。
 * @event paused
 * @param {Event.EventCustom} event
 * @param {VideoPlayer} videoPlayer - The VideoPlayer component.
 */

/**
 * !#en
 * Note: This event is emitted from the node to which the component belongs.
 * !#zh
 * 注意：此事件是从该组件所属的 Node 上面派发出来的，需要用 node.on 来监听。
 * @event stopped
 * @param {Event.EventCustom} event
 * @param {VideoPlayer} videoPlayer - The VideoPlayer component.
 */

/**
 * !#en
 * Note: This event is emitted from the node to which the component belongs.
 * !#zh
 * 注意：此事件是从该组件所属的 Node 上面派发出来的，需要用 node.on 来监听。
 * @event completed
 * @param {Event.EventCustom} event
 * @param {VideoPlayer} videoPlayer - The VideoPlayer component.
 */
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/webview/CCWebView.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var WebViewImpl = require('./webview-impl');
/**
 * !#en WebView event type
 * !#zh 网页视图事件类型
 * @enum WebView.EventType
 */


var EventType = WebViewImpl.EventType;
/**
 * !#en Web page Load completed.
 * !#zh  网页加载完成
 * @property {String} LOADED
 */

/**
 * !#en Web page is loading.
 * !#zh  网页加载中
 * @property {String} LOADING
 */

/**
 * !#en Web page error occurs when loading.
 * !#zh  网页加载出错
 * @property {String} ERROR
 */
//

function emptyCallback() {}
/**
 * !#en cc.WebView is a component for display web pages in the game. Because different platforms have different authorization, API and control methods for WebView component. And have not yet formed a unified standard, only Web, iOS, and Android platforms are currently supported.
 * !#zh WebView 组件，用于在游戏中显示网页。由于不同平台对于 WebView 组件的授权、API、控制方式都不同，还没有形成统一的标准，所以目前只支持 Web、iOS 和 Android 平台。
 * @class WebView
 * @extends Component
 */


var WebView = cc.Class({
  name: 'cc.WebView',
  "extends": cc.Component,
  editor: CC_EDITOR && {
    menu: 'i18n:MAIN_MENU.component.ui/WebView',
    executeInEditMode: true
  },
  properties: {
    _useOriginalSize: true,
    _url: '',

    /**
     * !#en A given URL to be loaded by the WebView, it should have a http or https prefix.
     * !#zh 指定 WebView 加载的网址，它应该是一个 http 或者 https 开头的字符串
     * @property {String} url
     */
    url: {
      type: cc.String,
      tooltip: CC_DEV && 'i18n:COMPONENT.webview.url',
      get: function get() {
        return this._url;
      },
      set: function set(url) {
        this._url = url;
        var impl = this._impl;

        if (impl) {
          impl.loadURL(url);
        }
      }
    },

    /**
     * !#en The webview's event callback , it will be triggered when certain webview event occurs.
     * !#zh WebView 的回调事件，当网页加载过程中，加载完成后或者加载出错时都会回调此函数
     * @property {Component.EventHandler[]} webviewLoadedEvents
     */
    webviewEvents: {
      "default": [],
      type: cc.Component.EventHandler
    }
  },
  statics: {
    EventType: EventType,
    // Impl will be overrided in the different platform.
    Impl: WebViewImpl
  },
  ctor: function ctor() {
    this._impl = new WebView.Impl();
  },
  onRestore: function onRestore() {
    if (!this._impl) {
      this._impl = new WebView.Impl();
    }
  },
  onEnable: function onEnable() {
    var impl = this._impl;
    impl.createDomElementIfNeeded(this.node.width, this.node.height);

    if (!CC_EDITOR) {
      impl.setEventListener(EventType.LOADED, this._onWebViewLoaded.bind(this));
      impl.setEventListener(EventType.LOADING, this._onWebViewLoading.bind(this));
      impl.setEventListener(EventType.ERROR, this._onWebViewLoadError.bind(this));
    }

    impl.loadURL(this._url);
    impl.setVisible(true);
  },
  onDisable: function onDisable() {
    var impl = this._impl;
    impl.setVisible(false);

    if (!CC_EDITOR) {
      impl.setEventListener(EventType.LOADED, emptyCallback);
      impl.setEventListener(EventType.LOADING, emptyCallback);
      impl.setEventListener(EventType.ERROR, emptyCallback);
    }
  },
  onDestroy: function onDestroy() {
    if (this._impl) {
      this._impl.destroy();

      this._impl = null;
    }
  },
  update: function update(dt) {
    if (this._impl) {
      this._impl.updateMatrix(this.node);
    }
  },
  _onWebViewLoaded: function _onWebViewLoaded() {
    cc.Component.EventHandler.emitEvents(this.webviewEvents, this, EventType.LOADED);
    this.node.emit('loaded', this);
  },
  _onWebViewLoading: function _onWebViewLoading() {
    cc.Component.EventHandler.emitEvents(this.webviewEvents, this, EventType.LOADING);
    this.node.emit('loading', this);
    return true;
  },
  _onWebViewLoadError: function _onWebViewLoadError() {
    cc.Component.EventHandler.emitEvents(this.webviewEvents, this, EventType.ERROR);
    this.node.emit('error', this);
  },

  /**
   * !#en
   * Set javascript interface scheme (see also setOnJSCallback). <br/>
   * Note: Supports only on the Android and iOS. For HTML5, please refer to the official documentation.<br/>
   * Please refer to the official documentation for more details.
   * !#zh
   * 设置 JavaScript 接口方案（与 'setOnJSCallback' 配套使用）。<br/>
   * 注意：只支持 Android 和 iOS ，Web 端用法请前往官方文档查看。<br/>
   * 详情请参阅官方文档
   * @method setJavascriptInterfaceScheme
   * @param {String} scheme
   */
  setJavascriptInterfaceScheme: function setJavascriptInterfaceScheme(scheme) {
    if (this._impl) {
      this._impl.setJavascriptInterfaceScheme(scheme);
    }
  },

  /**
   * !#en
   * This callback called when load URL that start with javascript
   * interface scheme (see also setJavascriptInterfaceScheme). <br/>
   * Note: Supports only on the Android and iOS. For HTML5, please refer to the official documentation.<br/>
   * Please refer to the official documentation for more details.
   * !#zh
   * 当加载 URL 以 JavaScript 接口方案开始时调用这个回调函数。<br/>
   * 注意：只支持 Android 和 iOS，Web 端用法请前往官方文档查看。
   * 详情请参阅官方文档
   * @method setOnJSCallback
   * @param {Function} callback
   */
  setOnJSCallback: function setOnJSCallback(callback) {
    if (this._impl) {
      this._impl.setOnJSCallback(callback);
    }
  },

  /**
   * !#en
   * Evaluates JavaScript in the context of the currently displayed page. <br/>
   * Please refer to the official document for more details <br/>
   * Note: Cross domain issues need to be resolved by yourself <br/>
   * !#zh
   * 执行 WebView 内部页面脚本（详情请参阅官方文档） <br/>
   * 注意：需要自行解决跨域问题
   * @method evaluateJS
   * @param {String} str
   */
  evaluateJS: function evaluateJS(str) {
    if (this._impl) {
      this._impl.evaluateJS(str);
    }
  }
});
cc.WebView = module.exports = WebView;
/**
 * !#en
 * Note: This event is emitted from the node to which the component belongs.
 * !#zh
 * 注意：此事件是从该组件所属的 Node 上面派发出来的，需要用 node.on 来监听。
 * @event loaded
 * @param {Event.EventCustom} event
 * @param {WebView} webView - The WebView component.
 */

/**
 * !#en
 * Note: This event is emitted from the node to which the component belongs.
 * !#zh
 * 注意：此事件是从该组件所属的 Node 上面派发出来的，需要用 node.on 来监听。
 * @event loading
 * @param {Event.EventCustom} event
 * @param {WebView} webView - The WebView component.
 */

/**
 * !#en
 * Note: This event is emitted from the node to which the component belongs.
 * !#zh
 * 注意：此事件是从该组件所属的 Node 上面派发出来的，需要用 node.on 来监听。
 * @event error
 * @param {Event.EventCustom} event
 * @param {WebView} webView - The WebView component.
 */

/**
 * !#en if you don't need the WebView and it isn't in any running Scene, you should
 * call the destroy method on this component or the associated node explicitly.
 * Otherwise, the created DOM element won't be removed from web page.
 * !#zh
 * 如果你不再使用 WebView，并且组件未添加到场景中，那么你必须手动对组件或所在节点调用 destroy。
 * 这样才能移除网页上的 DOM 节点，避免 Web 平台内存泄露。
 * @example
 * webview.node.parent = null;  // or  webview.node.removeFromParent(false);
 * // when you don't need webview anymore
 * webview.node.destroy();
 * @method destroy
 * @return {Boolean} whether it is the first time the destroy being called
 */
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvY29jb3MyZC93ZWJ2aWV3L0NDV2ViVmlldy5qcyJdLCJuYW1lcyI6WyJXZWJWaWV3SW1wbCIsInJlcXVpcmUiLCJFdmVudFR5cGUiLCJlbXB0eUNhbGxiYWNrIiwiV2ViVmlldyIsImNjIiwiQ2xhc3MiLCJuYW1lIiwiQ29tcG9uZW50IiwiZWRpdG9yIiwiQ0NfRURJVE9SIiwibWVudSIsImV4ZWN1dGVJbkVkaXRNb2RlIiwicHJvcGVydGllcyIsIl91c2VPcmlnaW5hbFNpemUiLCJfdXJsIiwidXJsIiwidHlwZSIsIlN0cmluZyIsInRvb2x0aXAiLCJDQ19ERVYiLCJnZXQiLCJzZXQiLCJpbXBsIiwiX2ltcGwiLCJsb2FkVVJMIiwid2Vidmlld0V2ZW50cyIsIkV2ZW50SGFuZGxlciIsInN0YXRpY3MiLCJJbXBsIiwiY3RvciIsIm9uUmVzdG9yZSIsIm9uRW5hYmxlIiwiY3JlYXRlRG9tRWxlbWVudElmTmVlZGVkIiwibm9kZSIsIndpZHRoIiwiaGVpZ2h0Iiwic2V0RXZlbnRMaXN0ZW5lciIsIkxPQURFRCIsIl9vbldlYlZpZXdMb2FkZWQiLCJiaW5kIiwiTE9BRElORyIsIl9vbldlYlZpZXdMb2FkaW5nIiwiRVJST1IiLCJfb25XZWJWaWV3TG9hZEVycm9yIiwic2V0VmlzaWJsZSIsIm9uRGlzYWJsZSIsIm9uRGVzdHJveSIsImRlc3Ryb3kiLCJ1cGRhdGUiLCJkdCIsInVwZGF0ZU1hdHJpeCIsImVtaXRFdmVudHMiLCJlbWl0Iiwic2V0SmF2YXNjcmlwdEludGVyZmFjZVNjaGVtZSIsInNjaGVtZSIsInNldE9uSlNDYWxsYmFjayIsImNhbGxiYWNrIiwiZXZhbHVhdGVKUyIsInN0ciIsIm1vZHVsZSIsImV4cG9ydHMiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7QUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQTBCQSxJQUFNQSxXQUFXLEdBQUdDLE9BQU8sQ0FBQyxnQkFBRCxDQUEzQjtBQUVBOzs7Ozs7O0FBS0EsSUFBTUMsU0FBUyxHQUFHRixXQUFXLENBQUNFLFNBQTlCO0FBR0E7Ozs7OztBQU1BOzs7Ozs7QUFNQTs7Ozs7QUFNQTs7QUFDQSxTQUFTQyxhQUFULEdBQTBCLENBQUc7QUFFN0I7Ozs7Ozs7O0FBTUEsSUFBSUMsT0FBTyxHQUFHQyxFQUFFLENBQUNDLEtBQUgsQ0FBUztBQUNuQkMsRUFBQUEsSUFBSSxFQUFFLFlBRGE7QUFFbkIsYUFBU0YsRUFBRSxDQUFDRyxTQUZPO0FBSW5CQyxFQUFBQSxNQUFNLEVBQUVDLFNBQVMsSUFBSTtBQUNqQkMsSUFBQUEsSUFBSSxFQUFFLHFDQURXO0FBRWpCQyxJQUFBQSxpQkFBaUIsRUFBRTtBQUZGLEdBSkY7QUFTbkJDLEVBQUFBLFVBQVUsRUFBRTtBQUNSQyxJQUFBQSxnQkFBZ0IsRUFBRSxJQURWO0FBR1JDLElBQUFBLElBQUksRUFBRSxFQUhFOztBQUlSOzs7OztBQUtBQyxJQUFBQSxHQUFHLEVBQUU7QUFDREMsTUFBQUEsSUFBSSxFQUFFWixFQUFFLENBQUNhLE1BRFI7QUFFREMsTUFBQUEsT0FBTyxFQUFFQyxNQUFNLElBQUksNEJBRmxCO0FBR0RDLE1BQUFBLEdBQUcsRUFBRSxlQUFZO0FBQ2IsZUFBTyxLQUFLTixJQUFaO0FBQ0gsT0FMQTtBQU1ETyxNQUFBQSxHQUFHLEVBQUUsYUFBVU4sR0FBVixFQUFlO0FBQ2hCLGFBQUtELElBQUwsR0FBWUMsR0FBWjtBQUNBLFlBQUlPLElBQUksR0FBRyxLQUFLQyxLQUFoQjs7QUFDQSxZQUFJRCxJQUFKLEVBQVU7QUFDTkEsVUFBQUEsSUFBSSxDQUFDRSxPQUFMLENBQWFULEdBQWI7QUFDSDtBQUNKO0FBWkEsS0FURzs7QUF3QlI7Ozs7O0FBS0FVLElBQUFBLGFBQWEsRUFBRTtBQUNYLGlCQUFTLEVBREU7QUFFWFQsTUFBQUEsSUFBSSxFQUFFWixFQUFFLENBQUNHLFNBQUgsQ0FBYW1CO0FBRlI7QUE3QlAsR0FUTztBQTRDbkJDLEVBQUFBLE9BQU8sRUFBRTtBQUNMMUIsSUFBQUEsU0FBUyxFQUFFQSxTQUROO0FBRUw7QUFDQTJCLElBQUFBLElBQUksRUFBRTdCO0FBSEQsR0E1Q1U7QUFrRG5COEIsRUFBQUEsSUFsRG1CLGtCQWtEWDtBQUNKLFNBQUtOLEtBQUwsR0FBYSxJQUFJcEIsT0FBTyxDQUFDeUIsSUFBWixFQUFiO0FBQ0gsR0FwRGtCO0FBc0RuQkUsRUFBQUEsU0F0RG1CLHVCQXNETjtBQUNULFFBQUksQ0FBQyxLQUFLUCxLQUFWLEVBQWlCO0FBQ2IsV0FBS0EsS0FBTCxHQUFhLElBQUlwQixPQUFPLENBQUN5QixJQUFaLEVBQWI7QUFDSDtBQUNKLEdBMURrQjtBQTREbkJHLEVBQUFBLFFBNURtQixzQkE0RFA7QUFDUixRQUFJVCxJQUFJLEdBQUcsS0FBS0MsS0FBaEI7QUFDQUQsSUFBQUEsSUFBSSxDQUFDVSx3QkFBTCxDQUE4QixLQUFLQyxJQUFMLENBQVVDLEtBQXhDLEVBQStDLEtBQUtELElBQUwsQ0FBVUUsTUFBekQ7O0FBQ0EsUUFBSSxDQUFDMUIsU0FBTCxFQUFnQjtBQUNaYSxNQUFBQSxJQUFJLENBQUNjLGdCQUFMLENBQXNCbkMsU0FBUyxDQUFDb0MsTUFBaEMsRUFBd0MsS0FBS0MsZ0JBQUwsQ0FBc0JDLElBQXRCLENBQTJCLElBQTNCLENBQXhDO0FBQ0FqQixNQUFBQSxJQUFJLENBQUNjLGdCQUFMLENBQXNCbkMsU0FBUyxDQUFDdUMsT0FBaEMsRUFBeUMsS0FBS0MsaUJBQUwsQ0FBdUJGLElBQXZCLENBQTRCLElBQTVCLENBQXpDO0FBQ0FqQixNQUFBQSxJQUFJLENBQUNjLGdCQUFMLENBQXNCbkMsU0FBUyxDQUFDeUMsS0FBaEMsRUFBdUMsS0FBS0MsbUJBQUwsQ0FBeUJKLElBQXpCLENBQThCLElBQTlCLENBQXZDO0FBQ0g7O0FBQ0RqQixJQUFBQSxJQUFJLENBQUNFLE9BQUwsQ0FBYSxLQUFLVixJQUFsQjtBQUNBUSxJQUFBQSxJQUFJLENBQUNzQixVQUFMLENBQWdCLElBQWhCO0FBQ0gsR0F0RWtCO0FBd0VuQkMsRUFBQUEsU0F4RW1CLHVCQXdFTjtBQUNULFFBQUl2QixJQUFJLEdBQUcsS0FBS0MsS0FBaEI7QUFDQUQsSUFBQUEsSUFBSSxDQUFDc0IsVUFBTCxDQUFnQixLQUFoQjs7QUFDQSxRQUFJLENBQUNuQyxTQUFMLEVBQWdCO0FBQ1phLE1BQUFBLElBQUksQ0FBQ2MsZ0JBQUwsQ0FBc0JuQyxTQUFTLENBQUNvQyxNQUFoQyxFQUF3Q25DLGFBQXhDO0FBQ0FvQixNQUFBQSxJQUFJLENBQUNjLGdCQUFMLENBQXNCbkMsU0FBUyxDQUFDdUMsT0FBaEMsRUFBeUN0QyxhQUF6QztBQUNBb0IsTUFBQUEsSUFBSSxDQUFDYyxnQkFBTCxDQUFzQm5DLFNBQVMsQ0FBQ3lDLEtBQWhDLEVBQXVDeEMsYUFBdkM7QUFDSDtBQUNKLEdBaEZrQjtBQWtGbkI0QyxFQUFBQSxTQWxGbUIsdUJBa0ZOO0FBQ1QsUUFBSSxLQUFLdkIsS0FBVCxFQUFnQjtBQUNaLFdBQUtBLEtBQUwsQ0FBV3dCLE9BQVg7O0FBQ0EsV0FBS3hCLEtBQUwsR0FBYSxJQUFiO0FBQ0g7QUFDSixHQXZGa0I7QUF5Rm5CeUIsRUFBQUEsTUF6Rm1CLGtCQXlGWEMsRUF6RlcsRUF5RlA7QUFDUixRQUFJLEtBQUsxQixLQUFULEVBQWdCO0FBQ1osV0FBS0EsS0FBTCxDQUFXMkIsWUFBWCxDQUF3QixLQUFLakIsSUFBN0I7QUFDSDtBQUNKLEdBN0ZrQjtBQStGbkJLLEVBQUFBLGdCQS9GbUIsOEJBK0ZDO0FBQ2hCbEMsSUFBQUEsRUFBRSxDQUFDRyxTQUFILENBQWFtQixZQUFiLENBQTBCeUIsVUFBMUIsQ0FBcUMsS0FBSzFCLGFBQTFDLEVBQXlELElBQXpELEVBQStEeEIsU0FBUyxDQUFDb0MsTUFBekU7QUFDQSxTQUFLSixJQUFMLENBQVVtQixJQUFWLENBQWUsUUFBZixFQUF5QixJQUF6QjtBQUNILEdBbEdrQjtBQW9HbkJYLEVBQUFBLGlCQXBHbUIsK0JBb0dFO0FBQ2pCckMsSUFBQUEsRUFBRSxDQUFDRyxTQUFILENBQWFtQixZQUFiLENBQTBCeUIsVUFBMUIsQ0FBcUMsS0FBSzFCLGFBQTFDLEVBQXlELElBQXpELEVBQStEeEIsU0FBUyxDQUFDdUMsT0FBekU7QUFDQSxTQUFLUCxJQUFMLENBQVVtQixJQUFWLENBQWUsU0FBZixFQUEwQixJQUExQjtBQUNBLFdBQU8sSUFBUDtBQUNILEdBeEdrQjtBQTBHbkJULEVBQUFBLG1CQTFHbUIsaUNBMEdJO0FBQ25CdkMsSUFBQUEsRUFBRSxDQUFDRyxTQUFILENBQWFtQixZQUFiLENBQTBCeUIsVUFBMUIsQ0FBcUMsS0FBSzFCLGFBQTFDLEVBQXlELElBQXpELEVBQStEeEIsU0FBUyxDQUFDeUMsS0FBekU7QUFDQSxTQUFLVCxJQUFMLENBQVVtQixJQUFWLENBQWUsT0FBZixFQUF3QixJQUF4QjtBQUNILEdBN0drQjs7QUErR25COzs7Ozs7Ozs7Ozs7QUFZQUMsRUFBQUEsNEJBM0htQix3Q0EySFdDLE1BM0hYLEVBMkhtQjtBQUNsQyxRQUFJLEtBQUsvQixLQUFULEVBQWdCO0FBQ1osV0FBS0EsS0FBTCxDQUFXOEIsNEJBQVgsQ0FBd0NDLE1BQXhDO0FBQ0g7QUFDSixHQS9Ia0I7O0FBaUluQjs7Ozs7Ozs7Ozs7OztBQWFBQyxFQUFBQSxlQTlJbUIsMkJBOElGQyxRQTlJRSxFQThJUTtBQUN2QixRQUFJLEtBQUtqQyxLQUFULEVBQWdCO0FBQ1osV0FBS0EsS0FBTCxDQUFXZ0MsZUFBWCxDQUEyQkMsUUFBM0I7QUFDSDtBQUNKLEdBbEprQjs7QUFvSm5COzs7Ozs7Ozs7OztBQVdBQyxFQUFBQSxVQS9KbUIsc0JBK0pQQyxHQS9KTyxFQStKRjtBQUNiLFFBQUksS0FBS25DLEtBQVQsRUFBZ0I7QUFDWixXQUFLQSxLQUFMLENBQVdrQyxVQUFYLENBQXNCQyxHQUF0QjtBQUNIO0FBQ0o7QUFuS2tCLENBQVQsQ0FBZDtBQXVLQXRELEVBQUUsQ0FBQ0QsT0FBSCxHQUFhd0QsTUFBTSxDQUFDQyxPQUFQLEdBQWlCekQsT0FBOUI7QUFDQTs7Ozs7Ozs7OztBQVVBOzs7Ozs7Ozs7O0FBVUE7Ozs7Ozs7Ozs7QUFVQSIsInNvdXJjZXNDb250ZW50IjpbIi8qKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqXG4gQ29weXJpZ2h0IChjKSAyMDEzLTIwMTYgQ2h1a29uZyBUZWNobm9sb2dpZXMgSW5jLlxuIENvcHlyaWdodCAoYykgMjAxNy0yMDE4IFhpYW1lbiBZYWppIFNvZnR3YXJlIENvLiwgTHRkLlxuXG4gaHR0cHM6Ly93d3cuY29jb3MuY29tL1xuXG4gUGVybWlzc2lvbiBpcyBoZXJlYnkgZ3JhbnRlZCwgZnJlZSBvZiBjaGFyZ2UsIHRvIGFueSBwZXJzb24gb2J0YWluaW5nIGEgY29weVxuIG9mIHRoaXMgc29mdHdhcmUgYW5kIGFzc29jaWF0ZWQgZW5naW5lIHNvdXJjZSBjb2RlICh0aGUgXCJTb2Z0d2FyZVwiKSwgYSBsaW1pdGVkLFxuIHdvcmxkd2lkZSwgcm95YWx0eS1mcmVlLCBub24tYXNzaWduYWJsZSwgcmV2b2NhYmxlIGFuZCBub24tZXhjbHVzaXZlIGxpY2Vuc2VcbiB0byB1c2UgQ29jb3MgQ3JlYXRvciBzb2xlbHkgdG8gZGV2ZWxvcCBnYW1lcyBvbiB5b3VyIHRhcmdldCBwbGF0Zm9ybXMuIFlvdSBzaGFsbFxuIG5vdCB1c2UgQ29jb3MgQ3JlYXRvciBzb2Z0d2FyZSBmb3IgZGV2ZWxvcGluZyBvdGhlciBzb2Z0d2FyZSBvciB0b29scyB0aGF0J3NcbiB1c2VkIGZvciBkZXZlbG9waW5nIGdhbWVzLiBZb3UgYXJlIG5vdCBncmFudGVkIHRvIHB1Ymxpc2gsIGRpc3RyaWJ1dGUsXG4gc3VibGljZW5zZSwgYW5kL29yIHNlbGwgY29waWVzIG9mIENvY29zIENyZWF0b3IuXG5cbiBUaGUgc29mdHdhcmUgb3IgdG9vbHMgaW4gdGhpcyBMaWNlbnNlIEFncmVlbWVudCBhcmUgbGljZW5zZWQsIG5vdCBzb2xkLlxuIFhpYW1lbiBZYWppIFNvZnR3YXJlIENvLiwgTHRkLiByZXNlcnZlcyBhbGwgcmlnaHRzIG5vdCBleHByZXNzbHkgZ3JhbnRlZCB0byB5b3UuXG5cbiBUSEUgU09GVFdBUkUgSVMgUFJPVklERUQgXCJBUyBJU1wiLCBXSVRIT1VUIFdBUlJBTlRZIE9GIEFOWSBLSU5ELCBFWFBSRVNTIE9SXG4gSU1QTElFRCwgSU5DTFVESU5HIEJVVCBOT1QgTElNSVRFRCBUTyBUSEUgV0FSUkFOVElFUyBPRiBNRVJDSEFOVEFCSUxJVFksXG4gRklUTkVTUyBGT1IgQSBQQVJUSUNVTEFSIFBVUlBPU0UgQU5EIE5PTklORlJJTkdFTUVOVC4gSU4gTk8gRVZFTlQgU0hBTEwgVEhFXG4gQVVUSE9SUyBPUiBDT1BZUklHSFQgSE9MREVSUyBCRSBMSUFCTEUgRk9SIEFOWSBDTEFJTSwgREFNQUdFUyBPUiBPVEhFUlxuIExJQUJJTElUWSwgV0hFVEhFUiBJTiBBTiBBQ1RJT04gT0YgQ09OVFJBQ1QsIFRPUlQgT1IgT1RIRVJXSVNFLCBBUklTSU5HIEZST00sXG4gT1VUIE9GIE9SIElOIENPTk5FQ1RJT04gV0lUSCBUSEUgU09GVFdBUkUgT1IgVEhFIFVTRSBPUiBPVEhFUiBERUFMSU5HUyBJTlxuIFRIRSBTT0ZUV0FSRS5cbiAqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqL1xuXG5jb25zdCBXZWJWaWV3SW1wbCA9IHJlcXVpcmUoJy4vd2Vidmlldy1pbXBsJyk7XG5cbi8qKlxuICogISNlbiBXZWJWaWV3IGV2ZW50IHR5cGVcbiAqICEjemgg572R6aG16KeG5Zu+5LqL5Lu257G75Z6LXG4gKiBAZW51bSBXZWJWaWV3LkV2ZW50VHlwZVxuICovXG5jb25zdCBFdmVudFR5cGUgPSBXZWJWaWV3SW1wbC5FdmVudFR5cGU7XG5cblxuLyoqXG4gKiAhI2VuIFdlYiBwYWdlIExvYWQgY29tcGxldGVkLlxuICogISN6aCAg572R6aG15Yqg6L295a6M5oiQXG4gKiBAcHJvcGVydHkge1N0cmluZ30gTE9BREVEXG4gKi9cblxuLyoqXG4gKiAhI2VuIFdlYiBwYWdlIGlzIGxvYWRpbmcuXG4gKiAhI3poICDnvZHpobXliqDovb3kuK1cbiAqIEBwcm9wZXJ0eSB7U3RyaW5nfSBMT0FESU5HXG4gKi9cblxuLyoqXG4gKiAhI2VuIFdlYiBwYWdlIGVycm9yIG9jY3VycyB3aGVuIGxvYWRpbmcuXG4gKiAhI3poICDnvZHpobXliqDovb3lh7rplJlcbiAqIEBwcm9wZXJ0eSB7U3RyaW5nfSBFUlJPUlxuICovXG5cbi8vXG5mdW5jdGlvbiBlbXB0eUNhbGxiYWNrICgpIHsgfVxuXG4vKipcbiAqICEjZW4gY2MuV2ViVmlldyBpcyBhIGNvbXBvbmVudCBmb3IgZGlzcGxheSB3ZWIgcGFnZXMgaW4gdGhlIGdhbWUuIEJlY2F1c2UgZGlmZmVyZW50IHBsYXRmb3JtcyBoYXZlIGRpZmZlcmVudCBhdXRob3JpemF0aW9uLCBBUEkgYW5kIGNvbnRyb2wgbWV0aG9kcyBmb3IgV2ViVmlldyBjb21wb25lbnQuIEFuZCBoYXZlIG5vdCB5ZXQgZm9ybWVkIGEgdW5pZmllZCBzdGFuZGFyZCwgb25seSBXZWIsIGlPUywgYW5kIEFuZHJvaWQgcGxhdGZvcm1zIGFyZSBjdXJyZW50bHkgc3VwcG9ydGVkLlxuICogISN6aCBXZWJWaWV3IOe7hOS7tu+8jOeUqOS6juWcqOa4uOaIj+S4reaYvuekuue9kemhteOAgueUseS6juS4jeWQjOW5s+WPsOWvueS6jiBXZWJWaWV3IOe7hOS7tueahOaOiOadg+OAgUFQSeOAgeaOp+WItuaWueW8j+mDveS4jeWQjO+8jOi/mOayoeacieW9ouaIkOe7n+S4gOeahOagh+WHhu+8jOaJgOS7peebruWJjeWPquaUr+aMgSBXZWLjgIFpT1Mg5ZKMIEFuZHJvaWQg5bmz5Y+w44CCXG4gKiBAY2xhc3MgV2ViVmlld1xuICogQGV4dGVuZHMgQ29tcG9uZW50XG4gKi9cbmxldCBXZWJWaWV3ID0gY2MuQ2xhc3Moe1xuICAgIG5hbWU6ICdjYy5XZWJWaWV3JyxcbiAgICBleHRlbmRzOiBjYy5Db21wb25lbnQsXG5cbiAgICBlZGl0b3I6IENDX0VESVRPUiAmJiB7XG4gICAgICAgIG1lbnU6ICdpMThuOk1BSU5fTUVOVS5jb21wb25lbnQudWkvV2ViVmlldycsXG4gICAgICAgIGV4ZWN1dGVJbkVkaXRNb2RlOiB0cnVlXG4gICAgfSxcblxuICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgX3VzZU9yaWdpbmFsU2l6ZTogdHJ1ZSxcblxuICAgICAgICBfdXJsOiAnJyxcbiAgICAgICAgLyoqXG4gICAgICAgICAqICEjZW4gQSBnaXZlbiBVUkwgdG8gYmUgbG9hZGVkIGJ5IHRoZSBXZWJWaWV3LCBpdCBzaG91bGQgaGF2ZSBhIGh0dHAgb3IgaHR0cHMgcHJlZml4LlxuICAgICAgICAgKiAhI3poIOaMh+WumiBXZWJWaWV3IOWKoOi9veeahOe9keWdgO+8jOWug+W6lOivpeaYr+S4gOS4qiBodHRwIOaIluiAhSBodHRwcyDlvIDlpLTnmoTlrZfnrKbkuLJcbiAgICAgICAgICogQHByb3BlcnR5IHtTdHJpbmd9IHVybFxuICAgICAgICAgKi9cbiAgICAgICAgdXJsOiB7XG4gICAgICAgICAgICB0eXBlOiBjYy5TdHJpbmcsXG4gICAgICAgICAgICB0b29sdGlwOiBDQ19ERVYgJiYgJ2kxOG46Q09NUE9ORU5ULndlYnZpZXcudXJsJyxcbiAgICAgICAgICAgIGdldDogZnVuY3Rpb24gKCkge1xuICAgICAgICAgICAgICAgIHJldHVybiB0aGlzLl91cmw7XG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgc2V0OiBmdW5jdGlvbiAodXJsKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5fdXJsID0gdXJsO1xuICAgICAgICAgICAgICAgIGxldCBpbXBsID0gdGhpcy5faW1wbDtcbiAgICAgICAgICAgICAgICBpZiAoaW1wbCkge1xuICAgICAgICAgICAgICAgICAgICBpbXBsLmxvYWRVUkwodXJsKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgIH0sXG5cbiAgICAgICAgLyoqXG4gICAgICAgICAqICEjZW4gVGhlIHdlYnZpZXcncyBldmVudCBjYWxsYmFjayAsIGl0IHdpbGwgYmUgdHJpZ2dlcmVkIHdoZW4gY2VydGFpbiB3ZWJ2aWV3IGV2ZW50IG9jY3Vycy5cbiAgICAgICAgICogISN6aCBXZWJWaWV3IOeahOWbnuiwg+S6i+S7tu+8jOW9k+e9kemhteWKoOi9vei/h+eoi+S4re+8jOWKoOi9veWujOaIkOWQjuaIluiAheWKoOi9veWHuumUmeaXtumDveS8muWbnuiwg+atpOWHveaVsFxuICAgICAgICAgKiBAcHJvcGVydHkge0NvbXBvbmVudC5FdmVudEhhbmRsZXJbXX0gd2Vidmlld0xvYWRlZEV2ZW50c1xuICAgICAgICAgKi9cbiAgICAgICAgd2Vidmlld0V2ZW50czoge1xuICAgICAgICAgICAgZGVmYXVsdDogW10sXG4gICAgICAgICAgICB0eXBlOiBjYy5Db21wb25lbnQuRXZlbnRIYW5kbGVyLFxuICAgICAgICB9LFxuICAgIH0sXG5cbiAgICBzdGF0aWNzOiB7XG4gICAgICAgIEV2ZW50VHlwZTogRXZlbnRUeXBlLFxuICAgICAgICAvLyBJbXBsIHdpbGwgYmUgb3ZlcnJpZGVkIGluIHRoZSBkaWZmZXJlbnQgcGxhdGZvcm0uXG4gICAgICAgIEltcGw6IFdlYlZpZXdJbXBsXG4gICAgfSxcblxuICAgIGN0b3IgKCkge1xuICAgICAgICB0aGlzLl9pbXBsID0gbmV3IFdlYlZpZXcuSW1wbCgpO1xuICAgIH0sXG5cbiAgICBvblJlc3RvcmUgKCkge1xuICAgICAgICBpZiAoIXRoaXMuX2ltcGwpIHtcbiAgICAgICAgICAgIHRoaXMuX2ltcGwgPSBuZXcgV2ViVmlldy5JbXBsKCk7XG4gICAgICAgIH1cbiAgICB9LFxuXG4gICAgb25FbmFibGUgKCkge1xuICAgICAgICBsZXQgaW1wbCA9IHRoaXMuX2ltcGw7XG4gICAgICAgIGltcGwuY3JlYXRlRG9tRWxlbWVudElmTmVlZGVkKHRoaXMubm9kZS53aWR0aCwgdGhpcy5ub2RlLmhlaWdodCk7XG4gICAgICAgIGlmICghQ0NfRURJVE9SKSB7XG4gICAgICAgICAgICBpbXBsLnNldEV2ZW50TGlzdGVuZXIoRXZlbnRUeXBlLkxPQURFRCwgdGhpcy5fb25XZWJWaWV3TG9hZGVkLmJpbmQodGhpcykpO1xuICAgICAgICAgICAgaW1wbC5zZXRFdmVudExpc3RlbmVyKEV2ZW50VHlwZS5MT0FESU5HLCB0aGlzLl9vbldlYlZpZXdMb2FkaW5nLmJpbmQodGhpcykpO1xuICAgICAgICAgICAgaW1wbC5zZXRFdmVudExpc3RlbmVyKEV2ZW50VHlwZS5FUlJPUiwgdGhpcy5fb25XZWJWaWV3TG9hZEVycm9yLmJpbmQodGhpcykpO1xuICAgICAgICB9XG4gICAgICAgIGltcGwubG9hZFVSTCh0aGlzLl91cmwpO1xuICAgICAgICBpbXBsLnNldFZpc2libGUodHJ1ZSk7XG4gICAgfSxcblxuICAgIG9uRGlzYWJsZSAoKSB7XG4gICAgICAgIGxldCBpbXBsID0gdGhpcy5faW1wbDtcbiAgICAgICAgaW1wbC5zZXRWaXNpYmxlKGZhbHNlKTtcbiAgICAgICAgaWYgKCFDQ19FRElUT1IpIHtcbiAgICAgICAgICAgIGltcGwuc2V0RXZlbnRMaXN0ZW5lcihFdmVudFR5cGUuTE9BREVELCBlbXB0eUNhbGxiYWNrKTtcbiAgICAgICAgICAgIGltcGwuc2V0RXZlbnRMaXN0ZW5lcihFdmVudFR5cGUuTE9BRElORywgZW1wdHlDYWxsYmFjayk7XG4gICAgICAgICAgICBpbXBsLnNldEV2ZW50TGlzdGVuZXIoRXZlbnRUeXBlLkVSUk9SLCBlbXB0eUNhbGxiYWNrKTtcbiAgICAgICAgfVxuICAgIH0sXG5cbiAgICBvbkRlc3Ryb3kgKCkge1xuICAgICAgICBpZiAodGhpcy5faW1wbCkge1xuICAgICAgICAgICAgdGhpcy5faW1wbC5kZXN0cm95KCk7XG4gICAgICAgICAgICB0aGlzLl9pbXBsID0gbnVsbDtcbiAgICAgICAgfVxuICAgIH0sXG5cbiAgICB1cGRhdGUgKGR0KSB7XG4gICAgICAgIGlmICh0aGlzLl9pbXBsKSB7XG4gICAgICAgICAgICB0aGlzLl9pbXBsLnVwZGF0ZU1hdHJpeCh0aGlzLm5vZGUpO1xuICAgICAgICB9XG4gICAgfSxcblxuICAgIF9vbldlYlZpZXdMb2FkZWQgKCkge1xuICAgICAgICBjYy5Db21wb25lbnQuRXZlbnRIYW5kbGVyLmVtaXRFdmVudHModGhpcy53ZWJ2aWV3RXZlbnRzLCB0aGlzLCBFdmVudFR5cGUuTE9BREVEKTtcbiAgICAgICAgdGhpcy5ub2RlLmVtaXQoJ2xvYWRlZCcsIHRoaXMpO1xuICAgIH0sXG5cbiAgICBfb25XZWJWaWV3TG9hZGluZyAoKSB7XG4gICAgICAgIGNjLkNvbXBvbmVudC5FdmVudEhhbmRsZXIuZW1pdEV2ZW50cyh0aGlzLndlYnZpZXdFdmVudHMsIHRoaXMsIEV2ZW50VHlwZS5MT0FESU5HKTtcbiAgICAgICAgdGhpcy5ub2RlLmVtaXQoJ2xvYWRpbmcnLCB0aGlzKTtcbiAgICAgICAgcmV0dXJuIHRydWU7XG4gICAgfSxcblxuICAgIF9vbldlYlZpZXdMb2FkRXJyb3IgKCkge1xuICAgICAgICBjYy5Db21wb25lbnQuRXZlbnRIYW5kbGVyLmVtaXRFdmVudHModGhpcy53ZWJ2aWV3RXZlbnRzLCB0aGlzLCBFdmVudFR5cGUuRVJST1IpO1xuICAgICAgICB0aGlzLm5vZGUuZW1pdCgnZXJyb3InLCB0aGlzKTtcbiAgICB9LFxuXG4gICAgLyoqXG4gICAgICogISNlblxuICAgICAqIFNldCBqYXZhc2NyaXB0IGludGVyZmFjZSBzY2hlbWUgKHNlZSBhbHNvIHNldE9uSlNDYWxsYmFjaykuIDxici8+XG4gICAgICogTm90ZTogU3VwcG9ydHMgb25seSBvbiB0aGUgQW5kcm9pZCBhbmQgaU9TLiBGb3IgSFRNTDUsIHBsZWFzZSByZWZlciB0byB0aGUgb2ZmaWNpYWwgZG9jdW1lbnRhdGlvbi48YnIvPlxuICAgICAqIFBsZWFzZSByZWZlciB0byB0aGUgb2ZmaWNpYWwgZG9jdW1lbnRhdGlvbiBmb3IgbW9yZSBkZXRhaWxzLlxuICAgICAqICEjemhcbiAgICAgKiDorr7nva4gSmF2YVNjcmlwdCDmjqXlj6PmlrnmoYjvvIjkuI4gJ3NldE9uSlNDYWxsYmFjaycg6YWN5aWX5L2/55So77yJ44CCPGJyLz5cbiAgICAgKiDms6jmhI/vvJrlj6rmlK/mjIEgQW5kcm9pZCDlkowgaU9TIO+8jFdlYiDnq6/nlKjms5Xor7fliY3lvoDlrpjmlrnmlofmoaPmn6XnnIvjgII8YnIvPlxuICAgICAqIOivpuaDheivt+WPgumYheWumOaWueaWh+aho1xuICAgICAqIEBtZXRob2Qgc2V0SmF2YXNjcmlwdEludGVyZmFjZVNjaGVtZVxuICAgICAqIEBwYXJhbSB7U3RyaW5nfSBzY2hlbWVcbiAgICAgKi9cbiAgICBzZXRKYXZhc2NyaXB0SW50ZXJmYWNlU2NoZW1lIChzY2hlbWUpIHtcbiAgICAgICAgaWYgKHRoaXMuX2ltcGwpIHtcbiAgICAgICAgICAgIHRoaXMuX2ltcGwuc2V0SmF2YXNjcmlwdEludGVyZmFjZVNjaGVtZShzY2hlbWUpO1xuICAgICAgICB9XG4gICAgfSxcblxuICAgIC8qKlxuICAgICAqICEjZW5cbiAgICAgKiBUaGlzIGNhbGxiYWNrIGNhbGxlZCB3aGVuIGxvYWQgVVJMIHRoYXQgc3RhcnQgd2l0aCBqYXZhc2NyaXB0XG4gICAgICogaW50ZXJmYWNlIHNjaGVtZSAoc2VlIGFsc28gc2V0SmF2YXNjcmlwdEludGVyZmFjZVNjaGVtZSkuIDxici8+XG4gICAgICogTm90ZTogU3VwcG9ydHMgb25seSBvbiB0aGUgQW5kcm9pZCBhbmQgaU9TLiBGb3IgSFRNTDUsIHBsZWFzZSByZWZlciB0byB0aGUgb2ZmaWNpYWwgZG9jdW1lbnRhdGlvbi48YnIvPlxuICAgICAqIFBsZWFzZSByZWZlciB0byB0aGUgb2ZmaWNpYWwgZG9jdW1lbnRhdGlvbiBmb3IgbW9yZSBkZXRhaWxzLlxuICAgICAqICEjemhcbiAgICAgKiDlvZPliqDovb0gVVJMIOS7pSBKYXZhU2NyaXB0IOaOpeWPo+aWueahiOW8gOWni+aXtuiwg+eUqOi/meS4quWbnuiwg+WHveaVsOOAgjxici8+XG4gICAgICog5rOo5oSP77ya5Y+q5pSv5oyBIEFuZHJvaWQg5ZKMIGlPU++8jFdlYiDnq6/nlKjms5Xor7fliY3lvoDlrpjmlrnmlofmoaPmn6XnnIvjgIJcbiAgICAgKiDor6bmg4Xor7flj4LpmIXlrpjmlrnmlofmoaNcbiAgICAgKiBAbWV0aG9kIHNldE9uSlNDYWxsYmFja1xuICAgICAqIEBwYXJhbSB7RnVuY3Rpb259IGNhbGxiYWNrXG4gICAgICovXG4gICAgc2V0T25KU0NhbGxiYWNrIChjYWxsYmFjaykge1xuICAgICAgICBpZiAodGhpcy5faW1wbCkge1xuICAgICAgICAgICAgdGhpcy5faW1wbC5zZXRPbkpTQ2FsbGJhY2soY2FsbGJhY2spO1xuICAgICAgICB9XG4gICAgfSxcblxuICAgIC8qKlxuICAgICAqICEjZW5cbiAgICAgKiBFdmFsdWF0ZXMgSmF2YVNjcmlwdCBpbiB0aGUgY29udGV4dCBvZiB0aGUgY3VycmVudGx5IGRpc3BsYXllZCBwYWdlLiA8YnIvPlxuICAgICAqIFBsZWFzZSByZWZlciB0byB0aGUgb2ZmaWNpYWwgZG9jdW1lbnQgZm9yIG1vcmUgZGV0YWlscyA8YnIvPlxuICAgICAqIE5vdGU6IENyb3NzIGRvbWFpbiBpc3N1ZXMgbmVlZCB0byBiZSByZXNvbHZlZCBieSB5b3Vyc2VsZiA8YnIvPlxuICAgICAqICEjemhcbiAgICAgKiDmiafooYwgV2ViVmlldyDlhoXpg6jpobXpnaLohJrmnKzvvIjor6bmg4Xor7flj4LpmIXlrpjmlrnmlofmoaPvvIkgPGJyLz5cbiAgICAgKiDms6jmhI/vvJrpnIDopoHoh6rooYzop6PlhrPot6jln5/pl67pophcbiAgICAgKiBAbWV0aG9kIGV2YWx1YXRlSlNcbiAgICAgKiBAcGFyYW0ge1N0cmluZ30gc3RyXG4gICAgICovXG4gICAgZXZhbHVhdGVKUyAoc3RyKSB7XG4gICAgICAgIGlmICh0aGlzLl9pbXBsKSB7XG4gICAgICAgICAgICB0aGlzLl9pbXBsLmV2YWx1YXRlSlMoc3RyKTtcbiAgICAgICAgfVxuICAgIH0sXG5cbn0pO1xuXG5jYy5XZWJWaWV3ID0gbW9kdWxlLmV4cG9ydHMgPSBXZWJWaWV3O1xuLyoqXG4gKiAhI2VuXG4gKiBOb3RlOiBUaGlzIGV2ZW50IGlzIGVtaXR0ZWQgZnJvbSB0aGUgbm9kZSB0byB3aGljaCB0aGUgY29tcG9uZW50IGJlbG9uZ3MuXG4gKiAhI3poXG4gKiDms6jmhI/vvJrmraTkuovku7bmmK/ku47or6Xnu4Tku7bmiYDlsZ7nmoQgTm9kZSDkuIrpnaLmtL7lj5Hlh7rmnaXnmoTvvIzpnIDopoHnlKggbm9kZS5vbiDmnaXnm5HlkKzjgIJcbiAqIEBldmVudCBsb2FkZWRcbiAqIEBwYXJhbSB7RXZlbnQuRXZlbnRDdXN0b219IGV2ZW50XG4gKiBAcGFyYW0ge1dlYlZpZXd9IHdlYlZpZXcgLSBUaGUgV2ViVmlldyBjb21wb25lbnQuXG4gKi9cblxuLyoqXG4gKiAhI2VuXG4gKiBOb3RlOiBUaGlzIGV2ZW50IGlzIGVtaXR0ZWQgZnJvbSB0aGUgbm9kZSB0byB3aGljaCB0aGUgY29tcG9uZW50IGJlbG9uZ3MuXG4gKiAhI3poXG4gKiDms6jmhI/vvJrmraTkuovku7bmmK/ku47or6Xnu4Tku7bmiYDlsZ7nmoQgTm9kZSDkuIrpnaLmtL7lj5Hlh7rmnaXnmoTvvIzpnIDopoHnlKggbm9kZS5vbiDmnaXnm5HlkKzjgIJcbiAqIEBldmVudCBsb2FkaW5nXG4gKiBAcGFyYW0ge0V2ZW50LkV2ZW50Q3VzdG9tfSBldmVudFxuICogQHBhcmFtIHtXZWJWaWV3fSB3ZWJWaWV3IC0gVGhlIFdlYlZpZXcgY29tcG9uZW50LlxuICovXG5cbi8qKlxuICogISNlblxuICogTm90ZTogVGhpcyBldmVudCBpcyBlbWl0dGVkIGZyb20gdGhlIG5vZGUgdG8gd2hpY2ggdGhlIGNvbXBvbmVudCBiZWxvbmdzLlxuICogISN6aFxuICog5rOo5oSP77ya5q2k5LqL5Lu25piv5LuO6K+l57uE5Lu25omA5bGe55qEIE5vZGUg5LiK6Z2i5rS+5Y+R5Ye65p2l55qE77yM6ZyA6KaB55SoIG5vZGUub24g5p2l55uR5ZCs44CCXG4gKiBAZXZlbnQgZXJyb3JcbiAqIEBwYXJhbSB7RXZlbnQuRXZlbnRDdXN0b219IGV2ZW50XG4gKiBAcGFyYW0ge1dlYlZpZXd9IHdlYlZpZXcgLSBUaGUgV2ViVmlldyBjb21wb25lbnQuXG4gKi9cblxuLyoqXG4gKiAhI2VuIGlmIHlvdSBkb24ndCBuZWVkIHRoZSBXZWJWaWV3IGFuZCBpdCBpc24ndCBpbiBhbnkgcnVubmluZyBTY2VuZSwgeW91IHNob3VsZFxuICogY2FsbCB0aGUgZGVzdHJveSBtZXRob2Qgb24gdGhpcyBjb21wb25lbnQgb3IgdGhlIGFzc29jaWF0ZWQgbm9kZSBleHBsaWNpdGx5LlxuICogT3RoZXJ3aXNlLCB0aGUgY3JlYXRlZCBET00gZWxlbWVudCB3b24ndCBiZSByZW1vdmVkIGZyb20gd2ViIHBhZ2UuXG4gKiAhI3poXG4gKiDlpoLmnpzkvaDkuI3lho3kvb/nlKggV2ViVmlld++8jOW5tuS4lOe7hOS7tuacqua3u+WKoOWIsOWcuuaZr+S4re+8jOmCo+S5iOS9oOW/hemhu+aJi+WKqOWvuee7hOS7tuaIluaJgOWcqOiKgueCueiwg+eUqCBkZXN0cm9544CCXG4gKiDov5nmoLfmiY3og73np7vpmaTnvZHpobXkuIrnmoQgRE9NIOiKgueCue+8jOmBv+WFjSBXZWIg5bmz5Y+w5YaF5a2Y5rOE6Zyy44CCXG4gKiBAZXhhbXBsZVxuICogd2Vidmlldy5ub2RlLnBhcmVudCA9IG51bGw7ICAvLyBvciAgd2Vidmlldy5ub2RlLnJlbW92ZUZyb21QYXJlbnQoZmFsc2UpO1xuICogLy8gd2hlbiB5b3UgZG9uJ3QgbmVlZCB3ZWJ2aWV3IGFueW1vcmVcbiAqIHdlYnZpZXcubm9kZS5kZXN0cm95KCk7XG4gKiBAbWV0aG9kIGRlc3Ryb3lcbiAqIEByZXR1cm4ge0Jvb2xlYW59IHdoZXRoZXIgaXQgaXMgdGhlIGZpcnN0IHRpbWUgdGhlIGRlc3Ryb3kgYmVpbmcgY2FsbGVkXG4gKi9cbiJdLCJzb3VyY2VSb290IjoiLyJ9
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/components/CCStudioComponent.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var ComponentType = cc.Enum({
  NONE: 0,
  CHECKBOX: 1,
  TEXT_ATLAS: 2,
  SLIDER_BAR: 3,
  LIST_VIEW: 4,
  PAGE_VIEW: 5
});
var ListDirection = cc.Enum({
  VERTICAL: 0,
  HORIZONTAL: 1
});
var VerticalAlign = cc.Enum({
  TOP: 0,
  CENTER: 1,
  BOTTOM: 2
});
var HorizontalAlign = cc.Enum({
  LEFT: 0,
  CENTER: 1,
  RIGHT: 2
});
var StudioComponent = cc.Class({
  name: 'cc.StudioComponent',
  "extends": cc.Component,
  editor: CC_EDITOR && {
    inspector: 'unpack://engine-dev/extensions/cocostudio/editor/studio-component.js'
  },
  properties: CC_EDITOR && {
    _type: ComponentType.NONE,
    type: {
      get: function get() {
        return this._type;
      },
      set: function set(value) {
        this._type = value;
      },
      readonly: true,
      type: ComponentType
    },
    // props for checkbox
    _checkNormalBackFrame: null,
    checkNormalBackFrame: {
      get: function get() {
        return this._checkNormalBackFrame;
      },
      set: function set(value) {
        this._checkNormalBackFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    _checkPressedBackFrame: null,
    checkPressedBackFrame: {
      get: function get() {
        return this._checkPressedBackFrame;
      },
      set: function set(value) {
        this._checkPressedBackFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    _checkDisableBackFrame: null,
    checkDisableBackFrame: {
      get: function get() {
        return this._checkDisableBackFrame;
      },
      set: function set(value) {
        this._checkDisableBackFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    _checkNormalFrame: null,
    checkNormalFrame: {
      get: function get() {
        return this._checkNormalFrame;
      },
      set: function set(value) {
        this._checkNormalFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    _checkDisableFrame: null,
    checkDisableFrame: {
      get: function get() {
        return this._checkDisableFrame;
      },
      set: function set(value) {
        this._checkDisableFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    checkInteractable: {
      readonly: true,
      "default": true
    },
    isChecked: {
      readonly: true,
      "default": true
    },
    // props for TextAtlas
    _atlasFrame: null,
    atlasFrame: {
      get: function get() {
        return this._atlasFrame;
      },
      set: function set(value) {
        this._atlasFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    firstChar: {
      readonly: true,
      "default": '.'
    },
    charWidth: {
      readonly: true,
      "default": 0
    },
    charHeight: {
      readonly: true,
      "default": 0
    },
    string: {
      readonly: true,
      "default": ''
    },
    // props for SliderBar
    _sliderBackFrame: null,
    sliderBackFrame: {
      get: function get() {
        return this._sliderBackFrame;
      },
      set: function set(value) {
        this._sliderBackFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    _sliderBarFrame: null,
    sliderBarFrame: {
      get: function get() {
        return this._sliderBarFrame;
      },
      set: function set(value) {
        this._sliderBarFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    _sliderBtnNormalFrame: null,
    sliderBtnNormalFrame: {
      get: function get() {
        return this._sliderBtnNormalFrame;
      },
      set: function set(value) {
        this._sliderBtnNormalFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    _sliderBtnPressedFrame: null,
    sliderBtnPressedFrame: {
      get: function get() {
        return this._sliderBtnPressedFrame;
      },
      set: function set(value) {
        this._sliderBtnPressedFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    _sliderBtnDisabledFrame: null,
    sliderBtnDisabledFrame: {
      get: function get() {
        return this._sliderBtnDisabledFrame;
      },
      set: function set(value) {
        this._sliderBtnDisabledFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    sliderInteractable: {
      readonly: true,
      "default": true
    },
    sliderProgress: {
      "default": 0.5,
      readonly: true,
      type: cc.Float,
      range: [0, 1, 0.1]
    },
    // props for ListView
    listInertia: {
      readonly: true,
      "default": true,
      animatable: false,
      tooltip: CC_DEV && 'i18n:COMPONENT.scrollview.inertia'
    },
    listDirection: {
      readonly: true,
      "default": ListDirection.VERTICAL,
      type: ListDirection
    },
    listHorizontalAlign: {
      readonly: true,
      "default": HorizontalAlign.LEFT,
      type: HorizontalAlign
    },
    listVerticalAlign: {
      readonly: true,
      "default": VerticalAlign.TOP,
      type: VerticalAlign
    },
    listPadding: {
      readonly: true,
      "default": 0
    }
  },
  statics: {
    ComponentType: ComponentType,
    ListDirection: ListDirection,
    VerticalAlign: VerticalAlign,
    HorizontalAlign: HorizontalAlign
  }
});

var PrefabHelper = require('../utils/prefab-helper');

StudioComponent.PlaceHolder = cc.Class({
  name: 'cc.StudioComponent.PlaceHolder',
  "extends": cc.Component,
  properties: {
    _baseUrl: '',
    nestedPrefab: cc.Prefab
  },
  onLoad: function onLoad() {
    if (!this.nestedPrefab) {
      if (CC_DEV) {
        cc.warn('Unable to find %s resource.', this._baseUrl);
      }

      return;
    }

    this._replaceWithNestedPrefab();
  },
  _replaceWithNestedPrefab: function _replaceWithNestedPrefab() {
    var node = this.node;
    var _prefab = node._prefab;
    _prefab.root = node;
    _prefab.asset = this.nestedPrefab;
    PrefabHelper.syncWithPrefab(node);
  }
});
cc.StudioComponent = module.exports = StudioComponent;
var StudioWidget = cc.Class({
  name: 'cc.StudioWidget',
  "extends": cc.Widget,
  editor: CC_EDITOR && {
    inspector: 'packages://inspector/inspectors/comps/ccwidget.js'
  },
  _validateTargetInDEV: function _validateTargetInDEV() {}
});
cc.StudioWidget = module.exports = StudioWidget;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/deprecated.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var js = cc.js;

if (CC_DEBUG) {
  var deprecateEnum = function deprecateEnum(obj, oldPath, newPath, hasTypePrefixBefore) {
    if (!CC_SUPPORT_JIT) {
      return;
    }

    hasTypePrefixBefore = hasTypePrefixBefore !== false;
    var enumDef = Function('return ' + newPath)();
    var entries = cc.Enum.getList(enumDef);
    var delimiter = hasTypePrefixBefore ? '_' : '.';

    for (var i = 0; i < entries.length; i++) {
      var entry = entries[i].name;
      var oldPropName;

      if (hasTypePrefixBefore) {
        var oldTypeName = oldPath.split('.').slice(-1)[0];
        oldPropName = oldTypeName + '_' + entry;
      } else {
        oldPropName = entry;
      }

      js.get(obj, oldPropName, function (entry) {
        cc.errorID(1400, oldPath + delimiter + entry, newPath + '.' + entry);
        return enumDef[entry];
      }.bind(null, entry));
    }
  };

  var markAsRemoved = function markAsRemoved(ownerCtor, removedProps, ownerName) {
    if (!ownerCtor) {
      // 可能被裁剪了
      return;
    }

    ownerName = ownerName || js.getClassName(ownerCtor);
    removedProps.forEach(function (prop) {
      function error() {
        cc.errorID(1406, ownerName, prop);
      }

      js.getset(ownerCtor.prototype, prop, error, error);
    });
  };

  var markAsDeprecated = function markAsDeprecated(ownerCtor, deprecatedProps, ownerName) {
    if (!ownerCtor) {
      return;
    }

    ownerName = ownerName || js.getClassName(ownerCtor);
    var descriptors = Object.getOwnPropertyDescriptors(ownerCtor.prototype);
    deprecatedProps.forEach(function (prop) {
      var deprecatedProp = prop[0];
      var newProp = prop[1];
      var descriptor = descriptors[deprecatedProp];
      js.getset(ownerCtor.prototype, deprecatedProp, function () {
        cc.warnID(1400, ownerName + "." + deprecatedProp, ownerName + "." + newProp);
        return descriptor.get.call(this);
      }, function (v) {
        cc.warnID(1400, ownerName + "." + deprecatedProp, ownerName + "." + newProp);
        descriptor.set.call(this, v);
      });
    });
  };

  var markAsRemovedInObject = function markAsRemovedInObject(ownerObj, removedProps, ownerName) {
    if (!ownerObj) {
      // 可能被裁剪了
      return;
    }

    removedProps.forEach(function (prop) {
      function error() {
        cc.errorID(1406, ownerName, prop);
      }

      js.getset(ownerObj, prop, error);
    });
  };

  var provideClearError = function provideClearError(owner, obj, ownerName) {
    if (!owner) {
      // 可能被裁剪了
      return;
    }

    var className = ownerName || cc.js.getClassName(owner);
    var Info = 'Sorry, ' + className + '.%s is removed, please use %s instead.';

    var _loop = function _loop() {
      function define(prop, getset) {
        function accessor(newProp) {
          cc.error(Info, prop, newProp);
        }

        if (!Array.isArray(getset)) {
          getset = getset.split(',').map(function (x) {
            return x.trim();
          });
        }

        try {
          js.getset(owner, prop, accessor.bind(null, getset[0]), getset[1] && accessor.bind(null, getset[1]));
        } catch (e) {}
      }

      getset = obj[prop];

      if (prop[0] === '*') {
        // get set
        etProp = prop.slice(1);
        define('g' + etProp, getset);
        define('s' + etProp, getset);
      } else {
        prop.split(',').map(function (x) {
          return x.trim();
        }).forEach(function (x) {
          define(x, getset);
        });
      }
    };

    for (var prop in obj) {
      var getset;
      var etProp;

      _loop();
    }
  };

  var markFunctionWarning = function markFunctionWarning(ownerCtor, obj, ownerName) {
    if (!ownerCtor) {
      // 可能被裁剪了
      return;
    }

    ownerName = ownerName || js.getClassName(ownerCtor);

    for (var prop in obj) {
      (function () {
        var propName = prop;
        var originFunc = ownerCtor[propName];
        if (!originFunc) return;

        function warn() {
          cc.warn('Sorry, %s.%s is deprecated. Please use %s instead', ownerName, propName, obj[propName]);
          return originFunc.apply(this, arguments);
        }

        ownerCtor[propName] = warn;
      })();
    }
  }; // remove cc.info


  js.get(cc, 'info', function () {
    cc.errorID(1400, 'cc.info', 'cc.log');
    return cc.log;
  }); // cc.spriteFrameCache

  js.get(cc, "spriteFrameCache", function () {
    cc.errorID(1404);
  }); // cc.vmath

  js.get(cc, 'vmath', function () {
    cc.warnID(1400, 'cc.vmath', 'cc.math');
    return cc.math;
  });
  js.get(cc.math, 'vec2', function () {
    cc.warnID(1400, 'cc.vmath.vec2', 'cc.Vec2');
    return cc.Vec2;
  });
  js.get(cc.math, 'vec3', function () {
    cc.warnID(1400, 'cc.vmath.vec3', 'cc.Vec3');
    return cc.Vec3;
  });
  js.get(cc.math, 'vec4', function () {
    cc.warnID(1400, 'cc.vmath.vec4', 'cc.Vec4');
    return cc.Vec4;
  });
  js.get(cc.math, 'mat4', function () {
    cc.warnID(1400, 'cc.vmath.mat4', 'cc.Mat4');
    return cc.Mat4;
  });
  js.get(cc.math, 'mat3', function () {
    cc.warnID(1400, 'cc.vmath.mat3', 'cc.Mat3');
    return cc.Mat3;
  });
  js.get(cc.math, 'quat', function () {
    cc.warnID(1400, 'cc.vmath.quat', 'cc.Quat');
    return cc.Quat;
  }); // SpriteFrame

  js.get(cc.SpriteFrame.prototype, '_textureLoaded', function () {
    cc.errorID(1400, 'spriteFrame._textureLoaded', 'spriteFrame.textureLoaded()');
    return this.textureLoaded();
  });
  markAsRemoved(cc.SpriteFrame, ['addLoadedEventListener']);
  markFunctionWarning(cc.Sprite.prototype, {
    setState: 'cc.Sprite.setMaterial',
    getState: 'cc.Sprite.getMaterial'
  }, 'cc.Sprite');
  js.get(cc.SpriteFrame.prototype, 'clearTexture', function () {
    cc.errorID(1406, 'cc.SpriteFrame', 'clearTexture');
    return function () {};
  }); // cc.textureCache

  js.get(cc, 'textureCache', function () {
    cc.errorID(1406, 'cc', 'textureCache');
  }); // Texture

  var Texture2D = cc.Texture2D;
  js.get(Texture2D.prototype, 'releaseTexture', function () {
    cc.errorID(1400, 'texture.releaseTexture()', 'texture.destroy()');
    return this.destroy;
  });
  js.get(Texture2D.prototype, 'getName', function () {
    cc.errorID(1400, 'texture.getName()', 'texture._glID');
    return function () {
      return this._glID || null;
    };
  });
  js.get(Texture2D.prototype, 'isLoaded', function () {
    cc.errorID(1400, 'texture.isLoaded function', 'texture.loaded property');
    return function () {
      return this.loaded;
    };
  });
  js.get(Texture2D.prototype, 'setAntiAliasTexParameters', function () {
    cc.errorID(1400, 'texture.setAntiAliasTexParameters()', 'texture.setFilters(cc.Texture2D.Filter.LINEAR, cc.Texture2D.Filter.LINEAR)');
    return function () {
      this.setFilters(Texture2D.Filter.LINEAR, Texture2D.Filter.LINEAR);
    };
  });
  js.get(Texture2D.prototype, 'setAliasTexParameters', function () {
    cc.errorID(1400, 'texture.setAntiAliasTexParameters()', 'texture.setFilters(cc.Texture2D.Filter.NEAREST, cc.Texture2D.Filter.NEAREST)');
    return function () {
      this.setFilters(Texture2D.Filter.NEAREST, Texture2D.Filter.NEAREST);
    };
  }); // cc.macro

  markAsRemovedInObject(cc.macro, ['ENABLE_GL_STATE_CACHE', 'FIX_ARTIFACTS_BY_STRECHING_TEXEL'], 'cc.macro');
  provideClearError(cc.macro, {
    PI: 'Math.PI',
    PI2: 'Math.PI * 2',
    FLT_MAX: 'Number.MAX_VALUE',
    FLT_MIN: 'Number.MIN_VALUE',
    UINT_MAX: 'Number.MAX_SAFE_INTEGER'
  }, 'cc.macro'); // cc.game

  markAsRemovedInObject(cc.game, ['CONFIG_KEY'], 'cc.game'); // cc.sys

  markAsRemovedInObject(cc.sys, ['dumpRoot', 'cleanScript'], 'cc.sys'); // cc.Director

  provideClearError(cc.Director, {
    EVENT_PROJECTION_CHANGED: '',
    EVENT_BEFORE_VISIT: 'EVENT_AFTER_UPDATE',
    EVENT_AFTER_VISIT: 'EVENT_BEFORE_DRAW'
  }, 'cc.Director');
  markFunctionWarning(cc.Director.prototype, {
    convertToGL: 'cc.view.convertToLocationInView',
    convertToUI: '',
    getWinSize: 'cc.winSize',
    getWinSizeInPixels: 'cc.winSize',
    getVisibleSize: 'cc.view.getVisibleSize',
    getVisibleOrigin: 'cc.view.getVisibleOrigin',
    purgeCachedData: 'cc.loader.releaseAll',
    setDepthTest: 'cc.Camera.main.depth',
    setClearColor: 'cc.Camera.main.backgroundColor',
    getRunningScene: 'cc.director.getScene',
    getAnimationInterval: 'cc.game.getFrameRate',
    setAnimationInterval: 'cc.game.setFrameRate',
    isDisplayStats: 'cc.debug.isDisplayStats',
    setDisplayStats: 'cc.debug.setDisplayStats',
    stopAnimation: 'cc.game.pause',
    startAnimation: 'cc.game.resume'
  }, 'cc.Director');
  markAsRemoved(cc.Director, ['pushScene', 'popScene', 'popToRootScene', 'popToSceneStackLevel', 'setProjection', 'getProjection'], 'cc.Director'); // Scheduler

  provideClearError(cc.Scheduler, {
    scheduleCallbackForTarget: 'schedule',
    scheduleUpdateForTarget: 'scheduleUpdate',
    unscheduleCallbackForTarget: 'unschedule',
    unscheduleUpdateForTarget: 'unscheduleUpdate',
    unscheduleAllCallbacksForTarget: 'unscheduleAllForTarget',
    unscheduleAllCallbacks: 'unscheduleAll',
    unscheduleAllCallbacksWithMinPriority: 'unscheduleAllWithMinPriority'
  }, 'cc.Scheduler'); // cc.view

  provideClearError(cc.view, {
    adjustViewPort: 'adjustViewportMeta',
    setViewPortInPoints: 'setViewportInPoints',
    getViewPortRect: 'getViewportRect'
  }, 'cc.view');
  markAsRemovedInObject(cc.view, ['isViewReady', 'setTargetDensityDPI', 'getTargetDensityDPI', 'setFrameZoomFactor', 'canSetContentScaleFactor', 'setContentTranslateLeftTop', 'getContentTranslateLeftTop', 'setViewName', 'getViewName'], 'cc.view'); // Loader

  markAsRemoved(cc.Pipeline, ['flowInDeps', 'getItems'], 'cc.loader'); // cc.PhysicsManager

  markAsRemoved(cc.PhysicsManager, ['attachDebugDrawToCamera', 'detachDebugDrawFromCamera']); // cc.CollisionManager

  markAsRemoved(cc.CollisionManager, ['attachDebugDrawToCamera', 'detachDebugDrawFromCamera']); // cc.Node

  provideClearError(cc._BaseNode.prototype, {
    'tag': 'name',
    'getTag': 'name',
    'setTag': 'name',
    'getChildByTag': 'getChildByName',
    'removeChildByTag': 'getChildByName(name).destroy()'
  });
  markAsRemoved(cc.Node, ['_cascadeColorEnabled', 'cascadeColor', 'isCascadeColorEnabled', 'setCascadeColorEnabled', '_cascadeOpacityEnabled', 'cascadeOpacity', 'isCascadeOpacityEnabled', 'setCascadeOpacityEnabled', 'opacityModifyRGB', 'isOpacityModifyRGB', 'setOpacityModifyRGB', 'ignoreAnchor', 'isIgnoreAnchorPointForPosition', 'ignoreAnchorPointForPosition', 'isRunning', '_sgNode']);
  markFunctionWarning(cc.Node.prototype, {
    getNodeToParentTransform: 'getLocalMatrix',
    getNodeToParentTransformAR: 'getLocalMatrix',
    getNodeToWorldTransform: 'getWorldMatrix',
    getNodeToWorldTransformAR: 'getWorldMatrix',
    getParentToNodeTransform: 'getLocalMatrix',
    getWorldToNodeTransform: 'getWorldMatrix',
    convertTouchToNodeSpace: 'convertToNodeSpaceAR',
    convertTouchToNodeSpaceAR: 'convertToNodeSpaceAR',
    convertToWorldSpace: 'convertToWorldSpaceAR',
    convertToNodeSpace: 'convertToNodeSpaceAR'
  });
  provideClearError(cc.Node.prototype, {
    getRotationX: 'rotationX',
    setRotationX: 'rotationX',
    getRotationY: 'rotationY',
    setRotationY: 'rotationY',
    getPositionX: 'x',
    setPositionX: 'x',
    getPositionY: 'y',
    setPositionY: 'y',
    getSkewX: 'skewX',
    setSkewX: 'skewX',
    getSkewY: 'skewY',
    setSkewY: 'skewY',
    getScaleX: 'scaleX',
    setScaleX: 'scaleX',
    getScaleY: 'scaleY',
    setScaleY: 'scaleY',
    getOpacity: 'opacity',
    setOpacity: 'opacity',
    getColor: 'color',
    setColor: 'color',
    getLocalZOrder: 'zIndex',
    setLocalZOrder: 'zIndex'
  });
  provideClearError(cc.Sprite.prototype, {
    setInsetLeft: 'cc.SpriteFrame insetLeft',
    setInsetRight: 'cc.SpriteFrame insetRight',
    setInsetTop: 'cc.SpriteFrame insetTop',
    setInsetBottom: 'cc.SpriteFrame insetBottom'
  }); // cc.Material

  cc.Material.getInstantiatedBuiltinMaterial = cc.MaterialVariant.createWithBuiltin;
  cc.Material.getInstantiatedMaterial = cc.MaterialVariant.create;
  markFunctionWarning(cc.Material, {
    getInstantiatedBuiltinMaterial: 'cc.MaterialVariant.createWithBuiltin',
    getInstantiatedMaterial: 'cc.MaterialVariant.create'
  }); // cc.RenderComponent

  cc.js.getset(cc.RenderComponent.prototype, 'sharedMaterials', function () {
    cc.warnID(1400, 'sharedMaterials', 'getMaterials');
    return this.materials;
  }, function (v) {
    cc.warnID(1400, 'sharedMaterials', 'setMaterial');
    this.materials = v;
  }); // cc.Camera

  markFunctionWarning(cc.Camera.prototype, {
    getNodeToCameraTransform: 'getWorldToScreenMatrix2D',
    getCameraToWorldPoint: 'getScreenToWorldPoint',
    getWorldToCameraPoint: 'getWorldToScreenPoint',
    getCameraToWorldMatrix: 'getScreenToWorldMatrix2D',
    getWorldToCameraMatrix: 'getWorldToScreenMatrix2D'
  });
  markAsRemoved(cc.Camera, ['addTarget', 'removeTarget', 'getTargets']); // SCENE

  var ERR = '"%s" is not defined in the Scene, it is only defined in normal nodes.';
  CC_EDITOR || Object.defineProperties(cc.Scene.prototype, {
    active: {
      get: function get() {
        cc.error(ERR, 'active');
        return true;
      },
      set: function set() {
        cc.error(ERR, 'active');
      }
    },
    activeInHierarchy: {
      get: function get() {
        cc.error(ERR, 'activeInHierarchy');
        return true;
      }
    },
    getComponent: {
      get: function get() {
        cc.error(ERR, 'getComponent');
        return function () {
          return null;
        };
      }
    },
    addComponent: {
      get: function get() {
        cc.error(ERR, 'addComponent');
        return function () {
          return null;
        };
      }
    }
  }); // cc.dynamicAtlasManager

  markAsRemovedInObject(cc.dynamicAtlasManager, ['minFrameSize'], 'cc.dynamicAtlasManager'); // light component

  if (cc.Light) {
    markAsRemovedInObject(cc.Light.prototype, ['shadowDepthScale'], 'cc.Light.prototype');
  } // Value types


  provideClearError(cc, {
    // AffineTransform
    affineTransformMake: 'cc.AffineTransform.create',
    affineTransformMakeIdentity: 'cc.AffineTransform.identity',
    affineTransformClone: 'cc.AffineTransform.clone',
    affineTransformConcat: 'cc.AffineTransform.concat',
    affineTransformConcatIn: 'cc.AffineTransform.concat',
    affineTransformInvert: 'cc.AffineTransform.invert',
    affineTransformInvertIn: 'cc.AffineTransform.invert',
    affineTransformInvertOut: 'cc.AffineTransform.invert',
    affineTransformEqualToTransform: 'cc.AffineTransform.equal',
    pointApplyAffineTransform: 'cc.AffineTransform.transformVec2',
    sizeApplyAffineTransform: 'cc.AffineTransform.transformSize',
    rectApplyAffineTransform: 'cc.AffineTransform.transformRect',
    obbApplyAffineTransform: 'cc.AffineTransform.transformObb',
    // Vec2
    pointEqualToPoint: 'cc.Vec2 equals',
    // Size
    sizeEqualToSize: 'cc.Size equals',
    // Rect
    rectEqualToRect: 'rectA.equals(rectB)',
    rectContainsRect: 'rectA.containsRect(rectB)',
    rectContainsPoint: 'rect.contains(vec2)',
    rectOverlapsRect: 'rectA.intersects(rectB)',
    rectIntersectsRect: 'rectA.intersects(rectB)',
    rectIntersection: 'rectA.intersection(intersection, rectB)',
    rectUnion: 'rectA.union(union, rectB)',
    rectGetMaxX: 'rect.xMax',
    rectGetMidX: 'rect.center.x',
    rectGetMinX: 'rect.xMin',
    rectGetMaxY: 'rect.yMax',
    rectGetMidY: 'rect.center.y',
    rectGetMinY: 'rect.yMin',
    // Color
    colorEqual: 'colorA.equals(colorB)',
    hexToColor: 'color.fromHEX(hexColor)',
    colorToHex: 'color.toHEX()',
    // Enums
    TextAlignment: 'cc.macro.TextAlignment',
    VerticalTextAlignment: 'cc.macro.VerticalTextAlignment',
    // Point Extensions
    pNeg: 'p.neg()',
    pAdd: 'p1.add(p2)',
    pSub: 'p1.sub(p2)',
    pMult: 'p.mul(factor)',
    pMidpoint: 'p1.add(p2).mul(0.5)',
    pDot: 'p1.dot(p2)',
    pCross: 'p1.cross(p2)',
    pPerp: 'p.rotate(-90 * Math.PI / 180)',
    pRPerp: 'p.rotate(90 * Math.PI / 180)',
    pProject: 'p1.project(p2)',
    pLengthSQ: 'p.magSqr()',
    pDistanceSQ: 'p1.sub(p2).magSqr()',
    pLength: 'p.mag()',
    pDistance: 'p1.sub(p2).mag()',
    pNormalize: 'p.normalize()',
    pForAngle: 'cc.v2(Math.cos(a), Math.sin(a))',
    pToAngle: 'Math.atan2(v.y, v.x)',
    pZeroIn: 'p.x = p.y = 0',
    pIn: 'p1.set(p2)',
    pMultIn: 'p.mulSelf(factor)',
    pSubIn: 'p1.subSelf(p2)',
    pAddIn: 'p1.addSelf(p2)',
    pNormalizeIn: 'p.normalizeSelf()',
    pSameAs: 'p1.equals(p2)',
    pAngle: 'v1.angle(v2)',
    pAngleSigned: 'v1.signAngle(v2)',
    pRotateByAngle: 'p.rotate(radians)',
    pCompMult: 'v1.dot(v2)',
    pFuzzyEqual: 'v1.fuzzyEquals(v2, tolerance)',
    pLerp: 'p.lerp(endPoint, ratio)',
    pClamp: 'p.clampf(min_inclusive, max_inclusive)',
    rand: 'Math.random() * 0xffffff',
    randomMinus1To1: '(Math.random() - 0.5) * 2',
    container: 'cc.game.container',
    _canvas: 'cc.game.canvas',
    _renderType: 'cc.game.renderType',
    _getError: 'cc.debug.getError',
    _initDebugSetting: 'cc.debug._resetDebugSetting',
    DebugMode: 'cc.debug.DebugMode'
  }, 'cc');
  markAsRemovedInObject(cc, ['blendFuncDisable', 'pFromSize', 'pCompOp', 'pIntersectPoint', 'pSegmentIntersect', 'pLineIntersect', 'obbApplyMatrix', 'getImageFormatByData', 'initEngine'], 'cc');
  markFunctionWarning(cc, {
    // cc.p
    p: 'cc.v2'
  }, 'cc'); // cc.Rect

  provideClearError(cc.Rect, {
    contain: 'rectA.contains(rectB)',
    transformMat4: 'rect.transformMat4(out, mat4)'
  }); // cc.Color

  provideClearError(cc.Color, {
    rgb2hsv: 'color.toHSV()',
    hsv2rgb: 'color.fromHSV(h, s, v)'
  }); // macro functions

  js.get(cc, 'lerp', function () {
    cc.errorID(1400, 'cc.lerp', 'cc.misc.lerp');
    return cc.misc.lerp;
  });
  js.get(cc, 'random0To1', function () {
    cc.errorID(1400, 'cc.random0To1', 'Math.random');
    return Math.random;
  });
  js.get(cc, 'degreesToRadians', function () {
    cc.errorID(1400, 'cc.degreesToRadians', 'cc.misc.degreesToRadians');
    return cc.misc.degreesToRadians;
  });
  js.get(cc, 'radiansToDegrees', function () {
    cc.errorID(1400, 'cc.radiansToDegrees', 'cc.misc.radiansToDegrees');
    return cc.misc.radiansToDegrees;
  });
  js.get(cc, 'clampf', function () {
    cc.errorID(1400, 'cc.clampf', 'cc.misc.clampf');
    return cc.misc.clampf;
  });
  js.get(cc, 'clamp01', function () {
    cc.errorID(1400, 'cc.clamp01', 'cc.misc.clamp01');
    return cc.misc.clamp01;
  });
  js.get(cc, 'ImageFormat', function () {
    cc.errorID(1400, 'cc.ImageFormat', 'cc.macro.ImageFormat');
    return cc.macro.ImageFormat;
  });
  js.get(cc, 'KEY', function () {
    cc.errorID(1400, 'cc.KEY', 'cc.macro.KEY');
    return cc.macro.KEY;
  });
  js.get(cc, 'Easing', function () {
    cc.errorID(1400, 'cc.Easing', 'cc.easing');
    return cc.easing;
  }); // cc.isChildClassOf

  js.get(cc, 'isChildClassOf', function () {
    cc.errorID(1400, 'cc.isChildClassOf', 'cc.js.isChildClassOf');
    return cc.js.isChildClassOf;
  }); // dragon bones

  if (typeof dragonBones !== 'undefined') {
    js.get(dragonBones.CCFactory, 'getFactory', function () {
      cc.errorID(1400, 'dragonBones.CCFactory.getFactory', 'dragonBones.CCFactory.getInstance');
      return dragonBones.CCFactory.getInstance;
    });
  } // renderEngine


  cc.renderer.renderEngine = {
    get gfx() {
      cc.warnID(1400, 'cc.renderer.renderEngine.gfx', 'cc.gfx');
      return cc.gfx;
    },

    get math() {
      cc.warnID(1400, 'cc.renderer.renderEngine.math', 'cc.math');
      return cc.vmath;
    },

    get InputAssembler() {
      cc.warnID(1400, 'cc.renderer.renderEngine.InputAssembler', 'cc.renderer.InputAssembler');
      return cc.renderer.InputAssembler;
    }

  };
}
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/extensions/ccpool/CCNodePool.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

/**
 * !#en
 *  cc.NodePool is the cache pool designed for node type.<br/>
 *  It can helps you to improve your game performance for objects which need frequent release and recreate operations<br/>
 *
 * It's recommended to create cc.NodePool instances by node type, the type corresponds to node type in game design, not the class, 
 * for example, a prefab is a specific node type. <br/>
 * When you create a node pool, you can pass a Component which contains `unuse`, `reuse` functions to control the content of node.<br/>
 *
 * Some common use case is :<br/>
 *      1. Bullets in game (die very soon, massive creation and recreation, no side effect on other objects)<br/>
 *      2. Blocks in candy crash (massive creation and recreation)<br/>
 *      etc...
 * !#zh
 * cc.NodePool 是用于管理节点对象的对象缓存池。<br/>
 * 它可以帮助您提高游戏性能，适用于优化对象的反复创建和销毁<br/>
 * 以前 cocos2d-x 中的 cc.pool 和新的节点事件注册系统不兼容，因此请使用 cc.NodePool 来代替。
 *
 * 新的 NodePool 需要实例化之后才能使用，每种不同的节点对象池需要一个不同的对象池实例，这里的种类对应于游戏中的节点设计，一个 prefab 相当于一个种类的节点。<br/>
 * 在创建缓冲池时，可以传入一个包含 unuse, reuse 函数的组件类型用于节点的回收和复用逻辑。<br/>
 *
 * 一些常见的用例是：<br/>
 *      1.在游戏中的子弹（死亡很快，频繁创建，对其他对象无副作用）<br/>
 *      2.糖果粉碎传奇中的木块（频繁创建）。
 *      等等....
 * @class NodePool
 */

/**
 * !#en
 * Constructor for creating a pool for a specific node template (usually a prefab). You can pass a component (type or name) argument for handling event for reusing and recycling node.
 * !#zh
 * 使用构造函数来创建一个节点专用的对象池，您可以传递一个组件类型或名称，用于处理节点回收和复用时的事件逻辑。
 * @method constructor
 * @param {Function|String} [poolHandlerComp] !#en The constructor or the class name of the component to control the unuse/reuse logic. !#zh 处理节点回收和复用事件逻辑的组件类型或名称。
 * @example
 *  properties: {
 *    template: cc.Prefab
 *  },
 *  onLoad () {
      // MyTemplateHandler is a component with 'unuse' and 'reuse' to handle events when node is reused or recycled.
 *    this.myPool = new cc.NodePool('MyTemplateHandler');
 *  }
 * @typescript
 * constructor(poolHandlerComp?: {prototype: Component}|string)
 */
cc.NodePool = function (poolHandlerComp) {
  /**
   * !#en The pool handler component, it could be the class name or the constructor.
   * !#zh 缓冲池处理组件，用于节点的回收和复用逻辑，这个属性可以是组件类名或组件的构造函数。
   * @property poolHandlerComp
   * @type {Function|String}
   */
  this.poolHandlerComp = poolHandlerComp;
  this._pool = [];
};

cc.NodePool.prototype = {
  constructor: cc.NodePool,

  /**
   * !#en The current available size in the pool
   * !#zh 获取当前缓冲池的可用对象数量
   * @method size
   * @return {Number}
   */
  size: function size() {
    return this._pool.length;
  },

  /**
   * !#en Destroy all cached nodes in the pool
   * !#zh 销毁对象池中缓存的所有节点
   * @method clear
   */
  clear: function clear() {
    var count = this._pool.length;

    for (var i = 0; i < count; ++i) {
      this._pool[i].destroy();
    }

    this._pool.length = 0;
  },

  /**
   * !#en Put a new Node into the pool.
   * It will automatically remove the node from its parent without cleanup.
   * It will also invoke unuse method of the poolHandlerComp if exist.
   * !#zh 向缓冲池中存入一个不再需要的节点对象。
   * 这个函数会自动将目标节点从父节点上移除，但是不会进行 cleanup 操作。
   * 这个函数会调用 poolHandlerComp 的 unuse 函数，如果组件和函数都存在的话。
   * @method put
   * @param {Node} obj
   * @example
   *   let myNode = cc.instantiate(this.template);
   *   this.myPool.put(myNode);
   */
  put: function put(obj) {
    if (obj && this._pool.indexOf(obj) === -1) {
      // Remove from parent, but don't cleanup
      obj.removeFromParent(false); // Invoke pool handler

      var handler = this.poolHandlerComp ? obj.getComponent(this.poolHandlerComp) : null;

      if (handler && handler.unuse) {
        handler.unuse();
      }

      this._pool.push(obj);
    }
  },

  /**
   * !#en Get a obj from pool, if no available object in pool, null will be returned.
   * This function will invoke the reuse function of poolHandlerComp if exist.
   * !#zh 获取对象池中的对象，如果对象池没有可用对象，则返回空。
   * 这个函数会调用 poolHandlerComp 的 reuse 函数，如果组件和函数都存在的话。
   * @method get
   * @param {any} ...params - !#en Params to pass to 'reuse' method in poolHandlerComp !#zh 向 poolHandlerComp 中的 'reuse' 函数传递的参数
   * @return {Node|null}
   * @example
   *   let newNode = this.myPool.get();
   */
  get: function get() {
    var last = this._pool.length - 1;

    if (last < 0) {
      return null;
    } else {
      // Pop the last object in pool
      var obj = this._pool[last];
      this._pool.length = last; // Invoke pool handler

      var handler = this.poolHandlerComp ? obj.getComponent(this.poolHandlerComp) : null;

      if (handler && handler.reuse) {
        handler.reuse.apply(handler, arguments);
      }

      return obj;
    }
  }
};
module.exports = cc.NodePool;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/platform/CCInputExtension.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2011-2012 cocos2d-x.org
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var eventManager = require('../event-manager');

var inputManager = require("./CCInputManager");

var PORTRAIT = 0;
var LANDSCAPE_LEFT = -90;
var PORTRAIT_UPSIDE_DOWN = 180;
var LANDSCAPE_RIGHT = 90;

var _didAccelerateFun;
/**
 * !#en the device accelerometer reports values for each axis in units of g-force.
 * !#zh 设备重力传感器传递的各个轴的数据。
 * @class Acceleration
 * @method constructor
 * @param {Number} x
 * @param {Number} y
 * @param {Number} z
 * @param {Number} timestamp
 */


cc.Acceleration = function (x, y, z, timestamp) {
  this.x = x || 0;
  this.y = y || 0;
  this.z = z || 0;
  this.timestamp = timestamp || 0;
};
/**
 * whether enable accelerometer event
 * @method setAccelerometerEnabled
 * @param {Boolean} isEnable
 */


inputManager.setAccelerometerEnabled = function (isEnable) {
  var _t = this;

  if (_t._accelEnabled === isEnable) return;
  _t._accelEnabled = isEnable;
  var scheduler = cc.director.getScheduler();
  scheduler.enableForTarget(_t);

  if (_t._accelEnabled) {
    _t._registerAccelerometerEvent();

    _t._accelCurTime = 0;
    scheduler.scheduleUpdate(_t);
  } else {
    _t._unregisterAccelerometerEvent();

    _t._accelCurTime = 0;
    scheduler.unscheduleUpdate(_t);
  }

  if (CC_JSB || CC_RUNTIME) {
    jsb.device.setMotionEnabled(isEnable);
  }
};
/**
 * set accelerometer interval value
 * @method setAccelerometerInterval
 * @param {Number} interval
 */


inputManager.setAccelerometerInterval = function (interval) {
  if (this._accelInterval !== interval) {
    this._accelInterval = interval;

    if (CC_JSB || CC_RUNTIME) {
      jsb.device.setMotionInterval(interval);
    }
  }
};

inputManager._registerKeyboardEvent = function () {
  cc.game.canvas.addEventListener("keydown", function (e) {
    eventManager.dispatchEvent(new cc.Event.EventKeyboard(e.keyCode, true));
    e.stopPropagation();
    e.preventDefault();
  }, false);
  cc.game.canvas.addEventListener("keyup", function (e) {
    eventManager.dispatchEvent(new cc.Event.EventKeyboard(e.keyCode, false));
    e.stopPropagation();
    e.preventDefault();
  }, false);
};

inputManager._registerAccelerometerEvent = function () {
  var w = window,
      _t = this;

  _t._acceleration = new cc.Acceleration();
  _t._accelDeviceEvent = w.DeviceMotionEvent || w.DeviceOrientationEvent; //TODO fix DeviceMotionEvent bug on QQ Browser version 4.1 and below.

  if (cc.sys.browserType === cc.sys.BROWSER_TYPE_MOBILE_QQ) _t._accelDeviceEvent = window.DeviceOrientationEvent;

  var _deviceEventType = _t._accelDeviceEvent === w.DeviceMotionEvent ? "devicemotion" : "deviceorientation";

  var ua = navigator.userAgent;

  if (/Android/.test(ua) || /Adr/.test(ua) && cc.sys.browserType === cc.BROWSER_TYPE_UC) {
    _t._minus = -1;
  }

  _didAccelerateFun = _t.didAccelerate.bind(_t);
  w.addEventListener(_deviceEventType, _didAccelerateFun, false);
};

inputManager._unregisterAccelerometerEvent = function () {
  var w = window,
      _t = this;

  var _deviceEventType = _t._accelDeviceEvent === w.DeviceMotionEvent ? "devicemotion" : "deviceorientation";

  if (_didAccelerateFun) {
    w.removeEventListener(_deviceEventType, _didAccelerateFun, false);
  }
};

inputManager.didAccelerate = function (eventData) {
  var _t = this,
      w = window;

  if (!_t._accelEnabled) return;
  var mAcceleration = _t._acceleration;
  var x, y, z;

  if (_t._accelDeviceEvent === window.DeviceMotionEvent) {
    var eventAcceleration = eventData["accelerationIncludingGravity"];
    x = _t._accelMinus * eventAcceleration.x * 0.1;
    y = _t._accelMinus * eventAcceleration.y * 0.1;
    z = eventAcceleration.z * 0.1;
  } else {
    x = eventData["gamma"] / 90 * 0.981;
    y = -(eventData["beta"] / 90) * 0.981;
    z = eventData["alpha"] / 90 * 0.981;
  }

  if (cc.view._isRotated) {
    var tmp = x;
    x = -y;
    y = tmp;
  }

  mAcceleration.x = x;
  mAcceleration.y = y;
  mAcceleration.z = z;
  mAcceleration.timestamp = eventData.timeStamp || Date.now();
  var tmpX = mAcceleration.x;

  if (w.orientation === LANDSCAPE_RIGHT) {
    mAcceleration.x = -mAcceleration.y;
    mAcceleration.y = tmpX;
  } else if (w.orientation === LANDSCAPE_LEFT) {
    mAcceleration.x = mAcceleration.y;
    mAcceleration.y = -tmpX;
  } else if (w.orientation === PORTRAIT_UPSIDE_DOWN) {
    mAcceleration.x = -mAcceleration.x;
    mAcceleration.y = -mAcceleration.y;
  } // fix android acc values are opposite


  if (cc.sys.os === cc.sys.OS_ANDROID && cc.sys.browserType !== cc.sys.BROWSER_TYPE_MOBILE_QQ) {
    mAcceleration.x = -mAcceleration.x;
    mAcceleration.y = -mAcceleration.y;
  }
};
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/index.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
require('./platform');

require('./assets');

if (!CC_EDITOR || !Editor.isMainProcess) {
  require('./CCNode');

  require('./CCPrivateNode');

  require('./CCScene');

  require('./components');

  require('./graphics');

  require('./collider'); // CCIntersection can be used separately.


  require('./collider/CCIntersection');

  require('./physics');

  require('./camera/CCCamera');

  require('./geom-utils');
}

require('./mesh');

require('./3d');

require('./base-ui/CCWidgetManager');
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/particle/index.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/
 
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
require('./CCParticleAsset');

require('./CCParticleSystem');

require('./particle-simulator');

require('./particle-system-assembler');
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/extensions/spine/index.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

/**
 * !#en
 * The global main namespace of Spine, all classes, functions,
 * properties and constants of Spine are defined in this namespace
 * !#zh
 * Spine 的全局的命名空间，
 * 与 Spine 相关的所有的类，函数，属性，常量都在这个命名空间中定义。
 * @module sp
 * @main sp
 */

/*
 * Reference:
 * http://esotericsoftware.com/spine-runtime-terminology
 * http://esotericsoftware.com/files/runtime-diagram.png
 * http://en.esotericsoftware.com/spine-using-runtimes
 */
var _global = typeof window === 'undefined' ? global : window;

var _isUseSpine = true;

if (!CC_NATIVERENDERER) {
  _global.spine = require('./lib/spine');
} else if (!_global.spine) {
  _isUseSpine = false;
}

if (_isUseSpine) {
  _global.sp = {};
  /**
   * !#en
   * The global time scale of Spine.
   * !#zh
   * Spine 全局时间缩放率。
   * @example
   * sp.timeScale = 0.8;
   */

  sp._timeScale = 1.0;
  Object.defineProperty(sp, 'timeScale', {
    get: function get() {
      return this._timeScale;
    },
    set: function set(value) {
      this._timeScale = value;
    },
    configurable: true
  }); // The attachment type of spine. It contains three type: REGION(0), BOUNDING_BOX(1), MESH(2) and SKINNED_MESH.

  sp.ATTACHMENT_TYPE = {
    REGION: 0,
    BOUNDING_BOX: 1,
    MESH: 2,
    SKINNED_MESH: 3
  };
  /**
   * !#en The event type of spine skeleton animation.
   * !#zh 骨骼动画事件类型。
   * @enum AnimationEventType
   */

  sp.AnimationEventType = cc.Enum({
    /**
     * !#en The play spine skeleton animation start type.
     * !#zh 开始播放骨骼动画。
     * @property {Number} START
     */
    START: 0,

    /**
     * !#en Another entry has replaced this entry as the current entry. This entry may continue being applied for mixing.
     * !#zh 当前的 entry 被其他的 entry 替换。当使用 mixing 时，当前的 entry 会继续运行。
     */
    INTERRUPT: 1,

    /**
     * !#en The play spine skeleton animation finish type.
     * !#zh 播放骨骼动画结束。
     * @property {Number} END
     */
    END: 2,

    /**
     * !#en The entry will be disposed.
     * !#zh entry 将被销毁。
     */
    DISPOSE: 3,

    /**
     * !#en The play spine skeleton animation complete type.
     * !#zh 播放骨骼动画完成。
     * @property {Number} COMPLETE
     */
    COMPLETE: 4,

    /**
     * !#en The spine skeleton animation event type.
     * !#zh 骨骼动画事件。
     * @property {Number} EVENT
     */
    EVENT: 5
  });
  /**
   * @module sp
   */

  if (!CC_EDITOR || !Editor.isMainProcess) {
    sp.spine = _global.spine;

    if (!CC_NATIVERENDERER) {
      require('./skeleton-texture');
    }

    require('./skeleton-data');

    require('./vertex-effect-delegate');

    require('./Skeleton');

    require('./spine-assembler');
  } else {
    require('./skeleton-data');
  }
}
/**
 * !#en
 * `sp.spine` is the namespace for official Spine Runtime, which officially implemented and maintained by Spine.<br>
 * Please refer to the official documentation for its detailed usage: [http://en.esotericsoftware.com/spine-using-runtimes](http://en.esotericsoftware.com/spine-using-runtimes)
 * !#zh
 * sp.spine 模块是 Spine 官方运行库的 API 入口，由 Spine 官方统一实现和维护，具体用法请参考：[http://zh.esotericsoftware.com/spine-using-runtimes](http://zh.esotericsoftware.com/spine-using-runtimes)
 * @module sp.spine
 * @main sp.spine
 */
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/animation/index.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
require('./bezier');

require('./easing');

require('./types');

require('./motion-path-helper');

require('./animation-curves');

require('./animation-clip');

require('./animation-manager');

require('./animation-state');

require('./animation-animator');
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/actions/index.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
require('./CCActionManager');

require('./CCAction');

require('./CCActionInterval');

require('./CCActionInstant');

require('./CCActionEase');

require('./CCActionCatmullRom');

require('./tween');
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/CCDirector.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2008-2010 Ricardo Quesada
 Copyright (c) 2011-2012 cocos2d-x.org
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var EventTarget = require('./event/event-target');

var AutoReleaseUtils = require('./load-pipeline/auto-release-utils');

var ComponentScheduler = require('./component-scheduler');

var NodeActivator = require('./node-activator');

var Obj = require('./platform/CCObject');

var game = require('./CCGame');

var renderer = require('./renderer');

var eventManager = require('./event-manager');

var Scheduler = require('./CCScheduler'); //----------------------------------------------------------------------------------------------------------------------

/**
 * !#en
 * <p>
 *    ATTENTION: USE cc.director INSTEAD OF cc.Director.<br/>
 *    cc.director is a singleton object which manage your game's logic flow.<br/>
 *    Since the cc.director is a singleton, you don't need to call any constructor or create functions,<br/>
 *    the standard way to use it is by calling:<br/>
 *      - cc.director.methodName(); <br/>
 *
 *    It creates and handle the main Window and manages how and when to execute the Scenes.<br/>
 *    <br/>
 *    The cc.director is also responsible for:<br/>
 *      - initializing the OpenGL context<br/>
 *      - setting the OpenGL pixel format (default on is RGB565)<br/>
 *      - setting the OpenGL buffer depth (default on is 0-bit)<br/>
 *      - setting the color for clear screen (default one is BLACK)<br/>
 *      - setting the projection (default one is 3D)<br/>
 *      - setting the orientation (default one is Portrait)<br/>
 *      <br/>
 *    <br/>
 *    The cc.director also sets the default OpenGL context:<br/>
 *      - GL_TEXTURE_2D is enabled<br/>
 *      - GL_VERTEX_ARRAY is enabled<br/>
 *      - GL_COLOR_ARRAY is enabled<br/>
 *      - GL_TEXTURE_COORD_ARRAY is enabled<br/>
 * </p>
 * <p>
 *   cc.director also synchronizes timers with the refresh rate of the display.<br/>
 *   Features and Limitations:<br/>
 *      - Scheduled timers & drawing are synchronizes with the refresh rate of the display<br/>
 *      - Only supports animation intervals of 1/60 1/30 & 1/15<br/>
 * </p>
 *
 * !#zh
 * <p>
 *     注意：用 cc.director 代替 cc.Director。<br/>
 *     cc.director 一个管理你的游戏的逻辑流程的单例对象。<br/>
 *     由于 cc.director 是一个单例，你不需要调用任何构造函数或创建函数，<br/>
 *     使用它的标准方法是通过调用：<br/>
 *       - cc.director.methodName();
 *     <br/>
 *     它创建和处理主窗口并且管理什么时候执行场景。<br/>
 *     <br/>
 *     cc.director 还负责：<br/>
 *      - 初始化 OpenGL 环境。<br/>
 *      - 设置OpenGL像素格式。(默认是 RGB565)<br/>
 *      - 设置OpenGL缓冲区深度 (默认是 0-bit)<br/>
 *      - 设置空白场景的颜色 (默认是 黑色)<br/>
 *      - 设置投影 (默认是 3D)<br/>
 *      - 设置方向 (默认是 Portrait)<br/>
 *    <br/>
 *    cc.director 设置了 OpenGL 默认环境 <br/>
 *      - GL_TEXTURE_2D   启用。<br/>
 *      - GL_VERTEX_ARRAY 启用。<br/>
 *      - GL_COLOR_ARRAY  启用。<br/>
 *      - GL_TEXTURE_COORD_ARRAY 启用。<br/>
 * </p>
 * <p>
 *   cc.director 也同步定时器与显示器的刷新速率。
 *   <br/>
 *   特点和局限性: <br/>
 *      - 将计时器 & 渲染与显示器的刷新频率同步。<br/>
 *      - 只支持动画的间隔 1/60 1/30 & 1/15。<br/>
 * </p>
 *
 * @class Director
 * @extends EventTarget
 */


cc.Director = function () {
  EventTarget.call(this); // paused?

  this._paused = false; // purge?

  this._purgeDirectorInNextLoop = false;
  this._winSizeInPoints = null; // scenes

  this._loadingScene = '';
  this._scene = null; // FPS

  this._totalFrames = 0;
  this._lastUpdate = 0;
  this._deltaTime = 0.0;
  this._startTime = 0.0; // ParticleSystem max step delta time

  this._maxParticleDeltaTime = 0.0; // Scheduler for user registration update

  this._scheduler = null; // Scheduler for life-cycle methods in component

  this._compScheduler = null; // Node activator

  this._nodeActivator = null; // Action manager

  this._actionManager = null;
  var self = this;
  game.on(game.EVENT_SHOW, function () {
    self._lastUpdate = performance.now();
  });
  game.once(game.EVENT_ENGINE_INITED, this.init, this);
};

cc.Director.prototype = {
  constructor: cc.Director,
  init: function init() {
    this._totalFrames = 0;
    this._lastUpdate = performance.now();
    this._startTime = this._lastUpdate;
    this._paused = false;
    this._purgeDirectorInNextLoop = false;
    this._winSizeInPoints = cc.size(0, 0);
    this._scheduler = new Scheduler();

    if (cc.ActionManager) {
      this._actionManager = new cc.ActionManager();

      this._scheduler.scheduleUpdate(this._actionManager, Scheduler.PRIORITY_SYSTEM, false);
    } else {
      this._actionManager = null;
    }

    this.sharedInit();
    return true;
  },

  /*
   * Manage all init process shared between the web engine and jsb engine.
   * All platform independent init process should be occupied here.
   */
  sharedInit: function sharedInit() {
    this._compScheduler = new ComponentScheduler();
    this._nodeActivator = new NodeActivator(); // Event manager

    if (eventManager) {
      eventManager.setEnabled(true);
    } // Animation manager


    if (cc.AnimationManager) {
      this._animationManager = new cc.AnimationManager();

      this._scheduler.scheduleUpdate(this._animationManager, Scheduler.PRIORITY_SYSTEM, false);
    } else {
      this._animationManager = null;
    } // collision manager


    if (cc.CollisionManager) {
      this._collisionManager = new cc.CollisionManager();

      this._scheduler.scheduleUpdate(this._collisionManager, Scheduler.PRIORITY_SYSTEM, false);
    } else {
      this._collisionManager = null;
    } // physics manager


    if (cc.PhysicsManager) {
      this._physicsManager = new cc.PhysicsManager();

      this._scheduler.scheduleUpdate(this._physicsManager, Scheduler.PRIORITY_SYSTEM, false);
    } else {
      this._physicsManager = null;
    } // physics 3d manager


    if (cc.Physics3DManager) {
      this._physics3DManager = new cc.Physics3DManager();

      this._scheduler.scheduleUpdate(this._physics3DManager, Scheduler.PRIORITY_SYSTEM, false);
    } else {
      this._physics3DManager = null;
    } // WidgetManager


    if (cc._widgetManager) {
      cc._widgetManager.init(this);
    }

    cc.loader.init(this);
  },

  /**
   * calculates delta time since last time it was called
   */
  calculateDeltaTime: function calculateDeltaTime(now) {
    if (!now) now = performance.now(); // avoid delta time from being negative
    // negative deltaTime would be caused by the precision of now's value, for details please see: https://developer.mozilla.org/zh-CN/docs/Web/API/window/requestAnimationFrame

    this._deltaTime = now > this._lastUpdate ? (now - this._lastUpdate) / 1000 : 0;
    if (CC_DEBUG && this._deltaTime > 1) this._deltaTime = 1 / 60.0;
    this._lastUpdate = now;
  },

  /**
   * !#en
   * Converts a view coordinate to an WebGL coordinate<br/>
   * Useful to convert (multi) touches coordinates to the current layout (portrait or landscape)<br/>
   * Implementation can be found in CCDirectorWebGL.
   * !#zh 将触摸点的屏幕坐标转换为 WebGL View 下的坐标。
   * @method convertToGL
   * @param {Vec2} uiPoint
   * @return {Vec2}
   * @deprecated since v2.0
   */
  convertToGL: function convertToGL(uiPoint) {
    var container = game.container;
    var view = cc.view;
    var box = container.getBoundingClientRect();
    var left = box.left + window.pageXOffset - container.clientLeft;
    var top = box.top + window.pageYOffset - container.clientTop;
    var x = view._devicePixelRatio * (uiPoint.x - left);
    var y = view._devicePixelRatio * (top + box.height - uiPoint.y);
    return view._isRotated ? cc.v2(view._viewportRect.width - y, x) : cc.v2(x, y);
  },

  /**
   * !#en
   * Converts an OpenGL coordinate to a view coordinate<br/>
   * Useful to convert node points to window points for calls such as glScissor<br/>
   * Implementation can be found in CCDirectorWebGL.
   * !#zh 将触摸点的 WebGL View 坐标转换为屏幕坐标。
   * @method convertToUI
   * @param {Vec2} glPoint
   * @return {Vec2}
   * @deprecated since v2.0
   */
  convertToUI: function convertToUI(glPoint) {
    var container = game.container;
    var view = cc.view;
    var box = container.getBoundingClientRect();
    var left = box.left + window.pageXOffset - container.clientLeft;
    var top = box.top + window.pageYOffset - container.clientTop;
    var uiPoint = cc.v2(0, 0);

    if (view._isRotated) {
      uiPoint.x = left + glPoint.y / view._devicePixelRatio;
      uiPoint.y = top + box.height - (view._viewportRect.width - glPoint.x) / view._devicePixelRatio;
    } else {
      uiPoint.x = left + glPoint.x * view._devicePixelRatio;
      uiPoint.y = top + box.height - glPoint.y * view._devicePixelRatio;
    }

    return uiPoint;
  },

  /**
   * End the life of director in the next frame
   * @method end
   */
  end: function end() {
    this._purgeDirectorInNextLoop = true;
  },

  /**
   * !#en
   * Returns the size of the WebGL view in points.<br/>
   * It takes into account any possible rotation (device orientation) of the window.
   * !#zh 获取视图的大小，以点为单位。
   * @method getWinSize
   * @return {Size}
   * @deprecated since v2.0
   */
  getWinSize: function getWinSize() {
    return cc.size(cc.winSize);
  },

  /**
   * !#en
   * Returns the size of the OpenGL view in pixels.<br/>
   * It takes into account any possible rotation (device orientation) of the window.<br/>
   * On Mac winSize and winSizeInPixels return the same value.
   * (The pixel here refers to the resource resolution. If you want to get the physics resolution of device, you need to use cc.view.getFrameSize())
   * !#zh
   * 获取视图大小，以像素为单位（这里的像素指的是资源分辨率。
   * 如果要获取屏幕物理分辨率，需要用 cc.view.getFrameSize()）
   * @method getWinSizeInPixels
   * @return {Size}
   * @deprecated since v2.0
   */
  getWinSizeInPixels: function getWinSizeInPixels() {
    return cc.size(cc.winSize);
  },

  /**
   * !#en Pause the director's ticker, only involve the game logic execution.
   * It won't pause the rendering process nor the event manager.
   * If you want to pause the entier game including rendering, audio and event, 
   * please use {{#crossLink "Game.pause"}}cc.game.pause{{/crossLink}}
   * !#zh 暂停正在运行的场景，该暂停只会停止游戏逻辑执行，但是不会停止渲染和 UI 响应。
   * 如果想要更彻底得暂停游戏，包含渲染，音频和事件，请使用 {{#crossLink "Game.pause"}}cc.game.pause{{/crossLink}}。
   * @method pause
   */
  pause: function pause() {
    if (this._paused) return;
    this._paused = true;
  },

  /**
   * Removes cached all cocos2d cached data.
   * @deprecated since v2.0
   */
  purgeCachedData: function purgeCachedData() {
    cc.loader.releaseAll();
  },

  /**
   * Purge the cc.director itself, including unschedule all schedule, remove all event listeners, clean up and exit the running scene, stops all animations, clear cached data.
   */
  purgeDirector: function purgeDirector() {
    //cleanup scheduler
    this._scheduler.unscheduleAll();

    this._compScheduler.unscheduleAll();

    this._nodeActivator.reset(); // Disable event dispatching


    if (eventManager) eventManager.setEnabled(false);

    if (!CC_EDITOR) {
      if (cc.isValid(this._scene)) {
        this._scene.destroy();
      }

      this._scene = null;
      cc.renderer.clear();
      cc.AssetLibrary.resetBuiltins();
    }

    cc.game.pause(); // Clear all caches

    cc.loader.releaseAll();
  },

  /**
   * Reset the cc.director, can be used to restart the director after purge
   */
  reset: function reset() {
    this.purgeDirector();
    if (eventManager) eventManager.setEnabled(true); // Action manager

    if (this._actionManager) {
      this._scheduler.scheduleUpdate(this._actionManager, cc.Scheduler.PRIORITY_SYSTEM, false);
    } // Animation manager


    if (this._animationManager) {
      this._scheduler.scheduleUpdate(this._animationManager, cc.Scheduler.PRIORITY_SYSTEM, false);
    } // Collider manager


    if (this._collisionManager) {
      this._scheduler.scheduleUpdate(this._collisionManager, cc.Scheduler.PRIORITY_SYSTEM, false);
    } // Physics manager


    if (this._physicsManager) {
      this._scheduler.scheduleUpdate(this._physicsManager, cc.Scheduler.PRIORITY_SYSTEM, false);
    }

    cc.game.resume();
  },

  /**
   * !#en
   * Run a scene. Replaces the running scene with a new one or enter the first scene.<br/>
   * The new scene will be launched immediately.
   * !#zh 立刻切换指定场景。
   * @method runSceneImmediate
   * @param {Scene} scene - The need run scene.
   * @param {Function} [onBeforeLoadScene] - The function invoked at the scene before loading.
   * @param {Function} [onLaunched] - The function invoked at the scene after launch.
   */
  runSceneImmediate: function runSceneImmediate(scene, onBeforeLoadScene, onLaunched) {
    cc.assertID(scene instanceof cc.Scene, 1216);
    CC_BUILD && CC_DEBUG && console.time('InitScene');

    scene._load(); // ensure scene initialized


    CC_BUILD && CC_DEBUG && console.timeEnd('InitScene'); // Re-attach or replace persist nodes

    CC_BUILD && CC_DEBUG && console.time('AttachPersist');
    var persistNodeList = Object.keys(game._persistRootNodes).map(function (x) {
      return game._persistRootNodes[x];
    });

    for (var i = 0; i < persistNodeList.length; i++) {
      var node = persistNodeList[i];
      var existNode = scene.getChildByUuid(node.uuid);

      if (existNode) {
        // scene also contains the persist node, select the old one
        var index = existNode.getSiblingIndex();

        existNode._destroyImmediate();

        scene.insertChild(node, index);
      } else {
        node.parent = scene;
      }
    }

    CC_BUILD && CC_DEBUG && console.timeEnd('AttachPersist');
    var oldScene = this._scene;

    if (!CC_EDITOR) {
      // auto release assets
      CC_BUILD && CC_DEBUG && console.time('AutoRelease');
      var autoReleaseAssets = oldScene && oldScene.autoReleaseAssets && oldScene.dependAssets;
      AutoReleaseUtils.autoRelease(autoReleaseAssets, scene.dependAssets, persistNodeList);
      CC_BUILD && CC_DEBUG && console.timeEnd('AutoRelease');
    } // unload scene


    CC_BUILD && CC_DEBUG && console.time('Destroy');

    if (cc.isValid(oldScene)) {
      oldScene.destroy();
    }

    this._scene = null; // purge destroyed nodes belongs to old scene

    Obj._deferredDestroy();

    CC_BUILD && CC_DEBUG && console.timeEnd('Destroy');

    if (onBeforeLoadScene) {
      onBeforeLoadScene();
    }

    this.emit(cc.Director.EVENT_BEFORE_SCENE_LAUNCH, scene); // Run an Entity Scene

    this._scene = scene;
    CC_BUILD && CC_DEBUG && console.time('Activate');

    scene._activate();

    CC_BUILD && CC_DEBUG && console.timeEnd('Activate'); //start scene

    cc.game.resume();

    if (onLaunched) {
      onLaunched(null, scene);
    }

    this.emit(cc.Director.EVENT_AFTER_SCENE_LAUNCH, scene);
  },

  /**
   * !#en
   * Run a scene. Replaces the running scene with a new one or enter the first scene.
   * The new scene will be launched at the end of the current frame.
   * !#zh 运行指定场景。
   * @method runScene
   * @param {Scene} scene - The need run scene.
   * @param {Function} [onBeforeLoadScene] - The function invoked at the scene before loading.
   * @param {Function} [onLaunched] - The function invoked at the scene after launch.
   * @private
   */
  runScene: function runScene(scene, onBeforeLoadScene, onLaunched) {
    cc.assertID(scene, 1205);
    cc.assertID(scene instanceof cc.Scene, 1216); // ensure scene initialized

    scene._load(); // Delay run / replace scene to the end of the frame


    this.once(cc.Director.EVENT_AFTER_UPDATE, function () {
      this.runSceneImmediate(scene, onBeforeLoadScene, onLaunched);
    }, this);
  },
  //  @Scene loading section
  _getSceneUuid: function _getSceneUuid(key) {
    var scenes = game._sceneInfos;

    if (typeof key === 'string') {
      if (!key.endsWith('.fire')) {
        key += '.fire';
      }

      if (key[0] !== '/' && !key.startsWith('db://')) {
        key = '/' + key; // 使用全名匹配
      } // search scene


      for (var i = 0; i < scenes.length; i++) {
        var info = scenes[i];

        if (info.url.endsWith(key)) {
          return info;
        }
      }
    } else if (typeof key === 'number') {
      if (0 <= key && key < scenes.length) {
        return scenes[key];
      } else {
        cc.errorID(1206, key);
      }
    } else {
      cc.errorID(1207, key);
    }

    return null;
  },

  /**
   * !#en Loads the scene by its name.
   * !#zh 通过场景名称进行加载场景。
   *
   * @method loadScene
   * @param {String} sceneName - The name of the scene to load.
   * @param {Function} [onLaunched] - callback, will be called after scene launched.
   * @return {Boolean} if error, return false
   */
  loadScene: function loadScene(sceneName, onLaunched, _onUnloaded) {
    if (this._loadingScene) {
      cc.warnID(1208, sceneName, this._loadingScene);
      return false;
    }

    var info = this._getSceneUuid(sceneName);

    if (info) {
      var uuid = info.uuid;
      this.emit(cc.Director.EVENT_BEFORE_SCENE_LOADING, sceneName);
      this._loadingScene = sceneName;

      this._loadSceneByUuid(uuid, onLaunched, _onUnloaded);

      return true;
    } else {
      cc.errorID(1209, sceneName);
      return false;
    }
  },

  /**
   * !#en
   * Preloads the scene to reduces loading time. You can call this method at any time you want.
   * After calling this method, you still need to launch the scene by `cc.director.loadScene`.
   * It will be totally fine to call `cc.director.loadScene` at any time even if the preloading is not
   * yet finished, the scene will be launched after loaded automatically.
   * !#zh 预加载场景，你可以在任何时候调用这个方法。
   * 调用完后，你仍然需要通过 `cc.director.loadScene` 来启动场景，因为这个方法不会执行场景加载操作。
   * 就算预加载还没完成，你也可以直接调用 `cc.director.loadScene`，加载完成后场景就会启动。
   *
   * @method preloadScene
   * @param {String} sceneName - The name of the scene to preload.
   * @param {Function} [onProgress] - callback, will be called when the load progression change.
   * @param {Number} onProgress.completedCount - The number of the items that are already completed
   * @param {Number} onProgress.totalCount - The total number of the items
   * @param {Object} onProgress.item - The latest item which flow out the pipeline
   * @param {Function} [onLoaded] - callback, will be called after scene loaded.
   * @param {Error} onLoaded.error - null or the error object.
   * @param {cc.SceneAsset} onLoaded.asset - The scene asset itself.
   */
  preloadScene: function preloadScene(sceneName, onProgress, onLoaded) {
    if (onLoaded === undefined) {
      onLoaded = onProgress;
      onProgress = null;
    }

    var info = this._getSceneUuid(sceneName);

    if (info) {
      this.emit(cc.Director.EVENT_BEFORE_SCENE_LOADING, sceneName);
      cc.loader.load({
        uuid: info.uuid,
        type: 'uuid'
      }, onProgress, function (error, asset) {
        if (error) {
          cc.errorID(1210, sceneName, error.message);
        }

        if (onLoaded) {
          onLoaded(error, asset);
        }
      });
    } else {
      var error = 'Can not preload the scene "' + sceneName + '" because it is not in the build settings.';
      onLoaded(new Error(error));
      cc.error('preloadScene: ' + error);
    }
  },

  /**
   * Loads the scene by its uuid.
   * @method _loadSceneByUuid
   * @param {String} uuid - the uuid of the scene asset to load
   * @param {Function} [onLaunched]
   * @param {Function} [onUnloaded]
   * @param {Boolean} [dontRunScene] - Just download and initialize the scene but will not launch it,
   *                                   only take effect in the Editor.
   * @private
   */
  _loadSceneByUuid: function _loadSceneByUuid(uuid, onLaunched, onUnloaded, dontRunScene) {
    if (CC_EDITOR) {
      if (typeof onLaunched === 'boolean') {
        dontRunScene = onLaunched;
        onLaunched = null;
      }

      if (typeof onUnloaded === 'boolean') {
        dontRunScene = onUnloaded;
        onUnloaded = null;
      }
    } //cc.AssetLibrary.unloadAsset(uuid);     // force reload


    console.time('LoadScene ' + uuid);
    cc.AssetLibrary.loadAsset(uuid, function (error, sceneAsset) {
      console.timeEnd('LoadScene ' + uuid);
      var self = cc.director;
      self._loadingScene = '';

      if (error) {
        error = 'Failed to load scene: ' + error;
        cc.error(error);
      } else {
        if (sceneAsset instanceof cc.SceneAsset) {
          var scene = sceneAsset.scene;
          scene._id = sceneAsset._uuid;
          scene._name = sceneAsset._name;

          if (CC_EDITOR) {
            if (!dontRunScene) {
              self.runSceneImmediate(scene, onUnloaded, onLaunched);
            } else {
              scene._load();

              if (onLaunched) {
                onLaunched(null, scene);
              }
            }
          } else {
            self.runSceneImmediate(scene, onUnloaded, onLaunched);
          }

          return;
        } else {
          error = 'The asset ' + uuid + ' is not a scene';
          cc.error(error);
        }
      }

      if (onLaunched) {
        onLaunched(error);
      }
    });
  },

  /**
   * !#en Resume game logic execution after pause, if the current scene is not paused, nothing will happen.
   * !#zh 恢复暂停场景的游戏逻辑，如果当前场景没有暂停将没任何事情发生。
   * @method resume
   */
  resume: function resume() {
    if (!this._paused) {
      return;
    }

    this._lastUpdate = performance.now();

    if (!this._lastUpdate) {
      cc.logID(1200);
    }

    this._paused = false;
    this._deltaTime = 0;
  },

  /**
   * !#en
   * Enables or disables WebGL depth test.<br/>
   * Implementation can be found in CCDirectorCanvas.js/CCDirectorWebGL.js
   * !#zh 启用/禁用深度测试（在 Canvas 渲染模式下不会生效）。
   * @method setDepthTest
   * @param {Boolean} on
   * @deprecated since v2.0
   */
  setDepthTest: function setDepthTest(value) {
    if (!cc.Camera.main) {
      return;
    }

    cc.Camera.main.depth = !!value;
  },

  /**
   * !#en
   * Set color for clear screen.<br/>
   * (Implementation can be found in CCDirectorCanvas.js/CCDirectorWebGL.js)
   * !#zh
   * 设置场景的默认擦除颜色。<br/>
   * 支持全透明，但不支持透明度为中间值。要支持全透明需手工开启 cc.macro.ENABLE_TRANSPARENT_CANVAS。
   * @method setClearColor
   * @param {Color} clearColor
   * @deprecated since v2.0
   */
  setClearColor: function setClearColor(clearColor) {
    if (!cc.Camera.main) {
      return;
    }

    cc.Camera.main.backgroundColor = clearColor;
  },

  /**
   * !#en Returns current logic Scene.
   * !#zh 获取当前逻辑场景。
   * @method getRunningScene
   * @private
   * @return {Scene}
   * @deprecated since v2.0
   */
  getRunningScene: function getRunningScene() {
    return this._scene;
  },

  /**
   * !#en Returns current logic Scene.
   * !#zh 获取当前逻辑场景。
   * @method getScene
   * @return {Scene}
   * @example
   *  // This will help you to get the Canvas node in scene
   *  cc.director.getScene().getChildByName('Canvas');
   */
  getScene: function getScene() {
    return this._scene;
  },

  /**
   * !#en Returns the FPS value. Please use {{#crossLink "Game.setFrameRate"}}cc.game.setFrameRate{{/crossLink}} to control animation interval.
   * !#zh 获取单位帧执行时间。请使用 {{#crossLink "Game.setFrameRate"}}cc.game.setFrameRate{{/crossLink}} 来控制游戏帧率。
   * @method getAnimationInterval
   * @deprecated since v2.0
   * @return {Number}
   */
  getAnimationInterval: function getAnimationInterval() {
    return 1000 / game.getFrameRate();
  },

  /**
   * Sets animation interval, this doesn't control the main loop.
   * To control the game's frame rate overall, please use {{#crossLink "Game.setFrameRate"}}cc.game.setFrameRate{{/crossLink}}
   * @method setAnimationInterval
   * @deprecated since v2.0
   * @param {Number} value - The animation interval desired.
   */
  setAnimationInterval: function setAnimationInterval(value) {
    game.setFrameRate(Math.round(1000 / value));
  },

  /**
   * !#en Returns the delta time since last frame.
   * !#zh 获取上一帧的增量时间。
   * @method getDeltaTime
   * @return {Number}
   */
  getDeltaTime: function getDeltaTime() {
    return this._deltaTime;
  },

  /**
   * !#en Returns the total passed time since game start, unit: ms
   * !#zh 获取从游戏开始到现在总共经过的时间，单位为 ms
   * @method getTotalTime
   * @return {Number}
   */
  getTotalTime: function getTotalTime() {
    return performance.now() - this._startTime;
  },

  /**
   * !#en Returns how many frames were called since the director started.
   * !#zh 获取 director 启动以来游戏运行的总帧数。
   * @method getTotalFrames
   * @return {Number}
   */
  getTotalFrames: function getTotalFrames() {
    return this._totalFrames;
  },

  /**
   * !#en Returns whether or not the Director is paused.
   * !#zh 是否处于暂停状态。
   * @method isPaused
   * @return {Boolean}
   */
  isPaused: function isPaused() {
    return this._paused;
  },

  /**
   * !#en Returns the cc.Scheduler associated with this director.
   * !#zh 获取和 director 相关联的 cc.Scheduler。
   * @method getScheduler
   * @return {Scheduler}
   */
  getScheduler: function getScheduler() {
    return this._scheduler;
  },

  /**
   * !#en Sets the cc.Scheduler associated with this director.
   * !#zh 设置和 director 相关联的 cc.Scheduler。
   * @method setScheduler
   * @param {Scheduler} scheduler
   */
  setScheduler: function setScheduler(scheduler) {
    if (this._scheduler !== scheduler) {
      this._scheduler = scheduler;
    }
  },

  /**
   * !#en Returns the cc.ActionManager associated with this director.
   * !#zh 获取和 director 相关联的 cc.ActionManager（动作管理器）。
   * @method getActionManager
   * @return {ActionManager}
   */
  getActionManager: function getActionManager() {
    return this._actionManager;
  },

  /**
   * !#en Sets the cc.ActionManager associated with this director.
   * !#zh 设置和 director 相关联的 cc.ActionManager（动作管理器）。
   * @method setActionManager
   * @param {ActionManager} actionManager
   */
  setActionManager: function setActionManager(actionManager) {
    if (this._actionManager !== actionManager) {
      if (this._actionManager) {
        this._scheduler.unscheduleUpdate(this._actionManager);
      }

      this._actionManager = actionManager;

      this._scheduler.scheduleUpdate(this._actionManager, cc.Scheduler.PRIORITY_SYSTEM, false);
    }
  },

  /* 
   * !#en Returns the cc.AnimationManager associated with this director.
   * !#zh 获取和 director 相关联的 cc.AnimationManager（动画管理器）。
   * @method getAnimationManager
   * @return {AnimationManager}
   */
  getAnimationManager: function getAnimationManager() {
    return this._animationManager;
  },

  /**
   * !#en Returns the cc.CollisionManager associated with this director.
   * !#zh 获取和 director 相关联的 cc.CollisionManager （碰撞管理器）。
   * @method getCollisionManager
   * @return {CollisionManager}
   */
  getCollisionManager: function getCollisionManager() {
    return this._collisionManager;
  },

  /**
   * !#en Returns the cc.PhysicsManager associated with this director.
   * !#zh 返回与 director 相关联的 cc.PhysicsManager （物理管理器）。
   * @method getPhysicsManager
   * @return {PhysicsManager}
   */
  getPhysicsManager: function getPhysicsManager() {
    return this._physicsManager;
  },

  /**
   * !#en Returns the cc.Physics3DManager associated with this director.
   * !#zh 返回与 director 相关联的 cc.Physics3DManager （物理管理器）。
   * @method getPhysics3DManager
   * @return {Physics3DManager}
   */
  getPhysics3DManager: function getPhysics3DManager() {
    return this._physics3DManager;
  },
  // Loop management

  /*
   * Starts Animation
   * @deprecated since v2.1.2
   */
  startAnimation: function startAnimation() {
    cc.game.resume();
  },

  /*
   * Stops animation
   * @deprecated since v2.1.2
   */
  stopAnimation: function stopAnimation() {
    cc.game.pause();
  },
  _resetDeltaTime: function _resetDeltaTime() {
    this._lastUpdate = performance.now();
    this._deltaTime = 0;
  },

  /*
   * Run main loop of director
   */
  mainLoop: CC_EDITOR ? function (deltaTime, updateAnimate) {
    this._deltaTime = deltaTime; // Update

    if (!this._paused) {
      this.emit(cc.Director.EVENT_BEFORE_UPDATE);

      this._compScheduler.startPhase();

      this._compScheduler.updatePhase(deltaTime);

      if (updateAnimate) {
        this._scheduler.update(deltaTime);
      }

      this._compScheduler.lateUpdatePhase(deltaTime);

      this.emit(cc.Director.EVENT_AFTER_UPDATE);
    } // Render


    this.emit(cc.Director.EVENT_BEFORE_DRAW);
    renderer.render(this._scene, deltaTime); // After draw

    this.emit(cc.Director.EVENT_AFTER_DRAW);
    this._totalFrames++;
  } : function (now) {
    if (this._purgeDirectorInNextLoop) {
      this._purgeDirectorInNextLoop = false;
      this.purgeDirector();
    } else {
      // calculate "global" dt
      this.calculateDeltaTime(now); // Update

      if (!this._paused) {
        // before update
        this.emit(cc.Director.EVENT_BEFORE_UPDATE); // Call start for new added components

        this._compScheduler.startPhase(); // Update for components


        this._compScheduler.updatePhase(this._deltaTime); // Engine update with scheduler


        this._scheduler.update(this._deltaTime); // Late update for components


        this._compScheduler.lateUpdatePhase(this._deltaTime); // After life-cycle executed


        this._compScheduler.clearup(); // User can use this event to do things after update


        this.emit(cc.Director.EVENT_AFTER_UPDATE); // Destroy entities that have been removed recently

        Obj._deferredDestroy();
      } // Render


      this.emit(cc.Director.EVENT_BEFORE_DRAW);
      renderer.render(this._scene, this._deltaTime); // After draw

      this.emit(cc.Director.EVENT_AFTER_DRAW);
      eventManager.frameUpdateListeners();
      this._totalFrames++;
    }
  },
  __fastOn: function __fastOn(type, callback, target) {
    this.on(type, callback, target);
  },
  __fastOff: function __fastOff(type, callback, target) {
    this.off(type, callback, target);
  }
}; // Event target

cc.js.addon(cc.Director.prototype, EventTarget.prototype);
/**
 * !#en The event projection changed of cc.Director. This event will not get triggered since v2.0
 * !#zh cc.Director 投影变化的事件。从 v2.0 开始这个事件不会再被触发
 * @property {String} EVENT_PROJECTION_CHANGED
 * @readonly
 * @static
 * @deprecated since v2.0
 */

cc.Director.EVENT_PROJECTION_CHANGED = "director_projection_changed";
/**
 * !#en The event which will be triggered before loading a new scene.
 * !#zh 加载新场景之前所触发的事件。
 * @event cc.Director.EVENT_BEFORE_SCENE_LOADING
 * @param {String} sceneName - The loading scene name
 */

/**
 * !#en The event which will be triggered before loading a new scene.
 * !#zh 加载新场景之前所触发的事件。
 * @property {String} EVENT_BEFORE_SCENE_LOADING
 * @readonly
 * @static
 */

cc.Director.EVENT_BEFORE_SCENE_LOADING = "director_before_scene_loading";
/*
 * !#en The event which will be triggered before launching a new scene.
 * !#zh 运行新场景之前所触发的事件。
 * @event cc.Director.EVENT_BEFORE_SCENE_LAUNCH
 * @param {String} sceneName - New scene which will be launched
 */

/**
 * !#en The event which will be triggered before launching a new scene.
 * !#zh 运行新场景之前所触发的事件。
 * @property {String} EVENT_BEFORE_SCENE_LAUNCH
 * @readonly
 * @static
 */

cc.Director.EVENT_BEFORE_SCENE_LAUNCH = "director_before_scene_launch";
/**
 * !#en The event which will be triggered after launching a new scene.
 * !#zh 运行新场景之后所触发的事件。
 * @event cc.Director.EVENT_AFTER_SCENE_LAUNCH
 * @param {String} sceneName - New scene which is launched
 */

/**
 * !#en The event which will be triggered after launching a new scene.
 * !#zh 运行新场景之后所触发的事件。
 * @property {String} EVENT_AFTER_SCENE_LAUNCH
 * @readonly
 * @static
 */

cc.Director.EVENT_AFTER_SCENE_LAUNCH = "director_after_scene_launch";
/**
 * !#en The event which will be triggered at the beginning of every frame.
 * !#zh 每个帧的开始时所触发的事件。
 * @event cc.Director.EVENT_BEFORE_UPDATE
 */

/**
 * !#en The event which will be triggered at the beginning of every frame.
 * !#zh 每个帧的开始时所触发的事件。
 * @property {String} EVENT_BEFORE_UPDATE
 * @readonly
 * @static
 */

cc.Director.EVENT_BEFORE_UPDATE = "director_before_update";
/**
 * !#en The event which will be triggered after engine and components update logic.
 * !#zh 将在引擎和组件 “update” 逻辑之后所触发的事件。
 * @event cc.Director.EVENT_AFTER_UPDATE
 */

/**
 * !#en The event which will be triggered after engine and components update logic.
 * !#zh 将在引擎和组件 “update” 逻辑之后所触发的事件。
 * @property {String} EVENT_AFTER_UPDATE
 * @readonly
 * @static
 */

cc.Director.EVENT_AFTER_UPDATE = "director_after_update";
/**
 * !#en The event is deprecated since v2.0, please use cc.Director.EVENT_BEFORE_DRAW instead
 * !#zh 这个事件从 v2.0 开始被废弃，请直接使用 cc.Director.EVENT_BEFORE_DRAW
 * @property {String} EVENT_BEFORE_VISIT
 * @readonly
 * @deprecated since v2.0
 * @static
 */

cc.Director.EVENT_BEFORE_VISIT = "director_before_draw";
/**
 * !#en The event is deprecated since v2.0, please use cc.Director.EVENT_BEFORE_DRAW instead
 * !#zh 这个事件从 v2.0 开始被废弃，请直接使用 cc.Director.EVENT_BEFORE_DRAW
 * @property {String} EVENT_AFTER_VISIT
 * @readonly
 * @deprecated since v2.0
 * @static
 */

cc.Director.EVENT_AFTER_VISIT = "director_before_draw";
/**
 * !#en The event which will be triggered before the rendering process.
 * !#zh 渲染过程之前所触发的事件。
 * @event cc.Director.EVENT_BEFORE_DRAW
 */

/**
 * !#en The event which will be triggered before the rendering process.
 * !#zh 渲染过程之前所触发的事件。
 * @property {String} EVENT_BEFORE_DRAW
 * @readonly
 * @static
 */

cc.Director.EVENT_BEFORE_DRAW = "director_before_draw";
/**
 * !#en The event which will be triggered after the rendering process.
 * !#zh 渲染过程之后所触发的事件。
 * @event cc.Director.EVENT_AFTER_DRAW
 */

/**
 * !#en The event which will be triggered after the rendering process.
 * !#zh 渲染过程之后所触发的事件。
 * @property {String} EVENT_AFTER_DRAW
 * @readonly
 * @static
 */

cc.Director.EVENT_AFTER_DRAW = "director_after_draw"; //Possible OpenGL projections used by director

/**
 * Constant for 2D projection (orthogonal projection)
 * @property {Number} PROJECTION_2D
 * @default 0
 * @readonly
 * @static
 * @deprecated since v2.0
 */

cc.Director.PROJECTION_2D = 0;
/**
 * Constant for 3D projection with a fovy=60, znear=0.5f and zfar=1500.
 * @property {Number} PROJECTION_3D
 * @default 1
 * @readonly
 * @static
 * @deprecated since v2.0
 */

cc.Director.PROJECTION_3D = 1;
/**
 * Constant for custom projection, if cc.Director's projection set to it, it calls "updateProjection" on the projection delegate.
 * @property {Number} PROJECTION_CUSTOM
 * @default 3
 * @readonly
 * @static
 * @deprecated since v2.0
 */

cc.Director.PROJECTION_CUSTOM = 3;
/**
 * Constant for default projection of cc.Director, default projection is 2D projection
 * @property {Number} PROJECTION_DEFAULT
 * @default cc.Director.PROJECTION_2D
 * @readonly
 * @static
 * @deprecated since v2.0
 */

cc.Director.PROJECTION_DEFAULT = cc.Director.PROJECTION_2D;
/**
 * The event which will be triggered before the physics process.<br/>
 * 物理过程之前所触发的事件。
 * @event Director.EVENT_BEFORE_PHYSICS
 * @readonly
 */

cc.Director.EVENT_BEFORE_PHYSICS = 'director_before_physics';
/**
 * The event which will be triggered after the physics process.<br/>
 * 物理过程之后所触发的事件。
 * @event Director.EVENT_AFTER_PHYSICS
 * @readonly
 */

cc.Director.EVENT_AFTER_PHYSICS = 'director_after_physics';
/**
 * @module cc
 */

/**
 * !#en Director
 * !#zh 导演类。
 * @property director
 * @type {Director}
 */

cc.director = new cc.Director();
module.exports = cc.director;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/CCScheduler.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

/**
 * @module cc
 */
var js = require('./platform/js');

var IdGenerater = require('./platform/id-generater');

var MAX_POOL_SIZE = 20;
var idGenerater = new IdGenerater('Scheduler'); //data structures

/*
 * A list double-linked list used for "updates with priority"
 * @class ListEntry
 * @param {Object} target not retained (retained by hashUpdateEntry)
 * @param {Number} priority
 * @param {Boolean} paused
 * @param {Boolean} markedForDeletion selector will no longer be called and entry will be removed at end of the next tick
 */

var ListEntry = function ListEntry(target, priority, paused, markedForDeletion) {
  this.target = target;
  this.priority = priority;
  this.paused = paused;
  this.markedForDeletion = markedForDeletion;
};

var _listEntries = [];

ListEntry.get = function (target, priority, paused, markedForDeletion) {
  var result = _listEntries.pop();

  if (result) {
    result.target = target;
    result.priority = priority;
    result.paused = paused;
    result.markedForDeletion = markedForDeletion;
  } else {
    result = new ListEntry(target, priority, paused, markedForDeletion);
  }

  return result;
};

ListEntry.put = function (entry) {
  if (_listEntries.length < MAX_POOL_SIZE) {
    entry.target = null;

    _listEntries.push(entry);
  }
};
/*
 * A update entry list
 * @class HashUpdateEntry
 * @param {Array} list Which list does it belong to ?
 * @param {ListEntry} entry entry in the list
 * @param {Object} target hash key (retained)
 * @param {function} callback
 */


var HashUpdateEntry = function HashUpdateEntry(list, entry, target, callback) {
  this.list = list;
  this.entry = entry;
  this.target = target;
  this.callback = callback;
};

var _hashUpdateEntries = [];

HashUpdateEntry.get = function (list, entry, target, callback) {
  var result = _hashUpdateEntries.pop();

  if (result) {
    result.list = list;
    result.entry = entry;
    result.target = target;
    result.callback = callback;
  } else {
    result = new HashUpdateEntry(list, entry, target, callback);
  }

  return result;
};

HashUpdateEntry.put = function (entry) {
  if (_hashUpdateEntries.length < MAX_POOL_SIZE) {
    entry.list = entry.entry = entry.target = entry.callback = null;

    _hashUpdateEntries.push(entry);
  }
}; //

/*
 * Hash Element used for "selectors with interval"
 * @class HashTimerEntry
 * @param {Array} timers
 * @param {Object} target  hash key (retained)
 * @param {Number} timerIndex
 * @param {Timer} currentTimer
 * @param {Boolean} currentTimerSalvaged
 * @param {Boolean} paused
 */


var HashTimerEntry = function HashTimerEntry(timers, target, timerIndex, currentTimer, currentTimerSalvaged, paused) {
  var _t = this;

  _t.timers = timers;
  _t.target = target;
  _t.timerIndex = timerIndex;
  _t.currentTimer = currentTimer;
  _t.currentTimerSalvaged = currentTimerSalvaged;
  _t.paused = paused;
};

var _hashTimerEntries = [];

HashTimerEntry.get = function (timers, target, timerIndex, currentTimer, currentTimerSalvaged, paused) {
  var result = _hashTimerEntries.pop();

  if (result) {
    result.timers = timers;
    result.target = target;
    result.timerIndex = timerIndex;
    result.currentTimer = currentTimer;
    result.currentTimerSalvaged = currentTimerSalvaged;
    result.paused = paused;
  } else {
    result = new HashTimerEntry(timers, target, timerIndex, currentTimer, currentTimerSalvaged, paused);
  }

  return result;
};

HashTimerEntry.put = function (entry) {
  if (_hashTimerEntries.length < MAX_POOL_SIZE) {
    entry.timers = entry.target = entry.currentTimer = null;

    _hashTimerEntries.push(entry);
  }
};
/*
 * Light weight timer
 * @extends cc.Class
 */


function CallbackTimer() {
  this._lock = false;
  this._scheduler = null;
  this._elapsed = -1;
  this._runForever = false;
  this._useDelay = false;
  this._timesExecuted = 0;
  this._repeat = 0;
  this._delay = 0;
  this._interval = 0;
  this._target = null;
  this._callback = null;
}

var proto = CallbackTimer.prototype;

proto.initWithCallback = function (scheduler, callback, target, seconds, repeat, delay) {
  this._lock = false;
  this._scheduler = scheduler;
  this._target = target;
  this._callback = callback;
  this._elapsed = -1;
  this._interval = seconds;
  this._delay = delay;
  this._useDelay = this._delay > 0;
  this._repeat = repeat;
  this._runForever = this._repeat === cc.macro.REPEAT_FOREVER;
  return true;
};
/**
 * @return {Number} returns interval of timer
 */


proto.getInterval = function () {
  return this._interval;
};
/**
 * @param {Number} interval set interval in seconds
 */


proto.setInterval = function (interval) {
  this._interval = interval;
};
/**
 * triggers the timer
 * @param {Number} dt delta time
 */


proto.update = function (dt) {
  if (this._elapsed === -1) {
    this._elapsed = 0;
    this._timesExecuted = 0;
  } else {
    this._elapsed += dt;

    if (this._runForever && !this._useDelay) {
      //standard timer usage
      if (this._elapsed >= this._interval) {
        this.trigger();
        this._elapsed = 0;
      }
    } else {
      //advanced usage
      if (this._useDelay) {
        if (this._elapsed >= this._delay) {
          this.trigger();
          this._elapsed -= this._delay;
          this._timesExecuted += 1;
          this._useDelay = false;
        }
      } else {
        if (this._elapsed >= this._interval) {
          this.trigger();
          this._elapsed = 0;
          this._timesExecuted += 1;
        }
      }

      if (this._callback && !this._runForever && this._timesExecuted > this._repeat) this.cancel();
    }
  }
};

proto.getCallback = function () {
  return this._callback;
};

proto.trigger = function () {
  if (this._target && this._callback) {
    this._lock = true;

    this._callback.call(this._target, this._elapsed);

    this._lock = false;
  }
};

proto.cancel = function () {
  //override
  this._scheduler.unschedule(this._callback, this._target);
};

var _timers = [];

CallbackTimer.get = function () {
  return _timers.pop() || new CallbackTimer();
};

CallbackTimer.put = function (timer) {
  if (_timers.length < MAX_POOL_SIZE && !timer._lock) {
    timer._scheduler = timer._target = timer._callback = null;

    _timers.push(timer);
  }
};
/**
 * !#en
 * Scheduler is responsible of triggering the scheduled callbacks.<br/>
 * You should not use NSTimer. Instead use this class.<br/>
 * <br/>
 * There are 2 different types of callbacks (selectors):<br/>
 *     - update callback: the 'update' callback will be called every frame. You can customize the priority.<br/>
 *     - custom callback: A custom callback will be called every frame, or with a custom interval of time<br/>
 * <br/>
 * The 'custom selectors' should be avoided when possible. It is faster,
 * and consumes less memory to use the 'update callback'. *
 * !#zh
 * Scheduler 是负责触发回调函数的类。<br/>
 * 通常情况下，建议使用 cc.director.getScheduler() 来获取系统定时器。<br/>
 * 有两种不同类型的定时器：<br/>
 *     - update 定时器：每一帧都会触发。您可以自定义优先级。<br/>
 *     - 自定义定时器：自定义定时器可以每一帧或者自定义的时间间隔触发。<br/>
 * 如果希望每帧都触发，应该使用 update 定时器，使用 update 定时器更快，而且消耗更少的内存。
 *
 * @class Scheduler
 */


cc.Scheduler = function () {
  this._timeScale = 1.0;
  this._updatesNegList = []; // list of priority < 0

  this._updates0List = []; // list of priority == 0

  this._updatesPosList = []; // list of priority > 0

  this._hashForUpdates = js.createMap(true); // hash used to fetch quickly the list entries for pause, delete, etc

  this._hashForTimers = js.createMap(true); // Used for "selectors with interval"

  this._currentTarget = null;
  this._currentTargetSalvaged = false;
  this._updateHashLocked = false; // If true unschedule will not remove anything from a hash. Elements will only be marked for deletion.

  this._arrayForTimers = []; // Speed up indexing
  //this._arrayForUpdates = [];   // Speed up indexing
};

cc.Scheduler.prototype = {
  constructor: cc.Scheduler,
  //-----------------------private method----------------------
  _removeHashElement: function _removeHashElement(element) {
    delete this._hashForTimers[element.target._id];
    var arr = this._arrayForTimers;

    for (var i = 0, l = arr.length; i < l; i++) {
      if (arr[i] === element) {
        arr.splice(i, 1);
        break;
      }
    }

    HashTimerEntry.put(element);
  },
  _removeUpdateFromHash: function _removeUpdateFromHash(entry) {
    var targetId = entry.target._id;
    var self = this,
        element = self._hashForUpdates[targetId];

    if (element) {
      // Remove list entry from list
      var list = element.list,
          listEntry = element.entry;

      for (var i = 0, l = list.length; i < l; i++) {
        if (list[i] === listEntry) {
          list.splice(i, 1);
          break;
        }
      }

      delete self._hashForUpdates[targetId];
      ListEntry.put(listEntry);
      HashUpdateEntry.put(element);
    }
  },
  _priorityIn: function _priorityIn(ppList, listElement, priority) {
    for (var i = 0; i < ppList.length; i++) {
      if (priority < ppList[i].priority) {
        ppList.splice(i, 0, listElement);
        return;
      }
    }

    ppList.push(listElement);
  },
  _appendIn: function _appendIn(ppList, listElement) {
    ppList.push(listElement);
  },
  //-----------------------public method-------------------------

  /**
   * !#en This method should be called for any target which needs to schedule tasks, and this method should be called before any scheduler API usage.
   * This method will add a `_id` property if it doesn't exist.
   * !#zh 任何需要用 Scheduler 管理任务的对象主体都应该调用这个方法，并且应该在调用任何 Scheduler API 之前调用这个方法。
   * 这个方法会给对象添加一个 `_id` 属性，如果这个属性不存在的话。
   * @method enableForTarget
   * @param {Object} target
   */
  enableForTarget: function enableForTarget(target) {
    if (!target._id) {
      if (target.__instanceId) {
        cc.warnID(1513);
      } else {
        target._id = idGenerater.getNewId();
      }
    }
  },

  /**
   * !#en
   * Modifies the time of all scheduled callbacks.<br/>
   * You can use this property to create a 'slow motion' or 'fast forward' effect.<br/>
   * Default is 1.0. To create a 'slow motion' effect, use values below 1.0.<br/>
   * To create a 'fast forward' effect, use values higher than 1.0.<br/>
   * Note：It will affect EVERY scheduled selector / action.
   * !#zh
   * 设置时间间隔的缩放比例。<br/>
   * 您可以使用这个方法来创建一个 “slow motion（慢动作）” 或 “fast forward（快进）” 的效果。<br/>
   * 默认是 1.0。要创建一个 “slow motion（慢动作）” 效果,使用值低于 1.0。<br/>
   * 要使用 “fast forward（快进）” 效果，使用值大于 1.0。<br/>
   * 注意：它影响该 Scheduler 下管理的所有定时器。
   * @method setTimeScale
   * @param {Number} timeScale
   */
  setTimeScale: function setTimeScale(timeScale) {
    this._timeScale = timeScale;
  },

  /**
   * !#en Returns time scale of scheduler.
   * !#zh 获取时间间隔的缩放比例。
   * @method getTimeScale
   * @return {Number}
   */
  getTimeScale: function getTimeScale() {
    return this._timeScale;
  },

  /**
   * !#en 'update' the scheduler. (You should NEVER call this method, unless you know what you are doing.)
   * !#zh update 调度函数。(不应该直接调用这个方法，除非完全了解这么做的结果)
   * @method update
   * @param {Number} dt delta time
   */
  update: function update(dt) {
    this._updateHashLocked = true;
    if (this._timeScale !== 1) dt *= this._timeScale;
    var i, list, len, entry;

    for (i = 0, list = this._updatesNegList, len = list.length; i < len; i++) {
      entry = list[i];
      if (!entry.paused && !entry.markedForDeletion) entry.target.update(dt);
    }

    for (i = 0, list = this._updates0List, len = list.length; i < len; i++) {
      entry = list[i];
      if (!entry.paused && !entry.markedForDeletion) entry.target.update(dt);
    }

    for (i = 0, list = this._updatesPosList, len = list.length; i < len; i++) {
      entry = list[i];
      if (!entry.paused && !entry.markedForDeletion) entry.target.update(dt);
    } // Iterate over all the custom selectors


    var elt,
        arr = this._arrayForTimers;

    for (i = 0; i < arr.length; i++) {
      elt = arr[i];
      this._currentTarget = elt;
      this._currentTargetSalvaged = false;

      if (!elt.paused) {
        // The 'timers' array may change while inside this loop
        for (elt.timerIndex = 0; elt.timerIndex < elt.timers.length; ++elt.timerIndex) {
          elt.currentTimer = elt.timers[elt.timerIndex];
          elt.currentTimerSalvaged = false;
          elt.currentTimer.update(dt);
          elt.currentTimer = null;
        }
      } // only delete currentTarget if no actions were scheduled during the cycle (issue #481)


      if (this._currentTargetSalvaged && this._currentTarget.timers.length === 0) {
        this._removeHashElement(this._currentTarget);

        --i;
      }
    } // delete all updates that are marked for deletion
    // updates with priority < 0


    for (i = 0, list = this._updatesNegList; i < list.length;) {
      entry = list[i];
      if (entry.markedForDeletion) this._removeUpdateFromHash(entry);else i++;
    }

    for (i = 0, list = this._updates0List; i < list.length;) {
      entry = list[i];
      if (entry.markedForDeletion) this._removeUpdateFromHash(entry);else i++;
    }

    for (i = 0, list = this._updatesPosList; i < list.length;) {
      entry = list[i];
      if (entry.markedForDeletion) this._removeUpdateFromHash(entry);else i++;
    }

    this._updateHashLocked = false;
    this._currentTarget = null;
  },

  /**
   * !#en
   * <p>
   *   The scheduled method will be called every 'interval' seconds.<br/>
   *   If paused is YES, then it won't be called until it is resumed.<br/>
   *   If 'interval' is 0, it will be called every frame, but if so, it recommended to use 'scheduleUpdateForTarget:' instead.<br/>
   *   If the callback function is already scheduled, then only the interval parameter will be updated without re-scheduling it again.<br/>
   *   repeat let the action be repeated repeat + 1 times, use cc.macro.REPEAT_FOREVER to let the action run continuously<br/>
   *   delay is the amount of time the action will wait before it'll start<br/>
   * </p>
   * !#zh
   * 指定回调函数，调用对象等信息来添加一个新的定时器。<br/>
   * 如果 paused 值为 true，那么直到 resume 被调用才开始计时。<br/>
   * 当时间间隔达到指定值时，设置的回调函数将会被调用。<br/>
   * 如果 interval 值为 0，那么回调函数每一帧都会被调用，但如果是这样，
   * 建议使用 scheduleUpdateForTarget 代替。<br/>
   * 如果回调函数已经被定时器使用，那么只会更新之前定时器的时间间隔参数，不会设置新的定时器。<br/>
   * repeat 值可以让定时器触发 repeat + 1 次，使用 cc.macro.REPEAT_FOREVER
   * 可以让定时器一直循环触发。<br/>
   * delay 值指定延迟时间，定时器会在延迟指定的时间之后开始计时。
   * @method schedule
   * @param {Function} callback
   * @param {Object} target
   * @param {Number} interval
   * @param {Number} [repeat=cc.macro.REPEAT_FOREVER]
   * @param {Number} [delay=0]
   * @param {Boolean} paused
   * @example {@link cocos2d/core/CCScheduler/schedule.js}
   * @typescript
   * schedule(callback: Function, target: any, interval: number, repeat: number, delay: number, paused?: boolean): void
   * schedule(callback: Function, target: any, interval: number, paused?: boolean): void
   */
  schedule: function schedule(callback, target, interval, repeat, delay, paused) {
    'use strict';

    if (typeof callback !== 'function') {
      var tmp = callback;
      callback = target;
      target = tmp;
    } //selector, target, interval, repeat, delay, paused
    //selector, target, interval, paused


    if (arguments.length === 4 || arguments.length === 5) {
      paused = !!repeat;
      repeat = cc.macro.REPEAT_FOREVER;
      delay = 0;
    }

    cc.assertID(target, 1502);
    var targetId = target._id;

    if (!targetId) {
      if (target.__instanceId) {
        cc.warnID(1513);
        targetId = target._id = target.__instanceId;
      } else {
        cc.errorID(1510);
      }
    }

    var element = this._hashForTimers[targetId];

    if (!element) {
      // Is this the 1st element ? Then set the pause level to all the callback_fns of this target
      element = HashTimerEntry.get(null, target, 0, null, null, paused);

      this._arrayForTimers.push(element);

      this._hashForTimers[targetId] = element;
    } else if (element.paused !== paused) {
      cc.warnID(1511);
    }

    var timer, i;

    if (element.timers == null) {
      element.timers = [];
    } else {
      for (i = 0; i < element.timers.length; ++i) {
        timer = element.timers[i];

        if (timer && callback === timer._callback) {
          cc.logID(1507, timer.getInterval(), interval);
          timer._interval = interval;
          return;
        }
      }
    }

    timer = CallbackTimer.get();
    timer.initWithCallback(this, callback, target, interval, repeat, delay);
    element.timers.push(timer);

    if (this._currentTarget === element && this._currentTargetSalvaged) {
      this._currentTargetSalvaged = false;
    }
  },

  /**
   * !#en
   * Schedules the update callback for a given target,
   * During every frame after schedule started, the "update" function of target will be invoked.
   * !#zh
   * 使用指定的优先级为指定的对象设置 update 定时器。
   * update 定时器每一帧都会被触发，触发时自动调用指定对象的 "update" 函数。
   * 优先级的值越低，定时器被触发的越早。
   * @method scheduleUpdate
   * @param {Object} target
   * @param {Number} priority
   * @param {Boolean} paused
   */
  scheduleUpdate: function scheduleUpdate(target, priority, paused) {
    var targetId = target._id;

    if (!targetId) {
      if (target.__instanceId) {
        cc.warnID(1513);
        targetId = target._id = target.__instanceId;
      } else {
        cc.errorID(1510);
      }
    }

    var hashElement = this._hashForUpdates[targetId];

    if (hashElement && hashElement.entry) {
      // check if priority has changed
      if (hashElement.entry.priority !== priority) {
        if (this._updateHashLocked) {
          cc.logID(1506);
          hashElement.entry.markedForDeletion = false;
          hashElement.entry.paused = paused;
          return;
        } else {
          // will be added again outside if (hashElement).
          this.unscheduleUpdate(target);
        }
      } else {
        hashElement.entry.markedForDeletion = false;
        hashElement.entry.paused = paused;
        return;
      }
    }

    var listElement = ListEntry.get(target, priority, paused, false);
    var ppList; // most of the updates are going to be 0, that's way there
    // is an special list for updates with priority 0

    if (priority === 0) {
      ppList = this._updates0List;

      this._appendIn(ppList, listElement);
    } else {
      ppList = priority < 0 ? this._updatesNegList : this._updatesPosList;

      this._priorityIn(ppList, listElement, priority);
    } //update hash entry for quick access


    this._hashForUpdates[targetId] = HashUpdateEntry.get(ppList, listElement, target, null);
  },

  /**
   * !#en
   * Unschedules a callback for a callback and a given target.
   * If you want to unschedule the "update", use `unscheduleUpdate()`
   * !#zh
   * 取消指定对象定时器。
   * 如果需要取消 update 定时器，请使用 unscheduleUpdate()。
   * @method unschedule
   * @param {Function} callback The callback to be unscheduled
   * @param {Object} target The target bound to the callback.
   */
  unschedule: function unschedule(callback, target) {
    //callback, target
    // explicity handle nil arguments when removing an object
    if (!target || !callback) return;
    var targetId = target._id;

    if (!targetId) {
      if (target.__instanceId) {
        cc.warnID(1513);
        targetId = target._id = target.__instanceId;
      } else {
        cc.errorID(1510);
      }
    }

    var self = this,
        element = self._hashForTimers[targetId];

    if (element) {
      var timers = element.timers;

      for (var i = 0, li = timers.length; i < li; i++) {
        var timer = timers[i];

        if (callback === timer._callback) {
          if (timer === element.currentTimer && !element.currentTimerSalvaged) {
            element.currentTimerSalvaged = true;
          }

          timers.splice(i, 1);
          CallbackTimer.put(timer); //update timerIndex in case we are in tick;, looping over the actions

          if (element.timerIndex >= i) {
            element.timerIndex--;
          }

          if (timers.length === 0) {
            if (self._currentTarget === element) {
              self._currentTargetSalvaged = true;
            } else {
              self._removeHashElement(element);
            }
          }

          return;
        }
      }
    }
  },

  /** 
   * !#en Unschedules the update callback for a given target.
   * !#zh 取消指定对象的 update 定时器。
   * @method unscheduleUpdate
   * @param {Object} target The target to be unscheduled.
   */
  unscheduleUpdate: function unscheduleUpdate(target) {
    if (!target) return;
    var targetId = target._id;

    if (!targetId) {
      if (target.__instanceId) {
        cc.warnID(1513);
        targetId = target._id = target.__instanceId;
      } else {
        cc.errorID(1510);
      }
    }

    var element = this._hashForUpdates[targetId];

    if (element) {
      if (this._updateHashLocked) {
        element.entry.markedForDeletion = true;
      } else {
        this._removeUpdateFromHash(element.entry);
      }
    }
  },

  /** 
   * !#en
   * Unschedules all scheduled callbacks for a given target.
   * This also includes the "update" callback.
   * !#zh 取消指定对象的所有定时器，包括 update 定时器。
   * @method unscheduleAllForTarget
   * @param {Object} target The target to be unscheduled.
   */
  unscheduleAllForTarget: function unscheduleAllForTarget(target) {
    // explicit nullptr handling
    if (!target) {
      return;
    }

    var targetId = target._id;

    if (!targetId) {
      if (target.__instanceId) {
        cc.warnID(1513);
        targetId = target._id = target.__instanceId;
      } else {
        cc.errorID(1510);
      }
    } // Custom Selectors


    var element = this._hashForTimers[targetId];

    if (element) {
      var timers = element.timers;

      if (timers.indexOf(element.currentTimer) > -1 && !element.currentTimerSalvaged) {
        element.currentTimerSalvaged = true;
      }

      for (var i = 0, l = timers.length; i < l; i++) {
        CallbackTimer.put(timers[i]);
      }

      timers.length = 0;

      if (this._currentTarget === element) {
        this._currentTargetSalvaged = true;
      } else {
        this._removeHashElement(element);
      }
    } // update selector


    this.unscheduleUpdate(target);
  },

  /**
   * !#en
   * Unschedules all scheduled callbacks from all targets including the system callbacks.<br/>
   * You should NEVER call this method, unless you know what you are doing.
   * !#zh
   * 取消所有对象的所有定时器，包括系统定时器。<br/>
   * 不用调用此函数，除非你确定你在做什么。
   * @method unscheduleAll
   */
  unscheduleAll: function unscheduleAll() {
    this.unscheduleAllWithMinPriority(cc.Scheduler.PRIORITY_SYSTEM);
  },

  /**
   * !#en
   * Unschedules all callbacks from all targets with a minimum priority.<br/>
   * You should only call this with `PRIORITY_NON_SYSTEM_MIN` or higher.
   * !#zh
   * 取消所有优先级的值大于指定优先级的定时器。<br/>
   * 你应该只取消优先级的值大于 PRIORITY_NON_SYSTEM_MIN 的定时器。
   * @method unscheduleAllWithMinPriority
   * @param {Number} minPriority The minimum priority of selector to be unscheduled. Which means, all selectors which
   *        priority is higher than minPriority will be unscheduled.
   */
  unscheduleAllWithMinPriority: function unscheduleAllWithMinPriority(minPriority) {
    // Custom Selectors
    var i,
        element,
        arr = this._arrayForTimers;

    for (i = arr.length - 1; i >= 0; i--) {
      element = arr[i];
      this.unscheduleAllForTarget(element.target);
    } // Updates selectors


    var entry;
    var temp_length = 0;

    if (minPriority < 0) {
      for (i = 0; i < this._updatesNegList.length;) {
        temp_length = this._updatesNegList.length;
        entry = this._updatesNegList[i];
        if (entry && entry.priority >= minPriority) this.unscheduleUpdate(entry.target);
        if (temp_length == this._updatesNegList.length) i++;
      }
    }

    if (minPriority <= 0) {
      for (i = 0; i < this._updates0List.length;) {
        temp_length = this._updates0List.length;
        entry = this._updates0List[i];
        if (entry) this.unscheduleUpdate(entry.target);
        if (temp_length == this._updates0List.length) i++;
      }
    }

    for (i = 0; i < this._updatesPosList.length;) {
      temp_length = this._updatesPosList.length;
      entry = this._updatesPosList[i];
      if (entry && entry.priority >= minPriority) this.unscheduleUpdate(entry.target);
      if (temp_length == this._updatesPosList.length) i++;
    }
  },

  /** 
   * !#en Checks whether a callback for a given target is scheduled.
   * !#zh 检查指定的回调函数和回调对象组合是否存在定时器。
   * @method isScheduled
   * @param {Function} callback The callback to check.
   * @param {Object} target The target of the callback.
   * @return {Boolean} True if the specified callback is invoked, false if not.
   */
  isScheduled: function isScheduled(callback, target) {
    //key, target
    //selector, target
    cc.assertID(callback, 1508);
    cc.assertID(target, 1509);
    var targetId = target._id;

    if (!targetId) {
      if (target.__instanceId) {
        cc.warnID(1513);
        targetId = target._id = target.__instanceId;
      } else {
        cc.errorID(1510);
      }
    }

    var element = this._hashForTimers[targetId];

    if (!element) {
      return false;
    }

    if (element.timers == null) {
      return false;
    } else {
      var timers = element.timers;

      for (var i = 0; i < timers.length; ++i) {
        var timer = timers[i];

        if (callback === timer._callback) {
          return true;
        }
      }

      return false;
    }
  },

  /**
   * !#en
   * Pause all selectors from all targets.<br/>
   * You should NEVER call this method, unless you know what you are doing.
   * !#zh
   * 暂停所有对象的所有定时器。<br/>
   * 不要调用这个方法，除非你知道你正在做什么。
   * @method pauseAllTargets
   */
  pauseAllTargets: function pauseAllTargets() {
    return this.pauseAllTargetsWithMinPriority(cc.Scheduler.PRIORITY_SYSTEM);
  },

  /**
   * !#en
   * Pause all selectors from all targets with a minimum priority. <br/>
   * You should only call this with kCCPriorityNonSystemMin or higher.
   * !#zh
   * 暂停所有优先级的值大于指定优先级的定时器。<br/>
   * 你应该只暂停优先级的值大于 PRIORITY_NON_SYSTEM_MIN 的定时器。
   * @method pauseAllTargetsWithMinPriority
   * @param {Number} minPriority
   */
  pauseAllTargetsWithMinPriority: function pauseAllTargetsWithMinPriority(minPriority) {
    var idsWithSelectors = [];
    var self = this,
        element,
        locArrayForTimers = self._arrayForTimers;
    var i, li; // Custom Selectors

    for (i = 0, li = locArrayForTimers.length; i < li; i++) {
      element = locArrayForTimers[i];

      if (element) {
        element.paused = true;
        idsWithSelectors.push(element.target);
      }
    }

    var entry;

    if (minPriority < 0) {
      for (i = 0; i < this._updatesNegList.length; i++) {
        entry = this._updatesNegList[i];

        if (entry) {
          if (entry.priority >= minPriority) {
            entry.paused = true;
            idsWithSelectors.push(entry.target);
          }
        }
      }
    }

    if (minPriority <= 0) {
      for (i = 0; i < this._updates0List.length; i++) {
        entry = this._updates0List[i];

        if (entry) {
          entry.paused = true;
          idsWithSelectors.push(entry.target);
        }
      }
    }

    for (i = 0; i < this._updatesPosList.length; i++) {
      entry = this._updatesPosList[i];

      if (entry) {
        if (entry.priority >= minPriority) {
          entry.paused = true;
          idsWithSelectors.push(entry.target);
        }
      }
    }

    return idsWithSelectors;
  },

  /**
   * !#en
   * Resume selectors on a set of targets.<br/>
   * This can be useful for undoing a call to pauseAllCallbacks.
   * !#zh
   * 恢复指定数组中所有对象的定时器。<br/>
   * 这个函数是 pauseAllCallbacks 的逆操作。
   * @method resumeTargets
   * @param {Array} targetsToResume
   */
  resumeTargets: function resumeTargets(targetsToResume) {
    if (!targetsToResume) return;

    for (var i = 0; i < targetsToResume.length; i++) {
      this.resumeTarget(targetsToResume[i]);
    }
  },

  /**
   * !#en
   * Pauses the target.<br/>
   * All scheduled selectors/update for a given target won't be 'ticked' until the target is resumed.<br/>
   * If the target is not present, nothing happens.
   * !#zh
   * 暂停指定对象的定时器。<br/>
   * 指定对象的所有定时器都会被暂停。<br/>
   * 如果指定的对象没有定时器，什么也不会发生。
   * @method pauseTarget
   * @param {Object} target
   */
  pauseTarget: function pauseTarget(target) {
    cc.assertID(target, 1503);
    var targetId = target._id;

    if (!targetId) {
      if (target.__instanceId) {
        cc.warnID(1513);
        targetId = target._id = target.__instanceId;
      } else {
        cc.errorID(1510);
      }
    } //customer selectors


    var self = this,
        element = self._hashForTimers[targetId];

    if (element) {
      element.paused = true;
    } //update callback


    var elementUpdate = self._hashForUpdates[targetId];

    if (elementUpdate) {
      elementUpdate.entry.paused = true;
    }
  },

  /**
   * !#en
   * Resumes the target.<br/>
   * The 'target' will be unpaused, so all schedule selectors/update will be 'ticked' again.<br/>
   * If the target is not present, nothing happens.
   * !#zh
   * 恢复指定对象的所有定时器。<br/>
   * 指定对象的所有定时器将继续工作。<br/>
   * 如果指定的对象没有定时器，什么也不会发生。
   * @method resumeTarget
   * @param {Object} target
   */
  resumeTarget: function resumeTarget(target) {
    cc.assertID(target, 1504);
    var targetId = target._id;

    if (!targetId) {
      if (target.__instanceId) {
        cc.warnID(1513);
        targetId = target._id = target.__instanceId;
      } else {
        cc.errorID(1510);
      }
    } // custom selectors


    var self = this,
        element = self._hashForTimers[targetId];

    if (element) {
      element.paused = false;
    } //update callback


    var elementUpdate = self._hashForUpdates[targetId];

    if (elementUpdate) {
      elementUpdate.entry.paused = false;
    }
  },

  /**
   * !#en Returns whether or not the target is paused.
   * !#zh 返回指定对象的定时器是否暂停了。
   * @method isTargetPaused
   * @param {Object} target
   * @return {Boolean}
   */
  isTargetPaused: function isTargetPaused(target) {
    cc.assertID(target, 1505);
    var targetId = target._id;

    if (!targetId) {
      if (target.__instanceId) {
        cc.warnID(1513);
        targetId = target._id = target.__instanceId;
      } else {
        cc.errorID(1510);
      }
    } // Custom selectors


    var element = this._hashForTimers[targetId];

    if (element) {
      return element.paused;
    }

    var elementUpdate = this._hashForUpdates[targetId];

    if (elementUpdate) {
      return elementUpdate.entry.paused;
    }

    return false;
  }
};
/**
 * !#en Priority level reserved for system services.
 * !#zh 系统服务的优先级。
 * @property PRIORITY_SYSTEM
 * @type {Number}
 * @static
 */

cc.Scheduler.PRIORITY_SYSTEM = 1 << 31;
/**
 * !#en Minimum priority level for user scheduling.
 * !#zh 用户调度最低优先级。
 * @property PRIORITY_NON_SYSTEM
 * @type {Number}
 * @static
 */

cc.Scheduler.PRIORITY_NON_SYSTEM = cc.Scheduler.PRIORITY_SYSTEM + 1;
module.exports = cc.Scheduler;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/tilemap/index.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/
 
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
require('./CCTiledMap');

require('./CCTiledMapRenderDataList');

require('./tiledmap-buffer');

require('./tmx-layer-assembler');
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/platform/CCMacro.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2008-2010 Ricardo Quesada
 Copyright (c) 2011-2012 cocos2d-x.org
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

/**
 * Predefined constants
 * @class macro
 * @static
 */
cc.macro = {
  /**
   * PI / 180
   * @property RAD
   * @type {Number}
   */
  RAD: Math.PI / 180,

  /**
   * One degree
   * @property DEG
   * @type {Number}
   */
  DEG: 180 / Math.PI,

  /**
   * @property REPEAT_FOREVER
   * @type {Number}
   */
  REPEAT_FOREVER: Number.MAX_VALUE - 1,

  /**
   * @property FLT_EPSILON
   * @type {Number}
   */
  FLT_EPSILON: 0.0000001192092896,

  /**
   * Minimum z index value for node
   * @property MIN_ZINDEX
   * @type {Number}
   */
  MIN_ZINDEX: -Math.pow(2, 15),

  /**
   * Maximum z index value for node
   * @property MAX_ZINDEX
   * @type {Number}
   */
  MAX_ZINDEX: Math.pow(2, 15) - 1,
  //some gl constant variable

  /**
   * @property ONE
   * @type {Number}
   */
  ONE: 1,

  /**
   * @property ZERO
   * @type {Number}
   */
  ZERO: 0,

  /**
   * @property SRC_ALPHA
   * @type {Number}
   */
  SRC_ALPHA: 0x0302,

  /**
   * @property SRC_ALPHA_SATURATE
   * @type {Number}
   */
  SRC_ALPHA_SATURATE: 0x308,

  /**
   * @property SRC_COLOR
   * @type {Number}
   */
  SRC_COLOR: 0x300,

  /**
   * @property DST_ALPHA
   * @type {Number}
   */
  DST_ALPHA: 0x304,

  /**
   * @property DST_COLOR
   * @type {Number}
   */
  DST_COLOR: 0x306,

  /**
   * @property ONE_MINUS_SRC_ALPHA
   * @type {Number}
   */
  ONE_MINUS_SRC_ALPHA: 0x0303,

  /**
   * @property ONE_MINUS_SRC_COLOR
   * @type {Number}
   */
  ONE_MINUS_SRC_COLOR: 0x301,

  /**
   * @property ONE_MINUS_DST_ALPHA
   * @type {Number}
   */
  ONE_MINUS_DST_ALPHA: 0x305,

  /**
   * @property ONE_MINUS_DST_COLOR
   * @type {Number}
   */
  ONE_MINUS_DST_COLOR: 0x0307,

  /**
   * @property ONE_MINUS_CONSTANT_ALPHA
   * @type {Number}
   */
  ONE_MINUS_CONSTANT_ALPHA: 0x8004,

  /**
   * @property ONE_MINUS_CONSTANT_COLOR
   * @type {Number}
   */
  ONE_MINUS_CONSTANT_COLOR: 0x8002,
  //Possible device orientations

  /**
   * Oriented vertically
   * @property ORIENTATION_PORTRAIT
   * @type {Number}
   */
  ORIENTATION_PORTRAIT: 1,

  /**
   * Oriented horizontally
   * @property ORIENTATION_LANDSCAPE
   * @type {Number}
   */
  ORIENTATION_LANDSCAPE: 2,

  /**
   * Oriented automatically
   * @property ORIENTATION_AUTO
   * @type {Number}
   */
  ORIENTATION_AUTO: 3,
  DENSITYDPI_DEVICE: 'device-dpi',
  DENSITYDPI_HIGH: 'high-dpi',
  DENSITYDPI_MEDIUM: 'medium-dpi',
  DENSITYDPI_LOW: 'low-dpi',
  // General configurations

  /**
   * <p>
   *   If enabled, the texture coordinates will be calculated by using this formula: <br/>
   *      - texCoord.left = (rect.x*2+1) / (texture.wide*2);                  <br/>
   *      - texCoord.right = texCoord.left + (rect.width*2-2)/(texture.wide*2); <br/>
   *                                                                                 <br/>
   *  The same for bottom and top.                                                   <br/>
   *                                                                                 <br/>
   *  This formula prevents artifacts by using 99% of the texture.                   <br/>
   *  The "correct" way to prevent artifacts is by expand the texture's border with the same color by 1 pixel<br/>
   *                                                                                  <br/>
   *  Affected component:                                                                 <br/>
   *      - cc.TMXLayer                                                       <br/>
   *                                                                                  <br/>
   *  Enabled by default. To disabled set it to 0. <br/>
   *  To modify it, in Web engine please refer to CCMacro.js, in JSB please refer to CCConfig.h
   * </p>
   *
   * @property {Number} FIX_ARTIFACTS_BY_STRECHING_TEXEL_TMX
   */
  FIX_ARTIFACTS_BY_STRECHING_TEXEL_TMX: true,

  /**
   * Position of the FPS (Default: 0,0 (bottom-left corner))<br/>
   * To modify it, in Web engine please refer to CCMacro.js, in JSB please refer to CCConfig.h
   * @property {Vec2} DIRECTOR_STATS_POSITION
   */
  DIRECTOR_STATS_POSITION: cc.v2(0, 0),

  /**
   * <p>
   *    If enabled, actions that alter the position property (eg: CCMoveBy, CCJumpBy, CCBezierBy, etc..) will be stacked.                  <br/>
   *    If you run 2 or more 'position' actions at the same time on a node, then end position will be the sum of all the positions.        <br/>
   *    If disabled, only the last run action will take effect.
   * </p>
   * @property {Number} ENABLE_STACKABLE_ACTIONS
   */
  ENABLE_STACKABLE_ACTIONS: true,

  /**
   * !#en 
   * The timeout to determine whether a touch is no longer active and should be removed.
   * The reason to add this timeout is due to an issue in X5 browser core, 
   * when X5 is presented in wechat on Android, if a touch is glissed from the bottom up, and leave the page area,
   * no touch cancel event is triggered, and the touch will be considered active forever. 
   * After multiple times of this action, our maximum touches number will be reached and all new touches will be ignored.
   * So this new mechanism can remove the touch that should be inactive if it's not updated during the last 5000 milliseconds.
   * Though it might remove a real touch if it's just not moving for the last 5 seconds which is not easy with the sensibility of mobile touch screen.
   * You can modify this value to have a better behavior if you find it's not enough.
   * !#zh
   * 用于甄别一个触点对象是否已经失效并且可以被移除的延时时长
   * 添加这个时长的原因是 X5 内核在微信浏览器中出现的一个 bug。
   * 在这个环境下，如果用户将一个触点从底向上移出页面区域，将不会触发任何 touch cancel 或 touch end 事件，而这个触点会被永远当作停留在页面上的有效触点。
   * 重复这样操作几次之后，屏幕上的触点数量将达到我们的事件系统所支持的最高触点数量，之后所有的触摸事件都将被忽略。
   * 所以这个新的机制可以在触点在一定时间内没有任何更新的情况下视为失效触点并从事件系统中移除。
   * 当然，这也可能移除一个真实的触点，如果用户的触点真的在一定时间段内完全没有移动（这在当前手机屏幕的灵敏度下会很难）。
   * 你可以修改这个值来获得你需要的效果，默认值是 5000 毫秒。
   * @property {Number} TOUCH_TIMEOUT
   */
  TOUCH_TIMEOUT: 5000,

  /**
   * !#en 
   * The maximum vertex count for a single batched draw call.
   * !#zh
   * 最大可以被单次批处理渲染的顶点数量。
   * @property {Number} BATCH_VERTEX_COUNT
   */
  BATCH_VERTEX_COUNT: 20000,

  /**
   * !#en 
   * Whether or not enabled tiled map auto culling. If you set the TiledMap skew or rotation, then need to manually disable this, otherwise, the rendering will be wrong.
   * !#zh
   * 是否开启瓦片地图的自动裁减功能。瓦片地图如果设置了 skew, rotation 或者采用了摄像机的话，需要手动关闭，否则渲染会出错。
   * @property {Boolean} ENABLE_TILEDMAP_CULLING
   * @default true
   */
  ENABLE_TILEDMAP_CULLING: true,

  /**
   * !#en 
   * The max concurrent task number for the downloader
   * !#zh
   * 下载任务的最大并发数限制，在安卓平台部分机型或版本上可能需要限制在较低的水平
   * @property {Number} DOWNLOAD_MAX_CONCURRENT
   * @default 64
   */
  DOWNLOAD_MAX_CONCURRENT: 64,

  /**
   * !#en 
   * Boolean that indicates if the canvas contains an alpha channel, default sets to false for better performance.
   * Though if you want to make your canvas background transparent and show other dom elements at the background, 
   * you can set it to true before `cc.game.run`.
   * Web only.
   * !#zh
   * 用于设置 Canvas 背景是否支持 alpha 通道，默认为 false，这样可以有更高的性能表现。
   * 如果你希望 Canvas 背景是透明的，并显示背后的其他 DOM 元素，你可以在 `cc.game.run` 之前将这个值设为 true。
   * 仅支持 Web
   * @property {Boolean} ENABLE_TRANSPARENT_CANVAS
   * @default false
   */
  ENABLE_TRANSPARENT_CANVAS: false,

  /**
   * !#en
   * Boolean that indicates if the WebGL context is created with `antialias` option turned on, default value is false.
   * Set it to true could make your game graphics slightly smoother, like texture hard edges when rotated.
   * Whether to use this really depend on your game design and targeted platform, 
   * device with retina display usually have good detail on graphics with or without this option, 
   * you probably don't want antialias if your game style is pixel art based.
   * Also, it could have great performance impact with some browser / device using software MSAA.
   * You can set it to true before `cc.game.run`.
   * Web only.
   * !#zh
   * 用于设置在创建 WebGL Context 时是否开启抗锯齿选项，默认值是 false。
   * 将这个选项设置为 true 会让你的游戏画面稍稍平滑一些，比如旋转硬边贴图时的锯齿。是否开启这个选项很大程度上取决于你的游戏和面向的平台。
   * 在大多数拥有 retina 级别屏幕的设备上用户往往无法区分这个选项带来的变化；如果你的游戏选择像素艺术风格，你也多半不会想开启这个选项。
   * 同时，在少部分使用软件级别抗锯齿算法的设备或浏览器上，这个选项会对性能产生比较大的影响。
   * 你可以在 `cc.game.run` 之前设置这个值，否则它不会生效。
   * 仅支持 Web
   * @property {Boolean} ENABLE_WEBGL_ANTIALIAS
   * @default false
   */
  ENABLE_WEBGL_ANTIALIAS: false,

  /**
   * !#en
   * Whether or not enable auto culling.
   * This feature have been removed in v2.0 new renderer due to overall performance consumption.
   * We have no plan currently to re-enable auto culling.
   * If your game have more dynamic objects, we suggest to disable auto culling.
   * If your game have more static objects, we suggest to enable auto culling.
   * !#zh
   * 是否开启自动裁减功能，开启裁减功能将会把在屏幕外的物体从渲染队列中去除掉。
   * 这个功能在 v2.0 的新渲染器中被移除了，因为它在大多数游戏中所带来的损耗要高于性能的提升，目前我们没有计划重新支持自动裁剪。
   * 如果游戏中的动态物体比较多的话，建议将此选项关闭。
   * 如果游戏中的静态物体比较多的话，建议将此选项打开。
   * @property {Boolean} ENABLE_CULLING
   * @deprecated since v2.0
   * @default false
   */
  ENABLE_CULLING: false,

  /**
   * !#en
   * Whether to clear the original image cache after uploaded a texture to GPU. If cleared, [Dynamic Atlas](https://docs.cocos.com/creator/manual/en/advanced-topics/dynamic-atlas.html) will not be supported.
   * Normally you don't need to enable this option on the web platform, because Image object doesn't consume too much memory.
   * But on WeChat Game platform, the current version cache decoded data in Image object, which has high memory usage.
   * So we enabled this option by default on WeChat, so that we can release Image cache immediately after uploaded to GPU.
   * !#zh
   * 是否在将贴图上传至 GPU 之后删除原始图片缓存，删除之后图片将无法进行 [动态合图](https://docs.cocos.com/creator/manual/zh/advanced-topics/dynamic-atlas.html)。
   * 在 Web 平台，你通常不需要开启这个选项，因为在 Web 平台 Image 对象所占用的内存很小。
   * 但是在微信小游戏平台的当前版本，Image 对象会缓存解码后的图片数据，它所占用的内存空间很大。
   * 所以我们在微信平台默认开启了这个选项，这样我们就可以在上传 GL 贴图之后立即释放 Image 对象的内存，避免过高的内存占用。
   * @property {Boolean} CLEANUP_IMAGE_CACHE
   * @default false
   */
  CLEANUP_IMAGE_CACHE: false,

  /**
   * !#en
   * Whether or not show mesh wire frame.
   * !#zh
   * 是否显示网格的线框。
   * @property {Boolean} SHOW_MESH_WIREFRAME
   * @default false
   */
  SHOW_MESH_WIREFRAME: false,

  /**
   * !#en
   * Whether or not show mesh normal.
   * !#zh
   * 是否显示网格的法线。
   * @property {Boolean} SHOW_MESH_NORMAL
   * @default false
   */
  SHOW_MESH_NORMAL: false,

  /**
   * !#en
   * Whether to enable multi-touch.
   * !#zh
   * 是否开启多点触摸
   * @property {Boolean} ENABLE_MULTI_TOUCH
   * @default true
   */
  ENABLE_MULTI_TOUCH: true
};
Object.defineProperty(cc.macro, 'ROTATE_ACTION_CCW', {
  set: function set(value) {
    if (cc.RotateTo && cc.RotateBy) {
      cc.RotateTo._reverse = cc.RotateBy._reverse = value;
    }
  }
});
var SUPPORT_TEXTURE_FORMATS = ['.pkm', '.pvr', '.webp', '.jpg', '.jpeg', '.bmp', '.png'];
/**
 * !#en
 * The image format supported by the engine defaults, and the supported formats may differ in different build platforms and device types.
 * Currently all platform and device support ['.webp', '.jpg', '.jpeg', '.bmp', '.png'], The iOS mobile platform also supports the PVR format。
 * !#zh
 * 引擎默认支持的图片格式，支持的格式可能在不同的构建平台和设备类型上有所差别。
 * 目前所有平台和设备支持的格式有 ['.webp', '.jpg', '.jpeg', '.bmp', '.png']. 另外 Ios 手机平台还额外支持了 PVR 格式。
 * @property {String[]} SUPPORT_TEXTURE_FORMATS
 */

cc.macro.SUPPORT_TEXTURE_FORMATS = SUPPORT_TEXTURE_FORMATS;
/**
 * !#en Key map for keyboard event
 * !#zh 键盘事件的按键值
 * @enum macro.KEY
 * @example {@link cocos2d/core/platform/CCCommon/KEY.js}
 */

cc.macro.KEY = {
  /**
   * !#en None
   * !#zh 没有分配
   * @property none
   * @type {Number}
   * @readonly
   */
  none: 0,
  // android

  /**
   * !#en The back key
   * !#zh 返回键
   * @property back
   * @type {Number}
   * @readonly
   */
  back: 6,

  /**
   * !#en The menu key
   * !#zh 菜单键
   * @property menu
   * @type {Number}
   * @readonly
   */
  menu: 18,

  /**
   * !#en The backspace key
   * !#zh 退格键
   * @property backspace
   * @type {Number}
   * @readonly
   */
  backspace: 8,

  /**
   * !#en The tab key
   * !#zh Tab 键
   * @property tab
   * @type {Number}
   * @readonly
   */
  tab: 9,

  /**
   * !#en The enter key
   * !#zh 回车键
   * @property enter
   * @type {Number}
   * @readonly
   */
  enter: 13,

  /**
   * !#en The shift key
   * !#zh Shift 键
   * @property shift
   * @type {Number}
   * @readonly
   */
  shift: 16,
  //should use shiftkey instead

  /**
   * !#en The ctrl key
   * !#zh Ctrl 键
   * @property ctrl
   * @type {Number}
   * @readonly
   */
  ctrl: 17,
  //should use ctrlkey

  /**
   * !#en The alt key
   * !#zh Alt 键
   * @property alt
   * @type {Number}
   * @readonly
   */
  alt: 18,
  //should use altkey

  /**
   * !#en The pause key
   * !#zh 暂停键
   * @property pause
   * @type {Number}
   * @readonly
   */
  pause: 19,

  /**
   * !#en The caps lock key
   * !#zh 大写锁定键
   * @property capslock
   * @type {Number}
   * @readonly
   */
  capslock: 20,

  /**
   * !#en The esc key
   * !#zh ESC 键
   * @property escape
   * @type {Number}
   * @readonly
   */
  escape: 27,

  /**
   * !#en The space key
   * !#zh 空格键
   * @property space
   * @type {Number}
   * @readonly
   */
  space: 32,

  /**
   * !#en The page up key
   * !#zh 向上翻页键
   * @property pageup
   * @type {Number}
   * @readonly
   */
  pageup: 33,

  /**
   * !#en The page down key
   * !#zh 向下翻页键
   * @property pagedown
   * @type {Number}
   * @readonly
   */
  pagedown: 34,

  /**
   * !#en The end key
   * !#zh 结束键
   * @property end
   * @type {Number}
   * @readonly
   */
  end: 35,

  /**
   * !#en The home key
   * !#zh 主菜单键
   * @property home
   * @type {Number}
   * @readonly
   */
  home: 36,

  /**
   * !#en The left key
   * !#zh 向左箭头键
   * @property left
   * @type {Number}
   * @readonly
   */
  left: 37,

  /**
   * !#en The up key
   * !#zh 向上箭头键
   * @property up
   * @type {Number}
   * @readonly
   */
  up: 38,

  /**
   * !#en The right key
   * !#zh 向右箭头键
   * @property right
   * @type {Number}
   * @readonly
   */
  right: 39,

  /**
   * !#en The down key
   * !#zh 向下箭头键
   * @property down
   * @type {Number}
   * @readonly
   */
  down: 40,

  /**
   * !#en The select key
   * !#zh Select 键
   * @property select
   * @type {Number}
   * @readonly
   */
  select: 41,

  /**
   * !#en The insert key
   * !#zh 插入键
   * @property insert
   * @type {Number}
   * @readonly
   */
  insert: 45,

  /**
   * !#en The Delete key
   * !#zh 删除键
   * @property Delete
   * @type {Number}
   * @readonly
   */
  Delete: 46,

  /**
   * !#en The '0' key on the top of the alphanumeric keyboard.
   * !#zh 字母键盘上的 0 键
   * @property 0
   * @type {Number}
   * @readonly
   */
  0: 48,

  /**
   * !#en The '1' key on the top of the alphanumeric keyboard.
   * !#zh 字母键盘上的 1 键
   * @property 1
   * @type {Number}
   * @readonly
   */
  1: 49,

  /**
   * !#en The '2' key on the top of the alphanumeric keyboard.
   * !#zh 字母键盘上的 2 键
   * @property 2
   * @type {Number}
   * @readonly
   */
  2: 50,

  /**
   * !#en The '3' key on the top of the alphanumeric keyboard.
   * !#zh 字母键盘上的 3 键
   * @property 3
   * @type {Number}
   * @readonly
   */
  3: 51,

  /**
   * !#en The '4' key on the top of the alphanumeric keyboard.
   * !#zh 字母键盘上的 4 键
   * @property 4
   * @type {Number}
   * @readonly
   */
  4: 52,

  /**
   * !#en The '5' key on the top of the alphanumeric keyboard.
   * !#zh 字母键盘上的 5 键
   * @property 5
   * @type {Number}
   * @readonly
   */
  5: 53,

  /**
   * !#en The '6' key on the top of the alphanumeric keyboard.
   * !#zh 字母键盘上的 6 键
   * @property 6
   * @type {Number}
   * @readonly
   */
  6: 54,

  /**
   * !#en The '7' key on the top of the alphanumeric keyboard.
   * !#zh 字母键盘上的 7 键
   * @property 7
   * @type {Number}
   * @readonly
   */
  7: 55,

  /**
   * !#en The '8' key on the top of the alphanumeric keyboard.
   * !#zh 字母键盘上的 8 键
   * @property 8
   * @type {Number}
   * @readonly
   */
  8: 56,

  /**
   * !#en The '9' key on the top of the alphanumeric keyboard.
   * !#zh 字母键盘上的 9 键
   * @property 9
   * @type {Number}
   * @readonly
   */
  9: 57,

  /**
   * !#en The a key
   * !#zh A 键
   * @property a
   * @type {Number}
   * @readonly
   */
  a: 65,

  /**
   * !#en The b key
   * !#zh B 键
   * @property b
   * @type {Number}
   * @readonly
   */
  b: 66,

  /**
   * !#en The c key
   * !#zh C 键
   * @property c
   * @type {Number}
   * @readonly
   */
  c: 67,

  /**
   * !#en The d key
   * !#zh D 键
   * @property d
   * @type {Number}
   * @readonly
   */
  d: 68,

  /**
   * !#en The e key
   * !#zh E 键
   * @property e
   * @type {Number}
   * @readonly
   */
  e: 69,

  /**
   * !#en The f key
   * !#zh F 键
   * @property f
   * @type {Number}
   * @readonly
   */
  f: 70,

  /**
   * !#en The g key
   * !#zh G 键
   * @property g
   * @type {Number}
   * @readonly
   */
  g: 71,

  /**
   * !#en The h key
   * !#zh H 键
   * @property h
   * @type {Number}
   * @readonly
   */
  h: 72,

  /**
   * !#en The i key
   * !#zh I 键
   * @property i
   * @type {Number}
   * @readonly
   */
  i: 73,

  /**
   * !#en The j key
   * !#zh J 键
   * @property j
   * @type {Number}
   * @readonly
   */
  j: 74,

  /**
   * !#en The k key
   * !#zh K 键
   * @property k
   * @type {Number}
   * @readonly
   */
  k: 75,

  /**
   * !#en The l key
   * !#zh L 键
   * @property l
   * @type {Number}
   * @readonly
   */
  l: 76,

  /**
   * !#en The m key
   * !#zh M 键
   * @property m
   * @type {Number}
   * @readonly
   */
  m: 77,

  /**
   * !#en The n key
   * !#zh N 键
   * @property n
   * @type {Number}
   * @readonly
   */
  n: 78,

  /**
   * !#en The o key
   * !#zh O 键
   * @property o
   * @type {Number}
   * @readonly
   */
  o: 79,

  /**
   * !#en The p key
   * !#zh P 键
   * @property p
   * @type {Number}
   * @readonly
   */
  p: 80,

  /**
   * !#en The q key
   * !#zh Q 键
   * @property q
   * @type {Number}
   * @readonly
   */
  q: 81,

  /**
   * !#en The r key
   * !#zh R 键
   * @property r
   * @type {Number}
   * @readonly
   */
  r: 82,

  /**
   * !#en The s key
   * !#zh S 键
   * @property s
   * @type {Number}
   * @readonly
   */
  s: 83,

  /**
   * !#en The t key
   * !#zh T 键
   * @property t
   * @type {Number}
   * @readonly
   */
  t: 84,

  /**
   * !#en The u key
   * !#zh U 键
   * @property u
   * @type {Number}
   * @readonly
   */
  u: 85,

  /**
   * !#en The v key
   * !#zh V 键
   * @property v
   * @type {Number}
   * @readonly
   */
  v: 86,

  /**
   * !#en The w key
   * !#zh W 键
   * @property w
   * @type {Number}
   * @readonly
   */
  w: 87,

  /**
   * !#en The x key
   * !#zh X 键
   * @property x
   * @type {Number}
   * @readonly
   */
  x: 88,

  /**
   * !#en The y key
   * !#zh Y 键
   * @property y
   * @type {Number}
   * @readonly
   */
  y: 89,

  /**
   * !#en The z key
   * !#zh Z 键
   * @property z
   * @type {Number}
   * @readonly
   */
  z: 90,

  /**
   * !#en The numeric keypad 0
   * !#zh 数字键盘 0
   * @property num0
   * @type {Number}
   * @readonly
   */
  num0: 96,

  /**
   * !#en The numeric keypad 1
   * !#zh 数字键盘 1
   * @property num1
   * @type {Number}
   * @readonly
   */
  num1: 97,

  /**
   * !#en The numeric keypad 2
   * !#zh 数字键盘 2
   * @property num2
   * @type {Number}
   * @readonly
   */
  num2: 98,

  /**
   * !#en The numeric keypad 3
   * !#zh 数字键盘 3
   * @property num3
   * @type {Number}
   * @readonly
   */
  num3: 99,

  /**
   * !#en The numeric keypad 4
   * !#zh 数字键盘 4
   * @property num4
   * @type {Number}
   * @readonly
   */
  num4: 100,

  /**
   * !#en The numeric keypad 5
   * !#zh 数字键盘 5
   * @property num5
   * @type {Number}
   * @readonly
   */
  num5: 101,

  /**
   * !#en The numeric keypad 6
   * !#zh 数字键盘 6
   * @property num6
   * @type {Number}
   * @readonly
   */
  num6: 102,

  /**
   * !#en The numeric keypad 7
   * !#zh 数字键盘 7
   * @property num7
   * @type {Number}
   * @readonly
   */
  num7: 103,

  /**
   * !#en The numeric keypad 8
   * !#zh 数字键盘 8
   * @property num8
   * @type {Number}
   * @readonly
   */
  num8: 104,

  /**
   * !#en The numeric keypad 9
   * !#zh 数字键盘 9
   * @property num9
   * @type {Number}
   * @readonly
   */
  num9: 105,

  /**
   * !#en The numeric keypad '*'
   * !#zh 数字键盘 *
   * @property *
   * @type {Number}
   * @readonly
   */
  '*': 106,

  /**
   * !#en The numeric keypad '+'
   * !#zh 数字键盘 +
   * @property +
   * @type {Number}
   * @readonly
   */
  '+': 107,

  /**
   * !#en The numeric keypad '-'
   * !#zh 数字键盘 -
   * @property -
   * @type {Number}
   * @readonly
   */
  '-': 109,

  /**
   * !#en The numeric keypad 'delete'
   * !#zh 数字键盘删除键
   * @property numdel
   * @type {Number}
   * @readonly
   */
  'numdel': 110,

  /**
   * !#en The numeric keypad '/'
   * !#zh 数字键盘 /
   * @property /
   * @type {Number}
   * @readonly
   */
  '/': 111,

  /**
   * !#en The F1 function key
   * !#zh F1 功能键
   * @property f1
   * @type {Number}
   * @readonly
   */
  f1: 112,
  //f1-f12 dont work on ie

  /**
   * !#en The F2 function key
   * !#zh F2 功能键
   * @property f2
   * @type {Number}
   * @readonly
   */
  f2: 113,

  /**
   * !#en The F3 function key
   * !#zh F3 功能键
   * @property f3
   * @type {Number}
   * @readonly
   */
  f3: 114,

  /**
   * !#en The F4 function key
   * !#zh F4 功能键
   * @property f4
   * @type {Number}
   * @readonly
   */
  f4: 115,

  /**
   * !#en The F5 function key
   * !#zh F5 功能键
   * @property f5
   * @type {Number}
   * @readonly
   */
  f5: 116,

  /**
   * !#en The F6 function key
   * !#zh F6 功能键
   * @property f6
   * @type {Number}
   * @readonly
   */
  f6: 117,

  /**
   * !#en The F7 function key
   * !#zh F7 功能键
   * @property f7
   * @type {Number}
   * @readonly
   */
  f7: 118,

  /**
   * !#en The F8 function key
   * !#zh F8 功能键
   * @property f8
   * @type {Number}
   * @readonly
   */
  f8: 119,

  /**
   * !#en The F9 function key
   * !#zh F9 功能键
   * @property f9
   * @type {Number}
   * @readonly
   */
  f9: 120,

  /**
   * !#en The F10 function key
   * !#zh F10 功能键
   * @property f10
   * @type {Number}
   * @readonly
   */
  f10: 121,

  /**
   * !#en The F11 function key
   * !#zh F11 功能键
   * @property f11
   * @type {Number}
   * @readonly
   */
  f11: 122,

  /**
   * !#en The F12 function key
   * !#zh F12 功能键
   * @property f12
   * @type {Number}
   * @readonly
   */
  f12: 123,

  /**
   * !#en The numlock key
   * !#zh 数字锁定键
   * @property numlock
   * @type {Number}
   * @readonly
   */
  numlock: 144,

  /**
   * !#en The scroll lock key
   * !#zh 滚动锁定键
   * @property scrolllock
   * @type {Number}
   * @readonly
   */
  scrolllock: 145,

  /**
   * !#en The ';' key.
   * !#zh 分号键
   * @property ;
   * @type {Number}
   * @readonly
   */
  ';': 186,

  /**
   * !#en The ';' key.
   * !#zh 分号键
   * @property semicolon
   * @type {Number}
   * @readonly
   */
  semicolon: 186,

  /**
   * !#en The '=' key.
   * !#zh 等于号键
   * @property equal
   * @type {Number}
   * @readonly
   */
  equal: 187,

  /**
   * !#en The '=' key.
   * !#zh 等于号键
   * @property =
   * @type {Number}
   * @readonly
   */
  '=': 187,

  /**
   * !#en The ',' key.
   * !#zh 逗号键
   * @property ,
   * @type {Number}
   * @readonly
   */
  ',': 188,

  /**
   * !#en The ',' key.
   * !#zh 逗号键
   * @property comma
   * @type {Number}
   * @readonly
   */
  comma: 188,

  /**
   * !#en The dash '-' key.
   * !#zh 中划线键
   * @property dash
   * @type {Number}
   * @readonly
   */
  dash: 189,

  /**
   * !#en The '.' key.
   * !#zh 句号键
   * @property .
   * @type {Number}
   * @readonly
   */
  '.': 190,

  /**
   * !#en The '.' key
   * !#zh 句号键
   * @property period
   * @type {Number}
   * @readonly
   */
  period: 190,

  /**
   * !#en The forward slash key
   * !#zh 正斜杠键
   * @property forwardslash
   * @type {Number}
   * @readonly
   */
  forwardslash: 191,

  /**
   * !#en The grave key
   * !#zh 按键 `
   * @property grave
   * @type {Number}
   * @readonly
   */
  grave: 192,

  /**
   * !#en The '[' key
   * !#zh 按键 [
   * @property [
   * @type {Number}
   * @readonly
   */
  '[': 219,

  /**
   * !#en The '[' key
   * !#zh 按键 [
   * @property openbracket
   * @type {Number}
   * @readonly
   */
  openbracket: 219,

  /**
   * !#en The '\' key
   * !#zh 反斜杠键
   * @property backslash
   * @type {Number}
   * @readonly
   */
  backslash: 220,

  /**
   * !#en The ']' key
   * !#zh 按键 ]
   * @property ]
   * @type {Number}
   * @readonly
   */
  ']': 221,

  /**
   * !#en The ']' key
   * !#zh 按键 ]
   * @property closebracket
   * @type {Number}
   * @readonly
   */
  closebracket: 221,

  /**
   * !#en The quote key
   * !#zh 单引号键
   * @property quote
   * @type {Number}
   * @readonly
   */
  quote: 222,
  // gamepad controll

  /**
   * !#en The dpad left key
   * !#zh 导航键 向左
   * @property dpadLeft
   * @type {Number}
   * @readonly
   */
  dpadLeft: 1000,

  /**
   * !#en The dpad right key
   * !#zh 导航键 向右
   * @property dpadRight
   * @type {Number}
   * @readonly
   */
  dpadRight: 1001,

  /**
   * !#en The dpad up key
   * !#zh 导航键 向上
   * @property dpadUp
   * @type {Number}
   * @readonly
   */
  dpadUp: 1003,

  /**
   * !#en The dpad down key
   * !#zh 导航键 向下
   * @property dpadDown
   * @type {Number}
   * @readonly
   */
  dpadDown: 1004,

  /**
   * !#en The dpad center key
   * !#zh 导航键 确定键
   * @property dpadCenter
   * @type {Number}
   * @readonly
   */
  dpadCenter: 1005
};
/**
 * Image formats
 * @enum macro.ImageFormat
 */

cc.macro.ImageFormat = cc.Enum({
  /**
   * Image Format:JPG
   * @property JPG
   * @type {Number}
   */
  JPG: 0,

  /**
   * Image Format:PNG
   * @property PNG
   * @type {Number}
   */
  PNG: 1,

  /**
   * Image Format:TIFF
   * @property TIFF
   * @type {Number}
   */
  TIFF: 2,

  /**
   * Image Format:WEBP
   * @property WEBP
   * @type {Number}
   */
  WEBP: 3,

  /**
   * Image Format:PVR
   * @property PVR
   * @type {Number}
   */
  PVR: 4,

  /**
   * Image Format:ETC
   * @property ETC
   * @type {Number}
   */
  ETC: 5,

  /**
   * Image Format:S3TC
   * @property S3TC
   * @type {Number}
   */
  S3TC: 6,

  /**
   * Image Format:ATITC
   * @property ATITC
   * @type {Number}
   */
  ATITC: 7,

  /**
   * Image Format:TGA
   * @property TGA
   * @type {Number}
   */
  TGA: 8,

  /**
   * Image Format:RAWDATA
   * @property RAWDATA
   * @type {Number}
   */
  RAWDATA: 9,

  /**
   * Image Format:UNKNOWN
   * @property UNKNOWN
   * @type {Number}
   */
  UNKNOWN: 10
});
/**
 * !#en
 * Enum for blend factor
 * Refer to: http://www.andersriggelsen.dk/glblendfunc.php
 * !#zh
 * 混合因子
 * 可参考: http://www.andersriggelsen.dk/glblendfunc.php
 * @enum macro.BlendFactor
 */

cc.macro.BlendFactor = cc.Enum({
  /**
   * !#en All use
   * !#zh 全部使用
   * @property {Number} ONE
   */
  ONE: 1,
  //cc.macro.ONE

  /**
   * !#en Not all
   * !#zh 全部不用
   * @property {Number} ZERO
   */
  ZERO: 0,
  //cc.ZERO

  /**
   * !#en Using the source alpha
   * !#zh 使用源颜色的透明度
   * @property {Number} SRC_ALPHA
   */
  SRC_ALPHA: 0x302,
  //cc.SRC_ALPHA

  /**
   * !#en Using the source color
   * !#zh 使用源颜色
   * @property {Number} SRC_COLOR
   */
  SRC_COLOR: 0x300,
  //cc.SRC_COLOR

  /**
   * !#en Using the target alpha
   * !#zh 使用目标颜色的透明度
   * @property {Number} DST_ALPHA
   */
  DST_ALPHA: 0x304,
  //cc.DST_ALPHA

  /**
   * !#en Using the target color
   * !#zh 使用目标颜色
   * @property {Number} DST_COLOR
   */
  DST_COLOR: 0x306,
  //cc.DST_COLOR

  /**
   * !#en Minus the source alpha
   * !#zh 减去源颜色的透明度
   * @property {Number} ONE_MINUS_SRC_ALPHA
   */
  ONE_MINUS_SRC_ALPHA: 0x303,
  //cc.ONE_MINUS_SRC_ALPHA

  /**
   * !#en Minus the source color
   * !#zh 减去源颜色
   * @property {Number} ONE_MINUS_SRC_COLOR
   */
  ONE_MINUS_SRC_COLOR: 0x301,
  //cc.ONE_MINUS_SRC_COLOR

  /**
   * !#en Minus the target alpha
   * !#zh 减去目标颜色的透明度
   * @property {Number} ONE_MINUS_DST_ALPHA
   */
  ONE_MINUS_DST_ALPHA: 0x305,
  //cc.ONE_MINUS_DST_ALPHA

  /**
   * !#en Minus the target color
   * !#zh 减去目标颜色
   * @property {Number} ONE_MINUS_DST_COLOR
   */
  ONE_MINUS_DST_COLOR: 0x307 //cc.ONE_MINUS_DST_COLOR

});
/**
 * @enum macro.TextAlignment
 */

cc.macro.TextAlignment = cc.Enum({
  /**
   * @property {Number} LEFT
   */
  LEFT: 0,

  /**
   * @property {Number} CENTER
   */
  CENTER: 1,

  /**
   * @property {Number} RIGHT
   */
  RIGHT: 2
});
/**
 * @enum VerticalTextAlignment
 */

cc.macro.VerticalTextAlignment = cc.Enum({
  /**
   * @property {Number} TOP
   */
  TOP: 0,

  /**
   * @property {Number} CENTER
   */
  CENTER: 1,

  /**
   * @property {Number} BOTTOM
   */
  BOTTOM: 2
});
module.exports = cc.macro;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/extensions/dragonbones/index.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

/**
 * !#en
 * The global main namespace of DragonBones, all classes, functions,
 * properties and constants of DragonBones are defined in this namespace
 * !#zh
 * DragonBones 的全局的命名空间，
 * 与 DragonBones 相关的所有的类，函数，属性，常量都在这个命名空间中定义。
 * @module dragonBones
 * @main dragonBones
 */

/*
 * Reference:
 * http://dragonbones.com/cn/index.html
 */
var _global = typeof window === 'undefined' ? global : window;

if (!CC_NATIVERENDERER) {
  _global.dragonBones = require('./lib/dragonBones');
}

if (_global.dragonBones !== undefined) {
  /**
   * !#en
   * The global time scale of DragonBones.
   * !#zh
   * DragonBones 全局时间缩放率。
   * @example
   * dragonBones.timeScale = 0.8;
   */
  dragonBones._timeScale = 1.0;
  Object.defineProperty(dragonBones, 'timeScale', {
    get: function get() {
      return this._timeScale;
    },
    set: function set(value) {
      this._timeScale = value;
      var factory = this.CCFactory.getInstance();
      factory._dragonBones.clock.timeScale = value;
    },
    configurable: true
  });
  dragonBones.DisplayType = {
    Image: 0,
    Armature: 1,
    Mesh: 2
  };
  dragonBones.ArmatureType = {
    Armature: 0,
    MovieClip: 1,
    Stage: 2
  };
  dragonBones.ExtensionType = {
    FFD: 0,
    AdjustColor: 10,
    BevelFilter: 11,
    BlurFilter: 12,
    DropShadowFilter: 13,
    GlowFilter: 14,
    GradientBevelFilter: 15,
    GradientGlowFilter: 16
  };
  dragonBones.EventType = {
    Frame: 0,
    Sound: 1
  };
  dragonBones.ActionType = {
    Play: 0,
    Stop: 1,
    GotoAndPlay: 2,
    GotoAndStop: 3,
    FadeIn: 4,
    FadeOut: 5
  };
  dragonBones.AnimationFadeOutMode = {
    None: 0,
    SameLayer: 1,
    SameGroup: 2,
    SameLayerAndGroup: 3,
    All: 4
  };
  dragonBones.BinaryOffset = {
    WeigthBoneCount: 0,
    WeigthFloatOffset: 1,
    WeigthBoneIndices: 2,
    MeshVertexCount: 0,
    MeshTriangleCount: 1,
    MeshFloatOffset: 2,
    MeshWeightOffset: 3,
    MeshVertexIndices: 4,
    TimelineScale: 0,
    TimelineOffset: 1,
    TimelineKeyFrameCount: 2,
    TimelineFrameValueCount: 3,
    TimelineFrameValueOffset: 4,
    TimelineFrameOffset: 5,
    FramePosition: 0,
    FrameTweenType: 1,
    FrameTweenEasingOrCurveSampleCount: 2,
    FrameCurveSamples: 3,
    DeformMeshOffset: 0,
    DeformCount: 1,
    DeformValueCount: 2,
    DeformValueOffset: 3,
    DeformFloatOffset: 4
  };
  dragonBones.BoneType = {
    Bone: 0,
    Surface: 1
  };

  if (!CC_EDITOR || !Editor.isMainProcess) {
    if (!CC_NATIVERENDERER) {
      require('./CCFactory');

      require('./CCSlot');

      require('./CCTextureData');

      require('./CCArmatureDisplay');

      require('./ArmatureCache');
    } // require the component for dragonbones


    require('./DragonBonesAsset');

    require('./DragonBonesAtlasAsset');

    require('./ArmatureDisplay');

    require('./webgl-assembler');
  } else {
    require('./DragonBonesAsset');

    require('./DragonBonesAtlasAsset');
  }
}
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/platform/CCInputManager.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2011-2012 cocos2d-x.org
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var macro = require('./CCMacro');

var sys = require('./CCSys');

var eventManager = require('../event-manager');

var TOUCH_TIMEOUT = macro.TOUCH_TIMEOUT;

var _vec2 = cc.v2();
/**
 *  This class manages all events of input. include: touch, mouse, accelerometer, keyboard
 */


var inputManager = {
  _mousePressed: false,
  _isRegisterEvent: false,
  _preTouchPoint: cc.v2(0, 0),
  _prevMousePoint: cc.v2(0, 0),
  _preTouchPool: [],
  _preTouchPoolPointer: 0,
  _touches: [],
  _touchesIntegerDict: {},
  _indexBitsUsed: 0,
  _maxTouches: 8,
  _accelEnabled: false,
  _accelInterval: 1 / 5,
  _accelMinus: 1,
  _accelCurTime: 0,
  _acceleration: null,
  _accelDeviceEvent: null,
  _canvasBoundingRect: {
    left: 0,
    top: 0,
    adjustedLeft: 0,
    adjustedTop: 0,
    width: 0,
    height: 0
  },
  _getUnUsedIndex: function _getUnUsedIndex() {
    var temp = this._indexBitsUsed;
    var now = cc.sys.now();

    for (var i = 0; i < this._maxTouches; i++) {
      if (!(temp & 0x00000001)) {
        this._indexBitsUsed |= 1 << i;
        return i;
      } else {
        var touch = this._touches[i];

        if (now - touch._lastModified > TOUCH_TIMEOUT) {
          this._removeUsedIndexBit(i);

          delete this._touchesIntegerDict[touch.getID()];
          return i;
        }
      }

      temp >>= 1;
    } // all bits are used


    return -1;
  },
  _removeUsedIndexBit: function _removeUsedIndexBit(index) {
    if (index < 0 || index >= this._maxTouches) return;
    var temp = 1 << index;
    temp = ~temp;
    this._indexBitsUsed &= temp;
  },
  _glView: null,
  _updateCanvasBoundingRect: function _updateCanvasBoundingRect() {
    var element = cc.game.canvas;
    var canvasBoundingRect = this._canvasBoundingRect;
    var docElem = document.documentElement;
    var leftOffset = window.pageXOffset - docElem.clientLeft;
    var topOffset = window.pageYOffset - docElem.clientTop;

    if (element.getBoundingClientRect) {
      var box = element.getBoundingClientRect();
      canvasBoundingRect.left = box.left + leftOffset;
      canvasBoundingRect.top = box.top + topOffset;
      canvasBoundingRect.width = box.width;
      canvasBoundingRect.height = box.height;
    } else if (element instanceof HTMLCanvasElement) {
      canvasBoundingRect.left = leftOffset;
      canvasBoundingRect.top = topOffset;
      canvasBoundingRect.width = element.width;
      canvasBoundingRect.height = element.height;
    } else {
      canvasBoundingRect.left = leftOffset;
      canvasBoundingRect.top = topOffset;
      canvasBoundingRect.width = parseInt(element.style.width);
      canvasBoundingRect.height = parseInt(element.style.height);
    }
  },

  /**
   * @method handleTouchesBegin
   * @param {Array} touches
   */
  handleTouchesBegin: function handleTouchesBegin(touches) {
    var selTouch,
        index,
        curTouch,
        touchID,
        handleTouches = [],
        locTouchIntDict = this._touchesIntegerDict,
        now = sys.now();

    for (var i = 0, len = touches.length; i < len; i++) {
      selTouch = touches[i];
      touchID = selTouch.getID();
      index = locTouchIntDict[touchID];

      if (index == null) {
        var unusedIndex = this._getUnUsedIndex();

        if (unusedIndex === -1) {
          cc.logID(2300, unusedIndex);
          continue;
        } //curTouch = this._touches[unusedIndex] = selTouch;


        curTouch = this._touches[unusedIndex] = new cc.Touch(selTouch._point.x, selTouch._point.y, selTouch.getID());
        curTouch._lastModified = now;

        curTouch._setPrevPoint(selTouch._prevPoint);

        locTouchIntDict[touchID] = unusedIndex;
        handleTouches.push(curTouch);
      }
    }

    if (handleTouches.length > 0) {
      this._glView._convertTouchesWithScale(handleTouches);

      var touchEvent = new cc.Event.EventTouch(handleTouches);
      touchEvent._eventCode = cc.Event.EventTouch.BEGAN;
      eventManager.dispatchEvent(touchEvent);
    }
  },

  /**
   * @method handleTouchesMove
   * @param {Array} touches
   */
  handleTouchesMove: function handleTouchesMove(touches) {
    var selTouch,
        index,
        touchID,
        handleTouches = [],
        locTouches = this._touches,
        now = sys.now();

    for (var i = 0, len = touches.length; i < len; i++) {
      selTouch = touches[i];
      touchID = selTouch.getID();
      index = this._touchesIntegerDict[touchID];

      if (index == null) {
        //cc.log("if the index doesn't exist, it is an error");
        continue;
      }

      if (locTouches[index]) {
        locTouches[index]._setPoint(selTouch._point);

        locTouches[index]._setPrevPoint(selTouch._prevPoint);

        locTouches[index]._lastModified = now;
        handleTouches.push(locTouches[index]);
      }
    }

    if (handleTouches.length > 0) {
      this._glView._convertTouchesWithScale(handleTouches);

      var touchEvent = new cc.Event.EventTouch(handleTouches);
      touchEvent._eventCode = cc.Event.EventTouch.MOVED;
      eventManager.dispatchEvent(touchEvent);
    }
  },

  /**
   * @method handleTouchesEnd
   * @param {Array} touches
   */
  handleTouchesEnd: function handleTouchesEnd(touches) {
    var handleTouches = this.getSetOfTouchesEndOrCancel(touches);

    if (handleTouches.length > 0) {
      this._glView._convertTouchesWithScale(handleTouches);

      var touchEvent = new cc.Event.EventTouch(handleTouches);
      touchEvent._eventCode = cc.Event.EventTouch.ENDED;
      eventManager.dispatchEvent(touchEvent);
    }

    this._preTouchPool.length = 0;
  },

  /**
   * @method handleTouchesCancel
   * @param {Array} touches
   */
  handleTouchesCancel: function handleTouchesCancel(touches) {
    var handleTouches = this.getSetOfTouchesEndOrCancel(touches);

    if (handleTouches.length > 0) {
      this._glView._convertTouchesWithScale(handleTouches);

      var touchEvent = new cc.Event.EventTouch(handleTouches);
      touchEvent._eventCode = cc.Event.EventTouch.CANCELED;
      eventManager.dispatchEvent(touchEvent);
    }

    this._preTouchPool.length = 0;
  },

  /**
   * @method getSetOfTouchesEndOrCancel
   * @param {Array} touches
   * @returns {Array}
   */
  getSetOfTouchesEndOrCancel: function getSetOfTouchesEndOrCancel(touches) {
    var selTouch,
        index,
        touchID,
        handleTouches = [],
        locTouches = this._touches,
        locTouchesIntDict = this._touchesIntegerDict;

    for (var i = 0, len = touches.length; i < len; i++) {
      selTouch = touches[i];
      touchID = selTouch.getID();
      index = locTouchesIntDict[touchID];

      if (index == null) {
        continue; //cc.log("if the index doesn't exist, it is an error");
      }

      if (locTouches[index]) {
        locTouches[index]._setPoint(selTouch._point);

        locTouches[index]._setPrevPoint(selTouch._prevPoint);

        handleTouches.push(locTouches[index]);

        this._removeUsedIndexBit(index);

        delete locTouchesIntDict[touchID];
      }
    }

    return handleTouches;
  },

  /**
   * @method getPreTouch
   * @param {Touch} touch
   * @return {Touch}
   */
  getPreTouch: function getPreTouch(touch) {
    var preTouch = null;
    var locPreTouchPool = this._preTouchPool;
    var id = touch.getID();

    for (var i = locPreTouchPool.length - 1; i >= 0; i--) {
      if (locPreTouchPool[i].getID() === id) {
        preTouch = locPreTouchPool[i];
        break;
      }
    }

    if (!preTouch) preTouch = touch;
    return preTouch;
  },

  /**
   * @method setPreTouch
   * @param {Touch} touch
   */
  setPreTouch: function setPreTouch(touch) {
    var find = false;
    var locPreTouchPool = this._preTouchPool;
    var id = touch.getID();

    for (var i = locPreTouchPool.length - 1; i >= 0; i--) {
      if (locPreTouchPool[i].getID() === id) {
        locPreTouchPool[i] = touch;
        find = true;
        break;
      }
    }

    if (!find) {
      if (locPreTouchPool.length <= 50) {
        locPreTouchPool.push(touch);
      } else {
        locPreTouchPool[this._preTouchPoolPointer] = touch;
        this._preTouchPoolPointer = (this._preTouchPoolPointer + 1) % 50;
      }
    }
  },

  /**
   * @method getTouchByXY
   * @param {Number} tx
   * @param {Number} ty
   * @param {Vec2} pos
   * @return {Touch}
   */
  getTouchByXY: function getTouchByXY(tx, ty, pos) {
    var locPreTouch = this._preTouchPoint;

    var location = this._glView.convertToLocationInView(tx, ty, pos);

    var touch = new cc.Touch(location.x, location.y, 0);

    touch._setPrevPoint(locPreTouch.x, locPreTouch.y);

    locPreTouch.x = location.x;
    locPreTouch.y = location.y;
    return touch;
  },

  /**
   * @method getMouseEvent
   * @param {Vec2} location
   * @param {Vec2} pos
   * @param {Number} eventType
   * @returns {Event.EventMouse}
   */
  getMouseEvent: function getMouseEvent(location, pos, eventType) {
    var locPreMouse = this._prevMousePoint;
    var mouseEvent = new cc.Event.EventMouse(eventType);

    mouseEvent._setPrevCursor(locPreMouse.x, locPreMouse.y);

    locPreMouse.x = location.x;
    locPreMouse.y = location.y;

    this._glView._convertMouseToLocationInView(locPreMouse, pos);

    mouseEvent.setLocation(locPreMouse.x, locPreMouse.y);
    return mouseEvent;
  },

  /**
   * @method getPointByEvent
   * @param {Touch} event
   * @param {Vec2} pos
   * @return {Vec2}
   */
  getPointByEvent: function getPointByEvent(event, pos) {
    // qq , uc and safari browser can't calculate pageY correctly, need to refresh canvas bounding rect
    if (cc.sys.browserType === cc.sys.BROWSER_TYPE_QQ || cc.sys.browserType === cc.sys.BROWSER_TYPE_UC || cc.sys.browserType === cc.sys.BROWSER_TYPE_SAFARI) {
      this._updateCanvasBoundingRect();
    }

    if (event.pageX != null) //not avalable in <= IE8
      return {
        x: event.pageX,
        y: event.pageY
      };
    pos.left -= document.body.scrollLeft;
    pos.top -= document.body.scrollTop;
    return {
      x: event.clientX,
      y: event.clientY
    };
  },

  /**
   * @method getTouchesByEvent
   * @param {Touch} event
   * @param {Vec2} pos
   * @returns {Array}
   */
  getTouchesByEvent: function getTouchesByEvent(event, pos) {
    var touchArr = [],
        locView = this._glView;
    var touch_event, touch, preLocation;
    var locPreTouch = this._preTouchPoint;
    var length = event.changedTouches.length;

    for (var i = 0; i < length; i++) {
      touch_event = event.changedTouches[i];

      if (touch_event) {
        var location = void 0;
        if (sys.BROWSER_TYPE_FIREFOX === sys.browserType) location = locView.convertToLocationInView(touch_event.pageX, touch_event.pageY, pos, _vec2);else location = locView.convertToLocationInView(touch_event.clientX, touch_event.clientY, pos, _vec2);

        if (touch_event.identifier != null) {
          touch = new cc.Touch(location.x, location.y, touch_event.identifier); //use Touch Pool

          preLocation = this.getPreTouch(touch).getLocation();

          touch._setPrevPoint(preLocation.x, preLocation.y);

          this.setPreTouch(touch);
        } else {
          touch = new cc.Touch(location.x, location.y);

          touch._setPrevPoint(locPreTouch.x, locPreTouch.y);
        }

        locPreTouch.x = location.x;
        locPreTouch.y = location.y;
        touchArr.push(touch);
      }
    }

    return touchArr;
  },

  /**
   * @method registerSystemEvent
   * @param {HTMLElement} element
   */
  registerSystemEvent: function registerSystemEvent(element) {
    if (this._isRegisterEvent) return;
    this._glView = cc.view;
    var selfPointer = this;
    var canvasBoundingRect = this._canvasBoundingRect;
    window.addEventListener('resize', this._updateCanvasBoundingRect.bind(this));
    var prohibition = sys.isMobile;
    var supportMouse = 'mouse' in sys.capabilities;
    var supportTouches = 'touches' in sys.capabilities;

    if (supportMouse) {
      //HACK
      //  - At the same time to trigger the ontouch event and onmouse event
      //  - The function will execute 2 times
      //The known browser:
      //  liebiao
      //  miui
      //  WECHAT
      if (!prohibition) {
        window.addEventListener('mousedown', function () {
          selfPointer._mousePressed = true;
        }, false);
        window.addEventListener('mouseup', function (event) {
          if (!selfPointer._mousePressed) return;
          selfPointer._mousePressed = false;
          var location = selfPointer.getPointByEvent(event, canvasBoundingRect);

          if (!cc.rect(canvasBoundingRect.left, canvasBoundingRect.top, canvasBoundingRect.width, canvasBoundingRect.height).contains(location)) {
            selfPointer.handleTouchesEnd([selfPointer.getTouchByXY(location.x, location.y, canvasBoundingRect)]);
            var mouseEvent = selfPointer.getMouseEvent(location, canvasBoundingRect, cc.Event.EventMouse.UP);
            mouseEvent.setButton(event.button);
            eventManager.dispatchEvent(mouseEvent);
          }
        }, false);
      } // register canvas mouse event


      var EventMouse = cc.Event.EventMouse;
      var _mouseEventsOnElement = [!prohibition && ["mousedown", EventMouse.DOWN, function (event, mouseEvent, location, canvasBoundingRect) {
        selfPointer._mousePressed = true;
        selfPointer.handleTouchesBegin([selfPointer.getTouchByXY(location.x, location.y, canvasBoundingRect)]);
        element.focus();
      }], !prohibition && ["mouseup", EventMouse.UP, function (event, mouseEvent, location, canvasBoundingRect) {
        selfPointer._mousePressed = false;
        selfPointer.handleTouchesEnd([selfPointer.getTouchByXY(location.x, location.y, canvasBoundingRect)]);
      }], !prohibition && ["mousemove", EventMouse.MOVE, function (event, mouseEvent, location, canvasBoundingRect) {
        selfPointer.handleTouchesMove([selfPointer.getTouchByXY(location.x, location.y, canvasBoundingRect)]);

        if (!selfPointer._mousePressed) {
          mouseEvent.setButton(null);
        }
      }], ["mousewheel", EventMouse.SCROLL, function (event, mouseEvent) {
        mouseEvent.setScrollData(0, event.wheelDelta);
      }],
      /* firefox fix */
      ["DOMMouseScroll", EventMouse.SCROLL, function (event, mouseEvent) {
        mouseEvent.setScrollData(0, event.detail * -120);
      }]];

      for (var i = 0; i < _mouseEventsOnElement.length; ++i) {
        var entry = _mouseEventsOnElement[i];

        if (entry) {
          (function () {
            var name = entry[0];
            var type = entry[1];
            var handler = entry[2];
            element.addEventListener(name, function (event) {
              var location = selfPointer.getPointByEvent(event, canvasBoundingRect);
              var mouseEvent = selfPointer.getMouseEvent(location, canvasBoundingRect, type);
              mouseEvent.setButton(event.button);
              handler(event, mouseEvent, location, canvasBoundingRect);
              eventManager.dispatchEvent(mouseEvent);
              event.stopPropagation();
              event.preventDefault();
            }, false);
          })();
        }
      }
    }

    if (window.navigator.msPointerEnabled) {
      var _pointerEventsMap = {
        "MSPointerDown": selfPointer.handleTouchesBegin,
        "MSPointerMove": selfPointer.handleTouchesMove,
        "MSPointerUp": selfPointer.handleTouchesEnd,
        "MSPointerCancel": selfPointer.handleTouchesCancel
      };

      var _loop = function _loop(eventName) {
        var touchEvent = _pointerEventsMap[eventName];
        element.addEventListener(eventName, function (event) {
          var documentElement = document.documentElement;
          canvasBoundingRect.adjustedLeft = canvasBoundingRect.left - documentElement.scrollLeft;
          canvasBoundingRect.adjustedTop = canvasBoundingRect.top - documentElement.scrollTop;
          touchEvent.call(selfPointer, [selfPointer.getTouchByXY(event.clientX, event.clientY, canvasBoundingRect)]);
          event.stopPropagation();
        }, false);
      };

      for (var eventName in _pointerEventsMap) {
        _loop(eventName);
      }
    } //register touch event


    if (supportTouches) {
      var _touchEventsMap = {
        "touchstart": function touchstart(touchesToHandle) {
          selfPointer.handleTouchesBegin(touchesToHandle);
          element.focus();
        },
        "touchmove": function touchmove(touchesToHandle) {
          selfPointer.handleTouchesMove(touchesToHandle);
        },
        "touchend": function touchend(touchesToHandle) {
          selfPointer.handleTouchesEnd(touchesToHandle);
        },
        "touchcancel": function touchcancel(touchesToHandle) {
          selfPointer.handleTouchesCancel(touchesToHandle);
        }
      };

      var registerTouchEvent = function registerTouchEvent(eventName) {
        var handler = _touchEventsMap[eventName];
        element.addEventListener(eventName, function (event) {
          if (!event.changedTouches) return;
          var body = document.body;
          canvasBoundingRect.adjustedLeft = canvasBoundingRect.left - (body.scrollLeft || window.scrollX || 0);
          canvasBoundingRect.adjustedTop = canvasBoundingRect.top - (body.scrollTop || window.scrollY || 0);
          handler(selfPointer.getTouchesByEvent(event, canvasBoundingRect));
          event.stopPropagation();
          event.preventDefault();
        }, false);
      };

      for (var _eventName in _touchEventsMap) {
        registerTouchEvent(_eventName);
      }
    }

    this._registerKeyboardEvent();

    this._isRegisterEvent = true;
  },
  _registerKeyboardEvent: function _registerKeyboardEvent() {},
  _registerAccelerometerEvent: function _registerAccelerometerEvent() {},

  /**
   * @method update
   * @param {Number} dt
   */
  update: function update(dt) {
    if (this._accelCurTime > this._accelInterval) {
      this._accelCurTime -= this._accelInterval;
      eventManager.dispatchEvent(new cc.Event.EventAcceleration(this._acceleration));
    }

    this._accelCurTime += dt;
  }
};
module.exports = cc.internal.inputManager = inputManager;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/platform/CCSys.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var settingPlatform;

if (!CC_EDITOR) {
  settingPlatform = window._CCSettings ? _CCSettings.platform : undefined;
}

var isVivoGame = settingPlatform === 'qgame';
var isOppoGame = settingPlatform === 'quickgame';
var isHuaweiGame = settingPlatform === 'huawei';
var isJKWGame = settingPlatform === 'jkw-game';
var isQttGame = settingPlatform === 'qtt-game';

var _global = typeof window === 'undefined' ? global : window;

function initSys() {
  /**
   * System variables
   * @class sys
   * @main
   * @static
   */
  cc.sys = {};
  var sys = cc.sys;
  /**
   * English language code
   * @property {String} LANGUAGE_ENGLISH
   * @readOnly
   */

  sys.LANGUAGE_ENGLISH = "en";
  /**
   * Chinese language code
   * @property {String} LANGUAGE_CHINESE
   * @readOnly
   */

  sys.LANGUAGE_CHINESE = "zh";
  /**
   * French language code
   * @property {String} LANGUAGE_FRENCH
   * @readOnly
   */

  sys.LANGUAGE_FRENCH = "fr";
  /**
   * Italian language code
   * @property {String} LANGUAGE_ITALIAN
   * @readOnly
   */

  sys.LANGUAGE_ITALIAN = "it";
  /**
   * German language code
   * @property {String} LANGUAGE_GERMAN
   * @readOnly
   */

  sys.LANGUAGE_GERMAN = "de";
  /**
   * Spanish language code
   * @property {String} LANGUAGE_SPANISH
   * @readOnly
   */

  sys.LANGUAGE_SPANISH = "es";
  /**
   * Spanish language code
   * @property {String} LANGUAGE_DUTCH
   * @readOnly
   */

  sys.LANGUAGE_DUTCH = "du";
  /**
   * Russian language code
   * @property {String} LANGUAGE_RUSSIAN
   * @readOnly
   */

  sys.LANGUAGE_RUSSIAN = "ru";
  /**
   * Korean language code
   * @property {String} LANGUAGE_KOREAN
   * @readOnly
   */

  sys.LANGUAGE_KOREAN = "ko";
  /**
   * Japanese language code
   * @property {String} LANGUAGE_JAPANESE
   * @readOnly
   */

  sys.LANGUAGE_JAPANESE = "ja";
  /**
   * Hungarian language code
   * @property {String} LANGUAGE_HUNGARIAN
   * @readonly
   */

  sys.LANGUAGE_HUNGARIAN = "hu";
  /**
   * Portuguese language code
   * @property {String} LANGUAGE_PORTUGUESE
   * @readOnly
   */

  sys.LANGUAGE_PORTUGUESE = "pt";
  /**
   * Arabic language code
   * @property {String} LANGUAGE_ARABIC
   * @readOnly
   */

  sys.LANGUAGE_ARABIC = "ar";
  /**
   * Norwegian language code
   * @property {String} LANGUAGE_NORWEGIAN
   * @readOnly
   */

  sys.LANGUAGE_NORWEGIAN = "no";
  /**
   * Polish language code
   * @property {String} LANGUAGE_POLISH
   * @readOnly
   */

  sys.LANGUAGE_POLISH = "pl";
  /**
   * Turkish language code
   * @property {String} LANGUAGE_TURKISH
   * @readOnly
   */

  sys.LANGUAGE_TURKISH = "tr";
  /**
   * Ukrainian language code
   * @property {String} LANGUAGE_UKRAINIAN
   * @readOnly
   */

  sys.LANGUAGE_UKRAINIAN = "uk";
  /**
   * Romanian language code
   * @property {String} LANGUAGE_ROMANIAN
   * @readOnly
   */

  sys.LANGUAGE_ROMANIAN = "ro";
  /**
   * Bulgarian language code
   * @property {String} LANGUAGE_BULGARIAN
   * @readOnly
   */

  sys.LANGUAGE_BULGARIAN = "bg";
  /**
   * Unknown language code
   * @property {String} LANGUAGE_UNKNOWN
   * @readOnly
   */

  sys.LANGUAGE_UNKNOWN = "unknown";
  /**
   * @property {String} OS_IOS
   * @readOnly
   */

  sys.OS_IOS = "iOS";
  /**
   * @property {String} OS_ANDROID
   * @readOnly
   */

  sys.OS_ANDROID = "Android";
  /**
   * @property {String} OS_WINDOWS
   * @readOnly
   */

  sys.OS_WINDOWS = "Windows";
  /**
   * @property {String} OS_MARMALADE
   * @readOnly
   */

  sys.OS_MARMALADE = "Marmalade";
  /**
   * @property {String} OS_LINUX
   * @readOnly
   */

  sys.OS_LINUX = "Linux";
  /**
   * @property {String} OS_BADA
   * @readOnly
   */

  sys.OS_BADA = "Bada";
  /**
   * @property {String} OS_BLACKBERRY
   * @readOnly
   */

  sys.OS_BLACKBERRY = "Blackberry";
  /**
   * @property {String} OS_OSX
   * @readOnly
   */

  sys.OS_OSX = "OS X";
  /**
   * @property {String} OS_WP8
   * @readOnly
   */

  sys.OS_WP8 = "WP8";
  /**
   * @property {String} OS_WINRT
   * @readOnly
   */

  sys.OS_WINRT = "WINRT";
  /**
   * @property {String} OS_UNKNOWN
   * @readOnly
   */

  sys.OS_UNKNOWN = "Unknown";
  /**
   * @property {Number} UNKNOWN
   * @readOnly
   * @default -1
   */

  sys.UNKNOWN = -1;
  /**
   * @property {Number} WIN32
   * @readOnly
   * @default 0
   */

  sys.WIN32 = 0;
  /**
   * @property {Number} LINUX
   * @readOnly
   * @default 1
   */

  sys.LINUX = 1;
  /**
   * @property {Number} MACOS
   * @readOnly
   * @default 2
   */

  sys.MACOS = 2;
  /**
   * @property {Number} ANDROID
   * @readOnly
   * @default 3
   */

  sys.ANDROID = 3;
  /**
   * @property {Number} IPHONE
   * @readOnly
   * @default 4
   */

  sys.IPHONE = 4;
  /**
   * @property {Number} IPAD
   * @readOnly
   * @default 5
   */

  sys.IPAD = 5;
  /**
   * @property {Number} BLACKBERRY
   * @readOnly
   * @default 6
   */

  sys.BLACKBERRY = 6;
  /**
   * @property {Number} NACL
   * @readOnly
   * @default 7
   */

  sys.NACL = 7;
  /**
   * @property {Number} EMSCRIPTEN
   * @readOnly
   * @default 8
   */

  sys.EMSCRIPTEN = 8;
  /**
   * @property {Number} TIZEN
   * @readOnly
   * @default 9
   */

  sys.TIZEN = 9;
  /**
   * @property {Number} WINRT
   * @readOnly
   * @default 10
   */

  sys.WINRT = 10;
  /**
   * @property {Number} WP8
   * @readOnly
   * @default 11
   */

  sys.WP8 = 11;
  /**
   * @property {Number} MOBILE_BROWSER
   * @readOnly
   * @default 100
   */

  sys.MOBILE_BROWSER = 100;
  /**
   * @property {Number} DESKTOP_BROWSER
   * @readOnly
   * @default 101
   */

  sys.DESKTOP_BROWSER = 101;
  /**
   * Indicates whether executes in editor's window process (Electron's renderer context)
   * @property {Number} EDITOR_PAGE
   * @readOnly
   * @default 102
   */

  sys.EDITOR_PAGE = 102;
  /**
   * Indicates whether executes in editor's main process (Electron's browser context)
   * @property {Number} EDITOR_CORE
   * @readOnly
   * @default 103
   */

  sys.EDITOR_CORE = 103;
  /**
   * @property {Number} WECHAT_GAME
   * @readOnly
   * @default 104
   */

  sys.WECHAT_GAME = 104;
  /**
   * @property {Number} QQ_PLAY
   * @readOnly
   * @default 105
   */

  sys.QQ_PLAY = 105;
  /**
   * @property {Number} FB_PLAYABLE_ADS
   * @readOnly
   * @default 106
   */

  sys.FB_PLAYABLE_ADS = 106;
  /**
   * @property {Number} BAIDU_GAME
   * @readOnly
   * @default 107
   */

  sys.BAIDU_GAME = 107;
  /**
   * @property {Number} VIVO_GAME
   * @readOnly
   * @default 108
   */

  sys.VIVO_GAME = 108;
  /**
   * @property {Number} OPPO_GAME
   * @readOnly
   * @default 109
   */

  sys.OPPO_GAME = 109;
  /**
   * @property {Number} HUAWEI_GAME
   * @readOnly
   * @default 110
   */

  sys.HUAWEI_GAME = 110;
  /**
   * @property {Number} XIAOMI_GAME
   * @readOnly
   * @default 111
   */

  sys.XIAOMI_GAME = 111;
  /**
   * @property {Number} JKW_GAME
   * @readOnly
   * @default 112
   */

  sys.JKW_GAME = 112;
  /**
   * @property {Number} ALIPAY_GAME
   * @readOnly
   * @default 113
   */

  sys.ALIPAY_GAME = 113;
  /**
   * @property {Number} WECHAT_GAME_SUB
   * @readOnly
   * @default 114
   */

  sys.WECHAT_GAME_SUB = 114;
  /**
   * @property {Number} BAIDU_GAME_SUB
   * @readOnly
   * @default 115
   */

  sys.BAIDU_GAME_SUB = 115;
  /**
   * @property {Number} QTT_GAME
   * @readOnly
   * @default 116
   */

  sys.QTT_GAME = 116;
  /**
   * BROWSER_TYPE_WECHAT
   * @property {String} BROWSER_TYPE_WECHAT
   * @readOnly
   * @default "wechat"
   */

  sys.BROWSER_TYPE_WECHAT = "wechat";
  /**
   * BROWSER_TYPE_WECHAT_GAME
   * @property {String} BROWSER_TYPE_WECHAT_GAME
   * @readOnly
   * @default "wechatgame"
   */

  sys.BROWSER_TYPE_WECHAT_GAME = "wechatgame";
  /**
   * BROWSER_TYPE_WECHAT_GAME_SUB
   * @property {String} BROWSER_TYPE_WECHAT_GAME_SUB
   * @readOnly
   * @default "wechatgamesub"
   */

  sys.BROWSER_TYPE_WECHAT_GAME_SUB = "wechatgamesub";
  /**
   * BROWSER_TYPE_BAIDU_GAME
   * @property {String} BROWSER_TYPE_BAIDU_GAME
   * @readOnly
   * @default "baidugame"
   */

  sys.BROWSER_TYPE_BAIDU_GAME = "baidugame";
  /**
   * BROWSER_TYPE_BAIDU_GAME_SUB
   * @property {String} BROWSER_TYPE_BAIDU_GAME_SUB
   * @readOnly
   * @default "baidugamesub"
   */

  sys.BROWSER_TYPE_BAIDU_GAME_SUB = "baidugamesub";
  /**
   * BROWSER_TYPE_XIAOMI_GAME
   * @property {String} BROWSER_TYPE_XIAOMI_GAME
   * @readOnly
   * @default "xiaomigame"
   */

  sys.BROWSER_TYPE_XIAOMI_GAME = "xiaomigame";
  /**
   * BROWSER_TYPE_ALIPAY_GAME
   * @property {String} BROWSER_TYPE_ALIPAY_GAME
   * @readOnly
   * @default "alipaygame"
   */

  sys.BROWSER_TYPE_ALIPAY_GAME = "alipaygame";
  /**
   * BROWSER_TYPE_QQ_PLAY
   * @property {String} BROWSER_TYPE_QQ_PLAY
   * @readOnly
   * @default "qqplay"
   */

  sys.BROWSER_TYPE_QQ_PLAY = "qqplay";
  /**
   *
   * @property {String} BROWSER_TYPE_ANDROID
   * @readOnly
   * @default "androidbrowser"
   */

  sys.BROWSER_TYPE_ANDROID = "androidbrowser";
  /**
   *
   * @property {String} BROWSER_TYPE_IE
   * @readOnly
   * @default "ie"
   */

  sys.BROWSER_TYPE_IE = "ie";
  /**
   *
   * @property {String} BROWSER_TYPE_EDGE
   * @readOnly
   * @default "edge"
   */

  sys.BROWSER_TYPE_EDGE = "edge";
  /**
   *
   * @property {String} BROWSER_TYPE_QQ
   * @readOnly
   * @default "qqbrowser"
   */

  sys.BROWSER_TYPE_QQ = "qqbrowser";
  /**
   *
   * @property {String} BROWSER_TYPE_MOBILE_QQ
   * @readOnly
   * @default "mqqbrowser"
   */

  sys.BROWSER_TYPE_MOBILE_QQ = "mqqbrowser";
  /**
   *
   * @property {String} BROWSER_TYPE_UC
   * @readOnly
   * @default "ucbrowser"
   */

  sys.BROWSER_TYPE_UC = "ucbrowser";
  /**
   * uc third party integration.
   * @property {String} BROWSER_TYPE_UCBS
   * @readOnly
   * @default "ucbs"
   */

  sys.BROWSER_TYPE_UCBS = "ucbs";
  /**
   *
   * @property {String} BROWSER_TYPE_360
   * @readOnly
   * @default "360browser"
   */

  sys.BROWSER_TYPE_360 = "360browser";
  /**
   *
   * @property {String} BROWSER_TYPE_BAIDU_APP
   * @readOnly
   * @default "baiduboxapp"
   */

  sys.BROWSER_TYPE_BAIDU_APP = "baiduboxapp";
  /**
   *
   * @property {String} BROWSER_TYPE_BAIDU
   * @readOnly
   * @default "baidubrowser"
   */

  sys.BROWSER_TYPE_BAIDU = "baidubrowser";
  /**
   *
   * @property {String} BROWSER_TYPE_MAXTHON
   * @readOnly
   * @default "maxthon"
   */

  sys.BROWSER_TYPE_MAXTHON = "maxthon";
  /**
   *
   * @property {String} BROWSER_TYPE_OPERA
   * @readOnly
   * @default "opera"
   */

  sys.BROWSER_TYPE_OPERA = "opera";
  /**
   *
   * @property {String} BROWSER_TYPE_OUPENG
   * @readOnly
   * @default "oupeng"
   */

  sys.BROWSER_TYPE_OUPENG = "oupeng";
  /**
   *
   * @property {String} BROWSER_TYPE_MIUI
   * @readOnly
   * @default "miuibrowser"
   */

  sys.BROWSER_TYPE_MIUI = "miuibrowser";
  /**
   *
   * @property {String} BROWSER_TYPE_FIREFOX
   * @readOnly
   * @default "firefox"
   */

  sys.BROWSER_TYPE_FIREFOX = "firefox";
  /**
   *
   * @property {String} BROWSER_TYPE_SAFARI
   * @readOnly
   * @default "safari"
   */

  sys.BROWSER_TYPE_SAFARI = "safari";
  /**
   *
   * @property {String} BROWSER_TYPE_CHROME
   * @readOnly
   * @default "chrome"
   */

  sys.BROWSER_TYPE_CHROME = "chrome";
  /**
   *
   * @property {String} BROWSER_TYPE_LIEBAO
   * @readOnly
   * @default "liebao"
   */

  sys.BROWSER_TYPE_LIEBAO = "liebao";
  /**
   *
   * @property {String} BROWSER_TYPE_QZONE
   * @readOnly
   * @default "qzone"
   */

  sys.BROWSER_TYPE_QZONE = "qzone";
  /**
   *
   * @property {String} BROWSER_TYPE_SOUGOU
   * @readOnly
   * @default "sogou"
   */

  sys.BROWSER_TYPE_SOUGOU = "sogou";
  /**
   *
   * @property {String} BROWSER_TYPE_UNKNOWN
   * @readOnly
   * @default "unknown"
   */

  sys.BROWSER_TYPE_UNKNOWN = "unknown";
  /**
   * Is native ? This is set to be true in jsb auto.
   * @property {Boolean} isNative
   */

  sys.isNative = CC_JSB || CC_RUNTIME;
  /**
   * Is web browser ?
   * @property {Boolean} isBrowser
   */

  sys.isBrowser = typeof window === 'object' && typeof document === 'object' && !CC_JSB && !CC_RUNTIME;
  /**
   * Is webgl extension support?
   * @method glExtension
   * @param name
   */

  sys.glExtension = function (name) {
    return !!cc.renderer.device.ext(name);
  };
  /**
   * Get max joint matrix size for skinned mesh renderer.
   * @method getMaxJointMatrixSize
   */


  sys.getMaxJointMatrixSize = function () {
    if (!sys._maxJointMatrixSize) {
      var JOINT_MATRICES_SIZE = 50;
      var LEFT_UNIFORM_SIZE = 10;
      var gl = cc.game._renderContext;
      var maxUniforms = Math.floor(gl.getParameter(gl.MAX_VERTEX_UNIFORM_VECTORS) / 4) - LEFT_UNIFORM_SIZE;

      if (maxUniforms < JOINT_MATRICES_SIZE) {
        sys._maxJointMatrixSize = 0;
      } else {
        sys._maxJointMatrixSize = JOINT_MATRICES_SIZE;
      }
    }

    return sys._maxJointMatrixSize;
  };

  if (_global.__globalAdapter && _global.__globalAdapter.adaptSys) {
    // init sys info in adapter
    _global.__globalAdapter.adaptSys(sys);
  } else if (CC_EDITOR && Editor.isMainProcess) {
    sys.isMobile = false;
    sys.platform = sys.EDITOR_CORE;
    sys.language = sys.LANGUAGE_UNKNOWN;
    sys.languageCode = undefined;
    sys.os = {
      darwin: sys.OS_OSX,
      win32: sys.OS_WINDOWS,
      linux: sys.OS_LINUX
    }[process.platform] || sys.OS_UNKNOWN;
    sys.browserType = null;
    sys.browserVersion = null;
    sys.windowPixelResolution = {
      width: 0,
      height: 0
    };
    sys.__audioSupport = {};
  } else if (CC_JSB || CC_RUNTIME) {
    var platform;

    if (isVivoGame) {
      platform = sys.VIVO_GAME;
    } else if (isOppoGame) {
      platform = sys.OPPO_GAME;
    } else if (isHuaweiGame) {
      platform = sys.HUAWEI_GAME;
    } else if (isJKWGame) {
      platform = sys.JKW_GAME;
    } else if (isQttGame) {
      platform = sys.QTT_GAME;
    } else {
      platform = __getPlatform();
    }

    sys.platform = platform;
    sys.isMobile = platform === sys.ANDROID || platform === sys.IPAD || platform === sys.IPHONE || platform === sys.WP8 || platform === sys.TIZEN || platform === sys.BLACKBERRY || platform === sys.XIAOMI_GAME || isVivoGame || isOppoGame || isHuaweiGame || isJKWGame || isQttGame;
    sys.os = __getOS();
    sys.language = __getCurrentLanguage();
    var languageCode;

    if (CC_JSB) {
      languageCode = __getCurrentLanguageCode();
    }

    sys.languageCode = languageCode ? languageCode.toLowerCase() : undefined;
    sys.osVersion = __getOSVersion();
    sys.osMainVersion = parseInt(sys.osVersion);
    sys.browserType = null;
    sys.browserVersion = null;
    var w = window.innerWidth;
    var h = window.innerHeight;
    var ratio = window.devicePixelRatio || 1;
    sys.windowPixelResolution = {
      width: ratio * w,
      height: ratio * h
    };
    sys.localStorage = window.localStorage;
    var capabilities;
    capabilities = sys.capabilities = {
      "canvas": false,
      "opengl": true,
      "webp": true
    };

    if (sys.isMobile) {
      capabilities["accelerometer"] = true;
      capabilities["touches"] = true;
    } else {
      // desktop
      capabilities["keyboard"] = true;
      capabilities["mouse"] = true;
      capabilities["touches"] = false;
    }

    sys.__audioSupport = {
      ONLY_ONE: false,
      WEB_AUDIO: false,
      DELAY_CREATE_CTX: false,
      format: ['.mp3']
    };
  } else {
    // browser or runtime
    var win = window,
        nav = win.navigator,
        doc = document,
        docEle = doc.documentElement;
    var ua = nav.userAgent.toLowerCase();

    if (CC_EDITOR) {
      sys.isMobile = false;
      sys.platform = sys.EDITOR_PAGE;
    } else {
      /**
       * Indicate whether system is mobile system
       * @property {Boolean} isMobile
       */
      sys.isMobile = /mobile|android|iphone|ipad/.test(ua);
      /**
       * Indicate the running platform
       * @property {Number} platform
       */

      if (typeof FbPlayableAd !== "undefined") {
        sys.platform = sys.FB_PLAYABLE_ADS;
      } else {
        sys.platform = sys.isMobile ? sys.MOBILE_BROWSER : sys.DESKTOP_BROWSER;
      }
    }

    var currLanguage = nav.language;
    currLanguage = currLanguage ? currLanguage : nav.browserLanguage;
    /**
     * Get current language iso 639-1 code.
     * Examples of valid language codes include "zh-tw", "en", "en-us", "fr", "fr-fr", "es-es", etc.
     * The actual value totally depends on results provided by destination platform.
     * @property {String} languageCode
     */

    sys.languageCode = currLanguage.toLowerCase();
    currLanguage = currLanguage ? currLanguage.split("-")[0] : sys.LANGUAGE_ENGLISH;
    /**
     * Indicate the current language of the running system
     * @property {String} language
     */

    sys.language = currLanguage; // Get the os of system

    var isAndroid = false,
        iOS = false,
        osVersion = '',
        osMainVersion = 0;
    var uaResult = /android (\d+(?:\.\d+)*)/i.exec(ua) || /android (\d+(?:\.\d+)*)/i.exec(nav.platform);

    if (uaResult) {
      isAndroid = true;
      osVersion = uaResult[1] || '';
      osMainVersion = parseInt(osVersion) || 0;
    }

    uaResult = /(iPad|iPhone|iPod).*OS ((\d+_?){2,3})/i.exec(ua);

    if (uaResult) {
      iOS = true;
      osVersion = uaResult[2] || '';
      osMainVersion = parseInt(osVersion) || 0;
    } // refer to https://github.com/cocos-creator/engine/pull/5542 , thanks for contribition from @krapnikkk
    // ipad OS 13 safari identifies itself as "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15) AppleWebKit/605.1.15 (KHTML, like Gecko)" 
    // so use maxTouchPoints to check whether it's desktop safari or not. 
    // reference: https://stackoverflow.com/questions/58019463/how-to-detect-device-name-in-safari-on-ios-13-while-it-doesnt-show-the-correct
    // FIXME: should remove it when touch-enabled macs are available
    else if (/(iPhone|iPad|iPod)/.exec(nav.platform) || nav.platform === 'MacIntel' && nav.maxTouchPoints && nav.maxTouchPoints > 1) {
        iOS = true;
        osVersion = '';
        osMainVersion = 0;
      }

    var osName = sys.OS_UNKNOWN;
    if (nav.appVersion.indexOf("Win") !== -1) osName = sys.OS_WINDOWS;else if (iOS) osName = sys.OS_IOS;else if (nav.appVersion.indexOf("Mac") !== -1) osName = sys.OS_OSX;else if (nav.appVersion.indexOf("X11") !== -1 && nav.appVersion.indexOf("Linux") === -1) osName = sys.OS_UNIX;else if (isAndroid) osName = sys.OS_ANDROID;else if (nav.appVersion.indexOf("Linux") !== -1 || ua.indexOf("ubuntu") !== -1) osName = sys.OS_LINUX;
    /**
     * Indicate the running os name
     * @property {String} os
     */

    sys.os = osName;
    /**
     * Indicate the running os version
     * @property {String} osVersion
     */

    sys.osVersion = osVersion;
    /**
     * Indicate the running os main version
     * @property {Number} osMainVersion
     */

    sys.osMainVersion = osMainVersion;
    /**
     * Indicate the running browser type
     * @property {String} browserType
     */

    sys.browserType = sys.BROWSER_TYPE_UNKNOWN;
    /* Determine the browser type */

    (function () {
      var typeReg1 = /mqqbrowser|micromessenger|qqbrowser|sogou|qzone|liebao|maxthon|ucbs|360 aphone|360browser|baiduboxapp|baidubrowser|maxthon|mxbrowser|miuibrowser/i;
      var typeReg2 = /qq|ucbrowser|ubrowser|edge/i;
      var typeReg3 = /chrome|safari|firefox|trident|opera|opr\/|oupeng/i;
      var browserTypes = typeReg1.exec(ua) || typeReg2.exec(ua) || typeReg3.exec(ua);
      var browserType = browserTypes ? browserTypes[0].toLowerCase() : sys.BROWSER_TYPE_UNKNOWN;
      if (browserType === "safari" && isAndroid) browserType = sys.BROWSER_TYPE_ANDROID;else if (browserType === "qq" && ua.match(/android.*applewebkit/i)) browserType = sys.BROWSER_TYPE_ANDROID;
      var typeMap = {
        'micromessenger': sys.BROWSER_TYPE_WECHAT,
        'trident': sys.BROWSER_TYPE_IE,
        'edge': sys.BROWSER_TYPE_EDGE,
        '360 aphone': sys.BROWSER_TYPE_360,
        'mxbrowser': sys.BROWSER_TYPE_MAXTHON,
        'opr/': sys.BROWSER_TYPE_OPERA,
        'ubrowser': sys.BROWSER_TYPE_UC
      };
      sys.browserType = typeMap[browserType] || browserType;
    })();
    /**
     * Indicate the running browser version
     * @property {String} browserVersion
     */


    sys.browserVersion = "";
    /* Determine the browser version number */

    (function () {
      var versionReg1 = /(mqqbrowser|micromessenger|qqbrowser|sogou|qzone|liebao|maxthon|uc|ucbs|360 aphone|360|baiduboxapp|baidu|maxthon|mxbrowser|miui(?:.hybrid)?)(mobile)?(browser)?\/?([\d.]+)/i;
      var versionReg2 = /(qq|chrome|safari|firefox|trident|opera|opr\/|oupeng)(mobile)?(browser)?\/?([\d.]+)/i;
      var tmp = ua.match(versionReg1);
      if (!tmp) tmp = ua.match(versionReg2);
      sys.browserVersion = tmp ? tmp[4] : "";
    })();

    var w = window.innerWidth || document.documentElement.clientWidth;
    var h = window.innerHeight || document.documentElement.clientHeight;
    var ratio = window.devicePixelRatio || 1;
    /**
     * Indicate the real pixel resolution of the whole game window
     * @property {Size} windowPixelResolution
     */

    sys.windowPixelResolution = {
      width: ratio * w,
      height: ratio * h
    };

    sys._checkWebGLRenderMode = function () {
      if (cc.game.renderType !== cc.game.RENDER_TYPE_WEBGL) throw new Error("This feature supports WebGL render mode only.");
    };

    var _tmpCanvas1 = document.createElement("canvas");

    var create3DContext = function create3DContext(canvas, opt_attribs, opt_contextType) {
      if (opt_contextType) {
        try {
          return canvas.getContext(opt_contextType, opt_attribs);
        } catch (e) {
          return null;
        }
      } else {
        return create3DContext(canvas, opt_attribs, "webgl") || create3DContext(canvas, opt_attribs, "experimental-webgl") || create3DContext(canvas, opt_attribs, "webkit-3d") || create3DContext(canvas, opt_attribs, "moz-webgl") || null;
      }
    };
    /**
     * cc.sys.localStorage is a local storage component.
     * @property {Object} localStorage
     */


    try {
      var localStorage = sys.localStorage = win.localStorage;
      localStorage.setItem("storage", "");
      localStorage.removeItem("storage");
      localStorage = null;
    } catch (e) {
      var warn = function warn() {
        cc.warnID(5200);
      };

      sys.localStorage = {
        getItem: warn,
        setItem: warn,
        removeItem: warn,
        clear: warn
      };
    }

    var _supportWebp = _tmpCanvas1.toDataURL('image/webp').startsWith('data:image/webp');

    var _supportCanvas = !!_tmpCanvas1.getContext("2d");

    var _supportWebGL = false;

    if (CC_TEST) {
      _supportWebGL = false;
    } else if (win.WebGLRenderingContext) {
      _supportWebGL = true;
    }
    /**
     * The capabilities of the current platform
     * @property {Object} capabilities
     */


    var capabilities = sys.capabilities = {
      "canvas": _supportCanvas,
      "opengl": _supportWebGL,
      "webp": _supportWebp
    };
    if (docEle['ontouchstart'] !== undefined || doc['ontouchstart'] !== undefined || nav.msPointerEnabled) capabilities["touches"] = true;
    if (docEle['onmouseup'] !== undefined) capabilities["mouse"] = true;
    if (docEle['onkeyup'] !== undefined) capabilities["keyboard"] = true;
    if (win.DeviceMotionEvent || win.DeviceOrientationEvent) capabilities["accelerometer"] = true;

    var __audioSupport;
    /**
     * Audio support in the browser
     *
     * MULTI_CHANNEL        : Multiple audio while playing - If it doesn't, you can only play background music
     * WEB_AUDIO            : Support for WebAudio - Support W3C WebAudio standards, all of the audio can be played
     * AUTOPLAY             : Supports auto-play audio - if Don‘t support it, On a touch detecting background music canvas, and then replay
     * REPLAY_AFTER_TOUCH   : The first music will fail, must be replay after touchstart
     * USE_EMPTIED_EVENT    : Whether to use the emptied event to replace load callback
     * DELAY_CREATE_CTX     : delay created the context object - only webAudio
     * NEED_MANUAL_LOOP     : loop attribute failure, need to perform loop manually
     *
     * May be modifications for a few browser version
     */


    (function () {
      var DEBUG = false;
      var version = sys.browserVersion; // check if browser supports Web Audio
      // check Web Audio's context

      var supportWebAudio = !!(window.AudioContext || window.webkitAudioContext || window.mozAudioContext);
      __audioSupport = {
        ONLY_ONE: false,
        WEB_AUDIO: supportWebAudio,
        DELAY_CREATE_CTX: false
      };

      if (sys.os === sys.OS_IOS) {
        // IOS no event that used to parse completed callback
        // this time is not complete, can not play
        //
        __audioSupport.USE_LOADER_EVENT = 'loadedmetadata';
      }

      if (sys.browserType === sys.BROWSER_TYPE_FIREFOX) {
        __audioSupport.DELAY_CREATE_CTX = true;
        __audioSupport.USE_LOADER_EVENT = 'canplay';
      }

      if (sys.os === sys.OS_ANDROID) {
        if (sys.browserType === sys.BROWSER_TYPE_UC) {
          __audioSupport.ONE_SOURCE = true;
        }
      }

      if (DEBUG) {
        setTimeout(function () {
          cc.log('browse type: ' + sys.browserType);
          cc.log('browse version: ' + version);
          cc.log('MULTI_CHANNEL: ' + __audioSupport.MULTI_CHANNEL);
          cc.log('WEB_AUDIO: ' + __audioSupport.WEB_AUDIO);
          cc.log('AUTOPLAY: ' + __audioSupport.AUTOPLAY);
        }, 0);
      }
    })();

    try {
      if (__audioSupport.WEB_AUDIO) {
        __audioSupport.context = new (window.AudioContext || window.webkitAudioContext || window.mozAudioContext)();

        if (__audioSupport.DELAY_CREATE_CTX) {
          setTimeout(function () {
            __audioSupport.context = new (window.AudioContext || window.webkitAudioContext || window.mozAudioContext)();
          }, 0);
        }
      }
    } catch (error) {
      __audioSupport.WEB_AUDIO = false;
      cc.logID(5201);
    }

    var formatSupport = [];

    (function () {
      var audio = document.createElement('audio');

      if (audio.canPlayType) {
        var ogg = audio.canPlayType('audio/ogg; codecs="vorbis"');
        if (ogg) formatSupport.push('.ogg');
        var mp3 = audio.canPlayType('audio/mpeg');
        if (mp3) formatSupport.push('.mp3');
        var wav = audio.canPlayType('audio/wav; codecs="1"');
        if (wav) formatSupport.push('.wav');
        var mp4 = audio.canPlayType('audio/mp4');
        if (mp4) formatSupport.push('.mp4');
        var m4a = audio.canPlayType('audio/x-m4a');
        if (m4a) formatSupport.push('.m4a');
      }
    })();

    __audioSupport.format = formatSupport;
    sys.__audioSupport = __audioSupport;
  }
  /**
   * !#en
   * Network type enumeration
   * !#zh
   * 网络类型枚举
   *
   * @enum sys.NetworkType
   */


  sys.NetworkType = {
    /**
     * !#en
     * Network is unreachable.
     * !#zh
     * 网络不通
     *
     * @property {Number} NONE
     */
    NONE: 0,

    /**
     * !#en
     * Network is reachable via WiFi or cable.
     * !#zh
     * 通过无线或者有线本地网络连接因特网
     *
     * @property {Number} LAN
     */
    LAN: 1,

    /**
     * !#en
     * Network is reachable via Wireless Wide Area Network
     * !#zh
     * 通过蜂窝移动网络连接因特网
     *
     * @property {Number} WWAN
     */
    WWAN: 2
  };
  /**
   * @class sys
   */

  /**
   * !#en
   * Get the network type of current device, return cc.sys.NetworkType.LAN if failure.
   * !#zh
   * 获取当前设备的网络类型, 如果网络类型无法获取，默认将返回 cc.sys.NetworkType.LAN
   *
   * @method getNetworkType
   * @return {NetworkType}
   */

  sys.getNetworkType = function () {
    // TODO: need to implement this for mobile phones.
    return sys.NetworkType.LAN;
  };
  /**
   * !#en
   * Get the battery level of current device, return 1.0 if failure.
   * !#zh
   * 获取当前设备的电池电量，如果电量无法获取，默认将返回 1
   *
   * @method getBatteryLevel
   * @return {Number} - 0.0 ~ 1.0
   */


  sys.getBatteryLevel = function () {
    // TODO: need to implement this for mobile phones.
    return 1.0;
  };
  /**
   * Forces the garbage collection, only available in JSB
   * @method garbageCollect
   */


  sys.garbageCollect = function () {// N/A in web
  };
  /**
   * Restart the JS VM, only available in JSB
   * @method restartVM
   */


  sys.restartVM = function () {// N/A in web
  };
  /**
   * !#en
   * Return the safe area rect. <br/>
   * only available on the iOS native platform, otherwise it will return a rect with design resolution size.
   * !#zh
   * 返回手机屏幕安全区域，目前仅在 iOS 原生平台有效。其它平台将默认返回设计分辨率尺寸。
   * @method getSafeAreaRect
   * @return {Rect}
  */


  sys.getSafeAreaRect = function () {
    var visibleSize = cc.view.getVisibleSize();
    return cc.rect(0, 0, visibleSize.width, visibleSize.height);
  };
  /**
   * Check whether an object is valid,
   * In web engine, it will return true if the object exist
   * In native engine, it will return true if the JS object and the correspond native object are both valid
   * @method isObjectValid
   * @param {Object} obj
   * @return {Boolean} Validity of the object
   */


  sys.isObjectValid = function (obj) {
    if (obj) {
      return true;
    }

    return false;
  };
  /**
   * Dump system informations
   * @method dump
   */


  sys.dump = function () {
    var self = this;
    var str = "";
    str += "isMobile : " + self.isMobile + "\r\n";
    str += "language : " + self.language + "\r\n";
    str += "browserType : " + self.browserType + "\r\n";
    str += "browserVersion : " + self.browserVersion + "\r\n";
    str += "capabilities : " + JSON.stringify(self.capabilities) + "\r\n";
    str += "os : " + self.os + "\r\n";
    str += "osVersion : " + self.osVersion + "\r\n";
    str += "platform : " + self.platform + "\r\n";
    str += "Using " + (cc.game.renderType === cc.game.RENDER_TYPE_WEBGL ? "WEBGL" : "CANVAS") + " renderer." + "\r\n";
    cc.log(str);
  };
  /**
   * Open a url in browser
   * @method openURL
   * @param {String} url
   */


  sys.openURL = function (url) {
    if (CC_JSB || CC_RUNTIME) {
      jsb.openURL(url);
    } else {
      window.open(url);
    }
  };
  /**
   * Get the number of milliseconds elapsed since 1 January 1970 00:00:00 UTC.
   * @method now
   * @return {Number}
   */


  sys.now = function () {
    if (Date.now) {
      return Date.now();
    } else {
      return +new Date();
    }
  };

  return sys;
}

var sys = cc && cc.sys ? cc.sys : initSys();
module.exports = sys;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/platform/CCScreen.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2008-2010 Ricardo Quesada
 Copyright (c) 2011-2012 cocos2d-x.org
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.
 
 http://www.cocos2d-x.org
 
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

/**
 * The fullscreen API provides an easy way for web content to be presented using the user's entire screen.
 * It's invalid on safari, QQbrowser and android browser
 * @class screen
 */
cc.screen =
/** @lends cc.screen# */
{
  _supportsFullScreen: false,
  _onfullscreenchange: null,
  _onfullscreenerror: null,
  // the pre fullscreenchange function
  _preOnFullScreenChange: null,
  _preOnFullScreenError: null,
  _preOnTouch: null,
  _touchEvent: "",
  _fn: null,
  // Function mapping for cross browser support
  _fnMap: [['requestFullscreen', 'exitFullscreen', 'fullscreenchange', 'fullscreenEnabled', 'fullscreenElement', 'fullscreenerror'], ['requestFullScreen', 'exitFullScreen', 'fullScreenchange', 'fullScreenEnabled', 'fullScreenElement', 'fullscreenerror'], ['webkitRequestFullScreen', 'webkitCancelFullScreen', 'webkitfullscreenchange', 'webkitIsFullScreen', 'webkitCurrentFullScreenElement', 'webkitfullscreenerror'], ['mozRequestFullScreen', 'mozCancelFullScreen', 'mozfullscreenchange', 'mozFullScreen', 'mozFullScreenElement', 'mozfullscreenerror'], ['msRequestFullscreen', 'msExitFullscreen', 'MSFullscreenChange', 'msFullscreenEnabled', 'msFullscreenElement', 'msfullscreenerror']],

  /**
   * initialize
   * @method init
   */
  init: function init() {
    this._fn = {};
    var i,
        l,
        val,
        map = this._fnMap,
        valL;

    for (i = 0, l = map.length; i < l; i++) {
      val = map[i];

      if (val && typeof document[val[1]] !== 'undefined') {
        for (i = 0, valL = val.length; i < valL; i++) {
          this._fn[map[0][i]] = val[i];
        }

        break;
      }
    }

    this._supportsFullScreen = this._fn.requestFullscreen !== undefined; // Bug fix only for v2.1, don't merge into v2.0
    // In v2.0, screen touchend events conflict with editBox touchend events if it's not stayOnTop.
    // While in v2.1, editBox always keep stayOnTop and it doesn't support touchend events.

    this._touchEvent = 'ontouchend' in window ? 'touchend' : 'mousedown';
  },

  /**
   * return true if it's full now.
   * @method fullScreen
   * @returns {Boolean}
   */
  fullScreen: function fullScreen() {
    if (!this._supportsFullScreen) return false;else if (!document[this._fn.fullscreenElement] && !document[this._fn.webkitFullscreenElement] && !document[this._fn.mozFullScreenElement]) {
      return false;
    } else {
      return true;
    }
  },

  /**
   * change the screen to full mode.
   * @method requestFullScreen
   * @param {Element} element
   * @param {Function} onFullScreenChange
   * @param {Function} onFullScreenError
   */
  requestFullScreen: function requestFullScreen(element, onFullScreenChange, onFullScreenError) {
    if (element && element.tagName.toLowerCase() === "video") {
      if (cc.sys.os === cc.sys.OS_IOS && cc.sys.isBrowser && element.readyState > 0) {
        element.webkitEnterFullscreen && element.webkitEnterFullscreen();
        return;
      } else {
        element.setAttribute("x5-video-player-fullscreen", "true");
      }
    }

    if (!this._supportsFullScreen) {
      return;
    }

    element = element || document.documentElement;

    if (onFullScreenChange) {
      var eventName = this._fn.fullscreenchange;

      if (this._onfullscreenchange) {
        document.removeEventListener(eventName, this._onfullscreenchange);
      }

      this._onfullscreenchange = onFullScreenChange;
      document.addEventListener(eventName, onFullScreenChange, false);
    }

    if (onFullScreenError) {
      var _eventName = this._fn.fullscreenerror;

      if (this._onfullscreenerror) {
        document.removeEventListener(_eventName, this._onfullscreenerror);
      }

      this._onfullscreenerror = onFullScreenError;
      document.addEventListener(_eventName, onFullScreenError, {
        once: true
      });
    }

    element[this._fn.requestFullscreen]();
  },

  /**
   * exit the full mode.
   * @method exitFullScreen
   * @return {Boolean}
   */
  exitFullScreen: function exitFullScreen(element) {
    if (element && element.tagName.toLowerCase() === "video") {
      if (cc.sys.os === cc.sys.OS_IOS && cc.sys.isBrowser) {
        element.webkitExitFullscreen && element.webkitExitFullscreen();
        return;
      } else {
        element.setAttribute("x5-video-player-fullscreen", "false");
      }
    }

    return this._supportsFullScreen ? document[this._fn.exitFullscreen]() : true;
  },

  /**
   * Automatically request full screen with a touch/click event
   * @method autoFullScreen
   * @param {Element} element
   * @param {Function} onFullScreenChange
   */
  autoFullScreen: function autoFullScreen(element, onFullScreenChange) {
    element = element || document.body;

    this._ensureFullScreen(element, onFullScreenChange);

    this.requestFullScreen(element, onFullScreenChange);
  },
  disableAutoFullScreen: function disableAutoFullScreen(element) {
    var touchTarget = cc.game.canvas || element;
    var touchEventName = this._touchEvent;

    if (this._preOnTouch) {
      touchTarget.removeEventListener(touchEventName, this._preOnTouch);
      this._preOnTouch = null;
    }
  },
  // Register touch event if request full screen failed
  _ensureFullScreen: function _ensureFullScreen(element, onFullScreenChange) {
    var self = this;
    var touchTarget = cc.game.canvas || element;
    var fullScreenErrorEventName = this._fn.fullscreenerror;
    if (typeof document[fullScreenErrorEventName] === "undefined") return;
    var touchEventName = this._touchEvent;

    function onFullScreenError() {
      self._preOnFullScreenError = null; // handle touch event listener

      function onTouch() {
        self._preOnTouch = null;
        self.requestFullScreen(element, onFullScreenChange);
      }

      if (self._preOnTouch) {
        touchTarget.removeEventListener(touchEventName, self._preOnTouch);
      }

      self._preOnTouch = onTouch;
      touchTarget.addEventListener(touchEventName, self._preOnTouch, {
        once: true
      });
    } // handle full screen error


    if (this._preOnFullScreenError) {
      element.removeEventListener(fullScreenErrorEventName, this._preOnFullScreenError);
    }

    this._preOnFullScreenError = onFullScreenError;
    element.addEventListener(fullScreenErrorEventName, onFullScreenError, {
      once: true
    });
  }
};
cc.screen.init();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvY29jb3MyZC9jb3JlL3BsYXRmb3JtL0NDU2NyZWVuLmpzIl0sIm5hbWVzIjpbImNjIiwic2NyZWVuIiwiX3N1cHBvcnRzRnVsbFNjcmVlbiIsIl9vbmZ1bGxzY3JlZW5jaGFuZ2UiLCJfb25mdWxsc2NyZWVuZXJyb3IiLCJfcHJlT25GdWxsU2NyZWVuQ2hhbmdlIiwiX3ByZU9uRnVsbFNjcmVlbkVycm9yIiwiX3ByZU9uVG91Y2giLCJfdG91Y2hFdmVudCIsIl9mbiIsIl9mbk1hcCIsImluaXQiLCJpIiwibCIsInZhbCIsIm1hcCIsInZhbEwiLCJsZW5ndGgiLCJkb2N1bWV