/****************************************************************************
 Copyright (c) 2018 Xiamen Yaji Software Co., Ltd.
 
 http://www.cocos2d-x.org
 
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

#pragma once

#include "../../Macro.h"
#include "base/CCRef.h"
#include <stdint.h>

namespace se {
    class Object;
    class HandleObject;
}

RENDERER_BEGIN

class Effect;

class RenderData {
public:
    RenderData ();
    RenderData (const RenderData& o);
    virtual ~RenderData ();
    
    void setVertices (se::Object* jsVertices);
    void setIndices (se::Object* jsIndices);
    
    uint8_t* getVertices () const;
    uint8_t* getIndices () const;
    
    unsigned long getVBytes () { return _vBytes; }
    unsigned long getIBytes () { return _iBytes; }
    
    void clear();
    
private:
    unsigned long _vBytes = 0;
    unsigned long _iBytes = 0;
    uint8_t* _vertices = nullptr;
    uint8_t* _indices = nullptr;
    se::Object* _jsVertices = nullptr;
    se::Object* _jsIndices = nullptr;
};

RENDERER_END
