
class RTWebSocket extends window.WebSocket {
    constructor(wss, protocols, certificatePath) {
        do {
            if (typeof certificatePath !== 'string') {
                break;
            }
            if (qg.accessFile({ uri: "/" + certificatePath }) === "true") {
                break;
            }

            // tiny package
            if (typeof window.rtAdapter === "undefined" || typeof window.rtAdapter.REMOTE_SERVER_ROOT === "undefined") {
                break;
            }
            // small package
            let url = 'internal://files/' + certificatePath;
            if (qg.accessFile({ uri: url }) === "true") {
                certificatePath = url;
                break;
            }
            certificatePath = undefined;
            console.warn("use default certificate .certificatePath is not exist in: ", url);
        } while (0);
        super(wss, protocols, certificatePath);
    }
}
delete window.WebSocket;
window.WebSocket = RTWebSocket;
delete window.RTWebSocket;
