
class RTWebSocket extends window.WebSocket {
    constructor(wss, protocols, certificatePath) {
        do {
            if (typeof certificatePath !== 'string') {
                break;
            }

            //判断资源是否在包里。在包里则返回
            try {
                hbs.getFileSystemManager().accessSync(certificatePath);
                break;
            } catch (error) {

            }

            // tiny package
            if (typeof window.rtAdapter === "undefined" || typeof window.rtAdapter.REMOTE_SERVER_ROOT === "undefined") {
                break;
            }
            let cachedPath = rtAdapter.getCacheName(certificatePath);
            let url = rtAdapter.cacheDir + '/' + cachedPath;
            try {
                hbs.getFileSystemManager().accessSync(url);
            } catch (error) {
                console.warn("use default certificate .certificatePath is not exist in: ", url);
                certificatePath = undefined;
                break;
            }
            certificatePath = url;

        } while (0);
        super(wss, protocols, certificatePath);
    }
}
delete window.WebSocket;
window.WebSocket = RTWebSocket;
delete window.RTWebSocket;
