
const { exec } = require('child_process')
const fs = require('fs')
const path = require('path')
const debuglog = require('./debuglog')

/**
 * 启动mac平台的chrome
 */
function lookupChromeMac () {
  const lsregister = '/System/Library/Frameworks/CoreServices.framework/Versions/A/Frameworks/LaunchServices.framework/Versions/A/Support/lsregister'

  // sed命令嗅探在`path: Chrome`的段中的executable field的值，输出path和executable字段的值
  const sedCmd = `${lsregister} -dump | sed -n '/path:.*/{
    N
    /path:\\(.*\\)\\n.*Chrome$/s//\\1/g
    tz
    b
    :z
    h
    :x
    N
    /.*\\n.*executable:\\(.*\\)/s//\\1/g
    ty
    s/^$//g
    bx
    :y
    G
    p
  }'`

  return new Promise((resolve, reject) => {
    exec(sedCmd, (err, stdout, stderr) => {
      if (err) {
        debuglog(`lookupChromeMac(): 无法查找到chrome路径: ${err.message}`)
        reject(err)
      }

      const chromePath = _parseChromePathFromRegOutput(stdout, stderr)
      if (!chromePath) {
        reject(new Error(`Chrome路径解析出错: ${JSON.stringify(stdout)}, ${stderr}`))
      }

      resolve(chromePath)
    })
  }).catch(err => {
    return err
  })

  function _parseChromePathFromRegOutput (stdout, stderr) {
    const lines = stdout.replace(/\n$/, '')
      .split('\n').map(item => item.trim())

    debuglog(`_parseChromePathFromRegOutput(): ${JSON.stringify(lines)}`)
    for (let i=0; i<lines.length; i++) {
      if (i % 2 === 1) {
        const testPath = path.resolve(`${lines[i]}/${lines[i-1]}`)
        const testFileName = path.basename(testPath)
        if (fs.existsSync(testPath) && testFileName.toLowerCase().indexOf('google chrome') >= 0 ) {
          return testPath
        }
      }
    }
    return undefined 
  }
}

module.exports = lookupChromeMac
