
const { exec } = require('child_process')
const debuglog = require(`./debuglog`)

/**
 * 查找linux平台下的chrome binary
 */
function lookupChromeLinux () {
  return new Promise((resolve, reject) => {
    exec(`which google-chrome`, (err, stdout, stderr) => {
      if (err) {
        debuglog(`lookupChromeLinux(): 无法找到chrome路径： ${err.message}`)
        reject(err)
      }

      const chromePath = stdout.replace(/\n/g, '')
      return resolve(chromePath)
    })
  }).catch(err => {
    return err
  })
}

module.exports = lookupChromeLinux
