"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _koaRouter = _interopRequireDefault(require("koa-router"));

var _qrImage = _interopRequireDefault(require("qr-image"));

var _utils = require("../common/utils");

var router = (0, _koaRouter["default"])();
/**
 * @desc 适配老版本的应用加载器。
 * 使用老版本的应用加载器，会发送post到/, 并不会向/postwsid发请求；
 * 在新版本toolkit/老版本的应用加载器的组合下，用户将无法无法访问调试界面。因此提示用户更新应用加载器，并把请求转发至/postwsid;
 */

router.post('/',
/*#__PURE__*/
function () {
  var _ref = (0, _asyncToGenerator2["default"])(
  /*#__PURE__*/
  _regenerator["default"].mark(function _callee(ctx, next) {
    var body, method, path, isWs, isHybridLoader, ws, application, port, inspectorUrl;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.prev = 0;
            body = ctx.request.body;
            method = ctx.method, path = ctx.path;
            isWs = 'ws' in body && body.ws.indexOf('inspector') >= 0;
            isHybridLoader = 'application' in body && body.application.indexOf('hybrid.loader') >= 0;

            if (!(method.toLowerCase() === 'post' && path === '/' && isWs && isHybridLoader)) {
              _context.next = 15;
              break;
            }

            // 通知用户更新应用加载器版本
            _utils.colorconsole.warn('调试器已有重要更新，请更新调试器');

            (0, _utils.emitWSEvent)(ctx.io, 'informUpdate');
            ws = body.ws, application = body.application; // 生成调试url，并且向页面输出调试APP信息

            port = ctx.config.port;
            inspectorUrl = (0, _utils.getInspectorUrl)({
              ws: ws,
              port: port
            });
            (0, _utils.emitWSEvent)(ctx.io, 'appRegistered', {
              inspectorUrl: inspectorUrl,
              application: application
            });

            _utils.colorconsole.info("\u8BF7\u8BBF\u95EE\u4EE5\u4E0B\u94FE\u63A5\u8FDB\u884C\u8C03\u8BD5\uFF1A\n\n".concat(inspectorUrl, "\n"));

            _context.next = 17;
            break;

          case 15:
            _context.next = 17;
            return next();

          case 17:
            _context.next = 25;
            break;

          case 19:
            _context.prev = 19;
            _context.t0 = _context["catch"](0);

            _utils.colorconsole.error("### App Server ### \u51FA\u9519\u4FE1\u606F: ".concat(_context.t0.message));

            _utils.colorconsole.error('### App Server ### 当前调试器与toolkit不兼容，请更新调试器。');

            _context.next = 25;
            return next();

          case 25:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, null, [[0, 19]]);
  }));

  return function (_x, _x2) {
    return _ref.apply(this, arguments);
  };
}());
/**
 * 手机注册
 */

router.post('/postwsid',
/*#__PURE__*/
function () {
  var _ref2 = (0, _asyncToGenerator2["default"])(
  /*#__PURE__*/
  _regenerator["default"].mark(function _callee2(ctx, next) {
    var _ctx$request$body, ws, application, port, inspectorUrl;

    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _utils.colorconsole.info("### App Server ### \u6536\u5230App\u6CE8\u518C\u4FE1\u606F, \u683C\u5F0F:\n".concat(JSON.stringify(ctx.request.body), "\n"));

            _ctx$request$body = ctx.request.body, ws = _ctx$request$body.ws, application = _ctx$request$body.application; // 生成调试url，并且向页面输出调试APP信息

            port = ctx.config.port;
            inspectorUrl = (0, _utils.getInspectorUrl)({
              ws: ws,
              port: port
            });
            (0, _utils.emitWSEvent)(ctx.io, 'appRegistered', {
              inspectorUrl: inspectorUrl,
              application: application
            });

            _utils.colorconsole.info("\u8BF7\u8BBF\u95EE\u4EE5\u4E0B\u94FE\u63A5\u8FDB\u884C\u8C03\u8BD5\uFF1A\n\n".concat(inspectorUrl, "\n"));

            _context2.next = 8;
            return next();

          case 8:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));

  return function (_x3, _x4) {
    return _ref2.apply(this, arguments);
  };
}());
/**
 * 开始调试
 */

router.post('/poststdbg',
/*#__PURE__*/
function () {
  var _ref3 = (0, _asyncToGenerator2["default"])(
  /*#__PURE__*/
  _regenerator["default"].mark(function _callee3(ctx, next) {
    var params, sn, linkMode, devicePort, application, ws, _ref4, localWsPort, err, port, inspectorUrl;

    return _regenerator["default"].wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            params = (0, _utils.getDebugInfoFromRequest)(ctx.request);
            sn = params.sn, linkMode = params.linkMode, devicePort = params.devicePort, application = params.application;
            ws = params.ws; // ADB调试模式

            if (!(linkMode === _utils.LINK_MODE.ADB)) {
              _context3.next = 15;
              break;
            }

            _context3.next = 6;
            return ctx.adbDebugger.forwardForWsChannel(sn, devicePort);

          case 6:
            _ref4 = _context3.sent;
            localWsPort = _ref4.localWsPort;
            err = _ref4.err;

            if (!err) {
              _context3.next = 14;
              break;
            }

            _utils.colorconsole.error("startDebug(): adb forward \u7AEF\u53E3\u6620\u5C04\u5931\u8D25: ".concat(err.message));

            _context3.next = 13;
            return next();

          case 13:
            return _context3.abrupt("return");

          case 14:
            // ws中是手机的端口号，ADB模式下需要替换为forward对应的pc端口
            ws = ws.replace(devicePort, localWsPort);

          case 15:
            // 生成调试url，并且向页面输出调试APP信息
            port = ctx.config.port;
            inspectorUrl = (0, _utils.getInspectorUrl)({
              ws: ws,
              port: port
            });
            (0, _utils.emitWSEvent)(ctx.io, 'appRegistered', {
              inspectorUrl: inspectorUrl,
              application: application
            });

            _utils.colorconsole.info("\u8BF7\u8BBF\u95EE\u4EE5\u4E0B\u94FE\u63A5\u8FDB\u884C\u8C03\u8BD5\uFF1A\n\n".concat(inspectorUrl, "\n"));

            if (!(ctx.app.source === _utils.SOURCE.IDE)) {
              _context3.next = 23;
              break;
            }

            // 判断hapserver是否由ide启动
            process.send({
              url: inspectorUrl,
              type: 'openWin'
            });
            _context3.next = 25;
            break;

          case 23:
            _context3.next = 25;
            return (0, _utils.startChrome)(inspectorUrl);

          case 25:
            _context3.next = 27;
            return next();

          case 27:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  }));

  return function (_x5, _x6) {
    return _ref3.apply(this, arguments);
  };
}());
/**
 * 生成二维码
 */

router.get('/qrcode',
/*#__PURE__*/
function () {
  var _ref5 = (0, _asyncToGenerator2["default"])(
  /*#__PURE__*/
  _regenerator["default"].mark(function _callee4(ctx, next) {
    var port, qrText, image;
    return _regenerator["default"].wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            port = ctx.config.port;
            qrText = "http://".concat((0, _utils.getServerIPAndPort)(port));
            image = _qrImage["default"].image(qrText, {
              size: 9
            });
            ctx.type = 'image/png';
            ctx.body = image;
            _context4.next = 7;
            return next();

          case 7:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4);
  }));

  return function (_x7, _x8) {
    return _ref5.apply(this, arguments);
  };
}());
var _default = router;
exports["default"] = _default;