"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _fs = _interopRequireDefault(require("fs"));

var _path = _interopRequireDefault(require("path"));

var _koaRouter = _interopRequireDefault(require("koa-router"));

var _utils = require("../common/utils");

var router = (0, _koaRouter["default"])(); // 能使用rpks能力的调试器最低版本

var RPKS_SUPPORT_VERSION_FROM = 1040;
/**
 * 首页
 */

router.get('/',
/*#__PURE__*/
function () {
  var _ref = (0, _asyncToGenerator2["default"])(
  /*#__PURE__*/
  _regenerator["default"].mark(function _callee(ctx, next) {
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            ctx.response.redirect('/home/index.html');
            _context.next = 3;
            return next();

          case 3:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));

  return function (_x, _x2) {
    return _ref.apply(this, arguments);
  };
}()); // 下载rpk文件

router.get('/bundle',
/*#__PURE__*/
function () {
  var _ref2 = (0, _asyncToGenerator2["default"])(
  /*#__PURE__*/
  _regenerator["default"].mark(function _callee2(ctx, next) {
    var projectPath, projectName, projectDist, platformVersion, projectDistFilePath;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            projectPath = process.cwd();
            projectName = (0, _utils.getProjectName)();
            projectDist = _path["default"].join(projectPath, 'dist');
            platformVersion = ctx.request.query.platformVersion;

            if (platformVersion && platformVersion >= RPKS_SUPPORT_VERSION_FROM) {
              projectDistFilePath = getDistFilePath(projectDist, projectName, 'rpks');
            }

            if (!projectDistFilePath) {
              projectDistFilePath = getDistFilePath(projectDist, projectName, 'rpk');
            }

            if (projectDistFilePath) {
              ctx.body = _fs["default"].createReadStream(projectDistFilePath);
              ctx.set('Content-Type', 'application/octet-stream');
            } else {
              console.error("### App Server ### \u9879\u76EEdist\u76EE\u5F55\u4E0B\u4E0D\u5B58\u5728rpk\u6587\u4EF6\uFF1A".concat(projectDist));
              ctx["throw"]('404', '无法找到项目的rpk文件');
            }

            _context2.next = 9;
            return next();

          case 9:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));

  return function (_x3, _x4) {
    return _ref2.apply(this, arguments);
  };
}());
/**
 * 获取文件路径
 * @param projectDist
 * @param projectName
 * @param fileType
 * @returns {String}
 */

function getDistFilePath(projectDist, projectName, fileType) {
  var projectDistFilePath;
  projectDistFilePath = _path["default"].join(projectDist, "".concat(projectName, ".debug.").concat(fileType));

  if (_fs["default"].existsSync(projectDistFilePath)) {
    return projectDistFilePath;
  } else {
    projectDistFilePath = _path["default"].join(projectDist, "".concat(projectName, ".release.").concat(fileType));

    if (_fs["default"].existsSync(projectDistFilePath)) {
      return projectDistFilePath;
    }
  }
}

var _default = router;
exports["default"] = _default;