"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.record = record;

var _fs = _interopRequireDefault(require("fs"));

var _path = _interopRequireDefault(require("path"));

var _utils = require("../common/utils");

var CLIENT_PORT = 39517;
/**
 * 记录日志
 * @param {} ctx
 * @param {*} next
 */

function record(ctx, next) {
  //client.json的路径
  var clientPath = ctx.config.clientLogPath; // 清空调试设备记录

  var clearRecords = ctx.config.clearRecords;

  if (clearRecords) {
    if (_fs["default"].existsSync(clientPath)) {
      _fs["default"].unlinkSync(clientPath);

      _utils.colorconsole.info('### App Server ### 清空调试设备记录');
    }
  }

  var _getClientFromRequest = (0, _utils.getClientFromRequest)(ctx.request),
      sn = _getClientFromRequest.sn,
      clientIp = _getClientFromRequest.clientIp,
      linkMode = _getClientFromRequest.linkMode;

  var client = {
    sn: sn,
    ip: clientIp,
    port: CLIENT_PORT
  };

  switch (linkMode) {
    case _utils.LINK_MODE.WIFI:
      _utils.colorconsole.info("### App Server ### \u8BB0\u5F55\u4ECE".concat(clientIp, "\u8FDB\u5165\u7684HTTP\u8BF7\u6C42"));

      recordClient(clientPath, client);
      break;

    case _utils.LINK_MODE.ADB:
      // ADB模式下需要先读取连接时记录的信息
      client = getRecordClient(clientPath, sn, clientIp);

      if (client) {
        _utils.colorconsole.info("### App Server ### \u8BB0\u5F55\u4ECE\u8BBE\u5907(".concat(sn, ")\u8FDB\u5165\u7684HTTP\u8BF7\u6C42"));

        recordClient(clientPath, client);
      } else {
        _utils.colorconsole.warn("### App Server ### \uFF1A\u8BB0\u5F55\u8BBE\u5907(".concat(sn, ")\u5931\u8D25"));
      }

      break;
  }

  next();
}
/**
 * 记录地址
 * @param filePath {String}
 * @param newClient {sn, ip, port}
 *
 */


function recordClient(filePath, newClient) {
  // 目录存在
  var pathParentDir = _path["default"].dirname(filePath);

  var tmpJSONData = {
    clients: []
  };

  if (!_fs["default"].existsSync(pathParentDir)) {
    (0, _utils.mkdirsSync)(pathParentDir);
  } else if (_fs["default"].existsSync(filePath)) {
    tmpJSONData = JSON.parse(_fs["default"].readFileSync(filePath).toString());

    if (tmpJSONData.clients instanceof Array) {
      // 过滤相同的记录
      tmpJSONData.clients = tmpJSONData.clients.filter(function (client) {
        return client.ip !== newClient.ip || client.port !== newClient.port;
      }); // 保留最后的4条记录，最多记录5条

      while (tmpJSONData.clients.length > 4) {
        tmpJSONData.clients.shift();
      }
    }
  } // 写入文件


  tmpJSONData.clients.push(newClient);

  _fs["default"].writeFileSync(filePath, JSON.stringify(tmpJSONData));
}
/**
 * 根据设备sn和ip获取设备的记录
 * @param filePath
 * @param sn
 * @param ip
 * @returns {null}
 */


function getRecordClient(filePath, sn, ip) {
  if (_fs["default"].existsSync(filePath)) {
    var _JSON$parse = JSON.parse(_fs["default"].readFileSync(filePath).toString()),
        clients = _JSON$parse.clients;

    clients = clients instanceof Array ? clients : [];
    return clients.find(function (client) {
      return client.sn === sn && client.ip === ip && client.port;
    });
  }
}