"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _http = _interopRequireDefault(require("http"));

var _config = _interopRequireDefault(require("./config"));

var _app = _interopRequireDefault(require("./app"));

var _utils = require("./common/utils");

/**
 * Copyright (C) 2017, hapjs.org. All rights reserved.
 */
// https://koajs.com/#async-functions-with-babel
// https://babeljs.io/docs/en/babel-register/#ignores-node-modules-by-default
var digits = process.versions.node.split('.'); // '01' => 1

digits = digits.map(function (num) {
  return parseInt(num, 10);
});

var _digits = digits,
    _digits2 = (0, _slicedToArray2["default"])(_digits, 2),
    major = _digits2[0],
    minor = _digits2[1];

var supportAsyncAwait = major > 7 || major === 7 && minor >= 6;

if (!supportAsyncAwait) {
  require('@babel/register')({
    only: [/\bkoa-?/]
  });
}

function start(_x, _x2) {
  return _start.apply(this, arguments);
}
/**
 * 启动开发服务
 *
 * @param {Object} options - 参数配置项
 * @param {String|Number} [options.port] - 服务端口
 */


function _start() {
  _start = (0, _asyncToGenerator2["default"])(
  /*#__PURE__*/
  _regenerator["default"].mark(function _callee(app, config) {
    var server, port;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            app.context.config = config;
            server = _http["default"].createServer(app.callback());
            port = config.port; // 容错端口、请求地址
            // port = await getPort(port)

            server.listen(port, function () {
              (0, _utils.generateQrcode)(port);
            });
            server.on('error', function (err) {
              _utils.colorconsole.error("### App Server ### \u670D\u52A1\u5668\u9519\u8BEF: ".concat(err.message));

              if (err.code === 'EADDRINUSE') {
                _utils.colorconsole.error("### App Server ### \u670D\u52A1\u5668\u9519\u8BEF:\u7AEF\u53E3 ".concat(port, " \u88AB\u5360\u7528, \u8BF7\u68C0\u67E5"));
              }
            });
            process.on('SIGINT', function () {
              _utils.colorconsole.info('### App Server ### SIGINT信号');

              _utils.colorconsole.info("### App Server ### \u9000\u51FAserver\u8FDB\u7A0B pid: ".concat(process.pid));

              process.exit();
            });
            process.on('uncaughtException', function (err) {
              _utils.colorconsole.error("### App Server ### \u672A\u5B9A\u4E49\u7684\u5F02\u5E38, \u51FA\u9519\u4FE1\u606F: ".concat(err.message));
            });
            process.on('message', function (data) {
              if (data && data.source) {
                // 判断server是否来自于ide
                app.source = data.source;
              }
            });

          case 8:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _start.apply(this, arguments);
}

module.exports = function launch(options) {
  if (options.port || options.clientLogPath) {
    Object.assign(_config["default"], {
      port: options.port,
      clientLogPath: options.clientLogPath
    });
  } // 启动服务器


  start(_app["default"], _config["default"]);
};