"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSocketServer = createSocketServer;

var _socket = _interopRequireDefault(require("socket.io"));

var _utils = require("./utils");

/**
 * Copyright (C) 2017, hapjs.org. All rights reserved.
 */
function createSocketServer(server, app) {
  var io = (0, _socket["default"])(server); // 暂时绑定io

  app.context.io = io;
  io.on('connection', function (socket) {
    io.on('error', function (err) {
      _utils.colorconsole.error("### App Socket Server ### websocket server\u53D1\u751F\u9519\u8BEF: ".concat(err.message));
    });

    _utils.colorconsole.info("### App Socket Server ### websocket\u7528\u6237(".concat((0, _utils.stripPrefixForIPV4MappedIPV6Address)(socket.conn.remoteAddress), ")\u8FDE\u5165\u5230websocket server"));

    socket.on('disconnect', function () {
      _utils.colorconsole.info('### App Socket Server ### websocket client与websocket server断开');

      io.emit('user disconnected');
    });
  });
}